/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheMetrics;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEvictionManager;
import org.apache.ignite.internal.processors.cache.store.GridCacheWriteBehindStore;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;

public class CacheMetricsImpl
implements CacheMetrics {
    private static final long NANOS_IN_MICROSECOND = 1000L;
    private AtomicLong reads = new AtomicLong();
    private AtomicLong writes = new AtomicLong();
    private AtomicLong hits = new AtomicLong();
    private AtomicLong misses = new AtomicLong();
    private AtomicLong txCommits = new AtomicLong();
    private AtomicLong txRollbacks = new AtomicLong();
    private AtomicLong evictCnt = new AtomicLong();
    private AtomicLong rmCnt = new AtomicLong();
    private AtomicLong putTimeNanos = new AtomicLong();
    private AtomicLong getTimeNanos = new AtomicLong();
    private AtomicLong rmvTimeNanos = new AtomicLong();
    private AtomicLong commitTimeNanos = new AtomicLong();
    private AtomicLong rollbackTimeNanos = new AtomicLong();
    private AtomicLong offHeapGets = new AtomicLong();
    private AtomicLong offHeapPuts = new AtomicLong();
    private AtomicLong offHeapRemoves = new AtomicLong();
    private AtomicLong offHeapEvicts = new AtomicLong();
    private AtomicLong offHeapHits = new AtomicLong();
    private AtomicLong offHeapMisses = new AtomicLong();
    private AtomicLong swapGets = new AtomicLong();
    private AtomicLong swapPuts = new AtomicLong();
    private AtomicLong swapRemoves = new AtomicLong();
    private AtomicLong swapHits = new AtomicLong();
    private AtomicLong swapMisses = new AtomicLong();
    @GridToStringExclude
    private transient CacheMetricsImpl delegate;
    private GridCacheContext<?, ?> cctx;
    private GridCacheContext<?, ?> dhtCtx;
    private GridCacheWriteBehindStore store;

    public CacheMetricsImpl(GridCacheContext<?, ?> cctx) {
        assert (cctx != null);
        this.cctx = cctx;
        if (cctx.isNear()) {
            this.dhtCtx = cctx.near().dht().context();
        }
        if (cctx.store().store() instanceof GridCacheWriteBehindStore) {
            this.store = (GridCacheWriteBehindStore)cctx.store().store();
        }
        this.delegate = null;
    }

    public void delegate(CacheMetricsImpl delegate) {
        this.delegate = delegate;
    }

    @Override
    public String name() {
        return this.cctx.name();
    }

    @Override
    public long getOverflowSize() {
        try {
            GridCacheAdapter<?, ?> cache = this.cctx.cache();
            return cache != null ? cache.overflowSize() : -1L;
        }
        catch (IgniteCheckedException ignored) {
            return -1L;
        }
    }

    @Override
    public long getOffHeapGets() {
        return this.offHeapGets.get();
    }

    @Override
    public long getOffHeapPuts() {
        return this.offHeapPuts.get();
    }

    @Override
    public long getOffHeapRemovals() {
        return this.offHeapRemoves.get();
    }

    @Override
    public long getOffHeapEvictions() {
        return this.offHeapEvicts.get();
    }

    @Override
    public long getOffHeapHits() {
        return this.offHeapHits.get();
    }

    @Override
    public float getOffHeapHitPercentage() {
        long hits0 = this.offHeapHits.get();
        long gets0 = this.offHeapGets.get();
        if (hits0 == 0L) {
            return 0.0f;
        }
        return (float)hits0 / (float)gets0 * 100.0f;
    }

    @Override
    public long getOffHeapMisses() {
        return this.offHeapMisses.get();
    }

    @Override
    public float getOffHeapMissPercentage() {
        long misses0 = this.offHeapMisses.get();
        long reads0 = this.offHeapGets.get();
        if (misses0 == 0L) {
            return 0.0f;
        }
        return (float)misses0 / (float)reads0 * 100.0f;
    }

    @Override
    public long getOffHeapEntriesCount() {
        GridCacheAdapter<?, ?> cache = this.cctx.cache();
        return cache != null ? cache.offHeapEntriesCount() : -1L;
    }

    @Override
    public long getOffHeapPrimaryEntriesCount() {
        try {
            return this.cctx.swap().offheapEntriesCount(true, false, this.cctx.affinity().affinityTopologyVersion());
        }
        catch (IgniteCheckedException ignored) {
            return 0L;
        }
    }

    @Override
    public long getOffHeapBackupEntriesCount() {
        try {
            return this.cctx.swap().offheapEntriesCount(false, true, this.cctx.affinity().affinityTopologyVersion());
        }
        catch (IgniteCheckedException ignored) {
            return 0L;
        }
    }

    @Override
    public long getOffHeapAllocatedSize() {
        GridCacheAdapter<?, ?> cache = this.cctx.cache();
        return cache != null ? cache.offHeapAllocatedSize() : -1L;
    }

    @Override
    public long getOffHeapMaxSize() {
        return this.cctx.config().getOffHeapMaxMemory();
    }

    @Override
    public long getSwapGets() {
        return this.swapGets.get();
    }

    @Override
    public long getSwapPuts() {
        return this.swapPuts.get();
    }

    @Override
    public long getSwapRemovals() {
        return this.swapRemoves.get();
    }

    @Override
    public long getSwapHits() {
        return this.swapHits.get();
    }

    @Override
    public long getSwapMisses() {
        return this.swapMisses.get();
    }

    @Override
    public long getSwapEntriesCount() {
        try {
            return this.cctx.cache().swapKeys();
        }
        catch (IgniteCheckedException ignored) {
            return 0L;
        }
    }

    @Override
    public long getSwapSize() {
        try {
            return this.cctx.cache().swapSize();
        }
        catch (IgniteCheckedException ignored) {
            return 0L;
        }
    }

    @Override
    public float getSwapHitPercentage() {
        long hits0 = this.swapHits.get();
        long gets0 = this.swapGets.get();
        if (hits0 == 0L) {
            return 0.0f;
        }
        return (float)hits0 / (float)gets0 * 100.0f;
    }

    @Override
    public float getSwapMissPercentage() {
        long misses0 = this.swapMisses.get();
        long reads0 = this.swapGets.get();
        if (misses0 == 0L) {
            return 0.0f;
        }
        return (float)misses0 / (float)reads0 * 100.0f;
    }

    @Override
    public int getSize() {
        GridCacheAdapter<?, ?> cache = this.cctx.cache();
        return cache != null ? cache.size() : 0;
    }

    @Override
    public int getKeySize() {
        return this.getSize();
    }

    @Override
    public boolean isEmpty() {
        GridCacheAdapter<?, ?> cache = this.cctx.cache();
        return cache == null || cache.isEmpty();
    }

    @Override
    public int getDhtEvictQueueCurrentSize() {
        GridCacheContext<?, ?> ctx;
        GridCacheContext<?, ?> gridCacheContext = ctx = this.cctx.isNear() ? this.dhtCtx : this.cctx;
        if (ctx == null) {
            return -1;
        }
        GridCacheEvictionManager evictMgr = ctx.evicts();
        return evictMgr != null ? evictMgr.evictQueueSize() : -1;
    }

    @Override
    public int getTxCommitQueueSize() {
        return 0;
    }

    @Override
    public int getTxThreadMapSize() {
        return this.cctx.tm().threadMapSize();
    }

    @Override
    public int getTxXidMapSize() {
        return this.cctx.tm().idMapSize();
    }

    @Override
    public int getTxPrepareQueueSize() {
        return 0;
    }

    @Override
    public int getTxStartVersionCountsSize() {
        return 0;
    }

    @Override
    public int getTxCommittedVersionsSize() {
        return this.cctx.tm().completedVersionsSize();
    }

    @Override
    public int getTxRolledbackVersionsSize() {
        return this.cctx.tm().completedVersionsSize();
    }

    @Override
    public int getTxDhtThreadMapSize() {
        return this.cctx.isNear() && this.dhtCtx != null ? this.dhtCtx.tm().threadMapSize() : -1;
    }

    @Override
    public int getTxDhtXidMapSize() {
        return this.cctx.isNear() && this.dhtCtx != null ? this.dhtCtx.tm().idMapSize() : -1;
    }

    @Override
    public int getTxDhtCommitQueueSize() {
        return 0;
    }

    @Override
    public int getTxDhtPrepareQueueSize() {
        return 0;
    }

    @Override
    public int getTxDhtStartVersionCountsSize() {
        return 0;
    }

    @Override
    public int getTxDhtCommittedVersionsSize() {
        return this.cctx.isNear() && this.dhtCtx != null ? this.dhtCtx.tm().completedVersionsSize() : -1;
    }

    @Override
    public int getTxDhtRolledbackVersionsSize() {
        return this.cctx.isNear() && this.dhtCtx != null ? this.dhtCtx.tm().completedVersionsSize() : -1;
    }

    @Override
    public boolean isWriteBehindEnabled() {
        return this.store != null;
    }

    @Override
    public int getWriteBehindFlushSize() {
        return this.store != null ? this.store.getWriteBehindFlushSize() : -1;
    }

    @Override
    public int getWriteBehindFlushThreadCount() {
        return this.store != null ? this.store.getWriteBehindFlushThreadCount() : -1;
    }

    @Override
    public long getWriteBehindFlushFrequency() {
        return this.store != null ? this.store.getWriteBehindFlushFrequency() : -1L;
    }

    @Override
    public int getWriteBehindStoreBatchSize() {
        return this.store != null ? this.store.getWriteBehindStoreBatchSize() : -1;
    }

    @Override
    public int getWriteBehindTotalCriticalOverflowCount() {
        return this.store != null ? this.store.getWriteBehindTotalCriticalOverflowCount() : -1;
    }

    @Override
    public int getWriteBehindCriticalOverflowCount() {
        return this.store != null ? this.store.getWriteBehindCriticalOverflowCount() : -1;
    }

    @Override
    public int getWriteBehindErrorRetryCount() {
        return this.store != null ? this.store.getWriteBehindErrorRetryCount() : -1;
    }

    @Override
    public int getWriteBehindBufferSize() {
        return this.store != null ? this.store.getWriteBehindBufferSize() : -1;
    }

    @Override
    public float getAverageTxCommitTime() {
        long timeNanos = this.commitTimeNanos.get();
        long commitsCnt = this.txCommits.get();
        if (timeNanos == 0L || commitsCnt == 0L) {
            return 0.0f;
        }
        return 1.0f * (float)timeNanos / (float)commitsCnt / 1000.0f;
    }

    @Override
    public float getAverageTxRollbackTime() {
        long timeNanos = this.rollbackTimeNanos.get();
        long rollbacksCnt = this.txRollbacks.get();
        if (timeNanos == 0L || rollbacksCnt == 0L) {
            return 0.0f;
        }
        return 1.0f * (float)timeNanos / (float)rollbacksCnt / 1000.0f;
    }

    @Override
    public long getCacheTxCommits() {
        return this.txCommits.get();
    }

    @Override
    public long getCacheTxRollbacks() {
        return this.txRollbacks.get();
    }

    public void clear() {
        this.reads.set(0L);
        this.writes.set(0L);
        this.rmCnt.set(0L);
        this.hits.set(0L);
        this.misses.set(0L);
        this.evictCnt.set(0L);
        this.txCommits.set(0L);
        this.txRollbacks.set(0L);
        this.putTimeNanos.set(0L);
        this.rmvTimeNanos.set(0L);
        this.getTimeNanos.set(0L);
        this.commitTimeNanos.set(0L);
        this.rollbackTimeNanos.set(0L);
        this.offHeapGets.set(0L);
        this.offHeapPuts.set(0L);
        this.offHeapRemoves.set(0L);
        this.offHeapHits.set(0L);
        this.offHeapMisses.set(0L);
        this.offHeapEvicts.set(0L);
        this.swapGets.set(0L);
        this.swapPuts.set(0L);
        this.swapRemoves.set(0L);
        this.swapHits.set(0L);
        this.swapMisses.set(0L);
        if (this.delegate != null) {
            this.delegate.clear();
        }
    }

    @Override
    public long getCacheHits() {
        return this.hits.get();
    }

    @Override
    public float getCacheHitPercentage() {
        long hits0 = this.hits.get();
        long gets0 = this.reads.get();
        if (hits0 == 0L) {
            return 0.0f;
        }
        return (float)hits0 / (float)gets0 * 100.0f;
    }

    @Override
    public long getCacheMisses() {
        return this.misses.get();
    }

    @Override
    public float getCacheMissPercentage() {
        long misses0 = this.misses.get();
        long reads0 = this.reads.get();
        if (misses0 == 0L) {
            return 0.0f;
        }
        return (float)misses0 / (float)reads0 * 100.0f;
    }

    @Override
    public long getCacheGets() {
        return this.reads.get();
    }

    @Override
    public long getCachePuts() {
        return this.writes.get();
    }

    @Override
    public long getCacheRemovals() {
        return this.rmCnt.get();
    }

    @Override
    public long getCacheEvictions() {
        return this.evictCnt.get();
    }

    @Override
    public float getAverageGetTime() {
        long timeNanos = this.getTimeNanos.get();
        long readsCnt = this.reads.get();
        if (timeNanos == 0L || readsCnt == 0L) {
            return 0.0f;
        }
        return 1.0f * (float)timeNanos / (float)readsCnt / 1000.0f;
    }

    @Override
    public float getAveragePutTime() {
        long timeNanos = this.putTimeNanos.get();
        long putsCnt = this.writes.get();
        if (timeNanos == 0L || putsCnt == 0L) {
            return 0.0f;
        }
        return 1.0f * (float)timeNanos / (float)putsCnt / 1000.0f;
    }

    @Override
    public float getAverageRemoveTime() {
        long timeNanos = this.rmvTimeNanos.get();
        long removesCnt = this.rmCnt.get();
        if (timeNanos == 0L || removesCnt == 0L) {
            return 0.0f;
        }
        return 1.0f * (float)timeNanos / (float)removesCnt / 1000.0f;
    }

    public void onRead(boolean isHit) {
        this.reads.incrementAndGet();
        if (isHit) {
            this.hits.incrementAndGet();
        } else {
            this.misses.incrementAndGet();
        }
        if (this.delegate != null) {
            this.delegate.onRead(isHit);
        }
    }

    public void onWrite() {
        this.writes.incrementAndGet();
        if (this.delegate != null) {
            this.delegate.onWrite();
        }
    }

    public void onRemove() {
        this.rmCnt.incrementAndGet();
        if (this.delegate != null) {
            this.delegate.onRemove();
        }
    }

    public void onEvict() {
        this.evictCnt.incrementAndGet();
        if (this.delegate != null) {
            this.delegate.onEvict();
        }
    }

    public void onTxCommit(long duration) {
        this.txCommits.incrementAndGet();
        this.commitTimeNanos.addAndGet(duration);
        if (this.delegate != null) {
            this.delegate.onTxCommit(duration);
        }
    }

    public void onTxRollback(long duration) {
        this.txRollbacks.incrementAndGet();
        this.rollbackTimeNanos.addAndGet(duration);
        if (this.delegate != null) {
            this.delegate.onTxRollback(duration);
        }
    }

    public void addGetTimeNanos(long duration) {
        this.getTimeNanos.addAndGet(duration);
        if (this.delegate != null) {
            this.delegate.addGetTimeNanos(duration);
        }
    }

    public void addPutTimeNanos(long duration) {
        this.putTimeNanos.addAndGet(duration);
        if (this.delegate != null) {
            this.delegate.addPutTimeNanos(duration);
        }
    }

    public void addRemoveTimeNanos(long duration) {
        this.rmvTimeNanos.addAndGet(duration);
        if (this.delegate != null) {
            this.delegate.addRemoveTimeNanos(duration);
        }
    }

    public void addRemoveAndGetTimeNanos(long duration) {
        this.rmvTimeNanos.addAndGet(duration);
        this.getTimeNanos.addAndGet(duration);
        if (this.delegate != null) {
            this.delegate.addRemoveAndGetTimeNanos(duration);
        }
    }

    public void addPutAndGetTimeNanos(long duration) {
        this.putTimeNanos.addAndGet(duration);
        this.getTimeNanos.addAndGet(duration);
        if (this.delegate != null) {
            this.delegate.addPutAndGetTimeNanos(duration);
        }
    }

    @Override
    public String getKeyType() {
        CacheConfiguration ccfg = this.cctx.config();
        return ccfg != null ? ccfg.getKeyType().getName() : null;
    }

    @Override
    public String getValueType() {
        CacheConfiguration ccfg = this.cctx.config();
        return ccfg != null ? ccfg.getValueType().getName() : null;
    }

    @Override
    public boolean isReadThrough() {
        CacheConfiguration ccfg = this.cctx.config();
        return ccfg != null && ccfg.isReadThrough();
    }

    @Override
    public boolean isWriteThrough() {
        CacheConfiguration ccfg = this.cctx.config();
        return ccfg != null && ccfg.isWriteThrough();
    }

    @Override
    public boolean isStoreByValue() {
        CacheConfiguration ccfg = this.cctx.config();
        return ccfg != null && ccfg.isStoreByValue();
    }

    @Override
    public boolean isStatisticsEnabled() {
        CacheConfiguration ccfg = this.cctx.config();
        return ccfg != null && ccfg.isStatisticsEnabled();
    }

    @Override
    public boolean isManagementEnabled() {
        CacheConfiguration ccfg = this.cctx.config();
        return ccfg != null && ccfg.isManagementEnabled();
    }

    public void onOffHeapRead(boolean hit) {
        this.offHeapGets.incrementAndGet();
        if (hit) {
            this.offHeapHits.incrementAndGet();
        } else {
            this.offHeapMisses.incrementAndGet();
        }
        if (this.delegate != null) {
            this.delegate.onOffHeapRead(hit);
        }
    }

    public void onOffHeapWrite() {
        this.offHeapPuts.incrementAndGet();
        if (this.delegate != null) {
            this.delegate.onOffHeapWrite();
        }
    }

    public void onOffHeapRemove() {
        this.offHeapRemoves.incrementAndGet();
        if (this.delegate != null) {
            this.delegate.onOffHeapRemove();
        }
    }

    public void onOffHeapEvict() {
        this.offHeapEvicts.incrementAndGet();
        if (this.delegate != null) {
            this.delegate.onOffHeapEvict();
        }
    }

    public void onSwapRead(boolean hit) {
        this.swapGets.incrementAndGet();
        if (hit) {
            this.swapHits.incrementAndGet();
        } else {
            this.swapMisses.incrementAndGet();
        }
        if (this.delegate != null) {
            this.delegate.onSwapRead(hit);
        }
    }

    public void onSwapWrite() {
        this.onSwapWrite(1);
    }

    public void onSwapWrite(int cnt) {
        this.swapPuts.addAndGet(cnt);
        if (this.delegate != null) {
            this.delegate.onSwapWrite(cnt);
        }
    }

    public void onSwapRemove() {
        this.onSwapRemove(1);
    }

    public void onSwapRemove(int cnt) {
        this.swapRemoves.addAndGet(cnt);
        if (this.delegate != null) {
            this.delegate.onSwapRemove(cnt);
        }
    }

    public String toString() {
        return S.toString(CacheMetricsImpl.class, this);
    }
}

