/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import org.apache.ignite.cache.CacheMetrics;
import org.apache.ignite.internal.util.typedef.internal.S;

public class CacheMetricsSnapshot
implements CacheMetrics,
Externalizable {
    private static final long serialVersionUID = 0L;
    private long reads = 0L;
    private long puts = 0L;
    private long hits = 0L;
    private long misses = 0L;
    private long txCommits = 0L;
    private long txRollbacks = 0L;
    private long evicts = 0L;
    private long removes = 0L;
    private float putAvgTimeNanos = 0.0f;
    private float getAvgTimeNanos = 0.0f;
    private float rmvAvgTimeNanos = 0.0f;
    private float commitAvgTimeNanos = 0.0f;
    private float rollbackAvgTimeNanos = 0.0f;
    private String cacheName;
    private long overflowSize;
    private long offHeapGets;
    private long offHeapPuts;
    private long offHeapRemoves;
    private long offHeapEvicts;
    private long offHeapHits;
    private long offHeapMisses;
    private long offHeapEntriesCnt;
    private long offHeapPrimaryEntriesCnt;
    private long offHeapBackupEntriesCnt;
    private long offHeapAllocatedSize;
    private long offHeapMaxSize;
    private long swapGets;
    private long swapPuts;
    private long swapRemoves;
    private long swapEntriesCnt;
    private long swapHits;
    private long swapMisses;
    private long swapSize;
    private int size;
    private int keySize;
    private boolean isEmpty;
    private int dhtEvictQueueCurrSize;
    private int txThreadMapSize;
    private int txXidMapSize;
    private int txCommitQueueSize;
    private int txPrepareQueueSize;
    private int txStartVerCountsSize;
    private int txCommittedVersionsSize;
    private int txRolledbackVersionsSize;
    private int txDhtThreadMapSize;
    private int txDhtXidMapSize;
    private int txDhtCommitQueueSize;
    private int txDhtPrepareQueueSize;
    private int txDhtStartVerCountsSize;
    private int txDhtCommittedVersionsSize;
    private int txDhtRolledbackVersionsSize;
    private boolean isWriteBehindEnabled;
    private int writeBehindFlushSize;
    private int writeBehindFlushThreadCnt;
    private long writeBehindFlushFreq;
    private int writeBehindStoreBatchSize;
    private int writeBehindTotalCriticalOverflowCnt;
    private int writeBehindCriticalOverflowCnt;
    private int writeBehindErrorRetryCnt;
    private int writeBehindBufSize;
    private String keyType;
    private String valType;
    private boolean isStoreByVal;
    private boolean isStatisticsEnabled;
    private boolean isManagementEnabled;
    private boolean isReadThrough;
    private boolean isWriteThrough;

    public CacheMetricsSnapshot() {
    }

    public CacheMetricsSnapshot(CacheMetrics m) {
        this.reads = m.getCacheGets();
        this.puts = m.getCachePuts();
        this.hits = m.getCacheHits();
        this.misses = m.getCacheMisses();
        this.txCommits = m.getCacheTxCommits();
        this.txRollbacks = m.getCacheTxRollbacks();
        this.evicts = m.getCacheEvictions();
        this.removes = m.getCacheRemovals();
        this.putAvgTimeNanos = m.getAveragePutTime();
        this.getAvgTimeNanos = m.getAverageGetTime();
        this.rmvAvgTimeNanos = m.getAverageRemoveTime();
        this.commitAvgTimeNanos = m.getAverageTxCommitTime();
        this.rollbackAvgTimeNanos = m.getAverageTxRollbackTime();
        this.cacheName = m.name();
        this.overflowSize = m.getOverflowSize();
        this.offHeapGets = m.getOffHeapGets();
        this.offHeapPuts = m.getOffHeapPuts();
        this.offHeapRemoves = m.getOffHeapRemovals();
        this.offHeapEvicts = m.getOffHeapEvictions();
        this.offHeapHits = m.getOffHeapHits();
        this.offHeapMisses = m.getOffHeapMisses();
        this.offHeapEntriesCnt = m.getOffHeapEntriesCount();
        this.offHeapPrimaryEntriesCnt = m.getOffHeapPrimaryEntriesCount();
        this.offHeapBackupEntriesCnt = m.getOffHeapBackupEntriesCount();
        this.offHeapAllocatedSize = m.getOffHeapAllocatedSize();
        this.offHeapMaxSize = m.getOffHeapMaxSize();
        this.swapGets = m.getSwapGets();
        this.swapPuts = m.getSwapPuts();
        this.swapRemoves = m.getSwapRemovals();
        this.swapHits = m.getSwapHits();
        this.swapMisses = m.getSwapMisses();
        this.swapEntriesCnt = m.getSwapEntriesCount();
        this.swapSize = m.getSwapSize();
        this.size = m.getSize();
        this.keySize = m.getKeySize();
        this.isEmpty = m.isEmpty();
        this.dhtEvictQueueCurrSize = m.getDhtEvictQueueCurrentSize();
        this.txThreadMapSize = m.getTxThreadMapSize();
        this.txXidMapSize = m.getTxXidMapSize();
        this.txCommitQueueSize = m.getTxCommitQueueSize();
        this.txPrepareQueueSize = m.getTxPrepareQueueSize();
        this.txStartVerCountsSize = m.getTxStartVersionCountsSize();
        this.txCommittedVersionsSize = m.getTxCommittedVersionsSize();
        this.txRolledbackVersionsSize = m.getTxRolledbackVersionsSize();
        this.txDhtThreadMapSize = m.getTxDhtThreadMapSize();
        this.txDhtXidMapSize = m.getTxDhtXidMapSize();
        this.txDhtCommitQueueSize = m.getTxDhtCommitQueueSize();
        this.txDhtPrepareQueueSize = m.getTxDhtPrepareQueueSize();
        this.txDhtStartVerCountsSize = m.getTxDhtStartVersionCountsSize();
        this.txDhtCommittedVersionsSize = m.getTxDhtCommittedVersionsSize();
        this.txDhtRolledbackVersionsSize = m.getTxDhtRolledbackVersionsSize();
        this.isWriteBehindEnabled = m.isWriteBehindEnabled();
        this.writeBehindFlushSize = m.getWriteBehindFlushSize();
        this.writeBehindFlushThreadCnt = m.getWriteBehindFlushThreadCount();
        this.writeBehindFlushFreq = m.getWriteBehindFlushFrequency();
        this.writeBehindStoreBatchSize = m.getWriteBehindStoreBatchSize();
        this.writeBehindTotalCriticalOverflowCnt = m.getWriteBehindTotalCriticalOverflowCount();
        this.writeBehindCriticalOverflowCnt = m.getWriteBehindCriticalOverflowCount();
        this.writeBehindErrorRetryCnt = m.getWriteBehindErrorRetryCount();
        this.writeBehindBufSize = m.getWriteBehindBufferSize();
        this.keyType = m.getKeyType();
        this.valType = m.getValueType();
        this.isStoreByVal = m.isStoreByValue();
        this.isStatisticsEnabled = m.isStatisticsEnabled();
        this.isManagementEnabled = m.isManagementEnabled();
        this.isReadThrough = m.isReadThrough();
        this.isWriteThrough = m.isWriteThrough();
    }

    public CacheMetricsSnapshot(CacheMetrics loc, Collection<CacheMetrics> metrics) {
        this.cacheName = loc.name();
        this.isEmpty = loc.isEmpty();
        this.isWriteBehindEnabled = loc.isWriteBehindEnabled();
        this.writeBehindFlushSize = loc.getWriteBehindFlushSize();
        this.writeBehindFlushThreadCnt = loc.getWriteBehindFlushThreadCount();
        this.writeBehindFlushFreq = loc.getWriteBehindFlushFrequency();
        this.writeBehindStoreBatchSize = loc.getWriteBehindStoreBatchSize();
        this.writeBehindBufSize = loc.getWriteBehindBufferSize();
        this.size = loc.getSize();
        this.keySize = loc.getKeySize();
        this.keyType = loc.getKeyType();
        this.valType = loc.getValueType();
        this.isStoreByVal = loc.isStoreByValue();
        this.isStatisticsEnabled = loc.isStatisticsEnabled();
        this.isManagementEnabled = loc.isManagementEnabled();
        this.isReadThrough = loc.isReadThrough();
        this.isWriteThrough = loc.isWriteThrough();
        this.offHeapMaxSize = loc.getOffHeapMaxSize();
        for (CacheMetrics e : metrics) {
            this.reads += e.getCacheGets();
            this.puts += e.getCachePuts();
            this.hits += e.getCacheHits();
            this.misses += e.getCacheMisses();
            this.txCommits += e.getCacheTxCommits();
            this.txRollbacks += e.getCacheTxRollbacks();
            this.evicts += e.getCacheEvictions();
            this.removes += e.getCacheRemovals();
            this.putAvgTimeNanos += e.getAveragePutTime();
            this.getAvgTimeNanos += e.getAverageGetTime();
            this.rmvAvgTimeNanos += e.getAverageRemoveTime();
            this.commitAvgTimeNanos += e.getAverageTxCommitTime();
            this.rollbackAvgTimeNanos += e.getAverageTxRollbackTime();
            this.overflowSize = e.getOverflowSize() > -1L ? (this.overflowSize += e.getOverflowSize()) : -1L;
            this.offHeapGets += e.getOffHeapGets();
            this.offHeapPuts += e.getOffHeapPuts();
            this.offHeapRemoves += e.getOffHeapRemovals();
            this.offHeapEvicts += e.getOffHeapEvictions();
            this.offHeapHits += e.getOffHeapHits();
            this.offHeapMisses += e.getOffHeapMisses();
            this.offHeapEntriesCnt += e.getOffHeapEntriesCount();
            this.offHeapPrimaryEntriesCnt += e.getOffHeapPrimaryEntriesCount();
            this.offHeapBackupEntriesCnt += e.getOffHeapBackupEntriesCount();
            this.offHeapAllocatedSize += e.getOffHeapAllocatedSize();
            this.swapGets += e.getSwapGets();
            this.swapPuts += e.getSwapPuts();
            this.swapRemoves += e.getSwapRemovals();
            this.swapHits += e.getSwapHits();
            this.swapMisses += e.getSwapMisses();
            this.swapEntriesCnt += e.getSwapEntriesCount();
            this.swapSize += e.getSwapSize();
            this.dhtEvictQueueCurrSize = e.getDhtEvictQueueCurrentSize() > -1 ? (this.dhtEvictQueueCurrSize += e.getDhtEvictQueueCurrentSize()) : -1;
            this.txThreadMapSize += e.getTxThreadMapSize();
            this.txXidMapSize += e.getTxXidMapSize();
            this.txCommitQueueSize += e.getTxCommitQueueSize();
            this.txPrepareQueueSize += e.getTxPrepareQueueSize();
            this.txStartVerCountsSize += e.getTxStartVersionCountsSize();
            this.txCommittedVersionsSize += e.getTxCommittedVersionsSize();
            this.txRolledbackVersionsSize += e.getTxRolledbackVersionsSize();
            this.txDhtThreadMapSize = e.getTxDhtThreadMapSize() > -1 ? (this.txDhtThreadMapSize += e.getTxDhtThreadMapSize()) : -1;
            this.txDhtXidMapSize = e.getTxDhtXidMapSize() > -1 ? (this.txDhtXidMapSize += e.getTxDhtXidMapSize()) : -1;
            this.txDhtCommitQueueSize = e.getTxDhtCommitQueueSize() > -1 ? (this.txDhtCommitQueueSize += e.getTxDhtCommitQueueSize()) : -1;
            this.txDhtPrepareQueueSize = e.getTxDhtPrepareQueueSize() > -1 ? (this.txDhtPrepareQueueSize += e.getTxDhtPrepareQueueSize()) : -1;
            this.txDhtStartVerCountsSize = e.getTxDhtStartVersionCountsSize() > -1 ? (this.txDhtStartVerCountsSize += e.getTxDhtStartVersionCountsSize()) : -1;
            this.txDhtCommittedVersionsSize = e.getTxDhtCommittedVersionsSize() > -1 ? (this.txDhtCommittedVersionsSize += e.getTxDhtCommittedVersionsSize()) : -1;
            this.txDhtRolledbackVersionsSize = e.getTxDhtRolledbackVersionsSize() > -1 ? (this.txDhtRolledbackVersionsSize += e.getTxDhtRolledbackVersionsSize()) : -1;
            this.writeBehindTotalCriticalOverflowCnt = e.getWriteBehindTotalCriticalOverflowCount() > -1 ? (this.writeBehindTotalCriticalOverflowCnt += e.getWriteBehindTotalCriticalOverflowCount()) : -1;
            this.writeBehindCriticalOverflowCnt = e.getWriteBehindCriticalOverflowCount() > -1 ? (this.writeBehindCriticalOverflowCnt += e.getWriteBehindCriticalOverflowCount()) : -1;
            if (e.getWriteBehindErrorRetryCount() > -1) {
                this.writeBehindErrorRetryCnt += e.getWriteBehindErrorRetryCount();
                continue;
            }
            this.writeBehindErrorRetryCnt = -1;
        }
        int size = metrics.size();
        if (size > 1) {
            this.putAvgTimeNanos /= (float)size;
            this.getAvgTimeNanos /= (float)size;
            this.rmvAvgTimeNanos /= (float)size;
            this.commitAvgTimeNanos /= (float)size;
            this.rollbackAvgTimeNanos /= (float)size;
        }
    }

    @Override
    public long getCacheHits() {
        return this.hits;
    }

    @Override
    public float getCacheHitPercentage() {
        if (this.hits == 0L || this.reads == 0L) {
            return 0.0f;
        }
        return (float)this.hits / (float)this.reads * 100.0f;
    }

    @Override
    public long getCacheMisses() {
        return this.misses;
    }

    @Override
    public float getCacheMissPercentage() {
        if (this.misses == 0L || this.reads == 0L) {
            return 0.0f;
        }
        return (float)this.misses / (float)this.reads * 100.0f;
    }

    @Override
    public long getCacheGets() {
        return this.reads;
    }

    @Override
    public long getCachePuts() {
        return this.puts;
    }

    @Override
    public long getCacheRemovals() {
        return this.removes;
    }

    @Override
    public long getCacheEvictions() {
        return this.evicts;
    }

    @Override
    public float getAverageGetTime() {
        return this.getAvgTimeNanos;
    }

    @Override
    public float getAveragePutTime() {
        return this.putAvgTimeNanos;
    }

    @Override
    public float getAverageRemoveTime() {
        return this.rmvAvgTimeNanos;
    }

    @Override
    public float getAverageTxCommitTime() {
        return this.commitAvgTimeNanos;
    }

    @Override
    public float getAverageTxRollbackTime() {
        return this.rollbackAvgTimeNanos;
    }

    @Override
    public long getCacheTxCommits() {
        return this.txCommits;
    }

    @Override
    public long getCacheTxRollbacks() {
        return this.txRollbacks;
    }

    @Override
    public String name() {
        return this.cacheName;
    }

    @Override
    public long getOverflowSize() {
        return this.overflowSize;
    }

    @Override
    public long getOffHeapGets() {
        return this.offHeapGets;
    }

    @Override
    public long getOffHeapPuts() {
        return this.offHeapPuts;
    }

    @Override
    public long getOffHeapRemovals() {
        return this.offHeapRemoves;
    }

    @Override
    public long getOffHeapEvictions() {
        return this.offHeapEvicts;
    }

    @Override
    public long getOffHeapHits() {
        return this.offHeapHits;
    }

    @Override
    public float getOffHeapHitPercentage() {
        if (this.offHeapHits == 0L || this.offHeapGets == 0L) {
            return 0.0f;
        }
        return (float)this.offHeapHits / (float)this.offHeapGets * 100.0f;
    }

    @Override
    public long getOffHeapMisses() {
        return this.offHeapMisses;
    }

    @Override
    public float getOffHeapMissPercentage() {
        if (this.offHeapMisses == 0L || this.offHeapGets == 0L) {
            return 0.0f;
        }
        return (float)this.offHeapMisses / (float)this.offHeapGets * 100.0f;
    }

    @Override
    public long getOffHeapEntriesCount() {
        return this.offHeapEntriesCnt;
    }

    @Override
    public long getOffHeapPrimaryEntriesCount() {
        return this.offHeapPrimaryEntriesCnt;
    }

    @Override
    public long getOffHeapBackupEntriesCount() {
        return this.offHeapBackupEntriesCnt;
    }

    @Override
    public long getOffHeapAllocatedSize() {
        return this.offHeapAllocatedSize;
    }

    @Override
    public long getOffHeapMaxSize() {
        return this.offHeapMaxSize;
    }

    @Override
    public long getSwapGets() {
        return this.swapGets;
    }

    @Override
    public long getSwapPuts() {
        return this.swapPuts;
    }

    @Override
    public long getSwapRemovals() {
        return this.swapRemoves;
    }

    @Override
    public long getSwapHits() {
        return this.swapHits;
    }

    @Override
    public long getSwapMisses() {
        return this.swapMisses;
    }

    @Override
    public float getSwapHitPercentage() {
        if (this.swapHits == 0L || this.swapGets == 0L) {
            return 0.0f;
        }
        return (float)this.swapHits / (float)this.swapGets * 100.0f;
    }

    @Override
    public float getSwapMissPercentage() {
        if (this.swapMisses == 0L || this.swapGets == 0L) {
            return 0.0f;
        }
        return (float)this.swapMisses / (float)this.swapGets * 100.0f;
    }

    @Override
    public long getSwapEntriesCount() {
        return this.swapEntriesCnt;
    }

    @Override
    public long getSwapSize() {
        return this.swapSize;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int getKeySize() {
        return this.keySize;
    }

    @Override
    public boolean isEmpty() {
        return this.isEmpty;
    }

    @Override
    public int getDhtEvictQueueCurrentSize() {
        return this.dhtEvictQueueCurrSize;
    }

    @Override
    public int getTxThreadMapSize() {
        return this.txThreadMapSize;
    }

    @Override
    public int getTxXidMapSize() {
        return this.txXidMapSize;
    }

    @Override
    public int getTxCommitQueueSize() {
        return this.txCommitQueueSize;
    }

    @Override
    public int getTxPrepareQueueSize() {
        return this.txPrepareQueueSize;
    }

    @Override
    public int getTxStartVersionCountsSize() {
        return this.txStartVerCountsSize;
    }

    @Override
    public int getTxCommittedVersionsSize() {
        return this.txCommittedVersionsSize;
    }

    @Override
    public int getTxRolledbackVersionsSize() {
        return this.txRolledbackVersionsSize;
    }

    @Override
    public int getTxDhtThreadMapSize() {
        return this.txDhtThreadMapSize;
    }

    @Override
    public int getTxDhtXidMapSize() {
        return this.txDhtXidMapSize;
    }

    @Override
    public int getTxDhtCommitQueueSize() {
        return this.txDhtCommitQueueSize;
    }

    @Override
    public int getTxDhtPrepareQueueSize() {
        return this.txDhtPrepareQueueSize;
    }

    @Override
    public int getTxDhtStartVersionCountsSize() {
        return this.txDhtStartVerCountsSize;
    }

    @Override
    public int getTxDhtCommittedVersionsSize() {
        return this.txDhtCommittedVersionsSize;
    }

    @Override
    public int getTxDhtRolledbackVersionsSize() {
        return this.txDhtRolledbackVersionsSize;
    }

    @Override
    public boolean isWriteBehindEnabled() {
        return this.isWriteBehindEnabled;
    }

    @Override
    public int getWriteBehindFlushSize() {
        return this.writeBehindFlushSize;
    }

    @Override
    public int getWriteBehindFlushThreadCount() {
        return this.writeBehindFlushThreadCnt;
    }

    @Override
    public long getWriteBehindFlushFrequency() {
        return this.writeBehindFlushFreq;
    }

    @Override
    public int getWriteBehindStoreBatchSize() {
        return this.writeBehindStoreBatchSize;
    }

    @Override
    public int getWriteBehindTotalCriticalOverflowCount() {
        return this.writeBehindTotalCriticalOverflowCnt;
    }

    @Override
    public int getWriteBehindCriticalOverflowCount() {
        return this.writeBehindCriticalOverflowCnt;
    }

    @Override
    public int getWriteBehindErrorRetryCount() {
        return this.writeBehindErrorRetryCnt;
    }

    @Override
    public int getWriteBehindBufferSize() {
        return this.writeBehindBufSize;
    }

    @Override
    public String getKeyType() {
        return this.keyType;
    }

    @Override
    public String getValueType() {
        return this.valType;
    }

    @Override
    public boolean isStoreByValue() {
        return this.isStoreByVal;
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.isStatisticsEnabled;
    }

    @Override
    public boolean isManagementEnabled() {
        return this.isManagementEnabled;
    }

    @Override
    public boolean isReadThrough() {
        return this.isReadThrough;
    }

    @Override
    public boolean isWriteThrough() {
        return this.isWriteThrough;
    }

    public String toString() {
        return S.toString(CacheMetricsSnapshot.class, this);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.reads);
        out.writeLong(this.puts);
        out.writeLong(this.hits);
        out.writeLong(this.misses);
        out.writeLong(this.txCommits);
        out.writeLong(this.txRollbacks);
        out.writeLong(this.evicts);
        out.writeLong(this.removes);
        out.writeFloat(this.putAvgTimeNanos);
        out.writeFloat(this.getAvgTimeNanos);
        out.writeFloat(this.rmvAvgTimeNanos);
        out.writeFloat(this.commitAvgTimeNanos);
        out.writeFloat(this.rollbackAvgTimeNanos);
        out.writeLong(this.overflowSize);
        out.writeLong(this.offHeapGets);
        out.writeLong(this.offHeapPuts);
        out.writeLong(this.offHeapRemoves);
        out.writeLong(this.offHeapEvicts);
        out.writeLong(this.offHeapHits);
        out.writeLong(this.offHeapMisses);
        out.writeLong(this.offHeapEntriesCnt);
        out.writeLong(this.offHeapPrimaryEntriesCnt);
        out.writeLong(this.offHeapBackupEntriesCnt);
        out.writeLong(this.offHeapAllocatedSize);
        out.writeLong(this.offHeapMaxSize);
        out.writeLong(this.swapGets);
        out.writeLong(this.swapPuts);
        out.writeLong(this.swapRemoves);
        out.writeLong(this.swapHits);
        out.writeLong(this.swapMisses);
        out.writeLong(this.swapEntriesCnt);
        out.writeLong(this.swapSize);
        out.writeInt(this.dhtEvictQueueCurrSize);
        out.writeInt(this.txThreadMapSize);
        out.writeInt(this.txXidMapSize);
        out.writeInt(this.txCommitQueueSize);
        out.writeInt(this.txPrepareQueueSize);
        out.writeInt(this.txStartVerCountsSize);
        out.writeInt(this.txCommittedVersionsSize);
        out.writeInt(this.txRolledbackVersionsSize);
        out.writeInt(this.txDhtThreadMapSize);
        out.writeInt(this.txDhtXidMapSize);
        out.writeInt(this.txDhtCommitQueueSize);
        out.writeInt(this.txDhtPrepareQueueSize);
        out.writeInt(this.txDhtStartVerCountsSize);
        out.writeInt(this.txDhtCommittedVersionsSize);
        out.writeInt(this.txDhtRolledbackVersionsSize);
        out.writeInt(this.writeBehindTotalCriticalOverflowCnt);
        out.writeInt(this.writeBehindCriticalOverflowCnt);
        out.writeInt(this.writeBehindErrorRetryCnt);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.reads = in.readLong();
        this.puts = in.readLong();
        this.hits = in.readLong();
        this.misses = in.readLong();
        this.txCommits = in.readLong();
        this.txRollbacks = in.readLong();
        this.evicts = in.readLong();
        this.removes = in.readLong();
        this.putAvgTimeNanos = in.readFloat();
        this.getAvgTimeNanos = in.readFloat();
        this.rmvAvgTimeNanos = in.readFloat();
        this.commitAvgTimeNanos = in.readFloat();
        this.rollbackAvgTimeNanos = in.readFloat();
        this.overflowSize = in.readLong();
        this.offHeapGets = in.readLong();
        this.offHeapPuts = in.readLong();
        this.offHeapRemoves = in.readLong();
        this.offHeapEvicts = in.readLong();
        this.offHeapHits = in.readLong();
        this.offHeapMisses = in.readLong();
        this.offHeapEntriesCnt = in.readLong();
        this.offHeapPrimaryEntriesCnt = in.readLong();
        this.offHeapBackupEntriesCnt = in.readLong();
        this.offHeapAllocatedSize = in.readLong();
        this.offHeapMaxSize = in.readLong();
        this.swapGets = in.readLong();
        this.swapPuts = in.readLong();
        this.swapRemoves = in.readLong();
        this.swapHits = in.readLong();
        this.swapMisses = in.readLong();
        this.swapEntriesCnt = in.readLong();
        this.swapSize = in.readLong();
        this.dhtEvictQueueCurrSize = in.readInt();
        this.txThreadMapSize = in.readInt();
        this.txXidMapSize = in.readInt();
        this.txCommitQueueSize = in.readInt();
        this.txPrepareQueueSize = in.readInt();
        this.txStartVerCountsSize = in.readInt();
        this.txCommittedVersionsSize = in.readInt();
        this.txRolledbackVersionsSize = in.readInt();
        this.txDhtThreadMapSize = in.readInt();
        this.txDhtXidMapSize = in.readInt();
        this.txDhtCommitQueueSize = in.readInt();
        this.txDhtPrepareQueueSize = in.readInt();
        this.txDhtStartVerCountsSize = in.readInt();
        this.txDhtCommittedVersionsSize = in.readInt();
        this.txDhtRolledbackVersionsSize = in.readInt();
        this.writeBehindTotalCriticalOverflowCnt = in.readInt();
        this.writeBehindCriticalOverflowCnt = in.readInt();
        this.writeBehindErrorRetryCnt = in.readInt();
    }
}

