/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public abstract class CacheObjectAdapter
implements CacheObject,
Externalizable {
    private static final long serialVersionUID = 2006765505127197251L;
    @GridToStringInclude(sensitive=true)
    @GridDirectTransient
    protected Object val;
    protected byte[] valBytes;

    protected boolean needCopy(CacheObjectContext ctx) {
        return ctx.copyOnGet() && this.val != null && !ctx.processor().immutable(this.val);
    }

    @Override
    public byte cacheObjectType() {
        return 1;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        assert (this.valBytes != null);
        U.writeByteArray(out, this.valBytes);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.valBytes = U.readByteArray(in);
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.valBytes = reader.readByteArray("valBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(CacheObjectAdapter.class);
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeByteArray("valBytes", this.valBytes)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public byte fieldsCount() {
        return 1;
    }

    public String toString() {
        return S.toString(S.INCLUDE_SENSITIVE ? this.getClass().getSimpleName() : "CacheObject", "val", this.val, true, "hasValBytes", this.valBytes != null, false);
    }
}

