/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.ignite.cache.affinity.AffinityKeyMapper;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cacheobject.IgniteCacheObjectProcessor;
import org.apache.ignite.internal.util.typedef.F;

public class CacheObjectContext {
    private GridKernalContext kernalCtx;
    private IgniteCacheObjectProcessor proc;
    private String cacheName;
    private AffinityKeyMapper dfltAffMapper;
    private boolean cpyOnGet;
    private boolean storeVal;
    private boolean p2pEnabled;
    private boolean addDepInfo;

    public CacheObjectContext(GridKernalContext kernalCtx, String cacheName, AffinityKeyMapper dfltAffMapper, boolean cpyOnGet, boolean storeVal, boolean addDepInfo) {
        this.kernalCtx = kernalCtx;
        this.cacheName = cacheName;
        this.dfltAffMapper = dfltAffMapper;
        this.cpyOnGet = cpyOnGet;
        this.storeVal = storeVal;
        this.addDepInfo = addDepInfo;
        this.p2pEnabled = kernalCtx.config().isPeerClassLoadingEnabled();
        this.proc = kernalCtx.cacheObjects();
    }

    public String cacheName() {
        return this.cacheName;
    }

    public boolean p2pEnabled() {
        return this.p2pEnabled;
    }

    public boolean addDeploymentInfo() {
        return this.addDepInfo;
    }

    public boolean copyOnGet() {
        return this.cpyOnGet;
    }

    public boolean storeValue() {
        return this.storeVal;
    }

    public AffinityKeyMapper defaultAffMapper() {
        return this.dfltAffMapper;
    }

    public GridKernalContext kernalContext() {
        return this.kernalCtx;
    }

    public IgniteCacheObjectProcessor processor() {
        return this.proc;
    }

    public Object unwrapBinaryIfNeeded(Object o, boolean keepBinary) {
        return this.unwrapBinaryIfNeeded(o, keepBinary, true);
    }

    public Object unwrapBinaryIfNeeded(Object o, boolean keepBinary, boolean cpy) {
        if (o == null) {
            return null;
        }
        return this.unwrapBinary(o, keepBinary, cpy);
    }

    public Collection<Object> unwrapBinariesIfNeeded(Collection<Object> col, boolean keepBinary) {
        return this.unwrapBinariesIfNeeded(col, keepBinary, true);
    }

    public Collection<Object> unwrapBinariesIfNeeded(Collection<Object> col, boolean keepBinary, boolean cpy) {
        Collection<Object> col0 = BinaryUtils.newKnownCollection(col);
        if (col0 == null) {
            col0 = new ArrayList(col.size());
        }
        for (Object obj : col) {
            col0.add(this.unwrapBinary(obj, keepBinary, cpy));
        }
        return col0;
    }

    private Collection<Object> unwrapKnownCollection(Collection<Object> col, boolean keepBinary, boolean cpy) {
        Collection<Object> col0 = BinaryUtils.newKnownCollection(col);
        for (Object obj : col) {
            col0.add(this.unwrapBinary(obj, keepBinary, cpy));
        }
        return col0;
    }

    public Object[] unwrapBinariesInArrayIfNeeded(Object[] arr, boolean keepBinary, boolean cpy) {
        if (BinaryUtils.knownArray(arr)) {
            return arr;
        }
        Object[] res = new Object[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            res[i] = this.unwrapBinary(arr[i], keepBinary, cpy);
        }
        return res;
    }

    private Map<Object, Object> unwrapBinariesIfNeeded(Map<Object, Object> map, boolean keepBinary, boolean cpy) {
        if (keepBinary) {
            return map;
        }
        Map<Object, Object> map0 = BinaryUtils.newMap(map);
        for (Map.Entry<Object, Object> e : map.entrySet()) {
            map0.put(this.unwrapBinary(e.getKey(), keepBinary, cpy), this.unwrapBinary(e.getValue(), keepBinary, cpy));
        }
        return map0;
    }

    private Object unwrapBinary(Object o, boolean keepBinary, boolean cpy) {
        if (o instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)o;
            Object key = entry.getKey();
            Object uKey = this.unwrapBinary(key, keepBinary, cpy);
            Object val = entry.getValue();
            Object uVal = this.unwrapBinary(val, keepBinary, cpy);
            return key != uKey || val != uVal ? F.t(uKey, uVal) : o;
        }
        if (BinaryUtils.knownCollection(o)) {
            return this.unwrapKnownCollection((Collection)o, keepBinary, cpy);
        }
        if (BinaryUtils.knownMap(o)) {
            return this.unwrapBinariesIfNeeded((Map)o, keepBinary, cpy);
        }
        if (o instanceof Object[]) {
            return this.unwrapBinariesInArrayIfNeeded((Object[])o, keepBinary, cpy);
        }
        if (o instanceof CacheObject) {
            CacheObject co = (CacheObject)o;
            if (!keepBinary || co.isPlatformType()) {
                return this.unwrapBinary(co.value(this, cpy), keepBinary, cpy);
            }
        }
        return o;
    }

    private boolean knownCollection(Object o) {
        Class<?> cls = o == null ? null : o.getClass();
        return cls == ArrayList.class || cls == LinkedList.class || cls == HashSet.class;
    }

    private boolean knownMap(Object o) {
        Class<?> cls = o == null ? null : o.getClass();
        return cls == HashMap.class || cls == LinkedHashMap.class;
    }
}

