/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectAdapter;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.jetbrains.annotations.Nullable;

public class CacheObjectImpl
extends CacheObjectAdapter {
    private static final long serialVersionUID = 0L;

    public CacheObjectImpl() {
    }

    public CacheObjectImpl(Object val, byte[] valBytes) {
        assert (val != null || valBytes != null);
        this.val = val;
        this.valBytes = valBytes;
    }

    @Override
    public boolean isPlatformType() {
        return true;
    }

    @Override
    @Nullable
    public <T> T value(CacheObjectContext ctx, boolean cpy) {
        cpy = cpy && this.needCopy(ctx);
        try {
            if (cpy) {
                if (this.valBytes == null) {
                    assert (this.val != null);
                    this.valBytes = ctx.processor().marshal(ctx, this.val);
                }
                return (T)ctx.processor().unmarshal(ctx, this.valBytes, this.val == null ? ctx.kernalContext().config().getClassLoader() : this.val.getClass().getClassLoader());
            }
            if (this.val != null) {
                return (T)this.val;
            }
            assert (this.valBytes != null);
            Object val = ctx.processor().unmarshal(ctx, this.valBytes, ctx.kernalContext().config().getClassLoader());
            if (ctx.storeValue()) {
                this.val = val;
            }
            return (T)val;
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed to unmarshall object.", e);
        }
    }

    @Override
    public byte[] valueBytes(CacheObjectContext ctx) throws IgniteCheckedException {
        if (this.valBytes == null) {
            this.valBytes = ctx.processor().marshal(ctx, this.val);
        }
        return this.valBytes;
    }

    @Override
    public void prepareMarshal(CacheObjectContext ctx) throws IgniteCheckedException {
        assert (this.val != null || this.valBytes != null);
        if (this.valBytes == null) {
            this.valBytes = ctx.kernalContext().cacheObjects().marshal(ctx, this.val);
        }
    }

    @Override
    public void finishUnmarshal(CacheObjectContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        assert (this.val != null || this.valBytes != null);
        if (this.val == null && ctx.storeValue()) {
            this.val = ctx.processor().unmarshal(ctx, this.valBytes, ldr);
        }
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public byte directType() {
        return 89;
    }

    public int hashCode() {
        assert (false);
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        assert (false);
        return super.equals(obj);
    }

    @Override
    public CacheObject prepareForCache(CacheObjectContext ctx) {
        return this;
    }
}

