/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.util.UUID;
import javax.cache.expiry.ExpiryPolicy;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class CacheOperationContext
implements Serializable {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    private final boolean skipStore;
    @GridToStringInclude
    private final boolean noRetries;
    private final UUID subjId;
    private final boolean keepBinary;
    private final ExpiryPolicy expiryPlc;
    private final Byte dataCenterId;

    public CacheOperationContext() {
        this.skipStore = false;
        this.subjId = null;
        this.keepBinary = false;
        this.expiryPlc = null;
        this.noRetries = false;
        this.dataCenterId = null;
    }

    public CacheOperationContext(boolean skipStore, @Nullable UUID subjId, boolean keepBinary, @Nullable ExpiryPolicy expiryPlc, boolean noRetries, @Nullable Byte dataCenterId) {
        this.skipStore = skipStore;
        this.subjId = subjId;
        this.keepBinary = keepBinary;
        this.expiryPlc = expiryPlc;
        this.noRetries = noRetries;
        this.dataCenterId = dataCenterId;
    }

    public boolean isKeepBinary() {
        return this.keepBinary;
    }

    public boolean hasDataCenterId() {
        return this.dataCenterId != null;
    }

    public CacheOperationContext keepBinary() {
        return new CacheOperationContext(this.skipStore, this.subjId, true, this.expiryPlc, this.noRetries, this.dataCenterId);
    }

    @Nullable
    public UUID subjectId() {
        return this.subjId;
    }

    @Nullable
    public Byte dataCenterId() {
        return this.dataCenterId;
    }

    public CacheOperationContext forSubjectId(UUID subjId) {
        return new CacheOperationContext(this.skipStore, subjId, this.keepBinary, this.expiryPlc, this.noRetries, this.dataCenterId);
    }

    public boolean skipStore() {
        return this.skipStore;
    }

    public CacheOperationContext setSkipStore(boolean skipStore) {
        return new CacheOperationContext(skipStore, this.subjId, this.keepBinary, this.expiryPlc, this.noRetries, this.dataCenterId);
    }

    @Nullable
    public ExpiryPolicy expiry() {
        return this.expiryPlc;
    }

    public CacheOperationContext withExpiryPolicy(ExpiryPolicy plc) {
        return new CacheOperationContext(this.skipStore, this.subjId, true, plc, this.noRetries, this.dataCenterId);
    }

    public CacheOperationContext setNoRetries(boolean noRetries) {
        return new CacheOperationContext(this.skipStore, this.subjId, this.keepBinary, this.expiryPlc, noRetries, this.dataCenterId);
    }

    public boolean noRetries() {
        return this.noRetries;
    }

    public String toString() {
        return S.toString(CacheOperationContext.class, this);
    }
}

