/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.cache.Cache;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CacheWriterException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.store.CacheStore;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentHashMap8;

public class CacheStoreBalancingWrapper<K, V>
implements CacheStore<K, V> {
    public static final int DFLT_LOAD_ALL_THRESHOLD = 5;
    private CacheStore<K, V> delegate;
    private ConcurrentMap<K, LoadFuture> pendingLoads = new ConcurrentHashMap8<K, LoadFuture>();
    private int loadAllThreshold = 5;

    public CacheStoreBalancingWrapper(CacheStore<K, V> delegate) {
        this.delegate = delegate;
    }

    public CacheStoreBalancingWrapper(CacheStore<K, V> delegate, int loadAllThreshold) {
        this.delegate = delegate;
        this.loadAllThreshold = loadAllThreshold;
    }

    public int loadAllThreshold() {
        return this.loadAllThreshold;
    }

    @Override
    @Nullable
    public V load(K key) {
        LoadFuture fut = (LoadFuture)this.pendingLoads.get(key);
        try {
            if (fut != null) {
                return fut.get(key);
            }
            fut = new LoadFuture();
            LoadFuture old = this.pendingLoads.putIfAbsent(key, fut);
            if (old != null) {
                return old.get(key);
            }
        }
        catch (IgniteCheckedException e) {
            throw new CacheLoaderException(e);
        }
        try {
            Object val = this.delegate.load(key);
            fut.onComplete(key, val);
            return val;
        }
        catch (Throwable e) {
            fut.onError(key, e);
            if (e instanceof Error) {
                throw e;
            }
            throw e;
        }
    }

    @Override
    public void loadCache(IgniteBiInClosure<K, V> clo, Object ... args) {
        this.delegate.loadCache(clo, args);
    }

    @Override
    public Map<K, V> loadAll(Iterable<? extends K> keys) throws CacheLoaderException {
        assert (false);
        return this.delegate.loadAll(keys);
    }

    public void loadAll(Collection<? extends K> keys, IgniteBiInClosure<K, V> c) {
        assert (keys.size() <= this.loadAllThreshold) : this.loadAllThreshold;
        ArrayList<K> needLoad = null;
        HashMap<K, LoadFuture> pending = null;
        LoadFuture span = null;
        for (K k : keys) {
            LoadFuture old;
            LoadFuture fut = (LoadFuture)this.pendingLoads.get(k);
            if (fut != null) {
                if (pending == null) {
                    pending = new HashMap<K, LoadFuture>();
                }
                pending.put(k, fut);
                continue;
            }
            if (span == null) {
                span = new LoadFuture();
            }
            if ((old = this.pendingLoads.putIfAbsent(k, span)) != null) {
                if (pending == null) {
                    pending = new HashMap();
                }
                pending.put(k, old);
                continue;
            }
            if (needLoad == null) {
                needLoad = new ArrayList<K>(keys.size());
            }
            needLoad.add(k);
        }
        if (needLoad != null) {
            assert (!needLoad.isEmpty());
            assert (span != null);
            try {
                Map loaded = this.delegate.loadAll(needLoad);
                if (loaded != null) {
                    for (Map.Entry e : loaded.entrySet()) {
                        c.apply(e.getKey(), e.getValue());
                    }
                }
                span.onComplete(needLoad, loaded);
            }
            catch (Throwable e) {
                span.onError(needLoad, e);
                if (e instanceof Error) {
                    throw e;
                }
                throw e;
            }
        }
        if (pending != null) {
            try {
                for (Map.Entry entry : pending.entrySet()) {
                    Object key = entry.getKey();
                    c.apply(key, ((LoadFuture)entry.getValue()).get(key));
                }
            }
            catch (IgniteCheckedException e) {
                throw new CacheLoaderException(e);
            }
        }
    }

    @Override
    public void write(Cache.Entry<? extends K, ? extends V> entry) {
        this.delegate.write(entry);
    }

    @Override
    public void writeAll(Collection<Cache.Entry<? extends K, ? extends V>> entries) {
        this.delegate.writeAll(entries);
    }

    @Override
    public void delete(Object key) throws CacheWriterException {
        this.delegate.delete(key);
    }

    @Override
    public void deleteAll(Collection<?> keys) throws CacheWriterException {
        this.delegate.deleteAll(keys);
    }

    @Override
    public void sessionEnd(boolean commit) {
        this.delegate.sessionEnd(commit);
    }

    public String toString() {
        return S.toString(CacheStoreBalancingWrapper.class, this);
    }

    private class LoadFuture
    extends GridFutureAdapter<Map<K, V>> {
        private static final long serialVersionUID = 0L;
        private volatile Collection<K> keys;

        @Override
        public boolean onDone(@Nullable Map<K, V> res, @Nullable Throwable err) {
            if (super.onDone(res, err)) {
                assert (this.keys != null);
                for (Object key : this.keys) {
                    CacheStoreBalancingWrapper.this.pendingLoads.remove(key, this);
                }
                return true;
            }
            return false;
        }

        public void onComplete(K key, V val) {
            this.onComplete(Collections.singletonList(key), F.asMap(key, val));
        }

        public void onComplete(Collection<K> keys, Map<K, V> res) {
            this.keys = keys;
            this.onDone(res);
        }

        public void onError(K key, Throwable err) {
            this.keys = Collections.singletonList(key);
            this.onDone(err);
        }

        public void onError(Collection<K> keys, Throwable err) {
            this.keys = keys;
            this.onDone(err);
        }

        public V get(K key) throws IgniteCheckedException {
            return ((Map)this.get()).get(key);
        }
    }
}

