/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.util.UUID;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.NearCacheConfiguration;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheType;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class DynamicCacheChangeRequest
implements Serializable {
    private static final long serialVersionUID = 0L;
    private IgniteUuid deploymentId;
    @GridToStringExclude
    private String cacheName;
    private CacheConfiguration startCfg;
    private CacheType cacheType;
    private UUID initiatingNodeId;
    private NearCacheConfiguration nearCacheCfg;
    private boolean clientStartOnly;
    private boolean stop;
    private boolean close;
    private boolean failIfExists;
    private boolean template;
    private UUID rcvdFrom;
    private transient boolean exchangeNeeded;
    private transient AffinityTopologyVersion cacheFutTopVer;

    public DynamicCacheChangeRequest(String cacheName, UUID initiatingNodeId) {
        this.cacheName = cacheName;
        this.initiatingNodeId = initiatingNodeId;
    }

    public boolean exchangeNeeded() {
        return this.exchangeNeeded;
    }

    public void cacheFutureTopologyVersion(AffinityTopologyVersion cacheFutTopVer) {
        this.cacheFutTopVer = cacheFutTopVer;
    }

    @Nullable
    public AffinityTopologyVersion cacheFutureTopologyVersion() {
        return this.cacheFutTopVer;
    }

    public void exchangeNeeded(boolean exchangeNeeded) {
        this.exchangeNeeded = exchangeNeeded;
    }

    public void template(boolean template) {
        this.template = template;
    }

    public boolean template() {
        return this.template;
    }

    public IgniteUuid deploymentId() {
        return this.deploymentId;
    }

    public void deploymentId(IgniteUuid deploymentId) {
        this.deploymentId = deploymentId;
    }

    public boolean start() {
        return !this.template && this.startCfg != null;
    }

    public boolean stop() {
        return this.stop;
    }

    public void stop(boolean stop) {
        this.stop = stop;
    }

    public String cacheName() {
        return this.cacheName;
    }

    public void cacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public UUID initiatingNodeId() {
        return this.initiatingNodeId;
    }

    public NearCacheConfiguration nearCacheConfiguration() {
        return this.nearCacheCfg;
    }

    public void nearCacheConfiguration(NearCacheConfiguration nearCacheCfg) {
        this.nearCacheCfg = nearCacheCfg;
    }

    public CacheConfiguration startCacheConfiguration() {
        return this.startCfg;
    }

    public void startCacheConfiguration(CacheConfiguration startCfg) {
        this.startCfg = startCfg;
    }

    public void cacheType(CacheType cacheType) {
        this.cacheType = cacheType;
    }

    public CacheType cacheType() {
        return this.cacheType;
    }

    public boolean clientStartOnly() {
        return this.clientStartOnly;
    }

    public void clientStartOnly(boolean clientStartOnly) {
        this.clientStartOnly = clientStartOnly;
    }

    public boolean failIfExists() {
        return this.failIfExists;
    }

    public void failIfExists(boolean failIfExists) {
        this.failIfExists = failIfExists;
    }

    public boolean close() {
        return this.close;
    }

    public void close(boolean close) {
        this.close = close;
    }

    public void receivedFrom(UUID nodeId) {
        this.rcvdFrom = nodeId;
    }

    @Nullable
    public UUID receivedFrom() {
        return this.rcvdFrom;
    }

    public String toString() {
        return S.toString(DynamicCacheChangeRequest.class, this, "cacheName", this.cacheName());
    }
}

