/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheType;
import org.apache.ignite.internal.processors.plugin.CachePluginManager;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class DynamicCacheDescriptor {
    private IgniteUuid deploymentId;
    @GridToStringExclude
    private CacheConfiguration cacheCfg;
    private boolean locCfg;
    private boolean staticCfg;
    private boolean started;
    private CacheType cacheType;
    private volatile Map<UUID, CacheConfiguration> rmtCfgs;
    private boolean template;
    private final CachePluginManager pluginMgr;
    private boolean updatesAllowed = true;
    private AffinityTopologyVersion startTopVer;
    private boolean rcvdOnDiscovery;
    private Integer cacheId;
    private UUID rcvdFrom;
    private AffinityTopologyVersion rcvdFromVer;

    public DynamicCacheDescriptor(GridKernalContext ctx, CacheConfiguration cacheCfg, CacheType cacheType, boolean template, IgniteUuid deploymentId) {
        assert (cacheCfg != null);
        this.cacheCfg = cacheCfg;
        this.cacheType = cacheType;
        this.template = template;
        this.deploymentId = deploymentId;
        this.pluginMgr = new CachePluginManager(ctx, cacheCfg);
        this.cacheId = CU.cacheId(cacheCfg.getName());
    }

    public Integer cacheId() {
        return this.cacheId;
    }

    @Nullable
    public AffinityTopologyVersion startTopologyVersion() {
        return this.startTopVer;
    }

    public void startTopologyVersion(AffinityTopologyVersion startTopVer) {
        this.startTopVer = startTopVer;
    }

    public boolean template() {
        return this.template;
    }

    public CacheType cacheType() {
        return this.cacheType;
    }

    public IgniteUuid deploymentId() {
        return this.deploymentId;
    }

    public void deploymentId(IgniteUuid deploymentId) {
        this.deploymentId = deploymentId;
    }

    public boolean locallyConfigured() {
        return this.locCfg;
    }

    public void locallyConfigured(boolean locCfg) {
        this.locCfg = locCfg;
    }

    public boolean staticallyConfigured() {
        return this.staticCfg;
    }

    public void staticallyConfigured(boolean staticCfg) {
        this.staticCfg = staticCfg;
    }

    public boolean onStart() {
        if (!this.started) {
            this.started = true;
            return true;
        }
        return false;
    }

    public boolean started() {
        return this.started;
    }

    public CacheConfiguration cacheConfiguration() {
        return this.cacheCfg;
    }

    public CachePluginManager pluginManager() {
        return this.pluginMgr;
    }

    public CacheConfiguration remoteConfiguration(UUID nodeId) {
        Map<UUID, CacheConfiguration> cfgs = this.rmtCfgs;
        return cfgs == null ? null : cfgs.get(nodeId);
    }

    public void addRemoteConfiguration(UUID nodeId, CacheConfiguration cfg) {
        Map<UUID, CacheConfiguration> cfgs = this.rmtCfgs;
        if (cfgs == null) {
            this.rmtCfgs = cfgs = new HashMap<UUID, CacheConfiguration>();
        }
        cfgs.put(nodeId, cfg);
    }

    public void clearRemoteConfigurations() {
        this.rmtCfgs = null;
    }

    public boolean updatesAllowed() {
        return this.updatesAllowed;
    }

    public void updatesAllowed(boolean updatesAllowed) {
        this.updatesAllowed = updatesAllowed;
    }

    public boolean receivedOnDiscovery() {
        return this.rcvdOnDiscovery;
    }

    public void receivedOnDiscovery(boolean rcvdOnDiscovery) {
        this.rcvdOnDiscovery = rcvdOnDiscovery;
    }

    public void receivedFrom(UUID nodeId) {
        this.rcvdFrom = nodeId;
    }

    @Nullable
    public AffinityTopologyVersion receivedFromStartVersion() {
        return this.rcvdFromVer;
    }

    public void receivedFromStartVersion(AffinityTopologyVersion rcvdFromVer) {
        this.rcvdFromVer = rcvdFromVer;
    }

    @Nullable
    public UUID receivedFrom() {
        return this.rcvdFrom;
    }

    public String toString() {
        return S.toString(DynamicCacheDescriptor.class, this, "cacheName", U.maskName(this.cacheCfg.getName()));
    }
}

