/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.NearCacheConfiguration;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class GridCacheAttributes
implements Serializable {
    private static final long serialVersionUID = 0L;
    private CacheConfiguration ccfg;

    public GridCacheAttributes(CacheConfiguration cfg) {
        this.ccfg = cfg;
    }

    public GridCacheAttributes() {
    }

    public CacheConfiguration configuration() {
        return this.ccfg;
    }

    public String cacheName() {
        return this.ccfg.getName();
    }

    public CacheMode cacheMode() {
        CacheMode cacheMode = this.ccfg.getCacheMode();
        return cacheMode != null ? cacheMode : CacheConfiguration.DFLT_CACHE_MODE;
    }

    public CacheAtomicityMode atomicityMode() {
        CacheAtomicityMode atomicityMode = this.ccfg.getAtomicityMode();
        return atomicityMode != null ? atomicityMode : CacheConfiguration.DFLT_CACHE_ATOMICITY_MODE;
    }

    public boolean nearCacheEnabled() {
        return this.cacheMode() != CacheMode.LOCAL && this.ccfg.getNearConfiguration() != null;
    }

    public CacheRebalanceMode cacheRebalanceMode() {
        return this.ccfg.getRebalanceMode();
    }

    public String cacheAffinityClassName() {
        return GridCacheAttributes.className(this.ccfg.getAffinity());
    }

    public String cacheAffinityMapperClassName() {
        return GridCacheAttributes.className(this.ccfg.getAffinityMapper());
    }

    public boolean affinityIncludeNeighbors() {
        AffinityFunction aff = this.ccfg.getAffinity();
        return aff instanceof RendezvousAffinityFunction && !((RendezvousAffinityFunction)aff).isExcludeNeighbors();
    }

    public int affinityKeyBackups() {
        return this.ccfg.getBackups();
    }

    public int affinityPartitionsCount() {
        return this.ccfg.getAffinity().partitions();
    }

    public String affinityHashIdResolverClassName() {
        AffinityFunction aff = this.ccfg.getAffinity();
        if (aff instanceof RendezvousAffinityFunction) {
            if (((RendezvousAffinityFunction)aff).getHashIdResolver() == null) {
                return null;
            }
            return GridCacheAttributes.className(((RendezvousAffinityFunction)aff).getHashIdResolver());
        }
        return null;
    }

    public String evictionFilterClassName() {
        return GridCacheAttributes.className(this.ccfg.getEvictionFilter());
    }

    public String evictionPolicyClassName() {
        return GridCacheAttributes.className(this.ccfg.getEvictionPolicy());
    }

    public String nearEvictionPolicyClassName() {
        NearCacheConfiguration nearCfg = this.ccfg.getNearConfiguration();
        if (nearCfg == null) {
            return null;
        }
        return GridCacheAttributes.className(nearCfg.getNearEvictionPolicy());
    }

    public String storeFactoryClassName() {
        return GridCacheAttributes.className(this.ccfg.getCacheStoreFactory());
    }

    @Deprecated
    public String transactionManagerLookupClassName() {
        return this.ccfg.getTransactionManagerLookupClassName();
    }

    public boolean swapEnabled() {
        return this.ccfg.isSwapEnabled();
    }

    public boolean evictSynchronized() {
        return this.ccfg.isEvictSynchronized();
    }

    public float evictMaxOverflowRatio() {
        return this.ccfg.getEvictMaxOverflowRatio();
    }

    public long defaultLockTimeout() {
        return this.ccfg.getDefaultLockTimeout();
    }

    public int rebalanceBatchSize() {
        return this.ccfg.getRebalanceBatchSize();
    }

    public CacheWriteSynchronizationMode writeSynchronization() {
        return this.ccfg.getWriteSynchronizationMode();
    }

    public boolean readThrough() {
        return this.ccfg.isReadThrough();
    }

    public boolean writeThrough() {
        return this.ccfg.isWriteThrough();
    }

    public boolean loadPreviousValue() {
        return this.ccfg.isLoadPreviousValue();
    }

    public boolean writeBehindEnabled() {
        return this.ccfg.isWriteBehindEnabled();
    }

    public int writeBehindFlushSize() {
        return this.ccfg.getWriteBehindFlushSize();
    }

    public long writeBehindFlushFrequency() {
        return this.ccfg.getWriteBehindFlushFrequency();
    }

    public int writeBehindFlushThreadCount() {
        return this.ccfg.getWriteBehindFlushThreadCount();
    }

    public int writeBehindBatchSize() {
        return this.ccfg.getWriteBehindBatchSize();
    }

    public String interceptorClassName() {
        return GridCacheAttributes.className(this.ccfg.getInterceptor());
    }

    @Nullable
    private static String className(@Nullable Object obj) {
        return obj != null ? obj.getClass().getName() : null;
    }

    public String toString() {
        return S.toString(GridCacheAttributes.class, this);
    }
}

