/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Iterator;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridCacheClearAllRunnable<K, V>
implements Runnable {
    protected final GridCacheAdapter<K, V> cache;
    protected final GridCacheVersion obsoleteVer;
    protected final int id;
    protected final int totalCnt;
    protected final boolean readers;
    protected final GridCacheContext<K, V> ctx;
    protected final IgniteLogger log;

    public GridCacheClearAllRunnable(GridCacheAdapter<K, V> cache, GridCacheVersion obsoleteVer, int id, int totalCnt, boolean readers) {
        assert (cache != null);
        assert (obsoleteVer != null);
        assert (id >= 0);
        assert (totalCnt > 0);
        assert (id < totalCnt);
        this.cache = cache;
        this.obsoleteVer = obsoleteVer;
        this.id = id;
        this.totalCnt = totalCnt;
        this.readers = readers;
        this.ctx = cache.context();
        this.log = this.ctx.logger(this.getClass());
    }

    @Override
    public void run() {
        block8: {
            block9: {
                KeyCacheObject key;
                Iterator<KeyCacheObject> it;
                Iterator<GridCacheEntryEx> iter = this.cache.entries().iterator();
                while (iter.hasNext()) {
                    this.clearEntry(iter.next());
                }
                if (this.ctx.isNear()) break block8;
                if (this.ctx.swap().offHeapEnabled()) {
                    it = this.ctx.swap().offHeapKeyIterator(true, true, AffinityTopologyVersion.NONE);
                    while (it.hasNext()) {
                        key = it.next();
                        if (!this.owns(key)) continue;
                        this.clearEntry(this.cache.entryEx(key));
                    }
                }
                if (!this.ctx.swap().swapEnabled()) break block8;
                if (!GridQueryProcessor.isEnabled(this.ctx.config())) break block9;
                it = null;
                try {
                    it = this.ctx.swap().swapKeyIterator(true, true, AffinityTopologyVersion.NONE);
                }
                catch (IgniteCheckedException e) {
                    U.error(this.log, "Failed to get iterator over swap.", e);
                }
                if (it == null) break block8;
                while (it.hasNext()) {
                    key = it.next();
                    if (!this.owns(key)) continue;
                    this.clearEntry(this.cache.entryEx(key));
                }
                break block8;
            }
            if (this.id != 0) break block8;
            try {
                this.ctx.swap().clearSwap();
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Failed to clearLocally entries from swap storage.", e);
            }
        }
    }

    protected void clearEntry(GridCacheEntryEx e) {
        try {
            e.clear(this.obsoleteVer, this.readers);
        }
        catch (IgniteCheckedException ex) {
            U.error(this.log, "Failed to clearLocally entry from cache (will continue to clearLocally other entries): " + e, ex);
        }
    }

    protected boolean owns(KeyCacheObject key) {
        assert (key != null);
        return this.totalCnt == 1 || key.hashCode() % this.totalCnt == this.id;
    }

    public int id() {
        return this.id;
    }

    public int totalCount() {
        return this.totalCnt;
    }

    public boolean readers() {
        return this.readers;
    }

    public String toString() {
        return S.toString(GridCacheClearAllRunnable.class, this);
    }
}

