/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheConcurrentMap;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheMapEntry;
import org.apache.ignite.internal.processors.cache.GridCacheMapEntryFactory;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentHashMap8;

public class GridCacheConcurrentMapImpl
implements GridCacheConcurrentMap {
    private static final float DFLT_LOAD_FACTOR = 0.75f;
    private static final int DFLT_CONCUR_LEVEL = Runtime.getRuntime().availableProcessors() * 2;
    private final ConcurrentMap<KeyCacheObject, GridCacheMapEntry> map;
    private final GridCacheMapEntryFactory factory;
    private final GridCacheContext ctx;
    private final AtomicInteger pubSize = new AtomicInteger();

    public GridCacheConcurrentMapImpl(GridCacheContext ctx, GridCacheMapEntryFactory factory, int initialCapacity) {
        this(ctx, factory, initialCapacity, 0.75f, DFLT_CONCUR_LEVEL);
    }

    public GridCacheConcurrentMapImpl(GridCacheContext ctx, GridCacheMapEntryFactory factory, int initialCapacity, float loadFactor, int concurrencyLevel) {
        this.ctx = ctx;
        this.factory = factory;
        this.map = new ConcurrentHashMap8<KeyCacheObject, GridCacheMapEntry>(initialCapacity, loadFactor, concurrencyLevel);
    }

    @Override
    @Nullable
    public GridCacheMapEntry getEntry(KeyCacheObject key) {
        return (GridCacheMapEntry)this.map.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public GridCacheMapEntry putEntryIfObsoleteOrAbsent(AffinityTopologyVersion topVer, KeyCacheObject key, @Nullable CacheObject val, boolean create, boolean touch) {
        GridCacheMapEntry cur = null;
        GridCacheMapEntry created = null;
        GridCacheMapEntry created0 = null;
        GridCacheMapEntry doomed = null;
        boolean done = false;
        while (!done) {
            GridCacheMapEntry entry = (GridCacheMapEntry)this.map.get(key);
            created = null;
            doomed = null;
            if (entry == null) {
                if (create) {
                    if (created0 == null) {
                        created0 = this.factory.create(this.ctx, topVer, key, key.hashCode(), val);
                    }
                    cur = created = created0;
                    done = this.map.putIfAbsent(created.key(), created) == null;
                    continue;
                }
                done = true;
                continue;
            }
            if (entry.obsolete()) {
                doomed = entry;
                if (create) {
                    if (created0 == null) {
                        created0 = this.factory.create(this.ctx, topVer, key, key.hashCode(), val);
                    }
                    cur = created = created0;
                    done = this.map.replace(entry.key(), doomed, created);
                    continue;
                }
                done = this.map.remove(entry.key(), doomed);
                continue;
            }
            cur = entry;
            done = true;
        }
        int sizeChange = 0;
        if (doomed != null) {
            GridCacheMapEntry gridCacheMapEntry = doomed;
            synchronized (gridCacheMapEntry) {
                if (!doomed.deleted()) {
                    --sizeChange;
                }
            }
            if (this.ctx.events().isRecordable(61)) {
                this.ctx.events().addEvent(doomed.partition(), doomed.key(), this.ctx.localNodeId(), (IgniteUuid)null, null, 61, null, false, null, false, null, null, null, true);
            }
        }
        if (created != null) {
            ++sizeChange;
            if (this.ctx.events().isRecordable(60)) {
                this.ctx.events().addEvent(created.partition(), created.key(), this.ctx.localNodeId(), (IgniteUuid)null, null, 60, null, false, null, false, null, null, null, true);
            }
            if (touch) {
                this.ctx.evicts().touch(cur, topVer);
            }
        }
        if (sizeChange != 0) {
            this.pubSize.addAndGet(sizeChange);
        }
        return cur;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeEntry(GridCacheEntryEx entry) {
        boolean removed = this.map.remove(entry.key(), entry);
        if (removed) {
            if (this.ctx.events().isRecordable(61)) {
                this.ctx.events().addEvent(entry.partition(), entry.key(), this.ctx.localNodeId(), (IgniteUuid)null, null, 61, null, false, null, false, null, null, null, false);
            }
            GridCacheEntryEx gridCacheEntryEx = entry;
            synchronized (gridCacheEntryEx) {
                if (!entry.deleted()) {
                    this.decrementPublicSize(entry);
                }
            }
        }
        return removed;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public int publicSize() {
        return this.pubSize.get();
    }

    @Override
    public void incrementPublicSize(GridCacheEntryEx e) {
        this.pubSize.incrementAndGet();
    }

    @Override
    public void decrementPublicSize(GridCacheEntryEx e) {
        this.pubSize.decrementAndGet();
    }

    @Override
    public Set<KeyCacheObject> keySet(final CacheEntryPredicate ... filter) {
        final IgnitePredicate<KeyCacheObject> p = new IgnitePredicate<KeyCacheObject>(){

            @Override
            public boolean apply(KeyCacheObject key) {
                GridCacheMapEntry entry = (GridCacheMapEntry)GridCacheConcurrentMapImpl.this.map.get(key);
                return entry != null && entry.visitable(filter);
            }
        };
        return new AbstractSet<KeyCacheObject>(){

            @Override
            public Iterator<KeyCacheObject> iterator() {
                return F.iterator0(GridCacheConcurrentMapImpl.this.map.keySet(), true, p);
            }

            @Override
            public int size() {
                return F.size(this.iterator(), new IgnitePredicate[0]);
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof KeyCacheObject)) {
                    return false;
                }
                return GridCacheConcurrentMapImpl.this.map.keySet().contains(o) && p.apply((KeyCacheObject)o);
            }
        };
    }

    public Collection<GridCacheMapEntry> entries(final CacheEntryPredicate ... filter) {
        IgnitePredicate<GridCacheMapEntry> p = new IgnitePredicate<GridCacheMapEntry>(){

            @Override
            public boolean apply(GridCacheMapEntry entry) {
                return entry.visitable(filter);
            }
        };
        return F.viewReadOnly(this.map.values(), F.identity(), p);
    }

    public Collection<GridCacheMapEntry> allEntries(final CacheEntryPredicate ... filter) {
        IgnitePredicate<GridCacheMapEntry> p = new IgnitePredicate<GridCacheMapEntry>(){

            @Override
            public boolean apply(GridCacheMapEntry entry) {
                return F.isAll(entry, filter);
            }
        };
        return F.viewReadOnly(this.map.values(), F.identity(), p);
    }

    @Override
    @Deprecated
    @Nullable
    public GridCacheMapEntry randomEntry() {
        Iterator iterator = this.map.values().iterator();
        if (iterator.hasNext()) {
            return (GridCacheMapEntry)iterator.next();
        }
        return null;
    }

    @Override
    public Set<GridCacheMapEntry> entrySet(final CacheEntryPredicate ... filter) {
        final IgnitePredicate<GridCacheMapEntry> p = new IgnitePredicate<GridCacheMapEntry>(){

            @Override
            public boolean apply(GridCacheMapEntry entry) {
                return entry.visitable(filter);
            }
        };
        return new AbstractSet<GridCacheMapEntry>(){

            @Override
            public Iterator<GridCacheMapEntry> iterator() {
                return F.iterator0(GridCacheConcurrentMapImpl.this.map.values(), true, p);
            }

            @Override
            public int size() {
                return F.size(this.iterator(), new IgnitePredicate[0]);
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof GridCacheMapEntry)) {
                    return false;
                }
                GridCacheMapEntry entry = (GridCacheMapEntry)o;
                return entry.equals(GridCacheConcurrentMapImpl.this.map.get(entry.key())) && p.apply(entry);
            }
        };
    }
}

