/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import javax.cache.Cache;
import javax.cache.configuration.Factory;
import javax.cache.expiry.EternalExpiryPolicy;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.processor.EntryProcessorResult;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMemoryMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityKeyMapper;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.managers.communication.GridIoManager;
import org.apache.ignite.internal.managers.deployment.GridDeploymentManager;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.managers.eventstorage.GridEventStorageManager;
import org.apache.ignite.internal.managers.swapspace.GridSwapSpaceManager;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheConflictResolutionManager;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicateContainsValue;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicateHasValue;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicateNoValue;
import org.apache.ignite.internal.processors.cache.CacheEntrySerializablePredicate;
import org.apache.ignite.internal.processors.cache.CacheInvokeResult;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.CacheOperationContext;
import org.apache.ignite.internal.processors.cache.CacheType;
import org.apache.ignite.internal.processors.cache.CacheWeakQueryIteratorsHolder;
import org.apache.ignite.internal.processors.cache.EntryGetResult;
import org.apache.ignite.internal.processors.cache.EntryGetWithTtlResult;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheAffinityManager;
import org.apache.ignite.internal.processors.cache.GridCacheDeploymentManager;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheEventManager;
import org.apache.ignite.internal.processors.cache.GridCacheEvictionManager;
import org.apache.ignite.internal.processors.cache.GridCacheGateway;
import org.apache.ignite.internal.processors.cache.GridCacheIoManager;
import org.apache.ignite.internal.processors.cache.GridCacheLogger;
import org.apache.ignite.internal.processors.cache.GridCacheManager;
import org.apache.ignite.internal.processors.cache.GridCacheMapEntry;
import org.apache.ignite.internal.processors.cache.GridCacheMvccCandidate;
import org.apache.ignite.internal.processors.cache.GridCacheMvccManager;
import org.apache.ignite.internal.processors.cache.GridCachePreloader;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.GridCacheSwapManager;
import org.apache.ignite.internal.processors.cache.GridCacheTtlManager;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.datastructures.CacheDataStructuresManager;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTopologyFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTransactionalCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.colocated.GridDhtColocatedCache;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTransactionalCache;
import org.apache.ignite.internal.processors.cache.dr.GridCacheDrManager;
import org.apache.ignite.internal.processors.cache.jta.CacheJtaManagerAdapter;
import org.apache.ignite.internal.processors.cache.local.GridLocalCache;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryManager;
import org.apache.ignite.internal.processors.cache.query.continuous.CacheContinuousQueryManager;
import org.apache.ignite.internal.processors.cache.store.CacheStoreManager;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxManager;
import org.apache.ignite.internal.processors.cache.version.CacheVersionConflictResolver;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionConflictContext;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionManager;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionedEntryEx;
import org.apache.ignite.internal.processors.cacheobject.IgniteCacheObjectProcessor;
import org.apache.ignite.internal.processors.closure.GridClosureProcessor;
import org.apache.ignite.internal.processors.offheap.GridOffHeapProcessor;
import org.apache.ignite.internal.processors.plugin.CachePluginManager;
import org.apache.ignite.internal.processors.timeout.GridTimeoutProcessor;
import org.apache.ignite.internal.util.F0;
import org.apache.ignite.internal.util.offheap.unsafe.GridUnsafeMemory;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.GPC;
import org.apache.ignite.internal.util.typedef.internal.GPR;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.plugin.security.SecurityException;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.jetbrains.annotations.Nullable;

@GridToStringExclude
public class GridCacheContext<K, V>
implements Externalizable {
    private static final long serialVersionUID = 0L;
    private static final ThreadLocal<IgniteBiTuple<String, String>> stash = new ThreadLocal<IgniteBiTuple<String, String>>(){

        @Override
        protected IgniteBiTuple<String, String> initialValue() {
            return new IgniteBiTuple<String, String>();
        }
    };
    private static final GridCacheVersion[] EMPTY_VERSION = new GridCacheVersion[0];
    private GridKernalContext ctx;
    private GridCacheSharedContext<K, V> sharedCtx;
    private IgniteLogger log;
    private CacheConfiguration cacheCfg;
    private GridUnsafeMemory unsafeMemory;
    private GridCacheAffinityManager affMgr;
    private GridCacheEventManager evtMgr;
    private GridCacheQueryManager<K, V> qryMgr;
    private CacheContinuousQueryManager contQryMgr;
    private GridCacheSwapManager swapMgr;
    private GridCacheEvictionManager evictMgr;
    private CacheDataStructuresManager dataStructuresMgr;
    private GridCacheTtlManager ttlMgr;
    private CacheStoreManager storeMgr;
    private GridCacheDrManager drMgr;
    private CacheConflictResolutionManager rslvrMgr;
    private CachePluginManager pluginMgr;
    private List<GridCacheManager<K, V>> mgrs = new LinkedList<GridCacheManager<K, V>>();
    private GridCacheGateway<K, V> gate;
    private GridCacheAdapter<K, V> cache;
    private ClusterNode locNode;
    private ThreadLocal<CacheOperationContext> opCtxPerCall = new ThreadLocal();
    private String cacheName;
    private int cacheId;
    private CacheType cacheType;
    private byte plc;
    private ExpiryPolicy expiryPlc;
    private CacheWeakQueryIteratorsHolder<Map.Entry<K, V>> itHolder;
    private boolean affNode;
    private CacheVersionConflictResolver conflictRslvr;
    private CacheObjectContext cacheObjCtx;
    private CountDownLatch startLatch = new CountDownLatch(1);
    private AffinityTopologyVersion startTopVer;
    private IgniteUuid dynamicDeploymentId;
    private boolean updatesAllowed;
    private boolean depEnabled;
    private boolean deferredDel;
    private boolean customAffMapper;

    public GridCacheContext() {
    }

    public GridCacheContext(GridKernalContext ctx, GridCacheSharedContext sharedCtx, CacheConfiguration cacheCfg, CacheType cacheType, boolean affNode, boolean updatesAllowed, GridCacheEventManager evtMgr, GridCacheSwapManager swapMgr, CacheStoreManager storeMgr, GridCacheEvictionManager evictMgr, GridCacheQueryManager<K, V> qryMgr, CacheContinuousQueryManager contQryMgr, CacheDataStructuresManager dataStructuresMgr, GridCacheTtlManager ttlMgr, GridCacheDrManager drMgr, CacheConflictResolutionManager<K, V> rslvrMgr, CachePluginManager pluginMgr, GridCacheAffinityManager affMgr) {
        assert (ctx != null);
        assert (sharedCtx != null);
        assert (cacheCfg != null);
        assert (evtMgr != null);
        assert (swapMgr != null);
        assert (storeMgr != null);
        assert (evictMgr != null);
        assert (qryMgr != null);
        assert (contQryMgr != null);
        assert (affMgr != null);
        assert (dataStructuresMgr != null);
        assert (ttlMgr != null);
        assert (rslvrMgr != null);
        assert (pluginMgr != null);
        this.ctx = ctx;
        this.sharedCtx = sharedCtx;
        this.cacheCfg = cacheCfg;
        this.cacheType = cacheType;
        this.affNode = affNode;
        this.updatesAllowed = updatesAllowed;
        this.depEnabled = ctx.deploy().enabled() && !this.cacheObjects().isBinaryEnabled(cacheCfg);
        this.evtMgr = this.add(evtMgr);
        this.swapMgr = this.add(swapMgr);
        this.storeMgr = this.add(storeMgr);
        this.evictMgr = this.add(evictMgr);
        this.qryMgr = this.add(qryMgr);
        this.contQryMgr = this.add(contQryMgr);
        this.dataStructuresMgr = this.add(dataStructuresMgr);
        this.ttlMgr = this.add(ttlMgr);
        this.drMgr = this.add(drMgr);
        this.rslvrMgr = this.add(rslvrMgr);
        this.pluginMgr = this.add(pluginMgr);
        this.affMgr = this.add(affMgr);
        this.log = ctx.log(this.getClass());
        this.unsafeMemory = cacheCfg.getMemoryMode() == CacheMemoryMode.OFFHEAP_VALUES || cacheCfg.getMemoryMode() == CacheMemoryMode.OFFHEAP_TIERED ? new GridUnsafeMemory(cacheCfg.getOffHeapMaxMemory()) : null;
        this.gate = new GridCacheGateway(this);
        this.cacheName = cacheCfg.getName();
        this.cacheId = CU.cacheId(this.cacheName);
        this.plc = cacheType.ioPolicy();
        Factory<ExpiryPolicy> factory = cacheCfg.getExpiryPolicyFactory();
        ExpiryPolicy expiryPolicy = this.expiryPlc = factory != null ? factory.create() : null;
        if (this.expiryPlc instanceof EternalExpiryPolicy) {
            this.expiryPlc = null;
        }
        this.itHolder = new CacheWeakQueryIteratorsHolder(this.log);
    }

    public boolean customAffinityMapper() {
        return this.customAffMapper;
    }

    void dynamicDeploymentId(IgniteUuid dynamicDeploymentId) {
        this.dynamicDeploymentId = dynamicDeploymentId;
    }

    public IgniteUuid dynamicDeploymentId() {
        return this.dynamicDeploymentId;
    }

    void initConflictResolver() {
        this.conflictRslvr = this.rslvrMgr.conflictResolver();
    }

    public boolean affinityNode() {
        return this.affNode;
    }

    public void awaitStarted() throws IgniteCheckedException {
        U.await(this.startLatch);
        GridCachePreloader prldr = this.preloader();
        if (prldr != null) {
            prldr.startFuture().get();
        }
    }

    public boolean started() {
        if (this.startLatch.getCount() != 0L) {
            return false;
        }
        GridCachePreloader prldr = this.preloader();
        return prldr == null || prldr.startFuture().isDone();
    }

    public void onStarted() {
        this.startLatch.countDown();
    }

    public AffinityTopologyVersion startTopologyVersion() {
        return this.startTopVer;
    }

    public void startTopologyVersion(AffinityTopologyVersion startTopVer) {
        this.startTopVer = startTopVer;
    }

    @Nullable
    public ExpiryPolicy expiry() {
        return this.expiryPlc;
    }

    @Nullable
    public ExpiryPolicy expiryForTxEntry(IgniteTxEntry txEntry) {
        ExpiryPolicy plc = txEntry.expiry();
        return plc != null ? plc : this.expiryPlc;
    }

    @Nullable
    private <T extends GridCacheManager<K, V>> T add(@Nullable T mgr) {
        if (mgr != null) {
            this.mgrs.add(mgr);
        }
        return mgr;
    }

    public List<GridCacheManager<K, V>> managers() {
        return this.mgrs;
    }

    public GridCacheSharedContext<K, V> shared() {
        return this.sharedCtx;
    }

    public int cacheId() {
        return this.cacheId;
    }

    public boolean systemTx() {
        return this.cacheType == CacheType.UTILITY || this.cacheType == CacheType.INTERNAL && this.transactional();
    }

    public boolean userCache() {
        return this.cacheType.userCache();
    }

    public byte ioPolicy() {
        return this.plc;
    }

    public void cache(GridCacheAdapter<K, V> cache) {
        this.cache = cache;
        this.deferredDel = cache.isDht() || cache.isDhtAtomic() || cache.isColocated() || cache.isNear() && cache.configuration().getAtomicityMode() == CacheAtomicityMode.ATOMIC;
    }

    public GridLocalCache<K, V> local() {
        return (GridLocalCache)this.cache;
    }

    public boolean isDht() {
        return this.cache != null && this.cache.isDht();
    }

    public boolean isDhtAtomic() {
        return this.cache != null && this.cache.isDhtAtomic();
    }

    public boolean isColocated() {
        return this.cache != null && this.cache.isColocated();
    }

    public boolean isNear() {
        return this.cache != null && this.cache.isNear();
    }

    public boolean isLocal() {
        return this.cache != null && this.cache.isLocal();
    }

    public boolean isReplicated() {
        return this.cacheCfg.getCacheMode() == CacheMode.REPLICATED;
    }

    public boolean isPartitioned() {
        return this.cacheCfg.getCacheMode() == CacheMode.PARTITIONED;
    }

    public boolean isDrEnabled() {
        return this.dr().enabled();
    }

    public boolean deferredDelete() {
        return this.deferredDel;
    }

    public void incrementPublicSize(GridCacheMapEntry e) {
        assert (this.deferredDelete());
        assert (e != null);
        assert (!e.isInternal()) : e;
        this.cache.incrementSize(e);
    }

    public void decrementPublicSize(GridCacheMapEntry e) {
        assert (this.deferredDelete());
        assert (e != null);
        assert (!e.isInternal()) : e;
        this.cache.decrementSize(e);
    }

    public GridDhtCacheAdapter<K, V> dht() {
        return (GridDhtCacheAdapter)this.cache;
    }

    public GridDhtTransactionalCacheAdapter<K, V> dhtTx() {
        return (GridDhtTransactionalCacheAdapter)this.cache;
    }

    public GridDhtColocatedCache<K, V> colocated() {
        return (GridDhtColocatedCache)this.cache;
    }

    public GridNearCacheAdapter<K, V> near() {
        return (GridNearCacheAdapter)this.cache;
    }

    public GridNearTransactionalCache<K, V> nearTx() {
        return (GridNearTransactionalCache)this.cache;
    }

    public GridCacheGateway<K, V> gate() {
        return this.gate;
    }

    @Nullable
    public GridUnsafeMemory unsafeMemory() {
        return this.unsafeMemory;
    }

    public GridKernalContext kernalContext() {
        return this.ctx;
    }

    public IgniteEx grid() {
        return this.ctx.grid();
    }

    public String gridName() {
        return this.ctx.gridName();
    }

    public String name() {
        return this.cacheName;
    }

    public String namex() {
        return this.isDht() ? this.dht().near().name() : this.name();
    }

    public String namexx() {
        String name = this.namex();
        return name == null ? "default" : name;
    }

    public IgniteTxKey txKey(KeyCacheObject key) {
        return new IgniteTxKey(key, this.cacheId);
    }

    public void checkSecurity(SecurityPermission op) throws SecurityException {
        if (CU.isSystemCache(this.name())) {
            return;
        }
        this.ctx.security().authorize(this.name(), op, null);
    }

    public GridCachePreloader preloader() {
        return this.cache().preloader();
    }

    public UUID nodeId() {
        return this.ctx.localNodeId();
    }

    public boolean rebalanceEnabled() {
        return this.cacheCfg.getRebalanceMode() != CacheRebalanceMode.NONE;
    }

    public boolean atomic() {
        return this.cacheCfg.getAtomicityMode() == CacheAtomicityMode.ATOMIC;
    }

    public boolean transactional() {
        return this.cacheCfg.getAtomicityMode() == CacheAtomicityMode.TRANSACTIONAL;
    }

    public ClusterNode localNode() {
        if (this.locNode == null) {
            this.locNode = this.ctx.discovery().localNode();
        }
        return this.locNode;
    }

    public UUID localNodeId() {
        return this.ctx.localNodeId();
    }

    public boolean isLocalNode(ClusterNode n) {
        assert (n != null);
        return this.localNode().id().equals(n.id());
    }

    public boolean isLocalNode(UUID id) {
        assert (id != null);
        return this.localNode().id().equals(id);
    }

    @Nullable
    public ClusterNode node(UUID nodeId) {
        assert (nodeId != null);
        return this.ctx.discovery().node(nodeId);
    }

    public GridDhtPartitionTopology topology() {
        GridCacheAdapter<K, V> cache = this.cache;
        if (cache == null) {
            throw new IllegalStateException("Cache stopped: " + this.cacheName);
        }
        assert (cache.isNear() || cache.isDht() || cache.isColocated() || cache.isDhtAtomic()) : cache;
        return this.topology(cache);
    }

    public GridDhtTopologyFuture topologyVersionFuture() {
        GridCacheAdapter<K, V> cache = this.cache;
        if (cache == null) {
            throw new IllegalStateException("Cache stopped: " + this.cacheName);
        }
        assert (cache.isNear() || cache.isDht() || cache.isColocated() || cache.isDhtAtomic()) : cache;
        return this.topology(cache).topologyVersionFuture();
    }

    private GridDhtPartitionTopology topology(GridCacheAdapter<K, V> cache) {
        return cache.isNear() ? ((GridNearCacheAdapter)cache).dht().topology() : ((GridDhtCacheAdapter)cache).topology();
    }

    public Marshaller marshaller() {
        return this.ctx.config().getMarshaller();
    }

    public IgniteLogger logger(String ctgr) {
        return new GridCacheLogger(this, ctgr);
    }

    public IgniteLogger logger(Class<?> cls) {
        return this.logger(cls.getName());
    }

    public IgniteConfiguration gridConfig() {
        return this.ctx.config();
    }

    public GridIoManager gridIO() {
        return this.ctx.io();
    }

    public GridTimeoutProcessor time() {
        return this.ctx.timeout();
    }

    public GridOffHeapProcessor offheap() {
        return this.ctx.offheap();
    }

    public GridDeploymentManager gridDeploy() {
        return this.ctx.deploy();
    }

    public GridSwapSpaceManager gridSwap() {
        return this.ctx.swap();
    }

    public GridEventStorageManager gridEvents() {
        return this.ctx.event();
    }

    public GridClosureProcessor closures() {
        return this.ctx.closure();
    }

    public GridDiscoveryManager discovery() {
        return this.ctx.discovery();
    }

    public GridCacheAdapter<K, V> cache() {
        return this.cache;
    }

    public CacheConfiguration config() {
        return this.cacheCfg;
    }

    public boolean writeToStoreFromDht() {
        return this.store().isLocal() || this.cacheCfg.isWriteBehindEnabled();
    }

    public IgniteTxManager tm() {
        return this.sharedCtx.tm();
    }

    public GridCacheVersionManager versions() {
        return this.sharedCtx.versions();
    }

    public GridCacheMvccManager mvcc() {
        return this.sharedCtx.mvcc();
    }

    public GridCacheEventManager events() {
        return this.evtMgr;
    }

    public GridCacheAffinityManager affinity() {
        return this.affMgr;
    }

    public GridCacheQueryManager<K, V> queries() {
        return this.qryMgr;
    }

    public CacheContinuousQueryManager continuousQueries() {
        return this.contQryMgr;
    }

    public CacheWeakQueryIteratorsHolder<Map.Entry<K, V>> itHolder() {
        return this.itHolder;
    }

    public GridCacheSwapManager swap() {
        return this.swapMgr;
    }

    public CacheStoreManager store() {
        return this.storeMgr;
    }

    public GridCacheDeploymentManager<K, V> deploy() {
        return this.sharedCtx.deploy();
    }

    public GridCacheIoManager io() {
        return this.sharedCtx.io();
    }

    public GridCacheEvictionManager evicts() {
        return this.evictMgr;
    }

    public CacheDataStructuresManager dataStructures() {
        return this.dataStructuresMgr;
    }

    public GridCacheDrManager dr() {
        return this.drMgr;
    }

    public GridCacheTtlManager ttl() {
        return this.ttlMgr;
    }

    public CacheJtaManagerAdapter jta() {
        return this.sharedCtx.jta();
    }

    public CachePluginManager plugin() {
        return this.pluginMgr;
    }

    public boolean putIfAbsentFilter(@Nullable CacheEntryPredicate[] p) {
        if (p == null || p.length == 0) {
            return false;
        }
        for (CacheEntryPredicate p0 : p) {
            if (!(p0 instanceof CacheEntrySerializablePredicate) || !(((CacheEntrySerializablePredicate)p0).predicate() instanceof CacheEntryPredicateNoValue)) continue;
            return true;
        }
        return false;
    }

    public CacheEntryPredicate noVal() {
        return new CacheEntrySerializablePredicate(new CacheEntryPredicateNoValue());
    }

    public CacheEntryPredicate hasVal() {
        return new CacheEntrySerializablePredicate(new CacheEntryPredicateHasValue());
    }

    public CacheEntryPredicate equalsVal(V val) {
        return new CacheEntryPredicateContainsValue(this.toCacheObject(val));
    }

    public GridCacheVersion[] emptyVersion() {
        return EMPTY_VERSION;
    }

    public AffinityKeyMapper defaultAffMapper() {
        return this.cacheObjCtx.defaultAffMapper();
    }

    public void cacheObjectContext(CacheObjectContext cacheObjCtx) {
        this.cacheObjCtx = cacheObjCtx;
        this.customAffMapper = this.cacheCfg.getAffinityMapper().getClass() != cacheObjCtx.defaultAffMapper().getClass();
    }

    public IgnitePredicate<Cache.Entry<K, V>>[] vararg(IgnitePredicate<Cache.Entry<K, V>> p) {
        IgnitePredicate<Cache.Entry<K, V>>[] ignitePredicateArray;
        if (p == null) {
            ignitePredicateArray = CU.empty();
        } else {
            IgnitePredicate[] ignitePredicateArray2 = new IgnitePredicate[1];
            ignitePredicateArray = ignitePredicateArray2;
            ignitePredicateArray2[0] = p;
        }
        return ignitePredicateArray;
    }

    public <K1, V1> boolean isAll(GridCacheEntryEx e, @Nullable IgnitePredicate<Cache.Entry<K1, V1>>[] p) throws IgniteCheckedException {
        return F.isEmpty(p) || this.isAll(e.wrapLazyValue(this.keepBinary()), p);
    }

    public <E> boolean isAll(E e, @Nullable IgnitePredicate<? super E>[] p) throws IgniteCheckedException {
        if (F.isEmpty(p)) {
            return true;
        }
        try {
            boolean pass = F.isAll(e, p);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Evaluated filters for entry [pass=" + pass + ", entry=" + e + ", filters=" + Arrays.toString(p) + ']');
            }
            return pass;
        }
        catch (RuntimeException ex) {
            throw U.cast(ex);
        }
    }

    public boolean isAll(GridCacheEntryEx e, CacheEntryPredicate[] p) throws IgniteCheckedException {
        if (p == null || p.length == 0) {
            return true;
        }
        try {
            for (CacheEntryPredicate p0 : p) {
                if (p0 == null || p0.apply(e)) continue;
                return false;
            }
        }
        catch (RuntimeException ex) {
            throw U.cast(ex);
        }
        return true;
    }

    public boolean isAllLocked(GridCacheEntryEx e, CacheEntryPredicate[] p) throws IgniteCheckedException {
        if (p == null || p.length == 0) {
            return true;
        }
        try {
            for (CacheEntryPredicate p0 : p) {
                if (p0 == null) continue;
                p0.entryLocked(true);
                if (p0.apply(e)) continue;
                boolean bl = false;
                return bl;
            }
        }
        catch (RuntimeException ex) {
            throw U.cast(ex);
        }
        finally {
            for (CacheEntryPredicate p0 : p) {
                if (p0 == null) continue;
                p0.entryLocked(false);
            }
        }
        return true;
    }

    public void operationContextPerCall(@Nullable CacheOperationContext opCtx) {
        if (this.nearContext()) {
            this.dht().near().context().opCtxPerCall.set(opCtx);
        } else {
            this.opCtxPerCall.set(opCtx);
        }
    }

    public CacheOperationContext operationContextPerCall() {
        return this.nearContext() ? this.dht().near().context().opCtxPerCall.get() : this.opCtxPerCall.get();
    }

    public UUID subjectIdPerCall(@Nullable UUID subjId) {
        if (subjId != null) {
            return subjId;
        }
        return this.subjectIdPerCall(subjId, this.operationContextPerCall());
    }

    public UUID subjectIdPerCall(@Nullable UUID subjId, @Nullable CacheOperationContext opCtx) {
        if (opCtx != null) {
            subjId = opCtx.subjectId();
        }
        if (subjId == null) {
            subjId = this.ctx.localNodeId();
        }
        return subjId;
    }

    public boolean skipStore() {
        if (this.nearContext()) {
            return this.dht().near().context().skipStore();
        }
        CacheOperationContext opCtx = this.opCtxPerCall.get();
        return opCtx != null && opCtx.skipStore();
    }

    private boolean nearContext() {
        return this.isDht() || this.isDhtAtomic() && this.dht().near() != null;
    }

    public Runnable projectSafe(final Runnable r) {
        assert (r != null);
        final CacheOperationContext opCtx = this.operationContextPerCall();
        if (opCtx == null) {
            return r;
        }
        return new GPR(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CacheOperationContext old = GridCacheContext.this.operationContextPerCall();
                GridCacheContext.this.operationContextPerCall(opCtx);
                try {
                    r.run();
                }
                finally {
                    GridCacheContext.this.operationContextPerCall(old);
                }
            }
        };
    }

    public <T> Callable<T> projectSafe(final Callable<T> r) {
        assert (r != null);
        final CacheOperationContext opCtx = this.operationContextPerCall();
        if (opCtx == null) {
            return r;
        }
        return new GPC<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T call() throws Exception {
                CacheOperationContext old = GridCacheContext.this.operationContextPerCall();
                GridCacheContext.this.operationContextPerCall(opCtx);
                try {
                    Object v = r.call();
                    return v;
                }
                finally {
                    GridCacheContext.this.operationContextPerCall(old);
                }
            }
        };
    }

    public boolean deploymentEnabled() {
        return this.depEnabled;
    }

    public boolean isSwapOrOffheapEnabled() {
        return this.swapMgr.swapEnabled() || this.isOffHeapEnabled();
    }

    public boolean isOffHeapEnabled() {
        return this.swapMgr.offHeapEnabled();
    }

    public boolean readThrough() {
        return this.cacheCfg.isReadThrough() && !this.skipStore();
    }

    public boolean readThroughConfigured() {
        return this.store().configured() && this.cacheCfg.isReadThrough();
    }

    public boolean loadPreviousValue() {
        return this.cacheCfg.isLoadPreviousValue();
    }

    public boolean writeThrough() {
        return this.cacheCfg.isWriteThrough() && !this.skipStore();
    }

    public boolean isInvalidate() {
        return this.cacheCfg.isInvalidate();
    }

    public boolean syncCommit() {
        return this.cacheCfg.getWriteSynchronizationMode() == CacheWriteSynchronizationMode.FULL_SYNC;
    }

    public boolean syncRollback() {
        return this.cacheCfg.getWriteSynchronizationMode() == CacheWriteSynchronizationMode.FULL_SYNC;
    }

    public boolean syncPrimary() {
        return this.cacheCfg.getWriteSynchronizationMode() == CacheWriteSynchronizationMode.PRIMARY_SYNC;
    }

    public void dhtMap(UUID nearNodeId, AffinityTopologyVersion topVer, GridDhtCacheEntry entry, GridCacheVersion explicitLockVer, IgniteLogger log, Map<ClusterNode, List<GridDhtCacheEntry>> dhtMap, @Nullable Map<ClusterNode, List<GridDhtCacheEntry>> nearMap) throws GridCacheEntryRemovedException {
        assert (!AffinityTopologyVersion.NONE.equals(topVer));
        List<ClusterNode> dhtNodes = this.dht().topology().nodes(entry.partition(), topVer);
        if (log.isDebugEnabled()) {
            log.debug("Mapping entry to DHT nodes [nodes=" + U.nodeIds(dhtNodes) + ", entry=" + entry + ']');
        }
        Collection<ClusterNode> dhtRemoteNodes = F.view(dhtNodes, F.remoteNodes(this.nodeId()));
        this.map(entry, dhtRemoteNodes, dhtMap);
        Collection<ClusterNode> nearRemoteNodes = null;
        if (nearMap != null) {
            Collection<UUID> readers = entry.readers();
            Collection<ClusterNode> nearNodes = null;
            if (!F.isEmpty(readers)) {
                nearNodes = this.discovery().nodes(readers, F0.notEqualTo(nearNodeId));
                if (log.isDebugEnabled()) {
                    log.debug("Mapping entry to near nodes [nodes=" + U.nodeIds(nearNodes) + ", entry=" + entry + ']');
                }
            } else if (log.isDebugEnabled()) {
                log.debug("Entry has no near readers: " + entry);
            }
            if (nearNodes != null && !nearNodes.isEmpty()) {
                nearRemoteNodes = F.view(nearNodes, F.notIn(dhtNodes));
                this.map(entry, nearRemoteNodes, nearMap);
            }
        }
        if (explicitLockVer != null) {
            ArrayList<ClusterNode> dhtNodeIds = new ArrayList<ClusterNode>(dhtRemoteNodes);
            ArrayList<ClusterNode> nearNodeIds = F.isEmpty(nearRemoteNodes) ? null : new ArrayList<ClusterNode>(nearRemoteNodes);
            entry.mappings(explicitLockVer, dhtNodeIds, nearNodeIds);
        }
    }

    public void dhtMap(GridDhtCacheEntry entry, GridCacheVersion explicitLockVer, IgniteLogger log, Map<ClusterNode, List<GridDhtCacheEntry>> dhtMap, Map<ClusterNode, List<GridDhtCacheEntry>> nearMap) throws GridCacheEntryRemovedException {
        assert (explicitLockVer != null);
        GridCacheMvccCandidate cand = entry.candidate(explicitLockVer);
        if (cand != null) {
            Collection<ClusterNode> dhtNodes = cand.mappedDhtNodes();
            if (log.isDebugEnabled()) {
                log.debug("Mapping explicit lock to DHT nodes [nodes=" + U.nodeIds(dhtNodes) + ", entry=" + entry + ']');
            }
            Collection<ClusterNode> nearNodes = cand.mappedNearNodes();
            this.map(entry, dhtNodes, dhtMap);
            if (nearNodes != null && !nearNodes.isEmpty()) {
                this.map(entry, nearNodes, nearMap);
            }
        }
    }

    private void map(GridDhtCacheEntry entry, Iterable<ClusterNode> nodes, Map<ClusterNode, List<GridDhtCacheEntry>> map) {
        if (nodes != null) {
            for (ClusterNode n : nodes) {
                List<GridDhtCacheEntry> entries = map.get(n);
                if (entries == null) {
                    entries = new LinkedList<GridDhtCacheEntry>();
                    map.put(n, entries);
                }
                entries.add(entry);
            }
        }
    }

    public boolean conflictNeedResolve() {
        return this.conflictRslvr != null;
    }

    public GridCacheVersionConflictContext<K, V> conflictResolve(GridCacheVersionedEntryEx<K, V> oldEntry, GridCacheVersionedEntryEx<K, V> newEntry, boolean atomicVerComp) throws IgniteCheckedException {
        assert (this.conflictRslvr != null) : "Should not reach this place.";
        GridCacheVersionConflictContext<K, V> ctx = this.conflictRslvr.resolve(oldEntry, newEntry, atomicVerComp);
        if (ctx.isManualResolve()) {
            this.drMgr.onReceiveCacheConflictResolved(ctx.isUseNew(), ctx.isUseOld(), ctx.isMerge());
        }
        return ctx;
    }

    public byte dataCenterId() {
        return this.dr().dataCenterId();
    }

    public void onDeferredDelete(GridCacheEntryEx entry, GridCacheVersion ver) {
        assert (entry != null);
        assert (!Thread.holdsLock(entry)) : entry;
        assert (ver != null);
        assert (this.deferredDelete()) : this.cache;
        this.cache.onDeferredDelete(entry, ver);
    }

    public boolean cancelRemove(@Nullable IgniteBiTuple<Boolean, ?> interceptorRes) {
        if (interceptorRes != null) {
            if (interceptorRes.get1() == null) {
                U.warn(this.log, "CacheInterceptor must not return null as cancellation flag value from 'onBeforeRemove' method.");
                return false;
            }
            return interceptorRes.get1();
        }
        U.warn(this.log, "CacheInterceptor must not return null from 'onBeforeRemove' method.");
        return false;
    }

    public IgniteCacheObjectProcessor cacheObjects() {
        return this.kernalContext().cacheObjects();
    }

    public boolean binaryMarshaller() {
        return this.marshaller() instanceof BinaryMarshaller;
    }

    public boolean keepBinary() {
        CacheOperationContext opCtx = this.operationContextPerCall();
        return opCtx != null && opCtx.isKeepBinary();
    }

    public boolean offheapTiered() {
        return this.cacheCfg != null && this.cacheCfg.getMemoryMode() == CacheMemoryMode.OFFHEAP_TIERED && this.isOffHeapEnabled();
    }

    public boolean useOffheapEntry() {
        return this.cacheCfg != null && (this.cacheCfg.getMemoryMode() == CacheMemoryMode.OFFHEAP_TIERED || this.cacheCfg.getMemoryMode() == CacheMemoryMode.OFFHEAP_VALUES);
    }

    public boolean needValueCopy() {
        return this.affNode && this.cacheCfg.isCopyOnRead() && this.cacheCfg.getMemoryMode() != CacheMemoryMode.OFFHEAP_VALUES;
    }

    @Nullable
    public <T> T unwrapTemporary(@Nullable Object obj) {
        if (!this.useOffheapEntry()) {
            return (T)obj;
        }
        return (T)this.cacheObjects().unwrapTemporary(this, obj);
    }

    public Collection<Object> unwrapBinariesIfNeeded(Collection<Object> col, boolean keepBinary) {
        return this.cacheObjCtx.unwrapBinariesIfNeeded(col, keepBinary);
    }

    public Object unwrapBinaryIfNeeded(Object o, boolean keepBinary) {
        return this.cacheObjCtx.unwrapBinaryIfNeeded(o, keepBinary);
    }

    public Object unwrapBinaryIfNeeded(Object o, boolean keepBinary, boolean cpy) {
        return this.cacheObjCtx.unwrapBinaryIfNeeded(o, keepBinary, cpy);
    }

    public Map unwrapInvokeResult(@Nullable Map<Object, EntryProcessorResult> resMap, final boolean keepBinary) {
        return F.viewReadOnly(resMap, new C1<EntryProcessorResult, EntryProcessorResult>(){

            @Override
            public EntryProcessorResult apply(EntryProcessorResult res) {
                CacheInvokeResult invokeRes;
                if (res instanceof CacheInvokeResult && (invokeRes = (CacheInvokeResult)res).result() != null) {
                    res = CacheInvokeResult.fromResult(GridCacheContext.this.unwrapBinaryIfNeeded(invokeRes.result(), keepBinary, false));
                }
                return res;
            }
        }, new IgnitePredicate[0]);
    }

    public CacheObjectContext cacheObjectContext() {
        return this.cacheObjCtx;
    }

    @Nullable
    public CacheObject toCacheObject(@Nullable Object obj) {
        assert (this.validObjectForCache(obj)) : obj;
        return this.cacheObjects().toCacheObject(this.cacheObjCtx, obj, true);
    }

    public KeyCacheObject toCacheKeyObject(Object obj) {
        assert (this.validObjectForCache(obj)) : obj;
        return this.cacheObjects().toCacheKeyObject(this.cacheObjCtx, this, obj, true);
    }

    private boolean validObjectForCache(Object obj) {
        return obj == null || !CU.isUtilityCache(this.cacheName) || this.ctx.marshallerContext().isSystemType(obj.getClass().getName());
    }

    public KeyCacheObject toCacheKeyObject(byte[] bytes) throws IgniteCheckedException {
        Object obj = this.ctx.cacheObjects().unmarshal(this.cacheObjCtx, bytes, this.deploy().localLoader());
        return this.cacheObjects().toCacheKeyObject(this.cacheObjCtx, this, obj, false);
    }

    @Nullable
    public CacheObject unswapCacheObject(byte type, byte[] bytes, @Nullable IgniteUuid clsLdrId) throws IgniteCheckedException {
        if (this.ctx.config().isPeerClassLoadingEnabled() && type != 2) {
            ClassLoader ldr;
            ClassLoader classLoader = ldr = clsLdrId != null ? this.deploy().getClassLoader(clsLdrId) : this.deploy().localLoader();
            if (ldr == null) {
                return null;
            }
            return this.ctx.cacheObjects().toCacheObject(this.cacheObjCtx, this.ctx.cacheObjects().unmarshal(this.cacheObjCtx, bytes, ldr), false);
        }
        return this.ctx.cacheObjects().toCacheObject(this.cacheObjCtx, type, bytes);
    }

    public CacheObject fromOffheap(long valPtr, boolean tmp) throws IgniteCheckedException {
        assert (this.config().getMemoryMode() == CacheMemoryMode.OFFHEAP_TIERED || this.config().getMemoryMode() == CacheMemoryMode.OFFHEAP_VALUES) : this.cacheCfg;
        assert (valPtr != 0L);
        return this.ctx.cacheObjects().toCacheObject(this, valPtr, tmp);
    }

    public <K1, V1> void addResult(Map<K1, V1> map, KeyCacheObject key, CacheObject val, boolean skipVals, boolean keepCacheObjects, boolean deserializeBinary, boolean cpy, GridCacheVersion ver, long expireTime, long ttl) {
        this.addResult(map, key, val, skipVals, keepCacheObjects, deserializeBinary, cpy, null, ver, expireTime, ttl, ver != null);
    }

    public <K1, V1> void addResult(Map<K1, V1> map, KeyCacheObject key, EntryGetResult getRes, boolean skipVals, boolean keepCacheObjects, boolean deserializeBinary, boolean cpy, boolean needVer) {
        this.addResult(map, key, (CacheObject)getRes.value(), skipVals, keepCacheObjects, deserializeBinary, cpy, getRes, null, 0L, 0L, needVer);
    }

    public <K1, V1> void addResult(Map<K1, V1> map, KeyCacheObject key, CacheObject val, boolean skipVals, boolean keepCacheObjects, boolean deserializeBinary, boolean cpy, @Nullable EntryGetResult getRes, GridCacheVersion ver, long expireTime, long ttl, boolean needVer) {
        assert (key != null);
        assert (val != null || skipVals);
        if (!keepCacheObjects) {
            Boolean val0;
            Object key0 = this.unwrapBinaryIfNeeded(key, !deserializeBinary, cpy);
            Boolean bl = skipVals ? Boolean.valueOf(true) : (val0 = this.unwrapBinaryIfNeeded(val, !deserializeBinary, cpy));
            assert (key0 != null) : key;
            assert (val0 != null) : val;
            V1 v = this.createValue(ver, expireTime, ttl, val0, getRes, needVer);
            map.put(key0, v);
        } else {
            Serializable val0 = skipVals ? Boolean.valueOf(true) : val;
            V1 v = this.createValue(ver, expireTime, ttl, val0, getRes, needVer);
            map.put(key, v);
        }
    }

    private <V1> V1 createValue(GridCacheVersion ver, long expireTime, long ttl, Object val, @Nullable EntryGetResult getRes, boolean needVer) {
        Object v;
        if (!needVer) {
            v = val;
        } else if (getRes == null) {
            v = expireTime != 0L || ttl != 0L ? new EntryGetWithTtlResult(val, ver, false, expireTime, ttl) : new EntryGetResult(val, ver, false);
        } else {
            getRes.value(val);
            v = getRes;
        }
        return (V1)v;
    }

    public boolean updatesAllowed() {
        return this.updatesAllowed;
    }

    public void cleanup() {
        this.cache = null;
        this.cacheCfg = null;
        this.evictMgr = null;
        this.qryMgr = null;
        this.dataStructuresMgr = null;
        this.cacheObjCtx = null;
        this.mgrs.clear();
    }

    public void printMemoryStats() {
        X.println(">>> ", new Object[0]);
        X.println(">>> Cache memory stats [grid=" + this.ctx.gridName() + ", cache=" + this.name() + ']', new Object[0]);
        this.cache().printMemoryStats();
        LinkedList<GridCacheManager<K, V>> printed = new LinkedList<GridCacheManager<K, V>>();
        for (GridCacheManager<K, V> mgr : this.managers()) {
            mgr.printMemoryStats();
            printed.add(mgr);
        }
        if (this.isNear()) {
            for (GridCacheManager<K, V> mgr : this.near().dht().context().managers()) {
                if (printed.contains(mgr)) continue;
                mgr.printMemoryStats();
            }
        }
    }

    public Collection<KeyCacheObject> cacheKeysView(Collection<?> keys) {
        return F.viewReadOnly(keys, new C1<Object, KeyCacheObject>(){

            @Override
            public KeyCacheObject apply(Object key) {
                if (key == null) {
                    throw new NullPointerException("Null key.");
                }
                return GridCacheContext.this.toCacheKeyObject(key);
            }
        }, new IgnitePredicate[0]);
    }

    public boolean allowFastLocalRead(int part, List<ClusterNode> affNodes, AffinityTopologyVersion topVer) {
        return this.affinityNode() && this.rebalanceEnabled() && this.hasPartition(part, affNodes, topVer);
    }

    private boolean hasPartition(int part, List<ClusterNode> affNodes, AffinityTopologyVersion topVer) {
        assert (this.affinityNode());
        GridDhtPartitionTopology top = this.topology();
        return top.rebalanceFinished(topVer) && (this.isReplicated() || affNodes.contains(this.locNode)) || top.partitionState(this.localNodeId(), part) == GridDhtPartitionState.OWNING;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeString(out, this.gridName());
        U.writeString(out, this.namex());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        IgniteBiTuple<String, String> t = stash.get();
        t.set1(U.readString(in));
        t.set2(U.readString(in));
    }

    protected Object readResolve() throws ObjectStreamException {
        try {
            IgniteBiTuple<String, String> t = stash.get();
            IgniteKernal grid = IgnitionEx.localIgnite();
            GridCacheAdapter cache = grid.internalCache(t.get2());
            if (cache == null) {
                throw new IllegalStateException("Failed to find cache for name: " + t.get2());
            }
            GridCacheContext gridCacheContext = cache.context();
            return gridCacheContext;
        }
        catch (IllegalStateException e) {
            throw U.withCause(new InvalidObjectException(e.getMessage()), e);
        }
        finally {
            stash.remove();
        }
    }

    public String toString() {
        return "GridCacheContext: " + this.name();
    }
}

