/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class GridCacheEntryInfo
implements Message {
    private static final int SIZE_OVERHEAD = 76;
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    private KeyCacheObject key;
    private byte[] keyBytes;
    private int cacheId;
    private CacheObject val;
    private long ttl;
    private long expireTime;
    private GridCacheVersion ver;
    @GridDirectTransient
    private boolean isNew;
    @GridDirectTransient
    private boolean deleted;

    public int cacheId() {
        return this.cacheId;
    }

    public void cacheId(int cacheId) {
        this.cacheId = cacheId;
    }

    public void key(KeyCacheObject key) {
        this.key = key;
    }

    public void keyBytes(byte[] bytes) {
        this.keyBytes = bytes;
    }

    public byte[] keyBytes() {
        return this.keyBytes;
    }

    public KeyCacheObject key() {
        return this.key;
    }

    public CacheObject value() {
        return this.val;
    }

    public void value(CacheObject val) {
        this.val = val;
    }

    public long expireTime() {
        return this.expireTime;
    }

    public void expireTime(long expireTime) {
        this.expireTime = expireTime;
    }

    public long ttl() {
        return this.ttl;
    }

    public void ttl(long ttl) {
        this.ttl = ttl;
    }

    public GridCacheVersion version() {
        return this.ver;
    }

    public void version(GridCacheVersion ver) {
        this.ver = ver;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeInt("cacheId", this.cacheId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeLong("expireTime", this.expireTime)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeMessage("key", this.key)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeByteArray("keyBytes", this.keyBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeLong("ttl", this.ttl)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeMessage("val", this.val)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeMessage("ver", this.ver)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.cacheId = reader.readInt("cacheId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.expireTime = reader.readLong("expireTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.key = (KeyCacheObject)reader.readMessage("key");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.keyBytes = reader.readByteArray("keyBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.ttl = reader.readLong("ttl");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.val = (CacheObject)reader.readMessage("val");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.ver = (GridCacheVersion)reader.readMessage("ver");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridCacheEntryInfo.class);
    }

    @Override
    public byte directType() {
        return 91;
    }

    @Override
    public byte fieldsCount() {
        return 7;
    }

    public void unmarshalValue(GridCacheContext<?, ?> ctx, ClassLoader ldr) throws IgniteCheckedException {
        if (this.val != null) {
            this.val.finishUnmarshal(ctx.cacheObjectContext(), ldr);
        }
    }

    public int marshalledSize(GridCacheContext ctx) throws IgniteCheckedException {
        int size = 0;
        CacheObjectContext cacheObjCtx = ctx.cacheObjectContext();
        if (this.val != null) {
            size += this.val.valueBytes(cacheObjCtx).length;
        }
        if (this.key == null) {
            assert (this.keyBytes != null);
            size += this.keyBytes.length;
        } else {
            size += this.key.valueBytes(cacheObjCtx).length;
        }
        return 76 + size;
    }

    public void marshal(GridCacheContext ctx) throws IgniteCheckedException {
        assert (this.key != null ^ this.keyBytes != null);
        if (this.key != null) {
            this.key.prepareMarshal(ctx.cacheObjectContext());
        }
        if (this.val != null) {
            this.val.prepareMarshal(ctx.cacheObjectContext());
        }
        if (this.expireTime == 0L) {
            this.expireTime = -1L;
        } else {
            this.expireTime -= U.currentTimeMillis();
            if (this.expireTime < 0L) {
                this.expireTime = 0L;
            }
        }
    }

    public void unmarshal(GridCacheContext ctx, ClassLoader clsLdr) throws IgniteCheckedException {
        long remaining;
        if (this.key == null) {
            assert (this.keyBytes != null);
            CacheObjectContext cacheObjCtx = ctx.cacheObjectContext();
            Object key0 = ctx.cacheObjects().unmarshal(cacheObjCtx, this.keyBytes, clsLdr);
            this.key = ctx.cacheObjects().toCacheKeyObject(cacheObjCtx, ctx, key0, false);
        } else {
            this.key.finishUnmarshal(ctx.cacheObjectContext(), clsLdr);
        }
        if (this.val != null) {
            this.val.finishUnmarshal(ctx.cacheObjectContext(), clsLdr);
        }
        long l = this.expireTime = (remaining = this.expireTime) < 0L ? 0L : U.currentTimeMillis() + remaining;
        if (this.expireTime < 0L) {
            this.expireTime = 0L;
        }
    }

    public String toString() {
        return S.toString(GridCacheEntryInfo.class, this);
    }
}

