/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Collection;
import java.util.Map;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCacheSwapEntry;
import org.apache.ignite.internal.processors.cache.GridCacheSwapListener;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.jsr166.ConcurrentHashMap8;

public class GridCacheEntryInfoCollectSwapListener
implements GridCacheSwapListener {
    private final Map<KeyCacheObject, GridCacheEntryInfo> swappedEntries = new ConcurrentHashMap8<KeyCacheObject, GridCacheEntryInfo>();
    private final IgniteLogger log;

    public GridCacheEntryInfoCollectSwapListener(IgniteLogger log) {
        this.log = log;
    }

    @Override
    public void onEntryUnswapped(int part, KeyCacheObject key, GridCacheSwapEntry swapEntry) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received unswapped event for key: " + key);
        }
        assert (key != null);
        assert (swapEntry != null);
        GridCacheEntryInfo info = new GridCacheEntryInfo();
        info.key(key);
        info.ttl(swapEntry.ttl());
        info.expireTime(swapEntry.expireTime());
        info.version(swapEntry.version());
        info.value(swapEntry.value());
        this.swappedEntries.put(key, info);
    }

    public Collection<GridCacheEntryInfo> entries() {
        return this.swappedEntries.values();
    }
}

