/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CacheMemoryMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.eviction.EvictionFilter;
import org.apache.ignite.cache.eviction.EvictionPolicy;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.IgniteFutureCancelledCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicateAdapter;
import org.apache.ignite.internal.processors.cache.CacheEvictionEntry;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheBatchSwapEntry;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheEvictionRequest;
import org.apache.ignite.internal.processors.cache.GridCacheEvictionResponse;
import org.apache.ignite.internal.processors.cache.GridCacheInternal;
import org.apache.ignite.internal.processors.cache.GridCacheManagerAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObject;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObjectAdapter;
import org.apache.ignite.internal.util.F0;
import org.apache.ignite.internal.util.GridBusyLock;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.GridMetadataAwareAdapter;
import org.apache.ignite.internal.util.lang.IgnitePair;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.CI2;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.P1;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.thread.IgniteThread;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentHashMap8;
import org.jsr166.ConcurrentLinkedDeque8;

public class GridCacheEvictionManager
extends GridCacheManagerAdapter {
    private static final int META_KEY = GridMetadataAwareAdapter.EntryKey.CACHE_EVICTION_MANAGER_KEY.key();
    private EvictionPolicy plc;
    private EvictionFilter filter;
    private final ConcurrentLinkedDeque8<EvictionInfo> bufEvictQ = new ConcurrentLinkedDeque8();
    private final Map<Long, EvictionFuture> futs = new ConcurrentHashMap8<Long, EvictionFuture>();
    private final Lock futsCntLock = new ReentrantLock();
    private final Condition futsCntCond = this.futsCntLock.newCondition();
    private volatile int activeFutsCnt;
    private int maxActiveFuts;
    private final AtomicLong idGen = new AtomicLong();
    private boolean evictSync;
    private boolean nearSync;
    private boolean evictSyncAgr;
    private boolean plcEnabled;
    private CacheMemoryMode memoryMode;
    private BackupWorker backupWorker;
    private IgniteThread backupWorkerThread;
    private final GridBusyLock busyLock = new GridBusyLock();
    private volatile boolean stopping;
    private final AtomicReference<EvictionFuture> curEvictFut = new AtomicReference();
    private volatile boolean firstEvictWarn;

    @Override
    public void start0() throws IgniteCheckedException {
        CacheConfiguration cfg = this.cctx.config();
        this.plc = this.cctx.isNear() ? cfg.getNearConfiguration().getNearEvictionPolicy() : cfg.getEvictionPolicy();
        this.memoryMode = this.cctx.config().getMemoryMode();
        this.plcEnabled = this.plc != null && (this.cctx.isNear() || this.memoryMode != CacheMemoryMode.OFFHEAP_TIERED);
        this.filter = cfg.getEvictionFilter();
        if (cfg.getEvictMaxOverflowRatio() < 0.0f) {
            throw new IgniteCheckedException("Configuration parameter 'maxEvictOverflowRatio' cannot be negative.");
        }
        if (cfg.getEvictSynchronizedKeyBufferSize() < 0) {
            throw new IgniteCheckedException("Configuration parameter 'evictSynchronizedKeyBufferSize' cannot be negative.");
        }
        if (!this.cctx.isLocal()) {
            this.evictSync = cfg.isEvictSynchronized() && !this.cctx.isNear() && !this.cctx.isSwapOrOffheapEnabled();
            this.nearSync = GridCacheUtils.isNearEnabled(this.cctx) && !this.cctx.isNear() && cfg.isEvictSynchronized();
        } else {
            if (cfg.isEvictSynchronized()) {
                U.warn(this.log, "Ignored 'evictSynchronized' configuration property for LOCAL cache: " + this.cctx.namexx());
            }
            if (cfg.getNearConfiguration() != null && cfg.isEvictSynchronized()) {
                U.warn(this.log, "Ignored 'evictNearSynchronized' configuration property for LOCAL cache: " + this.cctx.namexx());
            }
        }
        if (this.cctx.isDht() && !this.nearSync && this.evictSync && GridCacheUtils.isNearEnabled(this.cctx)) {
            throw new IgniteCheckedException("Illegal configuration (may lead to data inconsistency) [evictSync=true, evictNearSync=false]");
        }
        this.reportConfigurationProblems();
        boolean bl = this.evictSyncAgr = this.evictSync || this.nearSync;
        if (this.evictSync && !this.cctx.isNear() && this.plcEnabled) {
            this.backupWorker = new BackupWorker();
            this.cctx.events().addListener(new GridLocalEventListener(){

                @Override
                public void onEvent(Event evt) {
                    assert (evt.type() == 12 || evt.type() == 11 || evt.type() == 10);
                    DiscoveryEvent discoEvt = (DiscoveryEvent)evt;
                    if (GridCacheEvictionManager.this.cctx.discovery().cacheAffinityNode(discoEvt.eventNode(), GridCacheEvictionManager.this.cctx.name())) {
                        GridCacheEvictionManager.this.backupWorker.addEvent(discoEvt);
                    }
                }
            }, 12, 11, 10);
        }
        if (this.evictSyncAgr) {
            if (cfg.getEvictSynchronizedTimeout() <= 0L) {
                throw new IgniteCheckedException("Configuration parameter 'evictSynchronousTimeout' should be positive.");
            }
            if (cfg.getEvictSynchronizedConcurrencyLevel() <= 0) {
                throw new IgniteCheckedException("Configuration parameter 'evictSynchronousConcurrencyLevel' should be positive.");
            }
            this.maxActiveFuts = cfg.getEvictSynchronizedConcurrencyLevel();
            this.cctx.io().addHandler(this.cctx.cacheId(), GridCacheEvictionRequest.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridCacheEvictionRequest>(){

                @Override
                public void apply(UUID nodeId, GridCacheEvictionRequest msg) {
                    GridCacheEvictionManager.this.processEvictionRequest(nodeId, msg);
                }
            });
            this.cctx.io().addHandler(this.cctx.cacheId(), GridCacheEvictionResponse.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridCacheEvictionResponse>(){

                @Override
                public void apply(UUID nodeId, GridCacheEvictionResponse msg) {
                    GridCacheEvictionManager.this.processEvictionResponse(nodeId, msg);
                }
            });
            this.cctx.events().addListener(new GridLocalEventListener(){

                @Override
                public void onEvent(Event evt) {
                    assert (evt.type() == 12 || evt.type() == 11);
                    DiscoveryEvent discoEvt = (DiscoveryEvent)evt;
                    for (EvictionFuture fut : GridCacheEvictionManager.this.futs.values()) {
                        fut.onNodeLeft(discoEvt.eventNode().id());
                    }
                }
            }, 12, 11);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Eviction manager started on node: " + this.cctx.nodeId());
        }
    }

    private void reportConfigurationProblems() {
        CacheMode mode = this.cctx.config().getCacheMode();
        if (this.plcEnabled && !this.cctx.isNear() && mode == CacheMode.PARTITIONED) {
            if (!this.evictSync) {
                U.warn(this.log, "Evictions are not synchronized with other nodes in topology which provides 2x-3x better performance but may cause data inconsistency if cache store is not configured (consider changing 'evictSynchronized' configuration property).", "Evictions are not synchronized for cache: " + this.cctx.namexx());
            }
            if (!this.nearSync && GridCacheUtils.isNearEnabled(this.cctx)) {
                U.warn(this.log, "Evictions on primary node are not synchronized with near caches on other nodes which provides 2x-3x better performance but may cause data inconsistency (consider changing 'nearEvictSynchronized' configuration property).", "Evictions are not synchronized with near caches on other nodes for cache: " + this.cctx.namexx());
            }
        }
    }

    @Override
    protected void onKernalStart0() throws IgniteCheckedException {
        super.onKernalStart0();
        if (this.plcEnabled && this.evictSync && !this.cctx.isNear()) {
            DiscoveryEvent evt = this.cctx.discovery().localJoinEvent();
            this.backupWorker.addEvent(evt);
            this.backupWorkerThread = new IgniteThread(this.backupWorker);
            this.backupWorkerThread.start();
        }
    }

    @Override
    protected void onKernalStop0(boolean cancel) {
        super.onKernalStop0(cancel);
        this.stopping = true;
        this.busyLock.block();
        if (this.evictSync && !this.cctx.isNear() && this.backupWorker != null) {
            this.backupWorker.cancel();
            U.join(this.backupWorkerThread, this.log);
        }
        for (EvictionFuture fut : this.futs.values()) {
            fut.cancel();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Eviction manager stopped on node: " + this.cctx.nodeId());
        }
    }

    public int evictQueueSize() {
        return this.bufEvictQ.sizex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEvictionResponse(UUID nodeId, GridCacheEvictionResponse res) {
        assert (nodeId != null);
        assert (res != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Processing eviction response [node=" + nodeId + ", localNode=" + this.cctx.nodeId() + ", res=" + res + ']');
        }
        if (!this.busyLock.enterBusy()) {
            return;
        }
        try {
            EvictionFuture fut = this.futs.get(res.futureId());
            if (fut != null) {
                fut.onResponse(nodeId, res);
            } else if (this.log.isDebugEnabled()) {
                this.log.debug("Eviction future for response is not found [res=" + res + ", node=" + nodeId + ", localNode=" + this.cctx.nodeId() + ']');
            }
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEvictionRequest(UUID nodeId, GridCacheEvictionRequest req) {
        assert (nodeId != null);
        assert (req != null);
        if (!this.busyLock.enterBusy()) {
            return;
        }
        try {
            if (req.classError() != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Class got undeployed during eviction: " + req.classError());
                }
                this.sendEvictionResponse(nodeId, new GridCacheEvictionResponse(this.cctx.cacheId(), req.futureId(), true));
                return;
            }
            AffinityTopologyVersion topVer = this.lockTopology();
            try {
                if (!topVer.equals(req.topologyVersion())) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Topology version is different [locTopVer=" + topVer + ", rmtTopVer=" + req.topologyVersion() + ']');
                    }
                    this.sendEvictionResponse(nodeId, new GridCacheEvictionResponse(this.cctx.cacheId(), req.futureId(), true));
                    return;
                }
                this.processEvictionRequest0(nodeId, req);
            }
            finally {
                this.unlockTopology();
            }
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEvictionRequest0(UUID nodeId, GridCacheEvictionRequest req) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Processing eviction request [node=" + nodeId + ", localNode=" + this.cctx.nodeId() + ", reqSize=" + req.entries().size() + ']');
        }
        HashMap dhtEntries = new HashMap();
        LinkedList<CacheEvictionEntry> nearEntries = new LinkedList<CacheEvictionEntry>();
        for (CacheEvictionEntry e : req.entries()) {
            boolean near = e.near();
            if (!near) {
                Collection col = F.addIfAbsent(dhtEntries, Integer.valueOf(this.cctx.affinity().partition(e.key())), new LinkedList());
                assert (col != null);
                col.add(e);
                continue;
            }
            nearEntries.add(e);
        }
        GridCacheEvictionResponse res = new GridCacheEvictionResponse(this.cctx.cacheId(), req.futureId());
        GridCacheVersion obsoleteVer = this.cctx.versions().next();
        for (Map.Entry e : dhtEntries.entrySet()) {
            int part = (Integer)e.getKey();
            boolean locked = this.lockPartition(part);
            try {
                for (CacheEvictionEntry t : (Collection)e.getValue()) {
                    KeyCacheObject key = t.key();
                    GridCacheVersion ver = t.version();
                    boolean near = t.near();
                    assert (!near);
                    boolean evicted = this.evictLocally(key, ver, near, obsoleteVer);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Evicted key [key=" + key + ", ver=" + ver + ", near=" + near + ", evicted=" + evicted + ']');
                    }
                    if (locked && evicted) {
                        this.saveEvictionInfo(key, ver, part);
                    }
                    if (evicted) continue;
                    res.addRejected(key);
                }
            }
            finally {
                if (!locked) continue;
                this.unlockPartition(part);
            }
        }
        for (CacheEvictionEntry t : nearEntries) {
            KeyCacheObject key = t.key();
            GridCacheVersion ver = t.version();
            boolean near = t.near();
            assert (near);
            boolean evicted = this.evictLocally(key, ver, near, obsoleteVer);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Evicted key [key=" + key + ", ver=" + ver + ", near=" + near + ", evicted=" + evicted + ']');
            }
            if (evicted) continue;
            res.addRejected(key);
        }
        this.sendEvictionResponse(nodeId, res);
    }

    private void sendEvictionResponse(UUID nodeId, GridCacheEvictionResponse res) {
        try {
            this.cctx.io().send(nodeId, (GridCacheMessage)res, this.cctx.ioPolicy());
            if (this.log.isDebugEnabled()) {
                this.log.debug("Sent eviction response [node=" + nodeId + ", localNode=" + this.cctx.nodeId() + ", res" + res + ']');
            }
        }
        catch (ClusterTopologyCheckedException ignored) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failed to send eviction response since initiating node left grid [node=" + nodeId + ", localNode=" + this.cctx.nodeId() + ']');
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to send eviction response to node [node=" + nodeId + ", localNode=" + this.cctx.nodeId() + ", res" + res + ']', e);
        }
    }

    private void saveEvictionInfo(KeyCacheObject key, GridCacheVersion ver, int p) {
        assert (this.cctx.rebalanceEnabled());
        if (!this.cctx.isNear()) {
            try {
                GridDhtLocalPartition part = this.cctx.dht().topology().localPartition(p, AffinityTopologyVersion.NONE, false);
                assert (part != null);
                part.onEntryEvicted(key, ver);
            }
            catch (GridDhtInvalidPartitionException ignored) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Partition does not belong to local node [part=" + p + ", nodeId" + this.cctx.localNode().id() + ']');
                }
            }
        } else assert (false) : "Failed to save eviction info: " + this.cctx.namexx();
    }

    private boolean lockPartition(int p) {
        block6: {
            if (!this.cctx.rebalanceEnabled()) {
                return false;
            }
            if (!this.cctx.isNear()) {
                try {
                    GridDhtLocalPartition part = this.cctx.dht().topology().localPartition(p, AffinityTopologyVersion.NONE, false);
                    if (part != null && part.reserve()) {
                        part.lock();
                        if (part.state() != GridDhtPartitionState.MOVING) {
                            part.unlock();
                            part.release();
                            return false;
                        }
                        return true;
                    }
                }
                catch (GridDhtInvalidPartitionException ignored) {
                    if (!this.log.isDebugEnabled()) break block6;
                    this.log.debug("Partition does not belong to local node [part=" + p + ", nodeId" + this.cctx.localNode().id() + ']');
                }
            }
        }
        return false;
    }

    private void unlockPartition(int p) {
        block5: {
            if (!this.cctx.rebalanceEnabled()) {
                return;
            }
            if (!this.cctx.isNear()) {
                try {
                    GridDhtLocalPartition part = this.cctx.dht().topology().localPartition(p, AffinityTopologyVersion.NONE, false);
                    if (part != null) {
                        part.unlock();
                        part.release();
                    }
                }
                catch (GridDhtInvalidPartitionException ignored) {
                    if (!this.log.isDebugEnabled()) break block5;
                    this.log.debug("Partition does not belong to local node [part=" + p + ", nodeId" + this.cctx.localNode().id() + ']');
                }
            }
        }
    }

    private AffinityTopologyVersion lockTopology() {
        if (!this.cctx.isNear()) {
            this.cctx.dht().topology().readLock();
            return this.cctx.dht().topology().topologyVersion();
        }
        return AffinityTopologyVersion.ZERO;
    }

    private void unlockTopology() {
        if (!this.cctx.isNear()) {
            this.cctx.dht().topology().readUnlock();
        }
    }

    private boolean evictLocally(KeyCacheObject key, GridCacheVersion ver, boolean near, GridCacheVersion obsoleteVer) {
        GridCacheAdapter cache;
        GridCacheEntryEx entry;
        assert (key != null);
        assert (ver != null);
        assert (obsoleteVer != null);
        assert (this.evictSyncAgr);
        assert (!this.cctx.isNear() || this.cctx.isReplicated());
        if (this.log.isDebugEnabled()) {
            this.log.debug("Evicting key locally [key=" + key + ", ver=" + ver + ", obsoleteVer=" + obsoleteVer + ", localNode=" + this.cctx.localNode() + ']');
        }
        if ((entry = (cache = near ? this.cctx.dht().near() : this.cctx.cache()).peekEx(key)) == null) {
            return true;
        }
        try {
            return this.evict0(cache, entry, obsoleteVer, null, false);
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to evict entry on remote node [key=" + key + ", localNode=" + this.cctx.nodeId() + ']', e);
            return false;
        }
    }

    private boolean evict0(GridCacheAdapter cache, GridCacheEntryEx entry, GridCacheVersion obsoleteVer, @Nullable CacheEntryPredicate[] filter, boolean explicit) throws IgniteCheckedException {
        assert (cache != null);
        assert (entry != null);
        assert (obsoleteVer != null);
        boolean recordable = this.cctx.events().isRecordable(62);
        CacheObject oldVal = recordable ? entry.rawGet() : null;
        boolean hasVal = recordable && entry.hasValue();
        boolean evicted = entry.evictInternal(this.cctx.isSwapOrOffheapEnabled(), obsoleteVer, filter);
        if (evicted) {
            if (explicit && this.plcEnabled) {
                this.notifyPolicy(entry);
            }
            cache.removeEntry(entry);
            if (cache.configuration().isStatisticsEnabled()) {
                cache.metrics0().onEvict();
            }
            if (recordable) {
                this.cctx.events().addEvent(entry.partition(), entry.key(), this.cctx.nodeId(), (IgniteUuid)null, null, 62, null, false, oldVal, hasVal, null, null, null, false);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Entry was evicted [entry=" + entry + ", localNode=" + this.cctx.nodeId() + ']');
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Entry was not evicted [entry=" + entry + ", localNode=" + this.cctx.nodeId() + ']');
        }
        return evicted;
    }

    public void touch(IgniteTxEntry txEntry, boolean loc) {
        GridCacheEntryEx e;
        if (!this.plcEnabled && this.memoryMode != CacheMemoryMode.OFFHEAP_TIERED) {
            return;
        }
        if (!loc) {
            if (this.cctx.isNear()) {
                return;
            }
            if (this.evictSync) {
                return;
            }
        }
        if ((e = txEntry.cached()).detached() || e.isInternal()) {
            return;
        }
        try {
            if (e.markObsoleteIfEmpty(null) || e.obsolete()) {
                e.context().cache().removeEntry(e);
            }
        }
        catch (IgniteCheckedException ex) {
            U.error(this.log, "Failed to evict entry from cache: " + e, ex);
        }
        if (this.memoryMode == CacheMemoryMode.OFFHEAP_TIERED) {
            try {
                this.evict0(this.cctx.cache(), e, this.cctx.versions().next(), null, false);
            }
            catch (IgniteCheckedException ex) {
                U.error(this.log, "Failed to evict entry from on heap memory: " + e, ex);
            }
        } else {
            this.notifyPolicy(e);
            if (this.evictSyncAgr) {
                this.waitForEvictionFutures();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void touch(GridCacheEntryEx e, AffinityTopologyVersion topVer) {
        if (e.detached() || e.isInternal()) {
            return;
        }
        try {
            if (e.markObsoleteIfEmpty(null) || e.obsolete()) {
                e.context().cache().removeEntry(e);
            }
        }
        catch (IgniteCheckedException ex) {
            U.error(this.log, "Failed to evict entry from cache: " + e, ex);
        }
        if (!this.cctx.isNear() && this.memoryMode == CacheMemoryMode.OFFHEAP_TIERED) {
            try {
                this.evict0(this.cctx.cache(), e, this.cctx.versions().next(), null, false);
            }
            catch (IgniteCheckedException ex) {
                U.error(this.log, "Failed to evict entry from on heap memory: " + e, ex);
            }
            return;
        }
        if (!this.plcEnabled) {
            return;
        }
        if (!this.cctx.isNear() && this.evictSync && !this.cctx.affinity().primaryByPartition(this.cctx.localNode(), e.partition(), topVer)) {
            return;
        }
        if (!this.busyLock.enterBusy()) {
            return;
        }
        try {
            if (this.evictSyncAgr) {
                this.waitForEvictionFutures();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Touching entry [entry=" + e + ", localNode=" + this.cctx.nodeId() + ']');
            }
            this.notifyPolicy(e);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private void touch0(GridCacheEntryEx e) {
        assert (this.evictSyncAgr);
        assert (this.plcEnabled);
        this.notifyPolicy(e);
    }

    private void touchOnTopologyChange(Iterable<? extends GridCacheEntryEx> entries) {
        assert (this.evictSync);
        assert (this.plcEnabled);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Touching entries [entries=" + entries + ", localNode=" + this.cctx.nodeId() + ']');
        }
        for (GridCacheEntryEx gridCacheEntryEx : entries) {
            if (gridCacheEntryEx.key() instanceof GridCacheInternal) continue;
            this.notifyPolicy(gridCacheEntryEx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void warnFirstEvict() {
        GridCacheEvictionManager gridCacheEvictionManager = this;
        synchronized (gridCacheEvictionManager) {
            if (this.firstEvictWarn) {
                return;
            }
            this.firstEvictWarn = true;
        }
        U.warn(this.log, "Evictions started (cache may have reached its capacity). You may wish to increase 'maxSize' on eviction policy being used for cache: " + this.cctx.name(), "Evictions started (cache may have reached its capacity): " + this.cctx.name());
    }

    public boolean evictSyncOrNearSync() {
        return this.evictSyncAgr;
    }

    public boolean evict(@Nullable GridCacheEntryEx entry, @Nullable GridCacheVersion obsoleteVer, boolean explicit, @Nullable CacheEntryPredicate[] filter) throws IgniteCheckedException {
        if (entry == null) {
            return true;
        }
        if (entry.key() instanceof GridCacheInternal) {
            return false;
        }
        if (!(this.cctx.isNear() || explicit || this.firstEvictWarn)) {
            this.warnFirstEvict();
        }
        if (this.evictSyncAgr) {
            assert (!this.cctx.isNear());
            if (this.cctx.affinity().backupsByKey(entry.key(), this.cctx.topology().topologyVersion()).contains(this.cctx.localNode()) && this.evictSync) {
                return !explicit;
            }
            try {
                if (!this.cctx.isAll(entry, filter)) {
                    return false;
                }
                if (entry.lockedByAny(new GridCacheVersion[0])) {
                    return false;
                }
                this.enqueue(entry, filter);
            }
            catch (GridCacheEntryRemovedException ignored) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Entry got removed while evicting [entry=" + entry + ", localNode=" + this.cctx.nodeId() + ']');
                }
            }
        } else {
            if (obsoleteVer == null) {
                obsoleteVer = this.cctx.versions().next();
            }
            return this.evict0(this.cctx.cache(), entry, obsoleteVer, filter, explicit);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batchEvict(Collection<?> keys, @Nullable GridCacheVersion obsoleteVer) throws IgniteCheckedException {
        assert (!this.evictSyncAgr);
        assert (this.cctx.isSwapOrOffheapEnabled());
        ArrayList<GridCacheEntryEx> locked = new ArrayList<GridCacheEntryEx>(keys.size());
        HashSet<GridCacheEntryEx> notRmv = null;
        ArrayList<GridCacheBatchSwapEntry> swapped = new ArrayList<GridCacheBatchSwapEntry>(keys.size());
        boolean recordable = this.cctx.events().isRecordable(62);
        GridCacheAdapter cache = this.cctx.cache();
        LinkedHashMap<?, GridCacheEntryEx> cached = U.newLinkedHashMap(keys.size());
        for (Object k : keys) {
            KeyCacheObject cacheKey = this.cctx.toCacheKeyObject(k);
            GridCacheEntryEx e = cache.peekEx(cacheKey);
            if (e == null) continue;
            cached.put(k, e);
        }
        try {
            for (GridCacheEntryEx entry : cached.values()) {
                GridCacheBatchSwapEntry swapEntry;
                if (entry.key().internal()) continue;
                GridUnsafe.monitorEnter(entry);
                locked.add(entry);
                if (entry.obsolete()) {
                    if (notRmv == null) {
                        notRmv = new HashSet<GridCacheEntryEx>();
                    }
                    notRmv.add(entry);
                    continue;
                }
                if (obsoleteVer == null) {
                    obsoleteVer = this.cctx.versions().next();
                }
                if ((swapEntry = entry.evictInBatchInternal(obsoleteVer)) != null) {
                    assert (entry.obsolete()) : entry;
                    swapped.add(swapEntry);
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Entry was evicted [entry=" + entry + ", localNode=" + this.cctx.nodeId() + ']');
                    continue;
                }
                if (entry.obsolete()) continue;
                if (notRmv == null) {
                    notRmv = new HashSet();
                }
                notRmv.add(entry);
            }
            if (!swapped.isEmpty()) {
                this.cctx.swap().writeAll(swapped);
            }
        }
        finally {
            ListIterator it = locked.listIterator(locked.size());
            while (it.hasPrevious()) {
                GridCacheEntryEx e = (GridCacheEntryEx)it.previous();
                GridUnsafe.monitorExit(e);
            }
            for (GridCacheEntryEx entry : locked) {
                if (!entry.obsolete() || notRmv != null && notRmv.contains(entry)) continue;
                entry.onMarkedObsolete();
                cache.removeEntry(entry);
                if (this.plcEnabled) {
                    this.notifyPolicy(entry);
                }
                if (!recordable) continue;
                this.cctx.events().addEvent(entry.partition(), entry.key(), this.cctx.nodeId(), (IgniteUuid)null, null, 62, null, false, entry.rawGet(), entry.hasValue(), null, null, null, false);
            }
        }
    }

    private void enqueue(GridCacheEntryEx entry, CacheEntryPredicate[] filter) throws GridCacheEntryRemovedException {
        ConcurrentLinkedDeque8.Node<EvictionInfo> node = (ConcurrentLinkedDeque8.Node<EvictionInfo>)entry.meta(META_KEY);
        if (node == null) {
            node = this.bufEvictQ.addLastx(new EvictionInfo(entry, entry.version(), filter));
            if (entry.putMetaIfAbsent(META_KEY, node) != null) {
                this.bufEvictQ.unlinkx(node);
            } else if (this.log.isDebugEnabled()) {
                this.log.debug("Added entry to eviction queue: " + entry);
            }
        }
    }

    private void checkEvictionQueue() {
        int maxSize = this.maxQueueSize();
        int bufSize = this.bufEvictQ.sizex();
        if (bufSize >= maxSize) {
            EvictionInfo info;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Processing eviction queue: " + bufSize);
            }
            ArrayList<EvictionInfo> evictInfos = new ArrayList<EvictionInfo>(bufSize);
            for (int i = 0; i < bufSize && (info = this.bufEvictQ.poll()) != null; ++i) {
                evictInfos.add(info);
            }
            if (!evictInfos.isEmpty()) {
                this.addToCurrentFuture(evictInfos);
            }
        }
    }

    private int maxQueueSize() {
        int size = (int)((float)this.cctx.cache().size() * this.cctx.config().getEvictMaxOverflowRatio()) / 100;
        if (size <= 0) {
            size = 500;
        }
        return Math.min(size, this.cctx.config().getEvictSynchronizedKeyBufferSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToCurrentFuture(Collection<EvictionInfo> evictInfos) {
        assert (!evictInfos.isEmpty());
        while (true) {
            EvictionFuture fut;
            if ((fut = this.curEvictFut.get()) == null) {
                this.curEvictFut.compareAndSet(null, new EvictionFuture());
                continue;
            }
            if (fut.prepareLock()) {
                boolean added;
                try {
                    added = fut.add(evictInfos);
                }
                finally {
                    fut.prepareUnlock();
                }
                if (added) {
                    if (!fut.prepare()) break;
                    this.curEvictFut.compareAndSet(fut, null);
                    fut.listen(new CI1<IgniteInternalFuture<?>>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void apply(IgniteInternalFuture<?> f) {
                            if (!GridCacheEvictionManager.this.busyLock.enterBusy()) {
                                if (GridCacheEvictionManager.this.log.isDebugEnabled()) {
                                    GridCacheEvictionManager.this.log.debug("Will not notify eviction future completion (grid is stopping): " + f);
                                }
                                return;
                            }
                            try {
                                AffinityTopologyVersion topVer = GridCacheEvictionManager.this.lockTopology();
                                try {
                                    GridCacheEvictionManager.this.onFutureCompleted((EvictionFuture)f, topVer);
                                }
                                finally {
                                    GridCacheEvictionManager.this.unlockTopology();
                                }
                            }
                            finally {
                                GridCacheEvictionManager.this.busyLock.leaveBusy();
                            }
                        }
                    });
                    break;
                }
                this.curEvictFut.compareAndSet(fut, new EvictionFuture());
                continue;
            }
            this.curEvictFut.compareAndSet(fut, new EvictionFuture());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void onFutureCompleted(EvictionFuture fut, AffinityTopologyVersion topVer) {
        block25: {
            if (!this.busyLock.enterBusy()) {
                return;
            }
            try {
                IgniteBiTuple t;
                try {
                    t = (IgniteBiTuple)fut.get();
                }
                catch (IgniteFutureCancelledCheckedException ignored) {
                    assert (false) : "Future has been cancelled, but manager is not stopping: " + fut;
                    this.busyLock.leaveBusy();
                    this.signal();
                    return;
                }
                catch (IgniteCheckedException e) {
                    U.error(this.log, "Eviction future finished with error (all entries will be touched): " + fut, e);
                    if (this.plcEnabled) {
                        for (EvictionInfo info : fut.entries()) {
                            this.touch0(info.entry());
                        }
                    }
                    this.busyLock.leaveBusy();
                    this.signal();
                    return;
                }
                if (!fut.topologyVersion().equals(topVer)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Topology has changed, all entries will be touched: " + fut);
                    }
                    if (this.plcEnabled) {
                        for (EvictionInfo info : fut.entries()) {
                            this.touch0(info.entry());
                        }
                    }
                    return;
                }
                GridCacheVersion obsoleteVer = null;
                Collection evictedEntries = (Collection)t.get1();
                for (EvictionInfo info : evictedEntries) {
                    GridCacheEntryEx entry = info.entry();
                    try {
                        for (IgniteBiTuple<ClusterNode, Long> r : fut.evictedReaders(entry.key())) {
                            UUID readerId = r.get1().id();
                            Long msgId = r.get2();
                            ((GridDhtCacheEntry)entry).removeReader(readerId, msgId);
                        }
                        if (obsoleteVer == null) {
                            obsoleteVer = this.cctx.versions().next();
                        }
                        this.evict0(this.cctx.cache(), entry, obsoleteVer, this.versionFilter(info), false);
                    }
                    catch (IgniteCheckedException e) {
                        U.error(this.log, "Failed to evict entry [entry=" + entry + ", localNode=" + this.cctx.nodeId() + ']', e);
                    }
                    catch (GridCacheEntryRemovedException ignored) {
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug("Entry was concurrently removed while evicting [entry=" + entry + ", localNode=" + this.cctx.nodeId() + ']');
                    }
                }
                Collection rejectedEntries = (Collection)t.get2();
                if (this.plcEnabled && !rejectedEntries.isEmpty()) {
                    for (EvictionInfo info : rejectedEntries) {
                        this.touch0(info.entry());
                    }
                }
                break block25;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.busyLock.leaveBusy();
                this.signal();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signal() {
        this.futsCntLock.lock();
        try {
            int cnt = --this.activeFutsCnt;
            assert (cnt >= 0) : "Invalid futures count: " + cnt;
            if (cnt < this.maxActiveFuts) {
                this.futsCntCond.signalAll();
            }
        }
        finally {
            this.futsCntLock.unlock();
        }
    }

    private CacheEntryPredicate[] versionFilter(final EvictionInfo info) {
        return new CacheEntryPredicate[]{new CacheEntryPredicateAdapter(){

            @Override
            public boolean apply(GridCacheEntryEx e) {
                try {
                    GridCacheVersion ver = e.version();
                    return info.version().equals(ver) && F.isAll(info.filter(), new IgnitePredicate[0]);
                }
                catch (GridCacheEntryRemovedException ignored) {
                    return false;
                }
            }
        }};
    }

    private IgniteBiTuple<Collection<ClusterNode>, Collection<ClusterNode>> remoteNodes(GridCacheEntryEx entry, AffinityTopologyVersion topVer) throws GridCacheEntryRemovedException {
        assert (entry != null);
        assert (this.cctx.config().getCacheMode() != CacheMode.LOCAL);
        Collection<Object> backups = this.evictSync ? F.view(this.cctx.dht().topology().nodes(entry.partition(), topVer), F0.notEqualTo(this.cctx.localNode())) : Collections.emptySet();
        Collection<Object> readers = this.nearSync ? F.transform(((GridDhtCacheEntry)entry).readers(), new C1<UUID, ClusterNode>(){

            @Override
            @Nullable
            public ClusterNode apply(UUID nodeId) {
                return GridCacheEvictionManager.this.cctx.node(nodeId);
            }
        }) : Collections.emptySet();
        return new IgnitePair<Collection<ClusterNode>>((Collection<ClusterNode>)backups, (Collection<ClusterNode>)readers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unwind() {
        if (!this.evictSyncAgr) {
            return;
        }
        if (!this.busyLock.enterBusy()) {
            return;
        }
        try {
            this.checkEvictionQueue();
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private void notifyPolicy(GridCacheEntryEx e) {
        assert (this.plcEnabled);
        assert (this.plc != null);
        assert (!e.isInternal()) : "Invalid entry for policy notification: " + e;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Notifying eviction policy with entry: " + e);
        }
        if (this.filter == null || this.filter.evictAllowed(e.wrapLazyValue(this.cctx.keepBinary()))) {
            this.plc.onEntryAccessed(e.obsoleteOrDeleted(), e.wrapEviction());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForEvictionFutures() {
        if (this.activeFutsCnt >= this.maxActiveFuts) {
            boolean interrupted = false;
            this.futsCntLock.lock();
            try {
                while (!this.stopping && this.activeFutsCnt >= this.maxActiveFuts) {
                    try {
                        this.futsCntCond.await(2000L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException ignored) {
                        interrupted = true;
                    }
                }
            }
            finally {
                this.futsCntLock.unlock();
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public void printStats() {
        X.println("Eviction stats [grid=" + this.cctx.gridName() + ", cache=" + this.cctx.cache().name() + ", buffEvictQ=" + this.bufEvictQ.sizex() + ']', new Object[0]);
    }

    @Override
    public void printMemoryStats() {
        X.println(">>> ", new Object[0]);
        X.println(">>> Eviction manager memory stats [grid=" + this.cctx.gridName() + ", cache=" + this.cctx.name() + ']', new Object[0]);
        X.println(">>>   buffEvictQ size: " + this.bufEvictQ.sizex(), new Object[0]);
        X.println(">>>   futsSize: " + this.futs.size(), new Object[0]);
        X.println(">>>   futsCreated: " + this.idGen.get(), new Object[0]);
    }

    private class EvictionFuture
    extends GridFutureAdapter<IgniteBiTuple<Collection<EvictionInfo>, Collection<EvictionInfo>>> {
        private static final long serialVersionUID = 0L;
        private final long id;
        private ConcurrentLinkedDeque8<EvictionInfo> evictInfos;
        private final ConcurrentMap<KeyCacheObject, EvictionInfo> entries;
        private final ConcurrentMap<KeyCacheObject, Collection<ClusterNode>> readers;
        private final Collection<EvictionInfo> evictedEntries;
        private final ConcurrentMap<KeyCacheObject, EvictionInfo> rejectedEntries;
        private final ConcurrentMap<UUID, GridCacheEvictionRequest> reqMap;
        private final ConcurrentMap<UUID, GridCacheEvictionResponse> resMap;
        private final AtomicBoolean finishPrepare;
        @GridToStringExclude
        private final ReadWriteLock prepareLock;
        private final AtomicBoolean completing;
        @GridToStringExclude
        private final ReadWriteLock lock;
        @GridToStringExclude
        private GridTimeoutObject timeoutObj;
        private AffinityTopologyVersion topVer;

        private EvictionFuture() {
            this.id = GridCacheEvictionManager.this.idGen.incrementAndGet();
            this.evictInfos = new ConcurrentLinkedDeque8();
            this.entries = new ConcurrentHashMap8<KeyCacheObject, EvictionInfo>();
            this.readers = new ConcurrentHashMap8<KeyCacheObject, Collection<ClusterNode>>();
            this.evictedEntries = new GridConcurrentHashSet<EvictionInfo>();
            this.rejectedEntries = new ConcurrentHashMap8<KeyCacheObject, EvictionInfo>();
            this.reqMap = new ConcurrentHashMap8<UUID, GridCacheEvictionRequest>();
            this.resMap = new ConcurrentHashMap8<UUID, GridCacheEvictionResponse>();
            this.finishPrepare = new AtomicBoolean();
            this.prepareLock = new ReentrantReadWriteLock();
            this.completing = new AtomicBoolean();
            this.lock = new ReentrantReadWriteLock();
            this.topVer = AffinityTopologyVersion.ZERO;
        }

        boolean prepareLock() {
            return this.prepareLock.readLock().tryLock();
        }

        void prepareUnlock() {
            this.prepareLock.readLock().unlock();
        }

        boolean add(Collection<EvictionInfo> infos) {
            assert (infos != null && !infos.isEmpty());
            if (this.evictInfos.sizex() > GridCacheEvictionManager.this.maxQueueSize()) {
                return false;
            }
            this.evictInfos.addAll(infos);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean prepare() {
            if (this.evictInfos.sizex() >= GridCacheEvictionManager.this.maxQueueSize() && this.finishPrepare.compareAndSet(false, true)) {
                this.prepareLock.writeLock().lock();
                GridCacheEvictionManager.this.futsCntLock.lock();
                try {
                    GridCacheEvictionManager.this.activeFutsCnt++;
                }
                finally {
                    GridCacheEvictionManager.this.futsCntLock.unlock();
                }
                GridCacheEvictionManager.this.futs.put(this.id, this);
                this.prepare0();
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void prepare0() {
            if (GridCacheEvictionManager.this.log.isDebugEnabled()) {
                GridCacheEvictionManager.this.log.debug("Preparing eviction future [futId=" + this.id + ", localNode=" + GridCacheEvictionManager.this.cctx.nodeId() + ", infos=" + this.evictInfos + ']');
            }
            assert (this.evictInfos != null && !this.evictInfos.isEmpty());
            this.topVer = GridCacheEvictionManager.this.lockTopology();
            try {
                HashSet<EvictionInfo> locals = null;
                for (EvictionInfo info : this.evictInfos) {
                    IgniteBiTuple tup;
                    ConcurrentLinkedDeque8.Node queueNode = (ConcurrentLinkedDeque8.Node)info.entry().removeMeta(META_KEY);
                    if (queueNode != null) {
                        GridCacheEvictionManager.this.bufEvictQ.unlinkx(queueNode);
                    }
                    try {
                        tup = GridCacheEvictionManager.this.remoteNodes(info.entry(), this.topVer);
                    }
                    catch (GridCacheEntryRemovedException ignored) {
                        if (!GridCacheEvictionManager.this.log.isDebugEnabled()) continue;
                        GridCacheEvictionManager.this.log.debug("Entry got removed while preparing eviction future (ignoring) [entry=" + info.entry() + ", nodeId=" + GridCacheEvictionManager.this.cctx.nodeId() + ']');
                        continue;
                    }
                    Collection entryReaders = F.addIfAbsent(this.readers, info.entry().key(), new GridConcurrentHashSet());
                    assert (entryReaders != null);
                    entryReaders.addAll((Collection)tup.get2());
                    Collection<ClusterNode> nodes = F.concat(true, (Collection)tup.get1(), (Collection)tup.get2());
                    if (!nodes.isEmpty()) {
                        this.entries.put(info.entry().key(), info);
                        for (ClusterNode node : nodes) {
                            GridCacheEvictionRequest req = F.addIfAbsent(this.reqMap, node.id(), new GridCacheEvictionRequest(GridCacheEvictionManager.this.cctx.cacheId(), this.id, this.evictInfos.size(), this.topVer, GridCacheEvictionManager.this.cctx.deploymentEnabled()));
                            assert (req != null);
                            req.addKey(info.entry().key(), info.version(), entryReaders.contains(node));
                        }
                        continue;
                    }
                    if (locals == null) {
                        locals = new HashSet<EvictionInfo>(this.evictInfos.size(), 1.0f);
                    }
                    locals.add(info);
                }
                if (locals != null) {
                    GridCacheVersion obsoleteVer = GridCacheEvictionManager.this.cctx.versions().next();
                    for (EvictionInfo info : locals) {
                        if (GridCacheEvictionManager.this.log.isDebugEnabled()) {
                            GridCacheEvictionManager.this.log.debug("Evicting key without remote participant nodes: " + info);
                        }
                        try {
                            if (GridCacheEvictionManager.this.evict0(GridCacheEvictionManager.this.cctx.cache(), info.entry(), obsoleteVer, GridCacheEvictionManager.this.versionFilter(info), false) || !GridCacheEvictionManager.this.plcEnabled) continue;
                            GridCacheEvictionManager.this.touch0(info.entry());
                        }
                        catch (IgniteCheckedException e) {
                            U.error(GridCacheEvictionManager.this.log, "Failed to evict entry: " + info.entry(), e);
                        }
                    }
                }
                if (this.entries.isEmpty()) {
                    this.complete(false);
                    return;
                }
            }
            finally {
                GridCacheEvictionManager.this.unlockTopology();
            }
            for (Map.Entry e : this.reqMap.entrySet()) {
                UUID nodeId = (UUID)e.getKey();
                GridCacheEvictionRequest req = (GridCacheEvictionRequest)e.getValue();
                if (GridCacheEvictionManager.this.log.isDebugEnabled()) {
                    GridCacheEvictionManager.this.log.debug("Sending eviction request [node=" + nodeId + ", req=" + req + ']');
                }
                try {
                    GridCacheEvictionManager.this.cctx.io().send(nodeId, (GridCacheMessage)req, GridCacheEvictionManager.this.cctx.ioPolicy());
                }
                catch (ClusterTopologyCheckedException ignored) {
                    this.onNodeLeft(nodeId);
                }
                catch (IgniteCheckedException ex) {
                    U.error(GridCacheEvictionManager.this.log, "Failed to send eviction request to node [node=" + nodeId + ", req=" + req + ']', ex);
                    this.rejectEntries(nodeId);
                }
            }
            this.registerTimeoutObject();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerTimeoutObject() {
            if (this.lock.readLock().tryLock()) {
                try {
                    this.timeoutObj = new GridTimeoutObjectAdapter(GridCacheEvictionManager.this.cctx.config().getEvictSynchronizedTimeout()){

                        @Override
                        public void onTimeout() {
                            EvictionFuture.this.complete(true);
                        }
                    };
                    GridCacheEvictionManager.this.cctx.time().addTimeoutObject(this.timeoutObj);
                }
                finally {
                    this.lock.readLock().unlock();
                }
            }
        }

        long id() {
            return this.id;
        }

        AffinityTopologyVersion topologyVersion() {
            return this.topVer;
        }

        Map<KeyCacheObject, Collection<ClusterNode>> readers() {
            return this.readers;
        }

        Collection<EvictionInfo> entries() {
            return this.entries.values();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void rejectEntries(UUID nodeId) {
            assert (nodeId != null);
            if (this.lock.readLock().tryLock()) {
                try {
                    if (GridCacheEvictionManager.this.log.isDebugEnabled()) {
                        GridCacheEvictionManager.this.log.debug("Rejecting entries for node: " + nodeId);
                    }
                    GridCacheEvictionRequest req = (GridCacheEvictionRequest)this.reqMap.remove(nodeId);
                    for (CacheEvictionEntry t : req.entries()) {
                        EvictionInfo info = (EvictionInfo)this.entries.get(t.key());
                        assert (info != null);
                        this.rejectedEntries.put(t.key(), info);
                    }
                }
                finally {
                    this.lock.readLock().unlock();
                }
            }
            this.checkDone();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onNodeLeft(UUID nodeId) {
            assert (nodeId != null);
            if (this.lock.readLock().tryLock()) {
                try {
                    this.reqMap.remove(nodeId);
                    this.resMap.remove(nodeId);
                }
                finally {
                    this.lock.readLock().unlock();
                }
                this.checkDone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onResponse(UUID nodeId, GridCacheEvictionResponse res) {
            assert (nodeId != null);
            assert (res != null);
            if (this.lock.readLock().tryLock()) {
                try {
                    ClusterNode node;
                    if (GridCacheEvictionManager.this.log.isDebugEnabled()) {
                        GridCacheEvictionManager.this.log.debug("Entered to eviction future onResponse() [fut=" + this + ", node=" + nodeId + ", res=" + res + ']');
                    }
                    if ((node = GridCacheEvictionManager.this.cctx.node(nodeId)) != null) {
                        this.resMap.put(nodeId, res);
                    } else {
                        this.reqMap.remove(nodeId);
                    }
                }
                finally {
                    this.lock.readLock().unlock();
                }
                if (res.evictError()) {
                    this.complete(false);
                } else {
                    this.checkDone();
                }
            } else if (GridCacheEvictionManager.this.log.isDebugEnabled()) {
                GridCacheEvictionManager.this.log.debug("Ignored eviction response [fut=" + this + ", node=" + nodeId + ", res=" + res + ']');
            }
        }

        private void checkDone() {
            if (this.reqMap.isEmpty() || this.resMap.keySet().containsAll(this.reqMap.keySet())) {
                this.complete(false);
            }
        }

        private void complete(boolean timedOut) {
            if (this.completing.compareAndSet(false, true)) {
                this.lock.writeLock().lock();
                GridCacheEvictionManager.this.futs.remove(this.id);
                if (this.timeoutObj != null && !timedOut) {
                    GridCacheEvictionManager.this.cctx.time().removeTimeoutObject(this.timeoutObj);
                }
                if (GridCacheEvictionManager.this.log.isDebugEnabled()) {
                    GridCacheEvictionManager.this.log.debug("Building eviction future result [fut=" + this + ", timedOut=" + timedOut + ']');
                }
                boolean err = false;
                for (GridCacheEvictionResponse res : this.resMap.values()) {
                    if (!res.evictError()) continue;
                    err = true;
                    break;
                }
                if (err) {
                    Collection ids = F.view(this.resMap.keySet(), new P1<UUID>(){

                        @Override
                        public boolean apply(UUID e) {
                            return ((GridCacheEvictionResponse)EvictionFuture.this.resMap.get(e)).evictError();
                        }
                    });
                    assert (!ids.isEmpty());
                    U.warn(GridCacheEvictionManager.this.log, "Remote node(s) failed to process eviction request due to topology changes (some backup or remote values maybe lost): " + ids);
                }
                if (timedOut) {
                    U.warn(GridCacheEvictionManager.this.log, "Timed out waiting for eviction future (consider changing 'evictSynchronousTimeout' and 'evictSynchronousConcurrencyLevel' configuration parameters).");
                }
                if (err || timedOut) {
                    assert (this.evictedEntries.isEmpty());
                    this.rejectedEntries.putAll(this.entries);
                } else {
                    HashMap<KeyCacheObject, EvictionInfo> rejectedEntries0 = new HashMap<KeyCacheObject, EvictionInfo>(this.rejectedEntries);
                    for (EvictionInfo info : this.entries.values()) {
                        KeyCacheObject key = info.entry().key();
                        if (rejectedEntries0.containsKey(key)) continue;
                        boolean rejected = false;
                        for (GridCacheEvictionResponse res : this.resMap.values()) {
                            if (!res.rejectedKeys().contains(key)) continue;
                            rejectedEntries0.put(key, info);
                            rejected = true;
                            break;
                        }
                        if (rejected) continue;
                        this.evictedEntries.add(info);
                    }
                }
                this.onDone(F.t(this.evictedEntries, this.rejectedEntries.values()));
            }
        }

        Collection<IgniteBiTuple<ClusterNode, Long>> evictedReaders(KeyCacheObject key) {
            Collection mappedReaders = (Collection)this.readers.get(key);
            if (mappedReaders == null) {
                return Collections.emptyList();
            }
            LinkedList<IgniteBiTuple<ClusterNode, Long>> col = new LinkedList<IgniteBiTuple<ClusterNode, Long>>();
            for (Map.Entry e : this.resMap.entrySet()) {
                GridCacheEvictionResponse res;
                ClusterNode node = GridCacheEvictionManager.this.cctx.node((UUID)e.getKey());
                if (node == null || !mappedReaders.contains(node) || (res = (GridCacheEvictionResponse)e.getValue()).rejectedKeys().contains(key)) continue;
                col.add(F.t(node, res.messageId()));
            }
            return col;
        }

        @Override
        public boolean cancel() {
            if (this.completing.compareAndSet(false, true)) {
                this.lock.writeLock().lock();
                if (this.timeoutObj != null) {
                    GridCacheEvictionManager.this.cctx.time().removeTimeoutObject(this.timeoutObj);
                }
                boolean b = this.onCancelled();
                assert (b);
                return true;
            }
            return false;
        }

        @Override
        public String toString() {
            return S.toString(EvictionFuture.class, this);
        }
    }

    private class EvictionInfo {
        private GridCacheEntryEx entry;
        private GridCacheVersion ver;
        private CacheEntryPredicate[] filter;

        EvictionInfo(GridCacheEntryEx entry, GridCacheVersion ver, CacheEntryPredicate[] filter) {
            assert (entry != null);
            assert (ver != null);
            this.entry = entry;
            this.ver = ver;
            this.filter = filter;
        }

        GridCacheEntryEx entry() {
            return this.entry;
        }

        GridCacheVersion version() {
            return this.ver;
        }

        CacheEntryPredicate[] filter() {
            return this.filter;
        }

        public String toString() {
            return S.toString(EvictionInfo.class, this);
        }
    }

    private class BackupWorker
    extends GridWorker {
        private final BlockingQueue<DiscoveryEvent> evts;
        private final Collection<Integer> primaryParts;

        private BackupWorker() {
            super(GridCacheEvictionManager.this.cctx.gridName(), "cache-eviction-backup-worker", GridCacheEvictionManager.this.log);
            this.evts = new LinkedBlockingQueue<DiscoveryEvent>();
            this.primaryParts = new HashSet<Integer>();
            assert (GridCacheEvictionManager.this.plcEnabled);
        }

        void addEvent(DiscoveryEvent evt) {
            assert (evt != null);
            this.evts.add(evt);
        }

        @Override
        protected void body() throws InterruptedException, IgniteInterruptedCheckedException {
            block10: {
                try {
                    assert (!GridCacheEvictionManager.this.cctx.isNear() && GridCacheEvictionManager.this.evictSync);
                    ClusterNode loc = GridCacheEvictionManager.this.cctx.localNode();
                    AffinityTopologyVersion initTopVer = new AffinityTopologyVersion(GridCacheEvictionManager.this.cctx.discovery().localJoinEvent().topologyVersion(), 0);
                    AffinityTopologyVersion cacheStartVer = GridCacheEvictionManager.this.cctx.startTopologyVersion();
                    if (cacheStartVer != null && cacheStartVer.compareTo(initTopVer) > 0) {
                        initTopVer = cacheStartVer;
                    }
                    this.primaryParts.addAll(GridCacheEvictionManager.this.cctx.affinity().primaryPartitions(GridCacheEvictionManager.this.cctx.localNodeId(), initTopVer));
                    block3: while (!this.isCancelled()) {
                        DiscoveryEvent evt = this.evts.take();
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Processing event: " + evt);
                        }
                        AffinityTopologyVersion topVer = new AffinityTopologyVersion(evt.topologyVersion());
                        Iterator<Integer> it = this.primaryParts.iterator();
                        while (it.hasNext() && this.evts.isEmpty()) {
                            if (GridCacheEvictionManager.this.cctx.affinity().primaryByPartition(loc, it.next(), topVer)) continue;
                            it.remove();
                        }
                        if (!this.evts.isEmpty()) continue;
                        for (GridDhtLocalPartition part : GridCacheEvictionManager.this.cctx.topology().localPartitions()) {
                            if (!this.evts.isEmpty()) continue block3;
                            if (!part.primary(topVer) || !this.primaryParts.add(part.id())) continue;
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Touching partition entries: " + part);
                            }
                            GridCacheEvictionManager.this.touchOnTopologyChange(part.allEntries(new CacheEntryPredicate[0]));
                        }
                    }
                }
                catch (InterruptedException loc) {
                }
                catch (IgniteException e) {
                    if (e.hasCause(InterruptedException.class)) break block10;
                    throw e;
                }
            }
        }
    }
}

