/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEvictionEntry;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheDeployable;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.NotNull;

public class GridCacheEvictionRequest
extends GridCacheMessage
implements GridCacheDeployable {
    private static final long serialVersionUID = 0L;
    private long futId;
    @GridToStringInclude
    @GridDirectCollection(value=CacheEvictionEntry.class)
    private Collection<CacheEvictionEntry> entries;
    private AffinityTopologyVersion topVer;

    public GridCacheEvictionRequest() {
    }

    GridCacheEvictionRequest(int cacheId, long futId, int size, @NotNull AffinityTopologyVersion topVer, boolean addDepInfo) {
        assert (futId > 0L);
        assert (size > 0);
        assert (topVer.topologyVersion() > 0L);
        this.cacheId = cacheId;
        this.futId = futId;
        this.addDepInfo = addDepInfo;
        this.entries = new ArrayList<CacheEvictionEntry>(size);
        this.topVer = topVer;
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        if (this.entries != null) {
            GridCacheContext cctx = ctx.cacheContext(this.cacheId);
            for (CacheEvictionEntry e : this.entries) {
                e.prepareMarshal(cctx);
                if (!this.addDepInfo) continue;
                this.prepareObject(e.key().value(cctx.cacheObjectContext(), false), cctx);
            }
        }
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        if (this.entries != null) {
            GridCacheContext cctx = ctx.cacheContext(this.cacheId);
            for (CacheEvictionEntry e : this.entries) {
                e.finishUnmarshal(cctx, ldr);
            }
        }
    }

    @Override
    public boolean addDeploymentInfo() {
        return this.addDepInfo;
    }

    long futureId() {
        return this.futId;
    }

    Collection<CacheEvictionEntry> entries() {
        return this.entries;
    }

    @Override
    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    void addKey(KeyCacheObject key, GridCacheVersion ver, boolean near) {
        assert (key != null);
        assert (ver != null);
        this.entries.add(new CacheEvictionEntry(key, ver, near));
    }

    @Override
    public boolean ignoreClassErrors() {
        return true;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 3: {
                if (!writer.writeCollection("entries", this.entries, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeLong("futId", this.futId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeMessage("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 3: {
                this.entries = reader.readCollection("entries", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.futId = reader.readLong("futId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.topVer = (AffinityTopologyVersion)reader.readMessage("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridCacheEvictionRequest.class);
    }

    @Override
    public byte directType() {
        return 14;
    }

    @Override
    public byte fieldsCount() {
        return 6;
    }

    @Override
    public String toString() {
        return S.toString(GridCacheEvictionRequest.class, this);
    }
}

