/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashSet;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class GridCacheEvictionResponse
extends GridCacheMessage {
    private static final long serialVersionUID = 0L;
    private long futId;
    @GridToStringInclude
    @GridDirectCollection(value=KeyCacheObject.class)
    private Collection<KeyCacheObject> rejectedKeys = new HashSet<KeyCacheObject>();
    private boolean err;

    public GridCacheEvictionResponse() {
    }

    GridCacheEvictionResponse(int cacheId, long futId) {
        this(cacheId, futId, false);
    }

    GridCacheEvictionResponse(int cacheId, long futId, boolean err) {
        this.cacheId = cacheId;
        this.futId = futId;
        this.err = err;
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        this.prepareMarshalCacheObjects(this.rejectedKeys, ctx.cacheContext(this.cacheId));
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        this.finishUnmarshalCacheObjects(this.rejectedKeys, ctx.cacheContext(this.cacheId), ldr);
    }

    @Override
    public boolean addDeploymentInfo() {
        return false;
    }

    long futureId() {
        return this.futId;
    }

    Collection<KeyCacheObject> rejectedKeys() {
        return this.rejectedKeys;
    }

    void addRejected(KeyCacheObject key) {
        assert (key != null);
        this.rejectedKeys.add(key);
    }

    boolean evictError() {
        return this.err;
    }

    @Override
    public boolean ignoreClassErrors() {
        return true;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 3: {
                if (!writer.writeBoolean("err", this.err)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeLong("futId", this.futId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeCollection("rejectedKeys", this.rejectedKeys, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 3: {
                this.err = reader.readBoolean("err");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.futId = reader.readLong("futId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.rejectedKeys = reader.readCollection("rejectedKeys", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridCacheEvictionResponse.class);
    }

    @Override
    public byte directType() {
        return 15;
    }

    @Override
    public byte fieldsCount() {
        return 6;
    }

    @Override
    public String toString() {
        return S.toString(GridCacheEvictionResponse.class, this);
    }
}

