/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.concurrent.atomic.AtomicReference;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteClientDisconnectedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.cache.CacheOperationContext;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCachePreloader;
import org.apache.ignite.internal.util.GridSpinReadWriteLock;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteFuture;
import org.jetbrains.annotations.Nullable;

@GridToStringExclude
public class GridCacheGateway<K, V> {
    private final GridCacheContext<K, V> ctx;
    private final AtomicReference<State> state = new AtomicReference<State>(State.STARTED);
    private IgniteFuture<?> reconnectFut;
    private GridSpinReadWriteLock rwLock = new GridSpinReadWriteLock();

    public GridCacheGateway(GridCacheContext<K, V> ctx) {
        assert (ctx != null);
        this.ctx = ctx;
    }

    public void enter() {
        if (this.ctx.deploymentEnabled()) {
            this.ctx.deploy().onEnter();
        }
        this.rwLock.readLock();
        this.checkState(true, true);
    }

    private boolean checkState(boolean lock, boolean stopErr) {
        State state = this.state.get();
        if (state != State.STARTED) {
            if (lock) {
                this.rwLock.readUnlock();
            }
            if (state == State.STOPPED) {
                if (stopErr) {
                    throw new IllegalStateException("Cache has been stopped: " + this.ctx.name());
                }
                return false;
            }
            assert (this.reconnectFut != null);
            throw new CacheException(new IgniteClientDisconnectedException(this.reconnectFut, "Client node disconnected: " + this.ctx.gridName()));
        }
        return true;
    }

    public boolean enterIfNotStopped() {
        this.onEnter();
        this.rwLock.readLock();
        return this.checkState(true, false);
    }

    public boolean enterIfNotStoppedNoLock() {
        this.onEnter();
        return this.checkState(false, false);
    }

    public void leaveNoLock() {
        this.ctx.tm().resetContext();
        this.ctx.mvcc().contextReset();
        if (!this.ctx.shared().closed(this.ctx)) {
            CU.unwindEvicts(this.ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leave() {
        try {
            this.leaveNoLock();
        }
        finally {
            this.rwLock.readUnlock();
        }
    }

    @Nullable
    public CacheOperationContext enter(@Nullable CacheOperationContext opCtx) {
        try {
            GridCachePreloader preldr;
            GridCacheAdapter<K, V> cache = this.ctx.cache();
            GridCachePreloader gridCachePreloader = preldr = cache != null ? cache.preloader() : null;
            if (preldr == null) {
                throw new IllegalStateException("Cache has been closed or destroyed: " + this.ctx.name());
            }
            preldr.startFuture().get();
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed to wait for cache preloader start [cacheName=" + this.ctx.name() + "]", e);
        }
        this.onEnter();
        this.rwLock.readLock();
        this.checkState(true, true);
        try {
            return this.setOperationContextPerCall(opCtx);
        }
        catch (Throwable e) {
            this.rwLock.readUnlock();
            throw e;
        }
    }

    @Nullable
    public CacheOperationContext enterNoLock(@Nullable CacheOperationContext opCtx) {
        this.onEnter();
        this.checkState(false, false);
        return this.setOperationContextPerCall(opCtx);
    }

    private CacheOperationContext setOperationContextPerCall(@Nullable CacheOperationContext opCtx) {
        CacheOperationContext prev = this.ctx.operationContextPerCall();
        if (prev != null || opCtx != null) {
            this.ctx.operationContextPerCall(opCtx);
        }
        return prev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leave(CacheOperationContext prev) {
        try {
            this.leaveNoLock(prev);
        }
        finally {
            this.rwLock.readUnlock();
        }
    }

    public void leaveNoLock(CacheOperationContext prev) {
        this.ctx.tm().resetContext();
        this.ctx.mvcc().contextReset();
        CU.unwindEvicts(this.ctx);
        this.ctx.operationContextPerCall(prev);
    }

    private void onEnter() {
        this.ctx.itHolder().checkWeakQueue();
        if (this.ctx.deploymentEnabled()) {
            this.ctx.deploy().onEnter();
        }
    }

    public void stopped() {
        this.state.set(State.STOPPED);
    }

    public void onDisconnected(IgniteFuture<?> reconnectFut) {
        assert (reconnectFut != null);
        this.reconnectFut = reconnectFut;
        this.state.compareAndSet(State.STARTED, State.DISCONNECTED);
    }

    public void writeLock() {
        this.rwLock.writeLock();
    }

    public void writeUnlock() {
        this.rwLock.writeUnlock();
    }

    public void reconnected(boolean stopped) {
        State newState = stopped ? State.STOPPED : State.STARTED;
        this.state.compareAndSet(State.DISCONNECTED, newState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStopped() {
        boolean interrupted = false;
        while (!this.rwLock.tryWriteLock()) {
            try {
                U.sleep(200L);
            }
            catch (IgniteInterruptedCheckedException ignore) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        try {
            this.state.set(State.STOPPED);
        }
        finally {
            this.rwLock.writeUnlock();
        }
    }

    private static enum State {
        STARTED,
        DISCONNECTED,
        STOPPED;

    }
}

