/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import javax.cache.Cache;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorResult;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicWriteOrderMode;
import org.apache.ignite.cache.CacheMemoryMode;
import org.apache.ignite.cache.eviction.EvictableEntry;
import org.apache.ignite.internal.binary.BinaryObjectOffheapImpl;
import org.apache.ignite.internal.managers.deployment.GridDeploymentInfo;
import org.apache.ignite.internal.managers.deployment.GridDeploymentInfoBean;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryImpl;
import org.apache.ignite.internal.processors.cache.CacheEntryImplEx;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CacheEvictableEntryImpl;
import org.apache.ignite.internal.processors.cache.CacheInvokeEntry;
import org.apache.ignite.internal.processors.cache.CacheInvokeResult;
import org.apache.ignite.internal.processors.cache.CacheLazyEntry;
import org.apache.ignite.internal.processors.cache.CacheLockCandidates;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheOperationContext;
import org.apache.ignite.internal.processors.cache.EntryGetResult;
import org.apache.ignite.internal.processors.cache.EntryGetWithTtlResult;
import org.apache.ignite.internal.processors.cache.EntryProcessorResourceInjectorProxy;
import org.apache.ignite.internal.processors.cache.GridCacheAtomicVersionComparator;
import org.apache.ignite.internal.processors.cache.GridCacheBatchSwapEntry;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheFilterFailedException;
import org.apache.ignite.internal.processors.cache.GridCacheIndexUpdateException;
import org.apache.ignite.internal.processors.cache.GridCacheMvcc;
import org.apache.ignite.internal.processors.cache.GridCacheMvccCandidate;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheSwapEntry;
import org.apache.ignite.internal.processors.cache.GridCacheUpdateAtomicResult;
import org.apache.ignite.internal.processors.cache.GridCacheUpdateTxResult;
import org.apache.ignite.internal.processors.cache.IgniteCacheExpiryPolicy;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.ReaderArguments;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicAbstractUpdateFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearCacheEntry;
import org.apache.ignite.internal.processors.cache.extras.GridCacheEntryExtras;
import org.apache.ignite.internal.processors.cache.extras.GridCacheMvccEntryExtras;
import org.apache.ignite.internal.processors.cache.extras.GridCacheObsoleteEntryExtras;
import org.apache.ignite.internal.processors.cache.extras.GridCacheTtlEntryExtras;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryManager;
import org.apache.ignite.internal.processors.cache.query.continuous.CacheContinuousQueryListener;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxLocalAdapter;
import org.apache.ignite.internal.processors.cache.version.GridCacheLazyPlainVersionedEntry;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionConflictContext;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionEx;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionedEntryEx;
import org.apache.ignite.internal.processors.dr.GridDrType;
import org.apache.ignite.internal.util.lang.GridClosureException;
import org.apache.ignite.internal.util.lang.GridMetadataAwareAdapter;
import org.apache.ignite.internal.util.lang.GridTuple;
import org.apache.ignite.internal.util.lang.GridTuple3;
import org.apache.ignite.internal.util.offheap.unsafe.GridUnsafeMemory;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T3;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public abstract class GridCacheMapEntry
extends GridMetadataAwareAdapter
implements GridCacheEntryEx {
    private static final byte IS_DELETED_MASK = 1;
    private static final byte IS_UNSWAPPED_MASK = 2;
    private static final byte IS_OFFHEAP_PTR_MASK = 4;
    private static final byte IS_SWAPPING_REQUIRED = 8;
    private static final byte IS_EVICT_DISABLED = 16;
    public static final GridCacheAtomicVersionComparator ATOMIC_VER_COMPARATOR = new GridCacheAtomicVersionComparator();
    private static final int SIZE_OVERHEAD = 145;
    protected static final AtomicReference<IgniteLogger> logRef = new AtomicReference();
    protected static volatile IgniteLogger log;
    @GridToStringExclude
    protected final GridCacheContext<?, ?> cctx;
    @GridToStringInclude
    protected final KeyCacheObject key;
    @GridToStringInclude
    protected CacheObject val;
    @GridToStringInclude
    protected final long startVer;
    @GridToStringInclude
    protected GridCacheVersion ver;
    @GridToStringInclude
    private final int hash;
    @GridToStringInclude
    private GridCacheEntryExtras extras;
    @GridToStringInclude
    protected byte flags;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GridCacheMapEntry(GridCacheContext<?, ?> cctx, KeyCacheObject key, int hash, CacheObject val) {
        if (log == null) {
            log = U.logger(cctx.kernalContext(), logRef, GridCacheMapEntry.class);
        }
        key = (KeyCacheObject)cctx.kernalContext().cacheObjects().prepareForCache(key, cctx);
        assert (key != null);
        this.key = key;
        this.hash = hash;
        this.cctx = cctx;
        val = cctx.kernalContext().cacheObjects().prepareForCache(val, cctx);
        GridCacheMapEntry gridCacheMapEntry = this;
        synchronized (gridCacheMapEntry) {
            this.value(val);
        }
        this.ver = cctx.versions().next();
        this.startVer = this.ver.order();
    }

    @Override
    public long startVersion() {
        return this.startVer;
    }

    protected void value(@Nullable CacheObject val) {
        int oldSize;
        int newSize;
        int delta;
        assert (Thread.holdsLock(this));
        if (this.cctx.cache().isIgfsDataCache() && this.cctx.kernalContext().igfsHelper().isIgfsBlockKey(this.keyValue(false)) && (delta = (newSize = this.valueLength0(val, null)) - (oldSize = this.valueLength0(this.val, this.val == null && this.hasOffHeapPointer() ? this.valueBytes0() : null))) != 0 && !this.cctx.isNear()) {
            this.cctx.cache().onIgfsDataSizeChanged(delta);
        }
        if (!this.isOffHeapValuesOnly()) {
            this.val = val;
            this.offHeapPointer(0L);
        } else {
            try {
                if (this.cctx.deploymentEnabled()) {
                    Object val0 = null;
                    if (val != null && val.cacheObjectType() != 2 && (val0 = this.cctx.cacheObjects().unmarshal(this.cctx.cacheObjectContext(), val.valueBytes(this.cctx.cacheObjectContext()), this.cctx.deploy().globalLoader())) != null) {
                        this.cctx.gridDeploy().deploy(val0.getClass(), val0.getClass().getClassLoader());
                    }
                    if (U.p2pLoader(val0)) {
                        this.cctx.deploy().addDeploymentContext(new GridDeploymentInfoBean((GridDeploymentInfo)((Object)val0.getClass().getClassLoader())));
                    }
                }
                GridUnsafeMemory mem = this.cctx.unsafeMemory();
                assert (mem != null);
                if (val != null) {
                    byte type = val.cacheObjectType();
                    this.offHeapPointer(mem.putOffHeap(this.offHeapPointer(), val.valueBytes(this.cctx.cacheObjectContext()), type));
                } else {
                    mem.removeOffHeap(this.offHeapPointer());
                    this.offHeapPointer(0L);
                }
            }
            catch (IgniteCheckedException e) {
                U.error(log, "Failed to deserialize value [entry=" + this + ", val=" + val + ']');
                throw new IgniteException(e);
            }
        }
    }

    private int valueLength0(@Nullable CacheObject val, @Nullable IgniteBiTuple<byte[], Byte> valBytes) {
        byte[] bytes;
        byte[] byArray = bytes = val != null ? (byte[])val.value(this.cctx.cacheObjectContext(), false) : null;
        if (bytes != null) {
            return bytes.length;
        }
        if (valBytes == null) {
            return 0;
        }
        return valBytes.get1().length - (valBytes.get2() == 2 ? 0 : 6);
    }

    protected CacheObject valueBytesUnlocked() {
        assert (Thread.holdsLock(this));
        CacheObject val0 = this.val;
        if (val0 == null && this.hasOffHeapPointer()) {
            IgniteBiTuple<byte[], Byte> t = this.valueBytes0();
            return this.cctx.cacheObjects().toCacheObject(this.cctx.cacheObjectContext(), t.get2(), t.get1());
        }
        return val0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int memorySize() throws IgniteCheckedException {
        int extrasSize;
        byte[] kb;
        byte[] vb = null;
        GridCacheMapEntry gridCacheMapEntry = this;
        synchronized (gridCacheMapEntry) {
            this.key.prepareMarshal(this.cctx.cacheObjectContext());
            kb = this.key.valueBytes(this.cctx.cacheObjectContext());
            if (this.val != null) {
                this.val.prepareMarshal(this.cctx.cacheObjectContext());
                vb = this.val.valueBytes(this.cctx.cacheObjectContext());
            }
            extrasSize = this.extrasSize();
        }
        return 145 + extrasSize + kb.length + (vb == null ? 1 : vb.length);
    }

    @Override
    public boolean isInternal() {
        return this.key.internal();
    }

    @Override
    public boolean isDht() {
        return false;
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public boolean isNear() {
        return false;
    }

    @Override
    public boolean isReplicated() {
        return false;
    }

    @Override
    public boolean detached() {
        return false;
    }

    @Override
    public <K, V> GridCacheContext<K, V> context() {
        return this.cctx;
    }

    @Override
    public boolean isNew() throws GridCacheEntryRemovedException {
        assert (Thread.holdsLock(this));
        this.checkObsolete();
        return this.isStartVersion();
    }

    @Override
    public synchronized boolean isNewLocked() throws GridCacheEntryRemovedException {
        this.checkObsolete();
        return this.isStartVersion();
    }

    public boolean isStartVersion() {
        return (long)this.ver.nodeOrder() == this.cctx.localNode().order() && this.ver.order() == this.startVer;
    }

    @Override
    public boolean valid(AffinityTopologyVersion topVer) {
        return true;
    }

    @Override
    public int partition() {
        return 0;
    }

    @Override
    public boolean partitionValid() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public GridCacheEntryInfo info() {
        GridCacheEntryInfo info = null;
        long time = U.currentTimeMillis();
        GridCacheMapEntry gridCacheMapEntry = this;
        synchronized (gridCacheMapEntry) {
            if (!this.obsolete()) {
                info = new GridCacheEntryInfo();
                info.key(this.key);
                info.cacheId(this.cctx.cacheId());
                long expireTime = this.expireTimeExtras();
                boolean expired = expireTime != 0L && expireTime <= time;
                info.ttl(this.ttlExtras());
                info.expireTime(expireTime);
                info.version(this.ver);
                info.setNew(this.isStartVersion());
                info.setDeleted(this.deletedUnlocked());
                if (!expired) {
                    info.value(this.valueBytesUnlocked());
                }
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onOffheapEvict(byte[] entry, GridCacheVersion evictVer, GridCacheVersion obsoleteVer) throws IgniteCheckedException, GridCacheEntryRemovedException {
        boolean obsolete;
        assert (this.cctx.swap().offHeapEnabled() && (this.cctx.swap().swapEnabled() || this.cctx.queries().enabled())) : this;
        GridCacheMapEntry gridCacheMapEntry = this;
        synchronized (gridCacheMapEntry) {
            this.checkObsolete();
            if (this.hasReaders() || !this.isStartVersion()) {
                return false;
            }
            GridCacheMvcc mvcc = this.mvccExtras();
            if (mvcc != null && !mvcc.isEmpty(obsoleteVer)) {
                return false;
            }
            if (this.cctx.swap().onOffheapEvict(this.key, entry, this.partition(), evictVer)) {
                assert (!this.hasValueUnlocked()) : this;
                if (log.isTraceEnabled()) {
                    log.trace("onOffheapEvict evicted [key=" + this.key + ", entry=" + System.identityHashCode(this) + ", ptr=" + this.offHeapPointer() + ']');
                }
                obsolete = this.markObsolete0(obsoleteVer, false, null);
                assert (obsolete) : this;
                if (!this.cctx.swap().swapEnabled()) {
                    CacheObject val = this.cctx.swap().unmarshalSwapEntryValue(entry);
                    this.clearIndex(val);
                }
            } else {
                obsolete = false;
                if (log.isTraceEnabled()) {
                    log.trace("onOffheapEvict not evicted [key=" + this.key + ", entry=" + System.identityHashCode(this) + ", ptr=" + this.offHeapPointer() + ']');
                }
            }
        }
        if (obsolete) {
            this.onMarkedObsolete();
        }
        return obsolete;
    }

    @Override
    public final CacheObject unswap() throws IgniteCheckedException, GridCacheEntryRemovedException {
        return this.unswap(true);
    }

    @Override
    @Nullable
    public final CacheObject unswap(boolean needVal) throws IgniteCheckedException, GridCacheEntryRemovedException {
        return this.unswap(needVal, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected CacheObject unswap(boolean needVal, boolean checkExpire) throws IgniteCheckedException, GridCacheEntryRemovedException {
        if (!this.cctx.isSwapOrOffheapEnabled()) {
            return null;
        }
        assert (!this.detached()) : this;
        boolean obsolete = false;
        boolean deferred = false;
        GridCacheVersion ver0 = null;
        GridCacheMapEntry gridCacheMapEntry = this;
        synchronized (gridCacheMapEntry) {
            this.checkObsolete();
            if (this.isStartVersion() && (this.flags & 2) == 0) {
                GridCacheSwapEntry e;
                if (this.cctx.offheapTiered()) {
                    e = this.cctx.swap().readOffheapPointer(this);
                    if (log.isTraceEnabled()) {
                        if (e != null) {
                            log.trace("Read offheap pointer [key=" + this.key + ", entry=" + System.identityHashCode(this) + ", ptr=" + e.offheapPointer() + ']');
                        } else {
                            log.trace("Read offheap pointer [key=" + this.key + ", entry=" + System.identityHashCode(this) + ", val=" + null + ']');
                        }
                    }
                    if (e != null) {
                        if (e.offheapPointer() > 0L) {
                            this.offHeapPointer(e.offheapPointer());
                            this.flags = (byte)(this.flags | 4);
                            if (needVal) {
                                CacheObject val = this.cctx.fromOffheap(e.offheapPointer(), false);
                                e.value(val);
                            }
                        } else {
                            this.offHeapPointer(0L);
                        }
                    }
                } else {
                    e = this.cctx.swap().readAndRemove(this);
                    if (log.isTraceEnabled()) {
                        log.trace("unswap readAndRemove [key=" + this.key + ", entry=" + System.identityHashCode(this) + ", found=" + (e != null) + ']');
                    }
                }
                this.flags = (byte)(this.flags | 2);
                if (e != null) {
                    long delta = checkExpire ? (e.expireTime() == 0L ? 0L : e.expireTime() - U.currentTimeMillis()) : 0L;
                    CacheObject val = e.value();
                    val = this.cctx.kernalContext().cacheObjects().prepareForCache(val, this.cctx);
                    this.update(val, e.expireTime(), e.ttl(), e.version(), false);
                    if (this.cctx.offheapTiered() && e.offheapPointer() > 0L) {
                        this.offHeapPointer(e.offheapPointer());
                    }
                    if (delta >= 0L) {
                        return val;
                    }
                    CacheObject expiredVal = this.rawGetOrUnmarshal(false);
                    if (this.onExpired(expiredVal, null)) {
                        if (this.cctx.deferredDelete()) {
                            deferred = true;
                            ver0 = this.ver;
                        } else {
                            obsolete = true;
                        }
                    }
                }
            }
        }
        if (obsolete) {
            this.onMarkedObsolete();
            this.cctx.cache().removeEntry(this);
        }
        if (deferred) {
            assert (ver0 != null);
            this.cctx.onDeferredDelete(this, ver0);
        }
        return null;
    }

    private void swap() throws IgniteCheckedException {
        boolean swapNeeded;
        boolean bl = swapNeeded = (this.flags & 8) != 0;
        if (this.cctx.isSwapOrOffheapEnabled() && !this.deletedUnlocked() && (this.hasValueUnlocked() || swapNeeded) && !this.detached()) {
            assert (Thread.holdsLock(this));
            boolean offheapPtr = this.hasOffHeapPointer();
            if (this.cctx.offheapTiered() && offheapPtr && !swapNeeded) {
                if (this.cctx.swap().offheapEvictionEnabled()) {
                    if (log.isTraceEnabled()) {
                        log.trace("enableOffheapEviction [key=" + this.key + ", entry=" + System.identityHashCode(this) + ", ptr=" + this.offHeapPointer() + ']');
                    }
                    this.cctx.swap().enableOffheapEviction(this.key(), this.partition());
                } else if (log.isTraceEnabled()) {
                    log.trace("Value did not change, skip write swap entry: " + this);
                }
                return;
            }
            IgniteUuid valClsLdrId = null;
            IgniteUuid keyClsLdrId = null;
            if (this.cctx.deploymentEnabled()) {
                if (this.val != null) {
                    valClsLdrId = this.cctx.deploy().getClassLoaderId(U.detectObjectClassLoader(this.val.value(this.cctx.cacheObjectContext(), false)));
                }
                keyClsLdrId = this.cctx.deploy().getClassLoaderId(U.detectObjectClassLoader(this.keyValue(false)));
            }
            IgniteBiTuple<byte[], Byte> valBytes = this.valueBytes0();
            if (log.isTraceEnabled()) {
                log.trace("writeToOffheap [key=" + this.key + ", entry=" + System.identityHashCode(this) + ", ptr=" + this.offHeapPointer() + ']');
            }
            this.cctx.swap().write(this.key(), ByteBuffer.wrap(valBytes.get1()), valBytes.get2(), this.ver, this.ttlExtras(), this.expireTimeExtras(), keyClsLdrId, valClsLdrId, !offheapPtr);
            this.flags = (byte)(this.flags & 0xFFFFFFF7);
        }
    }

    protected IgniteBiTuple<byte[], Byte> valueBytes0() {
        assert (Thread.holdsLock(this));
        if (this.hasOffHeapPointer()) {
            assert (this.isOffHeapValuesOnly() || this.cctx.offheapTiered());
            return this.cctx.unsafeMemory().get(this.offHeapPointer());
        }
        assert (this.val != null);
        try {
            byte[] bytes = this.val.valueBytes(this.cctx.cacheObjectContext());
            return new IgniteBiTuple<byte[], Byte>(bytes, this.val.cacheObjectType());
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    protected final void releaseSwap() throws IgniteCheckedException {
        if (this.cctx.isSwapOrOffheapEnabled()) {
            assert (Thread.holdsLock(this));
            if (log.isTraceEnabled()) {
                log.trace("removeFromSwap [key=" + this.key + ", entry=" + System.identityHashCode(this) + ", ptr=" + this.offHeapPointer() + ']');
            }
            this.cctx.swap().remove(this.key(), this.partition());
        }
    }

    @Nullable
    protected Object readThrough(@Nullable IgniteInternalTx tx, KeyCacheObject key, boolean reload, UUID subjId, String taskName) throws IgniteCheckedException {
        return this.cctx.store().load(tx, key);
    }

    @Override
    @Nullable
    public final CacheObject innerGet(@Nullable GridCacheVersion ver, @Nullable IgniteInternalTx tx, boolean readSwap, boolean readThrough, boolean updateMetrics, boolean evt, boolean tmp, UUID subjId, Object transformClo, String taskName, @Nullable IgniteCacheExpiryPolicy expirePlc, boolean keepBinary) throws IgniteCheckedException, GridCacheEntryRemovedException {
        return (CacheObject)this.innerGet0(ver, tx, readSwap, readThrough, evt, updateMetrics, tmp, subjId, transformClo, taskName, expirePlc, false, keepBinary, false, null);
    }

    @Override
    public EntryGetResult innerGetAndReserveForLoad(boolean readSwap, boolean updateMetrics, boolean evt, UUID subjId, String taskName, @Nullable IgniteCacheExpiryPolicy expiryPlc, boolean keepBinary, @Nullable ReaderArguments readerArgs) throws IgniteCheckedException, GridCacheEntryRemovedException {
        return (EntryGetResult)this.innerGet0(null, null, readSwap, false, evt, updateMetrics, false, subjId, null, taskName, expiryPlc, true, keepBinary, true, readerArgs);
    }

    @Override
    public EntryGetResult innerGetVersioned(@Nullable GridCacheVersion ver, IgniteInternalTx tx, boolean readSwap, boolean unmarshal, boolean updateMetrics, boolean evt, UUID subjId, Object transformClo, String taskName, @Nullable IgniteCacheExpiryPolicy expiryPlc, boolean keepBinary, @Nullable ReaderArguments readerArgs) throws IgniteCheckedException, GridCacheEntryRemovedException {
        return (EntryGetResult)this.innerGet0(ver, tx, readSwap, false, evt, updateMetrics, false, subjId, transformClo, taskName, expiryPlc, true, keepBinary, false, readerArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object innerGet0(GridCacheVersion nextVer, IgniteInternalTx tx, boolean readSwap, boolean readThrough, boolean evt, boolean updateMetrics, boolean tmp, UUID subjId, Object transformClo, String taskName, @Nullable IgniteCacheExpiryPolicy expiryPlc, boolean retVer, boolean keepBinary, boolean reserveForLoad, @Nullable ReaderArguments readerArgs) throws IgniteCheckedException, GridCacheEntryRemovedException {
        GridCacheVersion startVer;
        GridCacheMvcc mvcc;
        assert (!retVer || !readThrough);
        assert (!reserveForLoad || !readThrough);
        if (readThrough && !this.cctx.readThrough()) {
            readThrough = false;
        }
        GridCacheVersion resVer = null;
        boolean obsolete = false;
        boolean deferred = false;
        GridCacheVersion ver0 = null;
        Object res = null;
        GridCacheMapEntry gridCacheMapEntry = this;
        synchronized (gridCacheMapEntry) {
            CacheObject ret;
            CacheObject val;
            this.checkObsolete();
            boolean valid = this.valid(tx != null ? tx.topologyVersion() : this.cctx.affinity().affinityTopologyVersion());
            if (valid) {
                long expireTime;
                val = this.rawGetOrUnmarshalUnlocked(tmp);
                if (val == null && readSwap && this.isStartVersion()) {
                    if (tmp) {
                        this.unswap(false, false);
                        val = this.rawGetOrUnmarshalUnlocked(true);
                    } else {
                        val = this.unswap(true, false);
                    }
                }
                if (val != null && (expireTime = this.expireTimeExtras()) > 0L && expireTime - U.currentTimeMillis() <= 0L && this.onExpired((CacheObject)this.cctx.unwrapTemporary(val), null)) {
                    val = null;
                    evt = false;
                    if (this.cctx.deferredDelete()) {
                        deferred = true;
                        ver0 = this.ver;
                    } else {
                        obsolete = true;
                    }
                }
            } else {
                val = null;
            }
            if ((ret = val) == null) {
                if (updateMetrics && this.cctx.cache().configuration().isStatisticsEnabled()) {
                    this.cctx.cache().metrics0().onRead(false);
                }
            } else if (updateMetrics && this.cctx.cache().configuration().isStatisticsEnabled()) {
                this.cctx.cache().metrics0().onRead(true);
            }
            if (evt && this.cctx.events().isRecordable(64)) {
                transformClo = EntryProcessorResourceInjectorProxy.unwrap(transformClo);
                mvcc = this.mvccExtras();
                this.cctx.events().addEvent(this.partition(), this.key, tx, mvcc != null ? mvcc.anyOwner() : null, 64, ret, ret != null, ret, ret != null, subjId, transformClo != null ? transformClo.getClass().getName() : null, taskName, keepBinary);
                evt = false;
            }
            if (ret != null && expiryPlc != null) {
                this.updateTtl(expiryPlc);
            }
            if (retVer) {
                GridCacheVersion gridCacheVersion = resVer = this.isNear() && this.cctx.transactional() ? ((GridNearCacheEntry)this).dhtVersion() : this.ver;
                if (resVer == null) {
                    ret = null;
                }
            }
            startVer = this.ver;
            this.addReaderIfNeed(readerArgs);
            if (ret != null) {
                assert (tmp || !(ret instanceof BinaryObjectOffheapImpl));
                assert (!obsolete);
                assert (!deferred);
                res = retVer ? this.entryGetResult(ret, resVer, false) : ret;
            } else if (reserveForLoad && !obsolete) {
                boolean reserve;
                assert (!readThrough);
                assert (retVer);
                boolean bl = reserve = !this.evictionDisabled();
                if (reserve) {
                    this.flags = (byte)(this.flags | 0x10);
                }
                res = this.entryGetResult(null, resVer, reserve);
            }
        }
        if (obsolete) {
            this.onMarkedObsolete();
            throw new GridCacheEntryRemovedException();
        }
        if (deferred) {
            this.cctx.onDeferredDelete(this, ver0);
        }
        if (res != null) {
            return res;
        }
        CacheObject ret = null;
        if (readThrough) {
            IgniteInternalTx tx0 = null;
            if (tx != null && tx.local()) {
                if (this.cctx.isReplicated() || this.cctx.isColocated() || tx.near()) {
                    tx0 = tx;
                } else if (tx.dht()) {
                    GridCacheVersion ver = tx.nearXidVersion();
                    tx0 = this.cctx.dht().near().context().tm().tx(ver);
                }
            }
            Object storeVal = this.readThrough(tx0, this.key, false, subjId, taskName);
            ret = this.cctx.toCacheObject(storeVal);
        }
        if (ret == null && !evt) {
            return null;
        }
        GridCacheMapEntry gridCacheMapEntry2 = this;
        synchronized (gridCacheMapEntry2) {
            long ttl = this.ttlExtras();
            if (startVer.equals(this.ver)) {
                if (ret != null) {
                    ret = this.cctx.kernalContext().cacheObjects().prepareForCache(ret, this.cctx);
                    nextVer = nextVer != null ? nextVer : this.nextVersion();
                    CacheObject prevVal = this.rawGetOrUnmarshalUnlocked(false);
                    long expTime = CU.toExpireTime(ttl);
                    this.updateIndex(ret, expTime, nextVer, prevVal);
                    boolean hadValPtr = this.hasOffHeapPointer();
                    this.update(ret, expTime, ttl, nextVer, true);
                    if (hadValPtr && this.cctx.offheapTiered()) {
                        if (log.isTraceEnabled()) {
                            log.trace("innerGet removeOffheap [key=" + this.key + ", entry=" + System.identityHashCode(this) + ", ptr=" + this.offHeapPointer() + ']');
                        }
                        this.cctx.swap().removeOffheap(this.key);
                    }
                    if (this.cctx.deferredDelete() && this.deletedUnlocked() && !this.isInternal() && !this.detached()) {
                        this.deletedUnlocked(false);
                    }
                    assert (readerArgs == null);
                }
                if (evt && this.cctx.events().isRecordable(64)) {
                    transformClo = EntryProcessorResourceInjectorProxy.unwrap(transformClo);
                    mvcc = this.mvccExtras();
                    this.cctx.events().addEvent(this.partition(), this.key, tx, mvcc != null ? mvcc.anyOwner() : null, 64, ret, ret != null, null, false, subjId, transformClo != null ? transformClo.getClass().getName() : null, taskName, keepBinary);
                }
            }
        }
        assert (ret == null || !retVer);
        assert (tmp || !(ret instanceof BinaryObjectOffheapImpl));
        return ret;
    }

    private EntryGetResult entryGetResult(CacheObject val, GridCacheVersion ver, boolean reserve) {
        return this.extras == null || this.extras.expireTime() == 0L ? new EntryGetResult(val, ver, reserve) : new EntryGetWithTtlResult(val, ver, reserve, this.rawExpireTime(), this.rawTtl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public final CacheObject innerReload() throws IgniteCheckedException, GridCacheEntryRemovedException {
        Object object;
        boolean touch;
        CacheObject ret;
        block17: {
            CU.checkStore(this.cctx);
            GridCacheMapEntry gridCacheMapEntry = this;
            // MONITORENTER : gridCacheMapEntry
            this.checkObsolete();
            GridCacheVersion startVer = this.ver;
            boolean wasNew = this.isNew();
            // MONITOREXIT : gridCacheMapEntry
            String taskName = this.cctx.kernalContext().job().currentTaskName();
            ret = this.cctx.toCacheObject(this.readThrough(null, this.key, true, this.cctx.localNodeId(), taskName));
            touch = false;
            object = this;
            // MONITORENTER : object
            long ttl = this.ttlExtras();
            GridCacheVersion nextVer = this.cctx.versions().nextForLoad(this.ver);
            if (wasNew && !this.isNew()) {
                CacheObject cacheObject = ret;
                // MONITOREXIT : object
                if (!touch) return cacheObject;
                this.cctx.evicts().touch(this, this.cctx.affinity().affinityTopologyVersion());
                return cacheObject;
            }
            if (!startVer.equals(this.ver)) break block17;
            CacheObject old = this.rawGetOrUnmarshalUnlocked(false);
            if (log.isTraceEnabled()) {
                log.trace("innerReload releaseSwap [key=" + this.key + ", entry=" + System.identityHashCode(this) + ", old=" + old + ", ptr=" + this.offHeapPointer() + ']');
            }
            this.releaseSwap();
            long expTime = CU.toExpireTime(ttl);
            ret = this.cctx.kernalContext().cacheObjects().prepareForCache(ret, this.cctx);
            if (ret != null) {
                this.updateIndex(ret, expTime, nextVer, old);
                if (this.cctx.deferredDelete() && !this.isInternal() && !this.detached() && this.deletedUnlocked()) {
                    this.deletedUnlocked(false);
                }
            } else {
                this.clearIndex(old);
                if (this.cctx.deferredDelete() && !this.isInternal() && !this.detached() && !this.deletedUnlocked()) {
                    this.deletedUnlocked(true);
                }
            }
            this.update(ret, expTime, ttl, nextVer, true);
            touch = true;
            CacheObject cacheObject = ret;
            // MONITOREXIT : object
            if (!touch) return cacheObject;
            this.cctx.evicts().touch(this, this.cctx.affinity().affinityTopologyVersion());
            return cacheObject;
        }
        try {
            // MONITOREXIT : object
            touch = true;
            object = ret;
            return object;
        }
        finally {
            if (touch) {
                this.cctx.evicts().touch(this, this.cctx.affinity().affinityTopologyVersion());
            }
        }
    }

    protected void recordNodeId(UUID nodeId, AffinityTopologyVersion topVer) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final GridCacheUpdateTxResult innerSet(@Nullable IgniteInternalTx tx, UUID evtNodeId, UUID affNodeId, CacheObject val, boolean writeThrough, boolean retval, long ttl, boolean evt, boolean metrics, boolean keepBinary, boolean oldValPresent, @Nullable CacheObject oldVal, AffinityTopologyVersion topVer, CacheEntryPredicate[] filter, GridDrType drType, long drExpireTime, @Nullable GridCacheVersion explicitVer, @Nullable UUID subjId, String taskName, @Nullable GridCacheVersion dhtVer, @Nullable Long updateCntr) throws IgniteCheckedException, GridCacheEntryRemovedException {
        long updateCntr0;
        CacheObject old;
        GridCacheVersion newVer;
        boolean valid = this.valid(tx != null ? tx.topologyVersion() : topVer);
        if (!this.cctx.isAll((GridCacheEntryEx)this, filter)) {
            return new GridCacheUpdateTxResult(false, null);
        }
        boolean intercept = this.cctx.config().getInterceptor() != null;
        Object key0 = null;
        Object val0 = null;
        GridCacheMapEntry gridCacheMapEntry = this;
        synchronized (gridCacheMapEntry) {
            long expireTime;
            Map<UUID, CacheContinuousQueryListener> lsnrCol;
            this.checkObsolete();
            if (this.isNear()) {
                assert (dhtVer != null);
                if (!((GridNearCacheEntry)this).recordDhtVersion(dhtVer)) {
                    return new GridCacheUpdateTxResult(false, null);
                }
            }
            assert (tx == null || !tx.local() && tx.onePhaseCommit() || tx.ownsLock(this)) : "Transaction does not own lock for update [entry=" + this + ", tx=" + tx + ']';
            boolean startVer = this.isStartVersion();
            if (startVer) {
                this.unswap(retval, false);
            }
            GridCacheVersion gridCacheVersion = explicitVer != null ? explicitVer : (newVer = tx == null ? this.nextVersion() : tx.writeVersion());
            assert (newVer != null) : "Failed to get write version for tx: " + tx;
            boolean internal = this.isInternal() || !this.context().userCache();
            Map<UUID, CacheContinuousQueryListener> map = lsnrCol = this.notifyContinuousQueries(tx) ? this.cctx.continuousQueries().updateListeners(internal, false) : null;
            CacheObject cacheObject = oldValPresent ? oldVal : (retval || intercept || lsnrCol != null ? this.rawGetOrUnmarshalUnlocked(!retval && !this.isOffHeapValuesOnly()) : (old = this.val));
            if (intercept) {
                val0 = this.cctx.unwrapBinaryIfNeeded(val, keepBinary, false);
                CacheLazyEntry e = new CacheLazyEntry((GridCacheContext)this.cctx, this.key, old, keepBinary);
                Object interceptorVal = this.cctx.config().getInterceptor().onBeforePut(new CacheLazyEntry((GridCacheContext)this.cctx, this.key, old, keepBinary), val0);
                key0 = e.key();
                if (interceptorVal == null) {
                    return new GridCacheUpdateTxResult(false, (CacheObject)this.cctx.unwrapTemporary(old));
                }
                if (interceptorVal != val0) {
                    val0 = this.cctx.unwrapTemporary(interceptorVal);
                }
                val = this.cctx.toCacheObject(val0);
            }
            if (drExpireTime >= 0L) {
                assert (ttl >= 0L) : ttl;
                expireTime = drExpireTime;
            } else if (ttl == -1L) {
                ttl = this.ttlExtras();
                expireTime = this.expireTimeExtras();
            } else {
                expireTime = CU.toExpireTime(ttl);
            }
            assert (ttl >= 0L) : ttl;
            assert (expireTime >= 0L) : expireTime;
            val = this.cctx.kernalContext().cacheObjects().prepareForCache(val, this.cctx);
            if (val != null) {
                this.updateIndex(val, expireTime, newVer, old);
                if (this.cctx.deferredDelete() && this.deletedUnlocked() && !this.isInternal() && !this.detached()) {
                    this.deletedUnlocked(false);
                }
            }
            updateCntr0 = this.nextPartCounter(topVer);
            if (updateCntr != null && updateCntr != 0L) {
                updateCntr0 = updateCntr;
            }
            this.update(val, expireTime, ttl, newVer, true);
            this.drReplicate(drType, val, newVer, topVer);
            this.recordNodeId(affNodeId, topVer);
            if (metrics && this.cctx.cache().configuration().isStatisticsEnabled()) {
                this.cctx.cache().metrics0().onWrite();
            }
            if (evt && newVer != null && this.cctx.events().isRecordable(63)) {
                CacheObject evtOld = (CacheObject)this.cctx.unwrapTemporary(old);
                this.cctx.events().addEvent(this.partition(), this.key, evtNodeId, tx == null ? null : tx.xid(), newVer, 63, val, val != null, evtOld, evtOld != null || this.hasValueUnlocked(), subjId, null, taskName, keepBinary);
            }
            if (lsnrCol != null) {
                this.cctx.continuousQueries().onEntryUpdated(lsnrCol, this.key, val, old, internal, this.partition(), tx.local(), false, updateCntr0, null, topVer);
            }
            this.cctx.dataStructures().onEntryUpdated(this.key, false, keepBinary);
        }
        if (log.isDebugEnabled()) {
            log.debug("Updated cache entry [val=" + val + ", old=" + old + ", entry=" + this + ']');
        }
        if (writeThrough) {
            this.cctx.store().put(tx, this.key, val, newVer);
        }
        if (intercept) {
            this.cctx.config().getInterceptor().onAfterPut(new CacheLazyEntry<Object, Object>(this.cctx, this.key, key0, val, val0, keepBinary, updateCntr0));
        }
        return valid ? new GridCacheUpdateTxResult(true, retval ? old : null, updateCntr0) : new GridCacheUpdateTxResult(false, null);
    }

    protected Object keyValue(boolean cpy) {
        return this.key.value(this.cctx.cacheObjectContext(), cpy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final GridCacheUpdateTxResult innerRemove(@Nullable IgniteInternalTx tx, UUID evtNodeId, UUID affNodeId, boolean retval, boolean evt, boolean metrics, boolean keepBinary, boolean oldValPresent, @Nullable CacheObject oldVal, AffinityTopologyVersion topVer, CacheEntryPredicate[] filter, GridDrType drType, @Nullable GridCacheVersion explicitVer, @Nullable UUID subjId, String taskName, @Nullable GridCacheVersion dhtVer, @Nullable Long updateCntr) throws IgniteCheckedException, GridCacheEntryRemovedException {
        boolean deferred;
        Long updateCntr0;
        CacheObject old;
        GridCacheVersion newVer;
        assert (this.cctx.transactional());
        boolean valid = this.valid(tx != null ? tx.topologyVersion() : topVer);
        if (!this.cctx.isAll((GridCacheEntryEx)this, filter)) {
            return new GridCacheUpdateTxResult(false, null);
        }
        GridCacheVersion obsoleteVer = null;
        boolean intercept = this.cctx.config().getInterceptor() != null;
        IgniteBiTuple<Boolean, CacheObject> interceptRes = null;
        CacheLazyEntry entry0 = null;
        boolean marked = false;
        GridCacheMapEntry gridCacheMapEntry = this;
        synchronized (gridCacheMapEntry) {
            Map<UUID, CacheContinuousQueryListener> lsnrCol;
            this.checkObsolete();
            if (this.isNear()) {
                assert (dhtVer != null);
                if (!((GridNearCacheEntry)this).recordDhtVersion(dhtVer)) {
                    return new GridCacheUpdateTxResult(false, null);
                }
            }
            assert (tx == null || !tx.local() && tx.onePhaseCommit() || tx.ownsLock(this)) : "Transaction does not own lock for remove[entry=" + this + ", tx=" + tx + ']';
            boolean startVer = this.isStartVersion();
            if (startVer) {
                if (log.isTraceEnabled()) {
                    log.trace("innerRemove releaseSwap [key=" + this.key + ", entry=" + System.identityHashCode(this) + ", ptr=" + this.offHeapPointer() + ']');
                }
                this.releaseSwap();
            }
            newVer = explicitVer != null ? explicitVer : (tx == null ? this.nextVersion() : tx.writeVersion());
            boolean internal = this.isInternal() || !this.context().userCache();
            Map<UUID, CacheContinuousQueryListener> map = lsnrCol = this.notifyContinuousQueries(tx) ? this.cctx.continuousQueries().updateListeners(internal, false) : null;
            CacheObject cacheObject = oldValPresent ? oldVal : (retval || intercept || lsnrCol != null ? this.rawGetOrUnmarshalUnlocked(!retval && !this.isOffHeapValuesOnly()) : (old = this.val));
            if (intercept) {
                entry0 = new CacheLazyEntry((GridCacheContext)this.cctx, this.key, old, keepBinary);
                interceptRes = this.cctx.config().getInterceptor().onBeforeRemove(entry0);
                if (this.cctx.cancelRemove(interceptRes)) {
                    CacheObject ret = this.cctx.toCacheObject(this.cctx.unwrapTemporary(interceptRes.get2()));
                    return new GridCacheUpdateTxResult(false, ret);
                }
            }
            if (old == null) {
                old = this.saveValueForIndexUnlocked();
            }
            this.clearIndex(old);
            boolean hadValPtr = this.hasOffHeapPointer();
            this.update(null, 0L, 0L, newVer, true);
            if (this.cctx.deferredDelete() && !this.detached() && !this.isInternal() && !this.deletedUnlocked()) {
                this.deletedUnlocked(true);
                if (tx != null) {
                    GridCacheMvcc mvcc = this.mvccExtras();
                    if (mvcc == null || mvcc.isEmpty(tx.xidVersion())) {
                        this.clearReaders();
                    } else {
                        this.clearReader(tx.originatingNodeId());
                    }
                }
            }
            updateCntr0 = this.nextPartCounter(topVer);
            if (updateCntr != null && updateCntr != 0L) {
                updateCntr0 = updateCntr;
            }
            this.drReplicate(drType, null, newVer, topVer);
            if (metrics && this.cctx.cache().configuration().isStatisticsEnabled()) {
                this.cctx.cache().metrics0().onRemove();
            }
            if (tx == null) {
                obsoleteVer = newVer;
            } else if (this.lockedBy(tx.xidVersion())) {
                obsoleteVer = tx.xidVersion();
            } else if (log.isDebugEnabled()) {
                log.debug("Obsolete version was not set because lock was explicit: " + this);
            }
            if (evt && newVer != null && this.cctx.events().isRecordable(65)) {
                CacheObject evtOld = (CacheObject)this.cctx.unwrapTemporary(old);
                this.cctx.events().addEvent(this.partition(), this.key, evtNodeId, tx == null ? null : tx.xid(), newVer, 65, null, false, evtOld, evtOld != null || this.hasValueUnlocked(), subjId, null, taskName, keepBinary);
            }
            if (lsnrCol != null) {
                this.cctx.continuousQueries().onEntryUpdated(lsnrCol, this.key, null, old, internal, this.partition(), tx.local(), false, updateCntr0, null, topVer);
            }
            this.cctx.dataStructures().onEntryUpdated(this.key, true, keepBinary);
            boolean bl = deferred = this.cctx.deferredDelete() && !this.detached() && !this.isInternal();
            if (intercept) {
                entry0.updateCounter(updateCntr0);
                this.cctx.config().getInterceptor().onAfterRemove(entry0);
            }
            if (this.cctx.offheapTiered() && hadValPtr) {
                boolean rmv = this.cctx.swap().removeOffheap(this.key);
                if (log.isTraceEnabled()) {
                    log.trace("innerRemove remove offheap [key=" + this.key + ", entry=" + System.identityHashCode(this) + ", rmv=" + rmv + ", ptr=" + this.offHeapPointer() + ']');
                }
                assert (rmv);
            }
            if (!deferred) {
                assert (newVer == this.ver);
                if (obsoleteVer == null || !(marked = this.markObsolete0(obsoleteVer, true, null))) {
                    if (log.isDebugEnabled()) {
                        log.debug("Entry could not be marked obsolete (it is still used): " + this);
                    }
                } else {
                    this.recordNodeId(affNodeId, topVer);
                    if (log.isDebugEnabled()) {
                        log.debug("Entry was marked obsolete: " + this);
                    }
                }
            }
        }
        if (deferred) {
            this.cctx.onDeferredDelete(this, newVer);
        }
        if (marked) {
            assert (!deferred);
            this.onMarkedObsolete();
        }
        if (valid) {
            CacheObject ret = interceptRes != null ? this.cctx.toCacheObject(this.cctx.unwrapTemporary(interceptRes.get2())) : old;
            return new GridCacheUpdateTxResult(true, ret, updateCntr0);
        }
        return new GridCacheUpdateTxResult(false, null);
    }

    private boolean notifyContinuousQueries(@Nullable IgniteInternalTx tx) {
        return this.cctx.isLocal() || this.cctx.isReplicated() || !this.isNear() && (tx == null || !tx.onePhaseCommit() || tx.local());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridTuple3<Boolean, Object, EntryProcessorResult<Object>> innerUpdateLocal(GridCacheVersion ver, GridCacheOperation op, @Nullable Object writeObj, @Nullable Object[] invokeArgs, boolean writeThrough, boolean readThrough, boolean retval, boolean keepBinary, @Nullable ExpiryPolicy expiryPlc, boolean evt, boolean metrics, @Nullable CacheEntryPredicate[] filter, boolean intercept, @Nullable UUID subjId, String taskName) throws IgniteCheckedException, GridCacheEntryRemovedException {
        CacheObject old;
        assert (this.cctx.isLocal() && this.cctx.atomic());
        boolean res = true;
        IgniteBiTuple<Boolean, Object> interceptorRes = null;
        CacheInvokeResult invokeRes = null;
        GridCacheMapEntry gridCacheMapEntry = this;
        synchronized (gridCacheMapEntry) {
            CacheObject evtOld;
            CacheObject updated;
            boolean pass;
            boolean internal = this.isInternal() || !this.context().userCache();
            Map<UUID, CacheContinuousQueryListener> lsnrCol = this.cctx.continuousQueries().updateListeners(internal, false);
            boolean needVal = retval || intercept || op == GridCacheOperation.TRANSFORM || !F.isEmpty(filter) || lsnrCol != null;
            this.checkObsolete();
            if (this.isNew()) {
                this.unswap(retval, false);
            }
            old = needVal ? this.rawGetOrUnmarshalUnlocked(!retval && !this.isOffHeapValuesOnly()) : this.val;
            boolean readFromStore = false;
            Object old0 = null;
            if (readThrough && needVal && old == null && this.cctx.readThrough() && (op == GridCacheOperation.TRANSFORM || this.cctx.loadPreviousValue())) {
                old0 = this.readThrough(null, this.key, false, subjId, taskName);
                old = this.cctx.toCacheObject(old0);
                long ttl = 0L;
                long expireTime = 0L;
                if (expiryPlc != null && old != null) {
                    ttl = CU.toTtl(expiryPlc.getExpiryForCreation());
                    if (ttl == -2L) {
                        ttl = 1L;
                        expireTime = CU.expireTimeInPast();
                    } else if (ttl == -1L) {
                        ttl = 0L;
                    } else {
                        expireTime = CU.toExpireTime(ttl);
                    }
                }
                if ((old = this.cctx.kernalContext().cacheObjects().prepareForCache(old, this.cctx)) != null) {
                    this.updateIndex(old, expireTime, ver, null);
                } else {
                    this.clearIndex(null);
                }
                this.update(old, expireTime, ttl, ver, true);
            }
            if (metrics && this.cctx.cache().configuration().isStatisticsEnabled() && needVal && (op != GridCacheOperation.UPDATE || F.isEmpty(filter) || !this.cctx.putIfAbsentFilter(filter))) {
                this.cctx.cache().metrics0().onRead(old != null);
            }
            if (!F.isEmpty(filter) && !(pass = this.cctx.isAllLocked(this, filter))) {
                if (expiryPlc != null && !readFromStore && !this.cctx.putIfAbsentFilter(filter) && this.hasValueUnlocked()) {
                    this.updateTtl(expiryPlc);
                }
                Object val = retval ? this.cctx.cacheObjectContext().unwrapBinaryIfNeeded(CU.value(old, this.cctx, false), keepBinary, false) : null;
                return new T3<Boolean, Object, Object>(false, val, null);
            }
            String transformCloClsName = null;
            Object key0 = null;
            Object updated0 = null;
            if (op == GridCacheOperation.TRANSFORM) {
                transformCloClsName = EntryProcessorResourceInjectorProxy.unwrap(writeObj).getClass().getName();
                EntryProcessor entryProcessor = (EntryProcessor)writeObj;
                assert (entryProcessor != null);
                CacheInvokeEntry entry = new CacheInvokeEntry(this.key, old, this.version(), keepBinary, this);
                try {
                    Object computed = entryProcessor.process(entry, invokeArgs);
                    if (entry.modified()) {
                        updated0 = this.cctx.unwrapTemporary(entry.getValue());
                        updated = this.cctx.toCacheObject(updated0);
                    } else {
                        updated = old;
                    }
                    key0 = entry.key();
                    invokeRes = computed != null ? CacheInvokeResult.fromResult(this.cctx.unwrapTemporary(computed)) : null;
                }
                catch (Exception e) {
                    updated = old;
                    invokeRes = CacheInvokeResult.fromError(e);
                }
                if (!entry.modified()) {
                    if (expiryPlc != null && !readFromStore && this.hasValueUnlocked()) {
                        this.updateTtl(expiryPlc);
                    }
                    return new GridTuple3(false, null, invokeRes);
                }
            } else {
                updated = (CacheObject)writeObj;
            }
            GridCacheOperation gridCacheOperation = op = updated == null ? GridCacheOperation.DELETE : GridCacheOperation.UPDATE;
            if (intercept) {
                CacheLazyEntry<Object, Object> e;
                if (op == GridCacheOperation.UPDATE) {
                    updated0 = this.value(updated0, updated, keepBinary, false);
                    e = new CacheLazyEntry<Object, Object>(this.cctx, this.key, key0, old, old0, keepBinary);
                    Object interceptorVal = this.cctx.config().getInterceptor().onBeforePut(e, updated0);
                    if (interceptorVal == null) {
                        return new GridTuple3<Boolean, Object, EntryProcessorResult<Object>>(false, this.cctx.unwrapTemporary(this.value(old0, old, keepBinary, false)), invokeRes);
                    }
                    updated0 = this.cctx.unwrapTemporary(interceptorVal);
                    updated = this.cctx.toCacheObject(updated0);
                } else {
                    e = new CacheLazyEntry<Object, Object>(this.cctx, this.key, key0, old, old0, keepBinary);
                    interceptorRes = this.cctx.config().getInterceptor().onBeforeRemove(e);
                    if (this.cctx.cancelRemove(interceptorRes)) {
                        return new GridTuple3<Boolean, Object, EntryProcessorResult<Object>>(false, this.cctx.unwrapTemporary(interceptorRes.get2()), invokeRes);
                    }
                }
                key0 = e.key();
                old0 = e.value();
            }
            boolean hadVal = this.hasValueUnlocked();
            long ttl = 0L;
            long expireTime = 0L;
            if (op == GridCacheOperation.UPDATE) {
                if (expiryPlc != null) {
                    ttl = CU.toTtl(hadVal ? expiryPlc.getExpiryForUpdate() : expiryPlc.getExpiryForCreation());
                    if (ttl == -1L) {
                        ttl = this.ttlExtras();
                        expireTime = this.expireTimeExtras();
                    } else if (ttl != -2L) {
                        expireTime = CU.toExpireTime(ttl);
                    }
                } else {
                    ttl = this.ttlExtras();
                    expireTime = this.expireTimeExtras();
                }
            }
            if (ttl == -2L) {
                op = GridCacheOperation.DELETE;
            }
            boolean hasValPtr = false;
            if (op == GridCacheOperation.UPDATE) {
                updated = this.cctx.kernalContext().cacheObjects().prepareForCache(updated, this.cctx);
                if (writeThrough) {
                    this.cctx.store().put(null, this.key, updated, ver);
                }
                this.updateIndex(updated, expireTime, ver, old);
                assert (ttl != -2L);
                this.update(updated, expireTime, ttl, ver, true);
                if (evt) {
                    evtOld = null;
                    if (transformCloClsName != null && this.cctx.events().isRecordable(64)) {
                        evtOld = (CacheObject)this.cctx.unwrapTemporary(old);
                        this.cctx.events().addEvent(this.partition(), this.key, this.cctx.localNodeId(), null, (Object)null, 64, evtOld, evtOld != null || hadVal, evtOld, evtOld != null || hadVal, subjId, transformCloClsName, taskName, keepBinary);
                    }
                    if (this.cctx.events().isRecordable(63)) {
                        if (evtOld == null) {
                            evtOld = (CacheObject)this.cctx.unwrapTemporary(old);
                        }
                        this.cctx.events().addEvent(this.partition(), this.key, this.cctx.localNodeId(), null, (Object)null, 63, updated, updated != null, evtOld, evtOld != null || hadVal, subjId, null, taskName, keepBinary);
                    }
                }
            } else {
                if (writeThrough) {
                    this.cctx.store().remove(null, this.key);
                }
                hasValPtr = this.hasOffHeapPointer();
                if (old == null) {
                    old = this.saveValueForIndexUnlocked();
                }
                this.clearIndex(old);
                this.update(null, 0L, 0L, ver, true);
                if (evt) {
                    evtOld = null;
                    if (transformCloClsName != null && this.cctx.events().isRecordable(64)) {
                        this.cctx.events().addEvent(this.partition(), this.key, this.cctx.localNodeId(), null, (Object)null, 64, evtOld, evtOld != null || hadVal, evtOld, evtOld != null || hadVal, subjId, transformCloClsName, taskName, keepBinary);
                    }
                    if (this.cctx.events().isRecordable(65)) {
                        if (evtOld == null) {
                            evtOld = (CacheObject)this.cctx.unwrapTemporary(old);
                        }
                        this.cctx.events().addEvent(this.partition(), this.key, this.cctx.localNodeId(), null, (Object)null, 65, null, false, evtOld, evtOld != null || hadVal, subjId, null, taskName, keepBinary);
                    }
                }
                res = hadVal;
            }
            if (res) {
                this.updateMetrics(op, metrics);
            }
            if (lsnrCol != null) {
                long updateCntr = this.nextPartCounter(AffinityTopologyVersion.NONE);
                this.cctx.continuousQueries().onEntryUpdated(lsnrCol, this.key, this.val, old, internal, this.partition(), true, false, updateCntr, null, AffinityTopologyVersion.NONE);
            }
            this.cctx.dataStructures().onEntryUpdated(this.key, op == GridCacheOperation.DELETE, keepBinary);
            if (intercept) {
                if (op == GridCacheOperation.UPDATE) {
                    this.cctx.config().getInterceptor().onAfterPut(new CacheLazyEntry<Object, Object>(this.cctx, this.key, key0, updated, updated0, keepBinary, 0L));
                } else {
                    this.cctx.config().getInterceptor().onAfterRemove(new CacheLazyEntry<Object, Object>(this.cctx, this.key, key0, old, old0, keepBinary, 0L));
                }
            }
            if (op != GridCacheOperation.UPDATE && this.cctx.offheapTiered() && hasValPtr) {
                boolean rmv = this.cctx.swap().removeOffheap(this.key);
                if (log.isTraceEnabled()) {
                    log.trace("innerUpdateLocal remove offheap [key=" + this.key + ", entry=" + System.identityHashCode(this) + ", rmv=" + rmv + ", ptr=" + this.offHeapPointer() + ']');
                }
                assert (rmv);
            }
        }
        return new GridTuple3<Boolean, Object, EntryProcessorResult<Object>>(res, this.cctx.unwrapTemporary(interceptorRes != null ? interceptorRes.get2() : this.cctx.cacheObjectContext().unwrapBinaryIfNeeded(old, keepBinary, false)), invokeRes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridCacheUpdateAtomicResult innerUpdate(GridCacheVersion newVer, UUID evtNodeId, UUID affNodeId, GridCacheOperation op, @Nullable Object writeObj, @Nullable Object[] invokeArgs, boolean writeThrough, boolean readThrough, boolean retval, boolean keepBinary, @Nullable IgniteCacheExpiryPolicy expiryPlc, boolean evt, boolean metrics, boolean primary, boolean verCheck, AffinityTopologyVersion topVer, @Nullable CacheEntryPredicate[] filter, GridDrType drType, long explicitTtl, long explicitExpireTime, @Nullable GridCacheVersion conflictVer, boolean conflictResolve, boolean intercept, @Nullable UUID subjId, String taskName, @Nullable CacheObject prevVal, @Nullable Long updateCntr, @Nullable GridDhtAtomicAbstractUpdateFuture fut) throws IgniteCheckedException, GridCacheEntryRemovedException, GridClosureException {
        long newSysExpireTime;
        long newSysTtl;
        CacheObject updated;
        CacheObject oldVal;
        assert (this.cctx.atomic());
        boolean res = true;
        GridCacheVersion enqueueVer = null;
        GridCacheVersionConflictContext<?, ?> conflictCtx = null;
        IgniteBiTuple<Object, Exception> invokeRes = null;
        Object key0 = null;
        Object updated0 = null;
        Long updateCntr0 = null;
        GridCacheMapEntry gridCacheMapEntry = this;
        synchronized (gridCacheMapEntry) {
            long newExpireTime;
            long newTtl;
            boolean pass;
            boolean ignoreTime;
            boolean internal = this.isInternal() || !this.context().userCache();
            Map<UUID, CacheContinuousQueryListener> lsnrs = this.cctx.continuousQueries().updateListeners(internal, false);
            boolean needVal = lsnrs != null || intercept || retval || op == GridCacheOperation.TRANSFORM || !F.isEmptyOrNulls(filter);
            this.checkObsolete();
            if (this.isStartVersion()) {
                this.unswap(retval, false);
            }
            oldVal = needVal ? this.rawGetOrUnmarshalUnlocked(!retval && !this.isOffHeapValuesOnly()) : this.val;
            boolean readFromStore = false;
            Object old0 = null;
            if (readThrough && needVal && oldVal == null && this.cctx.readThrough() && (op == GridCacheOperation.TRANSFORM || this.cctx.loadPreviousValue())) {
                long initExpireTime;
                long initTtl;
                old0 = this.readThrough(null, this.key, false, subjId, taskName);
                oldVal = this.cctx.toCacheObject(old0);
                readFromStore = true;
                oldVal = this.cctx.kernalContext().cacheObjects().prepareForCache(oldVal, this.cctx);
                if (expiryPlc != null && oldVal != null) {
                    IgniteBiTuple<Long, Long> initTtlAndExpireTime = GridCacheMapEntry.initialTtlAndExpireTime(expiryPlc);
                    initTtl = initTtlAndExpireTime.get1();
                    initExpireTime = initTtlAndExpireTime.get2();
                } else {
                    initTtl = 0L;
                    initExpireTime = 0L;
                }
                if (oldVal != null) {
                    this.updateIndex(oldVal, initExpireTime, this.ver, null);
                } else {
                    this.clearIndex(null);
                }
                this.update(oldVal, initExpireTime, initTtl, this.ver, true);
                if (this.deletedUnlocked() && oldVal != null && !this.isInternal()) {
                    this.deletedUnlocked(false);
                }
            }
            Object transformClo = null;
            if (conflictResolve) {
                GridCacheVersion oldConflictVer = this.version().conflictVersion();
                if (this.cctx.conflictNeedResolve()) {
                    boolean ignoreTime2;
                    GridTuple3<Long, Long, Boolean> expiration = this.ttlAndExpireTime(expiryPlc, explicitTtl, explicitExpireTime);
                    GridCacheVersionedEntryEx oldEntry = this.versionedEntry(keepBinary);
                    if (op == GridCacheOperation.TRANSFORM) {
                        transformClo = writeObj;
                        EntryProcessor entryProcessor = (EntryProcessor)writeObj;
                        oldVal = this.rawGetOrUnmarshalUnlocked(true);
                        CacheInvokeEntry entry = new CacheInvokeEntry(this.key, oldVal, this.version(), keepBinary, this);
                        try {
                            Object computed = entryProcessor.process(entry, invokeArgs);
                            writeObj = entry.modified() ? this.cctx.toCacheObject(this.cctx.unwrapTemporary(entry.getValue())) : oldVal;
                            key0 = entry.key();
                            if (computed != null) {
                                invokeRes = new IgniteBiTuple(this.cctx.unwrapTemporary(computed), null);
                            }
                        }
                        catch (Exception e) {
                            invokeRes = new IgniteBiTuple<Object, Exception>(null, e);
                            writeObj = oldVal;
                        }
                    }
                    GridCacheLazyPlainVersionedEntry newEntry = new GridCacheLazyPlainVersionedEntry(this.cctx, this.key, (CacheObject)writeObj, expiration.get1(), expiration.get2(), conflictVer != null ? conflictVer : newVer, keepBinary);
                    conflictCtx = this.cctx.conflictResolve(oldEntry, newEntry, verCheck);
                    assert (conflictCtx != null);
                    boolean bl = ignoreTime2 = this.cctx.config().getAtomicWriteOrderMode() == CacheAtomicWriteOrderMode.PRIMARY;
                    if (conflictCtx.isUseOld()) {
                        GridCacheVersion newConflictVer;
                        GridCacheVersion gridCacheVersion = newConflictVer = conflictVer != null ? conflictVer : newVer;
                        if (!this.isNew() && verCheck && oldConflictVer.dataCenterId() == newConflictVer.dataCenterId() && ATOMIC_VER_COMPARATOR.compare(oldConflictVer, newConflictVer, ignoreTime2) == 0 && this.cctx.writeThrough() && primary) {
                            CacheObject val = this.rawGetOrUnmarshalUnlocked(false);
                            if (val == null) {
                                assert (this.deletedUnlocked());
                                this.cctx.store().remove(null, this.key);
                            } else {
                                this.cctx.store().put(null, this.key, val, this.ver);
                            }
                        }
                        return new GridCacheUpdateAtomicResult(false, retval ? this.rawGetOrUnmarshalUnlocked(false) : null, null, invokeRes, 0L, 0L, null, null, false, updateCntr0 == null ? 0L : updateCntr0);
                    }
                    if (conflictCtx.isMerge()) {
                        writeObj = this.cctx.toCacheObject(conflictCtx.mergeValue());
                        conflictVer = null;
                    } else assert (conflictCtx.isUseNew());
                    op = writeObj != null ? GridCacheOperation.UPDATE : GridCacheOperation.DELETE;
                } else {
                    conflictVer = null;
                }
            }
            boolean bl = ignoreTime = this.cctx.config().getAtomicWriteOrderMode() == CacheAtomicWriteOrderMode.PRIMARY;
            if (conflictCtx == null) {
                if (verCheck) {
                    if (!this.isNew() && ATOMIC_VER_COMPARATOR.compare(this.ver, newVer, ignoreTime) >= 0) {
                        if (ATOMIC_VER_COMPARATOR.compare(this.ver, newVer, ignoreTime) == 0 && this.cctx.writeThrough() && primary) {
                            CacheObject val;
                            if (log.isDebugEnabled()) {
                                log.debug("Received entry update with same version as current (will update store) [entry=" + this + ", newVer=" + newVer + ']');
                            }
                            if ((val = this.rawGetOrUnmarshalUnlocked(false)) == null) {
                                assert (this.deletedUnlocked());
                                this.cctx.store().remove(null, this.key);
                            } else {
                                this.cctx.store().put(null, this.key, val, this.ver);
                            }
                        } else if (log.isDebugEnabled()) {
                            log.debug("Received entry update with smaller version than current (will ignore) [entry=" + this + ", newVer=" + newVer + ']');
                        }
                        if (!this.cctx.isNear()) {
                            CacheObject evtVal;
                            if (op == GridCacheOperation.TRANSFORM) {
                                EntryProcessor entryProcessor = (EntryProcessor)writeObj;
                                CacheInvokeEntry entry = new CacheInvokeEntry(this.key, prevVal, this.version(), keepBinary, this);
                                try {
                                    entryProcessor.process(entry, invokeArgs);
                                    evtVal = entry.modified() ? this.cctx.toCacheObject(this.cctx.unwrapTemporary(entry.getValue())) : prevVal;
                                }
                                catch (Exception ignore) {
                                    evtVal = prevVal;
                                }
                            } else {
                                evtVal = (CacheObject)writeObj;
                            }
                            updateCntr0 = this.nextPartCounter(topVer);
                            if (updateCntr != null) {
                                updateCntr0 = updateCntr;
                            }
                            this.cctx.continuousQueries().onEntryUpdated(this.key, evtVal, prevVal, this.isInternal() || !this.context().userCache(), this.partition(), primary, false, updateCntr0, null, topVer);
                        }
                        return new GridCacheUpdateAtomicResult(false, retval ? this.rawGetOrUnmarshalUnlocked(false) : null, null, invokeRes, 0L, 0L, null, null, false, 0L);
                    }
                } else assert (this.isNew() || ATOMIC_VER_COMPARATOR.compare(this.ver, newVer, ignoreTime) <= 0) : "Invalid version for inner update [isNew=" + this.isNew() + ", entry=" + this + ", newVer=" + newVer + ']';
            }
            if (metrics && this.cctx.cache().configuration().isStatisticsEnabled() && needVal && (op != GridCacheOperation.UPDATE || F.isEmpty(filter) || !this.cctx.putIfAbsentFilter(filter))) {
                this.cctx.cache().metrics0().onRead(oldVal != null);
            }
            if (!F.isEmptyOrNulls(filter) && !(pass = this.cctx.isAllLocked(this, filter))) {
                if (expiryPlc != null && !readFromStore && this.hasValueUnlocked() && !this.cctx.putIfAbsentFilter(filter)) {
                    this.updateTtl(expiryPlc);
                }
                return new GridCacheUpdateAtomicResult(false, retval ? oldVal : null, null, invokeRes, 0L, 0L, null, null, false, updateCntr0 == null ? 0L : updateCntr0);
            }
            if (op == GridCacheOperation.TRANSFORM) {
                assert (conflictCtx == null) : "Cannot be TRANSFORM here if conflict resolution was performed earlier.";
                transformClo = writeObj;
                EntryProcessor entryProcessor = (EntryProcessor)writeObj;
                CacheInvokeEntry entry = new CacheInvokeEntry(this.key, oldVal, this.version(), keepBinary, this);
                try {
                    Object computed = entryProcessor.process(entry, invokeArgs);
                    if (entry.modified()) {
                        updated0 = this.cctx.unwrapTemporary(entry.getValue());
                        updated = this.cctx.toCacheObject(updated0);
                    } else {
                        updated = oldVal;
                    }
                    key0 = entry.key();
                    if (computed != null) {
                        invokeRes = new IgniteBiTuple(this.cctx.unwrapTemporary(computed), null);
                    }
                }
                catch (Exception e) {
                    invokeRes = new IgniteBiTuple<Object, Exception>(null, e);
                    updated = oldVal;
                }
                if (!entry.modified()) {
                    if (expiryPlc != null && !readFromStore && this.hasValueUnlocked()) {
                        this.updateTtl(expiryPlc);
                    }
                    return new GridCacheUpdateAtomicResult(false, retval ? oldVal : null, null, invokeRes, 0L, 0L, null, null, false, updateCntr0 == null ? 0L : updateCntr0);
                }
            } else {
                updated = (CacheObject)writeObj;
            }
            GridCacheOperation gridCacheOperation = op = updated == null ? GridCacheOperation.DELETE : GridCacheOperation.UPDATE;
            assert (op == GridCacheOperation.UPDATE || op == GridCacheOperation.DELETE && updated == null);
            boolean hadVal = this.hasValueUnlocked();
            if (conflictVer != null && conflictVer != newVer) {
                newVer = new GridCacheVersionEx(newVer.topologyVersion(), newVer.globalTime(), newVer.order(), newVer.nodeOrder(), newVer.dataCenterId(), conflictVer);
            }
            if (op == GridCacheOperation.UPDATE) {
                if (conflictCtx == null) {
                    if (explicitTtl != -1L) {
                        assert (conflictVer == null || explicitExpireTime != -1L);
                        newSysTtl = newTtl = explicitTtl;
                        newSysExpireTime = explicitExpireTime;
                        newExpireTime = explicitExpireTime != -1L ? explicitExpireTime : CU.toExpireTime(explicitTtl);
                    } else {
                        long l = expiryPlc == null ? -1L : (newSysTtl = hadVal ? expiryPlc.forUpdate() : expiryPlc.forCreate());
                        if (newSysTtl == -1L) {
                            newSysExpireTime = -1L;
                            newTtl = this.ttlExtras();
                            newExpireTime = this.expireTimeExtras();
                        } else if (newSysTtl == -2L) {
                            op = GridCacheOperation.DELETE;
                            newSysTtl = -1L;
                            newSysExpireTime = -1L;
                            newTtl = 0L;
                            newExpireTime = 0L;
                            updated = null;
                        } else {
                            newSysExpireTime = -1L;
                            newTtl = newSysTtl;
                            newExpireTime = CU.toExpireTime(newTtl);
                        }
                    }
                } else {
                    newSysTtl = newTtl = conflictCtx.ttl();
                    newSysExpireTime = newExpireTime = conflictCtx.expireTime();
                }
            } else {
                assert (op == GridCacheOperation.DELETE);
                newSysTtl = -1L;
                newSysExpireTime = -1L;
                newTtl = 0L;
                newExpireTime = 0L;
            }
            assert (newTtl != -1L && newTtl != -2L && newTtl >= 0L);
            assert (newExpireTime != -1L && newExpireTime >= 0L);
            IgniteBiTuple<Boolean, Object> interceptRes = null;
            boolean hasValPtr = false;
            if (op == GridCacheOperation.UPDATE) {
                if (log.isTraceEnabled()) {
                    log.trace("innerUpdate [key=" + this.key + ", entry=" + System.identityHashCode(this) + ", ptr=" + this.offHeapPointer() + ']');
                }
                if (intercept) {
                    updated0 = this.value(updated0, updated, keepBinary, false);
                    Object interceptorVal = this.cctx.config().getInterceptor().onBeforePut(new CacheLazyEntry<Object, Object>(this.cctx, this.key, key0, oldVal, old0, keepBinary), updated0);
                    if (interceptorVal == null) {
                        return new GridCacheUpdateAtomicResult(false, retval ? oldVal : null, null, invokeRes, 0L, 0L, null, null, false, updateCntr0 == null ? 0L : updateCntr0);
                    }
                    if (interceptorVal != updated0) {
                        updated0 = this.cctx.unwrapTemporary(interceptorVal);
                        updated = this.cctx.toCacheObject(updated0);
                    }
                }
                if (writeThrough) {
                    this.cctx.store().put(null, this.key, updated, newVer);
                }
                if (!hadVal) {
                    boolean new0 = this.isNew();
                    assert (this.deletedUnlocked() || new0 || this.isInternal()) : "Invalid entry [entry=" + this + ", locNodeId=" + this.cctx.localNodeId() + ']';
                    if (!new0 && !this.isInternal()) {
                        this.deletedUnlocked(false);
                    }
                } else assert (!this.deletedUnlocked()) : "Invalid entry [entry=" + this + ", locNodeId=" + this.cctx.localNodeId() + ']';
                updated = this.cctx.kernalContext().cacheObjects().prepareForCache(updated, this.cctx);
                this.updateIndex(updated, newExpireTime, newVer, oldVal);
                this.update(updated, newExpireTime, newTtl, newVer, true);
                updateCntr0 = this.nextPartCounter(topVer);
                if (updateCntr != null) {
                    updateCntr0 = updateCntr;
                }
                this.drReplicate(drType, updated, newVer, topVer);
                this.recordNodeId(affNodeId, topVer);
                if (evt) {
                    CacheObject evtOld = null;
                    if (transformClo != null && this.cctx.events().isRecordable(64)) {
                        evtOld = (CacheObject)this.cctx.unwrapTemporary(oldVal);
                        transformClo = EntryProcessorResourceInjectorProxy.unwrap(transformClo);
                        this.cctx.events().addEvent(this.partition(), this.key, evtNodeId, null, newVer, 64, evtOld, evtOld != null || hadVal, evtOld, evtOld != null || hadVal, subjId, transformClo.getClass().getName(), taskName, keepBinary);
                    }
                    if (newVer != null && this.cctx.events().isRecordable(63)) {
                        if (evtOld == null) {
                            evtOld = (CacheObject)this.cctx.unwrapTemporary(oldVal);
                        }
                        this.cctx.events().addEvent(this.partition(), this.key, evtNodeId, null, newVer, 63, updated, updated != null, evtOld, evtOld != null || hadVal, subjId, null, taskName, keepBinary);
                    }
                }
            } else {
                if (intercept && this.cctx.cancelRemove(interceptRes = this.cctx.config().getInterceptor().onBeforeRemove(new CacheLazyEntry<Object, Object>(this.cctx, this.key, key0, oldVal, old0, keepBinary, updateCntr0)))) {
                    return new GridCacheUpdateAtomicResult(false, this.cctx.toCacheObject(this.cctx.unwrapTemporary(interceptRes.get2())), null, invokeRes, 0L, 0L, null, null, false, updateCntr0 == null ? 0L : updateCntr0);
                }
                if (writeThrough) {
                    this.cctx.store().remove(null, this.key);
                }
                if (oldVal == null) {
                    oldVal = this.saveValueForIndexUnlocked();
                }
                this.clearIndex(oldVal);
                if (hadVal) {
                    assert (!this.deletedUnlocked());
                    if (!this.isInternal()) {
                        this.deletedUnlocked(true);
                    }
                } else {
                    boolean new0 = this.isNew();
                    assert (this.deletedUnlocked() || new0 || this.isInternal()) : "Invalid entry [entry=" + this + ", locNodeId=" + this.cctx.localNodeId() + ']';
                    if (new0 && !this.isInternal()) {
                        this.deletedUnlocked(true);
                    }
                }
                enqueueVer = newVer;
                hasValPtr = this.hasOffHeapPointer();
                this.update(null, 0L, 0L, newVer, true);
                assert (newSysTtl == -1L);
                assert (newSysExpireTime == -1L);
                this.clearReaders();
                this.recordNodeId(affNodeId, topVer);
                updateCntr0 = this.nextPartCounter(topVer);
                if (updateCntr != null) {
                    updateCntr0 = updateCntr;
                }
                this.drReplicate(drType, null, newVer, topVer);
                if (evt) {
                    CacheObject evtOld = null;
                    if (transformClo != null && this.cctx.events().isRecordable(64)) {
                        evtOld = (CacheObject)this.cctx.unwrapTemporary(oldVal);
                        transformClo = EntryProcessorResourceInjectorProxy.unwrap(transformClo);
                        this.cctx.events().addEvent(this.partition(), this.key, evtNodeId, null, newVer, 64, evtOld, evtOld != null || hadVal, evtOld, evtOld != null || hadVal, subjId, transformClo.getClass().getName(), taskName, keepBinary);
                    }
                    if (newVer != null && this.cctx.events().isRecordable(65)) {
                        if (evtOld == null) {
                            evtOld = (CacheObject)this.cctx.unwrapTemporary(oldVal);
                        }
                        this.cctx.events().addEvent(this.partition(), this.key, evtNodeId, null, newVer, 65, null, false, evtOld, evtOld != null || hadVal, subjId, null, taskName, keepBinary);
                    }
                }
                res = hadVal;
            }
            if (res) {
                this.updateMetrics(op, metrics);
            }
            if (lsnrs != null) {
                CacheObject evtVal = (CacheObject)this.cctx.unwrapTemporary(updated);
                CacheObject evtOldVal = (CacheObject)this.cctx.unwrapTemporary(oldVal);
                this.cctx.continuousQueries().onEntryUpdated(lsnrs, this.key, evtVal, evtOldVal, internal, this.partition(), primary, false, updateCntr0, fut, topVer);
            }
            this.cctx.dataStructures().onEntryUpdated(this.key, op == GridCacheOperation.DELETE, keepBinary);
            if (intercept) {
                if (op == GridCacheOperation.UPDATE) {
                    this.cctx.config().getInterceptor().onAfterPut(new CacheLazyEntry<Object, Object>(this.cctx, this.key, key0, updated, updated0, keepBinary, updateCntr0));
                } else {
                    this.cctx.config().getInterceptor().onAfterRemove(new CacheLazyEntry<Object, Object>(this.cctx, this.key, key0, oldVal, old0, keepBinary, updateCntr0));
                }
                if (interceptRes != null) {
                    oldVal = this.cctx.toCacheObject(this.cctx.unwrapTemporary(interceptRes.get2()));
                }
            }
            if (op != GridCacheOperation.UPDATE && this.cctx.offheapTiered() && hasValPtr) {
                boolean rmv = this.cctx.swap().removeOffheap(this.key);
                if (log.isTraceEnabled()) {
                    log.trace("innerUpdate remove offheap [key=" + this.key + ", entry=" + System.identityHashCode(this) + ", rmv=" + rmv + ", ptr=" + this.offHeapPointer() + ']');
                }
                assert (rmv);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Updated cache entry [val=" + this.val + ", old=" + oldVal + ", entry=" + this + ']');
        }
        return new GridCacheUpdateAtomicResult(res, oldVal, updated, invokeRes, newSysTtl, newSysExpireTime, enqueueVer, conflictCtx, true, updateCntr0 == null ? 0L : updateCntr0);
    }

    @Nullable
    private Object value(@Nullable Object val, @Nullable CacheObject cacheObj, boolean keepBinary, boolean cpy) {
        if (val != null) {
            return val;
        }
        return this.cctx.unwrapBinaryIfNeeded(cacheObj, keepBinary, cpy);
    }

    private static IgniteBiTuple<Long, Long> initialTtlAndExpireTime(IgniteCacheExpiryPolicy expiry) {
        long initExpireTime;
        assert (expiry != null);
        long initTtl = expiry.forCreate();
        if (initTtl == -2L) {
            initTtl = 1L;
            initExpireTime = CU.expireTimeInPast();
        } else if (initTtl == -1L) {
            initTtl = 0L;
            initExpireTime = 0L;
        } else {
            initExpireTime = CU.toExpireTime(initTtl);
        }
        return F.t(initTtl, initExpireTime);
    }

    private GridTuple3<Long, Long, Boolean> ttlAndExpireTime(IgniteCacheExpiryPolicy expiry, long ttl, long expireTime) throws GridCacheEntryRemovedException {
        boolean rmv = false;
        if (ttl == -1L && expiry != null) {
            long l = ttl = this.hasValueUnlocked() ? expiry.forUpdate() : expiry.forCreate();
        }
        if (ttl == -2L) {
            rmv = true;
            ttl = 0L;
        }
        if (ttl == -1L) {
            if (this.isNew()) {
                ttl = 0L;
            } else {
                ttl = this.ttlExtras();
                expireTime = this.expireTimeExtras();
            }
        }
        if (expireTime == -1L) {
            expireTime = CU.toExpireTime(ttl);
        }
        return F.t(ttl, expireTime, rmv);
    }

    private void drReplicate(GridDrType drType, @Nullable CacheObject val, GridCacheVersion ver, AffinityTopologyVersion topVer) throws IgniteCheckedException {
        if (this.cctx.isDrEnabled() && drType != GridDrType.DR_NONE && !this.isInternal()) {
            this.cctx.dr().replicate(this.key, val, this.rawTtl(), this.rawExpireTime(), ver.conflictVersion(), drType, topVer);
        }
    }

    protected boolean hasReaders() throws GridCacheEntryRemovedException {
        return false;
    }

    protected void clearReaders() {
    }

    protected void clearReader(UUID nodeId) throws GridCacheEntryRemovedException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean clear(GridCacheVersion ver, boolean readers) throws IgniteCheckedException {
        GridCacheMapEntry gridCacheMapEntry = this;
        synchronized (gridCacheMapEntry) {
            if (this.obsolete()) {
                return false;
            }
            CacheObject val = this.saveValueForIndexUnlocked();
            try {
                if (!this.hasReaders() || readers) {
                    if (!this.markObsolete0(ver, true, null)) {
                        if (log.isDebugEnabled()) {
                            log.debug("Entry could not be marked obsolete (it is still used): " + this);
                        }
                        return false;
                    }
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("Entry could not be marked obsolete (it still has readers): " + this);
                    }
                    return false;
                }
                this.clearReaders();
            }
            catch (GridCacheEntryRemovedException ignore) {
                assert (false);
                return false;
            }
            if (log.isTraceEnabled()) {
                log.trace("entry clear [key=" + this.key + ", entry=" + System.identityHashCode(this) + ", val=" + val + ", ptr=" + this.offHeapPointer() + ']');
            }
            this.clearIndex(val);
            this.releaseSwap();
        }
        this.onMarkedObsolete();
        this.cctx.cache().removeEntry(this);
        return true;
    }

    @Override
    public synchronized GridCacheVersion obsoleteVersion() {
        return this.obsoleteVersionExtras();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean markObsolete(GridCacheVersion ver) {
        boolean obsolete;
        GridCacheMapEntry gridCacheMapEntry = this;
        synchronized (gridCacheMapEntry) {
            obsolete = this.markObsolete0(ver, true, null);
        }
        if (obsolete) {
            this.onMarkedObsolete();
        }
        return obsolete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean markObsoleteIfEmpty(@Nullable GridCacheVersion obsoleteVer) throws IgniteCheckedException {
        boolean obsolete = false;
        boolean deferred = false;
        GridCacheVersion ver0 = null;
        try {
            GridCacheMapEntry gridCacheMapEntry = this;
            synchronized (gridCacheMapEntry) {
                block19: {
                    if (this.obsoleteVersionExtras() == null) break block19;
                    boolean bl = false;
                    return bl;
                }
                if (this.hasValueUnlocked()) {
                    long expireTime = this.expireTimeExtras();
                    if (expireTime > 0L && expireTime - U.currentTimeMillis() <= 0L && this.onExpired(this.rawGetOrUnmarshal(false), obsoleteVer)) {
                        if (this.cctx.deferredDelete()) {
                            deferred = true;
                            ver0 = this.ver;
                        } else {
                            obsolete = true;
                        }
                    }
                } else if (this.cctx.deferredDelete() && !this.isStartVersion() && !this.detached() && !this.isInternal()) {
                    if (!this.deletedUnlocked()) {
                        this.update(null, 0L, 0L, this.ver, true);
                        this.deletedUnlocked(true);
                        deferred = true;
                        ver0 = this.ver;
                    }
                } else {
                    if (obsoleteVer == null) {
                        obsoleteVer = this.nextVersion();
                    }
                    obsolete = this.markObsolete0(obsoleteVer, true, null);
                }
            }
        }
        finally {
            if (obsolete) {
                this.onMarkedObsolete();
            }
            if (deferred) {
                this.cctx.onDeferredDelete(this, ver0);
            }
        }
        return obsolete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean markObsoleteVersion(GridCacheVersion ver) {
        boolean marked;
        assert (this.cctx.deferredDelete());
        GridCacheMapEntry gridCacheMapEntry = this;
        synchronized (gridCacheMapEntry) {
            if (this.obsoleteVersionExtras() != null) {
                return true;
            }
            if (!this.ver.equals(ver)) {
                return false;
            }
            marked = this.markObsolete0(ver, true, null);
        }
        if (marked) {
            this.onMarkedObsolete();
        }
        return marked;
    }

    protected boolean evictionDisabled() {
        return (this.flags & 0x10) != 0;
    }

    protected final boolean markObsolete0(GridCacheVersion ver, boolean clear, GridCacheObsoleteEntryExtras extras) {
        assert (Thread.holdsLock(this));
        if (this.evictionDisabled()) {
            assert (!this.obsolete()) : this;
            return false;
        }
        GridCacheVersion obsoleteVer = this.obsoleteVersionExtras();
        if (ver != null) {
            if (obsoleteVer != null) {
                return true;
            }
            GridCacheMvcc mvcc = this.mvccExtras();
            if (mvcc == null || mvcc.isEmpty(ver)) {
                obsoleteVer = ver;
                this.obsoleteVersionExtras(obsoleteVer, extras);
                if (clear) {
                    this.value(null);
                }
                if (log.isTraceEnabled()) {
                    log.trace("markObsolete0 [key=" + this.key + ", entry=" + System.identityHashCode(this) + ", ptr=" + this.offHeapPointer() + ", clear=" + clear + ']');
                }
            }
            return obsoleteVer != null;
        }
        return obsoleteVer != null;
    }

    @Override
    public void onMarkedObsolete() {
    }

    @Override
    public final synchronized boolean obsolete() {
        return this.obsoleteVersionExtras() != null;
    }

    @Override
    public final synchronized boolean obsolete(GridCacheVersion exclude) {
        GridCacheVersion obsoleteVer = this.obsoleteVersionExtras();
        return obsoleteVer != null && !obsoleteVer.equals(exclude);
    }

    @Override
    public synchronized boolean invalidate(@Nullable GridCacheVersion curVer, GridCacheVersion newVer) throws IgniteCheckedException {
        assert (newVer != null);
        if (curVer == null || this.ver.equals(curVer)) {
            CacheObject val = this.saveValueForIndexUnlocked();
            this.value(null);
            this.ver = newVer;
            this.flags = (byte)(this.flags & 0xFFFFFFEF);
            if (log.isTraceEnabled()) {
                log.trace("invalidate releaseSwap [key=" + this.key + ", entry=" + System.identityHashCode(this) + ", val=" + val + ", ptr=" + this.offHeapPointer() + ']');
            }
            this.releaseSwap();
            this.clearIndex(val);
            this.onInvalidate();
        }
        return this.obsoleteVersionExtras() != null;
    }

    protected void onInvalidate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean invalidate(@Nullable CacheEntryPredicate[] filter) throws GridCacheEntryRemovedException, IgniteCheckedException {
        GridCacheVersion startVer;
        if (F.isEmptyOrNulls(filter)) {
            GridCacheMapEntry gridCacheMapEntry = this;
            synchronized (gridCacheMapEntry) {
                this.checkObsolete();
                this.invalidate(null, this.nextVersion());
                return true;
            }
        }
        GridCacheMapEntry gridCacheMapEntry = this;
        synchronized (gridCacheMapEntry) {
            this.checkObsolete();
            startVer = this.ver;
        }
        if (!this.cctx.isAll((GridCacheEntryEx)this, filter)) {
            return false;
        }
        gridCacheMapEntry = this;
        synchronized (gridCacheMapEntry) {
            this.checkObsolete();
            if (startVer.equals(this.ver)) {
                this.invalidate(null, this.nextVersion());
                return true;
            }
        }
        return this.invalidate(filter);
    }

    protected final void update(@Nullable CacheObject val, long expireTime, long ttl, GridCacheVersion ver, boolean addTracked) {
        assert (ver != null);
        assert (Thread.holdsLock(this));
        assert (ttl != -2L && ttl != -1L && ttl >= 0L) : ttl;
        long oldExpireTime = this.expireTimeExtras();
        if (addTracked && oldExpireTime != 0L && (expireTime != oldExpireTime || this.isStartVersion()) && this.cctx.config().isEagerTtl()) {
            this.cctx.ttl().removeTrackedEntry(this);
        }
        this.value(val);
        this.ttlAndExpireTimeExtras(ttl, expireTime);
        this.ver = ver;
        this.flags = (byte)(this.flags & 0xFFFFFFEF);
        if (addTracked && expireTime != 0L && (expireTime != oldExpireTime || this.isStartVersion()) && this.cctx.config().isEagerTtl()) {
            this.cctx.ttl().addTrackedEntry(this);
        }
    }

    private void updateTtl(ExpiryPolicy expiryPlc) {
        long ttl = CU.toTtl(expiryPlc.getExpiryForAccess());
        if (ttl != -1L) {
            this.updateTtl(ttl);
        }
    }

    private void updateTtl(IgniteCacheExpiryPolicy expiryPlc) throws GridCacheEntryRemovedException {
        long ttl = expiryPlc.forAccess();
        if (ttl != -1L) {
            this.updateTtl(ttl);
            expiryPlc.ttlUpdated(this.key(), this.version(), this.hasReaders() ? ((GridDhtCacheEntry)this).readers() : null);
        }
    }

    protected void updateTtl(long ttl) {
        long expireTime;
        assert (ttl >= 0L || ttl == -2L) : ttl;
        assert (Thread.holdsLock(this));
        if (ttl == -2L) {
            ttl = 1L;
            expireTime = CU.expireTimeInPast();
        } else {
            expireTime = CU.toExpireTime(ttl);
        }
        long oldExpireTime = this.expireTimeExtras();
        if (oldExpireTime != 0L && expireTime != oldExpireTime && this.cctx.config().isEagerTtl()) {
            this.cctx.ttl().removeTrackedEntry(this);
        }
        this.ttlAndExpireTimeExtras(ttl, expireTime);
        if (this.cctx.isSwapOrOffheapEnabled()) {
            this.flags = (byte)(this.flags | 8);
        }
        if (expireTime != 0L && expireTime != oldExpireTime && this.cctx.config().isEagerTtl()) {
            this.cctx.ttl().addTrackedEntry(this);
        }
    }

    protected final boolean isOffHeapValuesOnly() {
        return this.cctx.config().getMemoryMode() == CacheMemoryMode.OFFHEAP_VALUES;
    }

    protected void checkObsolete() throws GridCacheEntryRemovedException {
        assert (Thread.holdsLock(this));
        if (this.obsoleteVersionExtras() != null) {
            throw new GridCacheEntryRemovedException();
        }
    }

    @Override
    public KeyCacheObject key() {
        return this.key;
    }

    @Override
    public IgniteTxKey txKey() {
        return this.cctx.txKey(this.key);
    }

    @Override
    public synchronized GridCacheVersion version() throws GridCacheEntryRemovedException {
        this.checkObsolete();
        return this.ver;
    }

    @Override
    public synchronized boolean checkSerializableReadVersion(GridCacheVersion serReadVer) throws GridCacheEntryRemovedException {
        this.checkObsolete();
        if (!serReadVer.equals(this.ver)) {
            boolean empty;
            boolean bl = empty = this.isStartVersion() || this.deletedUnlocked();
            if (serReadVer.equals(IgniteTxEntry.SER_READ_EMPTY_ENTRY_VER)) {
                return empty;
            }
            if (serReadVer.equals(IgniteTxEntry.SER_READ_NOT_EMPTY_VER)) {
                return !empty;
            }
            return false;
        }
        return true;
    }

    int hash() {
        return this.hash;
    }

    @Override
    @Nullable
    public CacheObject peek(boolean heap, boolean offheap, boolean swap, AffinityTopologyVersion topVer, @Nullable IgniteCacheExpiryPolicy expiryPlc) throws GridCacheEntryRemovedException, IgniteCheckedException {
        GridTuple<CacheObject> val;
        assert (heap || offheap || swap);
        if (heap && (val = this.peekGlobal(topVer, null, expiryPlc)) != null) {
            return val.get();
        }
        if (offheap || swap) {
            GridCacheSwapEntry e = this.cctx.swap().read(this, false, offheap, swap, true);
            return e != null ? e.value() : null;
        }
        return null;
    }

    @Override
    @Nullable
    public CacheObject peek(boolean heap, boolean offheap, boolean swap, @Nullable IgniteCacheExpiryPolicy plc) throws GridCacheEntryRemovedException, IgniteCheckedException {
        IgniteInternalTx tx = this.cctx.tm().localTxx();
        AffinityTopologyVersion topVer = tx != null ? tx.topologyVersion() : this.cctx.affinity().affinityTopologyVersion();
        return this.peek(heap, offheap, swap, topVer, plc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private GridTuple<CacheObject> peekGlobal(AffinityTopologyVersion topVer, CacheEntryPredicate[] filter, @Nullable IgniteCacheExpiryPolicy expiryPlc) throws GridCacheEntryRemovedException, IgniteCheckedException {
        if (!this.valid(topVer)) {
            return null;
        }
        boolean rmv = false;
        try {
            while (true) {
                CacheObject val;
                GridCacheVersion ver;
                Object object = this;
                synchronized (object) {
                    block17: {
                        if (!this.checkExpired()) break block17;
                        rmv = this.markObsolete0(this.cctx.versions().next(this.ver), true, null);
                        GridTuple<CacheObject> gridTuple = null;
                        return gridTuple;
                    }
                    this.checkObsolete();
                    ver = this.ver;
                    val = this.rawGetOrUnmarshalUnlocked(false);
                    if (val != null && expiryPlc != null) {
                        this.updateTtl(expiryPlc);
                    }
                }
                if (val == null) {
                    object = null;
                    return object;
                }
                if (!this.cctx.isAll((GridCacheEntryEx)this, filter)) {
                    object = null;
                    return object;
                }
                if (!F.isEmptyOrNulls(filter) && !ver.equals(this.version())) continue;
                object = F.t(val);
                return object;
            }
        }
        finally {
            if (rmv) {
                this.onMarkedObsolete();
                this.cctx.cache().removeEntry(this);
            }
        }
    }

    private boolean checkExpired() throws IgniteCheckedException {
        long delta;
        assert (Thread.holdsLock(this));
        long expireTime = this.expireTimeExtras();
        if (expireTime > 0L && (delta = expireTime - U.currentTimeMillis()) <= 0L) {
            if (log.isTraceEnabled()) {
                log.trace("checkExpired clear [key=" + this.key + ", entry=" + System.identityHashCode(this) + ", ptr=" + this.offHeapPointer() + ']');
            }
            this.releaseSwap();
            this.clearIndex(this.saveValueForIndexUnlocked());
            return true;
        }
        return false;
    }

    @Override
    public synchronized CacheObject rawGet() {
        return this.val;
    }

    @Override
    @Nullable
    public synchronized CacheObject rawGetOrUnmarshal(boolean tmp) throws IgniteCheckedException {
        return this.rawGetOrUnmarshalUnlocked(tmp);
    }

    @Nullable
    public CacheObject rawGetOrUnmarshalUnlocked(boolean tmp) throws IgniteCheckedException {
        assert (Thread.holdsLock(this));
        CacheObject val = this.val;
        if (val != null) {
            return val;
        }
        if (this.hasOffHeapPointer()) {
            CacheObject val0 = this.cctx.fromOffheap(this.offHeapPointer(), tmp);
            if (!tmp && this.cctx.kernalContext().config().isPeerClassLoadingEnabled()) {
                val0.finishUnmarshal(this.cctx.cacheObjectContext(), this.cctx.deploy().globalLoader());
            }
            return val0;
        }
        return null;
    }

    @Override
    public final synchronized boolean hasValue() {
        return this.hasValueUnlocked();
    }

    protected final boolean hasValueUnlocked() {
        assert (Thread.holdsLock(this));
        return this.val != null || this.hasOffHeapPointer();
    }

    @Override
    public synchronized CacheObject rawPut(CacheObject val, long ttl) {
        CacheObject old = this.val;
        this.update(val, CU.toExpireTime(ttl), ttl, this.nextVersion(), true);
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean initialValue(CacheObject val, GridCacheVersion ver, long ttl, long expireTime, boolean preload, AffinityTopologyVersion topVer, GridDrType drType, boolean fromStore) throws IgniteCheckedException, GridCacheEntryRemovedException {
        GridCacheMapEntry gridCacheMapEntry = this;
        synchronized (gridCacheMapEntry) {
            this.checkObsolete();
            if (this.isNew() && !this.cctx.swap().containsKey(this.key, this.partition()) || !preload && this.deletedUnlocked()) {
                long expTime = expireTime < 0L ? CU.toExpireTime(ttl) : expireTime;
                val = this.cctx.kernalContext().cacheObjects().prepareForCache(val, this.cctx);
                if (val != null) {
                    this.updateIndex(val, expTime, ver, null);
                }
                this.update(val, expTime, ttl, ver, true);
                boolean skipQryNtf = false;
                if (val == null) {
                    skipQryNtf = true;
                    if (this.cctx.deferredDelete() && !this.deletedUnlocked() && !this.isInternal()) {
                        this.deletedUnlocked(true);
                    }
                } else if (this.deletedUnlocked()) {
                    this.deletedUnlocked(false);
                }
                long updateCntr = 0L;
                if (!preload) {
                    updateCntr = this.nextPartCounter(topVer);
                }
                this.drReplicate(drType, val, ver, topVer);
                if (!skipQryNtf) {
                    this.cctx.continuousQueries().onEntryUpdated(this.key, val, null, this.isInternal() || !this.context().userCache(), this.partition(), true, preload, updateCntr, null, topVer);
                    this.cctx.dataStructures().onEntryUpdated(this.key, false, true);
                }
                if (!fromStore && this.cctx.store().isLocal() && val != null) {
                    this.cctx.store().put(null, this.key, val, ver);
                }
                return true;
            }
            return false;
        }
    }

    private long nextPartCounter(AffinityTopologyVersion topVer) {
        long updateCntr;
        if (!this.cctx.isLocal() && !this.isNear()) {
            GridDhtLocalPartition locPart = this.cctx.topology().localPartition(this.partition(), topVer, false);
            if (locPart == null) {
                return 0L;
            }
            updateCntr = locPart.nextUpdateCounter();
        } else {
            updateCntr = 0L;
        }
        return updateCntr;
    }

    @Override
    public synchronized boolean initialValue(KeyCacheObject key, GridCacheSwapEntry unswapped) throws IgniteCheckedException, GridCacheEntryRemovedException {
        this.checkObsolete();
        if (this.isNew()) {
            CacheObject val = unswapped.value();
            val = this.cctx.kernalContext().cacheObjects().prepareForCache(val, this.cctx);
            this.update(val, unswapped.expireTime(), unswapped.ttl(), unswapped.version(), true);
            return true;
        }
        return false;
    }

    public synchronized GridCacheVersionedEntryEx versionedEntry(boolean keepBinary) throws IgniteCheckedException, GridCacheEntryRemovedException {
        boolean isNew = this.isStartVersion();
        CacheObject val = isNew ? this.unswap(true, false) : this.rawGetOrUnmarshalUnlocked(false);
        return new GridCacheLazyPlainVersionedEntry(this.cctx, this.key, val, this.ttlExtras(), this.expireTimeExtras(), this.ver.conflictVersion(), isNew, keepBinary);
    }

    @Override
    public synchronized void clearReserveForLoad(GridCacheVersion ver) throws IgniteCheckedException {
        if (this.obsoleteVersionExtras() != null) {
            return;
        }
        if (ver.equals(this.ver)) {
            assert (this.evictionDisabled()) : this;
            this.flags = (byte)(this.flags & 0xFFFFFFEF);
        }
    }

    @Override
    public synchronized EntryGetResult versionedValue(CacheObject val, GridCacheVersion curVer, GridCacheVersion newVer, @Nullable IgniteCacheExpiryPolicy loadExpiryPlc, @Nullable ReaderArguments readerArgs) throws IgniteCheckedException, GridCacheEntryRemovedException {
        this.checkObsolete();
        this.addReaderIfNeed(readerArgs);
        if (curVer == null || curVer.equals(this.ver)) {
            if (val != this.val) {
                long expTime;
                long ttl;
                GridCacheMvcc mvcc = this.mvccExtras();
                if (mvcc != null && !mvcc.isEmpty(new GridCacheVersion[0])) {
                    return this.entryGetResult(this.val, this.ver, false);
                }
                if (newVer == null) {
                    newVer = this.cctx.versions().next();
                }
                CacheObject old = this.rawGetOrUnmarshalUnlocked(false);
                if (loadExpiryPlc != null) {
                    IgniteBiTuple<Long, Long> initTtlAndExpireTime = GridCacheMapEntry.initialTtlAndExpireTime(loadExpiryPlc);
                    ttl = initTtlAndExpireTime.get1();
                    expTime = initTtlAndExpireTime.get2();
                } else {
                    ttl = this.ttlExtras();
                    expTime = this.expireTimeExtras();
                }
                val = this.cctx.kernalContext().cacheObjects().prepareForCache(val, this.cctx);
                if (val != null) {
                    this.updateIndex(val, expTime, newVer, old);
                    if (this.deletedUnlocked()) {
                        this.deletedUnlocked(false);
                    }
                }
                this.update(val, expTime, ttl, newVer, true);
                return this.entryGetResult(val, newVer, false);
            }
            assert (!this.evictionDisabled()) : this;
        }
        return this.entryGetResult(this.val, this.ver, false);
    }

    private void addReaderIfNeed(@Nullable ReaderArguments readerArgs) {
        block5: {
            if (readerArgs != null) {
                assert (this instanceof GridDhtCacheEntry) : this;
                assert (Thread.holdsLock(this));
                try {
                    ((GridDhtCacheEntry)this).addReader(readerArgs.reader(), readerArgs.messageId(), readerArgs.topologyVersion());
                }
                catch (GridCacheEntryRemovedException e) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError(this);
                }
            }
        }
    }

    private GridCacheVersion nextVersion() {
        return this.cctx.versions().next(this.ver);
    }

    @Override
    public synchronized boolean hasLockCandidate(GridCacheVersion ver) throws GridCacheEntryRemovedException {
        this.checkObsolete();
        GridCacheMvcc mvcc = this.mvccExtras();
        return mvcc != null && mvcc.hasCandidate(ver);
    }

    @Override
    public synchronized boolean hasLockCandidate(long threadId) throws GridCacheEntryRemovedException {
        this.checkObsolete();
        GridCacheMvcc mvcc = this.mvccExtras();
        return mvcc != null && mvcc.localCandidate(threadId) != null;
    }

    @Override
    public synchronized boolean lockedByAny(GridCacheVersion ... exclude) throws GridCacheEntryRemovedException {
        this.checkObsolete();
        GridCacheMvcc mvcc = this.mvccExtras();
        return mvcc != null && !mvcc.isEmpty(exclude);
    }

    @Override
    public boolean lockedByThread() throws GridCacheEntryRemovedException {
        return this.lockedByThread(Thread.currentThread().getId());
    }

    @Override
    public synchronized boolean lockedLocally(GridCacheVersion lockVer) throws GridCacheEntryRemovedException {
        this.checkObsolete();
        GridCacheMvcc mvcc = this.mvccExtras();
        return mvcc != null && mvcc.isLocallyOwned(lockVer);
    }

    @Override
    public synchronized boolean lockedByThread(long threadId, GridCacheVersion exclude) throws GridCacheEntryRemovedException {
        this.checkObsolete();
        GridCacheMvcc mvcc = this.mvccExtras();
        return mvcc != null && mvcc.isLocallyOwnedByThread(threadId, false, exclude);
    }

    @Override
    public synchronized boolean lockedLocallyByIdOrThread(GridCacheVersion lockVer, long threadId) throws GridCacheEntryRemovedException {
        GridCacheMvcc mvcc = this.mvccExtras();
        return mvcc != null && mvcc.isLocallyOwnedByIdOrThread(lockVer, threadId);
    }

    @Override
    public synchronized boolean lockedByThread(long threadId) throws GridCacheEntryRemovedException {
        this.checkObsolete();
        GridCacheMvcc mvcc = this.mvccExtras();
        return mvcc != null && mvcc.isLocallyOwnedByThread(threadId, true, new GridCacheVersion[0]);
    }

    @Override
    public synchronized boolean lockedBy(GridCacheVersion ver) throws GridCacheEntryRemovedException {
        this.checkObsolete();
        GridCacheMvcc mvcc = this.mvccExtras();
        return mvcc != null && mvcc.isOwnedBy(ver);
    }

    @Override
    public synchronized boolean lockedByThreadUnsafe(long threadId) {
        GridCacheMvcc mvcc = this.mvccExtras();
        return mvcc != null && mvcc.isLocallyOwnedByThread(threadId, true, new GridCacheVersion[0]);
    }

    @Override
    public synchronized boolean lockedByUnsafe(GridCacheVersion ver) {
        GridCacheMvcc mvcc = this.mvccExtras();
        return mvcc != null && mvcc.isOwnedBy(ver);
    }

    @Override
    public synchronized boolean lockedLocallyUnsafe(GridCacheVersion lockVer) {
        GridCacheMvcc mvcc = this.mvccExtras();
        return mvcc != null && mvcc.isLocallyOwned(lockVer);
    }

    @Override
    public synchronized boolean hasLockCandidateUnsafe(GridCacheVersion ver) {
        GridCacheMvcc mvcc = this.mvccExtras();
        return mvcc != null && mvcc.hasCandidate(ver);
    }

    @Override
    public synchronized Collection<GridCacheMvccCandidate> localCandidates(GridCacheVersion ... exclude) throws GridCacheEntryRemovedException {
        this.checkObsolete();
        GridCacheMvcc mvcc = this.mvccExtras();
        return mvcc == null ? Collections.emptyList() : mvcc.localCandidates(exclude);
    }

    @Override
    public Collection<GridCacheMvccCandidate> remoteMvccSnapshot(GridCacheVersion ... exclude) {
        return Collections.emptyList();
    }

    @Override
    @Nullable
    public synchronized GridCacheMvccCandidate candidate(GridCacheVersion ver) throws GridCacheEntryRemovedException {
        this.checkObsolete();
        GridCacheMvcc mvcc = this.mvccExtras();
        return mvcc == null ? null : mvcc.candidate(ver);
    }

    @Override
    public synchronized GridCacheMvccCandidate localCandidate(long threadId) throws GridCacheEntryRemovedException {
        this.checkObsolete();
        GridCacheMvcc mvcc = this.mvccExtras();
        return mvcc == null ? null : mvcc.localCandidate(threadId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridCacheMvccCandidate candidate(UUID nodeId, long threadId) throws GridCacheEntryRemovedException {
        boolean loc = this.cctx.nodeId().equals(nodeId);
        GridCacheMapEntry gridCacheMapEntry = this;
        synchronized (gridCacheMapEntry) {
            this.checkObsolete();
            GridCacheMvcc mvcc = this.mvccExtras();
            return mvcc == null ? null : (loc ? mvcc.localCandidate(threadId) : mvcc.remoteCandidate(nodeId, threadId));
        }
    }

    @Override
    public synchronized GridCacheMvccCandidate localOwner() throws GridCacheEntryRemovedException {
        this.checkObsolete();
        GridCacheMvcc mvcc = this.mvccExtras();
        return mvcc == null ? null : mvcc.localOwner();
    }

    @Override
    public synchronized long rawExpireTime() {
        return this.expireTimeExtras();
    }

    @Override
    public long expireTimeUnlocked() {
        assert (Thread.holdsLock(this));
        return this.expireTimeExtras();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean onTtlExpired(GridCacheVersion obsoleteVer) throws GridCacheEntryRemovedException {
        block27: {
            block28: {
                block25: {
                    block26: {
                        if (!GridCacheMapEntry.$assertionsDisabled && obsoleteVer == null) {
                            throw new AssertionError();
                        }
                        obsolete = false;
                        deferred = false;
                        ver0 = null;
                        var5_5 = this;
                        // MONITORENTER : var5_5
                        this.checkObsolete();
                        if (this.isStartVersion()) {
                            this.unswap(true, false);
                        }
                        if ((expireTime = this.expireTimeExtras()) == 0L || expireTime - U.currentTimeMillis() > 0L) {
                            var8_8 = false;
                            // MONITOREXIT : var5_5
                            return var8_8;
                        }
                        ** try [egrp 2[TRYBLOCK] [5 : 170->188)] { 
lbl-1000:
                        // 1 sources

                        {
                            expiredVal = this.rawGetOrUnmarshal(false);
                            if (expiredVal != null) break block25;
                            var9_10 = false;
                            // MONITOREXIT : var5_5
                            if (obsolete) {
                                this.onMarkedObsolete();
                                this.cctx.cache().removeEntry(this);
                            }
                            if (deferred) {
                                if (!GridCacheMapEntry.$assertionsDisabled && ver0 == null) {
                                    throw new AssertionError();
                                }
                                this.cctx.onDeferredDelete(this, ver0);
                            }
                            if (obsolete) break block26;
                            if (deferred == false) return var9_10;
                        }
                    }
                    if (this.cctx.cache().configuration().isStatisticsEnabled() == false) return var9_10;
                    this.cctx.cache().metrics0().onEvict();
                    return var9_10;
                }
                try {
                    if (this.onExpired(expiredVal, obsoleteVer)) {
                        if (this.cctx.deferredDelete()) {
                            deferred = true;
                            ver0 = this.ver;
                        } else {
                            obsolete = true;
                        }
                    }
                    // MONITOREXIT : var5_5
                    if (obsolete) {
                        this.onMarkedObsolete();
                        this.cctx.cache().removeEntry(this);
                    }
                    if (!deferred) break block27;
                    if (GridCacheMapEntry.$assertionsDisabled || ver0 != null) break block28;
                }
lbl58:
                // 3 sources

                catch (IgniteCheckedException e) {
                    U.error(GridCacheMapEntry.log, "Failed to clean up expired cache entry: " + this, e);
                    return true;
                }
                finally {
                    if (obsolete) {
                        this.onMarkedObsolete();
                        this.cctx.cache().removeEntry(this);
                    }
                    if (deferred) {
                        if (!GridCacheMapEntry.$assertionsDisabled && ver0 == null) {
                            throw new AssertionError();
                        }
                        this.cctx.onDeferredDelete(this, ver0);
                    }
                    if ((obsolete || deferred) && this.cctx.cache().configuration().isStatisticsEnabled()) {
                        this.cctx.cache().metrics0().onEvict();
                    }
                }
                throw new AssertionError();
            }
            this.cctx.onDeferredDelete(this, ver0);
        }
        if (!obsolete) {
            if (deferred == false) return true;
        }
        if (this.cctx.cache().configuration().isStatisticsEnabled() == false) return true;
        this.cctx.cache().metrics0().onEvict();
        return true;
    }

    private boolean onExpired(CacheObject expiredVal, GridCacheVersion obsoleteVer) throws IgniteCheckedException {
        assert (expiredVal != null);
        boolean rmvd = false;
        if (this.mvccExtras() != null) {
            return false;
        }
        if (this.cctx.deferredDelete() && !this.detached() && !this.isInternal()) {
            if (!this.deletedUnlocked() && !this.isStartVersion()) {
                this.update(null, 0L, 0L, this.ver, true);
                this.deletedUnlocked(true);
                rmvd = true;
            }
        } else {
            if (obsoleteVer == null) {
                obsoleteVer = this.nextVersion();
            }
            if (this.markObsolete0(obsoleteVer, true, null)) {
                rmvd = true;
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("onExpired clear [key=" + this.key + ", entry=" + System.identityHashCode(this) + ", ptr=" + this.offHeapPointer() + ']');
        }
        this.clearIndex(expiredVal);
        this.releaseSwap();
        if (this.cctx.events().isRecordable(70)) {
            this.cctx.events().addEvent(this.partition(), this.key, this.cctx.localNodeId(), null, 70, null, false, expiredVal, expiredVal != null, null, null, null, true);
        }
        this.cctx.continuousQueries().onEntryExpired(this, this.key, expiredVal);
        return rmvd;
    }

    @Override
    public synchronized long rawTtl() {
        return this.ttlExtras();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long expireTime() throws GridCacheEntryRemovedException {
        long time;
        IgniteTxLocalAdapter tx = this.currentTx();
        if (tx != null && (time = tx.entryExpireTime(this.txKey())) > 0L) {
            return time;
        }
        GridCacheMapEntry gridCacheMapEntry = this;
        synchronized (gridCacheMapEntry) {
            this.checkObsolete();
            return this.expireTimeExtras();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long ttl() throws GridCacheEntryRemovedException {
        long entryTtl;
        IgniteTxLocalAdapter tx = this.currentTx();
        if (tx != null && (entryTtl = tx.entryTtl(this.txKey())) > 0L) {
            return entryTtl;
        }
        GridCacheMapEntry gridCacheMapEntry = this;
        synchronized (gridCacheMapEntry) {
            this.checkObsolete();
            return this.ttlExtras();
        }
    }

    private IgniteTxLocalAdapter currentTx() {
        if (this.cctx.isDht()) {
            return (IgniteTxLocalAdapter)this.cctx.dht().near().context().tm().localTx();
        }
        return (IgniteTxLocalAdapter)this.cctx.tm().localTx();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTtl(@Nullable GridCacheVersion ver, long ttl) throws GridCacheEntryRemovedException {
        GridCacheMapEntry gridCacheMapEntry = this;
        synchronized (gridCacheMapEntry) {
            this.checkObsolete();
            if (this.hasValueUnlocked()) {
                this.updateTtl(ttl);
            }
        }
    }

    @Override
    public synchronized CacheObject valueBytes() throws GridCacheEntryRemovedException {
        this.checkObsolete();
        return this.valueBytesUnlocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public CacheObject valueBytes(@Nullable GridCacheVersion ver) throws IgniteCheckedException, GridCacheEntryRemovedException {
        CacheObject val = null;
        GridCacheMapEntry gridCacheMapEntry = this;
        synchronized (gridCacheMapEntry) {
            this.checkObsolete();
            if (ver == null || this.ver.equals(ver)) {
                val = this.valueBytesUnlocked();
            }
        }
        return val;
    }

    protected void updateIndex(@Nullable CacheObject val, long expireTime, GridCacheVersion ver, @Nullable CacheObject prevVal) throws IgniteCheckedException {
        assert (Thread.holdsLock(this));
        assert (val != null) : "null values in update index for key: " + this.key;
        try {
            GridCacheQueryManager<?, ?> qryMgr = this.cctx.queries();
            if (qryMgr.enabled()) {
                qryMgr.store(this.key, val, ver, expireTime);
            }
        }
        catch (IgniteCheckedException e) {
            throw new GridCacheIndexUpdateException(e);
        }
    }

    protected void clearIndex(CacheObject prevVal) throws IgniteCheckedException {
        assert (Thread.holdsLock(this));
        try {
            GridCacheQueryManager<?, ?> qryMgr = this.cctx.queries();
            if (qryMgr.enabled()) {
                qryMgr.remove(this.key(), (CacheObject)this.cctx.unwrapTemporary(prevVal));
            }
        }
        catch (IgniteCheckedException e) {
            throw new GridCacheIndexUpdateException(e);
        }
    }

    protected final CacheObject saveValueForIndexUnlocked() throws IgniteCheckedException {
        return this.saveOldValueUnlocked(true);
    }

    private CacheObject saveOldValueUnlocked(boolean qryOnly) throws IgniteCheckedException {
        assert (Thread.holdsLock(this));
        if (qryOnly && !this.cctx.queries().enabled()) {
            return null;
        }
        CacheObject val = this.rawGetOrUnmarshalUnlocked(false);
        if (val == null) {
            val = this.cctx.swap().readValue(this.key, true, true);
        }
        return val;
    }

    @Override
    public <K, V> Cache.Entry<K, V> wrap() {
        try {
            GridTuple<CacheObject> peek;
            IgniteInternalTx tx = this.cctx.tm().userTx();
            CacheObject val = tx != null ? ((peek = tx.peek(this.cctx, false, this.key)) == null ? this.rawGetOrUnmarshal(false) : peek.get()) : this.rawGetOrUnmarshal(false);
            return new CacheEntryImpl(this.key.value(this.cctx.cacheObjectContext(), false), CU.value(val, this.cctx, false), this.ver);
        }
        catch (GridCacheFilterFailedException ignored) {
            throw new IgniteException("Should never happen.");
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed to wrap entry: " + this, e);
        }
    }

    @Override
    public <K, V> Cache.Entry<K, V> wrapLazyValue(boolean keepBinary) {
        CacheOperationContext opCtx = this.cctx.operationContextPerCall();
        return new LazyValueEntry(this.key, keepBinary);
    }

    @Override
    @Nullable
    public CacheObject peekVisibleValue() {
        try {
            GridTuple<CacheObject> peek;
            IgniteInternalTx tx = this.cctx.tm().userTx();
            if (tx != null && (peek = tx.peek(this.cctx, false, this.key)) != null) {
                return peek.get();
            }
            if (this.detached()) {
                return this.rawGet();
            }
            while (true) {
                GridCacheEntryEx e;
                if ((e = this.cctx.cache().peekEx(this.key)) == null) {
                    return null;
                }
                try {
                    return e.peek(true, false, false, null);
                }
                catch (GridCacheEntryRemovedException gridCacheEntryRemovedException) {
                    continue;
                }
                catch (IgniteCheckedException ex) {
                    throw new IgniteException(ex);
                }
                break;
            }
        }
        catch (GridCacheFilterFailedException ignored) {
            throw new IgniteException("Should never happen.");
        }
    }

    @Override
    public <K, V> EvictableEntry<K, V> wrapEviction() {
        return new CacheEvictableEntryImpl(this);
    }

    @Override
    public synchronized <K, V> CacheEntryImplEx<K, V> wrapVersioned() {
        return new CacheEntryImplEx(this.key.value(this.cctx.cacheObjectContext(), false), null, this.ver);
    }

    private synchronized <K, V> CacheEntryImplEx<K, V> wrapVersionedWithValue() {
        Object val = this.val == null ? null : (Object)this.val.value(this.cctx.cacheObjectContext(), false);
        return new CacheEntryImplEx(this.key.value(this.cctx.cacheObjectContext(), false), val, this.ver);
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean evictInternal(boolean swap, GridCacheVersion obsoleteVer, @Nullable CacheEntryPredicate[] filter) throws IgniteCheckedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void evictFailed(@Nullable CacheObject prevVal) throws IgniteCheckedException {
        if (this.cctx.offheapTiered() && (this.flags & 4) != 0) {
            this.flags = (byte)(this.flags & 0xFFFFFFFB);
            if (prevVal != null) {
                if (log.isTraceEnabled()) {
                    log.trace("evictFailed [key=" + this.key + ", entry=" + System.identityHashCode(this) + ", ptr=" + this.offHeapPointer() + ']');
                }
                this.cctx.swap().removeOffheap(this.key());
                this.value(prevVal);
                GridCacheQueryManager<?, ?> qryMgr = this.cctx.queries();
                if (qryMgr.enabled()) {
                    qryMgr.onUnswap(this.key, prevVal);
                }
            }
        }
    }

    @Override
    public final GridCacheBatchSwapEntry evictInBatchInternal(GridCacheVersion obsoleteVer) throws IgniteCheckedException {
        GridCacheBatchSwapEntry ret;
        block12: {
            assert (Thread.holdsLock(this));
            assert (this.cctx.isSwapOrOffheapEnabled());
            assert (!this.obsolete());
            ret = null;
            try {
                if (!this.hasReaders() && this.markObsolete0(obsoleteVer, false, null)) {
                    if (!this.isStartVersion() && this.hasValueUnlocked()) {
                        if (this.cctx.offheapTiered() && this.hasOffHeapPointer()) {
                            if (this.cctx.swap().offheapEvictionEnabled()) {
                                if (log.isTraceEnabled()) {
                                    log.trace("enableOffheapEviction evictInBatchInternal [key=" + this.key + ", entry=" + System.identityHashCode(this) + ", ptr=" + this.offHeapPointer() + ']');
                                }
                                this.cctx.swap().enableOffheapEviction(this.key(), this.partition());
                            }
                            return null;
                        }
                        IgniteUuid valClsLdrId = null;
                        IgniteUuid keyClsLdrId = null;
                        if (this.cctx.deploymentEnabled()) {
                            if (this.val != null) {
                                valClsLdrId = this.cctx.deploy().getClassLoaderId(U.detectObjectClassLoader(this.val.value(this.cctx.cacheObjectContext(), false)));
                            }
                            keyClsLdrId = this.cctx.deploy().getClassLoaderId(U.detectObjectClassLoader(this.keyValue(false)));
                        }
                        IgniteBiTuple<byte[], Byte> valBytes = this.valueBytes0();
                        ret = new GridCacheBatchSwapEntry(this.key(), this.partition(), ByteBuffer.wrap(valBytes.get1()), valBytes.get2(), this.ver, this.ttlExtras(), this.expireTimeExtras(), keyClsLdrId, valClsLdrId);
                    }
                    this.value(null);
                }
            }
            catch (GridCacheEntryRemovedException ignored) {
                if (!log.isDebugEnabled()) break block12;
                log.debug("Got removed entry when evicting (will simply return): " + this);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final boolean visitable(CacheEntryPredicate[] filter) {
        block15: {
            rmv = false;
            var3_3 = this;
            // MONITORENTER : var3_3
            if (this.obsoleteOrDeleted()) {
                var4_6 = false;
                // MONITOREXIT : var3_3
                return var4_6;
            }
            ** try [egrp 2[TRYBLOCK] [5 : 40->73)] { 
lbl-1000:
            // 1 sources

            {
                if (!this.checkExpired()) break block15;
                rmv = this.markObsolete0(this.cctx.versions().next(this.ver), true, null);
                var4_7 = false;
                // MONITOREXIT : var3_3
                if (rmv == false) return var4_7;
                this.onMarkedObsolete();
                this.cctx.cache().removeEntry(this);
                return var4_7;
            }
        }
        try {
            // MONITOREXIT : var3_3
            if (filter != CU.empty0() && !this.cctx.isAll((GridCacheEntryEx)this, filter)) {
                var3_4 = false;
                if (rmv == false) return var3_4;
                this.onMarkedObsolete();
                this.cctx.cache().removeEntry(this);
                return var3_4;
            }
            if (!rmv) ** GOTO lbl49
            this.onMarkedObsolete();
            this.cctx.cache().removeEntry(this);
        }
lbl31:
        // 3 sources

        catch (IgniteCheckedException e) {
            U.error(GridCacheMapEntry.log, "An exception was thrown while filter checking.", e);
            ex = e.getCause(RuntimeException.class);
            if (ex != null) {
                throw ex;
            }
            err = e.getCause(Error.class);
            if (err != null) {
                throw err;
            }
            var6_12 = false;
            return var6_12;
        }
        finally {
            if (rmv) {
                this.onMarkedObsolete();
                this.cctx.cache().removeEntry(this);
            }
        }
lbl49:
        // 2 sources

        if ((tx = this.cctx.tm().localTxx()) == null) return true;
        e = tx.entry(this.txKey());
        if (e == null) return true;
        if (e.op() != GridCacheOperation.DELETE) return true;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean deleted() {
        if (!this.cctx.deferredDelete()) {
            return false;
        }
        GridCacheMapEntry gridCacheMapEntry = this;
        synchronized (gridCacheMapEntry) {
            return this.deletedUnlocked();
        }
    }

    @Override
    public final synchronized boolean obsoleteOrDeleted() {
        return this.obsoleteVersionExtras() != null || this.cctx.deferredDelete() && (this.deletedUnlocked() || !this.hasValueUnlocked());
    }

    protected final boolean deletedUnlocked() {
        assert (Thread.holdsLock(this));
        if (!this.cctx.deferredDelete()) {
            return false;
        }
        return (this.flags & 1) != 0;
    }

    protected final void deletedUnlocked(boolean deleted) {
        assert (Thread.holdsLock(this));
        assert (this.cctx.deferredDelete());
        if (deleted) {
            assert (!this.deletedUnlocked()) : this;
            this.flags = (byte)(this.flags | 1);
            this.decrementMapPublicSize();
        } else {
            assert (this.deletedUnlocked()) : this;
            this.flags = (byte)(this.flags & 0xFFFFFFFE);
            this.incrementMapPublicSize();
        }
    }

    protected void incrementMapPublicSize() {
        this.cctx.incrementPublicSize(this);
    }

    protected void decrementMapPublicSize() {
        this.cctx.decrementPublicSize(this);
    }

    @Nullable
    protected final GridCacheMvcc mvccExtras() {
        return this.extras != null ? this.extras.mvcc() : null;
    }

    @Nullable
    public final synchronized List<GridCacheMvccCandidate> mvccAllLocal() {
        GridCacheMvcc mvcc;
        GridCacheMvcc gridCacheMvcc = mvcc = this.extras != null ? this.extras.mvcc() : null;
        if (mvcc == null) {
            return null;
        }
        List<GridCacheMvccCandidate> allLocs = mvcc.allLocal();
        if (allLocs == null || allLocs.isEmpty()) {
            return null;
        }
        ArrayList<GridCacheMvccCandidate> locs = new ArrayList<GridCacheMvccCandidate>(allLocs.size());
        for (int i = 0; i < allLocs.size(); ++i) {
            GridCacheMvccCandidate loc = allLocs.get(i);
            if (loc.nearLocal()) continue;
            locs.add(loc);
        }
        return locs.isEmpty() ? null : locs;
    }

    protected final void mvccExtras(@Nullable GridCacheMvcc mvcc) {
        this.extras = this.extras != null ? this.extras.mvcc(mvcc) : (mvcc != null ? new GridCacheMvccEntryExtras(mvcc) : null);
    }

    @Nullable
    protected final GridCacheVersion obsoleteVersionExtras() {
        return this.extras != null ? this.extras.obsoleteVersion() : null;
    }

    private void obsoleteVersionExtras(@Nullable GridCacheVersion obsoleteVer, GridCacheObsoleteEntryExtras ext) {
        this.extras = this.extras != null ? this.extras.obsoleteVersion(obsoleteVer) : (obsoleteVer != null ? (ext != null ? ext : new GridCacheObsoleteEntryExtras(obsoleteVer)) : null);
    }

    protected final void checkOwnerChanged(@Nullable CacheLockCandidates prevOwners, @Nullable CacheLockCandidates owners, CacheObject val) {
        assert (!Thread.holdsLock(this));
        if (prevOwners != null && owners == null) {
            this.cctx.mvcc().callback().onOwnerChanged(this, null);
            if (this.cctx.events().isRecordable(67)) {
                boolean hasVal = this.hasValue();
                GridCacheMvccCandidate cand = prevOwners.candidate(0);
                this.cctx.events().addEvent(this.partition(), this.key, cand.nodeId(), cand, 67, val, hasVal, val, hasVal, null, null, null, true);
            }
        }
        if (owners != null) {
            for (int i = 0; i < owners.size(); ++i) {
                boolean locked;
                GridCacheMvccCandidate owner = owners.candidate(i);
                boolean bl = locked = prevOwners == null || !prevOwners.hasCandidate(owner.version());
                if (!locked) continue;
                this.cctx.mvcc().callback().onOwnerChanged(this, owner);
                if (owner.local()) {
                    this.checkThreadChain(owner);
                }
                if (!this.cctx.events().isRecordable(66)) continue;
                boolean hasVal = this.hasValue();
                this.cctx.events().addEvent(this.partition(), this.key, owner.nodeId(), owner, 66, val, hasVal, val, hasVal, null, null, null, true);
            }
        }
    }

    protected abstract void checkThreadChain(GridCacheMvccCandidate var1);

    private void updateMetrics(GridCacheOperation op, boolean metrics) {
        if (metrics && this.cctx.cache().configuration().isStatisticsEnabled()) {
            if (op == GridCacheOperation.DELETE) {
                this.cctx.cache().metrics0().onRemove();
            } else {
                this.cctx.cache().metrics0().onWrite();
            }
        }
    }

    public long ttlExtras() {
        return this.extras != null ? this.extras.ttl() : 0L;
    }

    public long expireTimeExtras() {
        return this.extras != null ? this.extras.expireTime() : 0L;
    }

    protected void ttlAndExpireTimeExtras(long ttl, long expireTime) {
        assert (ttl != -1L && ttl != -2L);
        this.extras = this.extras != null ? this.extras.ttlAndExpireTime(ttl, expireTime) : (ttl != 0L ? new GridCacheTtlEntryExtras(ttl, expireTime) : null);
    }

    protected boolean hasOffHeapPointer() {
        return false;
    }

    protected long offHeapPointer() {
        return 0L;
    }

    protected void offHeapPointer(long valPtr) {
    }

    private int extrasSize() {
        return this.extras != null ? this.extras.size() : 0;
    }

    @Override
    public void onUnlock() {
    }

    public boolean equals(Object o) {
        return o == this;
    }

    public int hashCode() {
        return this.hash;
    }

    public synchronized String toString() {
        return S.toString(GridCacheMapEntry.class, this);
    }

    private class LazyValueEntry<K, V>
    implements Cache.Entry<K, V> {
        private final KeyCacheObject key;
        private boolean keepBinary;

        private LazyValueEntry(KeyCacheObject key, boolean keepBinary) {
            this.key = key;
            this.keepBinary = keepBinary;
        }

        @Override
        public K getKey() {
            return (K)GridCacheMapEntry.this.cctx.cacheObjectContext().unwrapBinaryIfNeeded(this.key, this.keepBinary);
        }

        @Override
        public V getValue() {
            return (V)GridCacheMapEntry.this.cctx.cacheObjectContext().unwrapBinaryIfNeeded(GridCacheMapEntry.this.peekVisibleValue(), this.keepBinary);
        }

        @Override
        public <T> T unwrap(Class<T> cls) {
            if (cls.isAssignableFrom(IgniteCache.class)) {
                return (T)GridCacheMapEntry.this.cctx.grid().cache(GridCacheMapEntry.this.cctx.name());
            }
            if (cls.isAssignableFrom(this.getClass())) {
                return (T)this;
            }
            if (cls.isAssignableFrom(EvictableEntry.class)) {
                return (T)GridCacheMapEntry.this.wrapEviction();
            }
            if (cls.isAssignableFrom(CacheEntryImplEx.class)) {
                return (T)(cls == CacheEntryImplEx.class ? GridCacheMapEntry.this.wrapVersioned() : GridCacheMapEntry.this.wrapVersionedWithValue());
            }
            if (cls.isAssignableFrom(GridCacheVersion.class)) {
                return (T)GridCacheMapEntry.this.ver;
            }
            if (cls.isAssignableFrom(GridCacheMapEntry.this.getClass())) {
                return (T)GridCacheMapEntry.this;
            }
            throw new IllegalArgumentException("Unwrapping to class is not supported: " + cls);
        }

        public String toString() {
            return "IteratorEntry [key=" + this.key + ']';
        }
    }
}

