/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheLockCandidates;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionEx;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.jetbrains.annotations.Nullable;

public class GridCacheMvccCandidate
implements Externalizable,
Comparable<GridCacheMvccCandidate>,
CacheLockCandidates {
    private static final long serialVersionUID = 0L;
    private static final AtomicLong IDGEN = new AtomicLong();
    @GridToStringInclude
    private UUID nodeId;
    @GridToStringInclude
    private GridCacheVersion ver;
    @GridToStringInclude
    private long threadId;
    @GridToStringExclude
    private short flags;
    private long id;
    @GridToStringInclude
    private volatile transient AffinityTopologyVersion topVer = AffinityTopologyVersion.NONE;
    private GridCacheMvccCandidate reentry;
    @GridToStringExclude
    private volatile transient GridCacheMvccCandidate prev;
    @GridToStringExclude
    private volatile transient GridCacheMvccCandidate next;
    @GridToStringExclude
    private transient GridCacheEntryEx parent;
    private volatile transient UUID otherNodeId;
    private transient GridCacheVersion otherVer;
    @GridToStringInclude
    private volatile transient Collection<ClusterNode> mappedDhtNodes;
    @GridToStringInclude
    private volatile transient Collection<ClusterNode> mappedNearNodes;
    @GridToStringInclude
    private volatile transient GridCacheVersion ownerVer;
    private GridCacheVersion serOrder;

    public GridCacheMvccCandidate() {
    }

    public GridCacheMvccCandidate(GridCacheEntryEx parent, UUID nodeId, @Nullable UUID otherNodeId, @Nullable GridCacheVersion otherVer, long threadId, GridCacheVersion ver, boolean loc, boolean reentry, boolean tx, boolean singleImplicit, boolean nearLoc, boolean dhtLoc, @Nullable GridCacheVersion serOrder, boolean read) {
        assert (nodeId != null);
        assert (ver != null);
        assert (parent != null);
        this.parent = parent;
        this.nodeId = nodeId;
        this.otherNodeId = otherNodeId;
        this.otherVer = otherVer;
        this.threadId = threadId;
        this.ver = ver;
        this.serOrder = serOrder;
        this.mask(Mask.LOCAL, loc);
        this.mask(Mask.REENTRY, reentry);
        this.mask(Mask.TX, tx);
        this.mask(Mask.SINGLE_IMPLICIT, singleImplicit);
        this.mask(Mask.NEAR_LOCAL, nearLoc);
        this.mask(Mask.DHT_LOCAL, dhtLoc);
        this.mask(Mask.READ, read);
        this.id = IDGEN.incrementAndGet();
    }

    private void mask(Mask mask, boolean on) {
        this.flags = mask.set(this.flags, on);
    }

    public short flags() {
        return this.flags;
    }

    public <V> GridCacheEntryEx parent() {
        return this.parent;
    }

    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    public void topologyVersion(AffinityTopologyVersion topVer) {
        this.topVer = topVer;
    }

    public GridCacheMvccCandidate reenter() {
        GridCacheMvccCandidate old = this.reentry;
        GridCacheMvccCandidate reentry = new GridCacheMvccCandidate(this.parent, this.nodeId, this.otherNodeId, this.otherVer, this.threadId, this.ver, this.local(), true, this.tx(), this.singleImplicit(), this.nearLocal(), this.dhtLocal(), this.serializableOrder(), this.read());
        reentry.topVer = this.topVer;
        if (old != null) {
            reentry.reentry = old;
        }
        this.reentry = reentry;
        return reentry;
    }

    @Nullable
    public GridCacheMvccCandidate unenter() {
        if (this.reentry != null) {
            GridCacheMvccCandidate old = this.reentry;
            this.reentry = this.reentry.reentry;
            return old;
        }
        return null;
    }

    public void parent(GridCacheEntryEx parent) {
        assert (parent != null);
        this.parent = parent;
    }

    public UUID nodeId() {
        return this.nodeId;
    }

    public UUID otherNodeId() {
        return this.otherNodeId;
    }

    public void otherNodeId(UUID otherNodeId) {
        this.otherNodeId = otherNodeId;
    }

    public Collection<ClusterNode> mappedDhtNodes() {
        return this.mappedDhtNodes;
    }

    public Collection<ClusterNode> mappedNearNodes() {
        return this.mappedNearNodes;
    }

    public void mappedNodeIds(Collection<ClusterNode> mappedDhtNodes, Collection<ClusterNode> mappedNearNodes) {
        this.mappedDhtNodes = mappedDhtNodes;
        this.mappedNearNodes = mappedNearNodes;
    }

    public void removeMappedNode(ClusterNode node) {
        if (this.mappedDhtNodes.contains(node)) {
            this.mappedDhtNodes = new ArrayList<ClusterNode>(F.view(this.mappedDhtNodes, F.notEqualTo(node)));
        }
        if (this.mappedNearNodes != null && this.mappedNearNodes.contains(node)) {
            this.mappedNearNodes = new ArrayList<ClusterNode>(F.view(this.mappedNearNodes, F.notEqualTo(node)));
        }
    }

    public GridCacheVersion otherVersion() {
        return this.otherVer;
    }

    public boolean otherVersion(GridCacheVersion otherVer) {
        assert (otherVer != null);
        if (this.otherVer == null) {
            this.otherVer = otherVer;
            return true;
        }
        return this.otherVer.equals(otherVer);
    }

    public boolean ownerVersion(GridCacheVersion ownerVer) {
        assert (ownerVer != null);
        if (this.ownerVer == null) {
            this.ownerVer = ownerVer;
            return true;
        }
        return this.ownerVer.equals(ownerVer);
    }

    @Nullable
    public GridCacheVersion ownerVersion() {
        return this.ownerVer;
    }

    public long threadId() {
        return this.threadId;
    }

    public GridCacheVersion version() {
        return this.ver;
    }

    public boolean local() {
        return Mask.LOCAL.get(this.flags());
    }

    public boolean tx() {
        return Mask.TX.get(this.flags());
    }

    public boolean singleImplicit() {
        return Mask.SINGLE_IMPLICIT.get(this.flags());
    }

    public boolean nearLocal() {
        return Mask.NEAR_LOCAL.get(this.flags());
    }

    public boolean dhtLocal() {
        return Mask.DHT_LOCAL.get(this.flags());
    }

    public boolean serializable() {
        return this.serOrder != null;
    }

    @Nullable
    public GridCacheVersion serializableOrder() {
        return this.serOrder;
    }

    public boolean read() {
        return Mask.READ.get(this.flags());
    }

    public boolean reentry() {
        return Mask.REENTRY.get(this.flags());
    }

    public void setReentry() {
        this.mask(Mask.REENTRY, true);
    }

    public boolean ready() {
        return Mask.READY.get(this.flags());
    }

    public void setReady() {
        this.mask(Mask.READY, true);
    }

    public boolean used() {
        return Mask.USED.get(this.flags());
    }

    public void setUsed() {
        this.mask(Mask.USED, true);
    }

    public boolean removed() {
        return Mask.REMOVED.get(this.flags());
    }

    public void setRemoved() {
        this.mask(Mask.REMOVED, true);
    }

    public boolean owner() {
        return Mask.OWNER.get(this.flags());
    }

    public void setOwner() {
        this.mask(Mask.OWNER, true);
    }

    @Nullable
    public GridCacheMvccCandidate previous() {
        return this.prev;
    }

    public void previous(GridCacheMvccCandidate prev) {
        assert (this.threadId == prev.threadId) : "Invalid threadId [this=" + this + ", prev=" + prev + ']';
        this.prev = prev;
    }

    public GridCacheMvccCandidate next() {
        return this.next;
    }

    public void next(GridCacheMvccCandidate next) {
        this.next = next;
    }

    public IgniteTxKey key() {
        GridCacheEntryEx parent0 = this.parent;
        if (parent0 == null) {
            throw new IllegalStateException("Parent entry was not initialized for MVCC candidate: " + this);
        }
        return parent0.txKey();
    }

    @Override
    public GridCacheMvccCandidate candidate(int idx) {
        assert (idx == 0) : idx;
        return this;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean hasCandidate(GridCacheVersion ver) {
        return this.ver.equals(ver);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IgniteUtils.writeUuid(out, this.nodeId);
        out.writeBoolean(this.ver == null);
        if (this.ver != null) {
            out.writeBoolean(this.ver instanceof GridCacheVersionEx);
            this.ver.writeExternal(out);
        }
        out.writeLong(this.threadId);
        out.writeLong(this.id);
        out.writeShort(this.flags());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.nodeId = IgniteUtils.readUuid(in);
        if (!in.readBoolean()) {
            this.ver = in.readBoolean() ? new GridCacheVersionEx() : new GridCacheVersion();
            this.ver.readExternal(in);
        }
        this.threadId = in.readLong();
        this.id = in.readLong();
        short flags = in.readShort();
        this.mask(Mask.OWNER, Mask.OWNER.get(flags));
        this.mask(Mask.USED, Mask.USED.get(flags));
        this.mask(Mask.TX, Mask.TX.get(flags));
    }

    @Override
    public int compareTo(GridCacheMvccCandidate o) {
        if (o == this) {
            return 0;
        }
        int c = this.ver.compareTo(o.ver);
        if (c == 0) {
            return this.key().equals(o.key()) ? 0 : (this.id < o.id ? -1 : 1);
        }
        return c;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        GridCacheMvccCandidate other = (GridCacheMvccCandidate)o;
        assert (this.key() != null && other.key() != null) : "Key is null [this=" + this + ", other=" + o + ']';
        return this.ver.equals(other.ver) && this.key().equals(other.key());
    }

    public int hashCode() {
        return this.ver.hashCode();
    }

    public String toString() {
        GridCacheMvccCandidate prev = this.previous();
        GridCacheMvccCandidate next = this.next();
        return S.toString(GridCacheMvccCandidate.class, this, "key", this.parent == null ? null : this.parent.key(), true, "masks", Mask.toString(this.flags()), false, "prevVer", prev == null ? null : prev.version(), false, "nextVer", next == null ? null : next.version(), false);
    }

    static enum Mask {
        LOCAL(1),
        OWNER(2),
        READY(4),
        REENTRY(8),
        USED(16),
        TX(64),
        SINGLE_IMPLICIT(128),
        DHT_LOCAL(256),
        NEAR_LOCAL(512),
        REMOVED(1024),
        READ(2048);

        private static final Mask[] MASKS;
        private final short bit;

        private Mask(int bit) {
            this.bit = (short)bit;
        }

        boolean get(short flags) {
            return (flags & this.bit) == this.bit;
        }

        short set(short flags, boolean on) {
            return (short)(on ? flags | this.bit : flags & ~this.bit);
        }

        int bit(short flags) {
            return this.get(flags) ? 1 : 0;
        }

        static String toString(short flags) {
            SB sb = new SB();
            for (Mask m : MASKS) {
                if (m.ordinal() != 0) {
                    sb.a('|');
                }
                sb.a(m.name().toLowerCase()).a('=').a(m.bit(flags));
            }
            return sb.toString();
        }

        static {
            MASKS = Mask.values();
        }
    }
}

