/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheSwapEntry;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class GridCacheOffheapSwapEntry
implements GridCacheSwapEntry {
    private final long ptr;
    private final long valPtr;
    private final GridCacheVersion ver;
    private CacheObject val;
    private final byte type;

    public GridCacheOffheapSwapEntry(long ptr, int size) {
        assert (ptr > 0L) : ptr;
        assert (size > 40) : size;
        this.ptr = ptr;
        long readPtr = ptr + 16L;
        boolean verEx = GridUnsafe.getByte(readPtr++) != 0;
        this.ver = U.readVersion(readPtr, verEx);
        this.type = GridUnsafe.getByte((readPtr += verEx ? 48L : 24L) + 4L);
        this.valPtr = readPtr;
        assert (ptr + (long)size > (long)GridUnsafe.getInt(this.valPtr) + this.valPtr + 5L);
    }

    public static long valueAddress(long ptr, int size) {
        assert (ptr > 0L) : ptr;
        assert (size > 40) : size;
        ptr += 16L;
        boolean verEx = GridUnsafe.getByte(ptr++) != 0;
        assert ((ptr += verEx ? 48L : 24L) + (long)size > (long)GridUnsafe.getInt(ptr) + ptr + 5L);
        return ptr;
    }

    public static long timeToLive(long ptr) {
        return GridUnsafe.getLong(ptr);
    }

    public static long expireTime(long ptr) {
        return GridUnsafe.getLong(ptr + 8L);
    }

    public static GridCacheVersion version(long ptr) {
        long addr = ptr + 16L;
        boolean verEx = GridUnsafe.getByte(addr) != 0;
        return U.readVersion(++addr, verEx);
    }

    @Override
    public byte[] valueBytes() {
        return null;
    }

    @Override
    public void valueBytes(byte[] valBytes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CacheObject value() {
        return this.val;
    }

    @Override
    public void value(CacheObject val) {
        this.val = val;
    }

    @Override
    public byte type() {
        return this.type;
    }

    @Override
    public GridCacheVersion version() {
        return this.ver;
    }

    @Override
    public long ttl() {
        return GridUnsafe.getLong(this.ptr);
    }

    @Override
    public long expireTime() {
        return GridUnsafe.getLong(this.ptr + 8L);
    }

    @Override
    @Nullable
    public IgniteUuid keyClassLoaderId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long offheapPointer() {
        return this.valPtr;
    }

    @Override
    @Nullable
    public IgniteUuid valueClassLoaderId() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return S.toString(GridCacheOffheapSwapEntry.class, this);
    }
}

