/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Collection;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCachePreloader;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicAbstractUpdateRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionDemandMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionSupplyMessageV2;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPreloaderAssignments;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.Nullable;

public class GridCachePreloaderAdapter
implements GridCachePreloader {
    protected final GridCacheContext<?, ?> cctx;
    protected final IgniteLogger log;
    protected final AffinityFunction aff;
    private final IgniteInternalFuture finFut;
    protected IgnitePredicate<GridCacheEntryInfo> preloadPred;

    public GridCachePreloaderAdapter(GridCacheContext<?, ?> cctx) {
        assert (cctx != null);
        this.cctx = cctx;
        this.log = cctx.logger(this.getClass());
        this.aff = cctx.config().getAffinity();
        this.finFut = new GridFinishedFuture();
    }

    @Override
    public void start() throws IgniteCheckedException {
    }

    @Override
    public void stop() {
    }

    @Override
    public void onKernalStart() throws IgniteCheckedException {
    }

    @Override
    public void onKernalStop() {
    }

    @Override
    public IgniteInternalFuture<Boolean> forceRebalance() {
        return new GridFinishedFuture<Boolean>(true);
    }

    @Override
    public boolean needForceKeys() {
        return false;
    }

    @Override
    public void onReconnected() {
    }

    @Override
    public void preloadPredicate(IgnitePredicate<GridCacheEntryInfo> preloadPred) {
        this.preloadPred = preloadPred;
    }

    @Override
    public IgnitePredicate<GridCacheEntryInfo> preloadPredicate() {
        return this.preloadPred;
    }

    @Override
    public IgniteInternalFuture<Object> startFuture() {
        return this.finFut;
    }

    @Override
    public IgniteInternalFuture<?> syncFuture() {
        return this.finFut;
    }

    @Override
    public IgniteInternalFuture<Boolean> rebalanceFuture() {
        return this.finFut;
    }

    @Override
    public void unwindUndeploys() {
        this.cctx.deploy().unwind(this.cctx);
    }

    @Override
    public void handleSupplyMessage(int idx, UUID id, GridDhtPartitionSupplyMessageV2 s) {
    }

    @Override
    public void handleDemandMessage(int idx, UUID id, GridDhtPartitionDemandMessage d) {
    }

    @Override
    public IgniteInternalFuture<Object> request(Collection<KeyCacheObject> keys, AffinityTopologyVersion topVer) {
        return new GridFinishedFuture<Object>();
    }

    @Override
    public IgniteInternalFuture<Object> request(GridNearAtomicAbstractUpdateRequest req, AffinityTopologyVersion topVer) {
        return new GridFinishedFuture<Object>();
    }

    @Override
    public void onInitialExchangeComplete(@Nullable Throwable err) {
    }

    @Override
    public GridDhtPreloaderAssignments assign(GridDhtPartitionsExchangeFuture exchFut) {
        return null;
    }

    @Override
    public Runnable addAssignments(GridDhtPreloaderAssignments assignments, boolean forcePreload, int cnt, Runnable next, @Nullable GridFutureAdapter<Boolean> forcedRebFut) {
        return null;
    }

    @Override
    public void evictPartitionAsync(GridDhtLocalPartition part) {
    }

    @Override
    public void onTopologyChanged(GridDhtPartitionsExchangeFuture lastFut) {
    }

    @Override
    public void dumpDebugInfo() {
    }
}

