/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import javax.cache.configuration.Factory;
import javax.management.JMException;
import javax.management.MBeanServer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.CacheAtomicWriteOrderMode;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheExistsException;
import org.apache.ignite.cache.CacheMemoryMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.AffinityFunctionContext;
import org.apache.ignite.cache.affinity.AffinityNodeAddressHashResolver;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.store.CacheStore;
import org.apache.ignite.cache.store.CacheStoreSessionListener;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DeploymentMode;
import org.apache.ignite.configuration.FileSystemConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.NearCacheConfiguration;
import org.apache.ignite.configuration.TransactionConfiguration;
import org.apache.ignite.internal.GridComponent;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteClientDisconnectedCheckedException;
import org.apache.ignite.internal.IgniteComponentType;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteTransactionsEx;
import org.apache.ignite.internal.binary.BinaryContext;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.binary.GridBinaryMarshaller;
import org.apache.ignite.internal.managers.discovery.DiscoveryCustomMessage;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheAffinityChangeMessage;
import org.apache.ignite.internal.processors.cache.CacheAffinitySharedManager;
import org.apache.ignite.internal.processors.cache.CacheConflictResolutionManager;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.CacheType;
import org.apache.ignite.internal.processors.cache.DynamicCacheChangeBatch;
import org.apache.ignite.internal.processors.cache.DynamicCacheChangeRequest;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheAffinityManager;
import org.apache.ignite.internal.processors.cache.GridCacheAttributes;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheDeploymentManager;
import org.apache.ignite.internal.processors.cache.GridCacheEventManager;
import org.apache.ignite.internal.processors.cache.GridCacheEvictionManager;
import org.apache.ignite.internal.processors.cache.GridCacheIoManager;
import org.apache.ignite.internal.processors.cache.GridCacheLoaderWriterStore;
import org.apache.ignite.internal.processors.cache.GridCacheLoaderWriterStoreFactory;
import org.apache.ignite.internal.processors.cache.GridCacheManager;
import org.apache.ignite.internal.processors.cache.GridCacheMvccManager;
import org.apache.ignite.internal.processors.cache.GridCachePartitionExchangeManager;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedManager;
import org.apache.ignite.internal.processors.cache.GridCacheSharedTtlCleanupManager;
import org.apache.ignite.internal.processors.cache.GridCacheSwapManager;
import org.apache.ignite.internal.processors.cache.GridCacheTtlManager;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.GridNoStorageCacheMap;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.processors.cache.datastructures.CacheDataStructuresManager;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCache;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicCache;
import org.apache.ignite.internal.processors.cache.distributed.dht.colocated.GridDhtColocatedCache;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearAtomicCache;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTransactionalCache;
import org.apache.ignite.internal.processors.cache.dr.GridCacheDrManager;
import org.apache.ignite.internal.processors.cache.jta.CacheJtaManagerAdapter;
import org.apache.ignite.internal.processors.cache.local.GridLocalCache;
import org.apache.ignite.internal.processors.cache.local.atomic.GridLocalAtomicCache;
import org.apache.ignite.internal.processors.cache.query.GridCacheDistributedQueryManager;
import org.apache.ignite.internal.processors.cache.query.GridCacheLocalQueryManager;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryManager;
import org.apache.ignite.internal.processors.cache.query.continuous.CacheContinuousQueryManager;
import org.apache.ignite.internal.processors.cache.store.CacheStoreManager;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTransactionsImpl;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxManager;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionManager;
import org.apache.ignite.internal.processors.cacheobject.IgniteCacheObjectProcessor;
import org.apache.ignite.internal.processors.plugin.CachePluginManager;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObject;
import org.apache.ignite.internal.suggestions.GridPerformanceSuggestions;
import org.apache.ignite.internal.util.F0;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.IgniteOutClosureX;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.marshaller.MarshallerUtils;
import org.apache.ignite.spi.IgniteNodeValidationResult;
import org.jetbrains.annotations.Nullable;

public class GridCacheProcessor
extends GridProcessorAdapter {
    private static final String NULL_NAME = U.id8(UUID.randomUUID());
    private GridCacheSharedContext<?, ?> sharedCtx;
    private final Map<String, GridCacheAdapter<?, ?>> caches;
    private final Map<String, GridCacheAdapter> stoppedCaches = new ConcurrentHashMap<String, GridCacheAdapter>();
    private final Map<String, IgniteCacheProxy<?, ?>> jCacheProxies;
    private final Deque<String> stopSeq;
    private IgniteTransactionsImpl transactions;
    private ConcurrentMap<String, IgniteInternalFuture> pendingFuts = new ConcurrentHashMap<String, IgniteInternalFuture>();
    private ConcurrentMap<String, IgniteInternalFuture> pendingTemplateFuts = new ConcurrentHashMap<String, IgniteInternalFuture>();
    private ConcurrentMap<String, DynamicCacheDescriptor> registeredCaches = new ConcurrentHashMap<String, DynamicCacheDescriptor>();
    private ConcurrentMap<String, DynamicCacheDescriptor> registeredTemplates = new ConcurrentHashMap<String, DynamicCacheDescriptor>();
    private IdentityHashMap<CacheStore, ThreadLocal> sesHolders = new IdentityHashMap();
    private final Marshaller marsh;
    private final CountDownLatch cacheStartedLatch = new CountDownLatch(1);
    private Map<String, DynamicCacheDescriptor> cachesOnDisconnect;
    private Map<UUID, DynamicCacheChangeBatch> clientReconnectReqs;

    public GridCacheProcessor(GridKernalContext ctx) {
        super(ctx);
        this.caches = new ConcurrentHashMap();
        this.jCacheProxies = new ConcurrentHashMap();
        this.stopSeq = new LinkedList<String>();
        this.marsh = MarshallerUtils.jdkMarshaller(ctx.gridName());
    }

    private void initialize(CacheConfiguration cfg, CacheObjectContext cacheObjCtx) throws IgniteCheckedException {
        RendezvousAffinityFunction aff;
        if (cfg.getCacheMode() == null) {
            cfg.setCacheMode(CacheConfiguration.DFLT_CACHE_MODE);
        }
        if (cfg.getMemoryMode() == null) {
            cfg.setMemoryMode(CacheConfiguration.DFLT_MEMORY_MODE);
        }
        if (cfg.getNodeFilter() == null) {
            cfg.setNodeFilter(CacheConfiguration.ALL_NODES);
        }
        if (cfg.getAffinity() == null) {
            if (cfg.getCacheMode() == CacheMode.PARTITIONED) {
                aff = new RendezvousAffinityFunction();
                aff.setHashIdResolver(new AffinityNodeAddressHashResolver());
                cfg.setAffinity(aff);
            } else if (cfg.getCacheMode() == CacheMode.REPLICATED) {
                aff = new RendezvousAffinityFunction(false, 512);
                aff.setHashIdResolver(new AffinityNodeAddressHashResolver());
                cfg.setAffinity(aff);
                cfg.setBackups(Integer.MAX_VALUE);
            } else {
                cfg.setAffinity(new LocalAffinityFunction());
            }
        } else if (cfg.getCacheMode() != CacheMode.LOCAL) {
            if (cfg.getAffinity() instanceof RendezvousAffinityFunction && (aff = (RendezvousAffinityFunction)cfg.getAffinity()).getHashIdResolver() == null) {
                aff.setHashIdResolver(new AffinityNodeAddressHashResolver());
            }
        } else if (cfg.getCacheMode() == CacheMode.LOCAL && !(cfg.getAffinity() instanceof LocalAffinityFunction)) {
            cfg.setAffinity(new LocalAffinityFunction());
            U.warn(this.log, "AffinityFunction configuration parameter will be ignored for local cache [cacheName=" + U.maskName(cfg.getName()) + ']');
        }
        if (cfg.getCacheMode() == CacheMode.REPLICATED) {
            cfg.setBackups(Integer.MAX_VALUE);
        }
        if (cfg.getQueryParallelism() > 1 && cfg.getCacheMode() != CacheMode.PARTITIONED) {
            throw new IgniteCheckedException("Segmented indices are supported for PARTITIONED mode only.");
        }
        if (cfg.getAffinityMapper() == null) {
            cfg.setAffinityMapper(cacheObjCtx.defaultAffMapper());
        }
        this.ctx.igfsHelper().preProcessCacheConfiguration(cfg);
        if (cfg.getRebalanceMode() == null) {
            cfg.setRebalanceMode(CacheRebalanceMode.ASYNC);
        }
        if (cfg.getAtomicityMode() == null) {
            cfg.setAtomicityMode(CacheConfiguration.DFLT_CACHE_ATOMICITY_MODE);
        }
        if (cfg.getWriteSynchronizationMode() == null) {
            cfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.PRIMARY_SYNC);
        }
        assert (cfg.getWriteSynchronizationMode() != null);
        if (cfg.getAtomicityMode() == CacheAtomicityMode.ATOMIC) {
            if (cfg.getAtomicWriteOrderMode() == null) {
                cfg.setAtomicWriteOrderMode(cfg.getWriteSynchronizationMode() == CacheWriteSynchronizationMode.FULL_SYNC ? CacheAtomicWriteOrderMode.CLOCK : CacheAtomicWriteOrderMode.PRIMARY);
            } else if (cfg.getWriteSynchronizationMode() != CacheWriteSynchronizationMode.FULL_SYNC && cfg.getAtomicWriteOrderMode() == CacheAtomicWriteOrderMode.CLOCK) {
                cfg.setAtomicWriteOrderMode(CacheAtomicWriteOrderMode.PRIMARY);
                U.warn(this.log, "Automatically set write order mode to PRIMARY for better performance [writeSynchronizationMode=" + (Object)((Object)cfg.getWriteSynchronizationMode()) + ", " + "cacheName=" + U.maskName(cfg.getName()) + ']');
            }
        }
        if (cfg.getCacheStoreFactory() == null) {
            Factory writerFactory;
            Factory ldrFactory = cfg.getCacheLoaderFactory();
            Factory factory = writerFactory = cfg.isWriteThrough() ? cfg.getCacheWriterFactory() : null;
            if (ldrFactory != null || writerFactory != null) {
                cfg.setCacheStoreFactory(new GridCacheLoaderWriterStoreFactory(ldrFactory, writerFactory));
            }
        } else {
            if (cfg.getCacheLoaderFactory() != null) {
                throw new IgniteCheckedException("Cannot set both cache loaded factory and cache store factory for cache: " + U.maskName(cfg.getName()));
            }
            if (cfg.getCacheWriterFactory() != null) {
                throw new IgniteCheckedException("Cannot set both cache writer factory and cache store factory for cache: " + U.maskName(cfg.getName()));
            }
        }
    }

    private void suggestOptimizations(CacheConfiguration cfg, boolean hasStore) {
        GridPerformanceSuggestions perf = this.ctx.performance();
        String msg = "Disable eviction policy (remove from configuration)";
        if (cfg.getEvictionPolicy() != null) {
            perf.add(msg, false);
            perf.add("Disable synchronized evictions (set 'evictSynchronized' to false)", !cfg.isEvictSynchronized());
        } else {
            perf.add(msg, true);
        }
        if (cfg.getCacheMode() == CacheMode.PARTITIONED) {
            perf.add("Disable near cache (set 'nearConfiguration' to null)", cfg.getNearConfiguration() == null);
            if (cfg.getAffinity() != null) {
                perf.add("Decrease number of backups (set 'backups' to 0)", cfg.getBackups() == 0);
            }
        }
        perf.add("Enable ATOMIC mode if not using transactions (set 'atomicityMode' to ATOMIC)", cfg.getAtomicityMode() == CacheAtomicityMode.ATOMIC);
        perf.add("Disable fully synchronous writes (set 'writeSynchronizationMode' to PRIMARY_SYNC or FULL_ASYNC)", cfg.getWriteSynchronizationMode() != CacheWriteSynchronizationMode.FULL_SYNC);
        perf.add("Disable swap store (set 'swapEnabled' to false)", !cfg.isSwapEnabled());
        if (hasStore && cfg.isWriteThrough()) {
            perf.add("Enable write-behind to persistent store (set 'writeBehindEnabled' to true)", cfg.isWriteBehindEnabled());
        }
    }

    private void validate(IgniteConfiguration c, CacheConfiguration cc, CacheType cacheType, @Nullable CacheStore cfgStore) throws IgniteCheckedException {
        if (cc.getCacheMode() == CacheMode.REPLICATED && cc.getNearConfiguration() != null && this.ctx.discovery().cacheAffinityNode(this.ctx.discovery().localNode(), cc.getName())) {
            U.warn(this.log, "Near cache cannot be used with REPLICATED cache, will be ignored [cacheName=" + U.maskName(cc.getName()) + ']');
            cc.setNearConfiguration(null);
        }
        if (cc.getCacheMode() == CacheMode.LOCAL && !cc.getAffinity().getClass().equals(LocalAffinityFunction.class)) {
            U.warn(this.log, "AffinityFunction configuration parameter will be ignored for local cache [cacheName=" + U.maskName(cc.getName()) + ']');
        }
        if (cc.getAffinity().partitions() > 16384) {
            throw new IgniteCheckedException("Cannot have more than 16384 partitions [cacheName=" + cc.getName() + ", partitions=" + cc.getAffinity().partitions() + ']');
        }
        if (cc.getRebalanceMode() != CacheRebalanceMode.NONE) {
            this.assertParameter(cc.getRebalanceBatchSize() > 0, "rebalanceBatchSize > 0");
        }
        if ((cc.getCacheMode() == CacheMode.PARTITIONED || cc.getCacheMode() == CacheMode.REPLICATED) && cc.getAtomicityMode() == CacheAtomicityMode.ATOMIC && cc.getWriteSynchronizationMode() == CacheWriteSynchronizationMode.FULL_ASYNC) {
            U.warn(this.log, "Cache write synchronization mode is set to FULL_ASYNC. All single-key 'put' and 'remove' operations will return 'null', all 'putx' and 'removex' operations will return 'true' [cacheName=" + U.maskName(cc.getName()) + ']');
        }
        DeploymentMode depMode = c.getDeploymentMode();
        if (!(!c.isPeerClassLoadingEnabled() || depMode != DeploymentMode.PRIVATE && depMode != DeploymentMode.ISOLATED || CU.isSystemCache(cc.getName()) || c.getMarshaller() instanceof BinaryMarshaller)) {
            throw new IgniteCheckedException("Cache can be started in PRIVATE or ISOLATED deployment mode only when BinaryMarshaller is used [depMode=" + (Object)((Object)this.ctx.config().getDeploymentMode()) + ", marshaller=" + c.getMarshaller().getClass().getName() + ']');
        }
        if (cc.isWriteBehindEnabled()) {
            if (cfgStore == null) {
                throw new IgniteCheckedException("Cannot enable write-behind (writer or store is not provided) for cache: " + U.maskName(cc.getName()));
            }
            this.assertParameter(cc.getWriteBehindBatchSize() > 0, "writeBehindBatchSize > 0");
            this.assertParameter(cc.getWriteBehindFlushSize() >= 0, "writeBehindFlushSize >= 0");
            this.assertParameter(cc.getWriteBehindFlushFrequency() >= 0L, "writeBehindFlushFrequency >= 0");
            this.assertParameter(cc.getWriteBehindFlushThreadCount() > 0, "writeBehindFlushThreadCount > 0");
            if (cc.getWriteBehindFlushSize() == 0 && cc.getWriteBehindFlushFrequency() == 0L) {
                throw new IgniteCheckedException("Cannot set both 'writeBehindFlushFrequency' and 'writeBehindFlushSize' parameters to 0 for cache: " + U.maskName(cc.getName()));
            }
        }
        if (cc.isReadThrough() && cfgStore == null) {
            throw new IgniteCheckedException("Cannot enable read-through (loader or store is not provided) for cache: " + U.maskName(cc.getName()));
        }
        if (cc.isWriteThrough() && cfgStore == null) {
            throw new IgniteCheckedException("Cannot enable write-through (writer or store is not provided) for cache: " + U.maskName(cc.getName()));
        }
        long delay = cc.getRebalanceDelay();
        if (delay != 0L) {
            if (cc.getCacheMode() != CacheMode.PARTITIONED) {
                U.warn(this.log, "Rebalance delay is supported only for partitioned caches (will ignore): " + cc.getName(), "Will ignore rebalance delay for cache: " + U.maskName(cc.getName()));
            } else if (cc.getRebalanceMode() == CacheRebalanceMode.SYNC) {
                if (delay < 0L) {
                    U.warn(this.log, "Ignoring SYNC rebalance mode with manual rebalance start (node will not wait for rebalancing to be finished): " + U.maskName(cc.getName()), "Node will not wait for rebalance in SYNC mode: " + U.maskName(cc.getName()));
                } else {
                    U.warn(this.log, "Using SYNC rebalance mode with rebalance delay (node will wait until rebalancing is initiated for " + delay + "ms) for cache: " + U.maskName(cc.getName()), "Node will wait until rebalancing is initiated for " + delay + "ms for cache: " + U.maskName(cc.getName()));
                }
            }
        }
        this.ctx.igfsHelper().validateCacheConfiguration(cc);
        switch (cc.getMemoryMode()) {
            case OFFHEAP_VALUES: {
                if (cacheType.userCache() && cc.getEvictionPolicy() == null && cc.getOffHeapMaxMemory() >= 0L) {
                    U.quietAndWarn(this.log, "Off heap maximum memory configuration property will be ignored for the cache working in OFFHEAP_VALUES mode (memory usage will be unlimited): " + U.maskName(cc.getName()) + ". Consider configuring eviction policy or switching to " + "OFFHEAP_TIERED mode or.");
                }
                if (cc.getOffHeapMaxMemory() >= 0L) break;
                cc.setOffHeapMaxMemory(0L);
                break;
            }
            case OFFHEAP_TIERED: {
                if (cc.getOffHeapMaxMemory() >= 0L) break;
                cc.setOffHeapMaxMemory(0L);
                break;
            }
            case ONHEAP_TIERED: {
                if (!cacheType.userCache() || cc.getEvictionPolicy() != null || cc.getOffHeapMaxMemory() < 0L) break;
                U.quietAndWarn(this.log, "Eviction policy not enabled with ONHEAP_TIERED mode for cache (entries will not be moved to off-heap store): " + U.maskName(cc.getName()));
                break;
            }
            default: {
                throw new IllegalStateException("Unknown memory mode: " + (Object)((Object)cc.getMemoryMode()));
            }
        }
        if (cc.getMemoryMode() == CacheMemoryMode.OFFHEAP_VALUES && GridQueryProcessor.isEnabled(cc)) {
            throw new IgniteCheckedException("Cannot have query indexing enabled while values are stored off-heap. You must either disable query indexing or disable off-heap values only flag for cache: " + U.maskName(cc.getName()));
        }
        if (cc.getAtomicityMode() == CacheAtomicityMode.ATOMIC) {
            this.assertParameter(cc.getTransactionManagerLookupClassName() == null, "transaction manager can not be used with ATOMIC cache");
        }
    }

    private List<GridCacheManager> dhtManagers(GridCacheContext ctx) {
        return F.asList(new GridCacheManager[]{ctx.store(), ctx.events(), ctx.swap(), ctx.evicts(), ctx.queries(), ctx.continuousQueries(), ctx.dr()});
    }

    private Collection<GridCacheManager> dhtExcludes(GridCacheContext ctx) {
        if (ctx.config().getCacheMode() == CacheMode.LOCAL || !GridCacheUtils.isNearEnabled(ctx)) {
            return Collections.emptyList();
        }
        return F.asList(new GridCacheManager[]{ctx.queries(), ctx.continuousQueries(), ctx.store()});
    }

    private void prepare(CacheConfiguration cfg, Collection<Object> objs) throws IgniteCheckedException {
        this.prepare(cfg, cfg.getEvictionPolicy(), false);
        this.prepare(cfg, cfg.getAffinity(), false);
        this.prepare(cfg, cfg.getAffinityMapper(), false);
        this.prepare(cfg, cfg.getEvictionFilter(), false);
        this.prepare(cfg, cfg.getInterceptor(), false);
        this.prepare(cfg, cfg.getTopologyValidator(), false);
        NearCacheConfiguration nearCfg = cfg.getNearConfiguration();
        if (nearCfg != null) {
            this.prepare(cfg, nearCfg.getNearEvictionPolicy(), true);
        }
        for (Object obj : objs) {
            this.prepare(cfg, obj, false);
        }
    }

    private void prepare(CacheConfiguration cfg, @Nullable Object rsrc, boolean near) throws IgniteCheckedException {
        if (rsrc != null) {
            this.ctx.resource().injectGeneric(rsrc);
            this.ctx.resource().injectCacheName(rsrc, cfg.getName());
            this.registerMbean(rsrc, cfg.getName(), near);
        }
    }

    private void cleanup(GridCacheContext cctx) {
        NearCacheConfiguration nearCfg;
        CacheConfiguration cfg = cctx.config();
        this.cleanup(cfg, cfg.getEvictionPolicy(), false);
        this.cleanup(cfg, cfg.getAffinity(), false);
        this.cleanup(cfg, cfg.getAffinityMapper(), false);
        this.cleanup(cfg, cfg.getEvictionFilter(), false);
        this.cleanup(cfg, cfg.getInterceptor(), false);
        this.cleanup(cfg, cfg.getTopologyValidator(), false);
        this.cleanup(cfg, cctx.store().configuredStore(), false);
        if (!CU.isUtilityCache(cfg.getName()) && !CU.isSystemCache(cfg.getName())) {
            this.unregisterMbean(cctx.cache().localMxBean(), cfg.getName(), false);
            this.unregisterMbean(cctx.cache().clusterMxBean(), cfg.getName(), false);
        }
        if ((nearCfg = cfg.getNearConfiguration()) != null) {
            this.cleanup(cfg, nearCfg.getNearEvictionPolicy(), true);
        }
        cctx.cleanup();
    }

    private void cleanup(CacheConfiguration cfg, @Nullable Object rsrc, boolean near) {
        if (rsrc != null) {
            this.unregisterMbean(rsrc, cfg.getName(), near);
            try {
                this.ctx.resource().cleanupGeneric(rsrc);
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Failed to cleanup resource: " + rsrc, e);
            }
        }
    }

    @Override
    public void start() throws IgniteCheckedException {
        DeploymentMode depMode = this.ctx.config().getDeploymentMode();
        if (!F.isEmpty(this.ctx.config().getCacheConfiguration()) && depMode != DeploymentMode.CONTINUOUS && depMode != DeploymentMode.SHARED) {
            U.warn(this.log, "Deployment mode for cache is not CONTINUOUS or SHARED (it is recommended that you change deployment mode and restart): " + (Object)((Object)depMode), "Deployment mode for cache is not CONTINUOUS or SHARED.");
        }
        Set<String> internalCaches = this.internalCachesNames();
        CacheConfiguration[] cfgs = this.ctx.config().getCacheConfiguration();
        this.sharedCtx = this.createSharedContext(this.ctx, CU.startStoreSessionListeners(this.ctx, this.ctx.config().getCacheStoreSessionListenerFactories()));
        for (int i = 0; i < cfgs.length; ++i) {
            if (this.ctx.config().isDaemon() && !CU.isMarshallerCache(cfgs[i].getName())) continue;
            this.cloneCheckSerializable(cfgs[i]);
            CacheConfiguration cfg = new CacheConfiguration(cfgs[i]);
            CacheObjectContext cacheObjCtx = this.ctx.cacheObjects().contextForCache(cfg);
            this.initialize(cfg, cacheObjCtx);
            cfgs[i] = cfg;
            String masked = GridCacheProcessor.maskNull(cfg.getName());
            if (this.registeredCaches.containsKey(masked)) {
                String cacheName = cfg.getName();
                if (cacheName != null) {
                    throw new IgniteCheckedException("Duplicate cache name found (check configuration and assign unique name to each cache): " + U.maskName(cacheName));
                }
                throw new IgniteCheckedException("Default cache has already been configured (check configuration and assign unique name to each cache).");
            }
            CacheType cacheType = CU.isUtilityCache(cfg.getName()) ? CacheType.UTILITY : (CU.isMarshallerCache(cfg.getName()) ? CacheType.MARSHALLER : (internalCaches.contains(GridCacheProcessor.maskNull(cfg.getName())) ? CacheType.INTERNAL : CacheType.USER));
            boolean template = cfg.getName() != null && cfg.getName().endsWith("*");
            DynamicCacheDescriptor desc = new DynamicCacheDescriptor(this.ctx, cfg, cacheType, template, IgniteUuid.randomUuid());
            desc.locallyConfigured(true);
            desc.staticallyConfigured(true);
            desc.receivedFrom(this.ctx.localNodeId());
            if (!template) {
                this.registeredCaches.put(masked, desc);
                this.ctx.discovery().setCacheFilter(cfg.getName(), cfg.getNodeFilter(), cfg.getNearConfiguration() != null && cfg.getCacheMode() == CacheMode.PARTITIONED, cfg.getCacheMode());
                this.ctx.discovery().addClientNode(cfg.getName(), this.ctx.localNodeId(), cfg.getNearConfiguration() != null);
                if (!cacheType.userCache()) {
                    this.stopSeq.addLast(cfg.getName());
                } else {
                    this.stopSeq.addFirst(cfg.getName());
                }
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Use cache configuration as template: " + cfg);
                }
                this.registeredTemplates.put(masked, desc);
            }
            if (cfg.getName() != null) continue;
            DynamicCacheDescriptor desc0 = new DynamicCacheDescriptor(this.ctx, cfg, cacheType, true, IgniteUuid.randomUuid());
            desc0.locallyConfigured(true);
            desc0.staticallyConfigured(true);
            this.registeredTemplates.put(masked, desc0);
        }
        for (GridCacheSharedManager<?, ?> mgr : this.sharedCtx.managers()) {
            mgr.start(this.sharedCtx);
        }
        this.transactions = new IgniteTransactionsImpl(this.sharedCtx);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Started cache processor.");
        }
    }

    private Set<String> internalCachesNames() {
        HashSet<String> internalCaches = new HashSet<String>();
        FileSystemConfiguration[] igfsCfgs = this.ctx.grid().configuration().getFileSystemConfiguration();
        if (igfsCfgs != null) {
            for (FileSystemConfiguration igfsCfg : igfsCfgs) {
                internalCaches.add(GridCacheProcessor.maskNull(igfsCfg.getMetaCacheName()));
                internalCaches.add(GridCacheProcessor.maskNull(igfsCfg.getDataCacheName()));
            }
        }
        if (IgniteComponentType.HADOOP.inClassPath()) {
            internalCaches.add("ignite-hadoop-mr-sys-cache");
        }
        internalCaches.add("ignite-atomics-sys-cache");
        return internalCaches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onKernalStart() throws IgniteCheckedException {
        IgnitePredicate<ClusterNode> filter;
        ClusterNode locNode = this.ctx.discovery().localNode();
        try {
            if (!this.ctx.config().isDaemon() && !IgniteSystemProperties.getBoolean("IGNITE_SKIP_CONFIGURATION_CONSISTENCY_CHECK")) {
                for (ClusterNode clusterNode : this.ctx.discovery().remoteNodes()) {
                    if (((Boolean)clusterNode.attribute("org.apache.ignite.consistency.check.skipped")).booleanValue()) continue;
                    this.checkTransactionConfiguration(clusterNode);
                    DeploymentMode locDepMode = this.ctx.config().getDeploymentMode();
                    DeploymentMode rmtDepMode = (DeploymentMode)((Object)clusterNode.attribute("org.apache.ignite.ignite.dep.mode"));
                    CU.checkAttributeMismatch(this.log, null, clusterNode.id(), "deploymentMode", "Deployment mode", (Object)locDepMode, (Object)rmtDepMode, true);
                    for (DynamicCacheDescriptor desc : this.registeredCaches.values()) {
                        CacheConfiguration rmtCfg = desc.remoteConfiguration(clusterNode.id());
                        if (rmtCfg == null) continue;
                        CacheConfiguration locCfg = desc.cacheConfiguration();
                        this.checkCache(locCfg, rmtCfg, clusterNode);
                        CachePluginManager pluginMgr = desc.pluginManager();
                        pluginMgr.validateRemotes(rmtCfg, clusterNode);
                    }
                }
            }
            for (DynamicCacheDescriptor dynamicCacheDescriptor : this.registeredCaches.values()) {
                if (this.ctx.config().isDaemon() && !CU.isMarshallerCache(dynamicCacheDescriptor.cacheConfiguration().getName())) continue;
                dynamicCacheDescriptor.clearRemoteConfigurations();
                CacheConfiguration ccfg = dynamicCacheDescriptor.cacheConfiguration();
                filter = ccfg.getNodeFilter();
                boolean loc = dynamicCacheDescriptor.locallyConfigured();
                if (!loc && (!dynamicCacheDescriptor.receivedOnDiscovery() || !CU.affinityNode(locNode, filter))) continue;
                boolean started = dynamicCacheDescriptor.onStart();
                assert (started) : "Failed to change started flag for locally configured cache: " + dynamicCacheDescriptor;
                CacheObjectContext cacheObjCtx = this.ctx.cacheObjects().contextForCache(ccfg);
                CachePluginManager pluginMgr = dynamicCacheDescriptor.pluginManager();
                GridCacheContext ctx = this.createCache(ccfg, pluginMgr, dynamicCacheDescriptor.cacheType(), cacheObjCtx, dynamicCacheDescriptor.updatesAllowed());
                ctx.dynamicDeploymentId(dynamicCacheDescriptor.deploymentId());
                this.sharedCtx.addCacheContext(ctx);
                GridCacheAdapter cache = ctx.cache();
                String name = ccfg.getName();
                this.caches.put(GridCacheProcessor.maskNull(name), cache);
                this.startCache(cache);
                this.jCacheProxies.put(GridCacheProcessor.maskNull(name), new IgniteCacheProxy(ctx, cache, null, false));
            }
        }
        finally {
            this.cacheStartedLatch.countDown();
        }
        for (GridCacheSharedManager gridCacheSharedManager : this.sharedCtx.managers()) {
            gridCacheSharedManager.onKernalStart(false);
        }
        for (GridCacheAdapter gridCacheAdapter : this.caches.values()) {
            this.onKernalStart(gridCacheAdapter);
        }
        this.ctx.marshallerContext().onMarshallerCacheStarted(this.ctx);
        if (!this.ctx.config().isDaemon()) {
            this.ctx.cacheObjects().onUtilityCacheStarted();
        }
        this.ctx.service().onUtilityCacheStarted();
        for (DynamicCacheDescriptor dynamicCacheDescriptor : this.registeredCaches.values()) {
            CacheMode cacheMode;
            GridCacheAdapter<?, ?> cache;
            CacheConfiguration cfg = dynamicCacheDescriptor.cacheConfiguration();
            filter = cfg.getNodeFilter();
            if (!dynamicCacheDescriptor.locallyConfigured() && (!dynamicCacheDescriptor.receivedOnDiscovery() || !CU.affinityNode(locNode, filter)) || (cache = this.caches.get(GridCacheProcessor.maskNull(cfg.getName()))) == null || cfg.getRebalanceMode() != CacheRebalanceMode.SYNC || (cacheMode = cfg.getCacheMode()) != CacheMode.REPLICATED && (cacheMode != CacheMode.PARTITIONED || cfg.getRebalanceDelay() < 0L)) continue;
            cache.preloader().syncFuture().get();
        }
        assert (this.caches.containsKey("ignite-marshaller-sys-cache")) : "Marshaller cache should be started";
        assert (this.ctx.config().isDaemon() || this.caches.containsKey("ignite-sys-cache")) : "Utility cache should be started";
        if (!this.ctx.clientNode() && !this.ctx.isDaemon()) {
            this.addRemovedItemsCleanupTask(Long.getLong("IGNITE_CACHE_REMOVED_ENTRIES_TTL", 10000L));
        }
    }

    private void addRemovedItemsCleanupTask(long timeout) {
        this.ctx.timeout().addTimeoutObject(new RemovedItemsCleanupTask(timeout));
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        for (String cacheName : this.stopSeq) {
            GridCacheAdapter cache = this.stoppedCaches.remove(GridCacheProcessor.maskNull(cacheName));
            if (cache == null) continue;
            this.stopCache(cache, cancel);
        }
        for (GridCacheAdapter cache : this.stoppedCaches.values()) {
            if (cache != this.stoppedCaches.remove(GridCacheProcessor.maskNull(cache.name()))) continue;
            this.stopCache(cache, cancel);
        }
        List<GridCacheSharedManager<?, ?>> mgrs = this.sharedCtx.managers();
        ListIterator<GridCacheSharedManager<?, ?>> it = mgrs.listIterator(mgrs.size());
        while (it.hasPrevious()) {
            GridCacheSharedManager<?, ?> mgr = it.previous();
            mgr.stop(cancel);
        }
        CU.stopStoreSessionListeners(this.ctx, this.sharedCtx.storeSessionListeners());
        this.sharedCtx.cleanup();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Stopped cache processor.");
        }
    }

    public void blockGateways() {
        for (IgniteCacheProxy<?, ?> proxy : this.jCacheProxies.values()) {
            proxy.gate().onStopped();
        }
    }

    @Override
    public void onKernalStop(boolean cancel) {
        GridCacheAdapter cache;
        this.cacheStartedLatch.countDown();
        GridCachePartitionExchangeManager exch = this.context().exchange();
        exch.onKernalStop(cancel);
        for (GridCacheAdapter<?, ?> gridCacheAdapter : this.caches.values()) {
            GridCacheAffinityManager aff = gridCacheAdapter.context().affinity();
            if (aff == null) continue;
            aff.cancelFutures();
        }
        for (String string : this.stopSeq) {
            cache = this.caches.remove(GridCacheProcessor.maskNull(string));
            if (cache == null) continue;
            this.stoppedCaches.put(GridCacheProcessor.maskNull(string), cache);
            this.onKernalStop(cache, cancel);
        }
        for (Map.Entry entry : this.caches.entrySet()) {
            cache = (GridCacheAdapter)entry.getValue();
            if (cache != this.caches.remove(entry.getKey())) continue;
            this.stoppedCaches.put((String)entry.getKey(), cache);
            this.onKernalStop((GridCacheAdapter)entry.getValue(), cancel);
        }
        this.cancelFutures();
        List<GridCacheSharedManager<?, ?>> sharedMgrs = this.sharedCtx.managers();
        ListIterator<GridCacheSharedManager<?, ?>> listIterator = sharedMgrs.listIterator(sharedMgrs.size());
        while (listIterator.hasPrevious()) {
            GridCacheSharedManager<?, ?> mgr = listIterator.previous();
            if (mgr == exch) continue;
            mgr.onKernalStop(cancel);
        }
    }

    @Override
    public void onDisconnected(IgniteFuture<?> reconnectFut) throws IgniteCheckedException {
        this.cachesOnDisconnect = new HashMap<String, DynamicCacheDescriptor>(this.registeredCaches);
        IgniteClientDisconnectedCheckedException err = new IgniteClientDisconnectedCheckedException(this.ctx.cluster().clientReconnectFuture(), "Failed to execute dynamic cache change request, client node disconnected.");
        for (IgniteInternalFuture igniteInternalFuture : this.pendingFuts.values()) {
            ((GridFutureAdapter)igniteInternalFuture).onDone(err);
        }
        for (IgniteInternalFuture igniteInternalFuture : this.pendingTemplateFuts.values()) {
            ((GridFutureAdapter)igniteInternalFuture).onDone(err);
        }
        for (GridCacheAdapter gridCacheAdapter : this.caches.values()) {
            GridCacheContext cctx = gridCacheAdapter.context();
            cctx.gate().onDisconnected(reconnectFut);
            List mgrs = gridCacheAdapter.context().managers();
            ListIterator it = mgrs.listIterator(mgrs.size());
            while (it.hasPrevious()) {
                GridCacheManager mgr = it.previous();
                mgr.onDisconnected(reconnectFut);
            }
        }
        this.sharedCtx.onDisconnected(reconnectFut);
        this.registeredCaches.clear();
        this.registeredTemplates.clear();
    }

    @Override
    public IgniteInternalFuture<?> onReconnected(boolean clusterRestarted) throws IgniteCheckedException {
        ArrayList reconnected = new ArrayList(this.caches.size());
        GridCompoundFuture stopFut = null;
        for (final GridCacheAdapter<?, ?> gridCacheAdapter : this.caches.values()) {
            boolean stopped;
            boolean sysCache;
            String name = gridCacheAdapter.name();
            boolean bl = sysCache = CU.isMarshallerCache(name) || CU.isUtilityCache(name) || CU.isAtomicsCache(name);
            if (!sysCache) {
                DynamicCacheDescriptor oldDesc = this.cachesOnDisconnect.get(GridCacheProcessor.maskNull(name));
                assert (oldDesc != null) : "No descriptor for cache: " + name;
                DynamicCacheDescriptor newDesc = (DynamicCacheDescriptor)this.registeredCaches.get(GridCacheProcessor.maskNull(name));
                stopped = newDesc == null || !oldDesc.deploymentId().equals(newDesc.deploymentId());
            } else {
                stopped = false;
            }
            if (stopped) {
                gridCacheAdapter.context().gate().reconnected(true);
                this.sharedCtx.removeCacheContext(gridCacheAdapter.ctx);
                this.caches.remove(GridCacheProcessor.maskNull(gridCacheAdapter.name()));
                this.jCacheProxies.remove(GridCacheProcessor.maskNull(gridCacheAdapter.name()));
                IgniteInternalFuture<?> fut = this.ctx.closure().runLocalSafe(new Runnable(){

                    @Override
                    public void run() {
                        GridCacheProcessor.this.onKernalStop(gridCacheAdapter, true);
                        GridCacheProcessor.this.stopCache(gridCacheAdapter, true);
                    }
                });
                if (stopFut == null) {
                    stopFut = new GridCompoundFuture();
                }
                stopFut.add(fut);
                continue;
            }
            gridCacheAdapter.onReconnected();
            reconnected.add(gridCacheAdapter);
        }
        if (this.clientReconnectReqs != null) {
            for (Map.Entry entry : this.clientReconnectReqs.entrySet()) {
                this.processClientReconnectData((UUID)entry.getKey(), (DynamicCacheChangeBatch)entry.getValue());
            }
            this.clientReconnectReqs = null;
        }
        this.sharedCtx.onReconnected();
        for (GridCacheAdapter gridCacheAdapter : reconnected) {
            gridCacheAdapter.context().gate().reconnected(false);
        }
        this.cachesOnDisconnect = null;
        if (stopFut != null) {
            stopFut.markInitialized();
        }
        return stopFut;
    }

    private void startCache(GridCacheAdapter<?, ?> cache) throws IgniteCheckedException {
        GridCacheContext<?, ?> cacheCtx = cache.context();
        this.ctx.query().onCacheStart(cacheCtx);
        this.ctx.continuous().onCacheStart(cacheCtx);
        CacheConfiguration cfg = cacheCtx.config();
        if (cfg.isStoreKeepBinary().booleanValue() && cfg.isStoreKeepBinary() != CacheConfiguration.DFLT_STORE_KEEP_BINARY && !(this.ctx.config().getMarshaller() instanceof BinaryMarshaller)) {
            U.warn(this.log, "CacheConfiguration.isStoreKeepBinary() configuration property will be ignored because BinaryMarshaller is not used");
        }
        for (GridCacheManager<?, ?> mgr : F.view(cacheCtx.managers(), F.notContains(this.dhtExcludes(cacheCtx)))) {
            mgr.start(cacheCtx);
        }
        cacheCtx.initConflictResolver();
        if (cfg.getCacheMode() != CacheMode.LOCAL && GridCacheUtils.isNearEnabled(cfg)) {
            GridCacheContext dhtCtx = cacheCtx.near().dht().context();
            for (GridCacheManager mgr : this.dhtManagers(dhtCtx)) {
                mgr.start(dhtCtx);
            }
            dhtCtx.initConflictResolver();
            dhtCtx.cache().start();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Started DHT cache: " + dhtCtx.cache().name());
            }
        }
        cacheCtx.cache().start();
        cacheCtx.onStarted();
        if (this.log.isInfoEnabled()) {
            this.log.info("Started cache [name=" + U.maskName(cfg.getName()) + ", mode=" + (Object)((Object)cfg.getCacheMode()) + ']');
        }
    }

    private void stopCache(GridCacheAdapter<?, ?> cache, boolean cancel) {
        GridDhtCacheAdapter<?, ?> dht;
        GridCacheContext<?, ?> ctx = cache.context();
        this.sharedCtx.removeCacheContext(ctx);
        cache.stop();
        if (GridCacheUtils.isNearEnabled(ctx) && (dht = ctx.near().dht()) != null) {
            dht.stop();
            GridCacheContext dhtCtx = dht.context();
            List<GridCacheManager> dhtMgrs = this.dhtManagers(dhtCtx);
            ListIterator<GridCacheManager> it = dhtMgrs.listIterator(dhtMgrs.size());
            while (it.hasPrevious()) {
                GridCacheManager mgr = it.previous();
                mgr.stop(cancel);
            }
        }
        List<GridCacheManager<?, ?>> mgrs = ctx.managers();
        Collection<GridCacheManager> excludes = this.dhtExcludes(ctx);
        ListIterator<GridCacheManager<?, ?>> it = mgrs.listIterator(mgrs.size());
        while (it.hasPrevious()) {
            GridCacheManager<?, ?> mgr = it.previous();
            if (excludes.contains(mgr)) continue;
            mgr.stop(cancel);
        }
        ctx.kernalContext().query().onCacheStop(ctx);
        ctx.kernalContext().continuous().onCacheStop(ctx);
        U.stopLifecycleAware(this.log, this.lifecycleAwares(cache.configuration(), ctx.store().configuredStore()));
        if (this.log.isInfoEnabled()) {
            this.log.info("Stopped cache: " + cache.name());
        }
        this.cleanup(ctx);
    }

    public void awaitStarted() throws IgniteCheckedException {
        U.await(this.cacheStartedLatch);
    }

    private void onKernalStart(GridCacheAdapter<?, ?> cache) throws IgniteCheckedException {
        GridCacheContext<?, ?> ctx = cache.context();
        if (GridCacheUtils.isNearEnabled(ctx)) {
            GridDhtCacheAdapter<?, ?> dht = ctx.near().dht();
            GridCacheContext dhtCtx = dht.context();
            for (GridCacheManager mgr : this.dhtManagers(dhtCtx)) {
                mgr.onKernalStart();
            }
            dht.onKernalStart();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Executed onKernalStart() callback for DHT cache: " + dht.name());
            }
        }
        for (GridCacheManager<?, ?> mgr : F.view(ctx.managers(), F0.notContains(this.dhtExcludes(ctx)))) {
            mgr.onKernalStart();
        }
        cache.onKernalStart();
        if (ctx.events().isRecordable(98)) {
            ctx.events().addEvent(98);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Executed onKernalStart() callback for cache [name=" + cache.name() + ", mode=" + (Object)((Object)cache.configuration().getCacheMode()) + ']');
        }
    }

    private void onKernalStop(GridCacheAdapter<?, ?> cache, boolean cancel) {
        GridDhtCacheAdapter<?, ?> dht;
        GridCacheContext<?, ?> ctx = cache.context();
        if (GridCacheUtils.isNearEnabled(ctx) && (dht = ctx.near().dht()) != null) {
            GridCacheContext dhtCtx = dht.context();
            for (GridCacheManager mgr : this.dhtManagers(dhtCtx)) {
                mgr.onKernalStop(cancel);
            }
            dht.onKernalStop();
        }
        List<GridCacheManager<?, ?>> mgrs = ctx.managers();
        Collection<GridCacheManager> excludes = this.dhtExcludes(ctx);
        ListIterator<GridCacheManager<?, ?>> it = mgrs.listIterator(mgrs.size());
        while (it.hasPrevious()) {
            GridCacheManager mgr;
            mgr = it.previous();
            if (excludes.contains(mgr)) continue;
            mgr.onKernalStop(cancel);
        }
        cache.onKernalStop();
        if (ctx.events().isRecordable(99)) {
            ctx.events().addEvent(99);
        }
    }

    private GridCacheContext createCache(CacheConfiguration<?, ?> cfg, @Nullable CachePluginManager pluginMgr, CacheType cacheType, CacheObjectContext cacheObjCtx, boolean updatesAllowed) throws IgniteCheckedException {
        assert (cfg != null);
        if (cfg.getCacheStoreFactory() instanceof GridCacheLoaderWriterStoreFactory) {
            GridCacheLoaderWriterStoreFactory factory = (GridCacheLoaderWriterStoreFactory)cfg.getCacheStoreFactory();
            this.prepare(cfg, factory.loaderFactory(), false);
            this.prepare(cfg, factory.writerFactory(), false);
        } else {
            this.prepare(cfg, cfg.getCacheStoreFactory(), false);
        }
        CacheStore<?, ?> cfgStore = cfg.getCacheStoreFactory() != null ? cfg.getCacheStoreFactory().create() : null;
        this.validate(this.ctx.config(), cfg, cacheType, cfgStore);
        if (pluginMgr == null) {
            pluginMgr = new CachePluginManager(this.ctx, cfg);
        }
        pluginMgr.validate();
        this.sharedCtx.jta().registerCache(cfg);
        if (cacheType.userCache()) {
            this.suggestOptimizations(cfg, cfgStore != null);
        }
        ArrayList<Object> toPrepare = new ArrayList<Object>();
        if (cfgStore instanceof GridCacheLoaderWriterStore) {
            toPrepare.add(((GridCacheLoaderWriterStore)cfgStore).loader());
            toPrepare.add(((GridCacheLoaderWriterStore)cfgStore).writer());
        } else {
            toPrepare.add(cfgStore);
        }
        this.prepare(cfg, toPrepare);
        U.startLifecycleAware(this.lifecycleAwares(cfg, cfgStore));
        boolean affNode = CU.affinityNode(this.ctx.discovery().localNode(), cfg.getNodeFilter());
        GridCacheAffinityManager affMgr = new GridCacheAffinityManager();
        GridCacheEventManager evtMgr = new GridCacheEventManager();
        GridCacheSwapManager swapMgr = new GridCacheSwapManager(affNode && (cfg.getCacheMode() == CacheMode.LOCAL || !GridCacheUtils.isNearEnabled(cfg)));
        GridCacheEvictionManager evictMgr = new GridCacheEvictionManager();
        GridCacheQueryManager qryMgr = this.queryManager(cfg);
        CacheContinuousQueryManager contQryMgr = new CacheContinuousQueryManager();
        CacheDataStructuresManager dataStructuresMgr = new CacheDataStructuresManager();
        GridCacheTtlManager ttlMgr = new GridCacheTtlManager();
        CacheConflictResolutionManager rslvrMgr = pluginMgr.createComponent(CacheConflictResolutionManager.class);
        GridCacheDrManager drMgr = pluginMgr.createComponent(GridCacheDrManager.class);
        CacheStoreManager storeMgr = pluginMgr.createComponent(CacheStoreManager.class);
        storeMgr.initialize(cfgStore, this.sesHolders);
        GridCacheContext cacheCtx = new GridCacheContext(this.ctx, this.sharedCtx, cfg, cacheType, affNode, updatesAllowed, evtMgr, swapMgr, storeMgr, evictMgr, qryMgr, contQryMgr, dataStructuresMgr, ttlMgr, drMgr, rslvrMgr, pluginMgr, affMgr);
        cacheCtx.cacheObjectContext(cacheObjCtx);
        GridCacheAdapter cache = null;
        block0 : switch (cfg.getCacheMode()) {
            case LOCAL: {
                switch (cfg.getAtomicityMode()) {
                    case TRANSACTIONAL: {
                        cache = new GridLocalCache(cacheCtx);
                        break block0;
                    }
                    case ATOMIC: {
                        cache = new GridLocalAtomicCache(cacheCtx);
                        break block0;
                    }
                }
                assert (false) : "Invalid cache atomicity mode: " + (Object)((Object)cfg.getAtomicityMode());
                break;
            }
            case PARTITIONED: 
            case REPLICATED: {
                if (GridCacheUtils.isNearEnabled(cfg)) {
                    switch (cfg.getAtomicityMode()) {
                        case TRANSACTIONAL: {
                            cache = new GridNearTransactionalCache(cacheCtx);
                            break block0;
                        }
                        case ATOMIC: {
                            cache = new GridNearAtomicCache(cacheCtx);
                            break block0;
                        }
                    }
                    assert (false) : "Invalid cache atomicity mode: " + (Object)((Object)cfg.getAtomicityMode());
                    break;
                }
                switch (cfg.getAtomicityMode()) {
                    case TRANSACTIONAL: {
                        cache = cacheCtx.affinityNode() ? new GridDhtColocatedCache(cacheCtx) : new GridDhtColocatedCache(cacheCtx, new GridNoStorageCacheMap(cacheCtx));
                        break block0;
                    }
                    case ATOMIC: {
                        cache = cacheCtx.affinityNode() ? new GridDhtAtomicCache(cacheCtx) : new GridDhtAtomicCache(cacheCtx, new GridNoStorageCacheMap(cacheCtx));
                        break block0;
                    }
                }
                assert (false) : "Invalid cache atomicity mode: " + (Object)((Object)cfg.getAtomicityMode());
                break;
            }
            default: {
                assert (false) : "Invalid cache mode: " + (Object)((Object)cfg.getCacheMode());
                break;
            }
        }
        cacheCtx.cache(cache);
        GridCacheContext ret = cacheCtx;
        if (cfg.getCacheMode() != CacheMode.LOCAL && GridCacheUtils.isNearEnabled(cfg)) {
            swapMgr = new GridCacheSwapManager(affNode);
            evictMgr = new GridCacheEvictionManager();
            evtMgr = new GridCacheEventManager();
            pluginMgr = new CachePluginManager(this.ctx, cfg);
            drMgr = pluginMgr.createComponent(GridCacheDrManager.class);
            cacheCtx = new GridCacheContext(this.ctx, this.sharedCtx, cfg, cacheType, affNode, true, evtMgr, swapMgr, storeMgr, evictMgr, qryMgr, contQryMgr, dataStructuresMgr, ttlMgr, drMgr, rslvrMgr, pluginMgr, affMgr);
            cacheCtx.cacheObjectContext(cacheObjCtx);
            GridDhtCacheAdapter dht = null;
            switch (cfg.getAtomicityMode()) {
                case TRANSACTIONAL: {
                    assert (cache instanceof GridNearTransactionalCache);
                    GridNearTransactionalCache near = (GridNearTransactionalCache)cache;
                    GridDhtCache dhtCache = cacheCtx.affinityNode() ? new GridDhtCache(cacheCtx) : new GridDhtCache(cacheCtx, new GridNoStorageCacheMap(cacheCtx));
                    dhtCache.near(near);
                    near.dht(dhtCache);
                    dht = dhtCache;
                    break;
                }
                case ATOMIC: {
                    assert (cache instanceof GridNearAtomicCache);
                    GridNearAtomicCache near = (GridNearAtomicCache)cache;
                    GridDhtAtomicCache dhtCache = cacheCtx.affinityNode() ? new GridDhtAtomicCache(cacheCtx) : new GridDhtAtomicCache(cacheCtx, new GridNoStorageCacheMap(cacheCtx));
                    dhtCache.near(near);
                    near.dht(dhtCache);
                    dht = dhtCache;
                    break;
                }
                default: {
                    assert (false) : "Invalid cache atomicity mode: " + (Object)((Object)cfg.getAtomicityMode());
                    break;
                }
            }
            cacheCtx.cache(dht);
        }
        if (!CU.isUtilityCache(cache.name()) && !CU.isSystemCache(cache.name())) {
            this.registerMbean(cache.localMxBean(), cache.name(), false);
            this.registerMbean(cache.clusterMxBean(), cache.name(), false);
        }
        return ret;
    }

    public Collection<String> cacheNames() {
        return F.viewReadOnly(this.registeredCaches.values(), new IgniteClosure<DynamicCacheDescriptor, String>(){

            @Override
            public String apply(DynamicCacheDescriptor desc) {
                return desc.cacheConfiguration().getName();
            }
        }, new IgnitePredicate<DynamicCacheDescriptor>(){

            @Override
            public boolean apply(DynamicCacheDescriptor desc) {
                return desc.started();
            }
        });
    }

    public IgniteCacheProxy<?, ?> getOrStartPublicCache(boolean start, boolean inclLoc) throws IgniteCheckedException {
        for (Map.Entry<String, GridCacheAdapter<?, ?>> entry : this.caches.entrySet()) {
            CacheConfiguration ccfg = entry.getValue().configuration();
            String cacheName = ccfg.getName();
            if (!inclLoc && ccfg.getCacheMode() == CacheMode.LOCAL || !GridQueryProcessor.isEnabled(ccfg)) continue;
            return this.publicJCache(cacheName);
        }
        if (start) {
            for (Map.Entry<String, GridCacheAdapter<Object, Object>> entry : this.registeredCaches.entrySet()) {
                DynamicCacheDescriptor desc = (DynamicCacheDescriptor)((Object)entry.getValue());
                CacheConfiguration ccfg = desc.cacheConfiguration();
                if (ccfg.getCacheMode() == CacheMode.LOCAL || !GridQueryProcessor.isEnabled(ccfg)) continue;
                this.dynamicStartCache(null, ccfg.getName(), null, false, true, true).get();
                return this.publicJCache(ccfg.getName());
            }
        }
        return null;
    }

    public Collection<String> publicCacheNames() {
        return F.viewReadOnly(this.registeredCaches.values(), new IgniteClosure<DynamicCacheDescriptor, String>(){

            @Override
            public String apply(DynamicCacheDescriptor desc) {
                return desc.cacheConfiguration().getName();
            }
        }, new IgnitePredicate<DynamicCacheDescriptor>(){

            @Override
            public boolean apply(DynamicCacheDescriptor desc) {
                return desc.cacheType().userCache();
            }
        });
    }

    public CacheMode cacheMode(String cacheName) {
        DynamicCacheDescriptor desc = (DynamicCacheDescriptor)this.registeredCaches.get(GridCacheProcessor.maskNull(cacheName));
        return desc != null ? desc.cacheConfiguration().getCacheMode() : null;
    }

    public void prepareCacheStart(DynamicCacheChangeRequest req, AffinityTopologyVersion topVer) throws IgniteCheckedException {
        assert (req.start()) : req;
        assert (req.cacheType() != null) : req;
        this.prepareCacheStart(req.startCacheConfiguration(), req.nearCacheConfiguration(), req.cacheType(), req.clientStartOnly(), req.initiatingNodeId(), req.deploymentId(), topVer);
        DynamicCacheDescriptor desc = (DynamicCacheDescriptor)this.registeredCaches.get(GridCacheProcessor.maskNull(req.cacheName()));
        if (desc != null) {
            desc.onStart();
        }
    }

    public Collection<DynamicCacheDescriptor> startReceivedCaches(AffinityTopologyVersion topVer) throws IgniteCheckedException {
        ArrayList<DynamicCacheDescriptor> started = null;
        for (DynamicCacheDescriptor desc : this.registeredCaches.values()) {
            AffinityTopologyVersion startVer;
            if (desc.started() || !desc.staticallyConfigured() || desc.locallyConfigured() || desc.receivedFrom() != null && ((startVer = desc.receivedFromStartVersion()) == null || startVer.compareTo(topVer) > 0) || !desc.onStart()) continue;
            if (started == null) {
                started = new ArrayList<DynamicCacheDescriptor>();
            }
            started.add(desc);
            this.prepareCacheStart(desc.cacheConfiguration(), null, desc.cacheType(), false, null, desc.deploymentId(), topVer);
        }
        return started;
    }

    private void prepareCacheStart(CacheConfiguration cfg, NearCacheConfiguration nearCfg, CacheType cacheType, boolean clientStartOnly, UUID initiatingNodeId, IgniteUuid deploymentId, AffinityTopologyVersion topVer) throws IgniteCheckedException {
        CacheConfiguration ccfg = new CacheConfiguration(cfg);
        IgnitePredicate<ClusterNode> nodeFilter = ccfg.getNodeFilter();
        ClusterNode locNode = this.ctx.discovery().localNode();
        boolean affNodeStart = !clientStartOnly && CU.affinityNode(locNode, nodeFilter);
        boolean clientNodeStart = locNode.id().equals(initiatingNodeId);
        if (this.sharedCtx.cacheContext(CU.cacheId(cfg.getName())) != null) {
            return;
        }
        if (affNodeStart || clientNodeStart) {
            if (clientNodeStart && !affNodeStart) {
                if (nearCfg != null) {
                    ccfg.setNearConfiguration(nearCfg);
                } else {
                    ccfg.setNearConfiguration(null);
                }
            }
            CacheObjectContext cacheObjCtx = this.ctx.cacheObjects().contextForCache(ccfg);
            GridCacheContext cacheCtx = this.createCache(ccfg, null, cacheType, cacheObjCtx, true);
            cacheCtx.startTopologyVersion(topVer);
            cacheCtx.dynamicDeploymentId(deploymentId);
            this.sharedCtx.addCacheContext(cacheCtx);
            this.caches.put(GridCacheProcessor.maskNull(cacheCtx.name()), cacheCtx.cache());
            this.startCache(cacheCtx.cache());
            this.onKernalStart(cacheCtx.cache());
        }
    }

    public void blockGateway(DynamicCacheChangeRequest req) {
        IgniteCacheProxy<?, ?> proxy;
        assert (req.stop() || req.close());
        if ((req.stop() || req.close() && req.initiatingNodeId().equals(this.ctx.localNodeId())) && (proxy = this.jCacheProxies.get(GridCacheProcessor.maskNull(req.cacheName()))) != null) {
            if (req.stop()) {
                proxy.gate().stopped();
            } else {
                proxy.closeProxy();
            }
        }
    }

    private void stopGateway(DynamicCacheChangeRequest req) {
        assert (req.stop()) : req;
        IgniteCacheProxy<?, ?> proxy = this.jCacheProxies.remove(GridCacheProcessor.maskNull(req.cacheName()));
        if (proxy != null) {
            proxy.gate().onStopped();
        }
    }

    private void prepareCacheStop(DynamicCacheChangeRequest req) {
        assert (req.stop() || req.close()) : req;
        GridCacheAdapter<?, ?> cache = this.caches.remove(GridCacheProcessor.maskNull(req.cacheName()));
        if (cache != null) {
            GridCacheContext<?, ?> ctx = cache.context();
            this.sharedCtx.removeCacheContext(ctx);
            assert (req.deploymentId().equals(ctx.dynamicDeploymentId())) : "Different deployment IDs [req=" + req + ", ctxDepId=" + ctx.dynamicDeploymentId() + ']';
            this.onKernalStop(cache, true);
            this.stopCache(cache, true);
        }
    }

    public void onExchangeDone(AffinityTopologyVersion topVer, Collection<DynamicCacheChangeRequest> reqs, Throwable err) {
        for (GridCacheAdapter<?, ?> cache : this.caches.values()) {
            GridCacheContext<?, ?> cacheCtx = cache.context();
            if (!F.eq(cacheCtx.startTopologyVersion(), topVer)) continue;
            if (cacheCtx.preloader() != null) {
                cacheCtx.preloader().onInitialExchangeComplete(err);
            }
            String masked = GridCacheProcessor.maskNull(cacheCtx.name());
            this.jCacheProxies.put(masked, new IgniteCacheProxy(cache.context(), cache, null, false));
        }
        if (!F.isEmpty(reqs) && err == null) {
            for (DynamicCacheChangeRequest req : reqs) {
                IgniteCacheProxy<?, ?> proxy;
                String masked = GridCacheProcessor.maskNull(req.cacheName());
                if (req.stop()) {
                    this.stopGateway(req);
                    this.prepareCacheStop(req);
                } else if (req.close() && req.initiatingNodeId().equals(this.ctx.localNodeId()) && (proxy = this.jCacheProxies.remove(masked)) != null) {
                    if (proxy.context().affinityNode()) {
                        GridCacheAdapter<?, ?> cache = this.caches.get(masked);
                        if (cache != null) {
                            this.jCacheProxies.put(masked, new IgniteCacheProxy(cache.context(), cache, null, false));
                        }
                    } else {
                        proxy.context().gate().onStopped();
                        this.prepareCacheStop(req);
                    }
                }
                this.completeStartFuture(req);
            }
        }
    }

    public void completeStartFuture(DynamicCacheChangeRequest req) {
        DynamicCacheStartFuture fut = (DynamicCacheStartFuture)this.pendingFuts.get(GridCacheProcessor.maskNull(req.cacheName()));
        assert (req.deploymentId() != null);
        assert (fut == null || fut.deploymentId != null);
        if (fut != null && fut.deploymentId().equals(req.deploymentId()) && F.eq(req.initiatingNodeId(), this.ctx.localNodeId())) {
            fut.onDone();
        }
    }

    private GridCacheSharedContext createSharedContext(GridKernalContext kernalCtx, Collection<CacheStoreSessionListener> storeSesLsnrs) throws IgniteCheckedException {
        IgniteTxManager tm = new IgniteTxManager();
        GridCacheMvccManager mvccMgr = new GridCacheMvccManager();
        GridCacheVersionManager verMgr = new GridCacheVersionManager();
        GridCacheDeploymentManager depMgr = new GridCacheDeploymentManager();
        GridCachePartitionExchangeManager exchMgr = new GridCachePartitionExchangeManager();
        GridCacheIoManager ioMgr = new GridCacheIoManager();
        CacheAffinitySharedManager topMgr = new CacheAffinitySharedManager();
        GridCacheSharedTtlCleanupManager ttl = new GridCacheSharedTtlCleanupManager();
        CacheJtaManagerAdapter jta = (CacheJtaManagerAdapter)IgniteComponentType.JTA.createOptional();
        return new GridCacheSharedContext(kernalCtx, tm, verMgr, mvccMgr, depMgr, exchMgr, topMgr, ioMgr, ttl, jta, storeSesLsnrs);
    }

    @Override
    @Nullable
    public GridComponent.DiscoveryDataExchangeType discoveryDataType() {
        return GridComponent.DiscoveryDataExchangeType.CACHE_PROC;
    }

    @Override
    @Nullable
    public Serializable collectDiscoveryData(UUID nodeId) {
        Map<String, Map<UUID, Boolean>> clientNodesMap;
        ArrayList<DynamicCacheChangeRequest> reqs;
        boolean reconnect;
        boolean bl = reconnect = this.ctx.localNodeId().equals(nodeId) && this.cachesOnDisconnect != null;
        if (reconnect) {
            reqs = new ArrayList<DynamicCacheChangeRequest>(this.caches.size());
            clientNodesMap = U.newHashMap(this.caches.size());
            for (GridCacheAdapter gridCacheAdapter : this.caches.values()) {
                DynamicCacheDescriptor desc = this.cachesOnDisconnect.get(GridCacheProcessor.maskNull(gridCacheAdapter.name()));
                if (desc == null) continue;
                DynamicCacheChangeRequest req = new DynamicCacheChangeRequest(gridCacheAdapter.name(), null);
                req.startCacheConfiguration(desc.cacheConfiguration());
                req.cacheType(desc.cacheType());
                req.deploymentId(desc.deploymentId());
                req.receivedFrom(desc.receivedFrom());
                reqs.add(req);
                Boolean nearEnabled = gridCacheAdapter.isNear();
                HashMap<UUID, Boolean> map = U.newHashMap(1);
                map.put(nodeId, nearEnabled);
                clientNodesMap.put(gridCacheAdapter.name(), map);
            }
        } else {
            DynamicCacheChangeRequest req;
            reqs = new ArrayList(this.registeredCaches.size() + this.registeredTemplates.size());
            for (DynamicCacheDescriptor dynamicCacheDescriptor : this.registeredCaches.values()) {
                req = new DynamicCacheChangeRequest(dynamicCacheDescriptor.cacheConfiguration().getName(), null);
                req.startCacheConfiguration(dynamicCacheDescriptor.cacheConfiguration());
                req.cacheType(dynamicCacheDescriptor.cacheType());
                req.deploymentId(dynamicCacheDescriptor.deploymentId());
                req.receivedFrom(dynamicCacheDescriptor.receivedFrom());
                reqs.add(req);
            }
            for (DynamicCacheDescriptor dynamicCacheDescriptor : this.registeredTemplates.values()) {
                req = new DynamicCacheChangeRequest(dynamicCacheDescriptor.cacheConfiguration().getName(), null);
                req.startCacheConfiguration(dynamicCacheDescriptor.cacheConfiguration());
                req.template(true);
                reqs.add(req);
            }
            clientNodesMap = this.ctx.discovery().clientNodesMap();
        }
        DynamicCacheChangeBatch batch = new DynamicCacheChangeBatch(reqs);
        batch.clientNodes(clientNodesMap);
        batch.clientReconnect(reconnect);
        batch.id(null);
        return batch;
    }

    @Override
    public void onDiscoveryDataReceived(UUID joiningNodeId, UUID rmtNodeId, Serializable data) {
        if (data instanceof DynamicCacheChangeBatch) {
            DynamicCacheChangeBatch batch = (DynamicCacheChangeBatch)data;
            if (batch.clientReconnect()) {
                if (this.ctx.clientDisconnected()) {
                    if (this.clientReconnectReqs == null) {
                        this.clientReconnectReqs = new LinkedHashMap<UUID, DynamicCacheChangeBatch>();
                    }
                    this.clientReconnectReqs.put(joiningNodeId, batch);
                    return;
                }
                this.processClientReconnectData(joiningNodeId, batch);
            } else {
                for (DynamicCacheChangeRequest dynamicCacheChangeRequest : batch.requests()) {
                    DynamicCacheDescriptor desc;
                    this.initReceivedCacheConfiguration(dynamicCacheChangeRequest);
                    if (dynamicCacheChangeRequest.template()) {
                        CacheConfiguration ccfg = dynamicCacheChangeRequest.startCacheConfiguration();
                        assert (ccfg != null) : dynamicCacheChangeRequest;
                        DynamicCacheDescriptor existing = (DynamicCacheDescriptor)this.registeredTemplates.get(GridCacheProcessor.maskNull(dynamicCacheChangeRequest.cacheName()));
                        if (existing != null) continue;
                        desc = new DynamicCacheDescriptor(this.ctx, ccfg, dynamicCacheChangeRequest.cacheType(), true, dynamicCacheChangeRequest.deploymentId());
                        this.registeredTemplates.put(GridCacheProcessor.maskNull(dynamicCacheChangeRequest.cacheName()), desc);
                        continue;
                    }
                    DynamicCacheDescriptor existing = (DynamicCacheDescriptor)this.registeredCaches.get(GridCacheProcessor.maskNull(dynamicCacheChangeRequest.cacheName()));
                    if (!dynamicCacheChangeRequest.start() || dynamicCacheChangeRequest.clientStartOnly()) continue;
                    CacheConfiguration ccfg = dynamicCacheChangeRequest.startCacheConfiguration();
                    if (existing != null) {
                        if (joiningNodeId.equals(this.ctx.localNodeId())) {
                            existing.receivedFrom(dynamicCacheChangeRequest.receivedFrom());
                            existing.deploymentId(dynamicCacheChangeRequest.deploymentId());
                        }
                        if (!existing.locallyConfigured()) continue;
                        existing.addRemoteConfiguration(rmtNodeId, dynamicCacheChangeRequest.startCacheConfiguration());
                        this.ctx.discovery().setCacheFilter(dynamicCacheChangeRequest.cacheName(), ccfg.getNodeFilter(), ccfg.getNearConfiguration() != null, ccfg.getCacheMode());
                        continue;
                    }
                    assert (dynamicCacheChangeRequest.cacheType() != null) : dynamicCacheChangeRequest;
                    desc = new DynamicCacheDescriptor(this.ctx, ccfg, dynamicCacheChangeRequest.cacheType(), false, dynamicCacheChangeRequest.deploymentId());
                    if (dynamicCacheChangeRequest.initiatingNodeId() == null) {
                        desc.staticallyConfigured(true);
                    }
                    if (joiningNodeId.equals(this.ctx.localNodeId())) {
                        desc.receivedOnDiscovery(true);
                    }
                    desc.receivedFrom(dynamicCacheChangeRequest.receivedFrom());
                    DynamicCacheDescriptor old = this.registeredCaches.put(GridCacheProcessor.maskNull(dynamicCacheChangeRequest.cacheName()), desc);
                    assert (old == null) : old;
                    this.ctx.discovery().setCacheFilter(dynamicCacheChangeRequest.cacheName(), ccfg.getNodeFilter(), ccfg.getNearConfiguration() != null, ccfg.getCacheMode());
                }
                if (!F.isEmpty(batch.clientNodes())) {
                    for (Map.Entry entry : batch.clientNodes().entrySet()) {
                        String cacheName = (String)entry.getKey();
                        for (Map.Entry tup : ((Map)entry.getValue()).entrySet()) {
                            this.ctx.discovery().addClientNode(cacheName, (UUID)tup.getKey(), (Boolean)tup.getValue());
                        }
                    }
                }
            }
        }
    }

    private void processClientReconnectData(UUID clientNodeId, DynamicCacheChangeBatch batch) {
        assert (batch.clientReconnect()) : batch;
        for (DynamicCacheChangeRequest req : batch.requests()) {
            boolean sysCache;
            assert (!req.template()) : req;
            this.initReceivedCacheConfiguration(req);
            String name = req.cacheName();
            boolean bl = sysCache = CU.isMarshallerCache(name) || CU.isUtilityCache(name) || CU.isAtomicsCache(name);
            if (!sysCache) {
                DynamicCacheDescriptor desc = (DynamicCacheDescriptor)this.registeredCaches.get(GridCacheProcessor.maskNull(req.cacheName()));
                if (desc == null || !desc.deploymentId().equals(req.deploymentId())) continue;
                Map<UUID, Boolean> nodes = batch.clientNodes().get(name);
                assert (nodes != null) : req;
                assert (nodes.containsKey(clientNodeId)) : nodes;
                this.ctx.discovery().addClientNode(req.cacheName(), clientNodeId, nodes.get(clientNodeId));
                continue;
            }
            this.ctx.discovery().addClientNode(req.cacheName(), clientNodeId, false);
        }
    }

    public IgniteInternalFuture<?> createFromTemplate(String cacheName) {
        try {
            CacheConfiguration cfg = this.createConfigFromTemplate(cacheName);
            return this.dynamicStartCache(cfg, cacheName, null, true, true, true);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    public IgniteInternalFuture<?> getOrCreateFromTemplate(String cacheName, boolean checkThreadTx) {
        try {
            if (this.publicJCache(cacheName, false, checkThreadTx) != null) {
                return new GridFinishedFuture();
            }
            CacheConfiguration cfg = this.createConfigFromTemplate(cacheName);
            return this.dynamicStartCache(cfg, cacheName, null, false, true, checkThreadTx);
        }
        catch (IgniteCheckedException e) {
            return new GridFinishedFuture(e);
        }
    }

    private CacheConfiguration createConfigFromTemplate(String cacheName) throws IgniteCheckedException {
        CacheConfiguration cfgTemplate = null;
        CacheConfiguration dfltCacheCfg = null;
        ArrayList<CacheConfiguration> wildcardNameCfgs = null;
        for (DynamicCacheDescriptor desc : this.registeredTemplates.values()) {
            assert (desc.template());
            CacheConfiguration cfg = desc.cacheConfiguration();
            assert (cfg != null);
            if (F.eq(cacheName, cfg.getName())) {
                cfgTemplate = cfg;
                break;
            }
            if (cfg.getName() != null) {
                if (!cfg.getName().endsWith("*")) continue;
                if (cfg.getName().length() > 1) {
                    if (wildcardNameCfgs == null) {
                        wildcardNameCfgs = new ArrayList<CacheConfiguration>();
                    }
                    wildcardNameCfgs.add(cfg);
                    continue;
                }
                dfltCacheCfg = cfg;
                continue;
            }
            if (dfltCacheCfg != null) continue;
            dfltCacheCfg = cfg;
        }
        if (cfgTemplate == null && cacheName != null && wildcardNameCfgs != null) {
            Collections.sort(wildcardNameCfgs, new Comparator<CacheConfiguration>(){

                @Override
                public int compare(CacheConfiguration cfg1, CacheConfiguration cfg2) {
                    Integer len1 = cfg1.getName() != null ? cfg1.getName().length() : 0;
                    Integer len2 = cfg2.getName() != null ? cfg2.getName().length() : 0;
                    return len2.compareTo(len1);
                }
            });
            for (CacheConfiguration cfg : wildcardNameCfgs) {
                if (!cacheName.startsWith(cfg.getName().substring(0, cfg.getName().length() - 1))) continue;
                cfgTemplate = cfg;
                break;
            }
        }
        if (cfgTemplate == null) {
            cfgTemplate = dfltCacheCfg;
        }
        cfgTemplate = cfgTemplate == null ? new CacheConfiguration() : this.cloneCheckSerializable(cfgTemplate);
        CacheConfiguration cfg = new CacheConfiguration(cfgTemplate);
        cfg.setName(cacheName);
        return cfg;
    }

    public IgniteInternalFuture<?> dynamicStartCache(@Nullable CacheConfiguration ccfg, String cacheName, @Nullable NearCacheConfiguration nearCfg, boolean failIfExists, boolean failIfNotStarted, boolean checkThreadTx) {
        return this.dynamicStartCache(ccfg, cacheName, nearCfg, CacheType.USER, failIfExists, failIfNotStarted, checkThreadTx);
    }

    public IgniteInternalFuture<?> dynamicStartCache(@Nullable CacheConfiguration ccfg, String cacheName, @Nullable NearCacheConfiguration nearCfg, CacheType cacheType, boolean failIfExists, boolean failIfNotStarted, boolean checkThreadTx) {
        if (checkThreadTx) {
            this.checkEmptyTransactions();
        }
        try {
            DynamicCacheChangeRequest req = this.prepareCacheChangeRequest(ccfg, cacheName, nearCfg, cacheType, failIfExists, failIfNotStarted);
            if (req != null) {
                return F.first(this.initiateCacheChanges(F.asList(req), failIfExists));
            }
            return new GridFinishedFuture();
        }
        catch (Exception e) {
            return new GridFinishedFuture(e);
        }
    }

    public IgniteInternalFuture<?> dynamicStartCaches(Collection<CacheConfiguration> ccfgList, boolean failIfExists, boolean checkThreadTx) {
        return this.dynamicStartCaches(ccfgList, CacheType.USER, failIfExists, checkThreadTx);
    }

    private IgniteInternalFuture<?> dynamicStartCaches(Collection<CacheConfiguration> ccfgList, CacheType cacheType, boolean failIfExists, boolean checkThreadTx) {
        if (checkThreadTx) {
            this.checkEmptyTransactions();
        }
        ArrayList<DynamicCacheChangeRequest> reqList = new ArrayList<DynamicCacheChangeRequest>(ccfgList.size());
        try {
            for (CacheConfiguration ccfg : ccfgList) {
                DynamicCacheChangeRequest req = this.prepareCacheChangeRequest(ccfg, ccfg.getName(), null, cacheType, failIfExists, true);
                if (req == null) continue;
                reqList.add(req);
            }
        }
        catch (Exception e) {
            return new GridFinishedFuture(e);
        }
        if (!reqList.isEmpty()) {
            GridCompoundFuture compoundFut = new GridCompoundFuture();
            for (DynamicCacheStartFuture fut : this.initiateCacheChanges(reqList, failIfExists)) {
                compoundFut.add(fut);
            }
            compoundFut.markInitialized();
            return compoundFut;
        }
        return new GridFinishedFuture();
    }

    public IgniteInternalFuture<?> dynamicDestroyCache(String cacheName, boolean checkThreadTx) {
        if (checkThreadTx) {
            this.checkEmptyTransactions();
        }
        DynamicCacheChangeRequest t = new DynamicCacheChangeRequest(cacheName, this.ctx.localNodeId());
        t.stop(true);
        return F.first(this.initiateCacheChanges(F.asList(t), false));
    }

    public IgniteInternalFuture<?> dynamicDestroyCaches(Collection<String> cacheNames, boolean checkThreadTx) {
        if (checkThreadTx) {
            this.checkEmptyTransactions();
        }
        ArrayList<DynamicCacheChangeRequest> reqs = new ArrayList<DynamicCacheChangeRequest>(cacheNames.size());
        for (String cacheName : cacheNames) {
            DynamicCacheChangeRequest t = new DynamicCacheChangeRequest(cacheName, this.ctx.localNodeId());
            t.stop(true);
            reqs.add(t);
        }
        GridCompoundFuture compoundFut = new GridCompoundFuture();
        for (DynamicCacheStartFuture fut : this.initiateCacheChanges(reqs, false)) {
            compoundFut.add(fut);
        }
        compoundFut.markInitialized();
        return compoundFut;
    }

    public IgniteInternalFuture<?> dynamicCloseCache(String cacheName) {
        IgniteCacheProxy<?, ?> proxy = this.jCacheProxies.get(GridCacheProcessor.maskNull(cacheName));
        if (proxy == null || proxy.proxyClosed()) {
            return new GridFinishedFuture();
        }
        this.checkEmptyTransactions();
        DynamicCacheChangeRequest t = new DynamicCacheChangeRequest(cacheName, this.ctx.localNodeId());
        t.close(true);
        return F.first(this.initiateCacheChanges(F.asList(t), false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Collection<DynamicCacheStartFuture> initiateCacheChanges(Collection<DynamicCacheChangeRequest> reqs, boolean failIfExists) {
        IgniteCheckedException err;
        ArrayList<DynamicCacheStartFuture> res;
        block30: {
            res = new ArrayList<DynamicCacheStartFuture>(reqs.size());
            ArrayList<DynamicCacheChangeRequest> sndReqs = new ArrayList<DynamicCacheChangeRequest>(reqs.size());
            for (DynamicCacheChangeRequest req : reqs) {
                DynamicCacheStartFuture fut = new DynamicCacheStartFuture(req.cacheName(), req.deploymentId(), req);
                try {
                    block29: {
                        if (req.stop() || req.close()) {
                            DynamicCacheDescriptor desc = (DynamicCacheDescriptor)this.registeredCaches.get(GridCacheProcessor.maskNull(req.cacheName()));
                            if (desc == null) {
                                fut.onDone();
                            } else {
                                assert (desc.cacheConfiguration() != null) : desc;
                                if (req.close() && desc.cacheConfiguration().getCacheMode() == CacheMode.LOCAL) {
                                    req.close(false);
                                    req.stop(true);
                                }
                                IgniteUuid dynamicDeploymentId = desc.deploymentId();
                                assert (dynamicDeploymentId != null) : desc;
                                req.deploymentId(dynamicDeploymentId);
                                fut.deploymentId = dynamicDeploymentId;
                            }
                        }
                        if (fut.isDone()) continue;
                        DynamicCacheStartFuture old = (DynamicCacheStartFuture)this.pendingFuts.putIfAbsent(GridCacheProcessor.maskNull(req.cacheName()), fut);
                        if (old != null) {
                            if (req.start()) {
                                if (!req.clientStartOnly()) {
                                    if (failIfExists) {
                                        fut.onDone(new CacheExistsException("Failed to start cache (a cache with the same name is already being started or stopped): " + req.cacheName()));
                                        break block29;
                                    } else {
                                        fut = old;
                                        continue;
                                    }
                                }
                                fut = old;
                                continue;
                            }
                            fut = old;
                            continue;
                        }
                    }
                    if (fut.isDone()) continue;
                    sndReqs.add(req);
                }
                catch (Exception e) {
                    fut.onDone(e);
                }
                finally {
                    res.add(fut);
                }
            }
            err = null;
            if (!sndReqs.isEmpty()) {
                try {
                    this.ctx.discovery().sendCustomEvent(new DynamicCacheChangeBatch(sndReqs));
                    if (this.ctx.isStopping()) {
                        err = new IgniteCheckedException("Failed to execute dynamic cache change request, node is stopping.");
                        break block30;
                    }
                    if (this.ctx.clientDisconnected()) {
                        err = new IgniteClientDisconnectedCheckedException(this.ctx.cluster().clientReconnectFuture(), "Failed to execute dynamic cache change request, client node disconnected.");
                    }
                }
                catch (IgniteCheckedException e) {
                    err = e;
                }
            }
        }
        if (err != null) {
            for (DynamicCacheStartFuture fut : res) {
                fut.onDone(err);
            }
        }
        return res;
    }

    public void onDiscoveryEvent(int type, ClusterNode node, AffinityTopologyVersion topVer) {
        if (type == 10) {
            for (DynamicCacheDescriptor cacheDesc : this.registeredCaches.values()) {
                if (!node.id().equals(cacheDesc.receivedFrom())) continue;
                cacheDesc.receivedFromStartVersion(topVer);
            }
        }
        this.sharedCtx.affinity().onDiscoveryEvent(type, node, topVer);
    }

    public boolean onCustomEvent(DiscoveryCustomMessage msg, AffinityTopologyVersion topVer) {
        if (msg instanceof CacheAffinityChangeMessage) {
            return this.sharedCtx.affinity().onCustomEvent((CacheAffinityChangeMessage)msg);
        }
        return msg instanceof DynamicCacheChangeBatch && this.onCacheChangeRequested((DynamicCacheChangeBatch)msg, topVer);
    }

    private boolean onCacheChangeRequested(DynamicCacheChangeBatch batch, AffinityTopologyVersion topVer) {
        AffinityTopologyVersion newTopVer = null;
        boolean incMinorTopVer = false;
        for (DynamicCacheChangeRequest req : batch.requests()) {
            GridFutureAdapter fut;
            DynamicCacheDescriptor old;
            this.initReceivedCacheConfiguration(req);
            if (req.template()) {
                CacheConfiguration ccfg = req.startCacheConfiguration();
                assert (ccfg != null) : req;
                DynamicCacheDescriptor desc = (DynamicCacheDescriptor)this.registeredTemplates.get(GridCacheProcessor.maskNull(req.cacheName()));
                if (desc == null) {
                    DynamicCacheDescriptor templateDesc = new DynamicCacheDescriptor(this.ctx, ccfg, req.cacheType(), true, req.deploymentId());
                    old = this.registeredTemplates.put(GridCacheProcessor.maskNull(ccfg.getName()), templateDesc);
                    assert (old == null) : "Dynamic cache map was concurrently modified [new=" + templateDesc + ", old=" + old + ']';
                }
                if ((fut = (TemplateConfigurationFuture)this.pendingTemplateFuts.get(GridCacheProcessor.maskNull(ccfg.getName()))) == null || !((TemplateConfigurationFuture)fut).deploymentId().equals(req.deploymentId())) continue;
                fut.onDone();
                continue;
            }
            DynamicCacheDescriptor desc = (DynamicCacheDescriptor)this.registeredCaches.get(GridCacheProcessor.maskNull(req.cacheName()));
            boolean needExchange = false;
            fut = null;
            if (this.ctx.localNodeId().equals(req.initiatingNodeId()) && (fut = (DynamicCacheStartFuture)this.pendingFuts.get(GridCacheProcessor.maskNull(req.cacheName()))) != null && !req.deploymentId().equals(((DynamicCacheStartFuture)fut).deploymentId())) {
                fut = null;
            }
            if (req.start()) {
                if (desc == null) {
                    if (req.clientStartOnly()) {
                        if (fut != null) {
                            fut.onDone(new IgniteCheckedException("Failed to start client cache (a cache with the given name is not started): " + U.maskName(req.cacheName())));
                        }
                    } else {
                        CacheConfiguration ccfg = req.startCacheConfiguration();
                        assert (req.cacheType() != null) : req;
                        assert (F.eq(ccfg.getName(), req.cacheName())) : req;
                        DynamicCacheDescriptor startDesc = new DynamicCacheDescriptor(this.ctx, ccfg, req.cacheType(), false, req.deploymentId());
                        if (newTopVer == null) {
                            newTopVer = new AffinityTopologyVersion(topVer.topologyVersion(), topVer.minorTopologyVersion() + 1);
                        }
                        startDesc.startTopologyVersion(newTopVer);
                        DynamicCacheDescriptor old2 = this.registeredCaches.put(GridCacheProcessor.maskNull(ccfg.getName()), startDesc);
                        assert (old2 == null) : "Dynamic cache map was concurrently modified [new=" + startDesc + ", old=" + old2 + ']';
                        this.ctx.discovery().setCacheFilter(ccfg.getName(), ccfg.getNodeFilter(), ccfg.getNearConfiguration() != null, ccfg.getCacheMode());
                        this.ctx.discovery().addClientNode(req.cacheName(), req.initiatingNodeId(), req.nearCacheConfiguration() != null);
                        needExchange = true;
                    }
                } else {
                    boolean clientReq;
                    assert (req.initiatingNodeId() != null) : req;
                    ClusterNode node = this.ctx.discovery().node(req.initiatingNodeId());
                    boolean bl = clientReq = node != null && !this.ctx.discovery().cacheAffinityNode(node, req.cacheName());
                    if (req.clientStartOnly()) {
                        needExchange = clientReq && this.ctx.discovery().addClientNode(req.cacheName(), req.initiatingNodeId(), req.nearCacheConfiguration() != null);
                    } else if (req.failIfExists()) {
                        if (fut != null) {
                            fut.onDone(new CacheExistsException("Failed to start cache (a cache with the same name is already started): " + U.maskName(req.cacheName())));
                        }
                    } else {
                        boolean bl2 = clientReq && this.ctx.discovery().addClientNode(req.cacheName(), req.initiatingNodeId(), req.nearCacheConfiguration() != null) ? true : (needExchange = false);
                        if (needExchange) {
                            req.clientStartOnly(true);
                        }
                    }
                }
                if (!needExchange && desc != null) {
                    req.cacheFutureTopologyVersion(desc.startTopologyVersion());
                }
            } else {
                assert (req.stop() ^ req.close()) : req;
                if (desc != null) {
                    if (req.stop()) {
                        old = (DynamicCacheDescriptor)this.registeredCaches.remove(GridCacheProcessor.maskNull(req.cacheName()));
                        assert (old != null) : "Dynamic cache map was concurrently modified [req=" + req + ']';
                        this.ctx.discovery().removeCacheFilter(req.cacheName());
                        needExchange = true;
                    } else {
                        assert (req.close()) : req;
                        needExchange = this.ctx.discovery().onClientCacheClose(req.cacheName(), req.initiatingNodeId());
                    }
                }
            }
            req.exchangeNeeded(needExchange);
            incMinorTopVer |= needExchange;
        }
        return incMinorTopVer;
    }

    private void initReceivedCacheConfiguration(DynamicCacheChangeRequest req) {
        CacheConfiguration ccfg;
        if (req.startCacheConfiguration() != null && (ccfg = req.startCacheConfiguration()).isStoreKeepBinary() == null) {
            ccfg.setStoreKeepBinary(CacheConfiguration.DFLT_STORE_KEEP_BINARY);
        }
    }

    private int validatePreloadOrder(CacheConfiguration[] cfgs) throws IgniteCheckedException {
        int maxOrder = 0;
        for (CacheConfiguration cfg : cfgs) {
            int rebalanceOrder = cfg.getRebalanceOrder();
            if (rebalanceOrder > 0) {
                if (cfg.getCacheMode() == CacheMode.LOCAL) {
                    throw new IgniteCheckedException("Rebalance order set for local cache (fix configuration and restart the node): " + U.maskName(cfg.getName()));
                }
                if (cfg.getRebalanceMode() == CacheRebalanceMode.NONE) {
                    throw new IgniteCheckedException("Only caches with SYNC or ASYNC rebalance mode can be set as rebalance dependency for other caches [cacheName=" + U.maskName(cfg.getName()) + ", rebalanceMode=" + (Object)((Object)cfg.getRebalanceMode()) + ", rebalanceOrder=" + cfg.getRebalanceOrder() + ']');
                }
                maxOrder = Math.max(maxOrder, rebalanceOrder);
                continue;
            }
            if (rebalanceOrder >= 0) continue;
            throw new IgniteCheckedException("Rebalance order cannot be negative for cache (fix configuration and restart the node) [cacheName=" + U.maskName(cfg.getName()) + ", rebalanceOrder=" + rebalanceOrder + ']');
        }
        return maxOrder;
    }

    @Override
    @Nullable
    public IgniteNodeValidationResult validateNode(ClusterNode node) {
        return this.validateHashIdResolvers(node);
    }

    @Nullable
    private IgniteNodeValidationResult validateHashIdResolvers(ClusterNode node) {
        if (!node.isClient()) {
            for (DynamicCacheDescriptor desc : this.registeredCaches.values()) {
                CacheConfiguration cfg = desc.cacheConfiguration();
                if (!(cfg.getAffinity() instanceof RendezvousAffinityFunction)) continue;
                RendezvousAffinityFunction aff = (RendezvousAffinityFunction)cfg.getAffinity();
                Object nodeHashObj = aff.resolveNodeHash(node);
                for (ClusterNode topNode : this.ctx.discovery().allNodes()) {
                    Object topNodeHashObj = aff.resolveNodeHash(topNode);
                    if (nodeHashObj.hashCode() != topNodeHashObj.hashCode()) continue;
                    String hashIdRslvrName = "";
                    if (aff.getHashIdResolver() != null) {
                        hashIdRslvrName = ", hashIdResolverClass=" + aff.getHashIdResolver().getClass().getName();
                    }
                    String errMsg = "Failed to add node to topology because it has the same hash code for partitioned affinity as one of existing nodes [cacheName=" + U.maskName(cfg.getName()) + hashIdRslvrName + ", existingNodeId=" + topNode.id() + ']';
                    String sndMsg = "Failed to add node to topology because it has the same hash code for partitioned affinity as one of existing nodes [cacheName=" + U.maskName(cfg.getName()) + hashIdRslvrName + ", existingNodeId=" + topNode.id() + ']';
                    return new IgniteNodeValidationResult(topNode.id(), errMsg, sndMsg);
                }
            }
        }
        return null;
    }

    private void checkCache(CacheConfiguration locCfg, CacheConfiguration rmtCfg, ClusterNode rmtNode) throws IgniteCheckedException {
        ClusterNode locNode = this.ctx.discovery().localNode();
        UUID rmt = rmtNode.id();
        GridCacheAttributes rmtAttr = new GridCacheAttributes(rmtCfg);
        GridCacheAttributes locAttr = new GridCacheAttributes(locCfg);
        boolean isLocAff = CU.affinityNode(locNode, locCfg.getNodeFilter());
        boolean isRmtAff = CU.affinityNode(rmtNode, rmtCfg.getNodeFilter());
        CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "cacheMode", "Cache mode", (Object)locAttr.cacheMode(), (Object)rmtAttr.cacheMode(), true);
        if (rmtAttr.cacheMode() != CacheMode.LOCAL) {
            boolean checkStore;
            CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "interceptor", "Cache Interceptor", locAttr.interceptorClassName(), rmtAttr.interceptorClassName(), true);
            CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "atomicityMode", "Cache atomicity mode", (Object)locAttr.atomicityMode(), (Object)rmtAttr.atomicityMode(), true);
            CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "cachePreloadMode", "Cache preload mode", (Object)locAttr.cacheRebalanceMode(), (Object)rmtAttr.cacheRebalanceMode(), true);
            boolean bl = checkStore = isLocAff && isRmtAff;
            if (checkStore) {
                CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "storeFactory", "Store factory", locAttr.storeFactoryClassName(), rmtAttr.storeFactoryClassName(), true);
            }
            CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "cacheAffinity", "Cache affinity", locAttr.cacheAffinityClassName(), rmtAttr.cacheAffinityClassName(), true);
            CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "cacheAffinityMapper", "Cache affinity mapper", locAttr.cacheAffinityMapperClassName(), rmtAttr.cacheAffinityMapperClassName(), true);
            CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "affinityPartitionsCount", "Affinity partitions count", locAttr.affinityPartitionsCount(), rmtAttr.affinityPartitionsCount(), true);
            CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "evictionFilter", "Eviction filter", locAttr.evictionFilterClassName(), rmtAttr.evictionFilterClassName(), true);
            CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "evictionPolicy", "Eviction policy", locAttr.evictionPolicyClassName(), rmtAttr.evictionPolicyClassName(), true);
            CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "transactionManagerLookup", "Transaction manager lookup", locAttr.transactionManagerLookupClassName(), rmtAttr.transactionManagerLookupClassName(), false);
            CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "defaultLockTimeout", "Default lock timeout", locAttr.defaultLockTimeout(), rmtAttr.defaultLockTimeout(), false);
            CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "preloadBatchSize", "Preload batch size", locAttr.rebalanceBatchSize(), rmtAttr.rebalanceBatchSize(), false);
            CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "swapEnabled", "Swap enabled", locAttr.swapEnabled(), rmtAttr.swapEnabled(), false);
            CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "writeSynchronizationMode", "Write synchronization mode", (Object)locAttr.writeSynchronization(), (Object)rmtAttr.writeSynchronization(), true);
            CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "writeBehindBatchSize", "Write behind batch size", locAttr.writeBehindBatchSize(), rmtAttr.writeBehindBatchSize(), false);
            CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "writeBehindEnabled", "Write behind enabled", locAttr.writeBehindEnabled(), rmtAttr.writeBehindEnabled(), false);
            CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "writeBehindFlushFrequency", "Write behind flush frequency", locAttr.writeBehindFlushFrequency(), rmtAttr.writeBehindFlushFrequency(), false);
            CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "writeBehindFlushSize", "Write behind flush size", locAttr.writeBehindFlushSize(), rmtAttr.writeBehindFlushSize(), false);
            CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "writeBehindFlushThreadCount", "Write behind flush thread count", locAttr.writeBehindFlushThreadCount(), rmtAttr.writeBehindFlushThreadCount(), false);
            CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "evictMaxOverflowRatio", "Eviction max overflow ratio", Float.valueOf(locAttr.evictMaxOverflowRatio()), Float.valueOf(rmtAttr.evictMaxOverflowRatio()), true);
            if (locAttr.cacheMode() == CacheMode.PARTITIONED) {
                CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "evictSynchronized", "Eviction synchronized", locAttr.evictSynchronized(), rmtAttr.evictSynchronized(), true);
                CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "nearEvictionPolicy", "Near eviction policy", locAttr.nearEvictionPolicyClassName(), rmtAttr.nearEvictionPolicyClassName(), false);
                CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "affinityIncludeNeighbors", "Affinity include neighbors", locAttr.affinityIncludeNeighbors(), rmtAttr.affinityIncludeNeighbors(), true);
                CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "affinityKeyBackups", "Affinity key backups", locAttr.affinityKeyBackups(), rmtAttr.affinityKeyBackups(), true);
                String locHashIdResolver = locAttr.affinityHashIdResolverClassName();
                String rmtHashIdResolver = rmtAttr.affinityHashIdResolverClassName();
                String defHashIdResolver = AffinityNodeAddressHashResolver.class.getName();
                if (!(locHashIdResolver == null && rmtHashIdResolver == null || locHashIdResolver == null && rmtHashIdResolver.equals(defHashIdResolver) || rmtHashIdResolver == null && locHashIdResolver.equals(defHashIdResolver))) {
                    CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "cacheAffinity.hashIdResolver", "Partitioned cache affinity hash ID resolver class", locHashIdResolver, rmtHashIdResolver, true);
                }
                if (locHashIdResolver == null && rmtHashIdResolver != null && rmtHashIdResolver.equals(defHashIdResolver)) {
                    U.warn(this.log, "Set " + RendezvousAffinityFunction.class + " with " + defHashIdResolver + " to CacheConfiguration to start node [cacheName=" + rmtAttr.cacheName() + "]");
                }
            }
        }
    }

    private void checkTransactionConfiguration(ClusterNode rmt) throws IgniteCheckedException {
        TransactionConfiguration locTxCfg;
        TransactionConfiguration txCfg = (TransactionConfiguration)rmt.attribute("org.apache.ignite.tx");
        if (txCfg != null && (locTxCfg = this.ctx.config().getTransactionConfiguration()).isTxSerializableEnabled() != txCfg.isTxSerializableEnabled()) {
            throw new IgniteCheckedException("Serializable transactions enabled mismatch (fix txSerializableEnabled property or set -DIGNITE_SKIP_CONFIGURATION_CONSISTENCY_CHECK=true system property) [rmtNodeId=" + rmt.id() + ", locTxSerializableEnabled=" + locTxCfg.isTxSerializableEnabled() + ", rmtTxSerializableEnabled=" + txCfg.isTxSerializableEnabled() + ']');
        }
    }

    public void onEvictFromSwap(String spaceName, byte[] keyBytes, byte[] valBytes) {
        GridCacheQueryManager<?, ?> qryMgr;
        GridCacheContext<?, ?> cctx;
        assert (spaceName != null);
        assert (keyBytes != null);
        assert (valBytes != null);
        GridCacheAdapter<?, ?> cache = this.caches.get(GridCacheProcessor.maskNull(CU.cacheNameForSwapSpaceName(spaceName)));
        assert (cache != null) : "Failed to resolve cache name for swap space name: " + spaceName;
        GridCacheContext<Object, Object> gridCacheContext = cctx = cache.configuration().getCacheMode() == CacheMode.PARTITIONED ? ((GridNearCacheAdapter)cache).dht().context() : cache.context();
        if (spaceName.equals(CU.swapSpaceName(cctx)) && (qryMgr = cctx.queries()).enabled()) {
            try {
                KeyCacheObject key = cctx.toCacheKeyObject(keyBytes);
                CacheObject val = cctx.swap().unmarshalSwapEntryValue(valBytes);
                assert (val != null);
                qryMgr.remove(key, val);
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Failed to unmarshal key evicted from swap [swapSpaceName=" + spaceName + ']', e);
            }
        }
    }

    private GridCacheQueryManager queryManager(CacheConfiguration cfg) {
        return cfg.getCacheMode() == CacheMode.LOCAL ? new GridCacheLocalQueryManager() : new GridCacheDistributedQueryManager();
    }

    public long lastDataVersion() {
        long max = 0L;
        for (GridCacheAdapter<?, ?> cache : this.caches.values()) {
            GridCacheContext<Object, Object> ctx = cache.context();
            if (ctx.versions().last().order() > max) {
                max = ctx.versions().last().order();
            }
            if (!ctx.isNear() || (ctx = ctx.near().dht().context()).versions().last().order() <= max) continue;
            max = ctx.versions().last().order();
        }
        return max;
    }

    public <K, V> IgniteInternalCache<K, V> cache() {
        return this.cache(null);
    }

    public <K, V> IgniteInternalCache<K, V> cache(@Nullable String name) {
        IgniteCacheProxy<?, ?> jcache;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Getting cache for name: " + name);
        }
        return (jcache = this.jCacheProxies.get(GridCacheProcessor.maskNull(name))) == null ? null : jcache.internalProxy();
    }

    public <K, V> IgniteInternalCache<K, V> getOrStartCache(@Nullable String name) throws IgniteCheckedException {
        String masked;
        IgniteCacheProxy<?, ?> cache;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Getting cache for name: " + name);
        }
        if ((cache = this.jCacheProxies.get(masked = GridCacheProcessor.maskNull(name))) == null) {
            this.dynamicStartCache(null, name, null, false, true, true).get();
            cache = this.jCacheProxies.get(masked);
        }
        return cache == null ? null : cache.internalProxy();
    }

    public Collection<IgniteInternalCache<?, ?>> caches() {
        return F.viewReadOnly(this.jCacheProxies.values(), new IgniteClosure<IgniteCacheProxy<?, ?>, IgniteInternalCache<?, ?>>(){

            @Override
            public IgniteInternalCache<?, ?> apply(IgniteCacheProxy<?, ?> entries) {
                return entries.internalProxy();
            }
        }, new IgnitePredicate[0]);
    }

    public Collection<IgniteCacheProxy<?, ?>> jcaches() {
        return this.jCacheProxies.values();
    }

    public GridCacheAdapter<Integer, String> marshallerCache() {
        return this.internalCache("ignite-marshaller-sys-cache");
    }

    public <K, V> IgniteInternalCache<K, V> utilityCache() {
        return this.internalCacheEx("ignite-sys-cache");
    }

    public <K, V> IgniteInternalCache<K, V> atomicsCache() {
        return this.internalCacheEx("ignite-atomics-sys-cache");
    }

    private <K, V> IgniteInternalCache<K, V> internalCacheEx(String name) {
        if (this.ctx.discovery().localNode().isClient()) {
            IgniteCacheProxy<?, ?> proxy = this.jCacheProxies.get(name);
            assert (proxy != null);
            return proxy.internalProxy();
        }
        return this.internalCache(name);
    }

    public <K, V> IgniteInternalCache<K, V> publicCache(@Nullable String name) {
        DynamicCacheDescriptor desc;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Getting public cache for name: " + name);
        }
        if ((desc = (DynamicCacheDescriptor)this.registeredCaches.get(GridCacheProcessor.maskNull(name))) == null) {
            throw new IllegalArgumentException("Cache is not started: " + name);
        }
        if (!desc.cacheType().userCache()) {
            throw new IllegalStateException("Failed to get cache because it is a system cache: " + name);
        }
        IgniteCacheProxy<?, ?> jcache = this.jCacheProxies.get(GridCacheProcessor.maskNull(name));
        if (jcache == null) {
            throw new IllegalArgumentException("Cache is not started: " + name);
        }
        return jcache.internalProxy();
    }

    public <K, V> IgniteCacheProxy<K, V> publicJCache(@Nullable String cacheName) throws IgniteCheckedException {
        return this.publicJCache(cacheName, true, true);
    }

    @Nullable
    public <K, V> IgniteCacheProxy<K, V> publicJCache(@Nullable String cacheName, boolean failIfNotStarted, boolean checkThreadTx) throws IgniteCheckedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Getting public cache for name: " + cacheName);
        }
        String masked = GridCacheProcessor.maskNull(cacheName);
        IgniteCacheProxy<?, ?> cache = this.jCacheProxies.get(masked);
        DynamicCacheDescriptor desc = (DynamicCacheDescriptor)this.registeredCaches.get(masked);
        if (desc != null && !desc.cacheType().userCache()) {
            throw new IllegalStateException("Failed to get cache because it is a system cache: " + cacheName);
        }
        if (cache == null) {
            this.dynamicStartCache(null, cacheName, null, false, failIfNotStarted, checkThreadTx).get();
            cache = this.jCacheProxies.get(masked);
        }
        return cache;
    }

    public CacheConfiguration cacheConfiguration(String name) {
        DynamicCacheDescriptor desc = (DynamicCacheDescriptor)this.registeredCaches.get(GridCacheProcessor.maskNull(name));
        if (desc == null) {
            throw new IllegalStateException("Cache doesn't exist: " + name);
        }
        return desc.cacheConfiguration();
    }

    public Collection<DynamicCacheDescriptor> cacheDescriptors() {
        return this.registeredCaches.values();
    }

    @Nullable
    public DynamicCacheDescriptor cacheDescriptor(int cacheId) {
        for (DynamicCacheDescriptor cacheDesc : this.registeredCaches.values()) {
            CacheConfiguration ccfg = cacheDesc.cacheConfiguration();
            assert (ccfg != null) : cacheDesc;
            if (CU.cacheId(ccfg.getName()) != cacheId) continue;
            return cacheDesc;
        }
        return null;
    }

    public void addCacheConfiguration(CacheConfiguration cacheCfg) throws IgniteCheckedException {
        String masked = GridCacheProcessor.maskNull(cacheCfg.getName());
        DynamicCacheDescriptor desc = (DynamicCacheDescriptor)this.registeredTemplates.get(masked);
        if (desc != null) {
            return;
        }
        DynamicCacheChangeRequest req = new DynamicCacheChangeRequest(cacheCfg.getName(), this.ctx.localNodeId());
        CacheConfiguration cfg = new CacheConfiguration(cacheCfg);
        req.template(true);
        req.startCacheConfiguration(cfg);
        req.deploymentId(IgniteUuid.randomUuid());
        TemplateConfigurationFuture fut = new TemplateConfigurationFuture(req.cacheName(), req.deploymentId());
        TemplateConfigurationFuture old = (TemplateConfigurationFuture)this.pendingTemplateFuts.putIfAbsent(GridCacheProcessor.maskNull(cacheCfg.getName()), fut);
        if (old != null) {
            fut = old;
        }
        IgniteCheckedException err = null;
        try {
            this.ctx.discovery().sendCustomEvent(new DynamicCacheChangeBatch(Collections.singleton(req)));
            if (this.ctx.isStopping()) {
                err = new IgniteCheckedException("Failed to execute dynamic cache change request, node is stopping.");
            } else if (this.ctx.clientDisconnected()) {
                err = new IgniteClientDisconnectedCheckedException(this.ctx.cluster().clientReconnectFuture(), "Failed to execute dynamic cache change request, client node disconnected.");
            }
        }
        catch (IgniteCheckedException e) {
            err = e;
        }
        if (err != null) {
            fut.onDone(err);
        }
        fut.get();
    }

    public <K, V> IgniteCacheProxy<K, V> jcache(@Nullable String name) {
        IgniteCacheProxy<?, ?> cache = this.jCacheProxies.get(GridCacheProcessor.maskNull(name));
        if (cache == null) {
            throw new IllegalArgumentException("Cache is not configured: " + name);
        }
        return cache;
    }

    public Collection<IgniteCacheProxy<?, ?>> publicCaches() {
        ArrayList res = new ArrayList(this.jCacheProxies.size());
        for (Map.Entry<String, IgniteCacheProxy<?, ?>> entry : this.jCacheProxies.entrySet()) {
            if (!entry.getValue().context().userCache()) continue;
            res.add(entry.getValue());
        }
        return res;
    }

    public <K, V> GridCacheAdapter<K, V> internalCache() {
        return this.internalCache(null);
    }

    public <K, V> GridCacheAdapter<K, V> internalCache(@Nullable String name) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Getting internal cache adapter: " + name);
        }
        return this.caches.get(GridCacheProcessor.maskNull(name));
    }

    private void cancelFutures() {
        this.sharedCtx.mvcc().onStop();
        IgniteCheckedException err = new IgniteCheckedException("Operation has been cancelled (node is stopping).");
        for (IgniteInternalFuture fut : this.pendingFuts.values()) {
            ((GridFutureAdapter)fut).onDone(err);
        }
        for (IgniteInternalFuture fut : this.pendingTemplateFuts.values()) {
            ((GridFutureAdapter)fut).onDone(err);
        }
    }

    public Collection<GridCacheAdapter<?, ?>> internalCaches() {
        return this.caches.values();
    }

    public boolean systemCache(@Nullable String name) {
        DynamicCacheDescriptor desc = (DynamicCacheDescriptor)this.registeredCaches.get(GridCacheProcessor.maskNull(name));
        return desc != null && !desc.cacheType().userCache();
    }

    @Override
    public void printMemoryStats() {
        X.println(">>> ", new Object[0]);
        for (GridCacheAdapter<?, ?> c : this.caches.values()) {
            X.println(">>> Cache memory stats [grid=" + this.ctx.gridName() + ", cache=" + c.name() + ']', new Object[0]);
            c.context().printMemoryStats();
        }
    }

    public void onUndeployed(ClassLoader ldr) {
        if (!this.ctx.isStopping()) {
            for (GridCacheAdapter<?, ?> cache : this.caches.values()) {
                if (!cache.context().userCache() || !cache.context().deploymentEnabled()) continue;
                cache.onUndeploy(ldr);
            }
        }
    }

    public <K, V> GridCacheSharedContext<K, V> context() {
        return this.sharedCtx;
    }

    public IgniteTransactionsEx transactions() {
        return this.transactions;
    }

    public void createMissingCaches() throws IgniteCheckedException {
        for (Map.Entry e : this.registeredCaches.entrySet()) {
            CacheConfiguration ccfg = ((DynamicCacheDescriptor)e.getValue()).cacheConfiguration();
            if (this.caches.containsKey(GridCacheProcessor.maskNull(ccfg.getName())) || !GridQueryProcessor.isEnabled(ccfg)) continue;
            this.dynamicStartCache(null, ccfg.getName(), null, false, true, true).get();
        }
    }

    private void registerMbean(Object o, @Nullable String cacheName, boolean near) throws IgniteCheckedException {
        assert (o != null);
        MBeanServer srvr = this.ctx.config().getMBeanServer();
        assert (srvr != null);
        cacheName = U.maskName(cacheName);
        cacheName = near ? cacheName + "-near" : cacheName;
        for (Class<?> itf : o.getClass().getInterfaces()) {
            if (!itf.getName().endsWith("MBean") && !itf.getName().endsWith("MXBean")) continue;
            try {
                U.registerCacheMBean(srvr, this.ctx.gridName(), cacheName, o.getClass().getName(), o, itf);
                break;
            }
            catch (JMException e) {
                throw new IgniteCheckedException("Failed to register MBean for component: " + o, e);
            }
        }
    }

    private void unregisterMbean(Object o, @Nullable String cacheName, boolean near) {
        assert (o != null);
        MBeanServer srvr = this.ctx.config().getMBeanServer();
        assert (srvr != null);
        cacheName = U.maskName(cacheName);
        cacheName = near ? cacheName + "-near" : cacheName;
        for (Class<?> itf : o.getClass().getInterfaces()) {
            if (!itf.getName().endsWith("MBean") && !itf.getName().endsWith("MXBean")) continue;
            try {
                srvr.unregisterMBean(U.makeCacheMBeanName(this.ctx.gridName(), cacheName, o.getClass().getName()));
            }
            catch (JMException e) {
                U.error(this.log, "Failed to unregister MBean for component: " + o, e);
            }
            break;
        }
    }

    private Iterable<Object> lifecycleAwares(CacheConfiguration ccfg, Object ... objs) {
        ArrayList<Object> ret = new ArrayList<Object>(7 + objs.length);
        ret.add(ccfg.getAffinity());
        ret.add(ccfg.getAffinityMapper());
        ret.add(ccfg.getEvictionFilter());
        ret.add(ccfg.getEvictionPolicy());
        ret.add(ccfg.getInterceptor());
        ret.add(ccfg.getTopologyValidator());
        NearCacheConfiguration nearCfg = ccfg.getNearConfiguration();
        if (nearCfg != null) {
            ret.add(nearCfg.getNearEvictionPolicy());
        }
        Collections.addAll(ret, objs);
        return ret;
    }

    private void checkEmptyTransactions() throws IgniteException {
        if (this.transactions().tx() != null || this.sharedCtx.lockedTopologyVersion(null) != null) {
            throw new IgniteException("Cannot start/stop cache within lock or transaction.");
        }
    }

    private CacheConfiguration cloneCheckSerializable(final CacheConfiguration val) throws IgniteCheckedException {
        if (val == null) {
            return null;
        }
        return this.withBinaryContext(new IgniteOutClosureX<CacheConfiguration>(){

            @Override
            public CacheConfiguration applyx() throws IgniteCheckedException {
                if (val.getCacheStoreFactory() != null) {
                    try {
                        ClassLoader ldr = GridCacheProcessor.this.ctx.config().getClassLoader();
                        if (ldr == null) {
                            ldr = val.getCacheStoreFactory().getClass().getClassLoader();
                        }
                        U.unmarshal(GridCacheProcessor.this.marsh, U.marshal(GridCacheProcessor.this.marsh, val.getCacheStoreFactory()), U.resolveClassLoader(ldr, GridCacheProcessor.this.ctx.config()));
                    }
                    catch (IgniteCheckedException e) {
                        throw new IgniteCheckedException("Failed to validate cache configuration. Cache store factory is not serializable. Cache name: " + U.maskName(val.getName()), e);
                    }
                }
                try {
                    return (CacheConfiguration)U.unmarshal(GridCacheProcessor.this.marsh, U.marshal(GridCacheProcessor.this.marsh, (Object)val), U.resolveClassLoader(GridCacheProcessor.this.ctx.config()));
                }
                catch (IgniteCheckedException e) {
                    throw new IgniteCheckedException("Failed to validate cache configuration (make sure all objects in cache configuration are serializable): " + U.maskName(val.getName()), e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withBinaryContext(IgniteOutClosureX<T> c) throws IgniteCheckedException {
        T t;
        IgniteCacheObjectProcessor objProc = this.ctx.cacheObjects();
        BinaryContext oldCtx = null;
        if (objProc instanceof CacheObjectBinaryProcessorImpl) {
            GridBinaryMarshaller binMarsh = ((CacheObjectBinaryProcessorImpl)objProc).marshaller();
            oldCtx = binMarsh == null ? null : binMarsh.pushContext();
        }
        try {
            t = c.applyx();
        }
        catch (Throwable throwable) {
            if (objProc instanceof CacheObjectBinaryProcessorImpl) {
                GridBinaryMarshaller.popContext(oldCtx);
            }
            throw throwable;
        }
        if (objProc instanceof CacheObjectBinaryProcessorImpl) {
            GridBinaryMarshaller.popContext(oldCtx);
        }
        return t;
    }

    private DynamicCacheChangeRequest prepareCacheChangeRequest(@Nullable CacheConfiguration ccfg, String cacheName, @Nullable NearCacheConfiguration nearCfg, CacheType cacheType, boolean failIfExists, boolean failIfNotStarted) throws IgniteCheckedException {
        DynamicCacheDescriptor desc = (DynamicCacheDescriptor)this.registeredCaches.get(GridCacheProcessor.maskNull(cacheName));
        DynamicCacheChangeRequest req = new DynamicCacheChangeRequest(cacheName, this.ctx.localNodeId());
        req.failIfExists(failIfExists);
        if (ccfg != null) {
            this.cloneCheckSerializable(ccfg);
            if (desc != null) {
                if (failIfExists) {
                    throw new CacheExistsException("Failed to start cache (a cache with the same name is already started): " + cacheName);
                }
                CacheConfiguration descCfg = desc.cacheConfiguration();
                if (nearCfg != null) {
                    if (CU.affinityNode(this.ctx.discovery().localNode(), descCfg.getNodeFilter())) {
                        if (descCfg.getNearConfiguration() != null) {
                            return null;
                        }
                        throw new IgniteCheckedException("Failed to start near cache (local node is an affinity node for cache): " + cacheName);
                    }
                    req.clientStartOnly(true);
                } else {
                    req.clientStartOnly(true);
                }
                req.deploymentId(desc.deploymentId());
                req.startCacheConfiguration(descCfg);
            } else {
                req.deploymentId(IgniteUuid.randomUuid());
                CacheConfiguration cfg = new CacheConfiguration(ccfg);
                CacheObjectContext cacheObjCtx = this.ctx.cacheObjects().contextForCache(cfg);
                this.initialize(cfg, cacheObjCtx);
                req.startCacheConfiguration(cfg);
            }
        } else {
            req.clientStartOnly(true);
            if (desc != null) {
                ccfg = desc.cacheConfiguration();
            }
            if (ccfg == null) {
                if (failIfNotStarted) {
                    throw new CacheExistsException("Failed to start client cache (a cache with the given name is not started): " + cacheName);
                }
                return null;
            }
            req.deploymentId(desc.deploymentId());
            req.startCacheConfiguration(ccfg);
        }
        if (ccfg.isSwapEnabled()) {
            for (ClusterNode n : this.ctx.discovery().allNodes()) {
                if (GridCacheUtils.clientNode(n) || GridCacheUtils.isSwapEnabled(n)) continue;
                throw new IgniteCheckedException("Failed to start cache " + cacheName + " with swap enabled: Remote Node with ID " + n.id().toString().toUpperCase() + " has not swap SPI configured");
            }
        }
        if (nearCfg != null) {
            req.nearCacheConfiguration(nearCfg);
        }
        req.cacheType(cacheType);
        return req;
    }

    public <T> T clone(final T obj) throws IgniteCheckedException {
        return this.withBinaryContext(new IgniteOutClosureX<T>(){

            @Override
            public T applyx() throws IgniteCheckedException {
                return U.unmarshal(GridCacheProcessor.this.marsh, U.marshal(GridCacheProcessor.this.marsh, obj), U.resolveClassLoader(GridCacheProcessor.this.ctx.config()));
            }
        });
    }

    private static String maskNull(String name) {
        return name == null ? NULL_NAME : name;
    }

    private static String unmaskNull(String name) {
        return name == NULL_NAME ? null : name;
    }

    private class RemovedItemsCleanupTask
    implements GridTimeoutObject {
        private final IgniteUuid id = IgniteUuid.randomUuid();
        private final long endTime;
        private final long timeout;

        RemovedItemsCleanupTask(long timeout) {
            this.timeout = timeout;
            this.endTime = U.currentTimeMillis() + timeout;
        }

        @Override
        public IgniteUuid timeoutId() {
            return this.id;
        }

        @Override
        public long endTime() {
            return this.endTime;
        }

        @Override
        public void onTimeout() {
            GridCacheProcessor.this.ctx.closure().runLocalSafe(new Runnable(){

                @Override
                public void run() {
                    try {
                        for (GridCacheContext cacheCtx : GridCacheProcessor.this.sharedCtx.cacheContexts()) {
                            if (cacheCtx.isLocal() || !cacheCtx.affinityNode()) continue;
                            GridDhtPartitionTopology top = null;
                            try {
                                top = cacheCtx.topology();
                            }
                            catch (IllegalStateException illegalStateException) {
                                // empty catch block
                            }
                            if (top != null) {
                                for (GridDhtLocalPartition part : top.currentLocalPartitions()) {
                                    part.cleanupRemoveQueue();
                                }
                            }
                            if (!GridCacheProcessor.this.ctx.isStopping()) continue;
                            return;
                        }
                    }
                    catch (Exception e) {
                        U.error(GridCacheProcessor.this.log, "Failed to cleanup removed cache items: " + e, e);
                    }
                    if (GridCacheProcessor.this.ctx.isStopping()) {
                        return;
                    }
                    GridCacheProcessor.this.addRemovedItemsCleanupTask(RemovedItemsCleanupTask.this.timeout);
                }
            }, true);
        }
    }

    private static class LocalAffinityFunction
    implements AffinityFunction {
        private static final long serialVersionUID = 0L;

        private LocalAffinityFunction() {
        }

        @Override
        public List<List<ClusterNode>> assignPartitions(AffinityFunctionContext affCtx) {
            ClusterNode locNode = null;
            for (ClusterNode n : affCtx.currentTopologySnapshot()) {
                if (!n.isLocal()) continue;
                locNode = n;
                break;
            }
            if (locNode == null) {
                throw new IgniteException("Local node is not included into affinity nodes for 'LOCAL' cache");
            }
            ArrayList<List<ClusterNode>> res = new ArrayList<List<ClusterNode>>(this.partitions());
            for (int part = 0; part < this.partitions(); ++part) {
                res.add(Collections.singletonList(locNode));
            }
            return Collections.unmodifiableList(res);
        }

        @Override
        public void reset() {
        }

        @Override
        public int partitions() {
            return 1;
        }

        @Override
        public int partition(Object key) {
            return 0;
        }

        @Override
        public void removeNode(UUID nodeId) {
        }
    }

    private class TemplateConfigurationFuture
    extends GridFutureAdapter<Object> {
        @GridToStringInclude
        private IgniteUuid deploymentId;
        private String cacheName;

        private TemplateConfigurationFuture(String cacheName, IgniteUuid deploymentId) {
            this.deploymentId = deploymentId;
            this.cacheName = cacheName;
        }

        public IgniteUuid deploymentId() {
            return this.deploymentId;
        }

        @Override
        public boolean onDone(@Nullable Object res, @Nullable Throwable err) {
            GridCacheProcessor.this.pendingTemplateFuts.remove(GridCacheProcessor.maskNull(this.cacheName), this);
            return super.onDone(res, err);
        }

        @Override
        public String toString() {
            return S.toString(TemplateConfigurationFuture.class, this);
        }
    }

    private class DynamicCacheStartFuture
    extends GridFutureAdapter<Object> {
        @GridToStringInclude
        private IgniteUuid deploymentId;
        private String cacheName;
        @GridToStringInclude
        private DynamicCacheChangeRequest req;

        private DynamicCacheStartFuture(String cacheName, IgniteUuid deploymentId, DynamicCacheChangeRequest req) {
            this.deploymentId = deploymentId;
            this.cacheName = cacheName;
            this.req = req;
        }

        public IgniteUuid deploymentId() {
            return this.deploymentId;
        }

        public DynamicCacheChangeRequest request() {
            return this.req;
        }

        @Override
        public boolean onDone(@Nullable Object res, @Nullable Throwable err) {
            GridCacheProcessor.this.pendingFuts.remove(GridCacheProcessor.maskNull(this.cacheName), this);
            return super.onDone(res, err);
        }

        @Override
        public String toString() {
            return S.toString(DynamicCacheStartFuture.class, this);
        }
    }
}

