/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.store.CacheStoreSessionListener;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.TransactionConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.managers.communication.GridIoManager;
import org.apache.ignite.internal.managers.deployment.GridDeploymentManager;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.managers.eventstorage.GridEventStorageManager;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheAffinitySharedManager;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheDeploymentManager;
import org.apache.ignite.internal.processors.cache.GridCacheIoManager;
import org.apache.ignite.internal.processors.cache.GridCacheMvccManager;
import org.apache.ignite.internal.processors.cache.GridCachePartitionExchangeManager;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.cache.GridCacheSharedManager;
import org.apache.ignite.internal.processors.cache.GridCacheSharedTtlCleanupManager;
import org.apache.ignite.internal.processors.cache.jta.CacheJtaManagerAdapter;
import org.apache.ignite.internal.processors.cache.store.CacheStoreManager;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxManager;
import org.apache.ignite.internal.processors.cache.transactions.TransactionMetricsAdapter;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionManager;
import org.apache.ignite.internal.processors.timeout.GridTimeoutProcessor;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.marshaller.Marshaller;
import org.jetbrains.annotations.Nullable;

@GridToStringExclude
public class GridCacheSharedContext<K, V> {
    private GridKernalContext kernalCtx;
    private List<GridCacheSharedManager<K, V>> mgrs = new LinkedList<GridCacheSharedManager<K, V>>();
    private IgniteTxManager txMgr;
    private CacheJtaManagerAdapter jtaMgr;
    private GridCachePartitionExchangeManager<K, V> exchMgr;
    private GridCacheVersionManager verMgr;
    private GridCacheMvccManager mvccMgr;
    private GridCacheIoManager ioMgr;
    private GridCacheDeploymentManager<K, V> depMgr;
    private CacheAffinitySharedManager affMgr;
    private GridCacheSharedTtlCleanupManager ttlMgr;
    private ConcurrentMap<Integer, GridCacheContext<K, V>> ctxMap;
    private volatile TransactionMetricsAdapter txMetrics;
    private Collection<CacheStoreSessionListener> storeSesLsnrs;
    private final AtomicInteger locStoreCnt;
    private final boolean locStorePrimaryOnly = IgniteSystemProperties.getBoolean("IGNITE_LOCAL_STORE_KEEPS_PRIMARY_ONLY");
    private final IgniteLogger msgLog;
    private final IgniteLogger atomicMsgLog;
    private final IgniteLogger txPrepareMsgLog;
    private final IgniteLogger txFinishMsgLog;
    private final IgniteLogger txLockMsgLog;
    private final IgniteLogger txRecoveryMsgLog;

    public GridCacheSharedContext(GridKernalContext kernalCtx, IgniteTxManager txMgr, GridCacheVersionManager verMgr, GridCacheMvccManager mvccMgr, GridCacheDeploymentManager<K, V> depMgr, GridCachePartitionExchangeManager<K, V> exchMgr, CacheAffinitySharedManager<K, V> affMgr, GridCacheIoManager ioMgr, GridCacheSharedTtlCleanupManager ttlMgr, CacheJtaManagerAdapter jtaMgr, Collection<CacheStoreSessionListener> storeSesLsnrs) {
        this.kernalCtx = kernalCtx;
        this.setManagers(this.mgrs, txMgr, jtaMgr, verMgr, mvccMgr, depMgr, exchMgr, affMgr, ioMgr, ttlMgr);
        this.storeSesLsnrs = storeSesLsnrs;
        this.txMetrics = new TransactionMetricsAdapter();
        this.ctxMap = new ConcurrentHashMap<Integer, GridCacheContext<K, V>>();
        this.locStoreCnt = new AtomicInteger();
        this.msgLog = kernalCtx.log("org.apache.ignite.cache.msg");
        this.atomicMsgLog = kernalCtx.log("org.apache.ignite.cache.msg.atomic");
        this.txPrepareMsgLog = kernalCtx.log("org.apache.ignite.cache.msg.tx.prepare");
        this.txFinishMsgLog = kernalCtx.log("org.apache.ignite.cache.msg.tx.finish");
        this.txLockMsgLog = kernalCtx.log("org.apache.ignite.cache.msg.tx.lock");
        this.txRecoveryMsgLog = kernalCtx.log("org.apache.ignite.cache.msg.tx.recovery");
    }

    public IgniteLogger messageLogger() {
        return this.msgLog;
    }

    public IgniteLogger atomicMessageLogger() {
        return this.atomicMsgLog;
    }

    public IgniteLogger txPrepareMessageLogger() {
        return this.txPrepareMsgLog;
    }

    public IgniteLogger txFinishMessageLogger() {
        return this.txFinishMsgLog;
    }

    public IgniteLogger txLockMessageLogger() {
        return this.txLockMsgLog;
    }

    public IgniteLogger txRecoveryMessageLogger() {
        return this.txRecoveryMsgLog;
    }

    void onDisconnected(IgniteFuture<?> reconnectFut) throws IgniteCheckedException {
        GridCacheSharedManager<K, V> mgr;
        ListIterator<GridCacheSharedManager<K, V>> it = this.mgrs.listIterator(this.mgrs.size());
        while (it.hasPrevious()) {
            mgr = it.previous();
            mgr.onDisconnected(reconnectFut);
            if (!this.restartOnDisconnect(mgr)) continue;
            mgr.onKernalStop(true);
        }
        it = this.mgrs.listIterator(this.mgrs.size());
        while (it.hasPrevious()) {
            mgr = it.previous();
            if (!this.restartOnDisconnect(mgr)) continue;
            mgr.stop(true);
        }
    }

    void onReconnected() throws IgniteCheckedException {
        LinkedList<GridCacheSharedManager<K, V>> mgrs = new LinkedList<GridCacheSharedManager<K, V>>();
        this.setManagers(mgrs, this.txMgr, this.jtaMgr, this.verMgr, this.mvccMgr, new GridCacheDeploymentManager(), new GridCachePartitionExchangeManager(), this.affMgr, this.ioMgr, this.ttlMgr);
        this.mgrs = mgrs;
        for (GridCacheSharedManager gridCacheSharedManager : mgrs) {
            if (!this.restartOnDisconnect(gridCacheSharedManager)) continue;
            gridCacheSharedManager.start(this);
        }
        for (GridCacheSharedManager gridCacheSharedManager : mgrs) {
            gridCacheSharedManager.onKernalStart(true);
        }
    }

    private boolean restartOnDisconnect(GridCacheSharedManager<?, ?> mgr) {
        return mgr instanceof GridCacheDeploymentManager || mgr instanceof GridCachePartitionExchangeManager;
    }

    private void setManagers(List<GridCacheSharedManager<K, V>> mgrs, IgniteTxManager txMgr, CacheJtaManagerAdapter jtaMgr, GridCacheVersionManager verMgr, GridCacheMvccManager mvccMgr, GridCacheDeploymentManager<K, V> depMgr, GridCachePartitionExchangeManager<K, V> exchMgr, CacheAffinitySharedManager affMgr, GridCacheIoManager ioMgr, GridCacheSharedTtlCleanupManager ttlMgr) {
        this.mvccMgr = this.add(mgrs, mvccMgr);
        this.verMgr = this.add(mgrs, verMgr);
        this.txMgr = this.add(mgrs, txMgr);
        this.jtaMgr = this.add(mgrs, jtaMgr);
        this.depMgr = this.add(mgrs, depMgr);
        this.exchMgr = this.add(mgrs, exchMgr);
        this.affMgr = this.add(mgrs, affMgr);
        this.ioMgr = this.add(mgrs, ioMgr);
        this.ttlMgr = this.add(mgrs, ttlMgr);
    }

    public Collection<GridCacheContext> cacheContexts() {
        return this.ctxMap.values();
    }

    public GridCacheProcessor cache() {
        return this.kernalCtx.cache();
    }

    public void addCacheContext(GridCacheContext cacheCtx) throws IgniteCheckedException {
        if (this.ctxMap.containsKey(cacheCtx.cacheId())) {
            GridCacheContext existing = (GridCacheContext)this.ctxMap.get(cacheCtx.cacheId());
            throw new IgniteCheckedException("Failed to start cache due to conflicting cache ID (change cache name and restart grid) [cacheName=" + cacheCtx.name() + ", conflictingCacheName=" + existing.name() + ']');
        }
        CacheStoreManager mgr = cacheCtx.store();
        if (mgr.configured() && mgr.isLocal()) {
            this.locStoreCnt.incrementAndGet();
        }
        this.ctxMap.put(cacheCtx.cacheId(), cacheCtx);
    }

    public void removeCacheContext(GridCacheContext cacheCtx) {
        int cacheId = cacheCtx.cacheId();
        this.ctxMap.remove(cacheId, cacheCtx);
        CacheStoreManager mgr = cacheCtx.store();
        if (mgr.configured() && mgr.isLocal()) {
            this.locStoreCnt.decrementAndGet();
        }
        this.ioMgr.removeHandlers(cacheId);
    }

    public boolean closed(GridCacheContext ctx) {
        return !this.ctxMap.containsKey(ctx.cacheId());
    }

    public List<GridCacheSharedManager<K, V>> managers() {
        return this.mgrs;
    }

    public GridCacheContext<K, V> cacheContext(int cacheId) {
        return (GridCacheContext)this.ctxMap.get(cacheId);
    }

    public String gridName() {
        return this.kernalCtx.gridName();
    }

    public TransactionConfiguration txConfig() {
        return this.kernalCtx.config().getTransactionConfiguration();
    }

    public long preloadExchangeTimeout() {
        long t2;
        long t1 = this.gridConfig().getNetworkTimeout() * 4L;
        long timeout = Math.max(t1, t2 = this.gridConfig().getNetworkTimeout() * (long)this.gridConfig().getCacheConfiguration().length * 2L);
        return timeout < 0L ? Long.MAX_VALUE : timeout;
    }

    public boolean deploymentEnabled() {
        return this.kernalContext().deploy().enabled();
    }

    public byte dataCenterId() {
        GridCacheContext cacheCtx = F.first(this.cacheContexts());
        return cacheCtx.dataCenterId();
    }

    public TransactionMetricsAdapter txMetrics() {
        return this.txMetrics;
    }

    public void resetTxMetrics() {
        this.txMetrics = new TransactionMetricsAdapter();
    }

    public IgniteTxManager tm() {
        return this.txMgr;
    }

    public CacheJtaManagerAdapter jta() {
        return this.jtaMgr;
    }

    public GridCachePartitionExchangeManager<K, V> exchange() {
        return this.exchMgr;
    }

    public CacheAffinitySharedManager<K, V> affinity() {
        return this.affMgr;
    }

    public GridCacheVersionManager versions() {
        return this.verMgr;
    }

    public GridCacheMvccManager mvcc() {
        return this.mvccMgr;
    }

    public GridCacheIoManager io() {
        return this.ioMgr;
    }

    public GridCacheSharedTtlCleanupManager ttl() {
        return this.ttlMgr;
    }

    public GridCacheDeploymentManager<K, V> deploy() {
        return this.depMgr;
    }

    public Marshaller marshaller() {
        return this.kernalCtx.config().getMarshaller();
    }

    public IgniteConfiguration gridConfig() {
        return this.kernalCtx.config();
    }

    public GridKernalContext kernalContext() {
        return this.kernalCtx;
    }

    public GridIoManager gridIO() {
        return this.kernalCtx.io();
    }

    public GridDeploymentManager gridDeploy() {
        return this.kernalCtx.deploy();
    }

    public GridEventStorageManager gridEvents() {
        return this.kernalCtx.event();
    }

    public GridDiscoveryManager discovery() {
        return this.kernalCtx.discovery();
    }

    public GridTimeoutProcessor time() {
        return this.kernalCtx.timeout();
    }

    public UUID localNodeId() {
        return this.kernalCtx.localNodeId();
    }

    public ClusterNode localNode() {
        return this.kernalCtx.discovery().localNode();
    }

    public int getLocalStoreCount() {
        return this.locStoreCnt.get();
    }

    @Nullable
    public ClusterNode node(UUID nodeId) {
        return this.kernalCtx.discovery().node(nodeId);
    }

    public boolean localStorePrimaryOnly() {
        return this.locStorePrimaryOnly;
    }

    public IgniteLogger logger(Class<?> cls) {
        return this.kernalCtx.log(cls);
    }

    public IgniteLogger logger(String category) {
        return this.kernalCtx.log(category);
    }

    public IgniteInternalFuture<?> partitionReleaseFuture(AffinityTopologyVersion topVer) {
        GridCompoundFuture f = new GridCompoundFuture();
        f.add(this.mvcc().finishExplicitLocks(topVer));
        f.add(this.tm().finishTxs(topVer));
        f.add(this.mvcc().finishAtomicUpdates(topVer));
        f.add(this.mvcc().finishDataStreamerUpdates());
        f.markInitialized();
        return f;
    }

    public IgniteInternalFuture<?> nextAffinityReadyFuture(AffinityTopologyVersion curVer) {
        if (curVer == null) {
            return null;
        }
        AffinityTopologyVersion nextVer = new AffinityTopologyVersion(curVer.topologyVersion() + 1L);
        GridFinishedFuture fut = this.exchMgr.affinityReadyFuture(nextVer);
        return fut == null ? new GridFinishedFuture() : fut;
    }

    @Nullable
    public String verifyTxCompatibility(IgniteInternalTx tx, GridLongList activeCacheIds, GridCacheContext<K, V> cacheCtx) {
        if (cacheCtx.systemTx() && !tx.system()) {
            return "system cache can be enlisted only in system transaction";
        }
        if (!cacheCtx.systemTx() && tx.system()) {
            return "non-system cache can't be enlisted in system transaction";
        }
        for (int i = 0; i < activeCacheIds.size(); ++i) {
            int cacheId = (int)activeCacheIds.get(i);
            GridCacheContext<K, V> activeCacheCtx = this.cacheContext(cacheId);
            if (cacheCtx.systemTx() && activeCacheCtx.cacheId() != cacheCtx.cacheId()) {
                return "system transaction can include only one cache";
            }
            CacheStoreManager store = cacheCtx.store();
            CacheStoreManager activeStore = activeCacheCtx.store();
            if (store.isLocal() != activeStore.isLocal()) {
                return "caches with local and non-local stores can't be enlisted in one transaction";
            }
            if (store.isWriteBehind() != activeStore.isWriteBehind()) {
                return "caches with different write-behind setting can't be enlisted in one transaction";
            }
            if (activeCacheCtx.deploymentEnabled() != cacheCtx.deploymentEnabled()) {
                return "caches with enabled and disabled deployment modes can't be enlisted in one transaction";
            }
            assert (store.isWriteToStoreFromDht() == activeStore.isWriteToStoreFromDht());
        }
        return null;
    }

    @Nullable
    public AffinityTopologyVersion lockedTopologyVersion(IgniteInternalTx ignore) {
        long threadId = Thread.currentThread().getId();
        AffinityTopologyVersion topVer = this.txMgr.lockedTopologyVersion(threadId, ignore);
        if (topVer == null) {
            topVer = this.mvccMgr.lastExplicitLockTopologyVersion(threadId);
        }
        return topVer;
    }

    public void cleanup() {
        this.mvccMgr = null;
        this.mgrs.clear();
    }

    public void endTx(IgniteInternalTx tx) throws IgniteCheckedException {
        tx.txState().awaitLastFut(this);
        tx.close();
    }

    public IgniteInternalFuture<IgniteInternalTx> commitTxAsync(IgniteInternalTx tx) {
        GridCacheContext ctx = tx.txState().singleCacheContext(this);
        if (ctx == null) {
            tx.txState().awaitLastFut(this);
            return tx.commitAsync();
        }
        return ctx.cache().commitTxAsync(tx);
    }

    public IgniteInternalFuture rollbackTxAsync(IgniteInternalTx tx) throws IgniteCheckedException {
        tx.txState().awaitLastFut(this);
        return tx.rollbackAsync();
    }

    @Nullable
    public Collection<CacheStoreSessionListener> storeSessionListeners() {
        return this.storeSesLsnrs;
    }

    @Nullable
    private <T extends GridCacheSharedManager<K, V>> T add(List<GridCacheSharedManager<K, V>> mgrs, @Nullable T mgr) {
        if (mgr != null) {
            mgrs.add(mgr);
        }
        return mgr;
    }

    public void txContextReset() {
        this.mvccMgr.contextReset();
    }
}

