/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.cache.GridCacheSharedManagerAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheTtlManager;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.thread.IgniteThread;

public class GridCacheSharedTtlCleanupManager
extends GridCacheSharedManagerAdapter {
    private static final long CLEANUP_WORKER_SLEEP_INTERVAL = 500L;
    private static final int CLEANUP_WORKER_ENTRIES_PROCESS_LIMIT = 1000;
    private CleanupWorker cleanupWorker;
    private final Object mux = new Object();
    private List<GridCacheTtlManager> mgrs = new CopyOnWriteArrayList<GridCacheTtlManager>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onKernalStop0(boolean cancel) {
        Object object = this.mux;
        synchronized (object) {
            this.stopCleanupWorker();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(GridCacheTtlManager mgr) {
        Object object = this.mux;
        synchronized (object) {
            if (this.cleanupWorker == null) {
                this.startCleanupWorker();
            }
            this.mgrs.add(mgr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(GridCacheTtlManager mgr) {
        Object object = this.mux;
        synchronized (object) {
            this.mgrs.remove(mgr);
            if (this.mgrs.isEmpty()) {
                this.stopCleanupWorker();
            }
        }
    }

    private void startCleanupWorker() {
        this.cleanupWorker = new CleanupWorker();
        new IgniteThread(this.cleanupWorker).start();
    }

    private void stopCleanupWorker() {
        if (null != this.cleanupWorker) {
            U.cancel(this.cleanupWorker);
            U.join(this.cleanupWorker, this.log);
            this.cleanupWorker = null;
        }
    }

    private class CleanupWorker
    extends GridWorker {
        CleanupWorker() {
            super(GridCacheSharedTtlCleanupManager.this.cctx.gridName(), "ttl-cleanup-worker", GridCacheSharedTtlCleanupManager.this.cctx.logger(GridCacheSharedTtlCleanupManager.class));
        }

        @Override
        protected void body() throws InterruptedException, IgniteInterruptedCheckedException {
            while (!this.isCancelled()) {
                boolean expiredRemains = false;
                for (GridCacheTtlManager mgr : GridCacheSharedTtlCleanupManager.this.mgrs) {
                    if (mgr.expire(1000)) {
                        expiredRemains = true;
                    }
                    if (!this.isCancelled()) continue;
                    return;
                }
                if (expiredRemains) continue;
                U.sleep(500L);
            }
        }
    }
}

