/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheSwapEntry;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionEx;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class GridCacheSwapEntryImpl
implements GridCacheSwapEntry {
    static final int EXPIRE_TIME_OFFSET = 8;
    static final int VERSION_OFFSET = 16;
    static final int VERSION_SIZE = 24;
    static final int VERSION_EX_SIZE = 48;
    static final int GUID_SIZE = 24;
    private ByteBuffer valBytes;
    private CacheObject val;
    private byte type;
    private IgniteUuid keyClsLdrId;
    private IgniteUuid valClsLdrId;
    private GridCacheVersion ver;
    private long ttl;
    private long expireTime;

    public GridCacheSwapEntryImpl(ByteBuffer valBytes, byte type, GridCacheVersion ver, long ttl, long expireTime, @Nullable IgniteUuid keyClsLdrId, @Nullable IgniteUuid valClsLdrId) {
        this.valBytes = valBytes;
        this.type = type;
        this.ver = ver;
        this.ttl = ttl;
        this.expireTime = expireTime;
        this.valClsLdrId = valClsLdrId;
        this.keyClsLdrId = keyClsLdrId;
    }

    public static long timeToLive(byte[] bytes) {
        return GridUnsafe.getLong(bytes, GridUnsafe.BYTE_ARR_OFF);
    }

    public static long expireTime(byte[] bytes) {
        return GridUnsafe.getLong(bytes, GridUnsafe.BYTE_ARR_OFF + 8L);
    }

    public static GridCacheVersion version(byte[] bytes) {
        long off = GridUnsafe.BYTE_ARR_OFF + 16L;
        boolean verEx = GridUnsafe.getByte(bytes, off++) != 0;
        return U.readVersion(bytes, off, verEx);
    }

    @Nullable
    public static IgniteBiTuple<byte[], Byte> getValue(byte[] bytes) {
        long off = GridUnsafe.BYTE_ARR_OFF + 16L;
        boolean verEx = GridUnsafe.getByte(bytes, off++) != 0;
        int arrLen = GridUnsafe.getInt(bytes, off += verEx ? 48L : 24L);
        off += 4L;
        byte type = GridUnsafe.getByte(bytes, off++);
        byte[] valBytes = new byte[arrLen];
        GridUnsafe.copyMemory(bytes, off, valBytes, GridUnsafe.BYTE_ARR_OFF, arrLen);
        return new IgniteBiTuple<byte[], Byte>(valBytes, type);
    }

    @Override
    public byte[] valueBytes() {
        if (this.valBytes != null) {
            assert (this.valBytes.capacity() == this.valBytes.limit());
            return this.valBytes.array();
        }
        return null;
    }

    @Override
    public void valueBytes(@Nullable byte[] valBytes) {
        this.valBytes = valBytes != null ? ByteBuffer.wrap(valBytes) : null;
    }

    @Override
    public CacheObject value() {
        return this.val;
    }

    @Override
    public void value(CacheObject val) {
        this.val = val;
    }

    @Override
    public byte type() {
        return this.type;
    }

    @Override
    public GridCacheVersion version() {
        return this.ver;
    }

    @Override
    public long ttl() {
        return this.ttl;
    }

    @Override
    public long expireTime() {
        return this.expireTime;
    }

    @Override
    @Nullable
    public IgniteUuid keyClassLoaderId() {
        return this.keyClsLdrId;
    }

    @Override
    @Nullable
    public IgniteUuid valueClassLoaderId() {
        return this.valClsLdrId;
    }

    @Override
    public long offheapPointer() {
        return 0L;
    }

    public byte[] marshal() {
        int size = 17 + (this.ver instanceof GridCacheVersionEx ? 48 : 24);
        ++size;
        int len = this.valBytes.limit();
        size += len + 4;
        size += this.valClsLdrId == null ? 1 : 25;
        byte[] arr = new byte[size += this.keyClsLdrId == null ? 1 : 25];
        long off = GridUnsafe.BYTE_ARR_OFF;
        GridUnsafe.putLong(arr, off, this.ttl);
        GridUnsafe.putLong(arr, off += 8L, this.expireTime);
        off += 8L;
        off = U.writeVersion(arr, off, this.ver);
        GridUnsafe.putInt(arr, off, len);
        off += 4L;
        GridUnsafe.putByte(arr, off++, this.type);
        GridUnsafe.copyMemory(this.valBytes.array(), GridUnsafe.BYTE_ARR_OFF, arr, off, len);
        off += (long)len;
        off = U.writeGridUuid(arr, off, this.valClsLdrId);
        U.writeGridUuid(arr, off, this.keyClsLdrId);
        return arr;
    }

    public static GridCacheSwapEntryImpl unmarshal(byte[] arr, boolean valOnly) {
        if (valOnly) {
            long off = GridUnsafe.BYTE_ARR_OFF + 16L;
            boolean verEx = GridUnsafe.getByte(arr, off++) != 0;
            int arrLen = GridUnsafe.getInt(arr, off += verEx ? 48L : 24L);
            off += 4L;
            byte type = GridUnsafe.getByte(arr, off++);
            byte[] valBytes = new byte[arrLen];
            GridUnsafe.copyMemory(arr, off, valBytes, GridUnsafe.BYTE_ARR_OFF, arrLen);
            return new GridCacheSwapEntryImpl(ByteBuffer.wrap(valBytes), type, null, 0L, 0L, null, null);
        }
        long off = GridUnsafe.BYTE_ARR_OFF;
        long ttl = GridUnsafe.getLong(arr, off);
        long expireTime = GridUnsafe.getLong(arr, off += 8L);
        off += 8L;
        boolean verEx = GridUnsafe.getBoolean(arr, off++);
        GridCacheVersion ver = U.readVersion(arr, off, verEx);
        int arrLen = GridUnsafe.getInt(arr, off += verEx ? 48L : 24L);
        off += 4L;
        byte type = GridUnsafe.getByte(arr, off++);
        byte[] valBytes = new byte[arrLen];
        GridUnsafe.copyMemory(arr, off, valBytes, GridUnsafe.BYTE_ARR_OFF, arrLen);
        IgniteUuid valClsLdrId = U.readGridUuid(arr, off += (long)arrLen);
        IgniteUuid keyClsLdrId = U.readGridUuid(arr, off += valClsLdrId == null ? 1L : 25L);
        return new GridCacheSwapEntryImpl(ByteBuffer.wrap(valBytes), type, ver, ttl, expireTime, keyClsLdrId, valClsLdrId);
    }

    public String toString() {
        return S.toString(GridCacheSwapEntryImpl.class, this);
    }
}

