/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.lang.ref.ReferenceQueue;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.cache.Cache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CacheMemoryMode;
import org.apache.ignite.internal.managers.swapspace.GridSwapSpaceManager;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryImpl0;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheBatchSwapEntry;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheManagerAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheOffheapSwapEntry;
import org.apache.ignite.internal.processors.cache.GridCacheSwapEntry;
import org.apache.ignite.internal.processors.cache.GridCacheSwapEntryImpl;
import org.apache.ignite.internal.processors.cache.GridCacheSwapListener;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryManager;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionAware;
import org.apache.ignite.internal.processors.offheap.GridOffHeapProcessor;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.util.GridCloseableIteratorAdapter;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.GridEmptyCloseableIterator;
import org.apache.ignite.internal.util.GridEmptyIterator;
import org.apache.ignite.internal.util.GridWeakIterator;
import org.apache.ignite.internal.util.lang.GridCloseableIterator;
import org.apache.ignite.internal.util.lang.GridTuple;
import org.apache.ignite.internal.util.offheap.GridOffHeapEvictListener;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.CX2;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.spi.swapspace.SwapKey;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentHashMap8;

public class GridCacheSwapManager
extends GridCacheManagerAdapter {
    private GridSwapSpaceManager swapMgr;
    private String spaceName;
    private final boolean enabled;
    private boolean swapEnabled;
    private boolean offheapEnabled;
    private final ConcurrentMap<Integer, Collection<GridCacheSwapListener>> swapLsnrs = new ConcurrentHashMap8<Integer, Collection<GridCacheSwapListener>>();
    private final ConcurrentMap<Integer, Collection<GridCacheSwapListener>> offheapLsnrs = new ConcurrentHashMap8<Integer, Collection<GridCacheSwapListener>>();
    private GridOffHeapProcessor offheap;
    private final ReferenceQueue<Iterator<Map.Entry>> itQ = new ReferenceQueue();
    private final Collection<GridWeakIterator<Map.Entry>> itSet = new GridConcurrentHashSet<GridWeakIterator<Map.Entry>>();
    private boolean unwindOffheapEvicts;
    private ThreadLocal<Collection<IgniteBiTuple<byte[], byte[]>>> offheapEvicts = new ThreadLocal();
    private volatile boolean firstEvictWarn;

    public GridCacheSwapManager(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void start0() throws IgniteCheckedException {
        this.spaceName = CU.swapSpaceName(this.cctx);
        this.swapMgr = this.cctx.gridSwap();
        this.offheap = this.cctx.offheap();
        this.swapEnabled = this.enabled && this.cctx.config().isSwapEnabled() && this.cctx.kernalContext().swap().enabled();
        boolean bl = this.offheapEnabled = this.enabled && this.cctx.config().getOffHeapMaxMemory() >= 0L && (this.cctx.config().getMemoryMode() == CacheMemoryMode.ONHEAP_TIERED || this.cctx.config().getMemoryMode() == CacheMemoryMode.OFFHEAP_TIERED);
        if (this.offheapEnabled) {
            this.initOffHeap();
        }
    }

    @Override
    protected void stop0(boolean cancel) {
        if (this.offheapEnabled) {
            this.offheap.destruct(this.spaceName);
        }
        try {
            this.clearSwap();
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to clear cache swap space", e);
        }
    }

    public void unwindOffheapEvicts() {
        if (!this.unwindOffheapEvicts) {
            return;
        }
        Collection<IgniteBiTuple<byte[], byte[]>> evicts = this.offheapEvicts.get();
        if (evicts != null) {
            GridCacheVersion obsoleteVer = this.cctx.versions().next();
            block5: for (IgniteBiTuple<byte[], byte[]> t : evicts) {
                try {
                    byte[] kb = t.get1();
                    byte[] vb = t.get2();
                    GridCacheVersion evictVer = GridCacheSwapEntryImpl.version(vb);
                    KeyCacheObject key = this.cctx.toCacheKeyObject(kb);
                    while (true) {
                        GridCacheEntryEx entry = this.cctx.cache().entryEx(key);
                        try {
                            if (!entry.onOffheapEvict(vb, evictVer, obsoleteVer)) continue block5;
                            this.cctx.cache().removeEntry(entry);
                            continue block5;
                        }
                        catch (GridCacheEntryRemovedException gridCacheEntryRemovedException) {
                            continue;
                        }
                        break;
                    }
                }
                catch (GridDhtInvalidPartitionException kb) {
                }
                catch (IgniteCheckedException e) {
                    U.error(this.log, "Failed to unmarshal off-heap entry", e);
                }
            }
            this.offheapEvicts.set(null);
        }
    }

    private void initOffHeap() {
        GridOffHeapEvictListener lsnr;
        assert (this.offheapEnabled);
        long max = this.cctx.config().getOffHeapMaxMemory();
        long init = max > 0L ? max / 1024L : 0x800000L;
        int parts = this.cctx.config().getAffinity().partitions();
        if (this.swapEnabled || GridQueryProcessor.isEnabled(this.cctx.config())) {
            this.unwindOffheapEvicts = true;
            lsnr = new GridOffHeapEvictListener(){

                @Override
                public void onEvict(int part, int hash, byte[] kb, byte[] vb) {
                    assert (GridCacheSwapManager.this.unwindOffheapEvicts);
                    GridCacheSwapManager.this.onOffheapEvict();
                    ArrayList<IgniteBiTuple<byte[], byte[]>> evicts = (ArrayList<IgniteBiTuple<byte[], byte[]>>)GridCacheSwapManager.this.offheapEvicts.get();
                    if (evicts == null) {
                        evicts = new ArrayList<IgniteBiTuple<byte[], byte[]>>();
                        GridCacheSwapManager.this.offheapEvicts.set(evicts);
                    }
                    evicts.add(new IgniteBiTuple<byte[], byte[]>(kb, vb));
                }

                @Override
                public boolean removeEvicted() {
                    return false;
                }
            };
        } else {
            lsnr = new GridOffHeapEvictListener(){

                @Override
                public void onEvict(int part, int hash, byte[] kb, byte[] vb) {
                    GridCacheSwapManager.this.onOffheapEvict();
                }

                @Override
                public boolean removeEvicted() {
                    return true;
                }
            };
        }
        this.offheap.create(this.spaceName, parts, init, max, lsnr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onOffheapEvict() {
        if (this.cctx.config().isStatisticsEnabled()) {
            this.cctx.cache().metrics0().onOffHeapEvict();
        }
        if (this.firstEvictWarn) {
            return;
        }
        GridCacheSwapManager gridCacheSwapManager = this;
        synchronized (gridCacheSwapManager) {
            if (this.firstEvictWarn) {
                return;
            }
            this.firstEvictWarn = true;
        }
        U.warn(this.log, "Off-heap evictions started. You may wish to increase 'offHeapMaxMemory' in cache configuration [cache=" + this.cctx.name() + ", offHeapMaxMemory=" + this.cctx.config().getOffHeapMaxMemory() + ']', "Off-heap evictions started: " + this.cctx.name());
    }

    public boolean swapEnabled() {
        return this.swapEnabled;
    }

    public boolean offHeapEnabled() {
        return this.offheapEnabled;
    }

    public long swapSize() throws IgniteCheckedException {
        return this.enabled ? this.swapMgr.swapSize(this.spaceName) : -1L;
    }

    public int swapEntriesCount(boolean primary, boolean backup, AffinityTopologyVersion topVer) throws IgniteCheckedException {
        assert (primary || backup);
        if (!this.swapEnabled) {
            return 0;
        }
        if (!primary || !backup) {
            Set<Integer> parts = primary ? this.cctx.affinity().primaryPartitions(this.cctx.localNodeId(), topVer) : this.cctx.affinity().backupPartitions(this.cctx.localNodeId(), topVer);
            return (int)this.swapMgr.swapKeys(this.spaceName, parts);
        }
        return (int)this.swapMgr.swapKeys(this.spaceName);
    }

    public long swapEntriesCount(int partId) throws IgniteCheckedException {
        if (!this.swapEnabled) {
            return 0L;
        }
        return this.swapMgr.swapKeys(this.spaceName, Collections.singleton(partId));
    }

    public int offheapEntriesCount(boolean primary, boolean backup, AffinityTopologyVersion topVer) throws IgniteCheckedException {
        assert (primary || backup);
        if (!this.offheapEnabled) {
            return 0;
        }
        if (!primary || !backup) {
            Set<Integer> parts = primary ? this.cctx.affinity().primaryPartitions(this.cctx.localNodeId(), topVer) : this.cctx.affinity().backupPartitions(this.cctx.localNodeId(), topVer);
            return (int)this.offheap.entriesCount(this.spaceName, parts);
        }
        return (int)this.offheap.entriesCount(this.spaceName);
    }

    public long offheapEntriesCount(int partId) throws IgniteCheckedException {
        if (!this.offheapEnabled) {
            return 0L;
        }
        return this.offheap.entriesCount(this.spaceName, Collections.singleton(partId));
    }

    public long swapKeys() throws IgniteCheckedException {
        return this.enabled ? this.swapMgr.swapKeys(this.spaceName) : -1L;
    }

    private void onUnswapped(int part, KeyCacheObject key, GridCacheSwapEntry e) throws IgniteCheckedException {
        this.onEntryUnswapped(this.swapLsnrs, part, key, e);
    }

    private void onOffHeaped(int part, KeyCacheObject key, GridCacheSwapEntry e) throws IgniteCheckedException {
        this.onEntryUnswapped(this.offheapLsnrs, part, key, e);
    }

    private void onEntryUnswapped(ConcurrentMap<Integer, Collection<GridCacheSwapListener>> map, int part, KeyCacheObject key, GridCacheSwapEntry e) throws IgniteCheckedException {
        Collection lsnrs = (Collection)map.get(part);
        if (lsnrs == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Skipping unswapped notification [key=" + key + ", part=" + part + ']');
            }
            return;
        }
        for (GridCacheSwapListener lsnr : lsnrs) {
            lsnr.onEntryUnswapped(part, key, e);
        }
    }

    public void addSwapListener(int part, GridCacheSwapListener lsnr) {
        this.addListener(part, this.swapLsnrs, lsnr);
    }

    public void removeSwapListener(int part, GridCacheSwapListener lsnr) {
        this.removeListener(part, this.swapLsnrs, lsnr);
    }

    public void addOffHeapListener(int part, GridCacheSwapListener lsnr) {
        this.addListener(part, this.offheapLsnrs, lsnr);
    }

    public void removeOffHeapListener(int part, GridCacheSwapListener lsnr) {
        this.removeListener(part, this.offheapLsnrs, lsnr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addListener(int part, ConcurrentMap<Integer, Collection<GridCacheSwapListener>> map, GridCacheSwapListener lsnr) {
        Collection<GridCacheSwapListener> lsnrs = (Collection<GridCacheSwapListener>)map.get(part);
        while (true) {
            if (lsnrs != null) {
                Collection<GridCacheSwapListener> collection = lsnrs;
                synchronized (collection) {
                    if (!lsnrs.isEmpty()) {
                        lsnrs.add(lsnr);
                        break;
                    }
                }
                lsnrs = this.swapLsnrs.remove(part, lsnrs) ? null : (Collection)this.swapLsnrs.get(part);
                continue;
            }
            lsnrs = new GridConcurrentHashSet<GridCacheSwapListener>(){

                @Override
                public boolean equals(Object o) {
                    return o == this;
                }
            };
            lsnrs.add(lsnr);
            Collection<GridCacheSwapListener> old = this.swapLsnrs.putIfAbsent(part, lsnrs);
            if (old == null) break;
            lsnrs = old;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeListener(int part, ConcurrentMap<Integer, Collection<GridCacheSwapListener>> map, GridCacheSwapListener lsnr) {
        Collection lsnrs = (Collection)map.get(part);
        if (lsnrs != null) {
            boolean empty;
            Collection collection = lsnrs;
            synchronized (collection) {
                lsnrs.remove(lsnr);
                empty = lsnrs.isEmpty();
            }
            if (empty) {
                map.remove(part, lsnrs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIteratorQueue() {
        GridWeakIterator it;
        do {
            it = (GridWeakIterator)this.itQ.poll();
            try {
                if (it == null) continue;
                it.close();
            }
            catch (IgniteCheckedException e) {
                this.log.error("Failed to close iterator.", e);
            }
            finally {
                if (it != null) {
                    this.itSet.remove(it);
                }
            }
        } while (it != null);
    }

    @Nullable
    private <X extends GridCacheSwapEntry> X swapEntry(X e) throws IgniteCheckedException {
        assert (e != null);
        this.checkIteratorQueue();
        CacheObject val = this.cctx.unswapCacheObject(e.type(), e.valueBytes(), e.valueClassLoaderId());
        if (val == null) {
            return null;
        }
        e.value(val);
        return e;
    }

    public boolean containsKey(KeyCacheObject key, int part) throws IgniteCheckedException {
        if (!this.offheapEnabled && !this.swapEnabled) {
            return false;
        }
        this.checkIteratorQueue();
        if (this.offheapEnabled) {
            boolean contains = this.offheap.contains(this.spaceName, part, key, key.valueBytes(this.cctx.cacheObjectContext()));
            if (this.cctx.config().isStatisticsEnabled()) {
                this.cctx.cache().metrics0().onOffHeapRead(contains);
            }
            if (contains) {
                return true;
            }
        }
        if (this.swapEnabled) {
            assert (key != null);
            byte[] valBytes = this.swapMgr.read(this.spaceName, new SwapKey(key, part, key.valueBytes(this.cctx.cacheObjectContext())), this.cctx.deploy().globalLoader());
            if (this.cctx.config().isStatisticsEnabled()) {
                this.cctx.cache().metrics0().onSwapRead(valBytes != null);
            }
            return valBytes != null;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private GridCacheSwapEntry read(KeyCacheObject key, byte[] keyBytes, int part, boolean entryLocked, boolean readOffheap, boolean readSwap, boolean valOnly) throws IgniteCheckedException {
        GridCacheSwapEntry gridCacheSwapEntry;
        byte[] bytes;
        KeySwapListener lsnr;
        block17: {
            block16: {
                block15: {
                    assert (readOffheap || readSwap);
                    if (!this.offheapEnabled && !this.swapEnabled) {
                        return null;
                    }
                    this.checkIteratorQueue();
                    lsnr = null;
                    try {
                        if (this.offheapEnabled && this.swapEnabled && !entryLocked) {
                            lsnr = new KeySwapListener(key);
                            this.addSwapListener(part, lsnr);
                        }
                        if (!readOffheap || !this.offheapEnabled) break block15;
                        bytes = this.offheap.get(this.spaceName, part, key, keyBytes);
                        if (this.cctx.config().isStatisticsEnabled()) {
                            this.cctx.cache().metrics0().onOffHeapRead(bytes != null);
                        }
                        if (bytes == null) break block15;
                        GridCacheSwapEntry gridCacheSwapEntry2 = this.swapEntry(this.unmarshalSwapEntry(bytes, valOnly));
                        if (lsnr != null) {
                            this.removeSwapListener(part, lsnr);
                        }
                        return gridCacheSwapEntry2;
                    }
                    catch (Throwable throwable) {
                        if (lsnr != null) {
                            this.removeSwapListener(part, lsnr);
                        }
                        throw throwable;
                    }
                }
                if (this.swapEnabled && readSwap) break block16;
                bytes = null;
                if (lsnr != null) {
                    this.removeSwapListener(part, lsnr);
                }
                return bytes;
            }
            assert (key != null);
            bytes = this.swapMgr.read(this.spaceName, new SwapKey(key, part, keyBytes), this.cctx.deploy().globalLoader());
            if (bytes != null || lsnr == null) break block17;
            GridCacheSwapEntry gridCacheSwapEntry3 = lsnr.entry;
            if (lsnr != null) {
                this.removeSwapListener(part, lsnr);
            }
            return gridCacheSwapEntry3;
        }
        GridCacheSwapEntry gridCacheSwapEntry4 = gridCacheSwapEntry = bytes != null ? this.swapEntry(this.unmarshalSwapEntry(bytes, valOnly)) : null;
        if (lsnr != null) {
            this.removeSwapListener(part, lsnr);
        }
        return gridCacheSwapEntry;
    }

    @Nullable
    GridCacheSwapEntry readAndRemove(KeyCacheObject key) throws IgniteCheckedException {
        GridCacheSwapEntry entry;
        if (!this.offheapEnabled && !this.swapEnabled) {
            return null;
        }
        this.checkIteratorQueue();
        int part = this.cctx.affinity().partition(key);
        if (this.offheapEnabled && (entry = this.removeFromOffheap(key, key.valueBytes(this.cctx.cacheObjectContext()), part)) != null) {
            this.onOffHeaped(part, key, entry);
            if (this.cctx.events().isRecordable(77)) {
                this.cctx.events().addEvent(part, key, this.cctx.nodeId(), (IgniteUuid)null, null, 77, null, false, null, true, null, null, null, false);
            }
            return entry;
        }
        return this.readAndRemoveSwap(key, part);
    }

    @Nullable
    private GridCacheSwapEntry readAndRemoveSwap(final KeyCacheObject key, final int part) throws IgniteCheckedException {
        if (!this.swapEnabled) {
            return null;
        }
        final GridTuple t = new GridTuple();
        final GridTuple err = new GridTuple();
        SwapKey swapKey = new SwapKey(key, part, key.valueBytes(this.cctx.cacheObjectContext()));
        ClassLoader ldr = this.cctx.deploy().globalLoader();
        final GridCacheQueryManager qryMgr = this.cctx.queries();
        if (qryMgr.enabled() && !this.readSwapBeforeRemove(key, swapKey, ldr)) {
            return null;
        }
        this.swapMgr.remove(this.spaceName, swapKey, (IgniteInClosure<byte[]>)new CI1<byte[]>(){

            @Override
            public void apply(byte[] rmv) {
                if (!qryMgr.enabled() && GridCacheSwapManager.this.cctx.config().isStatisticsEnabled()) {
                    GridCacheSwapManager.this.cctx.cache().metrics0().onSwapRead(rmv != null);
                }
                if (rmv != null) {
                    try {
                        GridCacheSwapEntry entry = GridCacheSwapManager.this.swapEntry(GridCacheSwapManager.this.unmarshalSwapEntry(rmv, false));
                        if (entry == null) {
                            return;
                        }
                        t.set(entry);
                        CacheObject v = entry.value();
                        if (GridCacheSwapManager.this.cctx.events().isRecordable(69)) {
                            GridCacheSwapManager.this.cctx.events().addEvent(part, key, GridCacheSwapManager.this.cctx.nodeId(), (IgniteUuid)null, null, 69, null, false, v, true, null, null, null, false);
                        }
                        if (GridCacheSwapManager.this.cctx.config().isStatisticsEnabled()) {
                            GridCacheSwapManager.this.cctx.cache().metrics0().onSwapRemove();
                        }
                        GridCacheSwapManager.this.onUnswapped(part, key, entry);
                    }
                    catch (IgniteCheckedException e) {
                        err.set(e);
                    }
                }
            }
        }, ldr);
        if (err.get() != null) {
            throw (IgniteCheckedException)err.get();
        }
        return (GridCacheSwapEntry)t.get();
    }

    @Nullable
    GridCacheSwapEntry read(GridCacheEntryEx entry, boolean locked, boolean readOffheap, boolean readSwap, boolean valOnly) throws IgniteCheckedException {
        if (!this.offheapEnabled && !this.swapEnabled) {
            return null;
        }
        return this.read(entry.key(), entry.key().valueBytes(this.cctx.cacheObjectContext()), entry.partition(), locked, readOffheap, readSwap, valOnly);
    }

    @Nullable
    GridCacheSwapEntry readOffheapPointer(GridCacheEntryEx entry) throws IgniteCheckedException {
        if (!this.offheapEnabled) {
            return null;
        }
        KeyCacheObject key = entry.key();
        int part = this.cctx.affinity().partition(key);
        IgniteBiTuple<Long, Integer> ptr = this.offheap.valuePointer(this.spaceName, part, key, key.valueBytes(this.cctx.cacheObjectContext()));
        if (this.cctx.config().isStatisticsEnabled()) {
            this.cctx.cache().metrics0().onOffHeapRead(ptr != null);
        }
        if (ptr != null) {
            assert (ptr.get1() != null);
            assert (ptr.get2() != null);
            return new GridCacheOffheapSwapEntry(ptr.get1(), ptr.get2());
        }
        return this.readAndRemoveSwap(key, part);
    }

    @Nullable
    public CacheObject readValue(KeyCacheObject key, boolean readOffheap, boolean readSwap) throws IgniteCheckedException {
        if (!this.offheapEnabled && !this.swapEnabled) {
            return null;
        }
        int part = this.cctx.affinity().partition(key);
        GridCacheSwapEntry swapEntry = this.read(key, key.valueBytes(this.cctx.cacheObjectContext()), part, false, readOffheap, readSwap, true);
        assert (swapEntry == null || swapEntry.value() != null) : swapEntry;
        return swapEntry != null ? swapEntry.value() : null;
    }

    @Nullable
    GridCacheSwapEntry readAndRemove(GridCacheEntryEx entry) throws IgniteCheckedException {
        if (!this.offheapEnabled && !this.swapEnabled) {
            return null;
        }
        return this.readAndRemove(entry.key());
    }

    @Nullable
    private GridCacheSwapEntry removeFromOffheap(KeyCacheObject key, byte[] keyBytes, int part) throws IgniteCheckedException {
        GridCacheSwapEntry entry;
        GridCacheQueryManager qryMgr = this.cctx.queries();
        if (qryMgr.enabled()) {
            entry = this.readOffheapBeforeRemove(key, keyBytes, part);
            if (entry != null) {
                if (this.offheap.removex(this.spaceName, part, key, keyBytes)) {
                    if (this.cctx.config().isStatisticsEnabled()) {
                        this.cctx.cache().metrics0().onOffHeapRemove();
                    }
                } else {
                    entry = null;
                }
            }
        } else {
            byte[] entryBytes = this.offheap.remove(this.spaceName, part, key, keyBytes);
            if (this.cctx.config().isStatisticsEnabled()) {
                this.cctx.cache().metrics0().onOffHeapRead(entryBytes != null);
                if (entryBytes != null) {
                    this.cctx.cache().metrics0().onOffHeapRemove();
                }
            }
            entry = entryBytes == null ? null : this.swapEntry(this.unmarshalSwapEntry(entryBytes, false));
        }
        return entry;
    }

    public Collection<GridCacheBatchSwapEntry> readAndRemove(Collection<? extends KeyCacheObject> keys) throws IgniteCheckedException {
        if (!this.offheapEnabled && !this.swapEnabled) {
            return Collections.emptyList();
        }
        this.checkIteratorQueue();
        final GridCacheQueryManager qryMgr = this.cctx.queries();
        ArrayList<SwapKey> unprocessedKeys = null;
        final ArrayList<GridCacheBatchSwapEntry> res = new ArrayList<GridCacheBatchSwapEntry>(keys.size());
        if (this.offheapEnabled) {
            for (KeyCacheObject keyCacheObject : keys) {
                int part = this.cctx.affinity().partition(keyCacheObject);
                GridCacheSwapEntry entry = this.removeFromOffheap(keyCacheObject, keyCacheObject.valueBytes(this.cctx.cacheObjectContext()), part);
                if (entry != null) {
                    this.onOffHeaped(part, keyCacheObject, entry);
                    if (this.cctx.events().isRecordable(77)) {
                        this.cctx.events().addEvent(part, keyCacheObject, this.cctx.nodeId(), (IgniteUuid)null, null, 77, null, false, null, true, null, null, null, false);
                    }
                    GridCacheBatchSwapEntry unswapped = new GridCacheBatchSwapEntry(keyCacheObject, part, ByteBuffer.wrap(entry.valueBytes()), entry.type(), entry.version(), entry.ttl(), entry.expireTime(), entry.keyClassLoaderId(), entry.valueClassLoaderId());
                    unswapped.value(entry.value());
                    res.add(unswapped);
                    continue;
                }
                if (!this.swapEnabled) continue;
                if (unprocessedKeys == null) {
                    unprocessedKeys = new ArrayList(keys.size());
                }
                SwapKey swapKey = new SwapKey(keyCacheObject, this.cctx.affinity().partition(keyCacheObject), keyCacheObject.valueBytes(this.cctx.cacheObjectContext()));
                unprocessedKeys.add(swapKey);
            }
            if (unprocessedKeys == null) {
                return res;
            }
        } else {
            unprocessedKeys = new ArrayList<SwapKey>(keys.size());
            for (KeyCacheObject keyCacheObject : keys) {
                SwapKey swapKey = new SwapKey(keyCacheObject, this.cctx.affinity().partition(keyCacheObject), keyCacheObject.valueBytes(this.cctx.cacheObjectContext()));
                unprocessedKeys.add(swapKey);
            }
        }
        assert (this.swapEnabled);
        assert (unprocessedKeys != null);
        ClassLoader ldr = this.cctx.deploy().globalLoader();
        if (qryMgr.enabled()) {
            Iterator iterator = unprocessedKeys.iterator();
            while (iterator.hasNext()) {
                if (this.readSwapBeforeRemove(null, (SwapKey)iterator.next(), ldr)) continue;
                iterator.remove();
            }
        }
        final GridTuple gridTuple = new GridTuple();
        this.swapMgr.removeAll(this.spaceName, unprocessedKeys, new IgniteBiInClosure<SwapKey, byte[]>(){

            @Override
            public void apply(SwapKey swapKey, byte[] rmv) {
                if (!qryMgr.enabled() && GridCacheSwapManager.this.cctx.config().isStatisticsEnabled()) {
                    GridCacheSwapManager.this.cctx.cache().metrics0().onSwapRead(rmv != null);
                }
                if (rmv != null) {
                    try {
                        GridCacheSwapEntry entry = GridCacheSwapManager.this.swapEntry(GridCacheSwapManager.this.unmarshalSwapEntry(rmv, false));
                        if (entry == null) {
                            return;
                        }
                        KeyCacheObject key = GridCacheSwapManager.this.cctx.toCacheKeyObject(swapKey.keyBytes());
                        GridCacheBatchSwapEntry unswapped = new GridCacheBatchSwapEntry(key, swapKey.partition(), ByteBuffer.wrap(entry.valueBytes()), entry.type(), entry.version(), entry.ttl(), entry.expireTime(), entry.keyClassLoaderId(), entry.valueClassLoaderId());
                        unswapped.value(entry.value());
                        res.add(unswapped);
                        if (GridCacheSwapManager.this.cctx.events().isRecordable(69)) {
                            GridCacheSwapManager.this.cctx.events().addEvent(swapKey.partition(), key, GridCacheSwapManager.this.cctx.nodeId(), (IgniteUuid)null, null, 69, null, false, entry.value(), true, null, null, null, false);
                        }
                        if (GridCacheSwapManager.this.cctx.config().isStatisticsEnabled()) {
                            GridCacheSwapManager.this.cctx.cache().metrics0().onSwapRemove();
                        }
                        GridCacheSwapManager.this.onUnswapped(swapKey.partition(), key, entry);
                    }
                    catch (IgniteCheckedException e) {
                        gridTuple.set(e);
                    }
                }
            }
        }, ldr);
        if (gridTuple.get() != null) {
            throw (IgniteCheckedException)gridTuple.get();
        }
        return res;
    }

    boolean removeOffheap(KeyCacheObject key) throws IgniteCheckedException {
        assert (this.offheapEnabled);
        this.checkIteratorQueue();
        int part = this.cctx.affinity().partition(key);
        boolean rmv = this.offheap.removex(this.spaceName, part, key, key.valueBytes(this.cctx.cacheObjectContext()));
        if (rmv && this.cctx.config().isStatisticsEnabled()) {
            this.cctx.cache().metrics0().onOffHeapRemove();
        }
        return rmv;
    }

    boolean onOffheapEvict(KeyCacheObject key, byte[] entry, int part, final GridCacheVersion ver) throws IgniteCheckedException {
        assert (this.offheapEnabled);
        this.checkIteratorQueue();
        boolean rmv = this.offheap.removex(this.spaceName, part, key, key.valueBytes(this.cctx.cacheObjectContext()), new IgniteBiPredicate<Long, Integer>(){

            @Override
            public boolean apply(Long ptr, Integer len) {
                GridCacheVersion ver0 = GridCacheOffheapSwapEntry.version(ptr);
                return ver.equals(ver0);
            }
        });
        if (rmv) {
            Collection lsnrs = (Collection)this.offheapLsnrs.get(part);
            if (lsnrs != null) {
                GridCacheSwapEntry e = this.swapEntry(this.unmarshalSwapEntry(entry, false));
                for (GridCacheSwapListener lsnr : lsnrs) {
                    lsnr.onEntryUnswapped(part, key, e);
                }
            }
            if (this.swapEnabled) {
                this.cctx.swap().writeToSwap(part, key, entry);
            }
        }
        return rmv;
    }

    boolean offheapEvictionEnabled() {
        return this.offheapEnabled && this.cctx.config().getOffHeapMaxMemory() > 0L;
    }

    void enableOffheapEviction(KeyCacheObject key, int part) throws IgniteCheckedException {
        if (!this.offheapEnabled) {
            return;
        }
        this.checkIteratorQueue();
        this.offheap.enableEviction(this.spaceName, part, key, key.valueBytes(this.cctx.cacheObjectContext()));
    }

    public GridCacheSwapEntry readOffheapBeforeRemove(KeyCacheObject key, byte[] keyBytes, int part) throws IgniteCheckedException {
        GridCacheSwapEntry entry;
        assert (this.cctx.queries().enabled());
        byte[] entryBytes = this.offheap.get(this.spaceName, part, key, keyBytes);
        if (this.cctx.config().isStatisticsEnabled()) {
            this.cctx.cache().metrics0().onOffHeapRead(entryBytes != null);
        }
        if (entryBytes != null && (entry = this.swapEntry(this.unmarshalSwapEntry(entryBytes, false))) != null) {
            this.cctx.queries().onUnswap(key, entry.value());
            return entry;
        }
        return null;
    }

    private boolean readSwapBeforeRemove(@Nullable KeyCacheObject key, SwapKey swapKey, ClassLoader ldr) throws IgniteCheckedException {
        assert (this.cctx.queries().enabled());
        byte[] entryBytes = this.swapMgr.read(this.spaceName, swapKey, ldr);
        if (this.cctx.config().isStatisticsEnabled()) {
            this.cctx.cache().metrics0().onSwapRead(entryBytes != null);
        }
        if (entryBytes == null) {
            return false;
        }
        GridCacheSwapEntry entry = this.swapEntry(this.unmarshalSwapEntry(entryBytes, true));
        if (entry == null) {
            return false;
        }
        if (key == null) {
            key = this.cctx.toCacheKeyObject(swapKey.keyBytes());
        }
        this.cctx.queries().onUnswap(key, entry.value());
        return true;
    }

    public void remove(KeyCacheObject key, int part) throws IgniteCheckedException {
        if (!this.offheapEnabled && !this.swapEnabled) {
            return;
        }
        this.checkIteratorQueue();
        GridCacheQueryManager qryMgr = this.cctx.queries();
        if (this.offheapEnabled) {
            byte[] keyBytes = key.valueBytes(this.cctx.cacheObjectContext());
            if ((!qryMgr.enabled() || this.readOffheapBeforeRemove(key, keyBytes, part) != null) && this.offheap.removex(this.spaceName, part, key, keyBytes)) {
                if (this.cctx.config().isStatisticsEnabled()) {
                    this.cctx.cache().metrics0().onOffHeapRemove();
                }
                return;
            }
        }
        if (this.swapEnabled) {
            SwapKey swapKey = new SwapKey(key, part, key.valueBytes(this.cctx.cacheObjectContext()));
            ClassLoader ldr = this.cctx.deploy().globalLoader();
            if (qryMgr.enabled() && !this.readSwapBeforeRemove(key, swapKey, ldr)) {
                return;
            }
            this.swapMgr.remove(this.spaceName, swapKey, (IgniteInClosure<byte[]>)(this.cctx.config().isStatisticsEnabled() ? new CI1<byte[]>(){

                @Override
                public void apply(byte[] rmv) {
                    if (rmv != null) {
                        GridCacheSwapManager.this.cctx.cache().metrics0().onSwapRemove();
                    }
                }
            } : null), ldr);
        }
    }

    void write(KeyCacheObject key, ByteBuffer val, byte type, GridCacheVersion ver, long ttl, long expireTime, @Nullable IgniteUuid keyClsLdrId, @Nullable IgniteUuid valClsLdrId, boolean wasUnswapped) throws IgniteCheckedException {
        if (!this.offheapEnabled && !this.swapEnabled) {
            return;
        }
        this.checkIteratorQueue();
        int part = this.cctx.affinity().partition(key);
        GridCacheSwapEntryImpl entry = new GridCacheSwapEntryImpl(val, type, ver, ttl, expireTime, keyClsLdrId, valClsLdrId);
        if (this.offheapEnabled) {
            this.offheap.put(this.spaceName, part, key, key.valueBytes(this.cctx.cacheObjectContext()), entry.marshal());
            if (this.cctx.config().isStatisticsEnabled()) {
                this.cctx.cache().metrics0().onOffHeapWrite();
            }
            if (this.cctx.events().isRecordable(76)) {
                this.cctx.events().addEvent(part, key, this.cctx.nodeId(), (IgniteUuid)null, null, 76, null, false, null, true, null, null, null, false);
            }
        } else if (this.swapEnabled) {
            this.writeToSwap(part, key, entry.marshal());
        }
        GridCacheQueryManager qryMgr = this.cctx.queries();
        if (wasUnswapped && qryMgr.enabled()) {
            qryMgr.onSwap(key);
        }
    }

    void writeAll(Iterable<GridCacheBatchSwapEntry> swapped) throws IgniteCheckedException {
        assert (this.offheapEnabled || this.swapEnabled);
        this.checkIteratorQueue();
        GridCacheQueryManager qryMgr = this.cctx.queries();
        if (this.offheapEnabled) {
            for (GridCacheBatchSwapEntry swapEntry : swapped) {
                this.offheap.put(this.spaceName, swapEntry.partition(), swapEntry.key(), swapEntry.key().valueBytes(this.cctx.cacheObjectContext()), swapEntry.marshal());
                if (this.cctx.config().isStatisticsEnabled()) {
                    this.cctx.cache().metrics0().onOffHeapWrite();
                }
                if (this.cctx.events().isRecordable(76)) {
                    this.cctx.events().addEvent(swapEntry.partition(), swapEntry.key(), this.cctx.nodeId(), (IgniteUuid)null, null, 76, null, false, null, true, null, null, null, false);
                }
                if (!qryMgr.enabled()) continue;
                qryMgr.onSwap(swapEntry.key());
            }
        } else {
            LinkedHashMap<SwapKey, byte[]> batch = new LinkedHashMap<SwapKey, byte[]>();
            for (GridCacheBatchSwapEntry entry : swapped) {
                SwapKey swapKey = new SwapKey(entry.key(), entry.partition(), entry.key().valueBytes(this.cctx.cacheObjectContext()));
                batch.put(swapKey, entry.marshal());
            }
            this.swapMgr.writeAll(this.spaceName, batch, this.cctx.deploy().globalLoader());
            if (this.cctx.events().isRecordable(68)) {
                for (GridCacheBatchSwapEntry batchSwapEntry : swapped) {
                    this.cctx.events().addEvent(batchSwapEntry.partition(), batchSwapEntry.key(), this.cctx.nodeId(), (IgniteUuid)null, null, 68, null, false, null, true, null, null, null, false);
                    if (!qryMgr.enabled()) continue;
                    qryMgr.onSwap(batchSwapEntry.key());
                }
            }
            if (this.cctx.config().isStatisticsEnabled()) {
                this.cctx.cache().metrics0().onSwapWrite(batch.size());
            }
        }
    }

    public void writeToSwap(int part, KeyCacheObject key, byte[] entry) throws IgniteCheckedException {
        assert (this.swapEnabled);
        this.checkIteratorQueue();
        this.swapMgr.write(this.spaceName, new SwapKey(key, part, key.valueBytes(this.cctx.cacheObjectContext())), entry, this.cctx.deploy().globalLoader());
        if (this.cctx.config().isStatisticsEnabled()) {
            this.cctx.cache().metrics0().onSwapWrite();
        }
        if (this.cctx.events().isRecordable(68)) {
            this.cctx.events().addEvent(part, key, this.cctx.nodeId(), (IgniteUuid)null, null, 68, null, false, null, true, null, null, null, false);
        }
    }

    public void clearSwap() throws IgniteCheckedException {
        if (this.swapEnabled) {
            this.swapMgr.clear(this.spaceName);
        }
    }

    @Nullable
    public GridCloseableIterator<Map.Entry<byte[], GridCacheSwapEntry>> iterator(final int part) throws IgniteCheckedException {
        if (!this.swapEnabled() && !this.offHeapEnabled()) {
            return null;
        }
        this.checkIteratorQueue();
        if (this.offHeapEnabled() && !this.swapEnabled()) {
            return this.offHeapIterator(part);
        }
        if (this.swapEnabled() && !this.offHeapEnabled()) {
            return this.swapIterator(part);
        }
        return new GridCloseableIteratorAdapter<Map.Entry<byte[], GridCacheSwapEntry>>(){
            private GridCloseableIterator<Map.Entry<byte[], GridCacheSwapEntry>> it = GridCacheSwapManager.this.offHeapIterator(part);
            private boolean offheap = true;
            private boolean done;
            {
                this.advance();
            }

            private void advance() throws IgniteCheckedException {
                if (this.it.hasNext()) {
                    return;
                }
                this.it.close();
                if (this.offheap) {
                    this.offheap = false;
                    this.it = GridCacheSwapManager.this.swapIterator(part);
                    assert (this.it != null);
                    if (!this.it.hasNext()) {
                        this.it.close();
                        this.done = true;
                    }
                } else {
                    this.done = true;
                }
            }

            @Override
            protected Map.Entry<byte[], GridCacheSwapEntry> onNext() throws IgniteCheckedException {
                if (this.done) {
                    throw new NoSuchElementException();
                }
                Map.Entry e = (Map.Entry)this.it.next();
                this.advance();
                return e;
            }

            @Override
            protected boolean onHasNext() {
                return !this.done;
            }

            @Override
            protected void onClose() throws IgniteCheckedException {
                if (this.it != null) {
                    this.it.close();
                }
            }
        };
    }

    @Nullable
    public GridCloseableIterator<Map.Entry<byte[], byte[]>> rawIterator() throws IgniteCheckedException {
        if (!this.swapEnabled() && !this.offHeapEnabled()) {
            return new GridEmptyCloseableIterator<Map.Entry<byte[], byte[]>>();
        }
        this.checkIteratorQueue();
        if (this.offHeapEnabled() && !this.swapEnabled()) {
            return this.rawOffHeapIterator(null, true, true);
        }
        if (this.swapEnabled() && !this.offHeapEnabled()) {
            return this.rawSwapIterator(true, true);
        }
        return new GridCloseableIteratorAdapter<Map.Entry<byte[], byte[]>>(){
            private GridCloseableIterator<Map.Entry<byte[], byte[]>> it = GridCacheSwapManager.this.rawOffHeapIterator(null, true, true);
            private boolean offheapFlag = true;
            private boolean done;
            private Map.Entry<byte[], byte[]> cur;
            {
                this.advance();
            }

            private void advance() throws IgniteCheckedException {
                if (this.it.hasNext()) {
                    return;
                }
                this.it.close();
                if (this.offheapFlag) {
                    this.offheapFlag = false;
                    this.it = GridCacheSwapManager.this.rawSwapIterator(true, true);
                    if (!this.it.hasNext()) {
                        this.it.close();
                        this.done = true;
                    }
                } else {
                    this.done = true;
                }
            }

            @Override
            protected Map.Entry<byte[], byte[]> onNext() throws IgniteCheckedException {
                if (this.done) {
                    throw new NoSuchElementException();
                }
                this.cur = (Map.Entry)this.it.next();
                this.advance();
                return this.cur;
            }

            @Override
            protected boolean onHasNext() {
                return !this.done;
            }

            @Override
            protected void onRemove() throws IgniteCheckedException {
                if (this.offheapFlag) {
                    KeyCacheObject key = GridCacheSwapManager.this.cctx.toCacheKeyObject(this.cur.getKey());
                    int part = GridCacheSwapManager.this.cctx.affinity().partition(key);
                    boolean rmv = GridCacheSwapManager.this.offheap.removex(GridCacheSwapManager.this.spaceName, part, key, key.valueBytes(GridCacheSwapManager.this.cctx.cacheObjectContext()));
                    if (rmv && GridCacheSwapManager.this.cctx.config().isStatisticsEnabled()) {
                        GridCacheSwapManager.this.cctx.cache().metrics0().onOffHeapRemove();
                    }
                } else {
                    this.it.removeX();
                }
            }

            @Override
            protected void onClose() throws IgniteCheckedException {
                if (this.it != null) {
                    this.it.close();
                }
            }
        };
    }

    public <K, V> Iterator<Map.Entry<K, V>> lazySwapIterator(boolean keepBinary) throws IgniteCheckedException {
        if (!this.swapEnabled) {
            return new GridEmptyIterator<Map.Entry<K, V>>();
        }
        return this.lazyIterator(this.cctx.gridSwap().rawIterator(this.spaceName), keepBinary);
    }

    public Iterator<KeyCacheObject> offHeapKeyIterator(boolean primary, boolean backup, AffinityTopologyVersion topVer) {
        assert (primary || backup);
        if (!this.offheapEnabled) {
            return new GridEmptyIterator<KeyCacheObject>();
        }
        if (primary && backup) {
            return this.keyIterator(this.offheap.iterator(this.spaceName));
        }
        Set<Integer> parts = primary ? this.cctx.affinity().primaryPartitions(this.cctx.localNodeId(), topVer) : this.cctx.affinity().backupPartitions(this.cctx.localNodeId(), topVer);
        return new PartitionsAbstractIterator<KeyCacheObject>(parts){

            @Override
            protected Iterator<KeyCacheObject> partitionIterator(int part) throws IgniteCheckedException {
                return GridCacheSwapManager.this.keyIterator(GridCacheSwapManager.this.offheap.iterator(GridCacheSwapManager.this.spaceName, part));
            }
        };
    }

    public Iterator<KeyCacheObject> swapKeyIterator(boolean primary, boolean backup, AffinityTopologyVersion topVer) throws IgniteCheckedException {
        assert (primary || backup);
        if (!this.swapEnabled) {
            return new GridEmptyIterator<KeyCacheObject>();
        }
        if (primary && backup) {
            return this.keyIterator(this.cctx.gridSwap().rawIterator(this.spaceName));
        }
        Set<Integer> parts = primary ? this.cctx.affinity().primaryPartitions(this.cctx.localNodeId(), topVer) : this.cctx.affinity().backupPartitions(this.cctx.localNodeId(), topVer);
        return new PartitionsAbstractIterator<KeyCacheObject>(parts){

            @Override
            protected Iterator<KeyCacheObject> partitionIterator(int part) throws IgniteCheckedException {
                return GridCacheSwapManager.this.keyIterator(GridCacheSwapManager.this.swapMgr.rawIterator(GridCacheSwapManager.this.spaceName, part));
            }
        };
    }

    public <K, V> Iterator<Map.Entry<K, V>> lazyOffHeapIterator(boolean keepBinary) {
        if (!this.offheapEnabled) {
            return new GridEmptyCloseableIterator<Map.Entry<K, V>>();
        }
        return this.lazyIterator(this.offheap.iterator(this.spaceName), keepBinary);
    }

    public long offHeapEntriesCount() {
        return this.offheapEnabled ? this.offheap.entriesCount(this.spaceName) : 0L;
    }

    public long offHeapAllocatedSize() {
        return this.offheapEnabled ? this.offheap.allocatedSize(this.spaceName) : 0L;
    }

    private <K, V> Iterator<Map.Entry<K, V>> lazyIterator(final GridCloseableIterator<? extends Map.Entry<byte[], byte[]>> it, final boolean keepBinary) {
        if (it == null) {
            return new GridEmptyIterator<Map.Entry<K, V>>();
        }
        this.checkIteratorQueue();
        final GridCloseableIteratorAdapter iter = new GridCloseableIteratorAdapter<Map.Entry<K, V>>(){
            private Map.Entry<K, V> cur;

            @Override
            protected Map.Entry<K, V> onNext() {
                Map.Entry cur0 = (Map.Entry)it.next();
                this.cur = new GridVersionedMapEntry(cur0, keepBinary);
                return this.cur;
            }

            @Override
            protected boolean onHasNext() {
                return it.hasNext();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void onRemove() throws IgniteCheckedException {
                if (this.cur == null) {
                    throw new IllegalStateException("Method next() has not yet been called, or the remove() method has already been called after the last call to the next() method.");
                }
                try {
                    if (GridCacheSwapManager.this.cctx.isDht()) {
                        GridCacheSwapManager.this.cctx.dht().near().remove(this.cur.getKey());
                    } else {
                        GridCacheSwapManager.this.cctx.cache().remove(this.cur.getKey());
                    }
                }
                finally {
                    this.cur = null;
                }
            }

            @Override
            protected void onClose() throws IgniteCheckedException {
                it.close();
            }
        };
        Iterator ret = new Iterator<Map.Entry<K, V>>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                return (Map.Entry)iter.next();
            }

            @Override
            public void remove() {
                iter.remove();
            }
        };
        this.itSet.add(new GridWeakIterator(ret, iter, this.itQ));
        return ret;
    }

    private Iterator<KeyCacheObject> keyIterator(final GridCloseableIterator<? extends Map.Entry<byte[], byte[]>> it) {
        if (it == null) {
            return new GridEmptyIterator<KeyCacheObject>();
        }
        this.checkIteratorQueue();
        final GridCloseableIteratorAdapter<KeyCacheObject> iter = new GridCloseableIteratorAdapter<KeyCacheObject>(){
            private KeyCacheObject cur;

            @Override
            protected KeyCacheObject onNext() {
                try {
                    this.cur = GridCacheSwapManager.this.cctx.toCacheKeyObject((byte[])((Map.Entry)it.next()).getKey());
                    return this.cur;
                }
                catch (IgniteCheckedException e) {
                    throw new IgniteException(e);
                }
            }

            @Override
            protected boolean onHasNext() {
                return it.hasNext();
            }

            @Override
            protected void onRemove() throws IgniteCheckedException {
                throw new IllegalArgumentException();
            }

            @Override
            protected void onClose() throws IgniteCheckedException {
                it.close();
            }
        };
        Iterator<KeyCacheObject> ret = new Iterator<KeyCacheObject>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public KeyCacheObject next() {
                return (KeyCacheObject)iter.next();
            }

            @Override
            public void remove() {
                iter.remove();
            }
        };
        this.itSet.add(new GridWeakIterator<KeyCacheObject>(ret, iter, this.itQ));
        return ret;
    }

    @Nullable
    public GridCloseableIterator<Map.Entry<byte[], GridCacheSwapEntry>> offHeapIterator(int part) throws IgniteCheckedException {
        if (!this.offheapEnabled) {
            return null;
        }
        this.checkIteratorQueue();
        return new IteratorWrapper(this.offheap.iterator(this.spaceName, part));
    }

    public <T> GridCloseableIterator<T> rawOffHeapIterator(final CX2<T2<Long, Integer>, T2<Long, Integer>, T> c, @Nullable Integer part, boolean primary, boolean backup) {
        assert (c != null);
        if (!this.offheapEnabled || !primary && !backup) {
            return new GridEmptyCloseableIterator();
        }
        this.checkIteratorQueue();
        if (primary && backup) {
            if (part == null) {
                return this.offheap.iterator(this.spaceName, c);
            }
            return this.offheap.iterator(this.spaceName, c, part);
        }
        AffinityTopologyVersion ver = this.cctx.affinity().affinityTopologyVersion();
        Set<Integer> parts = part == null ? (primary ? this.cctx.affinity().primaryPartitions(this.cctx.localNodeId(), ver) : this.cctx.affinity().backupPartitions(this.cctx.localNodeId(), ver)) : Collections.singleton(part);
        return new CloseablePartitionsIterator<T, T>(parts){

            @Override
            protected GridCloseableIterator<T> partitionIterator(int part) throws IgniteCheckedException {
                return GridCacheSwapManager.this.offheap.iterator(GridCacheSwapManager.this.spaceName, c, part);
            }
        };
    }

    public GridCloseableIterator<Map.Entry<byte[], byte[]>> rawOffHeapIterator(@Nullable Integer part, boolean primary, boolean backup) {
        if (!this.offheapEnabled || !primary && !backup) {
            return new GridEmptyCloseableIterator<Map.Entry<byte[], byte[]>>();
        }
        if (primary && backup && part == null) {
            return new GridCloseableIteratorAdapter<Map.Entry<byte[], byte[]>>(){
                private GridCloseableIterator<IgniteBiTuple<byte[], byte[]>> it;
                private Map.Entry<byte[], byte[]> cur;
                {
                    this.it = GridCacheSwapManager.this.offheap.iterator(GridCacheSwapManager.this.spaceName);
                }

                @Override
                protected Map.Entry<byte[], byte[]> onNext() {
                    this.cur = (Map.Entry)this.it.next();
                    return this.cur;
                }

                @Override
                protected boolean onHasNext() {
                    return this.it.hasNext();
                }

                @Override
                protected void onRemove() throws IgniteCheckedException {
                    KeyCacheObject key = GridCacheSwapManager.this.cctx.toCacheKeyObject(this.cur.getKey());
                    int part = GridCacheSwapManager.this.cctx.affinity().partition(key);
                    boolean rmv = GridCacheSwapManager.this.offheap.removex(GridCacheSwapManager.this.spaceName, part, key, key.valueBytes(GridCacheSwapManager.this.cctx.cacheObjectContext()));
                    if (rmv && GridCacheSwapManager.this.cctx.config().isStatisticsEnabled()) {
                        GridCacheSwapManager.this.cctx.cache().metrics0().onOffHeapRemove();
                    }
                }

                @Override
                protected void onClose() throws IgniteCheckedException {
                    this.it.close();
                }
            };
        }
        AffinityTopologyVersion ver = this.cctx.affinity().affinityTopologyVersion();
        Set<Integer> parts = part == null ? (primary ? this.cctx.affinity().primaryPartitions(this.cctx.localNodeId(), ver) : this.cctx.affinity().backupPartitions(this.cctx.localNodeId(), ver)) : Collections.singleton(part);
        return new CloseablePartitionsIterator<Map.Entry<byte[], byte[]>, IgniteBiTuple<byte[], byte[]>>(parts){
            private Map.Entry<byte[], byte[]> cur;

            @Override
            protected Map.Entry<byte[], byte[]> onNext() {
                this.cur = (Map.Entry)super.onNext();
                return this.cur;
            }

            @Override
            protected GridCloseableIterator<IgniteBiTuple<byte[], byte[]>> partitionIterator(int part) throws IgniteCheckedException {
                return GridCacheSwapManager.this.offheap.iterator(GridCacheSwapManager.this.spaceName, part);
            }

            @Override
            protected void onRemove() throws IgniteCheckedException {
                KeyCacheObject key = GridCacheSwapManager.this.cctx.toCacheKeyObject(this.cur.getKey());
                int part = GridCacheSwapManager.this.cctx.affinity().partition(key);
                boolean rmv = GridCacheSwapManager.this.offheap.removex(GridCacheSwapManager.this.spaceName, part, key, key.valueBytes(GridCacheSwapManager.this.cctx.cacheObjectContext()));
                if (rmv && GridCacheSwapManager.this.cctx.config().isStatisticsEnabled()) {
                    GridCacheSwapManager.this.cctx.cache().metrics0().onOffHeapRemove();
                }
            }
        };
    }

    @Nullable
    public GridCloseableIterator<Map.Entry<byte[], GridCacheSwapEntry>> swapIterator(int part) throws IgniteCheckedException {
        if (!this.swapEnabled) {
            return null;
        }
        this.checkIteratorQueue();
        return new IteratorWrapper(this.swapMgr.rawIterator(this.spaceName, part));
    }

    public GridCloseableIterator<Map.Entry<byte[], byte[]>> rawSwapIterator(boolean primary, boolean backup) throws IgniteCheckedException {
        return this.rawSwapIterator(primary, backup, this.cctx.affinity().affinityTopologyVersion());
    }

    public GridCloseableIterator<Map.Entry<byte[], byte[]>> rawSwapIterator(boolean primary, boolean backup, AffinityTopologyVersion topVer) throws IgniteCheckedException {
        assert (topVer != null);
        if (!this.swapEnabled || !primary && !backup) {
            return new GridEmptyCloseableIterator<Map.Entry<byte[], byte[]>>();
        }
        this.checkIteratorQueue();
        if (primary && backup) {
            return this.swapMgr.rawIterator(this.spaceName);
        }
        Set<Integer> parts = primary ? this.cctx.affinity().primaryPartitions(this.cctx.localNodeId(), topVer) : this.cctx.affinity().backupPartitions(this.cctx.localNodeId(), topVer);
        return new CloseablePartitionsIterator<Map.Entry<byte[], byte[]>, Map.Entry<byte[], byte[]>>(parts){

            @Override
            protected GridCloseableIterator<Map.Entry<byte[], byte[]>> partitionIterator(int part) throws IgniteCheckedException {
                return GridCacheSwapManager.this.swapMgr.rawIterator(GridCacheSwapManager.this.spaceName, part);
            }
        };
    }

    public GridCloseableIterator<Map.Entry<byte[], byte[]>> rawSwapIterator(int part) throws IgniteCheckedException {
        if (!this.swapEnabled) {
            return new GridEmptyCloseableIterator<Map.Entry<byte[], byte[]>>();
        }
        this.checkIteratorQueue();
        return new CloseablePartitionsIterator<Map.Entry<byte[], byte[]>, Map.Entry<byte[], byte[]>>(Collections.singleton(part)){

            @Override
            protected GridCloseableIterator<Map.Entry<byte[], byte[]>> partitionIterator(int part) throws IgniteCheckedException {
                return GridCacheSwapManager.this.swapMgr.rawIterator(GridCacheSwapManager.this.spaceName, part);
            }
        };
    }

    public <K, V> Iterator<Cache.Entry<K, V>> swapIterator(boolean primary, boolean backup, AffinityTopologyVersion topVer, boolean keepBinary) throws IgniteCheckedException {
        assert (primary || backup);
        if (!this.swapEnabled) {
            return new GridEmptyIterator<Cache.Entry<K, V>>();
        }
        if (primary && backup) {
            return GridCacheSwapManager.cacheEntryIterator(this.lazySwapIterator(keepBinary));
        }
        Set<Integer> parts = primary ? this.cctx.affinity().primaryPartitions(this.cctx.localNodeId(), topVer) : this.cctx.affinity().backupPartitions(this.cctx.localNodeId(), topVer);
        return new PartitionsIterator<K, V>(parts, keepBinary){

            @Override
            protected GridCloseableIterator<? extends Map.Entry<byte[], byte[]>> nextPartition(int part) throws IgniteCheckedException {
                return GridCacheSwapManager.this.swapMgr.rawIterator(GridCacheSwapManager.this.spaceName, part);
            }
        };
    }

    public <K, V> Iterator<Cache.Entry<K, V>> offheapIterator(boolean primary, boolean backup, AffinityTopologyVersion topVer, boolean keepBinary) throws IgniteCheckedException {
        assert (primary || backup);
        if (!this.offheapEnabled) {
            return new GridEmptyIterator<Cache.Entry<K, V>>();
        }
        if (primary && backup) {
            return GridCacheSwapManager.cacheEntryIterator(this.lazyOffHeapIterator(keepBinary));
        }
        Set<Integer> parts = primary ? this.cctx.affinity().primaryPartitions(this.cctx.localNodeId(), topVer) : this.cctx.affinity().backupPartitions(this.cctx.localNodeId(), topVer);
        return new PartitionsIterator<K, V>(parts, keepBinary){

            @Override
            protected GridCloseableIterator<? extends Map.Entry<byte[], byte[]>> nextPartition(int part) {
                return GridCacheSwapManager.this.offheap.iterator(GridCacheSwapManager.this.spaceName, part);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int onUndeploy(ClassLoader ldr) {
        block13: {
            IgniteUuid ldrId = this.cctx.deploy().getClassLoaderId(ldr);
            assert (ldrId != null);
            this.checkIteratorQueue();
            try {
                GridCloseableIterator<Map.Entry<byte[], byte[]>> iter = this.rawIterator();
                if (iter == null) break block13;
                int undeployCnt = 0;
                try {
                    for (Map.Entry entry : iter) {
                        try {
                            Object val;
                            GridCacheSwapEntry swapEntry = this.unmarshalSwapEntry((byte[])entry.getValue(), false);
                            IgniteUuid valLdrId = swapEntry.valueClassLoaderId();
                            if (ldrId.equals(swapEntry.keyClassLoaderId())) {
                                if (this.log.isTraceEnabled()) {
                                    this.log.trace("onUndeploy remove key [ldrId=" + ldrId + ']');
                                }
                                iter.removeX();
                                ++undeployCnt;
                                continue;
                            }
                            if (valLdrId == null && swapEntry.value() == null && swapEntry.type() != 2 && (val = this.cctx.cacheObjects().unmarshal(this.cctx.cacheObjectContext(), swapEntry.valueBytes(), this.cctx.deploy().globalLoader())) != null) {
                                valLdrId = this.cctx.deploy().getClassLoaderId(val.getClass().getClassLoader());
                            }
                            if (this.log.isTraceEnabled()) {
                                this.log.trace("onUndeploy remove value [ldrId=" + ldrId + ']');
                            }
                            if (!ldrId.equals(valLdrId)) continue;
                            iter.removeX();
                            ++undeployCnt;
                        }
                        catch (Exception ex) {
                            U.error(this.log, "Failed to process swap entry.", ex);
                        }
                    }
                }
                finally {
                    iter.close();
                }
                return undeployCnt;
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Failed to clear cache swap space on undeploy.", e);
            }
        }
        return 0;
    }

    public String spaceName() {
        return this.spaceName;
    }

    public CacheObject unmarshalSwapEntryValue(byte[] bytes) throws IgniteCheckedException {
        GridCacheSwapEntryImpl swapEntry = this.swapEntry(GridCacheSwapEntryImpl.unmarshal(bytes, true));
        assert (swapEntry != null && swapEntry.value() != null) : swapEntry;
        return swapEntry.value();
    }

    private GridCacheSwapEntry unmarshalSwapEntry(byte[] bytes, boolean valOnly) {
        return GridCacheSwapEntryImpl.unmarshal(bytes, valOnly);
    }

    int iteratorSetSize() {
        return this.itSet.size();
    }

    private static <K, V> Iterator<Cache.Entry<K, V>> cacheEntryIterator(Iterator<Map.Entry<K, V>> it) {
        return F.iterator(it, new C1<Map.Entry<K, V>, Cache.Entry<K, V>>(){

            @Override
            public Cache.Entry<K, V> apply(Map.Entry<K, V> e) {
                return new CacheEntryImpl0(e);
            }
        }, true, new IgnitePredicate[0]);
    }

    private class GridVersionedMapEntry<K, V>
    implements Map.Entry<K, V>,
    GridCacheVersionAware {
        private final Map.Entry<byte[], byte[]> entry;
        private final boolean keepBinary;

        public GridVersionedMapEntry(Map.Entry<byte[], byte[]> entry, boolean keepBinary) {
            this.entry = entry;
            this.keepBinary = keepBinary;
        }

        @Override
        public K getKey() {
            try {
                return (K)GridCacheSwapManager.this.cctx.unwrapBinaryIfNeeded(GridCacheSwapManager.this.cctx.toCacheKeyObject(this.entry.getKey()), this.keepBinary);
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public V getValue() {
            try {
                GridCacheSwapEntry e = GridCacheSwapManager.this.swapEntry(GridCacheSwapManager.this.unmarshalSwapEntry(this.entry.getValue(), false));
                assert (e != null);
                return (V)GridCacheSwapManager.this.cctx.unwrapBinaryIfNeeded(e.value(), this.keepBinary);
            }
            catch (IgniteCheckedException ex) {
                throw new IgniteException(ex);
            }
        }

        @Override
        public GridCacheVersion version() {
            GridCacheSwapEntry e = GridCacheSwapManager.this.unmarshalSwapEntry(this.entry.getValue(), false);
            return e.version();
        }

        @Override
        public V setValue(V val) {
            throw new UnsupportedOperationException();
        }
    }

    private abstract class CloseablePartitionsIterator<T, T1 extends T>
    extends GridCloseableIteratorAdapter<T> {
        private Iterator<Integer> partIt;
        protected GridCloseableIterator<T1> curIt;
        protected T next;

        public CloseablePartitionsIterator(Collection<Integer> parts) {
            this.partIt = parts.iterator();
            try {
                this.advance();
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
        }

        @Override
        protected boolean onHasNext() {
            return this.next != null;
        }

        @Override
        protected T onNext() {
            try {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                T e = this.next;
                this.advance();
                return e;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
        }

        @Override
        protected void onClose() throws IgniteCheckedException {
            if (this.curIt != null) {
                this.curIt.close();
            }
        }

        private void advance() throws IgniteCheckedException {
            this.next = null;
            do {
                if (this.curIt == null && this.partIt.hasNext()) {
                    int part = this.partIt.next();
                    try {
                        this.curIt = this.partitionIterator(part);
                    }
                    catch (IgniteCheckedException e) {
                        throw new IgniteException(e);
                    }
                }
                if (this.curIt == null) continue;
                if (this.curIt.hasNext()) {
                    this.next = this.curIt.next();
                    break;
                }
                this.curIt.close();
                this.curIt = null;
            } while (this.partIt.hasNext());
        }

        protected abstract GridCloseableIterator<T1> partitionIterator(int var1) throws IgniteCheckedException;
    }

    private abstract class PartitionsAbstractIterator<T>
    implements Iterator<T> {
        private Iterator<Integer> partIt;
        private Iterator<T> curIt;
        private T next;

        public PartitionsAbstractIterator(Collection<Integer> parts) {
            this.partIt = parts.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            T e = this.next;
            this.advance();
            return e;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected final void advance() {
            this.next = null;
            do {
                if (this.curIt == null && this.partIt.hasNext()) {
                    int part = this.partIt.next();
                    try {
                        this.curIt = this.partitionIterator(part);
                    }
                    catch (IgniteCheckedException e) {
                        throw new IgniteException(e);
                    }
                }
                if (this.curIt == null) continue;
                if (this.curIt.hasNext()) {
                    this.next = this.curIt.next();
                    break;
                }
                this.curIt = null;
            } while (this.partIt.hasNext());
        }

        protected abstract Iterator<T> partitionIterator(int var1) throws IgniteCheckedException;
    }

    private abstract class PartitionsIterator<K, V>
    extends PartitionsAbstractIterator<Cache.Entry<K, V>> {
        private final boolean keepBinary;

        public PartitionsIterator(Collection<Integer> parts, boolean keepBinary) {
            super(parts);
            this.keepBinary = keepBinary;
            this.advance();
        }

        @Override
        protected Iterator<Cache.Entry<K, V>> partitionIterator(int part) throws IgniteCheckedException {
            return GridCacheSwapManager.cacheEntryIterator(GridCacheSwapManager.this.lazyIterator(this.nextPartition(part), this.keepBinary));
        }

        protected abstract GridCloseableIterator<? extends Map.Entry<byte[], byte[]>> nextPartition(int var1) throws IgniteCheckedException;
    }

    private class KeySwapListener
    implements GridCacheSwapListener {
        private final KeyCacheObject key;
        private volatile GridCacheSwapEntry entry;

        KeySwapListener(KeyCacheObject key) {
            this.key = key;
        }

        @Override
        public void onEntryUnswapped(int part, KeyCacheObject key, GridCacheSwapEntry e) throws IgniteCheckedException {
            if (this.key.equals(key)) {
                GridCacheSwapEntryImpl e0 = new GridCacheSwapEntryImpl(ByteBuffer.wrap(e.valueBytes()), e.type(), e.version(), e.ttl(), e.expireTime(), e.keyClassLoaderId(), e.valueClassLoaderId());
                CacheObject v = e.value();
                if (v != null) {
                    e0.value(v);
                } else {
                    e0 = (GridCacheSwapEntryImpl)GridCacheSwapManager.this.swapEntry(e0);
                }
                assert (e0 != null && e0.value() != null) : e0;
                this.entry = e0;
            }
        }
    }

    private class IteratorWrapper
    extends GridCloseableIteratorAdapter<Map.Entry<byte[], GridCacheSwapEntry>> {
        private static final long serialVersionUID = 0L;
        private final GridCloseableIterator<? extends Map.Entry<byte[], byte[]>> iter;

        private IteratorWrapper(GridCloseableIterator<? extends Map.Entry<byte[], byte[]>> iter) {
            assert (iter != null);
            this.iter = iter;
        }

        @Override
        protected Map.Entry<byte[], GridCacheSwapEntry> onNext() throws IgniteCheckedException {
            Map.Entry e = (Map.Entry)this.iter.nextX();
            GridCacheSwapEntry unmarshalled = GridCacheSwapManager.this.swapEntry(GridCacheSwapManager.this.unmarshalSwapEntry((byte[])e.getValue(), false));
            return F.t(e.getKey(), unmarshalled);
        }

        @Override
        protected boolean onHasNext() throws IgniteCheckedException {
            return this.iter.hasNext();
        }

        @Override
        protected void onClose() throws IgniteCheckedException {
            this.iter.close();
        }

        @Override
        protected void onRemove() {
            this.iter.remove();
        }
    }
}

