/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheManagerAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheMapEntry;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.GridConcurrentSkipListSet;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;
import org.jsr166.LongAdder8;

public class GridCacheTtlManager
extends GridCacheManagerAdapter {
    private final GridConcurrentSkipListSetEx pendingEntries = new GridConcurrentSkipListSetEx();

    @Override
    protected void start0() throws IgniteCheckedException {
        boolean cleanupDisabled;
        boolean bl = cleanupDisabled = this.cctx.kernalContext().isDaemon() || !this.cctx.config().isEagerTtl() || CU.isAtomicsCache(this.cctx.name()) || CU.isMarshallerCache(this.cctx.name()) || CU.isUtilityCache(this.cctx.name()) || this.cctx.kernalContext().clientNode() && this.cctx.config().getNearConfiguration() == null;
        if (cleanupDisabled) {
            return;
        }
        this.cctx.shared().ttl().register(this);
    }

    @Override
    protected void onKernalStop0(boolean cancel) {
        this.pendingEntries.clear();
        this.cctx.shared().ttl().unregister(this);
    }

    public void addTrackedEntry(GridCacheMapEntry entry) {
        assert (Thread.holdsLock(entry));
        EntryWrapper e = new EntryWrapper(entry);
        this.pendingEntries.add(e);
    }

    public void removeTrackedEntry(GridCacheMapEntry entry) {
        assert (Thread.holdsLock(entry));
        this.pendingEntries.remove(new EntryWrapper(entry));
    }

    public int pendingSize() {
        return this.pendingEntries.sizex();
    }

    @Override
    public void printMemoryStats() {
        X.println(">>>", new Object[0]);
        X.println(">>> TTL processor memory stats [grid=" + this.cctx.gridName() + ", cache=" + this.cctx.name() + ']', new Object[0]);
        X.println(">>>   pendingEntriesSize: " + this.pendingEntries.size(), new Object[0]);
    }

    public void expire() {
        this.expire(-1);
    }

    public boolean expire(int amount) {
        int limit;
        long now = U.currentTimeMillis();
        GridCacheVersion obsoleteVer = null;
        for (int cnt = limit = -1 != amount ? amount : this.pendingEntries.sizex(); cnt > 0; --cnt) {
            boolean touch;
            GridCacheEntryEx entry;
            EntryWrapper e = (EntryWrapper)this.pendingEntries.firstx();
            if (e == null || e.expireTime > now) {
                return false;
            }
            if (!this.pendingEntries.remove(e)) continue;
            if (obsoleteVer == null) {
                obsoleteVer = this.cctx.versions().next();
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Trying to remove expired entry from cache: " + e);
            }
            GridCacheEntryEx gridCacheEntryEx = entry = (touch = e.ctx.isSwapOrOffheapEnabled()) ? e.ctx.cache().entryEx(e.key) : e.ctx.cache().peekEx(e.key);
            if (entry == null) continue;
            while (true) {
                try {
                    if (!entry.onTtlExpired(obsoleteVer)) break;
                    touch = false;
                }
                catch (GridCacheEntryRemovedException ignored) {
                    entry = entry.context().cache().entryEx(entry.key());
                    touch = true;
                    continue;
                }
                break;
            }
            if (!touch) continue;
            entry.context().evicts().touch(entry, null);
        }
        if (amount != -1) {
            EntryWrapper e = (EntryWrapper)this.pendingEntries.firstx();
            return e != null && e.expireTime <= now;
        }
        return false;
    }

    private static int compareKeys(GridCacheContext cctx1, CacheObject key1, GridCacheContext cctx2, CacheObject key2) {
        int key2Hash;
        int key1Hash = key1.hashCode();
        int res = Integer.compare(key1Hash, key2Hash = key2.hashCode());
        if (res == 0) {
            key1 = (CacheObject)cctx1.unwrapTemporary(key1);
            key2 = (CacheObject)cctx2.unwrapTemporary(key2);
            try {
                byte[] key1ValBytes = key1.valueBytes(cctx1.cacheObjectContext());
                byte[] key2ValBytes = key2.valueBytes(cctx2.cacheObjectContext());
                res = Integer.compare(key1ValBytes.length, key2ValBytes.length);
                if (res == 0) {
                    for (int i = 0; i < key1ValBytes.length && (res = Byte.compare(key1ValBytes[i], key2ValBytes[i])) == 0; ++i) {
                    }
                }
                if (res == 0) {
                    res = Boolean.compare(cctx1.isNear(), cctx2.isNear());
                }
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }
        return res;
    }

    private static class GridConcurrentSkipListSetEx
    extends GridConcurrentSkipListSet<EntryWrapper> {
        private static final long serialVersionUID = 0L;
        private final LongAdder8 size = new LongAdder8();

        private GridConcurrentSkipListSetEx() {
        }

        public int sizex() {
            return this.size.intValue();
        }

        @Override
        public boolean add(EntryWrapper e) {
            boolean res = super.add(e);
            if (res) {
                this.size.increment();
            }
            return res;
        }

        @Override
        public boolean remove(Object o) {
            boolean res = super.remove(o);
            if (res) {
                this.size.decrement();
            }
            return res;
        }

        @Override
        @Nullable
        public EntryWrapper pollFirst() {
            EntryWrapper e = (EntryWrapper)super.pollFirst();
            if (e != null) {
                this.size.decrement();
            }
            return e;
        }
    }

    private static class EntryWrapper
    implements Comparable<EntryWrapper> {
        private final long expireTime;
        private final GridCacheContext ctx;
        private final KeyCacheObject key;

        private EntryWrapper(GridCacheMapEntry entry) {
            this.expireTime = entry.expireTimeUnlocked();
            assert (this.expireTime != 0L);
            this.ctx = entry.context();
            this.key = entry.key();
        }

        @Override
        public int compareTo(EntryWrapper o) {
            int res = Long.compare(this.expireTime, o.expireTime);
            if (res == 0) {
                res = GridCacheTtlManager.compareKeys(this.ctx, this.key, o.ctx, o.key);
            }
            return res;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof EntryWrapper)) {
                return false;
            }
            EntryWrapper that = (EntryWrapper)o;
            return this.expireTime == that.expireTime && GridCacheTtlManager.compareKeys(this.ctx, this.key, that.ctx, that.key) == 0;
        }

        public int hashCode() {
            int res = (int)(this.expireTime ^ this.expireTime >>> 32);
            res = 31 * res + this.key.hashCode();
            return res;
        }

        public String toString() {
            return S.toString(EntryWrapper.class, this);
        }
    }
}

