/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CompletionListener;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CacheEntry;
import org.apache.ignite.cache.CacheEntryProcessor;
import org.apache.ignite.cache.CacheManager;
import org.apache.ignite.cache.CacheMetrics;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.query.ContinuousQuery;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.QueryDetailMetrics;
import org.apache.ignite.cache.query.QueryMetrics;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cache.query.SpiQuery;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cache.query.TextQuery;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.AsyncSupportAdapter;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryImpl;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CacheLockImpl;
import org.apache.ignite.internal.processors.cache.CacheOperationContext;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheGateway;
import org.apache.ignite.internal.processors.cache.GridCacheProxyImpl;
import org.apache.ignite.internal.processors.cache.IgniteCacheFutureImpl;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.apache.ignite.internal.processors.cache.query.CacheQuery;
import org.apache.ignite.internal.processors.cache.query.CacheQueryFuture;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryDetailMetricsAdapter;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryType;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.util.GridCloseableIteratorAdapter;
import org.apache.ignite.internal.util.GridEmptyIterator;
import org.apache.ignite.internal.util.future.IgniteFutureImpl;
import org.apache.ignite.internal.util.lang.GridCloseableIterator;
import org.apache.ignite.internal.util.lang.GridClosureException;
import org.apache.ignite.internal.util.lang.IgniteOutClosureX;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.CX1;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.mxbean.CacheMetricsMXBean;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.jetbrains.annotations.Nullable;

public class IgniteCacheProxy<K, V>
extends AsyncSupportAdapter<IgniteCache<K, V>>
implements IgniteCache<K, V>,
Externalizable {
    private static final long serialVersionUID = 0L;
    private static final IgniteBiPredicate ACCEPT_ALL = new IgniteBiPredicate(){
        private static final long serialVersionUID = -1640538788290240617L;

        public boolean apply(Object k, Object v) {
            return true;
        }
    };
    private GridCacheContext<K, V> ctx;
    private GridCacheGateway<K, V> gate;
    @GridToStringInclude
    private IgniteInternalCache<K, V> delegate;
    private CacheOperationContext opCtx;
    @GridToStringExclude
    private GridCacheProxyImpl<K, V> internalProxy;
    @GridToStringExclude
    private CacheManager cacheMgr;
    @GridToStringExclude
    private boolean lock;

    public IgniteCacheProxy() {
    }

    public IgniteCacheProxy(GridCacheContext<K, V> ctx, IgniteInternalCache<K, V> delegate, CacheOperationContext opCtx, boolean async) {
        this(ctx, delegate, opCtx, async, true);
    }

    private IgniteCacheProxy(GridCacheContext<K, V> ctx, IgniteInternalCache<K, V> delegate, @Nullable CacheOperationContext opCtx, boolean async, boolean lock) {
        super(async);
        assert (ctx != null);
        assert (delegate != null);
        this.ctx = ctx;
        this.delegate = delegate;
        this.opCtx = opCtx;
        this.gate = ctx.gate();
        this.internalProxy = new GridCacheProxyImpl<K, V>(ctx, delegate, opCtx);
        this.lock = lock;
    }

    @Nullable
    public CacheOperationContext operationContext() {
        return this.opCtx;
    }

    public IgniteCacheProxy<K, V> cacheNoGate() {
        return new IgniteCacheProxy<K, V>(this.ctx, this.delegate, this.opCtx, this.isAsync(), false);
    }

    public GridCacheContext<K, V> context() {
        return this.ctx;
    }

    public GridCacheGateway<K, V> gate() {
        return this.gate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheMetrics metrics() {
        GridCacheGateway<K, V> gate = this.gate;
        CacheOperationContext prev = this.onEnter(gate, this.opCtx);
        try {
            CacheMetrics cacheMetrics = this.ctx.cache().clusterMetrics();
            return cacheMetrics;
        }
        finally {
            this.onLeave(gate, prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheMetrics metrics(ClusterGroup grp) {
        GridCacheGateway<K, V> gate = this.gate;
        CacheOperationContext prev = this.onEnter(gate, this.opCtx);
        try {
            CacheMetrics cacheMetrics = this.ctx.cache().clusterMetrics(grp);
            return cacheMetrics;
        }
        finally {
            this.onLeave(gate, prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheMetrics localMetrics() {
        GridCacheGateway<K, V> gate = this.gate;
        CacheOperationContext prev = this.onEnter(gate, this.opCtx);
        try {
            CacheMetrics cacheMetrics = this.ctx.cache().localMetrics();
            return cacheMetrics;
        }
        finally {
            this.onLeave(gate, prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheMetricsMXBean mxBean() {
        GridCacheGateway<K, V> gate = this.gate;
        CacheOperationContext prev = this.onEnter(gate, this.opCtx);
        try {
            CacheMetricsMXBean cacheMetricsMXBean = this.ctx.cache().clusterMxBean();
            return cacheMetricsMXBean;
        }
        finally {
            this.onLeave(gate, prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheMetricsMXBean localMxBean() {
        GridCacheGateway<K, V> gate = this.gate;
        CacheOperationContext prev = this.onEnter(gate, this.opCtx);
        try {
            CacheMetricsMXBean cacheMetricsMXBean = this.ctx.cache().localMxBean();
            return cacheMetricsMXBean;
        }
        finally {
            this.onLeave(gate, prev);
        }
    }

    @Override
    public <C extends Configuration<K, V>> C getConfiguration(Class<C> clazz) {
        CacheConfiguration cfg = this.ctx.config();
        if (!clazz.isAssignableFrom(cfg.getClass())) {
            throw new IllegalArgumentException();
        }
        return (C)((Configuration)clazz.cast(cfg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Cache.Entry<K, V> randomEntry() {
        GridKernalContext kctx = this.ctx.kernalContext();
        if (kctx.isDaemon() || kctx.clientNode()) {
            throw new UnsupportedOperationException("Not applicable for daemon or client node.");
        }
        GridCacheGateway<K, V> gate = this.gate;
        CacheOperationContext prev = this.onEnter(gate, this.opCtx);
        try {
            Cache.Entry<K, V> entry = this.ctx.cache().randomEntry();
            return entry;
        }
        finally {
            this.onLeave(gate, prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteCache<K, V> withExpiryPolicy(ExpiryPolicy plc) {
        GridCacheGateway<K, V> gate = this.gate;
        CacheOperationContext prev = this.onEnter(gate, this.opCtx);
        try {
            CacheOperationContext prj0 = this.opCtx != null ? this.opCtx.withExpiryPolicy(plc) : new CacheOperationContext(false, null, false, plc, false, null);
            IgniteCacheProxy<K, V> igniteCacheProxy = new IgniteCacheProxy<K, V>(this.ctx, this.delegate, prj0, this.isAsync(), this.lock);
            return igniteCacheProxy;
        }
        finally {
            this.onLeave(gate, prev);
        }
    }

    @Override
    public IgniteCache<K, V> withSkipStore() {
        return this.skipStore();
    }

    @Override
    public <K1, V1> IgniteCache<K1, V1> withKeepBinary() {
        return this.keepBinary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteCache<K, V> withNoRetries() {
        GridCacheGateway<K, V> gate = this.gate;
        CacheOperationContext prev = this.onEnter(gate, this.opCtx);
        try {
            boolean noRetries;
            boolean bl = noRetries = this.opCtx != null && this.opCtx.noRetries();
            if (noRetries) {
                IgniteCacheProxy igniteCacheProxy = this;
                return igniteCacheProxy;
            }
            CacheOperationContext opCtx0 = this.opCtx != null ? this.opCtx.setNoRetries(true) : new CacheOperationContext(false, null, false, null, true, null);
            IgniteCacheProxy<K, V> igniteCacheProxy = new IgniteCacheProxy<K, V>(this.ctx, this.delegate, opCtx0, this.isAsync(), this.lock);
            return igniteCacheProxy;
        }
        finally {
            this.onLeave(gate, prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadCache(@Nullable IgniteBiPredicate<K, V> p, Object ... args) {
        try {
            GridCacheGateway<K, V> gate = this.gate;
            CacheOperationContext prev = this.onEnter(gate, this.opCtx);
            try {
                if (this.isAsync()) {
                    if (this.ctx.cache().isLocal()) {
                        this.setFuture(this.ctx.cache().localLoadCacheAsync(p, args));
                    } else {
                        this.setFuture(this.ctx.cache().globalLoadCacheAsync(p, args));
                    }
                } else if (this.ctx.cache().isLocal()) {
                    this.ctx.cache().localLoadCache(p, args);
                } else {
                    this.ctx.cache().globalLoadCache(p, args);
                }
            }
            finally {
                this.onLeave(gate, prev);
            }
        }
        catch (IgniteCheckedException e) {
            throw this.cacheException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void localLoadCache(@Nullable IgniteBiPredicate<K, V> p, Object ... args) {
        try {
            GridCacheGateway<K, V> gate = this.gate;
            CacheOperationContext prev = this.onEnter(gate, this.opCtx);
            try {
                if (this.isAsync()) {
                    this.setFuture(this.delegate.localLoadCacheAsync(p, args));
                } else {
                    this.delegate.localLoadCache(p, args);
                }
            }
            finally {
                this.onLeave(gate, prev);
            }
        }
        catch (IgniteCheckedException e) {
            throw this.cacheException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public V getAndPutIfAbsent(K key, V val) throws CacheException {
        try {
            GridCacheGateway<K, V> gate = this.gate;
            CacheOperationContext prev = this.onEnter(gate, this.opCtx);
            try {
                if (this.isAsync()) {
                    this.setFuture(this.delegate.getAndPutIfAbsentAsync(key, val));
                    V v = null;
                    return v;
                }
                V v = this.delegate.getAndPutIfAbsent(key, val);
                return v;
            }
            finally {
                this.onLeave(gate, prev);
            }
        }
        catch (IgniteCheckedException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    public Lock lock(K key) throws CacheException {
        return this.lockAll(Collections.singleton(key));
    }

    @Override
    public Lock lockAll(Collection<? extends K> keys) {
        return new CacheLockImpl<K, V>(this.gate, this.delegate, this.opCtx, keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLocalLocked(K key, boolean byCurrThread) {
        GridCacheGateway<K, V> gate = this.gate;
        CacheOperationContext prev = this.onEnter(gate, this.opCtx);
        try {
            boolean bl = byCurrThread ? this.delegate.isLockedByThread(key) : this.delegate.isLocked(key);
            return bl;
        }
        finally {
            this.onLeave(gate, prev);
        }
    }

    private <T, R> QueryCursor<R> query(ScanQuery scanQry, final @Nullable IgniteClosure<T, R> transformer, @Nullable ClusterGroup grp) throws IgniteCheckedException {
        boolean isKeepBinary = this.opCtx != null && this.opCtx.isKeepBinary();
        IgniteBiPredicate p = scanQry.getFilter();
        final CacheQuery<R> qry = this.ctx.queries().createScanQuery(p, transformer, scanQry.getPartition(), isKeepBinary);
        if (scanQry.getPageSize() > 0) {
            qry.pageSize(scanQry.getPageSize());
        }
        if (grp != null) {
            qry.projection(grp);
        }
        GridCloseableIterator iter = (GridCloseableIterator)this.ctx.kernalContext().query().executeQuery(GridCacheQueryType.SCAN, this.ctx.name(), this.ctx, new IgniteOutClosureX<GridCloseableIterator<R>>(){

            @Override
            public GridCloseableIterator<R> applyx() throws IgniteCheckedException {
                final GridCloseableIterator iter0 = qry.executeScanQuery();
                final boolean needToConvert = transformer == null;
                return new GridCloseableIteratorAdapter<R>(){

                    @Override
                    protected R onNext() throws IgniteCheckedException {
                        Object next = iter0.nextX();
                        if (needToConvert) {
                            Map.Entry entry = (Map.Entry)next;
                            return new CacheEntryImpl(entry.getKey(), entry.getValue());
                        }
                        return next;
                    }

                    @Override
                    protected boolean onHasNext() throws IgniteCheckedException {
                        return iter0.hasNextX();
                    }

                    @Override
                    protected void onClose() throws IgniteCheckedException {
                        iter0.close();
                    }
                };
            }
        }, true);
        return new QueryCursorImpl(iter);
    }

    private QueryCursor<Cache.Entry<K, V>> query(final Query filter, @Nullable ClusterGroup grp) throws IgniteCheckedException {
        CacheQueryFuture fut;
        boolean isKeepBinary;
        boolean bl = isKeepBinary = this.opCtx != null && this.opCtx.isKeepBinary();
        if (filter instanceof TextQuery) {
            TextQuery p = (TextQuery)filter;
            final CacheQuery<Map.Entry<K, V>> qry = this.ctx.queries().createFullTextQuery(p.getType(), p.getText(), isKeepBinary);
            if (grp != null) {
                qry.projection(grp);
            }
            fut = (CacheQueryFuture)this.ctx.kernalContext().query().executeQuery(GridCacheQueryType.TEXT, p.getText(), this.ctx, new IgniteOutClosureX<CacheQueryFuture<Map.Entry<K, V>>>(){

                @Override
                public CacheQueryFuture<Map.Entry<K, V>> applyx() throws IgniteCheckedException {
                    return qry.execute(new Object[0]);
                }
            }, false);
        } else if (filter instanceof SpiQuery) {
            final CacheQuery qry = this.ctx.queries().createSpiQuery(isKeepBinary);
            if (grp != null) {
                qry.projection(grp);
            }
            fut = (CacheQueryFuture)this.ctx.kernalContext().query().executeQuery(GridCacheQueryType.SPI, filter.getClass().getSimpleName(), this.ctx, new IgniteOutClosureX<CacheQueryFuture<Cache.Entry<K, V>>>(){

                @Override
                public CacheQueryFuture<Cache.Entry<K, V>> applyx() throws IgniteCheckedException {
                    return qry.execute(((SpiQuery)filter).getArgs());
                }
            }, false);
        } else {
            if (filter instanceof SqlFieldsQuery) {
                throw new CacheException("Use methods 'queryFields' and 'localQueryFields' for " + SqlFieldsQuery.class.getSimpleName() + ".");
            }
            throw new CacheException("Unsupported query type: " + filter);
        }
        return new QueryCursorImpl<Cache.Entry<K, V>>(new GridCloseableIteratorAdapter<Cache.Entry<K, V>>(){
            private Cache.Entry<K, V> cur;

            @Override
            protected Cache.Entry<K, V> onNext() throws IgniteCheckedException {
                if (!this.onHasNext()) {
                    throw new NoSuchElementException();
                }
                Cache.Entry e = this.cur;
                this.cur = null;
                return e;
            }

            @Override
            protected boolean onHasNext() throws IgniteCheckedException {
                if (this.cur != null) {
                    return true;
                }
                Object next = fut.next();
                if (next == null) {
                    return false;
                }
                if (next instanceof Cache.Entry) {
                    this.cur = (Cache.Entry)next;
                } else {
                    Map.Entry e = (Map.Entry)next;
                    this.cur = new CacheEntryImpl(e.getKey(), e.getValue());
                }
                return true;
            }

            @Override
            protected void onClose() throws IgniteCheckedException {
                fut.cancel();
            }
        });
    }

    private ClusterGroup projection(boolean loc) {
        if (loc || this.ctx.isLocal() || this.isReplicatedDataNode()) {
            return this.ctx.kernalContext().grid().cluster().forLocal();
        }
        if (this.ctx.isReplicated()) {
            return this.ctx.kernalContext().grid().cluster().forDataNodes(this.ctx.name()).forRandom();
        }
        return null;
    }

    private QueryCursor<Cache.Entry<K, V>> queryContinuous(ContinuousQuery qry, boolean loc, boolean keepBinary) {
        if (qry.getInitialQuery() instanceof ContinuousQuery) {
            throw new IgniteException("Initial predicate for continuous query can't be an instance of another continuous query. Use SCAN or SQL query for initial iteration.");
        }
        if (qry.getLocalListener() == null) {
            throw new IgniteException("Mandatory local listener is not set for the query: " + qry);
        }
        if (qry.getRemoteFilter() != null && qry.getRemoteFilterFactory() != null) {
            throw new IgniteException("Should be used either RemoterFilter or RemoteFilterFactory.");
        }
        try {
            final UUID routineId = this.ctx.continuousQueries().executeQuery(qry.getLocalListener(), qry.getRemoteFilter(), qry.getRemoteFilterFactory(), qry.getPageSize(), qry.getTimeInterval(), qry.isAutoUnsubscribe(), loc, keepBinary, qry.isIncludeExpired());
            final QueryCursor cur = qry.getInitialQuery() != null ? this.query(qry.getInitialQuery()) : null;
            return new QueryCursor<Cache.Entry<K, V>>(){

                @Override
                public Iterator<Cache.Entry<K, V>> iterator() {
                    return cur != null ? cur.iterator() : new GridEmptyIterator();
                }

                @Override
                public List<Cache.Entry<K, V>> getAll() {
                    return cur != null ? cur.getAll() : Collections.emptyList();
                }

                @Override
                public void close() {
                    if (cur != null) {
                        cur.close();
                    }
                    try {
                        IgniteCacheProxy.this.ctx.kernalContext().continuous().stopRoutine(routineId).get();
                    }
                    catch (IgniteCheckedException e) {
                        throw U.convertException(e);
                    }
                }
            };
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public <R> QueryCursor<R> query(Query<R> qry) {
        A.notNull(qry, "qry");
        GridCacheGateway<K, V> gate = this.gate;
        CacheOperationContext prev = this.onEnter(gate, this.opCtx);
        try {
            this.ctx.checkSecurity(SecurityPermission.CACHE_READ);
            this.validate(qry);
            this.convertToBinary(qry);
            CacheOperationContext opCtxCall = this.ctx.operationContextPerCall();
            if (qry instanceof ContinuousQuery) {
                QueryCursor<Cache.Entry<K, V>> queryCursor = this.queryContinuous((ContinuousQuery)qry, qry.isLocal(), opCtxCall != null && opCtxCall.isKeepBinary());
                return queryCursor;
            }
            if (qry instanceof SqlQuery) {
                if (this.isReplicatedDataNode() && ((SqlQuery)qry).isDistributedJoins()) {
                    throw new CacheException("Queries using distributed JOINs have to be run on partitioned cache, not on replicated.");
                }
                SqlQuery p = (SqlQuery)qry;
                if (this.isReplicatedDataNode() || this.ctx.isLocal() || qry.isLocal()) {
                    QueryCursor queryCursor = this.ctx.kernalContext().query().queryLocal(this.ctx, p, opCtxCall != null && opCtxCall.isKeepBinary());
                    return queryCursor;
                }
                QueryCursor queryCursor = this.ctx.kernalContext().query().queryTwoStep(this.ctx, p);
                return queryCursor;
            }
            if (qry instanceof SqlFieldsQuery) {
                if (this.isReplicatedDataNode() && ((SqlFieldsQuery)qry).isDistributedJoins()) {
                    throw new CacheException("Queries using distributed JOINs have to be run on partitioned cache, not on replicated.");
                }
                SqlFieldsQuery p = (SqlFieldsQuery)qry;
                if (this.isReplicatedDataNode() || this.ctx.isLocal() || qry.isLocal()) {
                    QueryCursor<List<?>> queryCursor = this.ctx.kernalContext().query().queryLocalFields(this.ctx, p);
                    return queryCursor;
                }
                QueryCursor<List<?>> queryCursor = this.ctx.kernalContext().query().queryTwoStep(this.ctx, p);
                return queryCursor;
            }
            if (qry instanceof ScanQuery) {
                QueryCursor<R> queryCursor = this.query((ScanQuery)qry, null, this.projection(qry.isLocal()));
                return queryCursor;
            }
            QueryCursor<Cache.Entry<K, V>> queryCursor = this.query(qry, this.projection(qry.isLocal()));
            return queryCursor;
        }
        catch (Exception e) {
            if (e instanceof CacheException) {
                throw (CacheException)e;
            }
            throw new CacheException(e);
        }
        finally {
            this.onLeave(gate, prev);
        }
    }

    @Override
    public <T, R> QueryCursor<R> query(Query<T> qry, IgniteClosure<T, R> transformer) {
        A.notNull(qry, "qry");
        A.notNull(transformer, "transformer");
        if (!(qry instanceof ScanQuery)) {
            throw new UnsupportedOperationException("Transformers are supported only for SCAN queries.");
        }
        GridCacheGateway<K, V> gate = this.gate;
        CacheOperationContext prev = this.onEnter(gate, this.opCtx);
        try {
            this.ctx.checkSecurity(SecurityPermission.CACHE_READ);
            this.validate(qry);
            QueryCursor<R> queryCursor = this.query((ScanQuery)qry, transformer, this.projection(qry.isLocal()));
            return queryCursor;
        }
        catch (Exception e) {
            if (e instanceof CacheException) {
                throw (CacheException)e;
            }
            throw new CacheException(e);
        }
        finally {
            this.onLeave(gate, prev);
        }
    }

    private void convertToBinary(Query qry) {
        if (this.ctx.binaryMarshaller()) {
            if (qry instanceof SqlQuery) {
                SqlQuery sqlQry = (SqlQuery)qry;
                this.convertToBinary(sqlQry.getArgs());
            } else if (qry instanceof SpiQuery) {
                SpiQuery spiQry = (SpiQuery)qry;
                this.convertToBinary(spiQry.getArgs());
            } else if (qry instanceof SqlFieldsQuery) {
                SqlFieldsQuery fieldsQry = (SqlFieldsQuery)qry;
                this.convertToBinary(fieldsQry.getArgs());
            }
        }
    }

    private void convertToBinary(Object[] args) {
        if (args == null) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.ctx.cacheObjects().binary().toBinary(args[i]);
        }
    }

    private boolean isReplicatedDataNode() {
        return this.ctx.isReplicated() && this.ctx.affinityNode();
    }

    private void validate(Query qry) {
        if (!(GridQueryProcessor.isEnabled(this.ctx.config()) || qry instanceof ScanQuery || qry instanceof ContinuousQuery || qry instanceof SpiQuery)) {
            throw new CacheException("Indexing is disabled for cache: " + this.ctx.cache().name() + ". Use setIndexedTypes or setTypeMetadata methods on CacheConfiguration to enable.");
        }
        if (!this.ctx.kernalContext().query().moduleEnabled() && (qry instanceof SqlQuery || qry instanceof SqlFieldsQuery || qry instanceof TextQuery)) {
            throw new CacheException("Failed to execute query. Add module 'ignite-indexing' to the classpath of all Ignite nodes.");
        }
    }

    @Override
    public Iterable<Cache.Entry<K, V>> localEntries(CachePeekMode ... peekModes) throws CacheException {
        GridCacheGateway<K, V> gate = this.gate;
        CacheOperationContext prev = this.onEnter(gate, this.opCtx);
        try {
            Iterable<Cache.Entry<K, V>> iterable = this.delegate.localEntries(peekModes);
            return iterable;
        }
        catch (IgniteCheckedException e) {
            throw this.cacheException(e);
        }
        finally {
            this.onLeave(gate, prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryMetrics queryMetrics() {
        GridCacheGateway<K, V> gate = this.gate;
        CacheOperationContext prev = this.onEnter(gate, this.opCtx);
        try {
            QueryMetrics queryMetrics = this.delegate.context().queries().metrics();
            return queryMetrics;
        }
        finally {
            this.onLeave(gate, prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetQueryMetrics() {
        GridCacheGateway<K, V> gate = this.gate;
        CacheOperationContext prev = this.onEnter(gate, this.opCtx);
        try {
            this.delegate.context().queries().resetMetrics();
        }
        finally {
            this.onLeave(gate, prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<? extends QueryDetailMetrics> queryDetailMetrics() {
        GridCacheGateway<K, V> gate = this.gate;
        CacheOperationContext prev = this.onEnter(gate, this.opCtx);
        try {
            Collection<GridCacheQueryDetailMetricsAdapter> collection = this.delegate.context().queries().detailMetrics();
            return collection;
        }
        finally {
            this.onLeave(gate, prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetQueryDetailMetrics() {
        GridCacheGateway<K, V> gate = this.gate;
        CacheOperationContext prev = this.onEnter(gate, this.opCtx);
        try {
            this.delegate.context().queries().resetDetailMetrics();
        }
        finally {
            this.onLeave(gate, prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void localEvict(Collection<? extends K> keys) {
        GridCacheGateway<K, V> gate = this.gate;
        CacheOperationContext prev = this.onEnter(gate, this.opCtx);
        try {
            this.delegate.evictAll(keys);
        }
        finally {
            this.onLeave(gate, prev);
        }
    }

    @Override
    @Nullable
    public V localPeek(K key, CachePeekMode ... peekModes) {
        GridCacheGateway<K, V> gate = this.gate;
        CacheOperationContext prev = this.onEnter(gate, this.opCtx);
        try {
            V v = this.delegate.localPeek(key, peekModes, null);
            return v;
        }
        catch (IgniteCheckedException e) {
            throw this.cacheException(e);
        }
        finally {
            this.onLeave(gate, prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void localPromote(Set<? extends K> keys) throws CacheException {
        try {
            GridCacheGateway<K, V> gate = this.gate;
            CacheOperationContext prev = this.onEnter(gate, this.opCtx);
            try {
                this.delegate.promoteAll(keys);
            }
            finally {
                this.onLeave(gate, prev);
            }
        }
        catch (IgniteCheckedException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    public int size(CachePeekMode ... peekModes) throws CacheException {
        GridCacheGateway<K, V> gate = this.gate;
        CacheOperationContext prev = this.onEnter(gate, this.opCtx);
        try {
            if (this.isAsync()) {
                this.setFuture(this.delegate.sizeAsync(peekModes));
                int n = 0;
                return n;
            }
            int n = this.delegate.size(peekModes);
            return n;
        }
        catch (IgniteCheckedException e) {
            throw this.cacheException(e);
        }
        finally {
            this.onLeave(gate, prev);
        }
    }

    @Override
    public long sizeLong(CachePeekMode ... peekModes) throws CacheException {
        GridCacheGateway<K, V> gate = this.gate;
        CacheOperationContext prev = this.onEnter(gate, this.opCtx);
        try {
            if (this.isAsync()) {
                this.setFuture(this.delegate.sizeLongAsync(peekModes));
                long l = 0L;
                return l;
            }
            long l = this.delegate.sizeLong(peekModes);
            return l;
        }
        catch (IgniteCheckedException e) {
            throw this.cacheException(e);
        }
        finally {
            this.onLeave(gate, prev);
        }
    }

    @Override
    public long sizeLong(int part, CachePeekMode ... peekModes) throws CacheException {
        GridCacheGateway<K, V> gate = this.gate;
        CacheOperationContext prev = this.onEnter(gate, this.opCtx);
        try {
            if (this.isAsync()) {
                this.setFuture(this.delegate.sizeLongAsync(part, peekModes));
                long l = 0L;
                return l;
            }
            long l = this.delegate.sizeLong(part, peekModes);
            return l;
        }
        catch (IgniteCheckedException e) {
            throw this.cacheException(e);
        }
        finally {
            this.onLeave(gate, prev);
        }
    }

    @Override
    public int localSize(CachePeekMode ... peekModes) {
        GridCacheGateway<K, V> gate = this.gate;
        CacheOperationContext prev = this.onEnter(gate, this.opCtx);
        try {
            int n = this.delegate.localSize(peekModes);
            return n;
        }
        catch (IgniteCheckedException e) {
            throw this.cacheException(e);
        }
        finally {
            this.onLeave(gate, prev);
        }
    }

    @Override
    public long localSizeLong(CachePeekMode ... peekModes) {
        GridCacheGateway<K, V> gate = this.gate;
        CacheOperationContext prev = this.onEnter(gate, this.opCtx);
        try {
            long l = this.delegate.localSizeLong(peekModes);
            return l;
        }
        catch (IgniteCheckedException e) {
            throw this.cacheException(e);
        }
        finally {
            this.onLeave(gate, prev);
        }
    }

    @Override
    public long localSizeLong(int part, CachePeekMode ... peekModes) {
        GridCacheGateway<K, V> gate = this.gate;
        CacheOperationContext prev = this.onEnter(gate, this.opCtx);
        try {
            long l = this.delegate.localSizeLong(part, peekModes);
            return l;
        }
        catch (IgniteCheckedException e) {
            throw this.cacheException(e);
        }
        finally {
            this.onLeave(gate, prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public V get(K key) {
        try {
            GridCacheGateway<K, V> gate = this.gate;
            CacheOperationContext prev = this.onEnter(gate, this.opCtx);
            try {
                if (this.isAsync()) {
                    this.setFuture(this.delegate.getAsync(key));
                    V v = null;
                    return v;
                }
                V v = this.delegate.get(key);
                return v;
            }
            finally {
                this.onLeave(gate, prev);
            }
        }
        catch (IgniteCheckedException e) {
            throw this.cacheException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CacheEntry<K, V> getEntry(K key) {
        try {
            GridCacheGateway<K, V> gate = this.gate;
            CacheOperationContext prev = this.onEnter(gate, this.opCtx);
            try {
                if (this.isAsync()) {
                    this.setFuture(this.delegate.getEntryAsync(key));
                    CacheEntry<K, V> cacheEntry = null;
                    return cacheEntry;
                }
                CacheEntry<K, V> cacheEntry = this.delegate.getEntry(key);
                return cacheEntry;
            }
            finally {
                this.onLeave(gate, prev);
            }
        }
        catch (IgniteCheckedException e) {
            throw this.cacheException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<K, V> getAll(Set<? extends K> keys) {
        try {
            GridCacheGateway<K, V> gate = this.gate;
            CacheOperationContext prev = this.onEnter(gate, this.opCtx);
            try {
                if (this.isAsync()) {
                    this.setFuture(this.delegate.getAllAsync(keys));
                    Map<K, V> map = null;
                    return map;
                }
                Map<? extends K, V> map = this.delegate.getAll(keys);
                return map;
            }
            finally {
                this.onLeave(gate, prev);
            }
        }
        catch (IgniteCheckedException e) {
            throw this.cacheException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<CacheEntry<K, V>> getEntries(Set<? extends K> keys) {
        try {
            GridCacheGateway<K, V> gate = this.gate;
            CacheOperationContext prev = this.onEnter(gate, this.opCtx);
            try {
                if (this.isAsync()) {
                    this.setFuture(this.delegate.getEntriesAsync(keys));
                    Collection<CacheEntry<K, V>> collection = null;
                    return collection;
                }
                Collection<CacheEntry<K, V>> collection = this.delegate.getEntries(keys);
                return collection;
            }
            finally {
                this.onLeave(gate, prev);
            }
        }
        catch (IgniteCheckedException e) {
            throw this.cacheException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<K, V> getAllOutTx(Set<? extends K> keys) {
        try {
            GridCacheGateway<K, V> gate = this.gate;
            CacheOperationContext prev = this.onEnter(gate, this.opCtx);
            try {
                if (this.isAsync()) {
                    this.setFuture(this.delegate.getAllOutTxAsync(keys));
                    Map<K, V> map = null;
                    return map;
                }
                Map<? extends K, V> map = this.delegate.getAllOutTx(keys);
                return map;
            }
            finally {
                this.onLeave(gate, prev);
            }
        }
        catch (IgniteCheckedException e) {
            throw this.cacheException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<K, V> getAll(Collection<? extends K> keys) {
        try {
            GridCacheGateway<K, V> gate = this.gate;
            CacheOperationContext prev = this.onEnter(gate, this.opCtx);
            try {
                if (this.isAsync()) {
                    this.setFuture(this.delegate.getAllAsync(keys));
                    Map<K, V> map = null;
                    return map;
                }
                Map<? extends K, V> map = this.delegate.getAll(keys);
                return map;
            }
            finally {
                this.onLeave(gate, prev);
            }
        }
        catch (IgniteCheckedException e) {
            throw this.cacheException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Cache.Entry<K, V>> entrySetx(CacheEntryPredicate ... filter) {
        GridCacheGateway<K, V> gate = this.gate;
        CacheOperationContext prev = this.onEnter(gate, this.opCtx);
        try {
            Set<Cache.Entry<K, V>> set = this.delegate.entrySetx(filter);
            return set;
        }
        finally {
            this.onLeave(gate, prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(K key) {
        GridCacheGateway<K, V> gate = this.gate;
        CacheOperationContext prev = this.onEnter(gate, this.opCtx);
        try {
            if (this.isAsync()) {
                this.setFuture(this.delegate.containsKeyAsync(key));
                boolean bl = false;
                return bl;
            }
            boolean bl = this.delegate.containsKey(key);
            return bl;
        }
        finally {
            this.onLeave(gate, prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKeys(Set<? extends K> keys) {
        GridCacheGateway<K, V> gate = this.gate;
        CacheOperationContext prev = this.onEnter(gate, this.opCtx);
        try {
            if (this.isAsync()) {
                this.setFuture(this.delegate.containsKeysAsync(keys));
                boolean bl = false;
                return bl;
            }
            boolean bl = this.delegate.containsKeys(keys);
            return bl;
        }
        finally {
            this.onLeave(gate, prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadAll(Set<? extends K> keys, boolean replaceExisting, final @Nullable CompletionListener completionLsnr) {
        GridCacheGateway<K, V> gate = this.gate;
        CacheOperationContext prev = this.onEnter(gate, this.opCtx);
        try {
            IgniteInternalFuture<?> fut = this.ctx.cache().loadAll(keys, replaceExisting);
            if (completionLsnr != null) {
                fut.listen(new CI1<IgniteInternalFuture<?>>(){

                    @Override
                    public void apply(IgniteInternalFuture<?> fut) {
                        try {
                            fut.get();
                            completionLsnr.onCompletion();
                        }
                        catch (IgniteCheckedException e) {
                            completionLsnr.onException(IgniteCacheProxy.this.cacheException(e));
                        }
                    }
                });
            }
        }
        finally {
            this.onLeave(gate, prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, V val) {
        try {
            GridCacheGateway<K, V> gate = this.gate;
            CacheOperationContext prev = this.onEnter(gate, this.opCtx);
            try {
                if (this.isAsync()) {
                    IgniteInternalFuture<Boolean> fut = this.delegate.putAsync(key, val);
                    IgniteInternalFuture<Void> fut0 = fut.chain(new CX1<IgniteInternalFuture<Boolean>, Void>(){

                        @Override
                        public Void applyx(IgniteInternalFuture<Boolean> fut) throws IgniteCheckedException {
                            try {
                                fut.get();
                            }
                            catch (RuntimeException e) {
                                throw new GridClosureException(e);
                            }
                            return null;
                        }
                    });
                    this.setFuture(fut0);
                } else {
                    this.delegate.put(key, val);
                }
            }
            finally {
                this.onLeave(gate, prev);
            }
        }
        catch (IgniteCheckedException e) {
            throw this.cacheException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public V getAndPut(K key, V val) {
        try {
            GridCacheGateway<K, V> gate = this.gate;
            CacheOperationContext prev = this.onEnter(gate, this.opCtx);
            try {
                if (this.isAsync()) {
                    this.setFuture(this.delegate.getAndPutAsync(key, val));
                    V v = null;
                    return v;
                }
                V v = this.delegate.getAndPut(key, val);
                return v;
            }
            finally {
                this.onLeave(gate, prev);
            }
        }
        catch (IgniteCheckedException e) {
            throw this.cacheException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        try {
            GridCacheGateway<K, V> gate = this.gate;
            CacheOperationContext prev = this.onEnter(gate, this.opCtx);
            try {
                if (this.isAsync()) {
                    this.setFuture(this.delegate.putAllAsync(map));
                } else {
                    this.delegate.putAll(map);
                }
            }
            finally {
                this.onLeave(gate, prev);
            }
        }
        catch (IgniteCheckedException e) {
            throw this.cacheException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean putIfAbsent(K key, V val) {
        try {
            GridCacheGateway<K, V> gate = this.gate;
            CacheOperationContext prev = this.onEnter(gate, this.opCtx);
            try {
                if (this.isAsync()) {
                    this.setFuture(this.delegate.putIfAbsentAsync(key, val));
                    boolean bl = false;
                    return bl;
                }
                boolean bl = this.delegate.putIfAbsent(key, val);
                return bl;
            }
            finally {
                this.onLeave(gate, prev);
            }
        }
        catch (IgniteCheckedException e) {
            throw this.cacheException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean remove(K key) {
        try {
            GridCacheGateway<K, V> gate = this.gate;
            CacheOperationContext prev = this.onEnter(gate, this.opCtx);
            try {
                if (this.isAsync()) {
                    this.setFuture(this.delegate.removeAsync(key));
                    boolean bl = false;
                    return bl;
                }
                boolean bl = this.delegate.remove(key);
                return bl;
            }
            finally {
                this.onLeave(gate, prev);
            }
        }
        catch (IgniteCheckedException e) {
            throw this.cacheException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean remove(K key, V oldVal) {
        try {
            GridCacheGateway<K, V> gate = this.gate;
            CacheOperationContext prev = this.onEnter(gate, this.opCtx);
            try {
                if (this.isAsync()) {
                    this.setFuture(this.delegate.removeAsync(key, oldVal));
                    boolean bl = false;
                    return bl;
                }
                boolean bl = this.delegate.remove(key, oldVal);
                return bl;
            }
            finally {
                this.onLeave(gate, prev);
            }
        }
        catch (IgniteCheckedException e) {
            throw this.cacheException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public V getAndRemove(K key) {
        try {
            GridCacheGateway<K, V> gate = this.gate;
            CacheOperationContext prev = this.onEnter(gate, this.opCtx);
            try {
                if (this.isAsync()) {
                    this.setFuture(this.delegate.getAndRemoveAsync(key));
                    V v = null;
                    return v;
                }
                V v = this.delegate.getAndRemove(key);
                return v;
            }
            finally {
                this.onLeave(gate, prev);
            }
        }
        catch (IgniteCheckedException e) {
            throw this.cacheException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean replace(K key, V oldVal, V newVal) {
        try {
            GridCacheGateway<K, V> gate = this.gate;
            CacheOperationContext prev = this.onEnter(gate, this.opCtx);
            try {
                if (this.isAsync()) {
                    this.setFuture(this.delegate.replaceAsync(key, oldVal, newVal));
                    boolean bl = false;
                    return bl;
                }
                boolean bl = this.delegate.replace(key, oldVal, newVal);
                return bl;
            }
            finally {
                this.onLeave(gate, prev);
            }
        }
        catch (IgniteCheckedException e) {
            throw this.cacheException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean replace(K key, V val) {
        try {
            GridCacheGateway<K, V> gate = this.gate;
            CacheOperationContext prev = this.onEnter(gate, this.opCtx);
            try {
                if (this.isAsync()) {
                    this.setFuture(this.delegate.replaceAsync(key, val));
                    boolean bl = false;
                    return bl;
                }
                boolean bl = this.delegate.replace(key, val);
                return bl;
            }
            finally {
                this.onLeave(gate, prev);
            }
        }
        catch (IgniteCheckedException e) {
            throw this.cacheException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public V getAndReplace(K key, V val) {
        try {
            GridCacheGateway<K, V> gate = this.gate;
            CacheOperationContext prev = this.onEnter(gate, this.opCtx);
            try {
                if (this.isAsync()) {
                    this.setFuture(this.delegate.getAndReplaceAsync(key, val));
                    V v = null;
                    return v;
                }
                V v = this.delegate.getAndReplace(key, val);
                return v;
            }
            finally {
                this.onLeave(gate, prev);
            }
        }
        catch (IgniteCheckedException e) {
            throw this.cacheException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll(Set<? extends K> keys) {
        try {
            GridCacheGateway<K, V> gate = this.gate;
            CacheOperationContext prev = this.onEnter(gate, this.opCtx);
            try {
                if (this.isAsync()) {
                    this.setFuture(this.delegate.removeAllAsync(keys));
                } else {
                    this.delegate.removeAll(keys);
                }
            }
            finally {
                this.onLeave(gate, prev);
            }
        }
        catch (IgniteCheckedException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    public void removeAll() {
        GridCacheGateway<K, V> gate = this.gate;
        CacheOperationContext prev = this.onEnter(gate, this.opCtx);
        try {
            if (this.isAsync()) {
                this.setFuture(this.delegate.removeAllAsync());
            } else {
                this.delegate.removeAll();
            }
        }
        catch (IgniteCheckedException e) {
            throw this.cacheException(e);
        }
        finally {
            this.onLeave(gate, prev);
        }
    }

    @Override
    public void clear(K key) {
        GridCacheGateway<K, V> gate = this.gate;
        CacheOperationContext prev = this.onEnter(gate, this.opCtx);
        try {
            if (this.isAsync()) {
                this.setFuture(this.delegate.clearAsync(key));
            } else {
                this.delegate.clear(key);
            }
        }
        catch (IgniteCheckedException e) {
            throw this.cacheException(e);
        }
        finally {
            this.onLeave(gate, prev);
        }
    }

    @Override
    public void clearAll(Set<? extends K> keys) {
        GridCacheGateway<K, V> gate = this.gate;
        CacheOperationContext prev = this.onEnter(gate, this.opCtx);
        try {
            if (this.isAsync()) {
                this.setFuture(this.delegate.clearAllAsync(keys));
            } else {
                this.delegate.clearAll(keys);
            }
        }
        catch (IgniteCheckedException e) {
            throw this.cacheException(e);
        }
        finally {
            this.onLeave(gate, prev);
        }
    }

    @Override
    public void clear() {
        GridCacheGateway<K, V> gate = this.gate;
        CacheOperationContext prev = this.onEnter(gate, this.opCtx);
        try {
            if (this.isAsync()) {
                this.setFuture(this.delegate.clearAsync());
            } else {
                this.delegate.clear();
            }
        }
        catch (IgniteCheckedException e) {
            throw this.cacheException(e);
        }
        finally {
            this.onLeave(gate, prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void localClear(K key) {
        GridCacheGateway<K, V> gate = this.gate;
        CacheOperationContext prev = this.onEnter(gate, this.opCtx);
        try {
            this.delegate.clearLocally(key);
        }
        finally {
            this.onLeave(gate, prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void localClearAll(Set<? extends K> keys) {
        GridCacheGateway<K, V> gate = this.gate;
        CacheOperationContext prev = this.onEnter(gate, this.opCtx);
        try {
            for (K key : keys) {
                this.delegate.clearLocally(key);
            }
        }
        finally {
            this.onLeave(gate, prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... args) throws EntryProcessorException {
        try {
            GridCacheGateway<K, V> gate = this.gate;
            CacheOperationContext prev = this.onEnter(gate, this.opCtx);
            try {
                if (this.isAsync()) {
                    IgniteInternalFuture<EntryProcessorResult<T>> fut = this.delegate.invokeAsync(key, entryProcessor, args);
                    IgniteInternalFuture fut0 = fut.chain(new CX1<IgniteInternalFuture<EntryProcessorResult<T>>, T>(){

                        @Override
                        public T applyx(IgniteInternalFuture<EntryProcessorResult<T>> fut) throws IgniteCheckedException {
                            try {
                                EntryProcessorResult res = fut.get();
                                return res != null ? (Object)res.get() : null;
                            }
                            catch (RuntimeException e) {
                                throw new GridClosureException(e);
                            }
                        }
                    });
                    this.setFuture(fut0);
                    T t = null;
                    return t;
                }
                EntryProcessorResult<T> res = this.delegate.invoke(key, entryProcessor, args);
                T t = res != null ? (T)res.get() : null;
                return t;
            }
            finally {
                this.onLeave(gate, prev);
            }
        }
        catch (IgniteCheckedException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    public <T> T invoke(K key, CacheEntryProcessor<K, V, T> entryProcessor, Object ... args) throws EntryProcessorException {
        return this.invoke(key, (EntryProcessor<K, V, T>)entryProcessor, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T invoke(@Nullable AffinityTopologyVersion topVer, K key, EntryProcessor<K, V, T> entryProcessor, Object ... args) {
        try {
            GridCacheGateway<K, V> gate = this.gate;
            CacheOperationContext prev = this.onEnter(gate, this.opCtx);
            try {
                if (this.isAsync()) {
                    throw new UnsupportedOperationException();
                }
                EntryProcessorResult<T> res = this.delegate.invoke(topVer, key, entryProcessor, args);
                T t = res != null ? (T)res.get() : null;
                return t;
            }
            finally {
                this.onLeave(gate, prev);
            }
        }
        catch (IgniteCheckedException e) {
            throw this.cacheException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... args) {
        try {
            GridCacheGateway<K, V> gate = this.gate;
            CacheOperationContext prev = this.onEnter(gate, this.opCtx);
            try {
                if (this.isAsync()) {
                    this.setFuture(this.delegate.invokeAllAsync(keys, entryProcessor, args));
                    Map<K, EntryProcessorResult<T>> map = null;
                    return map;
                }
                Map<? extends K, EntryProcessorResult<T>> map = this.delegate.invokeAll(keys, entryProcessor, args);
                return map;
            }
            finally {
                this.onLeave(gate, prev);
            }
        }
        catch (IgniteCheckedException e) {
            throw this.cacheException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, CacheEntryProcessor<K, V, T> entryProcessor, Object ... args) {
        try {
            GridCacheGateway<K, V> gate = this.gate;
            CacheOperationContext prev = this.onEnter(gate, this.opCtx);
            try {
                if (this.isAsync()) {
                    this.setFuture(this.delegate.invokeAllAsync(keys, entryProcessor, args));
                    Map<K, EntryProcessorResult<T>> map = null;
                    return map;
                }
                Map<? extends K, EntryProcessorResult<T>> map = this.delegate.invokeAll(keys, entryProcessor, args);
                return map;
            }
            finally {
                this.onLeave(gate, prev);
            }
        }
        catch (IgniteCheckedException e) {
            throw this.cacheException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Map<? extends K, ? extends EntryProcessor<K, V, T>> map, Object ... args) {
        try {
            GridCacheGateway<K, V> gate = this.gate;
            CacheOperationContext prev = this.onEnter(gate, this.opCtx);
            try {
                if (this.isAsync()) {
                    this.setFuture(this.delegate.invokeAllAsync(map, args));
                    Map<K, EntryProcessorResult<T>> map2 = null;
                    return map2;
                }
                Map map3 = this.delegate.invokeAll(map, args);
                return map3;
            }
            finally {
                this.onLeave(gate, prev);
            }
        }
        catch (IgniteCheckedException e) {
            throw this.cacheException(e);
        }
    }

    @Override
    public String getName() {
        return this.delegate.name();
    }

    @Override
    public CacheManager getCacheManager() {
        return this.cacheMgr;
    }

    public void setCacheManager(CacheManager cacheMgr) {
        this.cacheMgr = cacheMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        IgniteInternalFuture<?> fut;
        GridCacheGateway<K, V> gate = this.gate;
        if (!this.onEnterIfNoStop(gate)) {
            return;
        }
        try {
            fut = this.ctx.kernalContext().cache().dynamicDestroyCache(this.ctx.name(), true);
        }
        finally {
            this.onLeave(gate);
        }
        try {
            fut.get();
        }
        catch (IgniteCheckedException e) {
            throw this.cacheException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        IgniteInternalFuture<?> fut;
        GridCacheGateway<K, V> gate = this.gate;
        if (!this.onEnterIfNoStop(gate)) {
            return;
        }
        try {
            fut = this.ctx.kernalContext().cache().dynamicCloseCache(this.ctx.name());
        }
        finally {
            this.onLeave(gate);
        }
        try {
            fut.get();
        }
        catch (IgniteCheckedException e) {
            throw this.cacheException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed() {
        GridCacheGateway<K, V> gate = this.gate;
        if (!this.onEnterIfNoStop(gate)) {
            return true;
        }
        try {
            boolean bl = this.ctx.kernalContext().cache().context().closed(this.ctx);
            return bl;
        }
        finally {
            this.onLeave(gate);
        }
    }

    public IgniteInternalCache delegate() {
        return this.delegate;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        if (clazz.isAssignableFrom(IgniteEx.class)) {
            return (T)this.ctx.grid();
        }
        throw new IllegalArgumentException("Unwrapping to class is not supported: " + clazz);
    }

    @Override
    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> lsnrCfg) {
        GridCacheGateway<K, V> gate = this.gate;
        CacheOperationContext prev = this.onEnter(gate, this.opCtx);
        try {
            CacheOperationContext opCtx = this.ctx.operationContextPerCall();
            this.ctx.continuousQueries().executeJCacheQuery(lsnrCfg, false, opCtx != null && opCtx.isKeepBinary());
        }
        catch (IgniteCheckedException e) {
            throw this.cacheException(e);
        }
        finally {
            this.onLeave(gate, prev);
        }
    }

    @Override
    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> lsnrCfg) {
        GridCacheGateway<K, V> gate = this.gate;
        CacheOperationContext prev = this.onEnter(gate, this.opCtx);
        try {
            this.ctx.continuousQueries().cancelJCacheQuery(lsnrCfg);
        }
        catch (IgniteCheckedException e) {
            throw this.cacheException(e);
        }
        finally {
            this.onLeave(gate, prev);
        }
    }

    @Override
    public Iterator<Cache.Entry<K, V>> iterator() {
        GridCacheGateway<K, V> gate = this.gate;
        CacheOperationContext prev = this.onEnter(gate, this.opCtx);
        try {
            Iterator<Cache.Entry<K, V>> iterator = this.ctx.cache().igniteIterator();
            return iterator;
        }
        catch (IgniteCheckedException e) {
            throw this.cacheException(e);
        }
        finally {
            this.onLeave(gate, prev);
        }
    }

    @Override
    protected IgniteCache<K, V> createAsyncInstance() {
        return new IgniteCacheProxy<K, V>(this.ctx, this.delegate, this.opCtx, true, this.lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K1, V1> IgniteCache<K1, V1> keepBinary() {
        GridCacheGateway<K, V> gate = this.gate;
        CacheOperationContext prev = this.onEnter(gate, this.opCtx);
        try {
            CacheOperationContext opCtx0 = new CacheOperationContext(this.opCtx != null && this.opCtx.skipStore(), this.opCtx != null ? this.opCtx.subjectId() : null, true, this.opCtx != null ? this.opCtx.expiry() : null, this.opCtx != null && this.opCtx.noRetries(), this.opCtx != null ? this.opCtx.dataCenterId() : null);
            IgniteCacheProxy<K, V> igniteCacheProxy = new IgniteCacheProxy<K, V>(this.ctx, (GridCacheAdapter)this.delegate, opCtx0, this.isAsync(), this.lock);
            return igniteCacheProxy;
        }
        finally {
            this.onLeave(gate, prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IgniteCache<K, V> withDataCenterId(byte dataCenterId) {
        CacheOperationContext prev = this.onEnter(this.gate, this.opCtx);
        try {
            Byte prevDataCenterId;
            Byte by = prevDataCenterId = this.opCtx != null ? this.opCtx.dataCenterId() : null;
            if (prevDataCenterId != null && dataCenterId == prevDataCenterId) {
                IgniteCacheProxy igniteCacheProxy = this;
                return igniteCacheProxy;
            }
            CacheOperationContext opCtx0 = new CacheOperationContext(this.opCtx != null && this.opCtx.skipStore(), this.opCtx != null ? this.opCtx.subjectId() : null, this.opCtx != null && this.opCtx.isKeepBinary(), this.opCtx != null ? this.opCtx.expiry() : null, this.opCtx != null && this.opCtx.noRetries(), dataCenterId);
            IgniteCacheProxy<K, V> igniteCacheProxy = new IgniteCacheProxy<K, V>(this.ctx, this.delegate, opCtx0, this.isAsync(), this.lock);
            return igniteCacheProxy;
        }
        finally {
            this.onLeave(this.gate, prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IgniteCache<K, V> skipStore() {
        GridCacheGateway<K, V> gate = this.gate;
        CacheOperationContext prev = this.onEnter(gate, this.opCtx);
        try {
            boolean skip;
            boolean bl = skip = this.opCtx != null && this.opCtx.skipStore();
            if (skip) {
                IgniteCacheProxy igniteCacheProxy = this;
                return igniteCacheProxy;
            }
            CacheOperationContext opCtx0 = new CacheOperationContext(true, this.opCtx != null ? this.opCtx.subjectId() : null, this.opCtx != null && this.opCtx.isKeepBinary(), this.opCtx != null ? this.opCtx.expiry() : null, this.opCtx != null && this.opCtx.noRetries(), this.opCtx != null ? this.opCtx.dataCenterId() : null);
            IgniteCacheProxy<K, V> igniteCacheProxy = new IgniteCacheProxy<K, V>(this.ctx, this.delegate, opCtx0, this.isAsync(), this.lock);
            return igniteCacheProxy;
        }
        finally {
            this.onLeave(gate, prev);
        }
    }

    private RuntimeException cacheException(IgniteCheckedException e) {
        return CU.convertToCacheException(e);
    }

    private <R> void setFuture(IgniteInternalFuture<R> fut) {
        this.curFut.set(new IgniteCacheFutureImpl<R>(fut));
    }

    public GridCacheProxyImpl<K, V> internalProxy() {
        return this.internalProxy;
    }

    public boolean proxyClosed() {
        return !this.gate.getClass().equals(GridCacheGateway.class);
    }

    public void closeProxy() {
        this.gate = new GridCacheGateway<K, V>(this.ctx){

            @Override
            public void enter() {
                throw new IllegalStateException("Cache has been closed: " + IgniteCacheProxy.this.ctx.name());
            }

            @Override
            public boolean enterIfNotStopped() {
                return false;
            }

            @Override
            public boolean enterIfNotStoppedNoLock() {
                return false;
            }

            @Override
            public void leaveNoLock() {
                assert (false);
            }

            @Override
            public void leave() {
                assert (false);
            }

            @Override
            @Nullable
            public CacheOperationContext enter(@Nullable CacheOperationContext opCtx) {
                throw new IllegalStateException("Cache has been closed: " + IgniteCacheProxy.this.ctx.name());
            }

            @Override
            @Nullable
            public CacheOperationContext enterNoLock(@Nullable CacheOperationContext opCtx) {
                throw new IllegalStateException("Cache has been closed: " + IgniteCacheProxy.this.ctx.name());
            }

            @Override
            public void leave(CacheOperationContext prev) {
                assert (false);
            }

            @Override
            public void leaveNoLock(CacheOperationContext prev) {
                assert (false);
            }

            @Override
            public void stopped() {
            }

            @Override
            public void onStopped() {
            }
        };
    }

    private CacheOperationContext onEnter(GridCacheGateway<K, V> gate, CacheOperationContext opCtx) {
        if (this.lock) {
            return gate.enter(opCtx);
        }
        return gate.enterNoLock(opCtx);
    }

    private boolean onEnterIfNoStop(GridCacheGateway<K, V> gate) {
        if (this.lock) {
            return gate.enterIfNotStopped();
        }
        return gate.enterIfNotStoppedNoLock();
    }

    private void onLeave(GridCacheGateway<K, V> gate, CacheOperationContext opCtx) {
        if (this.lock) {
            gate.leave(opCtx);
        } else {
            gate.leaveNoLock(opCtx);
        }
    }

    private void onLeave(GridCacheGateway<K, V> gate) {
        if (this.lock) {
            gate.leave();
        } else {
            gate.leaveNoLock();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.ctx);
        out.writeObject(this.delegate);
        out.writeObject(this.opCtx);
        out.writeBoolean(this.lock);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.ctx = (GridCacheContext)in.readObject();
        this.delegate = (IgniteInternalCache)in.readObject();
        this.opCtx = (CacheOperationContext)in.readObject();
        this.gate = this.ctx.gate();
        this.lock = in.readBoolean();
    }

    @Override
    public IgniteFuture<?> rebalance() {
        return new IgniteFutureImpl<Boolean>(this.ctx.preloader().forceRebalance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public V getTopologySafe(K key) {
        try {
            GridCacheGateway<K, V> gate = this.gate;
            CacheOperationContext prev = this.onEnter(gate, this.opCtx);
            try {
                V v = this.delegate.getTopologySafe(key);
                return v;
            }
            finally {
                this.onLeave(gate, prev);
            }
        }
        catch (IgniteCheckedException e) {
            throw this.cacheException(e);
        }
    }

    public String toString() {
        return S.toString(IgniteCacheProxy.class, this);
    }
}

