/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectAdapter;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.GridCacheInternal;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.jetbrains.annotations.Nullable;

public class KeyCacheObjectImpl
extends CacheObjectAdapter
implements KeyCacheObject {
    private static final long serialVersionUID = 0L;
    @GridDirectTransient
    private int part = -1;

    public KeyCacheObjectImpl() {
    }

    public KeyCacheObjectImpl(Object val, byte[] valBytes) {
        this(val, valBytes, -1);
    }

    public KeyCacheObjectImpl(Object val, byte[] valBytes, int part) {
        assert (val != null);
        this.val = val;
        this.valBytes = valBytes;
        this.part = part;
    }

    @Override
    public KeyCacheObject copy(int part) {
        if (this.part == part) {
            return this;
        }
        return new KeyCacheObjectImpl(this.val, this.valBytes, part);
    }

    @Override
    public int partition() {
        return this.part;
    }

    @Override
    public void partition(int part) {
        this.part = part;
    }

    @Override
    public byte[] valueBytes(CacheObjectContext ctx) throws IgniteCheckedException {
        if (this.valBytes == null) {
            this.valBytes = ctx.processor().marshal(ctx, this.val);
        }
        return this.valBytes;
    }

    @Override
    public boolean internal() {
        assert (this.val != null);
        return this.val instanceof GridCacheInternal;
    }

    @Override
    public boolean isPlatformType() {
        return true;
    }

    @Override
    @Nullable
    public <T> T value(CacheObjectContext ctx, boolean cpy) {
        assert (this.val != null);
        return (T)this.val;
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public CacheObject prepareForCache(CacheObjectContext ctx) {
        return this;
    }

    @Override
    public int hashCode() {
        assert (this.val != null);
        return this.val.hashCode();
    }

    @Override
    public byte directType() {
        return 90;
    }

    @Override
    public byte fieldsCount() {
        return 1;
    }

    @Override
    public void prepareMarshal(CacheObjectContext ctx) throws IgniteCheckedException {
        if (this.valBytes == null) {
            this.valBytes = ctx.kernalContext().cacheObjects().marshal(ctx, this.val);
        }
    }

    @Override
    public void finishUnmarshal(CacheObjectContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        if (this.val == null) {
            assert (this.valBytes != null);
            this.val = ctx.kernalContext().cacheObjects().unmarshal(ctx, this.valBytes, ldr);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof KeyCacheObjectImpl)) {
            return false;
        }
        KeyCacheObjectImpl other = (KeyCacheObjectImpl)obj;
        return this.val.equals(other.val);
    }
}

