/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.query.QueryCancelledException;
import org.apache.ignite.internal.processors.cache.query.QueryCursorEx;
import org.apache.ignite.internal.processors.query.GridQueryCancel;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;

public class QueryCursorImpl<T>
implements QueryCursorEx<T> {
    private static final AtomicReferenceFieldUpdater<QueryCursorImpl, State> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(QueryCursorImpl.class, State.class, "state");
    private final Iterable<T> iterExec;
    private final boolean isQry;
    private Iterator<T> iter;
    private volatile State state = State.IDLE;
    private List<GridQueryFieldMetadata> fieldsMeta;
    private final GridQueryCancel cancel;

    public QueryCursorImpl(Iterable<T> iterExec, GridQueryCancel cancel) {
        this(iterExec, cancel, true);
    }

    public QueryCursorImpl(Iterable<T> iterExec) {
        this(iterExec, null);
    }

    public QueryCursorImpl(Iterable<T> iterExec, GridQueryCancel cancel, boolean isQry) {
        this.iterExec = iterExec;
        this.cancel = cancel;
        this.isQry = isQry;
    }

    @Override
    public Iterator<T> iterator() {
        if (!STATE_UPDATER.compareAndSet(this, State.IDLE, State.EXECUTION)) {
            throw new IgniteException("Iterator is already fetched or query was cancelled.");
        }
        this.iter = this.iterExec.iterator();
        if (!STATE_UPDATER.compareAndSet(this, State.EXECUTION, State.RESULT_READY)) {
            this.closeIter();
            throw new CacheException(new QueryCancelledException());
        }
        assert (this.iter != null);
        return this.iter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> getAll() {
        ArrayList<T> all = new ArrayList<T>();
        try {
            for (T t : this) {
                all.add(t);
            }
        }
        finally {
            this.close();
        }
        return all;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getAll(QueryCursorEx.Consumer<T> clo) throws IgniteCheckedException {
        try {
            for (T t : this) {
                clo.consume(t);
            }
        }
        finally {
            this.close();
        }
    }

    @Override
    public void close() {
        while (this.state != State.CLOSED) {
            if (STATE_UPDATER.compareAndSet(this, State.RESULT_READY, State.CLOSED)) {
                this.closeIter();
                return;
            }
            if (STATE_UPDATER.compareAndSet(this, State.EXECUTION, State.CLOSED)) {
                if (this.cancel != null) {
                    this.cancel.cancel();
                }
                return;
            }
            if (!STATE_UPDATER.compareAndSet(this, State.IDLE, State.CLOSED)) continue;
            return;
        }
    }

    private void closeIter() {
        if (this.iter instanceof AutoCloseable) {
            try {
                ((AutoCloseable)((Object)this.iter)).close();
            }
            catch (Exception e) {
                throw new IgniteException(e);
            }
        }
    }

    public boolean isQuery() {
        return this.isQry;
    }

    public void fieldsMeta(List<GridQueryFieldMetadata> fieldsMeta) {
        this.fieldsMeta = fieldsMeta;
    }

    @Override
    public List<GridQueryFieldMetadata> fieldsMeta() {
        return this.fieldsMeta;
    }

    protected static enum State {
        IDLE,
        EXECUTION,
        RESULT_READY,
        CLOSED;

    }
}

