/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.binary;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryListenerException;
import javax.cache.event.CacheEntryUpdatedListener;
import javax.cache.event.EventType;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.MutableEntry;
import org.apache.ignite.IgniteBinary;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.binary.BinaryBasicNameMapper;
import org.apache.ignite.binary.BinaryField;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.binary.BinaryTypeConfiguration;
import org.apache.ignite.cache.CacheEntryEventSerializableFilter;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterTopologyException;
import org.apache.ignite.configuration.BinaryConfiguration;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.binary.BinaryContext;
import org.apache.ignite.internal.binary.BinaryEnumObjectImpl;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.binary.BinaryMetadataHandler;
import org.apache.ignite.internal.binary.BinaryObjectEx;
import org.apache.ignite.internal.binary.BinaryObjectImpl;
import org.apache.ignite.internal.binary.BinaryObjectOffheapImpl;
import org.apache.ignite.internal.binary.BinaryTypeImpl;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.binary.GridBinaryMarshaller;
import org.apache.ignite.internal.binary.builder.BinaryObjectBuilderImpl;
import org.apache.ignite.internal.binary.streams.BinaryOffheapInputStream;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicateAdapter;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.binary.BinaryMetadataKey;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryContext;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessor;
import org.apache.ignite.internal.processors.cache.binary.IgniteBinaryImpl;
import org.apache.ignite.internal.processors.cache.query.CacheQuery;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryManager;
import org.apache.ignite.internal.processors.cacheobject.IgniteCacheObjectProcessorImpl;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.lang.GridCloseableIterator;
import org.apache.ignite.internal.util.lang.GridMapEntry;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T1;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.spi.IgniteNodeValidationResult;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentHashMap8;

public class CacheObjectBinaryProcessorImpl
extends IgniteCacheObjectProcessorImpl
implements CacheObjectBinaryProcessor {
    public static final IgniteProductVersion BINARY_CFG_CHECK_SINCE = IgniteProductVersion.fromString("1.5.7");
    private final CountDownLatch startLatch = new CountDownLatch(1);
    private final boolean clientNode;
    private volatile IgniteCacheProxy<BinaryMetadataKey, BinaryMetadata> metaDataCache;
    private final ConcurrentHashMap8<Integer, BinaryTypeImpl> clientMetaDataCache;
    private final CacheEntryPredicate metaPred = new CacheEntryPredicateAdapter(){
        private static final long serialVersionUID = 0L;

        @Override
        public boolean apply(GridCacheEntryEx e) {
            return e.key().value(e.context().cacheObjectContext(), false) instanceof BinaryMetadataKey;
        }
    };
    private BinaryContext binaryCtx;
    private Marshaller marsh;
    private GridBinaryMarshaller binaryMarsh;
    @GridToStringExclude
    private IgniteBinary binaries;
    private final GridLocalEventListener clientDisconLsnr = new GridLocalEventListener(){

        @Override
        public void onEvent(Event evt) {
            CacheObjectBinaryProcessorImpl.this.binaryContext().unregisterBinarySchemas();
        }
    };
    private final Map<Integer, BinaryMetadata> metaBuf = new ConcurrentHashMap<Integer, BinaryMetadata>();
    private final ConcurrentHashMap<Integer, T1<BinaryField>> affKeyFields = new ConcurrentHashMap();

    public CacheObjectBinaryProcessorImpl(GridKernalContext ctx) {
        super(ctx);
        this.marsh = ctx.grid().configuration().getMarshaller();
        this.clientNode = this.ctx.clientNode();
        this.clientMetaDataCache = this.clientNode ? new ConcurrentHashMap8() : null;
    }

    @Override
    public void start() throws IgniteCheckedException {
        if (this.marsh instanceof BinaryMarshaller) {
            BinaryConfiguration bCfg;
            if (this.ctx.clientNode()) {
                this.ctx.event().addLocalEventListener(this.clientDisconLsnr, 16, new int[0]);
            }
            BinaryMetadataHandler metaHnd = new BinaryMetadataHandler(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void addMeta(int typeId, BinaryType newMeta) throws BinaryObjectException {
                    assert (newMeta != null);
                    assert (newMeta instanceof BinaryTypeImpl);
                    BinaryMetadata newMeta0 = ((BinaryTypeImpl)newMeta).metadata();
                    if (CacheObjectBinaryProcessorImpl.this.metaDataCache == null) {
                        BinaryMetadata mergedMeta;
                        BinaryMetadata oldMeta = (BinaryMetadata)CacheObjectBinaryProcessorImpl.this.metaBuf.get(typeId);
                        if (oldMeta != (mergedMeta = BinaryUtils.mergeMetadata(oldMeta, newMeta0))) {
                            3 var6_6 = this;
                            synchronized (var6_6) {
                                mergedMeta = BinaryUtils.mergeMetadata(oldMeta, newMeta0);
                                if (oldMeta == mergedMeta) {
                                    return;
                                }
                                CacheObjectBinaryProcessorImpl.this.metaBuf.put(typeId, mergedMeta);
                            }
                            if (CacheObjectBinaryProcessorImpl.this.metaDataCache == null) {
                                return;
                            }
                            CacheObjectBinaryProcessorImpl.this.metaBuf.remove(typeId);
                        } else {
                            return;
                        }
                    }
                    assert (CacheObjectBinaryProcessorImpl.this.metaDataCache != null);
                    CacheObjectBinaryProcessorImpl.this.addMeta(typeId, newMeta0.wrap(CacheObjectBinaryProcessorImpl.this.binaryCtx));
                }

                @Override
                public BinaryType metadata(int typeId) throws BinaryObjectException {
                    if (CacheObjectBinaryProcessorImpl.this.metaDataCache == null) {
                        U.awaitQuiet(CacheObjectBinaryProcessorImpl.this.startLatch);
                    }
                    return CacheObjectBinaryProcessorImpl.this.metadata(typeId);
                }
            };
            BinaryMarshaller bMarsh0 = (BinaryMarshaller)this.marsh;
            this.binaryCtx = new BinaryContext(metaHnd, this.ctx.config(), this.ctx.log(BinaryContext.class));
            IgniteUtils.invoke(BinaryMarshaller.class, (Object)bMarsh0, "setBinaryContext", this.binaryCtx, this.ctx.config());
            this.binaryMarsh = new GridBinaryMarshaller(this.binaryCtx);
            this.binaries = new IgniteBinaryImpl(this.ctx, this);
            if (!IgniteSystemProperties.getBoolean("IGNITE_SKIP_CONFIGURATION_CONSISTENCY_CHECK") && (bCfg = this.ctx.config().getBinaryConfiguration()) != null) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("globIdMapper", bCfg.getIdMapper() != null ? bCfg.getIdMapper().getClass().getName() : null);
                map.put("globSerializer", bCfg.getSerializer() != null ? bCfg.getSerializer().getClass() : null);
                map.put("compactFooter", bCfg.isCompactFooter());
                if (bCfg.getTypeConfigurations() != null) {
                    HashMap<Boolean, List<Serializable>> typeCfgsMap = new HashMap<Boolean, List<Serializable>>();
                    for (BinaryTypeConfiguration c : bCfg.getTypeConfigurations()) {
                        typeCfgsMap.put(c.getTypeName() != null, Arrays.asList(c.getIdMapper() != null ? c.getIdMapper().getClass() : null, c.getSerializer() != null ? c.getSerializer().getClass() : null, c.isEnum()));
                    }
                    map.put("typeCfgs", typeCfgsMap);
                }
                this.ctx.addNodeAttribute("org.apache.ignite.binary.config", map);
            }
        }
    }

    @Override
    public void stop(boolean cancel) {
        if (this.ctx.clientNode()) {
            this.ctx.event().removeLocalEventListener(this.clientDisconLsnr, new int[0]);
        }
    }

    @Override
    public void onContinuousProcessorStarted(GridKernalContext ctx) throws IgniteCheckedException {
        if (this.clientNode && !ctx.isDaemon()) {
            ctx.continuous().registerStaticRoutine("ignite-sys-cache", new MetaDataEntryListener(), new MetaDataEntryFilter(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUtilityCacheStarted() throws IgniteCheckedException {
        IgniteCacheProxy proxy = this.ctx.cache().jcache("ignite-sys-cache");
        boolean old = proxy.context().deploy().ignoreOwnership(true);
        try {
            this.metaDataCache = (IgniteCacheProxy)proxy.withNoRetries();
        }
        finally {
            proxy.context().deploy().ignoreOwnership(old);
        }
        if (this.clientNode) {
            ClusterNode oldestSrvNode;
            assert (!this.metaDataCache.context().affinityNode());
            while ((oldestSrvNode = this.ctx.discovery().oldestAliveCacheServerNode(AffinityTopologyVersion.NONE)) != null) {
                GridCacheQueryManager<BinaryMetadataKey, BinaryMetadata> qryMgr = this.metaDataCache.context().queries();
                CacheQuery qry = qryMgr.createScanQuery(new MetaDataPredicate(), null, false);
                qry.keepAll(false);
                qry.projection(this.ctx.cluster().get().forNode(oldestSrvNode, new ClusterNode[0]));
                try (GridCloseableIterator entries = qry.executeScanQuery();){
                    for (Map.Entry e : entries) {
                        assert (e.getKey() != null) : e;
                        assert (e.getValue() != null) : e;
                        this.addClientCacheMetaData((BinaryMetadataKey)e.getKey(), (BinaryMetadata)e.getValue());
                    }
                    break;
                }
                catch (IgniteCheckedException e) {
                    if (!this.ctx.discovery().alive(oldestSrvNode) || !this.ctx.discovery().pingNode(oldestSrvNode.id())) continue;
                    throw e;
                }
                catch (CacheException e) {
                    if (X.hasCause(e, ClusterTopologyCheckedException.class, ClusterTopologyException.class)) continue;
                    throw e;
                }
            }
        }
        for (Map.Entry<Integer, BinaryMetadata> e : this.metaBuf.entrySet()) {
            this.addMeta(e.getKey(), e.getValue().wrap(this.binaryCtx));
        }
        this.metaBuf.clear();
        this.startLatch.countDown();
    }

    @Override
    public void onKernalStart() throws IgniteCheckedException {
        super.onKernalStart();
        if (!IgniteSystemProperties.getBoolean("IGNITE_SKIP_CONFIGURATION_CONSISTENCY_CHECK") && this.marsh instanceof BinaryMarshaller) {
            BinaryConfiguration bcfg = this.ctx.config().getBinaryConfiguration();
            for (ClusterNode rmtNode : this.ctx.discovery().remoteNodes()) {
                if (rmtNode.version().compareTo(BINARY_CFG_CHECK_SINCE) >= 0) continue;
                if (bcfg == null || bcfg.getNameMapper() == null) {
                    throw new IgniteCheckedException("When BinaryMarshaller is used and topology contains old nodes, then " + BinaryBasicNameMapper.class.getName() + " mapper have to be set " + "explicitely into binary configuration and 'simpleName' property of the mapper " + "have to be set to 'true'.");
                }
                if (bcfg.getNameMapper() instanceof BinaryBasicNameMapper && ((BinaryBasicNameMapper)bcfg.getNameMapper()).isSimpleName()) break;
                U.quietAndWarn(this.log, "When BinaryMarshaller is used and topology contains old nodes, it's strongly recommended, to set " + BinaryBasicNameMapper.class.getName() + " mapper into binary configuration explicitely " + " and 'simpleName' property of the mapper set to 'true' (fix configuration or set " + "-D" + "IGNITE_SKIP_CONFIGURATION_CONSISTENCY_CHECK" + "=true system property).");
                break;
            }
        }
    }

    private void addClientCacheMetaData(BinaryMetadataKey key, final BinaryMetadata newMeta) {
        int key0 = key.typeId();
        this.clientMetaDataCache.compute((Integer)key0, new ConcurrentHashMap8.BiFun<Integer, BinaryTypeImpl, BinaryTypeImpl>(){

            @Override
            public BinaryTypeImpl apply(Integer key, BinaryTypeImpl oldMeta) {
                BinaryMetadata res;
                BinaryMetadata oldMeta0 = oldMeta != null ? oldMeta.metadata() : null;
                try {
                    res = BinaryUtils.mergeMetadata(oldMeta0, newMeta);
                }
                catch (BinaryObjectException ignored) {
                    res = oldMeta0;
                }
                return res != null ? res.wrap(CacheObjectBinaryProcessorImpl.this.binaryCtx) : null;
            }
        });
    }

    @Override
    public int typeId(String typeName) {
        if (this.binaryCtx == null) {
            return super.typeId(typeName);
        }
        return this.binaryCtx.typeId(typeName);
    }

    public byte[] marshal(@Nullable Object obj) throws BinaryObjectException {
        byte[] arr = this.binaryMarsh.marshal(obj);
        assert (arr.length > 0);
        return arr;
    }

    public Object unmarshal(long ptr, boolean forceHeap) throws BinaryObjectException {
        byte type;
        assert (ptr > 0L) : ptr;
        int size = GridUnsafe.getInt(ptr);
        ptr += 4L;
        if ((type = GridUnsafe.getByte(ptr++)) != 2) {
            assert (size > 0) : size;
            BinaryOffheapInputStream in = new BinaryOffheapInputStream(ptr, size, forceHeap);
            return this.binaryMarsh.unmarshal(in);
        }
        return U.copyMemory(ptr, size);
    }

    @Override
    public Object marshalToBinary(@Nullable Object obj) throws BinaryObjectException {
        if (obj == null) {
            return null;
        }
        if (BinaryUtils.isBinaryType(obj.getClass())) {
            return obj;
        }
        if (obj instanceof Object[]) {
            Object[] arr = (Object[])obj;
            Object[] pArr = new Object[arr.length];
            for (int i = 0; i < arr.length; ++i) {
                pArr[i] = this.marshalToBinary(arr[i]);
            }
            return pArr;
        }
        if (obj instanceof IgniteBiTuple) {
            IgniteBiTuple tup = (IgniteBiTuple)obj;
            if (obj instanceof T2) {
                return new T2<Object, Object>(this.marshalToBinary(tup.get1()), this.marshalToBinary(tup.get2()));
            }
            return new IgniteBiTuple<Object, Object>(this.marshalToBinary(tup.get1()), this.marshalToBinary(tup.get2()));
        }
        Collection pCol = BinaryUtils.newKnownCollection(obj);
        if (pCol != null) {
            Collection col = (Collection)obj;
            for (Object item : col) {
                pCol.add(this.marshalToBinary(item));
            }
            return pCol;
        }
        Map<Object, Object> pMap = BinaryUtils.newKnownMap(obj);
        if (pMap != null) {
            Map map = (Map)obj;
            for (Map.Entry e : map.entrySet()) {
                pMap.put(this.marshalToBinary(e.getKey()), this.marshalToBinary(e.getValue()));
            }
            return pMap;
        }
        if (obj instanceof Map.Entry) {
            Map.Entry e = (Map.Entry)obj;
            return new GridMapEntry<Object, Object>(this.marshalToBinary(e.getKey()), this.marshalToBinary(e.getValue()));
        }
        if (this.binaryMarsh.mustDeserialize(obj)) {
            return obj;
        }
        byte[] arr = this.binaryMarsh.marshal(obj);
        assert (arr.length > 0);
        Object obj0 = this.binaryMarsh.unmarshal(arr, null);
        if (obj0 instanceof BinaryObjectImpl) {
            ((BinaryObjectImpl)obj0).detachAllowed(true);
        }
        return obj0;
    }

    public GridBinaryMarshaller marshaller() {
        return this.binaryMarsh;
    }

    @Override
    public String affinityField(String keyType) {
        if (this.binaryCtx == null) {
            return null;
        }
        return this.binaryCtx.affinityKeyFieldName(this.typeId(keyType));
    }

    @Override
    public BinaryObjectBuilder builder(String clsName) {
        return new BinaryObjectBuilderImpl(this.binaryCtx, clsName);
    }

    @Override
    public BinaryObjectBuilder builder(BinaryObject binaryObj) {
        return BinaryObjectBuilderImpl.wrap(binaryObj);
    }

    @Override
    public void updateMetadata(int typeId, String typeName, @Nullable String affKeyFieldName, Map<String, Integer> fieldTypeIds, boolean isEnum) throws BinaryObjectException {
        BinaryMetadata meta = new BinaryMetadata(typeId, typeName, fieldTypeIds, affKeyFieldName, null, isEnum);
        this.binaryCtx.updateMetadata(typeId, meta);
    }

    @Override
    public void addMeta(int typeId, BinaryType newMeta) throws BinaryObjectException {
        assert (newMeta != null);
        assert (newMeta instanceof BinaryTypeImpl);
        BinaryMetadata newMeta0 = ((BinaryTypeImpl)newMeta).metadata();
        BinaryMetadataKey key = new BinaryMetadataKey(typeId);
        try {
            BinaryObjectException err;
            BinaryMetadata oldMeta = this.metaDataCache.localPeek(key, new CachePeekMode[0]);
            BinaryMetadata mergedMeta = BinaryUtils.mergeMetadata(oldMeta, newMeta0);
            AffinityTopologyVersion topVer = this.ctx.cache().context().lockedTopologyVersion(null);
            if (topVer == null) {
                topVer = this.ctx.cache().context().exchange().readyAffinityVersion();
            }
            if ((err = this.metaDataCache.invoke(topVer, key, new MetadataProcessor(mergedMeta), new Object[0])) != null) {
                throw err;
            }
        }
        catch (CacheException e) {
            throw new BinaryObjectException("Failed to update meta data for type: " + newMeta.typeName(), e);
        }
    }

    @Override
    @Nullable
    public BinaryType metadata(int typeId) throws BinaryObjectException {
        try {
            if (this.clientNode) {
                BinaryType typeMeta = this.clientMetaDataCache.get(typeId);
                if (typeMeta != null) {
                    return typeMeta;
                }
                BinaryMetadata meta = this.metaDataCache.getTopologySafe(new BinaryMetadataKey(typeId));
                return meta != null ? meta.wrap(this.binaryCtx) : null;
            }
            BinaryMetadataKey key = new BinaryMetadataKey(typeId);
            BinaryMetadata meta = this.metaDataCache.localPeek(key, new CachePeekMode[0]);
            if (meta == null && !this.metaDataCache.context().preloader().syncFuture().isDone()) {
                meta = this.metaDataCache.getTopologySafe(key);
            }
            return meta != null ? meta.wrap(this.binaryCtx) : null;
        }
        catch (CacheException e) {
            throw new BinaryObjectException(e);
        }
    }

    @Override
    public Map<Integer, BinaryType> metadata(Collection<Integer> typeIds) throws BinaryObjectException {
        try {
            ArrayList<BinaryMetadataKey> keys = new ArrayList<BinaryMetadataKey>(typeIds.size());
            for (Integer typeId : typeIds) {
                keys.add(new BinaryMetadataKey(typeId));
            }
            Map<BinaryMetadataKey, BinaryMetadata> meta = this.metaDataCache.getAll(keys);
            HashMap<Integer, BinaryType> res = U.newHashMap(meta.size());
            for (Map.Entry<BinaryMetadataKey, BinaryMetadata> e : meta.entrySet()) {
                res.put(e.getKey().typeId(), e.getValue().wrap(this.binaryCtx));
            }
            return res;
        }
        catch (CacheException e) {
            throw new BinaryObjectException(e);
        }
    }

    @Override
    public Collection<BinaryType> metadata() throws BinaryObjectException {
        if (this.clientNode) {
            return F.viewReadOnly(this.clientMetaDataCache.values(), new IgniteClosure<BinaryTypeImpl, BinaryType>(){

                @Override
                public BinaryType apply(BinaryTypeImpl meta) {
                    return meta;
                }
            }, new IgnitePredicate[0]);
        }
        return F.viewReadOnly(this.metaDataCache.entrySetx(this.metaPred), new C1<Cache.Entry<BinaryMetadataKey, BinaryMetadata>, BinaryType>(){
            private static final long serialVersionUID = 0L;

            @Override
            public BinaryType apply(Cache.Entry<BinaryMetadataKey, BinaryMetadata> e) {
                return e.getValue().wrap(CacheObjectBinaryProcessorImpl.this.binaryCtx);
            }
        }, new IgnitePredicate[0]);
    }

    @Override
    public BinaryObject buildEnum(String typeName, int ord) throws IgniteException {
        int typeId = this.binaryCtx.typeId(typeName);
        typeName = this.binaryCtx.userTypeName(typeName);
        this.updateMetadata(typeId, typeName, null, null, true);
        return new BinaryEnumObjectImpl(this.binaryCtx, typeId, null, ord);
    }

    @Override
    public IgniteBinary binary() throws IgniteException {
        return this.binaries;
    }

    @Override
    public boolean isBinaryObject(Object obj) {
        return obj instanceof BinaryObject;
    }

    @Override
    public boolean isBinaryEnabled(CacheConfiguration<?, ?> ccfg) {
        return this.marsh instanceof BinaryMarshaller;
    }

    public Object affinityKey(BinaryObject po) {
        int typeId;
        T1<BinaryField> fieldHolder;
        if (po instanceof BinaryObjectEx && (fieldHolder = this.affKeyFields.get(typeId = ((BinaryObjectEx)po).typeId())) != null) {
            BinaryField field = (BinaryField)fieldHolder.get();
            return field != null ? field.value(po) : po;
        }
        try {
            int typeId2;
            String name;
            BinaryType meta;
            BinaryType binaryType = meta = po instanceof BinaryObjectEx ? ((BinaryObjectEx)po).rawType() : po.type();
            if (meta != null) {
                String name2 = meta.affinityKeyFieldName();
                if (name2 != null) {
                    BinaryField field = meta.field(name2);
                    this.affKeyFields.putIfAbsent(meta.typeId(), new T1<BinaryField>(field));
                    return field.value(po);
                }
                this.affKeyFields.putIfAbsent(meta.typeId(), new T1<Object>(null));
            } else if (po instanceof BinaryObjectEx && (name = this.binaryCtx.affinityKeyFieldName(typeId2 = ((BinaryObjectEx)po).typeId())) != null) {
                return po.field(name);
            }
        }
        catch (BinaryObjectException e) {
            U.error(this.log, "Failed to get affinity field from binary object: " + po, e);
        }
        return po;
    }

    @Override
    public int typeId(Object obj) {
        if (obj == null) {
            return 0;
        }
        return this.isBinaryObject(obj) ? ((BinaryObjectEx)obj).typeId() : this.typeId(obj.getClass().getSimpleName());
    }

    @Override
    public Object field(Object obj, String fieldName) {
        if (obj == null) {
            return null;
        }
        return this.isBinaryObject(obj) ? ((BinaryObject)obj).field(fieldName) : super.field(obj, fieldName);
    }

    @Override
    public boolean hasField(Object obj, String fieldName) {
        return obj != null && ((BinaryObject)obj).hasField(fieldName);
    }

    public BinaryContext binaryContext() {
        return this.binaryCtx;
    }

    @Override
    public CacheObjectContext contextForCache(CacheConfiguration cfg) throws IgniteCheckedException {
        assert (cfg != null);
        boolean binaryEnabled = this.marsh instanceof BinaryMarshaller && !GridCacheUtils.isSystemCache(cfg.getName()) && !GridCacheUtils.isIgfsCache(this.ctx.config(), cfg.getName());
        CacheObjectContext ctx0 = super.contextForCache(cfg);
        CacheObjectBinaryContext res = new CacheObjectBinaryContext(this.ctx, cfg.getName(), ctx0.copyOnGet(), ctx0.storeValue(), binaryEnabled, ctx0.addDeploymentInfo());
        this.ctx.resource().injectGeneric(res.defaultAffMapper());
        return res;
    }

    @Override
    public byte[] marshal(CacheObjectContext ctx, Object val) throws IgniteCheckedException {
        if (!((CacheObjectBinaryContext)ctx).binaryEnabled() || this.binaryMarsh == null) {
            return super.marshal(ctx, val);
        }
        byte[] arr = this.binaryMarsh.marshal(val);
        assert (arr.length > 0);
        return arr;
    }

    @Override
    public Object unmarshal(CacheObjectContext ctx, byte[] bytes, ClassLoader clsLdr) throws IgniteCheckedException {
        if (!((CacheObjectBinaryContext)ctx).binaryEnabled() || this.binaryMarsh == null) {
            return super.unmarshal(ctx, bytes, clsLdr);
        }
        return this.binaryMarsh.unmarshal(bytes, clsLdr);
    }

    @Override
    public KeyCacheObject toCacheKeyObject(CacheObjectContext ctx, @Nullable GridCacheContext cctx, Object obj, boolean userObj) {
        if (!((CacheObjectBinaryContext)ctx).binaryEnabled()) {
            return super.toCacheKeyObject(ctx, cctx, obj, userObj);
        }
        if (obj instanceof KeyCacheObject) {
            KeyCacheObject key = (KeyCacheObject)obj;
            if (key instanceof BinaryObjectImpl) {
                key = key.copy(this.partition(ctx, cctx, key));
            } else if (key.partition() == -1) {
                key.partition(this.partition(ctx, cctx, key));
            }
            return key;
        }
        if ((obj = this.toBinary(obj)) instanceof BinaryObjectImpl) {
            ((BinaryObjectImpl)obj).partition(this.partition(ctx, cctx, obj));
            return (KeyCacheObject)obj;
        }
        return this.toCacheKeyObject0(ctx, cctx, obj, userObj);
    }

    @Override
    @Nullable
    public CacheObject toCacheObject(CacheObjectContext ctx, @Nullable Object obj, boolean userObj) {
        if (!((CacheObjectBinaryContext)ctx).binaryEnabled()) {
            return super.toCacheObject(ctx, obj, userObj);
        }
        if (obj == null || obj instanceof CacheObject) {
            return (CacheObject)obj;
        }
        if ((obj = this.toBinary(obj)) instanceof CacheObject) {
            return (CacheObject)obj;
        }
        return this.toCacheObject0(obj, userObj);
    }

    @Override
    public CacheObject toCacheObject(CacheObjectContext ctx, byte type, byte[] bytes) {
        if (type == 100) {
            return new BinaryObjectImpl(this.binaryContext(), bytes, 0);
        }
        if (type == 101) {
            return new BinaryEnumObjectImpl(this.binaryContext(), bytes);
        }
        return super.toCacheObject(ctx, type, bytes);
    }

    @Override
    public CacheObject toCacheObject(GridCacheContext ctx, long valPtr, boolean tmp) throws IgniteCheckedException {
        if (!((CacheObjectBinaryContext)ctx.cacheObjectContext()).binaryEnabled()) {
            return super.toCacheObject(ctx, valPtr, tmp);
        }
        Object val = this.unmarshal(valPtr, !tmp);
        if (val instanceof CacheObject) {
            return (CacheObject)val;
        }
        return this.toCacheObject(ctx.cacheObjectContext(), val, false);
    }

    @Override
    public Object unwrapTemporary(GridCacheContext ctx, Object obj) throws BinaryObjectException {
        if (!((CacheObjectBinaryContext)ctx.cacheObjectContext()).binaryEnabled()) {
            return obj;
        }
        if (obj instanceof BinaryObjectOffheapImpl) {
            return ((BinaryObjectOffheapImpl)obj).heapCopy();
        }
        return obj;
    }

    @Nullable
    public Object toBinary(@Nullable Object obj) throws IgniteException {
        if (obj == null) {
            return null;
        }
        if (this.isBinaryObject(obj)) {
            return obj;
        }
        return this.marshalToBinary(obj);
    }

    @Override
    @Nullable
    public IgniteNodeValidationResult validateNode(ClusterNode rmtNode) {
        IgniteNodeValidationResult res = super.validateNode(rmtNode);
        if (res != null) {
            return res;
        }
        if (IgniteSystemProperties.getBoolean("IGNITE_SKIP_CONFIGURATION_CONSISTENCY_CHECK") || !(this.marsh instanceof BinaryMarshaller)) {
            return null;
        }
        Object rmtBinaryCfg = rmtNode.attribute("org.apache.ignite.binary.config");
        if (rmtNode.version().compareTo(BINARY_CFG_CHECK_SINCE) < 0) {
            return null;
        }
        ClusterNode locNode = this.ctx.discovery().localNode();
        Object locBinaryCfg = locNode.attribute("org.apache.ignite.binary.config");
        if (!F.eq(locBinaryCfg, rmtBinaryCfg)) {
            String msg = "Local node's binary configuration is not equal to remote node's binary configuration [locNodeId=%s, rmtNodeId=%s, locBinaryCfg=%s, rmtBinaryCfg=%s]";
            return new IgniteNodeValidationResult(rmtNode.id(), String.format(msg, locNode.id(), rmtNode.id(), locBinaryCfg, rmtBinaryCfg), String.format(msg, rmtNode.id(), locNode.id(), rmtBinaryCfg, locBinaryCfg));
        }
        return null;
    }

    static class MetaDataPredicate
    implements IgniteBiPredicate<Object, Object> {
        private static final long serialVersionUID = 0L;

        MetaDataPredicate() {
        }

        @Override
        public boolean apply(Object key, Object val) {
            return key instanceof BinaryMetadataKey;
        }

        public String toString() {
            return S.toString(MetaDataPredicate.class, this);
        }
    }

    static class MetaDataEntryFilter
    implements CacheEntryEventSerializableFilter<Object, Object> {
        private static final long serialVersionUID = 0L;

        MetaDataEntryFilter() {
        }

        @Override
        public boolean evaluate(CacheEntryEvent<?, ?> evt) throws CacheEntryListenerException {
            return evt.getKey() instanceof BinaryMetadataKey;
        }

        public String toString() {
            return S.toString(MetaDataEntryFilter.class, this);
        }
    }

    class MetaDataEntryListener
    implements CacheEntryUpdatedListener<BinaryMetadataKey, BinaryMetadata> {
        MetaDataEntryListener() {
        }

        @Override
        public void onUpdated(Iterable<CacheEntryEvent<? extends BinaryMetadataKey, ? extends BinaryMetadata>> evts) throws CacheEntryListenerException {
            for (CacheEntryEvent<? extends BinaryMetadataKey, ? extends BinaryMetadata> evt : evts) {
                assert (evt.getEventType() == EventType.CREATED || evt.getEventType() == EventType.UPDATED) : evt;
                BinaryMetadataKey key = (BinaryMetadataKey)evt.getKey();
                BinaryMetadata newMeta = (BinaryMetadata)evt.getValue();
                assert (newMeta != null) : evt;
                CacheObjectBinaryProcessorImpl.this.addClientCacheMetaData(key, newMeta);
            }
        }

        public String toString() {
            return S.toString(MetaDataEntryListener.class, this);
        }
    }

    private static class MetadataProcessor
    implements EntryProcessor<BinaryMetadataKey, BinaryMetadata, BinaryObjectException>,
    Externalizable {
        private static final long serialVersionUID = 0L;
        private BinaryMetadata newMeta;

        public MetadataProcessor() {
        }

        private MetadataProcessor(BinaryMetadata newMeta) {
            assert (newMeta != null);
            this.newMeta = newMeta;
        }

        @Override
        public BinaryObjectException process(MutableEntry<BinaryMetadataKey, BinaryMetadata> entry, Object ... args) {
            try {
                BinaryMetadata oldMeta = (BinaryMetadata)entry.getValue();
                BinaryMetadata mergedMeta = BinaryUtils.mergeMetadata(oldMeta, this.newMeta);
                if (mergedMeta != oldMeta) {
                    entry.setValue(mergedMeta);
                }
                return null;
            }
            catch (BinaryObjectException e) {
                return e;
            }
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.newMeta);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.newMeta = (BinaryMetadata)in.readObject();
        }

        public String toString() {
            return S.toString(MetadataProcessor.class, this);
        }
    }
}

