/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed;

import java.nio.ByteBuffer;
import java.util.Collection;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedBaseMessage;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxState;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxStateAware;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.tostring.GridToStringBuilder;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

public class GridDistributedTxFinishRequest
extends GridDistributedBaseMessage
implements IgniteTxStateAware {
    private static final long serialVersionUID = 0L;
    private IgniteUuid futId;
    private long threadId;
    private GridCacheVersion commitVer;
    private boolean invalidate;
    private boolean commit;
    @Deprecated
    private boolean syncCommit;
    @Deprecated
    private boolean syncRollback;
    private GridCacheVersion baseVer;
    private int txSize;
    private boolean sys;
    private byte plc;
    @GridDirectTransient
    private IgniteTxState txState;

    public GridDistributedTxFinishRequest() {
    }

    public GridDistributedTxFinishRequest(GridCacheVersion xidVer, IgniteUuid futId, @Nullable GridCacheVersion commitVer, long threadId, boolean commit, boolean invalidate, boolean sys, byte plc, boolean syncCommit, boolean syncRollback, GridCacheVersion baseVer, Collection<GridCacheVersion> committedVers, Collection<GridCacheVersion> rolledbackVers, int txSize, boolean addDepInfo) {
        super(xidVer, 0, addDepInfo);
        assert (xidVer != null);
        this.futId = futId;
        this.commitVer = commitVer;
        this.threadId = threadId;
        this.commit = commit;
        this.invalidate = invalidate;
        this.sys = sys;
        this.plc = plc;
        this.syncCommit = syncCommit;
        this.syncRollback = syncRollback;
        this.baseVer = baseVer;
        this.txSize = txSize;
        this.completedVersions(committedVers, rolledbackVers);
    }

    public boolean system() {
        return this.sys;
    }

    public byte policy() {
        return this.plc;
    }

    public IgniteUuid futureId() {
        return this.futId;
    }

    public long threadId() {
        return this.threadId;
    }

    public GridCacheVersion commitVersion() {
        return this.commitVer;
    }

    public boolean commit() {
        return this.commit;
    }

    public boolean isInvalidate() {
        return this.invalidate;
    }

    public boolean syncCommit() {
        return this.syncCommit;
    }

    public void syncCommit(boolean syncCommit) {
        this.syncCommit = syncCommit;
    }

    public boolean syncRollback() {
        return this.syncRollback;
    }

    public GridCacheVersion baseVersion() {
        return this.baseVer;
    }

    public int txSize() {
        return this.txSize;
    }

    public boolean replyRequired() {
        return this.commit ? this.syncCommit : this.syncRollback;
    }

    @Override
    public IgniteTxState txState() {
        return this.txState;
    }

    @Override
    public void txState(IgniteTxState txState) {
        this.txState = txState;
    }

    @Override
    public IgniteLogger messageLogger(GridCacheSharedContext ctx) {
        return ctx.txFinishMessageLogger();
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 7: {
                if (!writer.writeMessage("baseVer", this.baseVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                if (!writer.writeBoolean("commit", this.commit)) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                if (!writer.writeMessage("commitVer", this.commitVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 10: {
                if (!writer.writeIgniteUuid("futId", this.futId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 11: {
                if (!writer.writeBoolean("invalidate", this.invalidate)) {
                    return false;
                }
                writer.incrementState();
            }
            case 12: {
                if (!writer.writeByte("plc", this.plc)) {
                    return false;
                }
                writer.incrementState();
            }
            case 13: {
                if (!writer.writeBoolean("syncCommit", this.syncCommit)) {
                    return false;
                }
                writer.incrementState();
            }
            case 14: {
                if (!writer.writeBoolean("syncRollback", this.syncRollback)) {
                    return false;
                }
                writer.incrementState();
            }
            case 15: {
                if (!writer.writeBoolean("sys", this.sys)) {
                    return false;
                }
                writer.incrementState();
            }
            case 16: {
                if (!writer.writeLong("threadId", this.threadId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 17: {
                if (!writer.writeInt("txSize", this.txSize)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 7: {
                this.baseVer = (GridCacheVersion)reader.readMessage("baseVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 8: {
                this.commit = reader.readBoolean("commit");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 9: {
                this.commitVer = (GridCacheVersion)reader.readMessage("commitVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 10: {
                this.futId = reader.readIgniteUuid("futId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 11: {
                this.invalidate = reader.readBoolean("invalidate");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 12: {
                this.plc = reader.readByte("plc");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 13: {
                this.syncCommit = reader.readBoolean("syncCommit");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 14: {
                this.syncRollback = reader.readBoolean("syncRollback");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 15: {
                this.sys = reader.readBoolean("sys");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 16: {
                this.threadId = reader.readLong("threadId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 17: {
                this.txSize = reader.readInt("txSize");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDistributedTxFinishRequest.class);
    }

    @Override
    public byte directType() {
        return 23;
    }

    @Override
    public byte fieldsCount() {
        return 18;
    }

    @Override
    public String toString() {
        return GridToStringBuilder.toString(GridDistributedTxFinishRequest.class, this, "super", super.toString());
    }
}

