/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class GridDistributedTxMapping
implements Externalizable {
    private static final long serialVersionUID = 0L;
    @GridToStringExclude
    private ClusterNode node;
    @GridToStringInclude
    private Collection<IgniteTxEntry> entries;
    private boolean explicitLock;
    private GridCacheVersion dhtVer;
    private boolean last;
    private boolean near;
    private boolean clientFirst;

    public GridDistributedTxMapping() {
    }

    public GridDistributedTxMapping(ClusterNode node) {
        this.node = node;
        this.entries = new LinkedHashSet<IgniteTxEntry>();
    }

    public boolean last() {
        return this.last;
    }

    public void last(boolean last) {
        this.last = last;
    }

    public boolean clientFirst() {
        return this.clientFirst;
    }

    public void clientFirst(boolean clientFirst) {
        this.clientFirst = clientFirst;
    }

    public boolean near() {
        return this.near;
    }

    public void near(boolean near) {
        this.near = near;
    }

    public ClusterNode node() {
        return this.node;
    }

    public Collection<IgniteTxEntry> entries() {
        return this.entries;
    }

    public boolean explicitLock() {
        return this.explicitLock;
    }

    public void markExplicitLock() {
        this.explicitLock = true;
    }

    public GridCacheVersion dhtVersion() {
        return this.dhtVer;
    }

    public void dhtVersion(GridCacheVersion dhtVer, GridCacheVersion writeVer) {
        this.dhtVer = dhtVer;
        for (IgniteTxEntry e : this.entries) {
            e.dhtVersion(writeVer);
        }
    }

    public Collection<IgniteTxEntry> reads() {
        return F.view(this.entries, CU.reads());
    }

    public Collection<IgniteTxEntry> writes() {
        return F.view(this.entries, CU.writes());
    }

    public void add(IgniteTxEntry entry) {
        this.entries.add(entry);
    }

    public boolean removeEntry(IgniteTxEntry entry) {
        return this.entries.remove(entry);
    }

    public void evictReaders(@Nullable Collection<IgniteTxKey> keys) {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        this.evictReaders(keys, this.entries);
    }

    private void evictReaders(Collection<IgniteTxKey> keys, @Nullable Collection<IgniteTxEntry> entries) {
        if (entries == null || entries.isEmpty()) {
            return;
        }
        Iterator<IgniteTxEntry> it = entries.iterator();
        while (it.hasNext()) {
            IgniteTxEntry entry = it.next();
            if (!keys.contains(entry.txKey())) continue;
            it.remove();
        }
    }

    public boolean empty() {
        return this.entries.isEmpty();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.node);
        U.writeCollection(out, this.entries);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.node = (ClusterNode)in.readObject();
        this.entries = U.readCollection(in);
    }

    public String toString() {
        return S.toString(GridDistributedTxMapping.class, this, "node", this.node.id());
    }
}

