/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.GridDirectMap;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedBaseMessage;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxState;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxStateAware;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.UUIDCollectionMessage;
import org.apache.ignite.internal.util.tostring.GridToStringBuilder;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.jetbrains.annotations.Nullable;

public class GridDistributedTxPrepareRequest
extends GridDistributedBaseMessage
implements IgniteTxStateAware {
    private static final long serialVersionUID = 0L;
    public static final IgniteProductVersion TX_NODES_DIRECT_MARSHALLABLE_SINCE = IgniteProductVersion.fromString("1.5.0");
    public static final C1<Collection<UUID>, UUIDCollectionMessage> COL_TO_MSG = new C1<Collection<UUID>, UUIDCollectionMessage>(){

        @Override
        public UUIDCollectionMessage apply(Collection<UUID> uuids) {
            return new UUIDCollectionMessage(uuids);
        }
    };
    public static final C1<UUIDCollectionMessage, Collection<UUID>> MSG_TO_COL = new C1<UUIDCollectionMessage, Collection<UUID>>(){

        @Override
        public Collection<UUID> apply(UUIDCollectionMessage msg) {
            return msg.uuids();
        }
    };
    @GridToStringInclude
    private long threadId;
    @GridToStringInclude
    private TransactionConcurrency concurrency;
    @GridToStringInclude
    private TransactionIsolation isolation;
    @GridToStringInclude
    private GridCacheVersion writeVer;
    @GridToStringInclude
    private long timeout;
    @GridToStringInclude
    private boolean invalidate;
    @GridToStringInclude
    @GridDirectCollection(value=IgniteTxEntry.class)
    private Collection<IgniteTxEntry> reads;
    @GridToStringInclude
    @GridDirectCollection(value=IgniteTxEntry.class)
    private Collection<IgniteTxEntry> writes;
    @GridToStringInclude
    @GridDirectTransient
    private Map<IgniteTxKey, GridCacheVersion> dhtVers;
    @GridDirectCollection(value=IgniteTxKey.class)
    private Collection<IgniteTxKey> dhtVerKeys;
    @GridDirectCollection(value=GridCacheVersion.class)
    private Collection<GridCacheVersion> dhtVerVals;
    private int txSize;
    @GridDirectTransient
    private Map<UUID, Collection<UUID>> txNodes;
    @GridDirectMap(keyType=UUID.class, valueType=UUIDCollectionMessage.class)
    private Map<UUID, UUIDCollectionMessage> txNodesMsg;
    private byte[] txNodesBytes;
    private boolean onePhaseCommit;
    private boolean sys;
    private byte plc;
    @GridDirectTransient
    private IgniteTxState txState;

    public GridDistributedTxPrepareRequest() {
    }

    public GridDistributedTxPrepareRequest(IgniteInternalTx tx, long timeout, @Nullable Collection<IgniteTxEntry> reads, Collection<IgniteTxEntry> writes, Map<UUID, Collection<UUID>> txNodes, boolean onePhaseCommit, boolean addDepInfo) {
        super(tx.xidVersion(), 0, addDepInfo);
        this.writeVer = tx.writeVersion();
        this.threadId = tx.threadId();
        this.concurrency = tx.concurrency();
        this.isolation = tx.isolation();
        this.invalidate = tx.isInvalidate();
        this.txSize = tx.size();
        this.sys = tx.system();
        this.plc = tx.ioPolicy();
        this.timeout = timeout;
        this.reads = reads;
        this.writes = writes;
        this.txNodes = txNodes;
        this.onePhaseCommit = onePhaseCommit;
    }

    public Map<UUID, Collection<UUID>> transactionNodes() {
        return this.txNodes;
    }

    public boolean system() {
        return this.sys;
    }

    public byte policy() {
        return this.plc;
    }

    public void addDhtVersion(IgniteTxKey key, @Nullable GridCacheVersion dhtVer) {
        if (this.dhtVers == null) {
            this.dhtVers = new HashMap<IgniteTxKey, GridCacheVersion>();
        }
        this.dhtVers.put(key, dhtVer);
    }

    public Map<IgniteTxKey, GridCacheVersion> dhtVersions() {
        return this.dhtVers == null ? Collections.emptyMap() : this.dhtVers;
    }

    public long threadId() {
        return this.threadId;
    }

    public GridCacheVersion writeVersion() {
        return this.writeVer;
    }

    public boolean isInvalidate() {
        return this.invalidate;
    }

    public long timeout() {
        return this.timeout;
    }

    public TransactionConcurrency concurrency() {
        return this.concurrency;
    }

    public TransactionIsolation isolation() {
        return this.isolation;
    }

    public Collection<IgniteTxEntry> reads() {
        return this.reads;
    }

    public Collection<IgniteTxEntry> writes() {
        return this.writes;
    }

    protected void reads(Collection<IgniteTxEntry> reads) {
        this.reads = reads;
    }

    protected void writes(Collection<IgniteTxEntry> writes) {
        this.writes = writes;
    }

    public int txSize() {
        return this.txSize;
    }

    public boolean onePhaseCommit() {
        return this.onePhaseCommit;
    }

    @Override
    public IgniteTxState txState() {
        return this.txState;
    }

    @Override
    public void txState(IgniteTxState txState) {
        this.txState = txState;
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        if (this.writes != null) {
            this.marshalTx(this.writes, ctx);
        }
        if (this.reads != null) {
            this.marshalTx(this.reads, ctx);
        }
        if (this.dhtVers != null && this.dhtVerKeys == null) {
            for (IgniteTxKey key : this.dhtVers.keySet()) {
                GridCacheContext cctx = ctx.cacheContext(key.cacheId());
                key.prepareMarshal(cctx);
            }
            this.dhtVerKeys = this.dhtVers.keySet();
            this.dhtVerVals = this.dhtVers.values();
        }
        if (ctx.exchange().minimumNodeVersion(this.topologyVersion()).compareTo(TX_NODES_DIRECT_MARSHALLABLE_SINCE) < 0) {
            if (this.txNodes != null && this.txNodesBytes == null) {
                this.txNodesBytes = U.marshal(ctx, this.txNodes);
            }
        } else if (this.txNodesMsg == null) {
            this.txNodesMsg = F.viewReadOnly(this.txNodes, COL_TO_MSG, new IgnitePredicate[0]);
        }
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        if (this.writes != null) {
            this.unmarshalTx(this.writes, false, ctx, ldr);
        }
        if (this.reads != null) {
            this.unmarshalTx(this.reads, false, ctx, ldr);
        }
        if (this.dhtVerKeys != null && this.dhtVers == null) {
            assert (this.dhtVerVals != null);
            assert (this.dhtVerKeys.size() == this.dhtVerVals.size());
            Iterator<IgniteTxKey> keyIt = this.dhtVerKeys.iterator();
            Iterator<GridCacheVersion> verIt = this.dhtVerVals.iterator();
            this.dhtVers = U.newHashMap(this.dhtVerKeys.size());
            while (keyIt.hasNext()) {
                IgniteTxKey key = keyIt.next();
                key.finishUnmarshal(ctx.cacheContext(key.cacheId()), ldr);
                this.dhtVers.put(key, verIt.next());
            }
        }
        if (this.txNodesMsg != null) {
            this.txNodes = F.viewReadOnly(this.txNodesMsg, MSG_TO_COL, new IgnitePredicate[0]);
        }
        if (this.txNodesBytes != null && this.txNodes == null) {
            this.txNodes = (Map)U.unmarshal(ctx, this.txNodesBytes, U.resolveClassLoader(ldr, ctx.gridConfig()));
        }
    }

    @Override
    public boolean addDeploymentInfo() {
        return this.addDepInfo || this.forceAddDepInfo;
    }

    @Override
    public IgniteLogger messageLogger(GridCacheSharedContext ctx) {
        return ctx.txPrepareMessageLogger();
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 7: {
                if (!writer.writeByte("concurrency", this.concurrency != null ? (byte)this.concurrency.ordinal() : (byte)-1)) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                if (!writer.writeCollection("dhtVerKeys", this.dhtVerKeys, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                if (!writer.writeCollection("dhtVerVals", this.dhtVerVals, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 10: {
                if (!writer.writeBoolean("invalidate", this.invalidate)) {
                    return false;
                }
                writer.incrementState();
            }
            case 11: {
                if (!writer.writeByte("isolation", this.isolation != null ? (byte)this.isolation.ordinal() : (byte)-1)) {
                    return false;
                }
                writer.incrementState();
            }
            case 12: {
                if (!writer.writeBoolean("onePhaseCommit", this.onePhaseCommit)) {
                    return false;
                }
                writer.incrementState();
            }
            case 13: {
                if (!writer.writeByte("plc", this.plc)) {
                    return false;
                }
                writer.incrementState();
            }
            case 14: {
                if (!writer.writeCollection("reads", this.reads, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 15: {
                if (!writer.writeBoolean("sys", this.sys)) {
                    return false;
                }
                writer.incrementState();
            }
            case 16: {
                if (!writer.writeLong("threadId", this.threadId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 17: {
                if (!writer.writeLong("timeout", this.timeout)) {
                    return false;
                }
                writer.incrementState();
            }
            case 18: {
                if (!writer.writeByteArray("txNodesBytes", this.txNodesBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 19: {
                if (!writer.writeMap("txNodesMsg", this.txNodesMsg, MessageCollectionItemType.UUID, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 20: {
                if (!writer.writeInt("txSize", this.txSize)) {
                    return false;
                }
                writer.incrementState();
            }
            case 21: {
                if (!writer.writeMessage("writeVer", this.writeVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 22: {
                if (!writer.writeCollection("writes", this.writes, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 7: {
                byte concurrencyOrd = reader.readByte("concurrency");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.concurrency = TransactionConcurrency.fromOrdinal(concurrencyOrd);
                reader.incrementState();
            }
            case 8: {
                this.dhtVerKeys = reader.readCollection("dhtVerKeys", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 9: {
                this.dhtVerVals = reader.readCollection("dhtVerVals", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 10: {
                this.invalidate = reader.readBoolean("invalidate");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 11: {
                byte isolationOrd = reader.readByte("isolation");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.isolation = TransactionIsolation.fromOrdinal(isolationOrd);
                reader.incrementState();
            }
            case 12: {
                this.onePhaseCommit = reader.readBoolean("onePhaseCommit");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 13: {
                this.plc = reader.readByte("plc");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 14: {
                this.reads = reader.readCollection("reads", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 15: {
                this.sys = reader.readBoolean("sys");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 16: {
                this.threadId = reader.readLong("threadId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 17: {
                this.timeout = reader.readLong("timeout");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 18: {
                this.txNodesBytes = reader.readByteArray("txNodesBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 19: {
                this.txNodesMsg = reader.readMap("txNodesMsg", MessageCollectionItemType.UUID, MessageCollectionItemType.MSG, false);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 20: {
                this.txSize = reader.readInt("txSize");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 21: {
                this.writeVer = (GridCacheVersion)reader.readMessage("writeVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 22: {
                this.writes = reader.readCollection("writes", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDistributedTxPrepareRequest.class);
    }

    @Override
    public byte directType() {
        return 25;
    }

    @Override
    public byte fieldsCount() {
        return 23;
    }

    @Override
    public String toString() {
        return GridToStringBuilder.toString(GridDistributedTxPrepareRequest.class, this, "super", super.toString());
    }
}

