/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheFilterFailedException;
import org.apache.ignite.internal.processors.cache.GridCacheMvccCandidate;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheReturn;
import org.apache.ignite.internal.processors.cache.GridCacheReturnCompletableWrapper;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearCacheEntry;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxAdapter;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxRemoteEx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxRemoteState;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxState;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionConflictContext;
import org.apache.ignite.internal.processors.dr.GridDrType;
import org.apache.ignite.internal.transactions.IgniteTxHeuristicCheckedException;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.lang.GridTuple;
import org.apache.ignite.internal.util.tostring.GridToStringBuilder;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.apache.ignite.transactions.TransactionState;
import org.jetbrains.annotations.Nullable;

public class GridDistributedTxRemoteAdapter
extends IgniteTxAdapter
implements IgniteTxRemoteEx {
    private static final long serialVersionUID = 0L;
    private static final AtomicIntegerFieldUpdater<GridDistributedTxRemoteAdapter> COMMIT_ALLOWED_UPD = AtomicIntegerFieldUpdater.newUpdater(GridDistributedTxRemoteAdapter.class, "commitAllowed");
    @GridToStringInclude
    private List<GridCacheVersion> explicitVers;
    @GridToStringInclude
    private boolean started;
    @GridToStringInclude
    private volatile int commitAllowed;
    @GridToStringInclude
    protected IgniteTxRemoteState txState;

    public GridDistributedTxRemoteAdapter() {
    }

    public GridDistributedTxRemoteAdapter(GridCacheSharedContext<?, ?> ctx, UUID nodeId, GridCacheVersion xidVer, GridCacheVersion commitVer, boolean sys, byte plc, TransactionConcurrency concurrency, TransactionIsolation isolation, boolean invalidate, long timeout, int txSize, @Nullable UUID subjId, int taskNameHash) {
        super(ctx, nodeId, xidVer, ctx.versions().last(), Thread.currentThread().getId(), sys, plc, concurrency, isolation, timeout, txSize, subjId, taskNameHash);
        this.invalidate = invalidate;
        this.commitVersion(commitVer);
        this.started = true;
    }

    @Override
    public IgniteTxState txState() {
        return this.txState;
    }

    @Override
    public UUID eventNodeId() {
        return this.nodeId;
    }

    @Override
    public Collection<UUID> masterNodeIds() {
        return Collections.singleton(this.nodeId);
    }

    @Override
    public UUID originatingNodeId() {
        return this.nodeId;
    }

    @Override
    public boolean activeCachesDeploymentEnabled() {
        return false;
    }

    @Override
    public boolean empty() {
        return this.txState.empty();
    }

    @Override
    public void invalidate(boolean invalidate) {
        this.invalidate = invalidate;
    }

    @Override
    public Map<IgniteTxKey, IgniteTxEntry> writeMap() {
        return this.txState.writeMap();
    }

    @Override
    public Map<IgniteTxKey, IgniteTxEntry> readMap() {
        return this.txState.readMap();
    }

    @Override
    public void seal() {
    }

    @Override
    public GridTuple<CacheObject> peek(GridCacheContext cacheCtx, boolean failFast, KeyCacheObject key) throws GridCacheFilterFailedException {
        assert (false) : "Method peek can only be called on user transaction: " + this;
        throw new IllegalStateException("Method peek can only be called on user transaction: " + this);
    }

    @Override
    public IgniteTxEntry entry(IgniteTxKey key) {
        return this.txState.entry(key);
    }

    public void clearEntry(IgniteTxKey key) {
        this.txState.clearEntry(key);
    }

    @Override
    public void doneRemote(GridCacheVersion baseVer, Collection<GridCacheVersion> committedVers, Collection<GridCacheVersion> rolledbackVers, Collection<GridCacheVersion> pendingVers) {
        Map<IgniteTxKey, IgniteTxEntry> writeMap;
        Map<IgniteTxKey, IgniteTxEntry> readMap = this.txState.readMap();
        if (readMap != null && !readMap.isEmpty()) {
            for (IgniteTxEntry txEntry : readMap.values()) {
                this.doneRemote(txEntry, baseVer, committedVers, rolledbackVers, pendingVers);
            }
        }
        if ((writeMap = this.txState.writeMap()) != null && !writeMap.isEmpty()) {
            for (IgniteTxEntry txEntry : writeMap.values()) {
                this.doneRemote(txEntry, baseVer, committedVers, rolledbackVers, pendingVers);
            }
        }
    }

    @Override
    public void setPartitionUpdateCounters(long[] cntrs) {
        if (this.writeMap() != null && !this.writeMap().isEmpty() && cntrs != null && cntrs.length > 0) {
            int i = 0;
            for (IgniteTxEntry txEntry : this.writeMap().values()) {
                txEntry.updateCounter(cntrs[i]);
                ++i;
            }
        }
    }

    private void doneRemote(IgniteTxEntry txEntry, GridCacheVersion baseVer, Collection<GridCacheVersion> committedVers, Collection<GridCacheVersion> rolledbackVers, Collection<GridCacheVersion> pendingVers) {
        while (true) {
            GridDistributedCacheEntry entry = (GridDistributedCacheEntry)txEntry.cached();
            try {
                GridCacheVersion doneVer = txEntry.explicitVersion() != null ? txEntry.explicitVersion() : this.xidVer;
                entry.doneRemote(doneVer, baseVer, pendingVers, committedVers, rolledbackVers, this.isSystemInvalidate());
            }
            catch (GridCacheEntryRemovedException ignored) {
                assert (entry.obsoleteVersion() != null);
                if (log.isDebugEnabled()) {
                    log.debug("Replacing obsolete entry in remote transaction [entry=" + entry + ", tx=" + this + ']');
                }
                txEntry.cached(txEntry.context().cache().entryEx(txEntry.key(), this.topologyVersion()));
                continue;
            }
            break;
        }
    }

    @Override
    public boolean onOwnerChanged(GridCacheEntryEx entry, GridCacheMvccCandidate owner) {
        try {
            if (this.hasWriteKey(entry.txKey())) {
                this.commitIfLocked();
                return true;
            }
        }
        catch (IgniteCheckedException e) {
            U.error(log, "Failed to commit remote transaction: " + this, e);
        }
        return false;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public boolean hasWriteKey(IgniteTxKey key) {
        return this.txState.hasWriteKey(key);
    }

    public IgniteInternalFuture<IgniteInternalTx> prepareAsync() {
        assert (false);
        return null;
    }

    @Override
    public Set<IgniteTxKey> readSet() {
        return this.txState.readSet();
    }

    @Override
    public Set<IgniteTxKey> writeSet() {
        return this.txState.writeSet();
    }

    @Override
    public Collection<IgniteTxEntry> allEntries() {
        return this.txState.allEntries();
    }

    @Override
    public Collection<IgniteTxEntry> writeEntries() {
        return this.txState.writeEntries();
    }

    @Override
    public Collection<IgniteTxEntry> readEntries() {
        return this.txState.readEntries();
    }

    @Override
    public void prepare() throws IgniteCheckedException {
        if (!(this.state(TransactionState.PREPARING) || this.state() == TransactionState.PREPARING && this.optimistic())) {
            if (log.isDebugEnabled()) {
                log.debug("Invalid transaction state for prepare: " + this);
            }
            return;
        }
        try {
            this.cctx.tm().prepareTx(this);
            if (this.pessimistic() || this.isSystemInvalidate()) {
                this.state(TransactionState.PREPARED);
            }
        }
        catch (IgniteCheckedException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitIfLocked() throws IgniteCheckedException {
        if (this.state() == TransactionState.COMMITTING) {
            block8: for (IgniteTxEntry txEntry : this.writeEntries()) {
                assert (txEntry != null) : "Missing transaction entry for tx: " + this;
                while (true) {
                    GridCacheEntryEx entry = txEntry.cached();
                    assert (entry != null) : "Missing cached entry for transaction entry: " + txEntry;
                    try {
                        GridCacheVersion ver = txEntry.explicitVersion() != null ? txEntry.explicitVersion() : this.xidVer;
                        if (entry.lockedBy(ver)) continue block8;
                        if (log.isDebugEnabled()) {
                            log.debug("Transaction does not own lock for entry (will wait) [entry=" + entry + ", tx=" + this + ']');
                        }
                        return;
                    }
                    catch (GridCacheEntryRemovedException ignore) {
                        if (log.isDebugEnabled()) {
                            log.debug("Got removed entry while committing (will retry): " + txEntry);
                        }
                        txEntry.cached(txEntry.context().cache().entryEx(txEntry.key(), this.topologyVersion()));
                        continue;
                    }
                    break;
                }
            }
            if (COMMIT_ALLOWED_UPD.compareAndSet(this, 0, 1)) {
                IgniteTxHeuristicCheckedException err = null;
                Map<IgniteTxKey, IgniteTxEntry> writeMap = this.txState.writeMap();
                GridCacheReturnCompletableWrapper wrapper = null;
                if (!F.isEmpty(writeMap)) {
                    GridCacheReturn ret = null;
                    if (!this.near() && !this.local() && this.onePhaseCommit()) {
                        if (this.needReturnValue()) {
                            ret = new GridCacheReturn(null, this.cctx.localNodeId().equals(this.otherNodeId()), true, null, true);
                            UUID origNodeId = this.otherNodeId();
                            wrapper = new GridCacheReturnCompletableWrapper(!this.cctx.localNodeId().equals(origNodeId) ? origNodeId : null);
                            this.cctx.tm().addCommittedTxReturn(this, wrapper);
                        } else {
                            this.cctx.tm().addCommittedTx(this, this.nearXidVersion(), null);
                        }
                    }
                    this.cctx.tm().addCommittedTx(this);
                    AffinityTopologyVersion topVer = this.topologyVersion();
                    this.batchStoreCommit(this.writeMap().values());
                    try {
                        block10: for (IgniteTxEntry txEntry : this.near() ? this.allEntries() : this.writeEntries()) {
                            GridCacheContext<?, ?> cacheCtx = txEntry.context();
                            boolean replicate = cacheCtx.isDrEnabled();
                            while (true) {
                                try {
                                    CacheObject val0;
                                    GridCacheVersion dhtVer;
                                    GridCacheEntryEx cached = txEntry.cached();
                                    if (cached == null) {
                                        cached = cacheCtx.cache().entryEx(txEntry.key(), this.topologyVersion());
                                        txEntry.cached(cached);
                                    }
                                    if (this.near() && cacheCtx.dr().receiveEnabled()) {
                                        cached.markObsolete(this.xidVer);
                                        continue block10;
                                    }
                                    GridNearCacheEntry nearCached = null;
                                    if (this.updateNearCache(cacheCtx, txEntry.key(), topVer)) {
                                        nearCached = cacheCtx.dht().near().peekExx(txEntry.key());
                                    }
                                    if (!F.isEmpty(txEntry.entryProcessors())) {
                                        txEntry.cached().unswap(false);
                                    }
                                    IgniteBiTuple<GridCacheOperation, CacheObject> res = this.applyTransformClosures(txEntry, false, ret);
                                    GridCacheOperation op = res.get1();
                                    CacheObject val = res.get2();
                                    GridCacheVersion explicitVer = txEntry.conflictVersion();
                                    if (explicitVer == null) {
                                        explicitVer = this.writeVersion();
                                    }
                                    if (txEntry.ttl() == -2L) {
                                        op = GridCacheOperation.DELETE;
                                    }
                                    boolean conflictNeedResolve = cacheCtx.conflictNeedResolve();
                                    GridCacheVersionConflictContext conflictCtx = null;
                                    if (conflictNeedResolve) {
                                        IgniteBiTuple<GridCacheOperation, GridCacheVersionConflictContext> drRes = this.conflictResolve(op, txEntry, val, explicitVer, cached);
                                        assert (drRes != null);
                                        conflictCtx = drRes.get2();
                                        if (conflictCtx.isUseOld()) {
                                            op = GridCacheOperation.NOOP;
                                        } else if (conflictCtx.isUseNew()) {
                                            txEntry.ttl(conflictCtx.ttl());
                                            txEntry.conflictExpireTime(conflictCtx.expireTime());
                                        } else if (conflictCtx.isMerge()) {
                                            op = drRes.get1();
                                            val = txEntry.context().toCacheObject(conflictCtx.mergeValue());
                                            explicitVer = this.writeVersion();
                                            txEntry.ttl(conflictCtx.ttl());
                                            txEntry.conflictExpireTime(conflictCtx.expireTime());
                                        }
                                    } else {
                                        explicitVer = null;
                                    }
                                    GridCacheVersion gridCacheVersion = dhtVer = cached.isNear() ? this.writeVersion() : null;
                                    if (op == GridCacheOperation.CREATE || op == GridCacheOperation.UPDATE) {
                                        if (this.isSystemInvalidate() || this.isInvalidate() && cacheCtx.isNear()) {
                                            cached.innerRemove(this, this.eventNodeId(), this.nodeId, false, true, true, txEntry.keepBinary(), txEntry.hasOldValue(), txEntry.oldValue(), topVer, null, replicate ? GridDrType.DR_BACKUP : GridDrType.DR_NONE, this.near() ? null : explicitVer, CU.subjectId(this, this.cctx), this.resolveTaskName(), dhtVer, txEntry.updateCounter());
                                        } else {
                                            cached.innerSet(this, this.eventNodeId(), this.nodeId, val, false, false, txEntry.ttl(), true, true, txEntry.keepBinary(), txEntry.hasOldValue(), txEntry.oldValue(), topVer, null, replicate ? GridDrType.DR_BACKUP : GridDrType.DR_NONE, txEntry.conflictExpireTime(), this.near() ? null : explicitVer, CU.subjectId(this, this.cctx), this.resolveTaskName(), dhtVer, txEntry.updateCounter());
                                            if (nearCached != null) {
                                                val0 = cached.valueBytes();
                                                nearCached.updateOrEvict(this.xidVer, val0, cached.expireTime(), cached.ttl(), this.nodeId, topVer);
                                            }
                                        }
                                    } else if (op == GridCacheOperation.DELETE) {
                                        cached.innerRemove(this, this.eventNodeId(), this.nodeId, false, true, true, txEntry.keepBinary(), txEntry.hasOldValue(), txEntry.oldValue(), topVer, null, replicate ? GridDrType.DR_BACKUP : GridDrType.DR_NONE, this.near() ? null : explicitVer, CU.subjectId(this, this.cctx), this.resolveTaskName(), dhtVer, txEntry.updateCounter());
                                        if (nearCached != null) {
                                            nearCached.updateOrEvict(this.xidVer, null, 0L, 0L, this.nodeId, topVer);
                                        }
                                    } else if (op == GridCacheOperation.RELOAD) {
                                        CacheObject reloaded = cached.innerReload();
                                        if (nearCached != null) {
                                            nearCached.innerReload();
                                            nearCached.updateOrEvict(cached.version(), reloaded, cached.expireTime(), cached.ttl(), this.nodeId, topVer);
                                        }
                                    } else if (op == GridCacheOperation.READ) {
                                        assert (this.near());
                                        if (log.isDebugEnabled()) {
                                            log.debug("Ignoring READ entry when committing: " + txEntry);
                                        }
                                    } else if (conflictCtx == null || !conflictCtx.isUseOld()) {
                                        if (txEntry.ttl() != -1L) {
                                            cached.updateTtl(null, txEntry.ttl());
                                        }
                                        if (nearCached != null) {
                                            val0 = cached.valueBytes();
                                            nearCached.updateOrEvict(this.xidVer, val0, cached.expireTime(), cached.ttl(), this.nodeId, topVer);
                                        }
                                    }
                                    assert (txEntry.op() == GridCacheOperation.READ || this.onePhaseCommit() || !cached.hasLockCandidateUnsafe(this.xidVer) || cached.lockedByUnsafe(this.xidVer)) : "Transaction does not own lock for commit [entry=" + cached + ", tx=" + this + ']';
                                    continue block10;
                                }
                                catch (GridCacheEntryRemovedException ignored) {
                                    if (log.isDebugEnabled()) {
                                        log.debug("Attempting to commit a removed entry (will retry): " + txEntry);
                                    }
                                    txEntry.cached(cacheCtx.cache().entryEx(txEntry.key(), this.topologyVersion()));
                                    continue;
                                }
                                break;
                            }
                        }
                        if (wrapper != null) {
                            wrapper.initialize(ret);
                        }
                    }
                    catch (Throwable ex) {
                        try {
                            err = new IgniteTxHeuristicCheckedException("Commit produced a runtime exception (all transaction entries will be invalidated): " + CU.txString(this), ex);
                            U.error(log, "Commit failed.", err);
                            this.uncommit();
                            this.state(TransactionState.UNKNOWN);
                            if (ex instanceof Error) {
                                throw (Error)ex;
                            }
                            if (wrapper != null) {
                                wrapper.initialize(ret);
                            }
                        }
                        catch (Throwable throwable) {
                            if (wrapper != null) {
                                wrapper.initialize(ret);
                            }
                            throw throwable;
                        }
                    }
                }
                if (err != null) {
                    this.state(TransactionState.UNKNOWN);
                    throw err;
                }
                this.cctx.tm().commitTx(this);
                this.state(TransactionState.COMMITTED);
            }
        }
    }

    @Override
    public void commit() throws IgniteCheckedException {
        if (this.optimistic()) {
            this.state(TransactionState.PREPARED);
        }
        if (!this.state(TransactionState.COMMITTING)) {
            TransactionState state = this.state();
            if (state == TransactionState.COMMITTING || state == TransactionState.COMMITTED) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Failed to set COMMITTING transaction state (will rollback): " + this);
            }
            this.setRollbackOnly();
            if (!this.isSystemInvalidate()) {
                throw new IgniteCheckedException("Invalid transaction state for commit [state=" + (Object)((Object)state) + ", tx=" + this + ']');
            }
            this.rollback();
        }
        this.commitIfLocked();
    }

    public void forceCommit() throws IgniteCheckedException {
        this.commitIfLocked();
    }

    @Override
    public IgniteInternalFuture<IgniteInternalTx> commitAsync() {
        try {
            this.commit();
            return new GridFinishedFuture<IgniteInternalTx>(this);
        }
        catch (IgniteCheckedException e) {
            return new GridFinishedFuture<IgniteInternalTx>(e);
        }
    }

    @Override
    public void rollback() {
        try {
            if (this.state(TransactionState.ROLLING_BACK) || this.state() == TransactionState.UNKNOWN) {
                this.cctx.tm().rollbackTx(this);
                this.state(TransactionState.ROLLED_BACK);
            }
        }
        catch (Error | RuntimeException e) {
            this.state(TransactionState.UNKNOWN);
            throw e;
        }
    }

    @Override
    public IgniteInternalFuture<IgniteInternalTx> rollbackAsync() {
        this.rollback();
        return new GridFinishedFuture<IgniteInternalTx>(this);
    }

    @Override
    public Collection<GridCacheVersion> alternateVersions() {
        return this.explicitVers == null ? Collections.emptyList() : this.explicitVers;
    }

    @Override
    public void commitError(Throwable e) {
    }

    protected void addExplicit(IgniteTxEntry e) {
        if (e.explicitVersion() != null) {
            if (this.explicitVers == null) {
                this.explicitVers = new LinkedList<GridCacheVersion>();
            }
            if (!this.explicitVers.contains(e.explicitVersion())) {
                this.explicitVers.add(e.explicitVersion());
                if (log.isDebugEnabled()) {
                    log.debug("Added explicit version to transaction [explicitVer=" + e.explicitVersion() + ", tx=" + this + ']');
                }
                this.cctx.tm().addAlternateVersion(e.explicitVersion(), this);
            }
        }
    }

    @Override
    public String toString() {
        return GridToStringBuilder.toString(GridDistributedTxRemoteAdapter.class, this, "super", super.toString());
    }
}

