/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheConcurrentMap;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheMapEntry;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtLocalPartition;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class GridCachePartitionedConcurrentMap
implements GridCacheConcurrentMap {
    private final GridCacheContext ctx;

    public GridCachePartitionedConcurrentMap(GridCacheContext ctx) {
        this.ctx = ctx;
    }

    @Nullable
    private GridDhtLocalPartition localPartition(KeyCacheObject key, AffinityTopologyVersion topVer, boolean create) {
        int p = key.partition();
        if (p == -1) {
            p = this.ctx.affinity().partition(key);
        }
        return this.ctx.topology().localPartition(p, topVer, create);
    }

    @Override
    @Nullable
    public GridCacheMapEntry getEntry(KeyCacheObject key) {
        GridDhtLocalPartition part = this.localPartition(key, AffinityTopologyVersion.NONE, false);
        if (part == null) {
            return null;
        }
        return part.getEntry(key);
    }

    @Override
    public GridCacheMapEntry putEntryIfObsoleteOrAbsent(AffinityTopologyVersion topVer, KeyCacheObject key, @Nullable CacheObject val, boolean create, boolean touch) {
        GridDhtLocalPartition part = this.localPartition(key, topVer, create);
        if (part == null) {
            return null;
        }
        return part.putEntryIfObsoleteOrAbsent(topVer, key, val, create, touch);
    }

    @Override
    public int size() {
        int size = 0;
        for (GridDhtLocalPartition part : this.ctx.topology().currentLocalPartitions()) {
            size += part.size();
        }
        return size;
    }

    @Override
    public int publicSize() {
        int size = 0;
        for (GridDhtLocalPartition part : this.ctx.topology().currentLocalPartitions()) {
            size += part.publicSize();
        }
        return size;
    }

    @Override
    public void incrementPublicSize(GridCacheEntryEx e) {
        this.localPartition(e.key(), AffinityTopologyVersion.NONE, true).incrementPublicSize(e);
    }

    @Override
    public void decrementPublicSize(GridCacheEntryEx e) {
        this.localPartition(e.key(), AffinityTopologyVersion.NONE, true).decrementPublicSize(e);
    }

    @Override
    public boolean removeEntry(GridCacheEntryEx entry) {
        GridDhtLocalPartition part = this.localPartition(entry.key(), AffinityTopologyVersion.NONE, false);
        if (part == null) {
            return false;
        }
        return part.removeEntry(entry);
    }

    @Override
    @Nullable
    public GridCacheMapEntry randomEntry() {
        return this.entries(new CacheEntryPredicate[0]).iterator().next();
    }

    @Override
    public Set<KeyCacheObject> keySet(final CacheEntryPredicate ... filter) {
        return new PartitionedSet<KeyCacheObject>(){

            @Override
            protected Set<KeyCacheObject> set(GridDhtLocalPartition part) {
                return part.keySet(filter);
            }
        };
    }

    @Override
    public Iterable<GridCacheMapEntry> entries(final CacheEntryPredicate ... filter) {
        return new Iterable<GridCacheMapEntry>(){

            @Override
            public Iterator<GridCacheMapEntry> iterator() {
                return new PartitionedIterator<GridCacheMapEntry>(){

                    @Override
                    protected Iterator<GridCacheMapEntry> iterator(GridDhtLocalPartition part) {
                        return part.entries(filter).iterator();
                    }
                };
            }
        };
    }

    @Override
    public Iterable<GridCacheMapEntry> allEntries(final CacheEntryPredicate ... filter) {
        return new Iterable<GridCacheMapEntry>(){

            @Override
            public Iterator<GridCacheMapEntry> iterator() {
                return new PartitionedIterator<GridCacheMapEntry>(){

                    @Override
                    protected Iterator<GridCacheMapEntry> iterator(GridDhtLocalPartition part) {
                        return part.allEntries(filter).iterator();
                    }
                };
            }
        };
    }

    @Override
    public Set<GridCacheMapEntry> entrySet(final CacheEntryPredicate ... filter) {
        return new PartitionedSet<GridCacheMapEntry>(){

            @Override
            protected Set<GridCacheMapEntry> set(GridDhtLocalPartition part) {
                return part.entrySet(filter);
            }
        };
    }

    public String toString() {
        return S.toString(GridCachePartitionedConcurrentMap.class, this);
    }

    private abstract class PartitionedSet<T>
    extends AbstractSet<T> {
        private PartitionedSet() {
        }

        protected abstract Set<T> set(GridDhtLocalPartition var1);

        @Override
        public Iterator<T> iterator() {
            return new PartitionedIterator<T>(){

                @Override
                protected Iterator<T> iterator(GridDhtLocalPartition part) {
                    return PartitionedSet.this.set(part).iterator();
                }
            };
        }

        @Override
        public int size() {
            int size = 0;
            for (GridDhtLocalPartition part : GridCachePartitionedConcurrentMap.this.ctx.topology().currentLocalPartitions()) {
                size += this.set(part).size();
            }
            return size;
        }

        @Override
        public boolean contains(Object o) {
            for (GridDhtLocalPartition part : GridCachePartitionedConcurrentMap.this.ctx.topology().currentLocalPartitions()) {
                if (!this.set(part).contains(o)) continue;
                return true;
            }
            return false;
        }
    }

    private abstract class PartitionedIterator<T>
    implements Iterator<T> {
        private Iterator<GridDhtLocalPartition> partsIter;
        private Iterator<T> currIter;

        private PartitionedIterator() {
            this.partsIter = GridCachePartitionedConcurrentMap.this.ctx.topology().currentLocalPartitions().iterator();
            this.currIter = this.partsIter.hasNext() ? this.iterator(this.partsIter.next()) : Collections.emptyIterator();
        }

        protected abstract Iterator<T> iterator(GridDhtLocalPartition var1);

        @Override
        public boolean hasNext() {
            if (this.currIter.hasNext()) {
                return true;
            }
            while (this.partsIter.hasNext()) {
                this.currIter = this.iterator(this.partsIter.next());
                if (!this.currIter.hasNext()) continue;
                return true;
            }
            return false;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                return this.currIter.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

