/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTopologyFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionExchangeId;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionFullMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionMap2;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.util.GridAtomicLong;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

@GridToStringExclude
public class GridClientPartitionTopology
implements GridDhtPartitionTopology {
    private static final boolean CONSISTENCY_CHECK = false;
    private static final boolean FULL_MAP_DEBUG = false;
    private static final Long ZERO = 0L;
    private GridCacheSharedContext cctx;
    private int cacheId;
    private final IgniteLogger log;
    private GridDhtPartitionFullMap node2part;
    private Map<Integer, Set<UUID>> part2node = new HashMap<Integer, Set<UUID>>();
    private GridDhtPartitionExchangeId lastExchangeId;
    private AffinityTopologyVersion topVer = AffinityTopologyVersion.NONE;
    private volatile boolean stopping;
    private GridDhtTopologyFuture topReadyFut;
    private final GridAtomicLong updateSeq = new GridAtomicLong(1L);
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Map<Integer, Long> cntrMap = new HashMap<Integer, Long>();
    private final Object similarAffKey;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridClientPartitionTopology(GridCacheSharedContext cctx, int cacheId, GridDhtPartitionsExchangeFuture exchFut, Object similarAffKey) {
        this.cctx = cctx;
        this.cacheId = cacheId;
        this.similarAffKey = similarAffKey;
        this.topVer = exchFut.topologyVersion();
        this.log = cctx.logger(this.getClass());
        this.lock.writeLock().lock();
        try {
            this.beforeExchange0(cctx.localNode(), exchFut);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Nullable
    public Object similarAffinityKey() {
        return this.similarAffKey;
    }

    private String fullMapString() {
        return this.node2part == null ? "null" : this.node2part.toString();
    }

    private String mapString(GridDhtPartitionMap2 map) {
        return map == null ? "null" : map.toString();
    }

    public int cacheId() {
        return this.cacheId;
    }

    @Override
    public void readLock() {
        this.lock.readLock().lock();
    }

    @Override
    public void readUnlock() {
        this.lock.readLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTopologyVersion(GridDhtPartitionExchangeId exchId, GridDhtPartitionsExchangeFuture exchFut, long updSeq, boolean stopping) throws IgniteInterruptedCheckedException {
        U.writeLock(this.lock);
        try {
            assert (exchId.topologyVersion().compareTo(this.topVer) > 0) : "Invalid topology version [topVer=" + this.topVer + ", exchId=" + exchId + ']';
            this.stopping = stopping;
            this.topVer = exchId.topologyVersion();
            this.updateSeq.setIfGreater(updSeq);
            this.topReadyFut = exchFut;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AffinityTopologyVersion topologyVersion() {
        this.lock.readLock().lock();
        try {
            assert (this.topVer.topologyVersion() > 0L);
            AffinityTopologyVersion affinityTopologyVersion = this.topVer;
            return affinityTopologyVersion;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridDhtTopologyFuture topologyVersionFuture() {
        this.lock.readLock().lock();
        try {
            assert (this.topReadyFut != null);
            GridDhtTopologyFuture gridDhtTopologyFuture = this.topReadyFut;
            return gridDhtTopologyFuture;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean stopping() {
        return this.stopping;
    }

    @Override
    public void initPartitions(GridDhtPartitionsExchangeFuture exchFut) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeExchange(GridDhtPartitionsExchangeFuture exchFut, boolean initParts) throws IgniteCheckedException {
        ClusterNode loc = this.cctx.localNode();
        U.writeLock(this.lock);
        try {
            if (this.stopping) {
                return;
            }
            this.beforeExchange0(loc, exchFut);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void beforeExchange0(ClusterNode loc, GridDhtPartitionsExchangeFuture exchFut) {
        GridDhtPartitionExchangeId exchId = exchFut.exchangeId();
        assert (this.topVer.equals(exchId.topologyVersion())) : "Invalid topology version [topVer=" + this.topVer + ", exchId=" + exchId + ']';
        if (!exchId.isJoined()) {
            this.removeNode(exchId.nodeId());
        }
        ClusterNode oldest = this.cctx.discovery().oldestAliveCacheServerNode(this.topVer);
        assert (oldest != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Partition map beforeExchange [exchId=" + exchId + ", fullMap=" + this.fullMapString() + ']');
        }
        long updateSeq = this.updateSeq.incrementAndGet();
        if (oldest.id().equals(loc.id()) || exchFut.isCacheAdded(this.cacheId, exchId.topologyVersion())) {
            if (this.node2part == null) {
                this.node2part = new GridDhtPartitionFullMap(oldest.id(), oldest.order(), updateSeq);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Created brand new full topology map on oldest node [exchId=" + exchId + ", fullMap=" + this.fullMapString() + ']');
                }
            } else if (!this.node2part.valid()) {
                this.node2part = new GridDhtPartitionFullMap(oldest.id(), oldest.order(), updateSeq, this.node2part, false);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Created new full topology map on oldest node [exchId=" + exchId + ", fullMap=" + this.node2part + ']');
                }
            } else if (!this.node2part.nodeId().equals(loc.id())) {
                this.node2part = new GridDhtPartitionFullMap(oldest.id(), oldest.order(), updateSeq, this.node2part, false);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Copied old map into new map on oldest node (previous oldest node left) [exchId=" + exchId + ", fullMap=" + this.fullMapString() + ']');
                }
            }
        }
        this.consistencyCheck();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Partition map after beforeExchange [exchId=" + exchId + ", fullMap=" + this.fullMapString() + ']');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean afterExchange(GridDhtPartitionsExchangeFuture exchFut) throws IgniteCheckedException {
        AffinityTopologyVersion topVer = exchFut.topologyVersion();
        this.lock.writeLock().lock();
        try {
            assert (topVer.equals(exchFut.topologyVersion())) : "Invalid topology version [topVer=" + topVer + ", exchId=" + exchFut.exchangeId() + ']';
            if (this.log.isDebugEnabled()) {
                this.log.debug("Partition map before afterExchange [exchId=" + exchFut.exchangeId() + ", fullMap=" + this.fullMapString() + ']');
            }
            this.updateSeq.incrementAndGet();
            this.consistencyCheck();
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return false;
    }

    @Override
    @Nullable
    public GridDhtLocalPartition localPartition(int p, AffinityTopologyVersion topVer, boolean create) throws GridDhtInvalidPartitionException {
        if (!create) {
            return null;
        }
        throw new GridDhtInvalidPartitionException(p, "Adding entry to evicted partition (often may be caused by inconsistent 'key.hashCode()' implementation) [part=" + p + ", topVer=" + topVer + ", this.topVer=" + this.topVer + ']');
    }

    @Override
    public GridDhtLocalPartition localPartition(Object key, boolean create) {
        return this.localPartition(1, AffinityTopologyVersion.NONE, create);
    }

    @Override
    public void releasePartitions(int ... parts) {
    }

    @Override
    public List<GridDhtLocalPartition> localPartitions() {
        return Collections.emptyList();
    }

    public Collection<GridDhtLocalPartition> currentLocalPartitions() {
        return Collections.emptyList();
    }

    @Override
    public void onRemoved(GridDhtCacheEntry e) {
        assert (false) : "Entry should not be removed from client topology: " + e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridDhtPartitionMap2 localPartitionMap() {
        this.lock.readLock().lock();
        try {
            GridDhtPartitionMap2 gridDhtPartitionMap2 = new GridDhtPartitionMap2(this.cctx.localNodeId(), this.updateSeq.get(), this.topVer, Collections.emptyMap(), true);
            return gridDhtPartitionMap2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridDhtPartitionState partitionState(UUID nodeId, int part) {
        this.lock.readLock().lock();
        try {
            GridDhtPartitionMap2 partMap = (GridDhtPartitionMap2)this.node2part.get(nodeId);
            if (partMap != null) {
                GridDhtPartitionState state = partMap.get(part);
                GridDhtPartitionState gridDhtPartitionState = state == null ? GridDhtPartitionState.EVICTED : state;
                return gridDhtPartitionState;
            }
            GridDhtPartitionState gridDhtPartitionState = GridDhtPartitionState.EVICTED;
            return gridDhtPartitionState;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ClusterNode> nodes(int p, AffinityTopologyVersion topVer) {
        this.lock.readLock().lock();
        try {
            assert (this.node2part != null && this.node2part.valid()) : "Invalid node-to-partitions map [topVer=" + topVer + ", node2part=" + this.node2part + ']';
            ArrayList<ClusterNode> nodes = null;
            Collection nodeIds = this.part2node.get(p);
            if (!F.isEmpty(nodeIds)) {
                for (UUID nodeId : nodeIds) {
                    ClusterNode n = this.cctx.discovery().node(nodeId);
                    if (n == null || topVer.topologyVersion() >= 0L && n.order() > topVer.topologyVersion()) continue;
                    if (nodes == null) {
                        nodes = new ArrayList<ClusterNode>(nodeIds.size());
                    }
                    nodes.add(n);
                }
            }
            ArrayList<ClusterNode> arrayList = nodes;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ClusterNode> nodes(int p, AffinityTopologyVersion topVer, GridDhtPartitionState state, GridDhtPartitionState ... states) {
        Collection<UUID> allIds = topVer.topologyVersion() > 0L ? F.nodeIds(CU.allNodes(this.cctx, topVer)) : null;
        this.lock.readLock().lock();
        try {
            int size;
            assert (this.node2part != null && this.node2part.valid()) : "Invalid node-to-partitions map [topVer=" + topVer + ", allIds=" + allIds + ", node2part=" + this.node2part + ']';
            Collection nodeIds = this.part2node.get(p);
            int n = size = nodeIds == null ? 0 : nodeIds.size();
            if (size == 0) {
                List<ClusterNode> list = Collections.emptyList();
                return list;
            }
            ArrayList<ClusterNode> nodes = new ArrayList<ClusterNode>(size);
            for (UUID id : nodeIds) {
                ClusterNode n2;
                if (topVer.topologyVersion() > 0L && !allIds.contains(id) || !this.hasState(p, id, state, states) || (n2 = this.cctx.discovery().node(id)) == null || topVer.topologyVersion() >= 0L && n2.order() > topVer.topologyVersion()) continue;
                nodes.add(n2);
            }
            ArrayList<ClusterNode> arrayList = nodes;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public List<ClusterNode> owners(int p, AffinityTopologyVersion topVer) {
        return this.nodes(p, topVer, GridDhtPartitionState.OWNING, new GridDhtPartitionState[0]);
    }

    @Override
    public List<ClusterNode> owners(int p) {
        return this.owners(p, AffinityTopologyVersion.NONE);
    }

    @Override
    public List<ClusterNode> moving(int p) {
        return this.nodes(p, AffinityTopologyVersion.NONE, GridDhtPartitionState.MOVING, new GridDhtPartitionState[0]);
    }

    private List<ClusterNode> ownersAndMoving(int p, AffinityTopologyVersion topVer) {
        return this.nodes(p, topVer, GridDhtPartitionState.OWNING, GridDhtPartitionState.MOVING);
    }

    @Override
    public long updateSequence() {
        return this.updateSeq.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long lastUpdateSequence() {
        this.lock.writeLock().lock();
        try {
            long l = this.updateSeq.incrementAndGet();
            return l;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridDhtPartitionFullMap partitionMap(boolean onlyActive) {
        this.lock.readLock().lock();
        try {
            assert (this.node2part != null && this.node2part.valid()) : "Invalid node2part [node2part: " + this.node2part + ", locNodeId=" + this.cctx.localNodeId() + ", gridName=" + this.cctx.gridName() + ']';
            GridDhtPartitionFullMap m = this.node2part;
            GridDhtPartitionFullMap gridDhtPartitionFullMap = new GridDhtPartitionFullMap(m.nodeId(), m.nodeOrder(), m.updateSequence(), m, onlyActive);
            return gridDhtPartitionFullMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public boolean update(@Nullable GridDhtPartitionExchangeId exchId, GridDhtPartitionFullMap partMap, Map<Integer, Long> cntrMap) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Updating full partition map [exchId=" + exchId + ", parts=" + this.fullMapString() + ']');
        }
        this.lock.writeLock().lock();
        try {
            if (exchId != null && this.lastExchangeId != null && this.lastExchangeId.compareTo(exchId) >= 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Stale exchange id for full partition map update (will ignore) [lastExchId=" + this.lastExchangeId + ", exchId=" + exchId + ']');
                }
                boolean bl = false;
                return bl;
            }
            if (this.node2part != null && this.node2part.compareTo(partMap) >= 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Stale partition map for full partition map update (will ignore) [lastExchId=" + this.lastExchangeId + ", exchId=" + exchId + ", curMap=" + this.node2part + ", newMap=" + partMap + ']');
                }
                boolean bl = false;
                return bl;
            }
            this.updateSeq.incrementAndGet();
            if (exchId != null) {
                this.lastExchangeId = exchId;
            }
            if (this.node2part != null) {
                for (GridDhtPartitionMap2 part : this.node2part.values()) {
                    GridDhtPartitionMap2 newPart = (GridDhtPartitionMap2)partMap.get(part.nodeId());
                    if (newPart == null || newPart.updateSequence() >= part.updateSequence()) continue;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Overriding partition map in full update map [exchId=" + exchId + ", curPart=" + this.mapString(part) + ", newPart=" + this.mapString(newPart) + ']');
                    }
                    partMap.put(part.nodeId(), part);
                }
                Iterator it = partMap.keySet().iterator();
                while (it.hasNext()) {
                    UUID nodeId = (UUID)it.next();
                    if (this.cctx.discovery().alive(nodeId)) continue;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Removing left node from full map update [nodeId=" + nodeId + ", partMap=" + partMap + ']');
                    }
                    it.remove();
                }
            }
            this.node2part = partMap;
            HashMap<Integer, Set<UUID>> p2n = new HashMap<Integer, Set<UUID>>();
            for (Map.Entry e : partMap.entrySet()) {
                for (Integer p : ((GridDhtPartitionMap2)e.getValue()).keySet()) {
                    HashSet ids = (HashSet)p2n.get(p);
                    if (ids == null) {
                        ids = U.newHashSet(3);
                        p2n.put(p, ids);
                    }
                    ids.add(e.getKey());
                }
            }
            this.part2node = p2n;
            if (cntrMap != null) {
                this.cntrMap = new HashMap<Integer, Long>(cntrMap);
            }
            this.consistencyCheck();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Partition map after full update: " + this.fullMapString());
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public boolean update(@Nullable GridDhtPartitionExchangeId exchId, GridDhtPartitionMap2 parts, Map<Integer, Long> cntrMap, boolean checkEvictions) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Updating single partition map [exchId=" + exchId + ", parts=" + this.mapString(parts) + ']');
        }
        if (!this.cctx.discovery().alive(parts.nodeId())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Received partition update for non-existing node (will ignore) [exchId=" + exchId + ", parts=" + parts + ']');
            }
            return false;
        }
        this.lock.writeLock().lock();
        try {
            boolean changed;
            GridDhtPartitionMap2 cur;
            if (this.stopping) {
                boolean bl = false;
                return bl;
            }
            if (this.lastExchangeId != null && exchId != null && this.lastExchangeId.compareTo(exchId) > 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Stale exchange id for single partition map update (will ignore) [lastExchId=" + this.lastExchangeId + ", exchId=" + exchId + ']');
                }
                boolean bl = false;
                return bl;
            }
            if (exchId != null) {
                this.lastExchangeId = exchId;
            }
            if (this.node2part == null) {
                this.node2part = new GridDhtPartitionFullMap();
            }
            if ((cur = (GridDhtPartitionMap2)this.node2part.get(parts.nodeId())) != null && cur.updateSequence() >= parts.updateSequence()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Stale update sequence for single partition map update (will ignore) [exchId=" + exchId + ", curSeq=" + cur.updateSequence() + ", newSeq=" + parts.updateSequence() + ']');
                }
                boolean bl = false;
                return bl;
            }
            long updateSeq = this.updateSeq.incrementAndGet();
            this.node2part.updateSequence(updateSeq);
            boolean bl = changed = cur == null || !cur.equals(parts);
            if (changed) {
                Set<UUID> ids;
                this.node2part.put(parts.nodeId(), parts);
                for (Integer n : parts.keySet()) {
                    ids = this.part2node.get(n);
                    if (ids == null) {
                        ids = U.newHashSet(3);
                        this.part2node.put(n, ids);
                    }
                    ids.add(parts.nodeId());
                }
                if (cur != null) {
                    for (Integer n : cur.keySet()) {
                        if (parts.containsKey(n) || (ids = this.part2node.get(n)) == null) continue;
                        ids.remove(parts.nodeId());
                    }
                }
            } else {
                cur.updateSequence(parts.updateSequence(), parts.topologyVersion());
            }
            if (cntrMap != null) {
                for (Map.Entry entry : cntrMap.entrySet()) {
                    Long cntr = this.cntrMap.get(entry.getKey());
                    if (cntr != null && cntr >= (Long)entry.getValue()) continue;
                    this.cntrMap.put((Integer)entry.getKey(), (Long)entry.getValue());
                }
            }
            this.consistencyCheck();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Partition map after single update: " + this.fullMapString());
            }
            boolean bl2 = changed;
            return bl2;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void checkEvictions() {
    }

    private void updateLocal(int p, UUID nodeId, GridDhtPartitionState state, long updateSeq) {
        GridDhtPartitionMap2 map;
        long seq;
        assert (this.lock.isWriteLockedByCurrentThread());
        assert (nodeId.equals(this.cctx.localNodeId()));
        ClusterNode oldest = this.cctx.discovery().oldestAliveCacheServerNode(this.topVer);
        if (oldest.id().equals(this.cctx.localNodeId()) && (seq = this.node2part.updateSequence()) != updateSeq) {
            if (seq > updateSeq) {
                if (this.updateSeq.get() < seq) {
                    boolean b = this.updateSeq.compareAndSet(this.updateSeq.get(), seq + 1L);
                    assert (b) : "Invalid update sequence [updateSeq=" + updateSeq + ", seq=" + seq + ", curUpdateSeq=" + this.updateSeq.get() + ", node2part=" + this.node2part.toFullString() + ']';
                    updateSeq = seq + 1L;
                } else {
                    updateSeq = seq;
                }
            }
            this.node2part.updateSequence(updateSeq);
        }
        if ((map = (GridDhtPartitionMap2)this.node2part.get(nodeId)) == null) {
            map = new GridDhtPartitionMap2(nodeId, updateSeq, this.topVer, Collections.emptyMap(), false);
            this.node2part.put(nodeId, map);
        }
        map.updateSequence(updateSeq, this.topVer);
        map.put(p, state);
        Set<UUID> ids = this.part2node.get(p);
        if (ids == null) {
            ids = U.newHashSet(3);
            this.part2node.put(p, ids);
        }
        ids.add(nodeId);
    }

    private void removeNode(UUID nodeId) {
        assert (nodeId != null);
        assert (this.lock.writeLock().isHeldByCurrentThread());
        ClusterNode oldest = this.cctx.discovery().oldestAliveCacheServerNode(this.topVer);
        ClusterNode loc = this.cctx.localNode();
        if (this.node2part != null) {
            if (oldest.equals(loc) && !this.node2part.nodeId().equals(loc.id())) {
                this.updateSeq.setIfGreater(this.node2part.updateSequence());
                this.node2part = new GridDhtPartitionFullMap(loc.id(), loc.order(), this.updateSeq.incrementAndGet(), this.node2part, false);
            } else {
                this.node2part = new GridDhtPartitionFullMap(this.node2part, this.node2part.updateSequence());
            }
            this.part2node = new HashMap<Integer, Set<UUID>>(this.part2node);
            GridDhtPartitionMap2 parts = (GridDhtPartitionMap2)this.node2part.remove(nodeId);
            if (parts != null) {
                for (Integer p : parts.keySet()) {
                    Set<UUID> nodeIds = this.part2node.get(p);
                    if (nodeIds == null) continue;
                    nodeIds.remove(nodeId);
                    if (!nodeIds.isEmpty()) continue;
                    this.part2node.remove(p);
                }
            }
            this.consistencyCheck();
        }
    }

    @Override
    public boolean own(GridDhtLocalPartition part) {
        assert (false) : "Client topology should never own a partition: " + part;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEvicted(GridDhtLocalPartition part, boolean updateSeq) {
        assert (updateSeq || this.lock.isWriteLockedByCurrentThread());
        this.lock.writeLock().lock();
        try {
            if (this.stopping) {
                return;
            }
            assert (part.state() == GridDhtPartitionState.EVICTED);
            long seq = updateSeq ? this.updateSeq.incrementAndGet() : this.updateSeq.get();
            this.updateLocal(part.id(), this.cctx.localNodeId(), part.state(), seq);
            this.consistencyCheck();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Integer, Long> updateCounters(boolean skipZeros) {
        this.lock.readLock().lock();
        try {
            if (skipZeros) {
                HashMap<Integer, Long> res = U.newHashMap(this.cntrMap.size());
                for (Map.Entry<Integer, Long> e : this.cntrMap.entrySet()) {
                    if (e.getValue().equals(ZERO)) continue;
                    res.put(e.getKey(), e.getValue());
                }
                HashMap<Integer, Long> hashMap = res;
                return hashMap;
            }
            HashMap<Integer, Long> hashMap = new HashMap<Integer, Long>(this.cntrMap);
            return hashMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean rebalanceFinished(AffinityTopologyVersion topVer) {
        assert (false) : "Should not be called on non-affinity node";
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasMovingPartitions() {
        this.lock.readLock().lock();
        try {
            assert (this.node2part != null && this.node2part.valid()) : "Invalid node2part [node2part: " + this.node2part + ", locNodeId=" + this.cctx.localNodeId() + ", gridName=" + this.cctx.gridName() + ']';
            for (GridDhtPartitionMap2 map : this.node2part.values()) {
                if (!map.hasMovingPartitions()) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void printMemoryStats(int threshold) {
        X.println(">>>  Cache partition topology stats [grid=" + this.cctx.gridName() + ", cacheId=" + this.cacheId + ']', new Object[0]);
    }

    private boolean hasState(int p, @Nullable UUID nodeId, GridDhtPartitionState match, GridDhtPartitionState ... matches) {
        if (nodeId == null) {
            return false;
        }
        GridDhtPartitionMap2 parts = (GridDhtPartitionMap2)this.node2part.get(nodeId);
        if (parts != null) {
            GridDhtPartitionState state = parts.get(p);
            if (state == match) {
                return true;
            }
            if (matches != null && matches.length > 0) {
                for (GridDhtPartitionState s : matches) {
                    if (state != s) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void consistencyCheck() {
    }
}

