/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.apache.ignite.spi.discovery.tcp.internal.TcpDiscoveryNode;
import org.jetbrains.annotations.NotNull;

public class GridDhtAffinityAssignmentResponse
extends GridCacheMessage {
    private static final long serialVersionUID = 0L;
    private AffinityTopologyVersion topVer;
    @GridDirectTransient
    @GridToStringInclude
    private List<List<ClusterNode>> affAssignment;
    private byte[] affAssignmentBytes;
    @GridDirectTransient
    private List<List<UUID>> affAssignmentIds;
    private byte[] affAssignmentIdsBytes;
    @GridDirectTransient
    private List<List<UUID>> idealAffAssignment;
    private byte[] idealAffAssignmentBytes;

    public GridDhtAffinityAssignmentResponse() {
    }

    public GridDhtAffinityAssignmentResponse(int cacheId, @NotNull AffinityTopologyVersion topVer, List<List<ClusterNode>> affAssignment, boolean sndNodeIds) {
        this.cacheId = cacheId;
        this.topVer = topVer;
        if (!sndNodeIds) {
            this.affAssignment = affAssignment;
        } else {
            this.affAssignmentIds = this.ids(affAssignment);
        }
    }

    @Override
    public boolean partitionExchangeMessage() {
        return true;
    }

    @Override
    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    public List<List<ClusterNode>> affinityAssignment(GridDiscoveryManager disco) {
        if (this.affAssignment != null) {
            return this.affAssignment;
        }
        if (this.affAssignmentIds != null) {
            this.affAssignment = this.nodes(disco, this.affAssignmentIds);
        }
        return this.affAssignment;
    }

    public List<List<ClusterNode>> idealAffinityAssignment(GridDiscoveryManager disco) {
        return this.nodes(disco, this.idealAffAssignment);
    }

    private List<List<ClusterNode>> nodes(GridDiscoveryManager disco, List<List<UUID>> assignmentIds) {
        if (assignmentIds != null) {
            ArrayList<List<ClusterNode>> assignment = new ArrayList<List<ClusterNode>>(assignmentIds.size());
            for (int i = 0; i < assignmentIds.size(); ++i) {
                List<UUID> ids = assignmentIds.get(i);
                ArrayList<ClusterNode> nodes = new ArrayList<ClusterNode>(ids.size());
                for (int j = 0; j < ids.size(); ++j) {
                    ClusterNode node = disco.node(this.topVer, ids.get(j));
                    assert (node != null);
                    nodes.add(node);
                }
                assignment.add(nodes);
            }
            return assignment;
        }
        return null;
    }

    public void idealAffinityAssignment(List<List<ClusterNode>> idealAffAssignment) {
        this.idealAffAssignment = this.ids(idealAffAssignment);
    }

    private List<List<UUID>> ids(List<List<ClusterNode>> assignments) {
        if (assignments != null) {
            ArrayList<List<UUID>> assignment = new ArrayList<List<UUID>>(assignments.size());
            for (int i = 0; i < assignments.size(); ++i) {
                List<ClusterNode> nodes = assignments.get(i);
                ArrayList<UUID> ids = new ArrayList<UUID>(nodes.size());
                for (int j = 0; j < nodes.size(); ++j) {
                    ids.add(nodes.get(j).id());
                }
                assignment.add(ids);
            }
            return assignment;
        }
        return null;
    }

    @Override
    public byte directType() {
        return 29;
    }

    @Override
    public byte fieldsCount() {
        return 7;
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        assert (this.affAssignment != null ^ this.affAssignmentIds != null);
        if (this.affAssignment != null && this.affAssignmentBytes == null) {
            this.affAssignmentBytes = U.marshal(ctx, this.affAssignment);
        }
        if (this.affAssignmentIds != null && this.affAssignmentIdsBytes == null) {
            this.affAssignmentIdsBytes = U.marshal(ctx, this.affAssignmentIds);
        }
        if (this.idealAffAssignment != null && this.idealAffAssignmentBytes == null) {
            this.idealAffAssignmentBytes = U.marshal(ctx, this.idealAffAssignment);
        }
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        assert (this.affAssignmentBytes != null ^ this.affAssignmentIdsBytes != null);
        ldr = U.resolveClassLoader(ldr, ctx.gridConfig());
        if (this.affAssignmentBytes != null && this.affAssignment == null) {
            this.affAssignment = this.unmarshalNodes(this.affAssignmentBytes, ctx, ldr);
        }
        if (this.affAssignmentIdsBytes != null && this.affAssignmentIds == null) {
            this.affAssignmentIds = (List)U.unmarshal(ctx, this.affAssignmentIdsBytes, ldr);
        }
        if (this.idealAffAssignmentBytes != null && this.idealAffAssignment == null) {
            this.idealAffAssignment = (List)U.unmarshal(ctx, this.idealAffAssignmentBytes, ldr);
        }
    }

    private List<List<ClusterNode>> unmarshalNodes(byte[] bytes, GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        List affAssignment = (List)U.unmarshal(ctx, bytes, U.resolveClassLoader(ldr, ctx.gridConfig()));
        int assignments = affAssignment.size();
        for (int n = 0; n < assignments; ++n) {
            List nodes = (List)affAssignment.get(n);
            int size = nodes.size();
            for (int i = 0; i < size; ++i) {
                ClusterNode node = (ClusterNode)nodes.get(i);
                if (!(node instanceof TcpDiscoveryNode)) continue;
                ((TcpDiscoveryNode)node).local(node.id().equals(ctx.localNodeId()));
            }
        }
        return affAssignment;
    }

    @Override
    public boolean addDeploymentInfo() {
        return false;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 3: {
                if (!writer.writeByteArray("affAssignmentBytes", this.affAssignmentBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeByteArray("affAssignmentIdsBytes", this.affAssignmentIdsBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeByteArray("idealAffAssignmentBytes", this.idealAffAssignmentBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeMessage("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 3: {
                this.affAssignmentBytes = reader.readByteArray("affAssignmentBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.affAssignmentIdsBytes = reader.readByteArray("affAssignmentIdsBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.idealAffAssignmentBytes = reader.readByteArray("idealAffAssignmentBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.topVer = (AffinityTopologyVersion)reader.readMessage("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDhtAffinityAssignmentResponse.class);
    }

    @Override
    public String toString() {
        return S.toString(GridDhtAffinityAssignmentResponse.class, this);
    }
}

