/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridNodeOrderComparator;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtAffinityAssignmentRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtAffinityAssignmentResponse;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class GridDhtAssignmentFetchFuture
extends GridFutureAdapter<GridDhtAffinityAssignmentResponse> {
    private static final long serialVersionUID = 0L;
    private static final AtomicReference<IgniteLogger> logRef = new AtomicReference();
    private static IgniteLogger log;
    private final GridCacheSharedContext ctx;
    @GridToStringInclude
    private Queue<ClusterNode> availableNodes;
    private ClusterNode pendingNode;
    @GridToStringInclude
    private final T2<Integer, AffinityTopologyVersion> key;

    public GridDhtAssignmentFetchFuture(GridCacheSharedContext ctx, String cacheName, AffinityTopologyVersion topVer) {
        this.ctx = ctx;
        this.key = new T2<Integer, AffinityTopologyVersion>(CU.cacheId(cacheName), topVer);
        Collection<ClusterNode> availableNodes = ctx.discovery().cacheAffinityNodes(cacheName, topVer);
        LinkedList<ClusterNode> tmp = new LinkedList<ClusterNode>();
        for (ClusterNode node : availableNodes) {
            if (node.isLocal() || !ctx.discovery().alive(node)) continue;
            tmp.add(node);
        }
        Collections.sort(tmp, GridNodeOrderComparator.INSTANCE);
        this.availableNodes = tmp;
        if (log == null) {
            log = U.logger(ctx.kernalContext(), logRef, GridDhtAssignmentFetchFuture.class);
        }
    }

    public void init() {
        this.ctx.affinity().addDhtAssignmentFetchFuture(this);
        this.requestFromNextNode();
    }

    public T2<Integer, AffinityTopologyVersion> key() {
        return this.key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResponse(UUID nodeId, GridDhtAffinityAssignmentResponse res) {
        if (!res.topologyVersion().equals(this.key.get2())) {
            if (log.isDebugEnabled()) {
                log.debug("Received affinity assignment for wrong topology version (will ignore) [node=" + nodeId + ", res=" + res + ", topVer=" + this.key.get2() + ']');
            }
            return;
        }
        GridDhtAffinityAssignmentResponse res0 = null;
        GridDhtAssignmentFetchFuture gridDhtAssignmentFetchFuture = this;
        synchronized (gridDhtAssignmentFetchFuture) {
            if (this.pendingNode != null && this.pendingNode.id().equals(nodeId)) {
                res0 = res;
            }
        }
        if (res0 != null) {
            this.onDone(res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNodeLeft(UUID leftNodeId) {
        GridDhtAssignmentFetchFuture gridDhtAssignmentFetchFuture = this;
        synchronized (gridDhtAssignmentFetchFuture) {
            if (this.pendingNode != null && this.pendingNode.id().equals(leftNodeId)) {
                this.availableNodes.remove(this.pendingNode);
                this.pendingNode = null;
            }
        }
        this.requestFromNextNode();
    }

    @Override
    public boolean onDone(@Nullable GridDhtAffinityAssignmentResponse res, @Nullable Throwable err) {
        if (super.onDone(res, err)) {
            this.ctx.affinity().removeDhtAssignmentFetchFuture(this);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestFromNextNode() {
        boolean complete;
        IgniteLogger log0 = log;
        GridDhtAssignmentFetchFuture gridDhtAssignmentFetchFuture = this;
        synchronized (gridDhtAssignmentFetchFuture) {
            while (!this.availableNodes.isEmpty()) {
                ClusterNode node = this.availableNodes.poll();
                try {
                    if (log0.isDebugEnabled()) {
                        log0.debug("Sending affinity fetch request to remote node [locNodeId=" + this.ctx.localNodeId() + ", node=" + node + ']');
                    }
                    this.ctx.io().send(node, (GridCacheMessage)new GridDhtAffinityAssignmentRequest((Integer)this.key.get1(), (AffinityTopologyVersion)this.key.get2()), (byte)4);
                    if (this.ctx.discovery().node(node.id()) == null) {
                        U.warn(log0, "Failed to request affinity assignment from remote node (node left grid, will continue to another node): " + node);
                        continue;
                    }
                    this.pendingNode = node;
                    break;
                }
                catch (ClusterTopologyCheckedException ignored) {
                    U.warn(log0, "Failed to request affinity assignment from remote node (node left grid, will continue to another node): " + node);
                }
                catch (IgniteCheckedException e) {
                    U.error(log0, "Failed to request affinity assignment from remote node (will continue to another node): " + node, e);
                }
            }
            complete = this.pendingNode == null;
        }
        if (complete) {
            this.onDone((GridDhtAffinityAssignmentResponse)null);
        }
    }

    @Override
    public String toString() {
        return S.toString(GridDhtAssignmentFetchFuture.class, this);
    }
}

