/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheLockCandidates;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheMultiTxFuture;
import org.apache.ignite.internal.processors.cache.GridCacheMvcc;
import org.apache.ignite.internal.processors.cache.GridCacheMvccCandidate;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedLockCancelledException;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxLocalAdapter;
import org.apache.ignite.internal.processors.cache.extras.GridCacheObsoleteEntryExtras;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.lang.GridPlainRunnable;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.Nullable;

public class GridDhtCacheEntry
extends GridDistributedCacheEntry {
    private static final int DHT_SIZE_OVERHEAD = 16;
    private static final IgniteClosure<ReaderId, UUID> R2N = new C1<ReaderId, UUID>(){

        @Override
        public UUID apply(ReaderId e) {
            return e.nodeId();
        }
    };
    @GridToStringInclude
    private volatile ReaderId[] rdrs = ReaderId.access$000();
    private final GridDhtLocalPartition locPart;

    public GridDhtCacheEntry(GridCacheContext ctx, AffinityTopologyVersion topVer, KeyCacheObject key, int hash, CacheObject val) {
        super(ctx, key, hash, val);
        int p = this.cctx.affinity().partition(key);
        this.locPart = ctx.topology().localPartition(p, topVer, true);
        assert (this.locPart != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int memorySize() throws IgniteCheckedException {
        int rdrsOverhead;
        GridDhtCacheEntry gridDhtCacheEntry = this;
        synchronized (gridDhtCacheEntry) {
            rdrsOverhead = 24 * this.rdrs.length;
        }
        return super.memorySize() + 16 + rdrsOverhead;
    }

    @Override
    public int partition() {
        return this.locPart.id();
    }

    @Override
    public boolean isDht() {
        return true;
    }

    @Override
    public boolean partitionValid() {
        return this.locPart.valid();
    }

    @Override
    public void onMarkedObsolete() {
        assert (!Thread.holdsLock(this));
        this.cctx.dht().topology().onRemoved(this);
    }

    @Nullable
    synchronized GridCacheMvccCandidate localCandidateByNearVersion(GridCacheVersion nearVer, boolean rmv) throws GridCacheEntryRemovedException {
        this.checkObsolete();
        GridCacheMvcc mvcc = this.mvccExtras();
        if (mvcc != null) {
            for (GridCacheMvccCandidate c : mvcc.localCandidatesNoCopy(false)) {
                GridCacheVersion ver = c.otherVersion();
                if (ver == null || !ver.equals(nearVer)) continue;
                return c;
            }
        }
        if (rmv) {
            this.addRemoved(nearVer);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    GridCacheMvccCandidate addDhtLocal(UUID nearNodeId, GridCacheVersion nearVer, AffinityTopologyVersion topVer, long threadId, GridCacheVersion ver, @Nullable GridCacheVersion serOrder, long timeout, boolean reenter, boolean tx, boolean implicitSingle, boolean read) throws GridCacheEntryRemovedException, GridDistributedLockCancelledException {
        CacheObject val;
        CacheLockCandidates owner;
        GridCacheMvccCandidate cand;
        CacheLockCandidates prev;
        assert (!reenter || serOrder == null);
        GridDhtCacheEntry gridDhtCacheEntry = this;
        synchronized (gridDhtCacheEntry) {
            this.checkRemoved(ver);
            this.checkRemoved(nearVer);
            this.checkObsolete();
            GridCacheMvcc mvcc = this.mvccExtras();
            if (mvcc == null) {
                mvcc = new GridCacheMvcc(this.cctx);
                this.mvccExtras(mvcc);
            }
            prev = mvcc.allOwners();
            boolean emptyBefore = mvcc.isEmpty(new GridCacheVersion[0]);
            cand = mvcc.addLocal(this, nearNodeId, nearVer, threadId, ver, timeout, serOrder, reenter, tx, implicitSingle, true, read);
            if (cand == null) {
                return null;
            }
            cand.topologyVersion(topVer);
            owner = mvcc.allOwners();
            if (owner != null) {
                cand.ownerVersion(owner.candidate(0).version());
            }
            boolean emptyAfter = mvcc.isEmpty(new GridCacheVersion[0]);
            this.checkCallbacks(emptyBefore, emptyAfter);
            val = this.val;
            if (mvcc.isEmpty(new GridCacheVersion[0])) {
                this.mvccExtras(null);
            }
        }
        if (!cand.reentry()) {
            this.cctx.mvcc().addNext(this.cctx, cand);
        }
        this.checkOwnerChanged(prev, owner, val);
        return cand;
    }

    @Override
    public boolean tmLock(IgniteInternalTx tx, long timeout, @Nullable GridCacheVersion serOrder, GridCacheVersion serReadVer, boolean read) throws GridCacheEntryRemovedException, GridDistributedLockCancelledException {
        if (tx.local()) {
            GridDhtTxLocalAdapter dhtTx = (GridDhtTxLocalAdapter)tx;
            return this.addDhtLocal(dhtTx.nearNodeId(), dhtTx.nearXidVersion(), tx.topologyVersion(), tx.threadId(), tx.xidVersion(), serOrder, timeout, false, true, tx.implicitSingle(), read) != null;
        }
        try {
            this.addRemote(tx.nodeId(), tx.otherNodeId(), tx.threadId(), tx.xidVersion(), true, tx.implicit(), null);
            return true;
        }
        catch (GridDistributedLockCancelledException ignored) {
            if (log.isDebugEnabled()) {
                log.debug("Attempted to enter tx lock for cancelled ID (will ignore): " + tx);
            }
            return false;
        }
    }

    @Override
    public GridCacheMvccCandidate removeLock() {
        GridCacheMvccCandidate ret = super.removeLock();
        this.locPart.onUnlock();
        return ret;
    }

    @Override
    public boolean removeLock(GridCacheVersion ver) throws GridCacheEntryRemovedException {
        boolean ret = super.removeLock(ver);
        this.locPart.onUnlock();
        return ret;
    }

    @Override
    public void onUnlock() {
        this.locPart.onUnlock();
    }

    @Nullable
    public synchronized IgniteBiTuple<GridCacheVersion, CacheObject> versionedValue(AffinityTopologyVersion topVer) throws GridCacheEntryRemovedException {
        if (this.isNew() || !this.valid(AffinityTopologyVersion.NONE) || this.deletedUnlocked()) {
            return null;
        }
        CacheObject val0 = this.valueBytesUnlocked();
        return F.t(this.ver, val0);
    }

    public Collection<UUID> readers() throws GridCacheEntryRemovedException {
        return F.viewReadOnly(this.checkReaders(), R2N, new IgnitePredicate[0]);
    }

    @Nullable
    public ReaderId readerId(UUID nodeId) {
        ReaderId[] rdrs;
        for (ReaderId reader : rdrs = this.rdrs) {
            if (!reader.nodeId().equals(nodeId)) continue;
            return reader;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public IgniteInternalFuture<Boolean> addReader(UUID nodeId, long msgId, AffinityTopologyVersion topVer) throws GridCacheEntryRemovedException {
        ReaderId reader;
        if (this.cctx.nodeId().equals(nodeId)) {
            return null;
        }
        ClusterNode node = this.cctx.discovery().node(nodeId);
        if (node == null) {
            if (log.isDebugEnabled()) {
                log.debug("Ignoring near reader because node left the grid: " + nodeId);
            }
            return null;
        }
        if (!this.cctx.discovery().cacheNearNode(node, this.cacheName())) {
            if (log.isDebugEnabled()) {
                log.debug("Ignoring near reader because near cache is disabled: " + nodeId);
            }
            return null;
        }
        if (this.cctx.affinity().partitionBelongs(node, this.partition(), topVer)) {
            if (log.isDebugEnabled()) {
                log.debug("Ignoring near reader because remote node is affinity node [locNodeId=" + this.cctx.localNodeId() + ", rmtNodeId=" + nodeId + ", key=" + this.key + ']');
            }
            return null;
        }
        boolean ret = false;
        GridCacheMultiTxFuture txFut = null;
        Collection<GridCacheMvccCandidate> cands = null;
        GridDhtCacheEntry gridDhtCacheEntry = this;
        synchronized (gridDhtCacheEntry) {
            this.checkObsolete();
            reader = this.readerId(nodeId);
            if (reader == null) {
                reader = new ReaderId(nodeId, msgId);
                ReaderId[] rdrs = Arrays.copyOf(this.rdrs, this.rdrs.length + 1);
                rdrs[rdrs.length - 1] = reader;
                this.rdrs = rdrs;
                if (!this.cctx.atomic()) {
                    txFut = reader.getOrCreateTxFuture(this.cctx);
                    cands = this.localCandidates(new GridCacheVersion[0]);
                    ret = true;
                }
            } else {
                txFut = reader.txFuture();
                long id = reader.messageId();
                if (id < msgId) {
                    reader.messageId(msgId);
                }
            }
        }
        if (ret) {
            assert (txFut != null);
            if (!F.isEmpty(cands)) {
                for (GridCacheMvccCandidate c : cands) {
                    Object tx = this.cctx.tm().tx(c.version());
                    if (tx == null || !tx.local()) continue;
                    txFut.addTx((IgniteInternalTx)tx);
                }
            }
            txFut.init();
            if (!txFut.isDone()) {
                final ReaderId reader0 = reader;
                txFut.listen(new CI1<IgniteInternalFuture<?>>(){

                    @Override
                    public void apply(IgniteInternalFuture<?> f) {
                        GridDhtCacheEntry.this.cctx.kernalContext().closure().runLocalSafe(new GridPlainRunnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                1 var1_1 = this;
                                synchronized (var1_1) {
                                    reader0.resetTxFuture();
                                }
                            }
                        });
                    }
                });
            } else {
                gridDhtCacheEntry = this;
                synchronized (gridDhtCacheEntry) {
                    reader.resetTxFuture();
                }
                txFut = null;
            }
        }
        return txFut;
    }

    public synchronized boolean removeReader(UUID nodeId, long msgId) throws GridCacheEntryRemovedException {
        this.checkObsolete();
        ReaderId[] rdrs = this.rdrs;
        int readerIdx = -1;
        for (int i = 0; i < rdrs.length; ++i) {
            if (!rdrs[i].nodeId().equals(nodeId)) continue;
            readerIdx = i;
            break;
        }
        if (readerIdx == -1 || rdrs[readerIdx].messageId() > msgId && msgId >= 0L) {
            return false;
        }
        if (rdrs.length == 1) {
            this.rdrs = ReaderId.EMPTY_ARRAY;
        } else {
            ReaderId[] newRdrs = Arrays.copyOf(rdrs, rdrs.length - 1);
            System.arraycopy(rdrs, readerIdx + 1, newRdrs, readerIdx, rdrs.length - readerIdx - 1);
            this.rdrs = newRdrs;
        }
        return true;
    }

    @Override
    public synchronized void clearReaders() {
        this.rdrs = ReaderId.EMPTY_ARRAY;
    }

    @Override
    public synchronized void clearReader(UUID nodeId) throws GridCacheEntryRemovedException {
        this.removeReader(nodeId, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean clearInternal(GridCacheVersion ver, boolean swap, GridCacheObsoleteEntryExtras extras) throws IgniteCheckedException {
        CacheObject prev;
        boolean rmv;
        block12: {
            rmv = false;
            try {
                GridDhtCacheEntry gridDhtCacheEntry = this;
                // MONITORENTER : gridDhtCacheEntry
                prev = this.saveValueForIndexUnlocked();
                if (this.markObsolete0(ver, false, extras)) break block12;
                if (log.isDebugEnabled()) {
                    log.debug("Entry could not be marked obsolete (it is still used or has readers): " + this);
                }
                boolean bl = false;
                // MONITOREXIT : gridDhtCacheEntry
                if (!rmv) return bl;
                this.cctx.cache().removeEntry(this);
                return bl;
            }
            catch (Throwable throwable) {
                if (!rmv) throw throwable;
                this.cctx.cache().removeEntry(this);
                throw throwable;
            }
        }
        this.rdrs = ReaderId.EMPTY_ARRAY;
        if (log.isDebugEnabled()) {
            log.debug("Entry has been marked obsolete: " + this);
        }
        if (log.isTraceEnabled()) {
            log.trace("clearInternal [key=" + this.key + ", entry=" + System.identityHashCode(this) + ", prev=" + prev + ", ptr=" + this.offHeapPointer() + ']');
        }
        this.clearIndex(prev);
        this.update(null, 0L, 0L, ver, true);
        if (swap) {
            this.releaseSwap();
            if (log.isDebugEnabled()) {
                log.debug("Entry has been cleared from swap storage: " + this);
            }
        }
        if (this.cctx.store().isLocal()) {
            this.cctx.store().remove(null, this.key);
        }
        rmv = true;
        boolean bl = true;
        // MONITOREXIT : gridDhtCacheEntry
        if (!rmv) return bl;
        this.cctx.cache().removeEntry(this);
        return bl;
    }

    public synchronized Collection<ReaderId> checkReaders() throws GridCacheEntryRemovedException {
        return this.checkReadersLocked();
    }

    protected Collection<ReaderId> checkReadersLocked() throws GridCacheEntryRemovedException {
        assert (Thread.holdsLock(this));
        this.checkObsolete();
        ReaderId[] rdrs = this.rdrs;
        if (rdrs.length == 0) {
            return Collections.emptySet();
        }
        ArrayList<ReaderId> newRdrs = null;
        for (int i = 0; i < rdrs.length; ++i) {
            ClusterNode node = this.cctx.discovery().getAlive(rdrs[i].nodeId());
            if (node == null || !this.cctx.discovery().cacheNode(node, this.cacheName())) {
                if (newRdrs != null) continue;
                newRdrs = new ArrayList<ReaderId>(rdrs.length);
                for (int k = 0; k < i; ++k) {
                    newRdrs.add(rdrs[k]);
                }
                continue;
            }
            if (newRdrs == null) continue;
            newRdrs.add(rdrs[i]);
        }
        if (newRdrs != null) {
            this.rdrs = rdrs = newRdrs.toArray(new ReaderId[newRdrs.size()]);
        }
        return Arrays.asList(rdrs);
    }

    @Override
    protected synchronized boolean hasReaders() throws GridCacheEntryRemovedException {
        this.checkReadersLocked();
        return this.rdrs.length > 0;
    }

    @Nullable
    public synchronized GridCacheMvccCandidate mappings(GridCacheVersion ver, Collection<ClusterNode> dhtNodeIds, Collection<ClusterNode> nearNodeIds) throws GridCacheEntryRemovedException {
        GridCacheMvccCandidate cand;
        this.checkObsolete();
        GridCacheMvcc mvcc = this.mvccExtras();
        GridCacheMvccCandidate gridCacheMvccCandidate = cand = mvcc == null ? null : mvcc.candidate(ver);
        if (cand != null) {
            cand.mappedNodeIds(dhtNodeIds, nearNodeIds);
        }
        return cand;
    }

    public synchronized void removeMapping(GridCacheVersion ver, ClusterNode mappedNode) {
        GridCacheMvccCandidate cand;
        GridCacheMvcc mvcc = this.mvccExtras();
        GridCacheMvccCandidate gridCacheMvccCandidate = cand = mvcc == null ? null : mvcc.candidate(ver);
        if (cand != null) {
            cand.removeMappedNode(mappedNode);
        }
    }

    protected String cacheName() {
        return this.cctx.dht().near().name();
    }

    @Override
    public synchronized String toString() {
        return S.toString(GridDhtCacheEntry.class, this, "super", super.toString());
    }

    @Override
    protected void incrementMapPublicSize() {
        this.locPart.incrementPublicSize(this);
    }

    @Override
    protected void decrementMapPublicSize() {
        this.locPart.decrementPublicSize(this);
    }

    private static class ReaderId {
        private static final ReaderId[] EMPTY_ARRAY = new ReaderId[0];
        private static final int READER_ID_SIZE = 24;
        private UUID nodeId;
        private long msgId;
        private GridCacheMultiTxFuture txFut;

        ReaderId(UUID nodeId, long msgId) {
            this.nodeId = nodeId;
            this.msgId = msgId;
        }

        UUID nodeId() {
            return this.nodeId;
        }

        long messageId() {
            return this.msgId;
        }

        void messageId(long msgId) {
            this.msgId = msgId;
        }

        GridCacheMultiTxFuture getOrCreateTxFuture(GridCacheContext cctx) {
            if (this.txFut == null) {
                this.txFut = new GridCacheMultiTxFuture(cctx);
            }
            return this.txFut;
        }

        GridCacheMultiTxFuture txFuture() {
            return this.txFut;
        }

        GridCacheMultiTxFuture resetTxFuture() {
            GridCacheMultiTxFuture txFut = this.txFut;
            this.txFut = null;
            return txFut;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ReaderId)) {
                return false;
            }
            ReaderId readerId = (ReaderId)o;
            return this.msgId == readerId.msgId && this.nodeId.equals(readerId.nodeId);
        }

        public int hashCode() {
            int res = this.nodeId.hashCode();
            res = 31 * res + (int)(this.msgId ^ this.msgId >>> 32);
            return res;
        }

        public String toString() {
            return S.toString(ReaderId.class, this);
        }
    }
}

