/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheConcurrentMap;
import org.apache.ignite.internal.processors.cache.GridCacheConcurrentMapImpl;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheMapEntry;
import org.apache.ignite.internal.processors.cache.GridCacheMapEntryFactory;
import org.apache.ignite.internal.processors.cache.GridCacheSwapEntry;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtPartitionsReservation;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridReservable;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPreloader;
import org.apache.ignite.internal.processors.cache.extras.GridCacheObsoleteEntryExtras;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.GridCloseableIterator;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentLinkedDeque8;

public class GridDhtLocalPartition
implements Comparable<GridDhtLocalPartition>,
GridReservable,
GridCacheConcurrentMap {
    public static final int MAX_DELETE_QUEUE_SIZE = Integer.getInteger("IGNITE_ATOMIC_CACHE_DELETE_HISTORY_SIZE", 200000);
    private final int rmvQueueMaxSize;
    private final long rmvdEntryTtl;
    private static final AtomicReference<IgniteLogger> logRef = new AtomicReference();
    private static volatile IgniteLogger log;
    private final int id;
    @GridToStringExclude
    private final AtomicLong state = new AtomicLong((long)GridDhtPartitionState.MOVING.ordinal() << 32);
    @GridToStringExclude
    private final GridFutureAdapter<?> rent;
    private final GridCacheConcurrentMap map;
    private final GridCacheContext cctx;
    @GridToStringExclude
    private final long createTime = U.currentTimeMillis();
    private volatile Map<KeyCacheObject, GridCacheVersion> evictHist = new HashMap<KeyCacheObject, GridCacheVersion>();
    private final ReentrantLock lock = new ReentrantLock();
    private final ConcurrentLinkedDeque8<RemovedEntryHolder> rmvQueue = new ConcurrentLinkedDeque8();
    private final CopyOnWriteArrayList<GridDhtPartitionsReservation> reservations = new CopyOnWriteArrayList();
    private final AtomicLong cntr = new AtomicLong();
    private volatile boolean shouldBeRenting;

    GridDhtLocalPartition(GridCacheContext cctx, int id, GridCacheMapEntryFactory entryFactory) {
        assert (cctx != null);
        this.id = id;
        this.cctx = cctx;
        log = U.logger(cctx.kernalContext(), logRef, this);
        this.rent = new GridFutureAdapter<Object>(){

            @Override
            public String toString() {
                return "PartitionRentFuture [part=" + GridDhtLocalPartition.this + ", map=" + GridDhtLocalPartition.this.map + ']';
            }
        };
        this.map = new GridCacheConcurrentMapImpl(cctx, entryFactory, cctx.config().getStartSize() / cctx.affinity().partitions());
        int delQueueSize = CU.isSystemCache(cctx.name()) ? 100 : Math.max(MAX_DELETE_QUEUE_SIZE / cctx.affinity().partitions(), 20);
        this.rmvQueueMaxSize = U.ceilPow2(delQueueSize);
        this.rmvdEntryTtl = Long.getLong("IGNITE_CACHE_REMOVED_ENTRIES_TTL", 10000L);
    }

    public boolean addReservation(GridDhtPartitionsReservation r) {
        assert (GridDhtPartitionState.fromOrdinal((int)(this.state.get() >> 32)) != GridDhtPartitionState.EVICTED) : "we can reserve only active partitions";
        assert ((this.state.get() & 0xFFFFL) != 0L) : "partition must be already reserved before adding group reservation";
        return this.reservations.addIfAbsent(r);
    }

    public void removeReservation(GridDhtPartitionsReservation r) {
        if (!this.reservations.remove(r)) {
            throw new IllegalStateException("Reservation was already removed.");
        }
    }

    public int id() {
        return this.id;
    }

    long createTime() {
        return this.createTime;
    }

    public GridDhtPartitionState state() {
        return GridDhtPartitionState.fromOrdinal((int)(this.state.get() >> 32));
    }

    public int reservations() {
        return (int)(this.state.get() & 0xFFFFL);
    }

    public Set<KeyCacheObject> keySet() {
        return this.map.keySet(new CacheEntryPredicate[0]);
    }

    public boolean isEmpty() {
        return this.map.size() == 0;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public int publicSize() {
        return this.map.publicSize();
    }

    @Override
    public void incrementPublicSize(GridCacheEntryEx e) {
        this.map.incrementPublicSize(e);
    }

    @Override
    public void decrementPublicSize(GridCacheEntryEx e) {
        this.map.decrementPublicSize(e);
    }

    public boolean valid() {
        GridDhtPartitionState state = this.state();
        return state == GridDhtPartitionState.MOVING || state == GridDhtPartitionState.OWNING || state == GridDhtPartitionState.RENTING;
    }

    @Override
    @Nullable
    public GridCacheMapEntry getEntry(KeyCacheObject key) {
        return this.map.getEntry(key);
    }

    @Override
    public boolean removeEntry(GridCacheEntryEx entry) {
        return this.map.removeEntry(entry);
    }

    @Override
    public Iterable<GridCacheMapEntry> entries(CacheEntryPredicate ... filter) {
        return this.map.entries(filter);
    }

    @Override
    public Iterable<GridCacheMapEntry> allEntries(CacheEntryPredicate ... filter) {
        return this.map.allEntries(filter);
    }

    @Override
    public Set<GridCacheMapEntry> entrySet(CacheEntryPredicate ... filter) {
        return this.map.entrySet(filter);
    }

    @Override
    @Nullable
    public GridCacheMapEntry randomEntry() {
        return this.map.randomEntry();
    }

    @Override
    public GridCacheMapEntry putEntryIfObsoleteOrAbsent(AffinityTopologyVersion topVer, KeyCacheObject key, @Nullable CacheObject val, boolean create, boolean touch) {
        return this.map.putEntryIfObsoleteOrAbsent(topVer, key, val, create, touch);
    }

    @Override
    public Set<KeyCacheObject> keySet(CacheEntryPredicate ... filter) {
        return this.map.keySet(filter);
    }

    void onRemoved(GridDhtCacheEntry entry) {
        assert (entry.obsolete()) : entry;
        this.map.removeEntry(entry);
        this.tryEvict();
    }

    public void cleanupRemoveQueue() {
        RemovedEntryHolder item;
        while (this.rmvQueue.sizex() >= this.rmvQueueMaxSize) {
            item = this.rmvQueue.pollFirst();
            if (item == null) continue;
            this.cctx.dht().removeVersionedEntry(item.key(), item.version());
        }
        if (!this.cctx.isDrEnabled()) {
            item = this.rmvQueue.peekFirst();
            while (item != null && item.expireTime() < U.currentTimeMillis() && (item = this.rmvQueue.pollFirst()) != null) {
                this.cctx.dht().removeVersionedEntry(item.key(), item.version());
                item = this.rmvQueue.peekFirst();
            }
        }
    }

    public void onDeferredDelete(KeyCacheObject key, GridCacheVersion ver) {
        this.cleanupRemoveQueue();
        this.rmvQueue.add(new RemovedEntryHolder(key, ver, this.rmvdEntryTtl));
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public void onEntryEvicted(KeyCacheObject key, GridCacheVersion ver) {
        GridCacheVersion ver0;
        assert (key != null);
        assert (ver != null);
        assert (this.lock.isHeldByCurrentThread());
        if (this.state() != GridDhtPartitionState.MOVING) {
            return;
        }
        Map<KeyCacheObject, GridCacheVersion> evictHist0 = this.evictHist;
        if (evictHist0 != null && ((ver0 = evictHist0.get(key)) == null || ver0.isLess(ver))) {
            GridCacheVersion ver1 = evictHist0.put(key, ver);
            assert (ver1 == ver0);
        }
    }

    public boolean preloadingPermitted(KeyCacheObject key, GridCacheVersion ver) {
        assert (key != null);
        assert (ver != null);
        assert (this.lock.isHeldByCurrentThread());
        if (this.state() != GridDhtPartitionState.MOVING) {
            return false;
        }
        Map<KeyCacheObject, GridCacheVersion> evictHist0 = this.evictHist;
        if (evictHist0 != null) {
            GridCacheVersion ver0 = evictHist0.get(key);
            return ver0 == null || ver0.isLess(ver);
        }
        return false;
    }

    @Override
    public boolean reserve() {
        long reservations;
        do {
            if ((int)((reservations = this.state.get()) >> 32) != GridDhtPartitionState.EVICTED.ordinal()) continue;
            return false;
        } while (!this.state.compareAndSet(reservations, reservations + 1L));
        return true;
    }

    @Override
    public void release() {
        long reservations;
        do {
            if ((int)((reservations = this.state.get()) & 0xFFFFL) == 0) {
                return;
            }
            assert ((int)(reservations >> 32) != GridDhtPartitionState.EVICTED.ordinal());
        } while (!this.state.compareAndSet(reservations--, reservations));
        if ((reservations & 0xFFFFL) == 0L && this.shouldBeRenting) {
            this.rent(true);
        }
        this.tryEvict();
    }

    private boolean casState(long reservations, GridDhtPartitionState toState) {
        return this.state.compareAndSet(reservations, reservations & 0xFFFFL | (long)toState.ordinal() << 32);
    }

    boolean own() {
        long reservations;
        do {
            int ord;
            if ((ord = (int)((reservations = this.state.get()) >> 32)) == GridDhtPartitionState.RENTING.ordinal() || ord == GridDhtPartitionState.EVICTED.ordinal()) {
                return false;
            }
            if (ord == GridDhtPartitionState.OWNING.ordinal()) {
                return true;
            }
            assert (ord == GridDhtPartitionState.MOVING.ordinal());
        } while (!this.casState(reservations, GridDhtPartitionState.OWNING));
        if (log.isDebugEnabled()) {
            log.debug("Owned partition: " + this);
        }
        this.evictHist = null;
        return true;
    }

    IgniteInternalFuture<?> rent(boolean updateSeq) {
        long reservations = this.state.get();
        int ord = (int)(reservations >> 32);
        if (ord == GridDhtPartitionState.RENTING.ordinal() || ord == GridDhtPartitionState.EVICTED.ordinal()) {
            return this.rent;
        }
        this.shouldBeRenting = true;
        if ((reservations & 0xFFFFL) == 0L && this.casState(reservations, GridDhtPartitionState.RENTING)) {
            this.shouldBeRenting = false;
            if (log.isDebugEnabled()) {
                log.debug("Moved partition to RENTING state: " + this);
            }
            this.tryEvictAsync(updateSeq);
        }
        return this.rent;
    }

    void tryEvictAsync(boolean updateSeq) {
        long reservations = this.state.get();
        int ord = (int)(reservations >> 32);
        if (this.isEmpty() && !GridQueryProcessor.isEnabled(this.cctx.config()) && ord == GridDhtPartitionState.RENTING.ordinal() && (reservations & 0xFFFFL) == 0L && this.casState(reservations, GridDhtPartitionState.EVICTED)) {
            if (log.isDebugEnabled()) {
                log.debug("Evicted partition: " + this);
            }
            this.clearSwap();
            if (this.cctx.isDrEnabled()) {
                this.cctx.dr().partitionEvicted(this.id);
            }
            this.cctx.dataStructures().onPartitionEvicted(this.id);
            this.rent.onDone();
            ((GridDhtPreloader)this.cctx.preloader()).onPartitionEvicted(this, updateSeq);
            this.clearDeferredDeletes();
        } else {
            this.cctx.preloader().evictPartitionAsync(this);
        }
    }

    boolean groupReserved() {
        for (GridDhtPartitionsReservation reservation : this.reservations) {
            if (reservation.invalidate()) continue;
            return true;
        }
        return false;
    }

    public void tryEvict() {
        long reservations = this.state.get();
        int ord = (int)(reservations >> 32);
        if (ord != GridDhtPartitionState.RENTING.ordinal() || (reservations & 0xFFFFL) != 0L || this.groupReserved()) {
            return;
        }
        this.clearAll();
        if (this.isEmpty() && this.casState(reservations, GridDhtPartitionState.EVICTED)) {
            if (log.isDebugEnabled()) {
                log.debug("Evicted partition: " + this);
            }
            if (!GridQueryProcessor.isEnabled(this.cctx.config())) {
                this.clearSwap();
            }
            if (this.cctx.isDrEnabled()) {
                this.cctx.dr().partitionEvicted(this.id);
            }
            this.cctx.continuousQueries().onPartitionEvicted(this.id);
            this.cctx.dataStructures().onPartitionEvicted(this.id);
            this.rent.onDone();
            ((GridDhtPreloader)this.cctx.preloader()).onPartitionEvicted(this, true);
            this.clearDeferredDeletes();
        }
    }

    private void clearSwap() {
        assert (this.state() == GridDhtPartitionState.EVICTED);
        assert (!GridQueryProcessor.isEnabled(this.cctx.config())) : "Indexing needs to have unswapped values.";
        try {
            GridCloseableIterator<Map.Entry<byte[], GridCacheSwapEntry>> it = this.cctx.swap().iterator(this.id);
            boolean isLocStore = this.cctx.store().isLocal();
            if (it != null) {
                while (it.hasNext()) {
                    Map.Entry entry = (Map.Entry)it.next();
                    byte[] keyBytes = (byte[])entry.getKey();
                    KeyCacheObject key = this.cctx.toCacheKeyObject(keyBytes);
                    this.cctx.swap().remove(key, this.id);
                    if (!isLocStore) continue;
                    this.cctx.store().remove(null, key.value(this.cctx.cacheObjectContext(), false));
                }
            }
        }
        catch (IgniteCheckedException e) {
            U.error(log, "Failed to clear swap for evicted partition: " + this, e);
        }
    }

    void onUnlock() {
        this.tryEvict();
    }

    public boolean primary(AffinityTopologyVersion topVer) {
        return this.cctx.affinity().primaryByPartition(this.cctx.localNode(), this.id, topVer);
    }

    public boolean backup(AffinityTopologyVersion topVer) {
        return this.cctx.affinity().backupByPartition(this.cctx.localNode(), this.id, topVer);
    }

    public long nextUpdateCounter() {
        return this.cntr.incrementAndGet();
    }

    public long updateCounter() {
        return this.cntr.get();
    }

    public void updateCounter(long val) {
        long val0;
        while ((val0 = this.cntr.get()) < val && !this.cntr.compareAndSet(val0, val)) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearAll() {
        block14: {
            GridCacheVersion clearVer = this.cctx.versions().next();
            boolean swap = this.cctx.isSwapOrOffheapEnabled();
            boolean rec = this.cctx.events().isRecordable(85);
            Iterator<GridCacheMapEntry> it = this.map.allEntries(new CacheEntryPredicate[0]).iterator();
            GridCloseableIterator<Map.Entry<byte[], GridCacheSwapEntry>> swapIt = null;
            if (swap && GridQueryProcessor.isEnabled(this.cctx.config())) {
                Iterator<GridDhtCacheEntry> unswapIt = null;
                try {
                    swapIt = this.cctx.swap().iterator(this.id);
                    unswapIt = this.unswapIterator(swapIt);
                }
                catch (Exception e) {
                    U.error(log, "Failed to clear swap for evicted partition: " + this, e);
                }
                if (unswapIt != null) {
                    it = F.concat(it, unswapIt);
                }
            }
            GridCacheObsoleteEntryExtras extras = new GridCacheObsoleteEntryExtras(clearVer);
            block8: while (true) {
                while (it.hasNext()) {
                    GridDhtCacheEntry cached = null;
                    try {
                        cached = (GridDhtCacheEntry)it.next();
                        if (!cached.clearInternal(clearVer, swap, extras)) continue block8;
                        this.map.removeEntry(cached);
                        if (cached.isInternal() || !rec) continue block8;
                        this.cctx.events().addEvent(cached.partition(), cached.key(), this.cctx.localNodeId(), (IgniteUuid)null, null, 85, null, false, cached.rawGet(), cached.hasValue(), null, null, null, false);
                        continue block8;
                    }
                    catch (GridDhtInvalidPartitionException e) {
                        assert (this.isEmpty() && this.state() == GridDhtPartitionState.EVICTED) : "Invalid error [e=" + e + ", part=" + this + ']';
                        assert (this.swapEmpty()) : "Invalid error when swap is not cleared [e=" + e + ", part=" + this + ']';
                        break block14;
                    }
                    catch (IgniteCheckedException e) {
                        U.error(log, "Failed to clear cache entry for evicted partition: " + cached, e);
                    }
                }
                break block14;
                {
                    continue block8;
                    break;
                }
                break;
            }
            finally {
                U.close(swapIt, log);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean swapEmpty() {
        GridCloseableIterator<Map.Entry<byte[], GridCacheSwapEntry>> it0 = null;
        try {
            it0 = this.cctx.swap().iterator(this.id);
            boolean bl = it0 == null || !it0.hasNext();
            return bl;
        }
        catch (IgniteCheckedException e) {
            U.error(log, "Failed to get partition swap iterator: " + this, e);
            boolean bl = true;
            return bl;
        }
        finally {
            if (it0 != null) {
                U.closeQuiet(it0);
            }
        }
    }

    private Iterator<GridDhtCacheEntry> unswapIterator(final GridCloseableIterator<Map.Entry<byte[], GridCacheSwapEntry>> it) {
        if (it == null) {
            return null;
        }
        return new Iterator<GridDhtCacheEntry>(){
            GridDhtCacheEntry lastEntry;

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            /*
             * Loose catch block
             */
            @Override
            public GridDhtCacheEntry next() {
                Map.Entry entry = (Map.Entry)it.next();
                byte[] keyBytes = (byte[])entry.getKey();
                while (true) {
                    try {
                        KeyCacheObject key = GridDhtLocalPartition.this.cctx.toCacheKeyObject(keyBytes);
                        this.lastEntry = (GridDhtCacheEntry)GridDhtLocalPartition.this.cctx.cache().entryEx(key, false);
                        this.lastEntry.unswap(true);
                        return this.lastEntry;
                    }
                    catch (GridCacheEntryRemovedException ignored) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug("Got removed entry: " + this.lastEntry);
                        continue;
                    }
                    break;
                }
                catch (IgniteCheckedException e) {
                    throw new CacheException(e);
                }
            }

            @Override
            public void remove() {
                GridDhtLocalPartition.this.map.removeEntry(this.lastEntry);
            }
        };
    }

    private void clearDeferredDeletes() {
        for (RemovedEntryHolder e : this.rmvQueue) {
            this.cctx.dht().removeVersionedEntry(e.key(), e.version());
        }
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        return obj instanceof GridDhtLocalPartition && (obj == this || ((GridDhtLocalPartition)obj).id() == this.id);
    }

    @Override
    public int compareTo(@NotNull GridDhtLocalPartition part) {
        if (part == null) {
            return 1;
        }
        return Integer.compare(this.id, part.id());
    }

    public String toString() {
        return S.toString(GridDhtLocalPartition.class, this, "state", (Object)this.state(), "reservations", (Object)this.reservations(), "empty", this.isEmpty(), "createTime", U.format(this.createTime));
    }

    private static class RemovedEntryHolder {
        private final KeyCacheObject key;
        private final GridCacheVersion ver;
        private final long expireTime;

        private RemovedEntryHolder(KeyCacheObject key, GridCacheVersion ver, long ttl) {
            this.key = key;
            this.ver = ver;
            this.expireTime = U.currentTimeMillis() + ttl;
        }

        KeyCacheObject key() {
            return this.key;
        }

        GridCacheVersion version() {
            return this.ver;
        }

        long expireTime() {
            return this.expireTime;
        }

        public String toString() {
            return S.toString(RemovedEntryHolder.class, this);
        }
    }
}

