/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.internal.IgniteFutureTimeoutCheckedException;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityAssignment;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheMapEntryFactory;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTopologyFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionExchangeId;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionFullMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionMap2;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.util.GridAtomicLong;
import org.apache.ignite.internal.util.StripedCompositeReadWriteLock;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.Nullable;

@GridToStringExclude
class GridDhtPartitionTopologyImpl
implements GridDhtPartitionTopology {
    private static final boolean CONSISTENCY_CHECK = false;
    private static final boolean FULL_MAP_DEBUG = false;
    private static final Long ZERO = 0L;
    private final GridCacheContext<?, ?> cctx;
    private final IgniteLogger log;
    private final AtomicReferenceArray<GridDhtLocalPartition> locParts;
    private GridDhtPartitionFullMap node2part;
    private Map<Integer, Set<UUID>> part2node = new HashMap<Integer, Set<UUID>>();
    private GridDhtPartitionExchangeId lastExchangeId;
    private volatile AffinityTopologyVersion topVer = AffinityTopologyVersion.NONE;
    private volatile boolean stopping;
    private GridDhtTopologyFuture topReadyFut;
    private final GridAtomicLong updateSeq = new GridAtomicLong(1L);
    private final StripedCompositeReadWriteLock lock = new StripedCompositeReadWriteLock(16);
    private final GridCacheMapEntryFactory entryFactory;
    private Map<Integer, Long> cntrMap = new HashMap<Integer, Long>();
    private volatile AffinityTopologyVersion rebalancedTopVer = AffinityTopologyVersion.NONE;

    GridDhtPartitionTopologyImpl(GridCacheContext<?, ?> cctx, GridCacheMapEntryFactory entryFactory) {
        assert (cctx != null);
        this.cctx = cctx;
        this.entryFactory = entryFactory;
        this.log = cctx.logger(this.getClass());
        this.locParts = new AtomicReferenceArray(cctx.config().getAffinity().partitions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReconnected() {
        this.lock.writeLock().lock();
        try {
            this.node2part = null;
            this.part2node = new HashMap<Integer, Set<UUID>>();
            this.lastExchangeId = null;
            this.updateSeq.set(1L);
            this.topReadyFut = null;
            this.rebalancedTopVer = AffinityTopologyVersion.NONE;
            this.topVer = AffinityTopologyVersion.NONE;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private String fullMapString() {
        return this.node2part == null ? "null" : this.node2part.toString();
    }

    private String mapString(GridDhtPartitionMap2 map) {
        return map == null ? "null" : map.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForRent() throws IgniteCheckedException {
        GridDhtLocalPartition part;
        int i;
        boolean changed = false;
        long longOpDumpTimeout = IgniteSystemProperties.getLong("IGNITE_LONG_OPERATIONS_DUMP_TIMEOUT", 60000L);
        int dumpCnt = 0;
        for (i = 0; i < this.locParts.length(); ++i) {
            block10: {
                GridDhtPartitionState state;
                part = this.locParts.get(i);
                if (part == null || (state = part.state()) != GridDhtPartitionState.RENTING && state != GridDhtPartitionState.EVICTED) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Waiting for renting partition: " + part);
                }
                if (longOpDumpTimeout > 0L) {
                    while (true) {
                        try {
                            part.rent(true).get(longOpDumpTimeout);
                            break block10;
                        }
                        catch (IgniteFutureTimeoutCheckedException ignored) {
                            if (dumpCnt++ >= GridDhtPartitionsExchangeFuture.DUMP_PENDING_OBJECTS_THRESHOLD) continue;
                            U.warn(this.log, "Failed to wait for partition eviction [topVer=" + this.topVer + ", cache=" + this.cctx.name() + ", part=" + part.id() + ", partState=" + (Object)((Object)part.state()) + ", size=" + part.size() + ", reservations=" + part.reservations() + ", grpReservations=" + part.groupReserved() + ", node=" + this.cctx.localNodeId() + "]");
                            if (!IgniteSystemProperties.getBoolean("IGNITE_THREAD_DUMP_ON_EXCHANGE_TIMEOUT", false)) continue;
                            U.dumpThreads(this.log);
                            continue;
                        }
                        break;
                    }
                }
                part.rent(true).get();
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug("Finished waiting for renting partition: " + part);
        }
        this.lock.writeLock().lock();
        try {
            for (i = 0; i < this.locParts.length(); ++i) {
                part = this.locParts.get(i);
                if (part == null || part.state() != GridDhtPartitionState.EVICTED) continue;
                this.locParts.set(i, null);
                changed = true;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return changed;
    }

    @Override
    public void readLock() {
        this.lock.readLock().lock();
    }

    @Override
    public void readUnlock() {
        this.lock.readLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTopologyVersion(GridDhtPartitionExchangeId exchId, GridDhtPartitionsExchangeFuture exchFut, long updSeq, boolean stopping) throws IgniteInterruptedCheckedException {
        U.writeLock(this.lock);
        try {
            assert (exchId.topologyVersion().compareTo(this.topVer) > 0) : "Invalid topology version [topVer=" + this.topVer + ", exchId=" + exchId + ", fut=" + exchFut + ']';
            this.stopping = stopping;
            this.updateSeq.setIfGreater(updSeq);
            this.topReadyFut = exchFut;
            this.rebalancedTopVer = AffinityTopologyVersion.NONE;
            this.topVer = exchId.topologyVersion();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public AffinityTopologyVersion topologyVersion() {
        AffinityTopologyVersion topVer = this.topVer;
        assert (topVer.topologyVersion() > 0L) : "Invalid topology version [topVer=" + topVer + ", cacheName=" + this.cctx.name() + ']';
        return topVer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridDhtTopologyFuture topologyVersionFuture() {
        this.lock.readLock().lock();
        try {
            assert (this.topReadyFut != null);
            GridDhtTopologyFuture gridDhtTopologyFuture = this.topReadyFut;
            return gridDhtTopologyFuture;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean stopping() {
        return this.stopping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initPartitions(GridDhtPartitionsExchangeFuture exchFut) throws IgniteInterruptedCheckedException {
        U.writeLock(this.lock);
        try {
            if (this.stopping) {
                return;
            }
            long updateSeq = this.updateSeq.incrementAndGet();
            this.initPartitions0(exchFut, updateSeq);
            this.consistencyCheck();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void initPartitions0(GridDhtPartitionsExchangeFuture exchFut, long updateSeq) {
        ClusterNode loc = this.cctx.localNode();
        ClusterNode oldest = this.currentCoordinator();
        GridDhtPartitionExchangeId exchId = exchFut.exchangeId();
        assert (this.topVer.equals(exchFut.topologyVersion())) : "Invalid topology [topVer=" + this.topVer + ", cache=" + this.cctx.name() + ", futVer=" + exchFut.topologyVersion() + ", fut=" + exchFut + ']';
        assert (this.cctx.affinity().affinityTopologyVersion().equals(exchFut.topologyVersion())) : "Invalid affinity [topVer=" + this.cctx.affinity().affinityTopologyVersion() + ", cache=" + this.cctx.name() + ", futVer=" + exchFut.topologyVersion() + ", fut=" + exchFut + ']';
        List<List<ClusterNode>> aff = this.cctx.affinity().assignments(exchFut.topologyVersion());
        int num = this.cctx.affinity().partitions();
        if (this.cctx.rebalanceEnabled()) {
            boolean first;
            boolean added = exchFut.isCacheAdded(this.cctx.cacheId(), exchId.topologyVersion());
            boolean bl = first = loc.equals(oldest) && loc.id().equals(exchId.nodeId()) && exchId.isJoined() || added;
            if (first) {
                assert (exchId.isJoined() || added);
                for (int p = 0; p < num; ++p) {
                    if (!this.localNode(p, aff)) continue;
                    GridDhtLocalPartition locPart = this.createPartition(p);
                    boolean owned = locPart.own();
                    assert (owned) : "Failed to own partition for oldest node [cacheName" + this.cctx.name() + ", part=" + locPart + ']';
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Owned partition for oldest node: " + locPart);
                    }
                    updateSeq = this.updateLocal(p, locPart.state(), updateSeq);
                }
            } else {
                this.createPartitions(aff, updateSeq);
            }
        } else {
            for (int p = 0; p < num; ++p) {
                GridDhtLocalPartition locPart = this.localPartition(p, this.topVer, false, false);
                boolean belongs = this.localNode(p, aff);
                if (locPart != null) {
                    GridDhtPartitionState state;
                    if (belongs || !(state = locPart.state()).active()) continue;
                    locPart.rent(false);
                    updateSeq = this.updateLocal(p, locPart.state(), updateSeq);
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Evicting partition with rebalancing disabled (it does not belong to affinity): " + locPart);
                    continue;
                }
                if (!belongs) continue;
                this.createPartition(p);
            }
        }
        if (this.node2part != null && this.node2part.valid()) {
            this.checkEvictions(updateSeq, aff);
        }
        this.updateRebalanceVersion(aff);
    }

    private void createPartitions(List<List<ClusterNode>> aff, long updateSeq) {
        int num = this.cctx.affinity().partitions();
        for (int p = 0; p < num; ++p) {
            if (this.node2part != null && this.node2part.valid()) {
                if (!this.localNode(p, aff)) continue;
                GridDhtLocalPartition locPart = this.createPartition(p);
                updateSeq = this.updateLocal(p, locPart.state(), updateSeq);
                continue;
            }
            if (!this.localNode(p, aff)) continue;
            this.createPartition(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeExchange(GridDhtPartitionsExchangeFuture exchFut, boolean affReady) throws IgniteCheckedException {
        this.waitForRent();
        ClusterNode loc = this.cctx.localNode();
        U.writeLock(this.lock);
        try {
            GridDhtPartitionExchangeId exchId = exchFut.exchangeId();
            if (this.stopping) {
                return;
            }
            assert (this.topVer.equals(exchId.topologyVersion())) : "Invalid topology version [topVer=" + this.topVer + ", exchId=" + exchId + ']';
            if (exchId.isLeft()) {
                this.removeNode(exchId.nodeId());
            }
            ClusterNode oldest = this.currentCoordinator();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Partition map beforeExchange [exchId=" + exchId + ", fullMap=" + this.fullMapString() + ']');
            }
            long updateSeq = this.updateSeq.incrementAndGet();
            this.cntrMap.clear();
            if (oldest != null && (loc.equals(oldest) || exchFut.isCacheAdded(this.cctx.cacheId(), exchId.topologyVersion()))) {
                if (this.node2part == null) {
                    this.node2part = new GridDhtPartitionFullMap(oldest.id(), oldest.order(), updateSeq);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Created brand new full topology map on oldest node [exchId=" + exchId + ", fullMap=" + this.fullMapString() + ']');
                    }
                } else if (!this.node2part.valid()) {
                    this.node2part = new GridDhtPartitionFullMap(oldest.id(), oldest.order(), updateSeq, this.node2part, false);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Created new full topology map on oldest node [exchId=" + exchId + ", fullMap=" + this.node2part + ']');
                    }
                } else if (!this.node2part.nodeId().equals(loc.id())) {
                    this.node2part = new GridDhtPartitionFullMap(oldest.id(), oldest.order(), updateSeq, this.node2part, false);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Copied old map into new map on oldest node (previous oldest node left) [exchId=" + exchId + ", fullMap=" + this.fullMapString() + ']');
                    }
                }
            }
            if (affReady) {
                this.initPartitions0(exchFut, updateSeq);
            } else {
                List<List<ClusterNode>> aff = this.cctx.affinity().idealAssignment();
                this.createPartitions(aff, updateSeq);
            }
            this.consistencyCheck();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Partition map after beforeExchange [exchId=" + exchId + ", fullMap=" + this.fullMapString() + ']');
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.waitForRent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean afterExchange(GridDhtPartitionsExchangeFuture exchFut) throws IgniteCheckedException {
        boolean changed = this.waitForRent();
        int num = this.cctx.affinity().partitions();
        AffinityTopologyVersion topVer = exchFut.topologyVersion();
        assert (this.cctx.affinity().affinityTopologyVersion().equals(topVer)) : "Affinity is not initialized [topVer=" + topVer + ", affVer=" + this.cctx.affinity().affinityTopologyVersion() + ", fut=" + exchFut + ']';
        this.lock.writeLock().lock();
        try {
            if (this.stopping) {
                boolean bl = false;
                return bl;
            }
            assert (topVer.equals(exchFut.topologyVersion())) : "Invalid topology version [topVer=" + topVer + ", exchId=" + exchFut.exchangeId() + ']';
            if (this.log.isDebugEnabled()) {
                this.log.debug("Partition map before afterExchange [exchId=" + exchFut.exchangeId() + ", fullMap=" + this.fullMapString() + ']');
            }
            long updateSeq = this.updateSeq.incrementAndGet();
            for (int p = 0; p < num; ++p) {
                GridDhtPartitionState state;
                GridDhtLocalPartition locPart = this.localPartition(p, topVer, false, false);
                if (this.cctx.affinity().partitionLocalNode(p, topVer)) {
                    if (locPart == null) {
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug("Skipping local partition afterExchange (will not create): " + p);
                        continue;
                    }
                    state = locPart.state();
                    if (state != GridDhtPartitionState.MOVING) continue;
                    if (this.cctx.rebalanceEnabled()) {
                        List<ClusterNode> owners = this.owners(p);
                        if (F.isEmpty(owners)) {
                            boolean owned = locPart.own();
                            assert (owned) : "Failed to own partition [cacheName" + this.cctx.name() + ", locPart=" + locPart + ']';
                            updateSeq = this.updateLocal(p, locPart.state(), updateSeq);
                            changed = true;
                            if (this.cctx.events().isRecordable(86)) {
                                DiscoveryEvent discoEvt = exchFut.discoveryEvent();
                                this.cctx.events().addPreloadEvent(p, 86, discoEvt.eventNode(), discoEvt.type(), discoEvt.timestamp());
                            }
                            if (!this.log.isDebugEnabled()) continue;
                            this.log.debug("Owned partition: " + locPart);
                            continue;
                        }
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug("Will not own partition (there are owners to rebalance from) [locPart=" + locPart + ", owners = " + owners + ']');
                        continue;
                    }
                    updateSeq = this.updateLocal(p, locPart.state(), updateSeq);
                    continue;
                }
                if (locPart == null || (state = locPart.state()) != GridDhtPartitionState.MOVING) continue;
                locPart.rent(false);
                updateSeq = this.updateLocal(p, locPart.state(), updateSeq);
                changed = true;
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Evicting moving partition (it does not belong to affinity): " + locPart);
            }
            this.updateRebalanceVersion(this.cctx.affinity().assignments(topVer));
            this.consistencyCheck();
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return changed;
    }

    @Override
    @Nullable
    public GridDhtLocalPartition localPartition(int p, AffinityTopologyVersion topVer, boolean create) throws GridDhtInvalidPartitionException {
        return this.localPartition(p, topVer, create, true);
    }

    private GridDhtLocalPartition createPartition(int p) {
        assert (this.lock.isWriteLockedByCurrentThread());
        GridDhtLocalPartition loc = this.locParts.get(p);
        if (loc == null || loc.state() == GridDhtPartitionState.EVICTED) {
            loc = new GridDhtLocalPartition(this.cctx, p, this.entryFactory);
            this.locParts.set(p, loc);
        }
        return loc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GridDhtLocalPartition localPartition(int p, AffinityTopologyVersion topVer, boolean create, boolean updateSeq) {
        GridDhtLocalPartition loc = this.locParts.get(p);
        if (loc != null && loc.state() != GridDhtPartitionState.EVICTED) {
            return loc;
        }
        if (!create) {
            return null;
        }
        this.lock.writeLock().lock();
        try {
            loc = this.locParts.get(p);
            boolean belongs = this.cctx.affinity().partitionLocalNode(p, topVer);
            if (loc != null && loc.state() == GridDhtPartitionState.EVICTED) {
                loc = null;
                this.locParts.set(p, null);
                if (!belongs) {
                    throw new GridDhtInvalidPartitionException(p, "Adding entry to evicted partition (often may be caused by inconsistent 'key.hashCode()' implementation) [part=" + p + ", topVer=" + topVer + ", this.topVer=" + this.topVer + ']');
                }
            }
            if (loc == null) {
                if (!belongs) {
                    throw new GridDhtInvalidPartitionException(p, "Creating partition which does not belong to local node (often may be caused by inconsistent 'key.hashCode()' implementation) [part=" + p + ", topVer=" + topVer + ", this.topVer=" + this.topVer + ']');
                }
                loc = new GridDhtLocalPartition(this.cctx, p, this.entryFactory);
                this.locParts.set(p, loc);
                if (updateSeq) {
                    this.updateSeq.incrementAndGet();
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Created local partition: " + loc);
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return loc;
    }

    @Override
    public void releasePartitions(int ... parts) {
        assert (parts != null);
        assert (parts.length > 0);
        for (int i = 0; i < parts.length; ++i) {
            GridDhtLocalPartition part = this.locParts.get(parts[i]);
            if (part == null) continue;
            part.release();
        }
    }

    @Override
    public GridDhtLocalPartition localPartition(Object key, boolean create) {
        return this.localPartition(this.cctx.affinity().partition(key), AffinityTopologyVersion.NONE, create);
    }

    @Override
    public List<GridDhtLocalPartition> localPartitions() {
        ArrayList<GridDhtLocalPartition> list = new ArrayList<GridDhtLocalPartition>(this.locParts.length());
        for (int i = 0; i < this.locParts.length(); ++i) {
            GridDhtLocalPartition part = this.locParts.get(i);
            if (part == null) continue;
            list.add(part);
        }
        return list;
    }

    @Override
    public Iterable<GridDhtLocalPartition> currentLocalPartitions() {
        return new Iterable<GridDhtLocalPartition>(){

            @Override
            public Iterator<GridDhtLocalPartition> iterator() {
                return new CurrentPartitionsIterator();
            }
        };
    }

    @Override
    public void onRemoved(GridDhtCacheEntry e) {
        GridDhtLocalPartition loc = this.localPartition(e.partition(), this.topologyVersion(), false);
        if (loc != null) {
            loc.onRemoved(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridDhtPartitionMap2 localPartitionMap() {
        HashMap<Integer, GridDhtPartitionState> map = new HashMap<Integer, GridDhtPartitionState>();
        this.lock.readLock().lock();
        try {
            for (int i = 0; i < this.locParts.length(); ++i) {
                GridDhtLocalPartition part = this.locParts.get(i);
                if (part == null) continue;
                map.put(i, part.state());
            }
            GridDhtPartitionMap2 gridDhtPartitionMap2 = new GridDhtPartitionMap2(this.cctx.nodeId(), this.updateSeq.get(), this.topVer, Collections.unmodifiableMap(map), true);
            return gridDhtPartitionMap2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridDhtPartitionState partitionState(UUID nodeId, int part) {
        this.lock.readLock().lock();
        try {
            GridDhtPartitionMap2 partMap = (GridDhtPartitionMap2)this.node2part.get(nodeId);
            if (partMap != null) {
                GridDhtPartitionState state = partMap.get(part);
                GridDhtPartitionState gridDhtPartitionState = state == null ? GridDhtPartitionState.EVICTED : state;
                return gridDhtPartitionState;
            }
            GridDhtPartitionState gridDhtPartitionState = GridDhtPartitionState.EVICTED;
            return gridDhtPartitionState;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ClusterNode> nodes(int p, AffinityTopologyVersion topVer) {
        AffinityAssignment affAssignment = this.cctx.affinity().assignment(topVer);
        List<ClusterNode> affNodes = affAssignment.get(p);
        this.lock.readLock().lock();
        try {
            assert (this.node2part != null && this.node2part.valid()) : "Invalid node-to-partitions map [topVer1=" + topVer + ", topVer2=" + this.topVer + ", node=" + this.cctx.gridName() + ", cache=" + this.cctx.name() + ", node2part=" + this.node2part + ']';
            List<ClusterNode> nodes = null;
            Collection nodeIds = this.part2node.get(p);
            if (!F.isEmpty(nodeIds)) {
                for (UUID nodeId : nodeIds) {
                    ClusterNode n;
                    HashSet<UUID> affIds = affAssignment.getIds(p);
                    if (affIds.contains(nodeId) || !this.hasState(p, nodeId, GridDhtPartitionState.OWNING, GridDhtPartitionState.MOVING, GridDhtPartitionState.RENTING) || (n = this.cctx.discovery().node(nodeId)) == null || topVer.topologyVersion() >= 0L && n.order() > topVer.topologyVersion()) continue;
                    if (nodes == null) {
                        nodes = new ArrayList<ClusterNode>(affNodes.size() + 2);
                        nodes.addAll(affNodes);
                    }
                    nodes.add(n);
                }
            }
            List<ClusterNode> list = nodes != null ? nodes : affNodes;
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ClusterNode> nodes(int p, AffinityTopologyVersion topVer, GridDhtPartitionState state, GridDhtPartitionState ... states) {
        Collection<UUID> allIds = topVer.topologyVersion() > 0L ? F.nodeIds(CU.affinityNodes(this.cctx, topVer)) : null;
        this.lock.readLock().lock();
        try {
            int size;
            assert (this.node2part != null && this.node2part.valid()) : "Invalid node-to-partitions map [topVer=" + topVer + ", allIds=" + allIds + ", node2part=" + this.node2part + ", cache=" + this.cctx.name() + ']';
            Collection nodeIds = this.part2node.get(p);
            int n = size = nodeIds == null ? 0 : nodeIds.size();
            if (size == 0) {
                List<ClusterNode> list = Collections.emptyList();
                return list;
            }
            ArrayList<ClusterNode> nodes = new ArrayList<ClusterNode>(size);
            for (UUID id : nodeIds) {
                ClusterNode n2;
                if (topVer.topologyVersion() > 0L && !allIds.contains(id) || !this.hasState(p, id, state, states) || (n2 = this.cctx.discovery().node(id)) == null || topVer.topologyVersion() >= 0L && n2.order() > topVer.topologyVersion()) continue;
                nodes.add(n2);
            }
            ArrayList<ClusterNode> arrayList = nodes;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public List<ClusterNode> owners(int p, AffinityTopologyVersion topVer) {
        if (!this.cctx.rebalanceEnabled()) {
            return this.ownersAndMoving(p, topVer);
        }
        return this.nodes(p, topVer, GridDhtPartitionState.OWNING, new GridDhtPartitionState[0]);
    }

    @Override
    public List<ClusterNode> owners(int p) {
        return this.owners(p, AffinityTopologyVersion.NONE);
    }

    @Override
    public List<ClusterNode> moving(int p) {
        if (!this.cctx.rebalanceEnabled()) {
            return this.ownersAndMoving(p, AffinityTopologyVersion.NONE);
        }
        return this.nodes(p, AffinityTopologyVersion.NONE, GridDhtPartitionState.MOVING, new GridDhtPartitionState[0]);
    }

    private List<ClusterNode> ownersAndMoving(int p, AffinityTopologyVersion topVer) {
        return this.nodes(p, topVer, GridDhtPartitionState.OWNING, GridDhtPartitionState.MOVING);
    }

    @Override
    public long updateSequence() {
        return this.updateSeq.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridDhtPartitionFullMap partitionMap(boolean onlyActive) {
        this.lock.readLock().lock();
        try {
            assert (this.node2part != null && this.node2part.valid()) : "Invalid node2part [node2part: " + this.node2part + ", cache=" + this.cctx.name() + ", started=" + this.cctx.started() + ", stopping=" + this.stopping + ", locNodeId=" + this.cctx.localNode().id() + ", locName=" + this.cctx.gridName() + ']';
            GridDhtPartitionFullMap m = this.node2part;
            GridDhtPartitionFullMap gridDhtPartitionFullMap = new GridDhtPartitionFullMap(m.nodeId(), m.nodeOrder(), m.updateSequence(), m, onlyActive);
            return gridDhtPartitionFullMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public boolean update(@Nullable GridDhtPartitionExchangeId exchId, GridDhtPartitionFullMap partMap, @Nullable Map<Integer, Long> cntrMap) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Updating full partition map [exchId=" + exchId + ", parts=" + this.fullMapString() + ']');
        }
        assert (partMap != null);
        this.lock.writeLock().lock();
        try {
            int i;
            if (this.stopping) {
                boolean bl = false;
                return bl;
            }
            if (cntrMap != null) {
                Long cntr;
                for (Map.Entry<Integer, Long> e : cntrMap.entrySet()) {
                    cntr = this.cntrMap.get(e.getKey());
                    if (cntr != null && cntr >= e.getValue()) continue;
                    this.cntrMap.put(e.getKey(), e.getValue());
                }
                for (i = 0; i < this.locParts.length(); ++i) {
                    GridDhtLocalPartition part = this.locParts.get(i);
                    if (part == null || (cntr = cntrMap.get(part.id())) == null) continue;
                    part.updateCounter(cntr);
                }
            }
            if (exchId != null && this.lastExchangeId != null && this.lastExchangeId.compareTo(exchId) >= 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Stale exchange id for full partition map update (will ignore) [lastExchId=" + this.lastExchangeId + ", exchId=" + exchId + ']');
                }
                i = 0;
                return i != 0;
            }
            if (this.node2part != null && this.node2part.compareTo(partMap) >= 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Stale partition map for full partition map update (will ignore) [lastExchId=" + this.lastExchangeId + ", exchId=" + exchId + ", curMap=" + this.node2part + ", newMap=" + partMap + ']');
                }
                i = 0;
                return i != 0;
            }
            long updateSeq = this.updateSeq.incrementAndGet();
            if (exchId != null) {
                this.lastExchangeId = exchId;
            }
            if (this.node2part != null) {
                for (GridDhtPartitionMap2 part : this.node2part.values()) {
                    GridDhtPartitionMap2 newPart = (GridDhtPartitionMap2)partMap.get(part.nodeId());
                    if (newPart == null || newPart.updateSequence() >= part.updateSequence() && (this.cctx.startTopologyVersion() == null || newPart.topologyVersion() == null || this.cctx.startTopologyVersion().compareTo(newPart.topologyVersion()) <= 0)) continue;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Overriding partition map in full update map [exchId=" + exchId + ", curPart=" + this.mapString(part) + ", newPart=" + this.mapString(newPart) + ']');
                    }
                    partMap.put(part.nodeId(), part);
                }
                Iterator it = partMap.keySet().iterator();
                while (it.hasNext()) {
                    UUID nodeId = (UUID)it.next();
                    if (this.cctx.discovery().alive(nodeId)) continue;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Removing left node from full map update [nodeId=" + nodeId + ", partMap=" + partMap + ']');
                    }
                    it.remove();
                }
            }
            this.node2part = partMap;
            HashMap<Integer, Set<UUID>> p2n = U.newHashMap(this.cctx.affinity().partitions());
            for (Map.Entry e : partMap.entrySet()) {
                for (Integer p : ((GridDhtPartitionMap2)e.getValue()).keySet()) {
                    HashSet ids = (HashSet)p2n.get(p);
                    if (ids == null) {
                        ids = U.newHashSet(3);
                        p2n.put(p, ids);
                    }
                    ids.add(e.getKey());
                }
            }
            this.part2node = p2n;
            boolean changed = false;
            AffinityTopologyVersion affVer = this.cctx.affinity().affinityTopologyVersion();
            if (!affVer.equals(AffinityTopologyVersion.NONE) && affVer.compareTo(this.topVer) >= 0) {
                List<List<ClusterNode>> aff = this.cctx.affinity().assignments(this.topVer);
                changed = this.checkEvictions(updateSeq, aff);
                this.updateRebalanceVersion(aff);
            }
            this.consistencyCheck();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Partition map after full update: " + this.fullMapString());
            }
            boolean bl = changed;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public boolean update(@Nullable GridDhtPartitionExchangeId exchId, GridDhtPartitionMap2 parts, @Nullable Map<Integer, Long> cntrMap, boolean checkEvictions) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Updating single partition map [exchId=" + exchId + ", parts=" + this.mapString(parts) + ']');
        }
        if (!this.cctx.discovery().alive(parts.nodeId())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Received partition update for non-existing node (will ignore) [exchId=" + exchId + ", parts=" + parts + ']');
            }
            return false;
        }
        this.lock.writeLock().lock();
        try {
            boolean changed;
            GridDhtPartitionMap2 cur;
            if (this.stopping) {
                boolean bl = false;
                return bl;
            }
            if (cntrMap != null) {
                for (Map.Entry<Integer, Long> e : cntrMap.entrySet()) {
                    GridDhtLocalPartition part;
                    Integer p = e.getKey();
                    Long cntr = this.cntrMap.get(p);
                    if (cntr == null || cntr < e.getValue()) {
                        this.cntrMap.put(p, e.getValue());
                    }
                    if ((part = this.locParts.get(p)) == null) continue;
                    part.updateCounter(e.getValue());
                }
            }
            if (this.lastExchangeId != null && exchId != null && this.lastExchangeId.compareTo(exchId) > 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Stale exchange id for single partition map update (will ignore) [lastExchId=" + this.lastExchangeId + ", exchId=" + exchId + ']');
                }
                boolean i$ = false;
                return i$;
            }
            if (exchId != null) {
                this.lastExchangeId = exchId;
            }
            if (this.node2part == null) {
                this.node2part = new GridDhtPartitionFullMap();
            }
            if ((cur = (GridDhtPartitionMap2)this.node2part.get(parts.nodeId())) != null && cur.updateSequence() >= parts.updateSequence()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Stale update sequence for single partition map update (will ignore) [exchId=" + exchId + ", curSeq=" + cur.updateSequence() + ", newSeq=" + parts.updateSequence() + ']');
                }
                boolean e = false;
                return e;
            }
            long updateSeq = this.updateSeq.incrementAndGet();
            this.node2part.newUpdateSequence(updateSeq);
            boolean bl = changed = cur == null || !cur.equals(parts);
            if (changed) {
                Set<UUID> ids;
                this.node2part.put(parts.nodeId(), parts);
                for (Integer p : parts.keySet()) {
                    ids = this.part2node.get(p);
                    if (ids == null) {
                        ids = U.newHashSet(3);
                        this.part2node.put(p, ids);
                    }
                    ids.add(parts.nodeId());
                }
                if (cur != null) {
                    for (Integer p : cur.keySet()) {
                        if (parts.containsKey(p) || (ids = this.part2node.get(p)) == null) continue;
                        ids.remove(parts.nodeId());
                    }
                }
            } else {
                cur.updateSequence(parts.updateSequence(), parts.topologyVersion());
            }
            if (checkEvictions) {
                changed |= this.checkEvictions(updateSeq);
            }
            this.consistencyCheck();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Partition map after single update: " + this.fullMapString());
            }
            boolean bl2 = changed;
            return bl2;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private boolean checkEvictions(long updateSeq) {
        AffinityTopologyVersion affVer = this.cctx.affinity().affinityTopologyVersion();
        boolean changed = false;
        if (!affVer.equals(AffinityTopologyVersion.NONE) && affVer.compareTo(this.topVer) >= 0) {
            List<List<ClusterNode>> aff = this.cctx.affinity().assignments(this.topVer);
            changed = this.checkEvictions(updateSeq, aff);
            this.updateRebalanceVersion(aff);
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkEvictions() {
        this.lock.writeLock().lock();
        try {
            long updateSeq = this.updateSeq.incrementAndGet();
            this.node2part.newUpdateSequence(updateSeq);
            this.checkEvictions(updateSeq);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private boolean checkEvictions(long updateSeq, List<List<ClusterNode>> aff) {
        boolean changed = false;
        UUID locId = this.cctx.nodeId();
        block0: for (int p = 0; p < this.locParts.length(); ++p) {
            int affCnt;
            List<ClusterNode> affNodes;
            GridDhtPartitionState state;
            GridDhtLocalPartition part = this.locParts.get(p);
            if (part == null || !(state = part.state()).active() || (affNodes = aff.get(p)).contains(this.cctx.localNode())) continue;
            Collection<UUID> nodeIds = F.nodeIds(this.nodes(p, this.topVer, GridDhtPartitionState.OWNING, new GridDhtPartitionState[0]));
            if (nodeIds.containsAll(F.nodeIds(affNodes))) {
                part.rent(false);
                updateSeq = this.updateLocal(part.id(), part.state(), updateSeq);
                changed = true;
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Evicted local partition (all affinity nodes are owners): " + part);
                continue;
            }
            int ownerCnt = nodeIds.size();
            if (ownerCnt <= (affCnt = affNodes.size())) continue;
            ArrayList<ClusterNode> sorted = new ArrayList<ClusterNode>(this.cctx.discovery().nodes(nodeIds, new IgnitePredicate[0]));
            Collections.sort(sorted, CU.nodeComparator(true));
            int diff = sorted.size() - affCnt;
            for (int i = 0; i < diff; ++i) {
                ClusterNode n = (ClusterNode)sorted.get(i);
                if (!locId.equals(n.id())) continue;
                part.rent(false);
                updateSeq = this.updateLocal(part.id(), part.state(), updateSeq);
                changed = true;
                if (!this.log.isDebugEnabled()) continue block0;
                this.log.debug("Evicted local partition (this node is oldest non-affinity node): " + part);
                continue block0;
            }
        }
        return changed;
    }

    @Nullable
    private ClusterNode currentCoordinator() {
        ClusterNode oldest = this.cctx.discovery().oldestAliveCacheServerNode(this.topVer);
        assert (oldest != null || this.cctx.kernalContext().clientNode());
        return oldest;
    }

    private long updateLocal(int p, GridDhtPartitionState state, long updateSeq) {
        UUID locNodeId;
        GridDhtPartitionMap2 map;
        long seq;
        ClusterNode oldest = this.currentCoordinator();
        assert (oldest != null || this.cctx.kernalContext().clientNode());
        if (this.cctx.localNode().equals(oldest) && (seq = this.node2part.updateSequence()) != updateSeq) {
            if (seq > updateSeq) {
                long seq0 = this.updateSeq.get();
                if (seq0 < seq) {
                    boolean b = this.updateSeq.compareAndSet(seq0, seq + 1L);
                    assert (b) : "Invalid update sequence [updateSeq=" + updateSeq + ", seq=" + seq + ", curUpdateSeq=" + this.updateSeq.get() + ", node2part=" + this.node2part.toFullString() + ']';
                    updateSeq = seq + 1L;
                } else {
                    updateSeq = seq;
                }
            }
            this.node2part.updateSequence(updateSeq);
        }
        if ((map = (GridDhtPartitionMap2)this.node2part.get(locNodeId = this.cctx.localNodeId())) == null) {
            map = new GridDhtPartitionMap2(locNodeId, updateSeq, this.topVer, Collections.emptyMap(), false);
            this.node2part.put(locNodeId, map);
        }
        map.updateSequence(updateSeq, this.topVer);
        map.put(p, state);
        Set<UUID> ids = this.part2node.get(p);
        if (ids == null) {
            ids = U.newHashSet(3);
            this.part2node.put(p, ids);
        }
        ids.add(locNodeId);
        return updateSeq;
    }

    private void removeNode(UUID nodeId) {
        assert (nodeId != null);
        ClusterNode oldest = CU.oldest(this.cctx.discovery().serverNodes(this.topVer));
        assert (oldest != null);
        ClusterNode loc = this.cctx.localNode();
        if (this.node2part != null) {
            if (oldest.equals(loc) && !this.node2part.nodeId().equals(loc.id())) {
                this.updateSeq.setIfGreater(this.node2part.updateSequence());
                this.node2part = new GridDhtPartitionFullMap(loc.id(), loc.order(), this.updateSeq.incrementAndGet(), this.node2part, false);
            } else {
                this.node2part = new GridDhtPartitionFullMap(this.node2part, this.node2part.updateSequence());
            }
            GridDhtPartitionMap2 parts = (GridDhtPartitionMap2)this.node2part.remove(nodeId);
            if (parts != null) {
                for (Integer p : parts.keySet()) {
                    Set<UUID> nodeIds = this.part2node.get(p);
                    if (nodeIds == null) continue;
                    nodeIds.remove(nodeId);
                    if (!nodeIds.isEmpty()) continue;
                    this.part2node.remove(p);
                }
            }
            this.consistencyCheck();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean own(GridDhtLocalPartition part) {
        this.lock.writeLock().lock();
        try {
            if (part.own()) {
                this.updateLocal(part.id(), part.state(), this.updateSeq.incrementAndGet());
                this.consistencyCheck();
                boolean bl = true;
                return bl;
            }
            this.consistencyCheck();
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEvicted(GridDhtLocalPartition part, boolean updateSeq) {
        this.lock.writeLock().lock();
        try {
            if (this.stopping) {
                return;
            }
            assert (part.state() == GridDhtPartitionState.EVICTED);
            long seq = updateSeq ? this.updateSeq.incrementAndGet() : this.updateSeq.get();
            this.updateLocal(part.id(), part.state(), seq);
            this.consistencyCheck();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Integer, Long> updateCounters(boolean skipZeros) {
        this.lock.readLock().lock();
        try {
            HashMap<Integer, Long> res;
            if (skipZeros) {
                res = U.newHashMap(this.cntrMap.size());
                for (Map.Entry<Integer, Long> e : this.cntrMap.entrySet()) {
                    Long cntr = e.getValue();
                    if (ZERO.equals(cntr)) continue;
                    res.put(e.getKey(), cntr);
                }
            } else {
                res = new HashMap<Integer, Long>(this.cntrMap);
            }
            for (int i = 0; i < this.locParts.length(); ++i) {
                GridDhtLocalPartition part = this.locParts.get(i);
                if (part == null) continue;
                Long cntr0 = (Long)res.get(part.id());
                long cntr1 = part.updateCounter();
                if (skipZeros && cntr1 == 0L || cntr0 != null && cntr1 <= cntr0) continue;
                res.put(part.id(), cntr1);
            }
            HashMap<Integer, Long> hashMap = res;
            return hashMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean rebalanceFinished(AffinityTopologyVersion topVer) {
        AffinityTopologyVersion curTopVer = this.topVer;
        return curTopVer.equals(topVer) && curTopVer.equals(this.rebalancedTopVer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasMovingPartitions() {
        this.lock.readLock().lock();
        try {
            assert (this.node2part != null && this.node2part.valid()) : "Invalid node2part [node2part: " + this.node2part + ", cache=" + this.cctx.name() + ", started=" + this.cctx.started() + ", stopping=" + this.stopping + ", locNodeId=" + this.cctx.localNode().id() + ", locName=" + this.cctx.gridName() + ']';
            for (GridDhtPartitionMap2 map : this.node2part.values()) {
                if (!map.hasMovingPartitions()) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printMemoryStats(int threshold) {
        X.println(">>>  Cache partition topology stats [grid=" + this.cctx.gridName() + ", cache=" + this.cctx.name() + ']', new Object[0]);
        this.lock.readLock().lock();
        try {
            for (int i = 0; i < this.locParts.length(); ++i) {
                int size;
                GridDhtLocalPartition part = this.locParts.get(i);
                if (part == null || (size = part.size()) < threshold) continue;
                X.println(">>>   Local partition [part=" + part.id() + ", size=" + size + ']', new Object[0]);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private boolean localNode(int part, List<List<ClusterNode>> aff) {
        return aff.get(part).contains(this.cctx.localNode());
    }

    private void updateRebalanceVersion(List<List<ClusterNode>> aff) {
        if (!this.rebalancedTopVer.equals(this.topVer)) {
            if (this.node2part == null || !this.node2part.valid()) {
                return;
            }
            for (int i = 0; i < this.cctx.affinity().partitions(); ++i) {
                List<ClusterNode> affNodes = aff.get(i);
                if (affNodes.isEmpty()) continue;
                List<ClusterNode> owners = this.owners(i);
                if (affNodes.size() == owners.size() && owners.containsAll(affNodes)) continue;
                return;
            }
            this.rebalancedTopVer = this.topVer;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Updated rebalanced version [cache=" + this.cctx.name() + ", ver=" + this.rebalancedTopVer + ']');
            }
        }
    }

    private boolean hasState(int p, @Nullable UUID nodeId, GridDhtPartitionState match, GridDhtPartitionState ... matches) {
        if (nodeId == null) {
            return false;
        }
        GridDhtPartitionMap2 parts = (GridDhtPartitionMap2)this.node2part.get(nodeId);
        if (parts != null) {
            GridDhtPartitionState state = parts.get(p);
            if (state == match) {
                return true;
            }
            if (matches != null && matches.length > 0) {
                for (GridDhtPartitionState s : matches) {
                    if (state != s) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void consistencyCheck() {
    }

    private class CurrentPartitionsIterator
    implements Iterator<GridDhtLocalPartition> {
        private int nextIdx;
        private GridDhtLocalPartition nextPart;

        private CurrentPartitionsIterator() {
            this.advance();
        }

        private void advance() {
            while (this.nextIdx < GridDhtPartitionTopologyImpl.this.locParts.length()) {
                GridDhtLocalPartition part = (GridDhtLocalPartition)GridDhtPartitionTopologyImpl.this.locParts.get(this.nextIdx);
                if (part != null) {
                    this.nextPart = part;
                    return;
                }
                ++this.nextIdx;
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextPart != null;
        }

        @Override
        public GridDhtLocalPartition next() {
            if (this.nextPart == null) {
                throw new NoSuchElementException();
            }
            GridDhtLocalPartition retVal = this.nextPart;
            this.nextPart = null;
            ++this.nextIdx;
            this.advance();
            return retVal;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

