/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.UUID;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxFinishRequest;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.apache.ignite.transactions.TransactionIsolation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridDhtTxFinishRequest
extends GridDistributedTxFinishRequest {
    private static final long serialVersionUID = 0L;
    public static final int WAIT_REMOTE_TX_FLAG_MASK = 1;
    public static final int NEED_RETURN_VALUE_FLAG_MASK = 2;
    private UUID nearNodeId;
    private TransactionIsolation isolation;
    private IgniteUuid miniId;
    private boolean sysInvalidate;
    private AffinityTopologyVersion topVer;
    @GridToStringInclude
    @GridDirectCollection(value=GridCacheVersion.class)
    private Collection<GridCacheVersion> pendingVers;
    private boolean checkCommitted;
    @GridToStringInclude
    @GridDirectCollection(value=Long.class)
    private GridLongList partUpdateCnt;
    private GridCacheVersion writeVer;
    private UUID subjId;
    private int taskNameHash;
    private byte flags;

    public GridDhtTxFinishRequest() {
    }

    public GridDhtTxFinishRequest(UUID nearNodeId, IgniteUuid futId, IgniteUuid miniId, @NotNull AffinityTopologyVersion topVer, GridCacheVersion xidVer, GridCacheVersion commitVer, long threadId, TransactionIsolation isolation, boolean commit, boolean invalidate, boolean sys, byte plc, boolean sysInvalidate, boolean syncCommit, boolean syncRollback, GridCacheVersion baseVer, Collection<GridCacheVersion> committedVers, Collection<GridCacheVersion> rolledbackVers, Collection<GridCacheVersion> pendingVers, int txSize, @Nullable UUID subjId, int taskNameHash, boolean addDepInfo, boolean retVal, boolean waitRemoteTxs) {
        super(xidVer, futId, commitVer, threadId, commit, invalidate, sys, plc, syncCommit, syncRollback, baseVer, committedVers, rolledbackVers, txSize, addDepInfo);
        assert (miniId != null);
        assert (nearNodeId != null);
        assert (isolation != null);
        this.pendingVers = pendingVers;
        this.topVer = topVer;
        this.nearNodeId = nearNodeId;
        this.isolation = isolation;
        this.miniId = miniId;
        this.sysInvalidate = sysInvalidate;
        this.subjId = subjId;
        this.taskNameHash = taskNameHash;
        this.needReturnValue(retVal);
        this.waitRemoteTransactions(waitRemoteTxs);
    }

    public GridDhtTxFinishRequest(UUID nearNodeId, IgniteUuid futId, IgniteUuid miniId, @NotNull AffinityTopologyVersion topVer, GridCacheVersion xidVer, GridCacheVersion commitVer, long threadId, TransactionIsolation isolation, boolean commit, boolean invalidate, boolean sys, byte plc, boolean sysInvalidate, boolean syncCommit, boolean syncRollback, GridCacheVersion baseVer, Collection<GridCacheVersion> committedVers, Collection<GridCacheVersion> rolledbackVers, Collection<GridCacheVersion> pendingVers, int txSize, @Nullable UUID subjId, int taskNameHash, boolean addDepInfo, Collection<Long> updateIdxs, boolean retVal, boolean waitRemoteTxs) {
        this(nearNodeId, futId, miniId, topVer, xidVer, commitVer, threadId, isolation, commit, invalidate, sys, plc, sysInvalidate, syncCommit, syncRollback, baseVer, committedVers, rolledbackVers, pendingVers, txSize, subjId, taskNameHash, addDepInfo, retVal, waitRemoteTxs);
        if (updateIdxs != null && !updateIdxs.isEmpty()) {
            this.partUpdateCnt = new GridLongList(updateIdxs.size());
            for (Long idx : updateIdxs) {
                this.partUpdateCnt.add(idx);
            }
        }
    }

    public GridLongList partUpdateCounters() {
        return this.partUpdateCnt;
    }

    public IgniteUuid miniId() {
        return this.miniId;
    }

    @Nullable
    public UUID subjectId() {
        return this.subjId;
    }

    public int taskNameHash() {
        return this.taskNameHash;
    }

    public TransactionIsolation isolation() {
        return this.isolation;
    }

    public UUID nearNodeId() {
        return this.nearNodeId;
    }

    public boolean isSystemInvalidate() {
        return this.sysInvalidate;
    }

    public GridCacheVersion writeVersion() {
        return this.writeVer;
    }

    public void writeVersion(GridCacheVersion writeVer) {
        this.writeVer = writeVer;
    }

    @Override
    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    public boolean checkCommitted() {
        return this.checkCommitted;
    }

    public void checkCommitted(boolean checkCommitted) {
        this.checkCommitted = checkCommitted;
    }

    public boolean waitRemoteTransactions() {
        return (this.flags & 1) != 0;
    }

    public void waitRemoteTransactions(boolean waitRemoteTxs) {
        this.flags = waitRemoteTxs ? (byte)(this.flags | 1) : (byte)(this.flags & 0xFFFFFFFE);
    }

    public boolean needReturnValue() {
        return (this.flags & 2) != 0;
    }

    public void needReturnValue(boolean retVal) {
        this.flags = retVal ? (byte)(this.flags | 2) : (byte)(this.flags & 0xFFFFFFFD);
    }

    @Override
    public String toString() {
        return S.toString(GridDhtTxFinishRequest.class, this, super.toString());
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 18: {
                if (!writer.writeBoolean("checkCommitted", this.checkCommitted)) {
                    return false;
                }
                writer.incrementState();
            }
            case 19: {
                if (!writer.writeByte("flags", this.flags)) {
                    return false;
                }
                writer.incrementState();
            }
            case 20: {
                if (!writer.writeByte("isolation", this.isolation != null ? (byte)this.isolation.ordinal() : (byte)-1)) {
                    return false;
                }
                writer.incrementState();
            }
            case 21: {
                if (!writer.writeIgniteUuid("miniId", this.miniId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 22: {
                if (!writer.writeUuid("nearNodeId", this.nearNodeId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 23: {
                if (!writer.writeMessage("partUpdateCnt", this.partUpdateCnt)) {
                    return false;
                }
                writer.incrementState();
            }
            case 24: {
                if (!writer.writeCollection("pendingVers", this.pendingVers, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 25: {
                if (!writer.writeUuid("subjId", this.subjId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 26: {
                if (!writer.writeBoolean("sysInvalidate", this.sysInvalidate)) {
                    return false;
                }
                writer.incrementState();
            }
            case 27: {
                if (!writer.writeInt("taskNameHash", this.taskNameHash)) {
                    return false;
                }
                writer.incrementState();
            }
            case 28: {
                if (!writer.writeMessage("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 29: {
                if (!writer.writeMessage("writeVer", this.writeVer)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 18: {
                this.checkCommitted = reader.readBoolean("checkCommitted");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 19: {
                this.flags = reader.readByte("flags");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 20: {
                byte isolationOrd = reader.readByte("isolation");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.isolation = TransactionIsolation.fromOrdinal(isolationOrd);
                reader.incrementState();
            }
            case 21: {
                this.miniId = reader.readIgniteUuid("miniId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 22: {
                this.nearNodeId = reader.readUuid("nearNodeId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 23: {
                this.partUpdateCnt = (GridLongList)reader.readMessage("partUpdateCnt");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 24: {
                this.pendingVers = reader.readCollection("pendingVers", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 25: {
                this.subjId = reader.readUuid("subjId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 26: {
                this.sysInvalidate = reader.readBoolean("sysInvalidate");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 27: {
                this.taskNameHash = reader.readInt("taskNameHash");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 28: {
                this.topVer = (AffinityTopologyVersion)reader.readMessage("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 29: {
                this.writeVer = (GridCacheVersion)reader.readMessage("writeVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDhtTxFinishRequest.class);
    }

    @Override
    public byte directType() {
        return 32;
    }

    @Override
    public byte fieldsCount() {
        return 30;
    }
}

