/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheReturn;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxFinishResponse;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class GridDhtTxFinishResponse
extends GridDistributedTxFinishResponse {
    private static final long serialVersionUID = 0L;
    private IgniteUuid miniId;
    @GridDirectTransient
    private Throwable checkCommittedErr;
    private byte[] checkCommittedErrBytes;
    private boolean checkCommitted;
    private GridCacheReturn retVal;

    public GridDhtTxFinishResponse() {
    }

    public GridDhtTxFinishResponse(GridCacheVersion xid, IgniteUuid futId, IgniteUuid miniId) {
        super(xid, futId);
        assert (miniId != null);
        this.miniId = miniId;
    }

    public IgniteUuid miniId() {
        return this.miniId;
    }

    public Throwable checkCommittedError() {
        return this.checkCommittedErr;
    }

    public void checkCommittedError(Throwable checkCommittedErr) {
        this.checkCommittedErr = checkCommittedErr;
    }

    public boolean checkCommitted() {
        return this.checkCommitted;
    }

    public void checkCommitted(boolean checkCommitted) {
        this.checkCommitted = checkCommitted;
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        if (this.checkCommittedErr != null && this.checkCommittedErrBytes == null) {
            this.checkCommittedErrBytes = U.marshal(ctx, (Object)this.checkCommittedErr);
        }
        if (this.retVal != null && this.retVal.cacheId() != 0) {
            GridCacheContext cctx = ctx.cacheContext(this.retVal.cacheId());
            assert (cctx != null) : this.retVal.cacheId();
            this.retVal.prepareMarshal(cctx);
        }
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        if (this.checkCommittedErrBytes != null && this.checkCommittedErr == null) {
            this.checkCommittedErr = (Throwable)U.unmarshal(ctx, this.checkCommittedErrBytes, U.resolveClassLoader(ldr, ctx.gridConfig()));
        }
        if (this.retVal != null && this.retVal.cacheId() != 0) {
            GridCacheContext cctx = ctx.cacheContext(this.retVal.cacheId());
            assert (cctx != null) : this.retVal.cacheId();
            this.retVal.finishUnmarshal(cctx, ldr);
        }
    }

    public void returnValue(GridCacheReturn retVal) {
        this.retVal = retVal;
    }

    public GridCacheReturn returnValue() {
        return this.retVal;
    }

    @Override
    public String toString() {
        return S.toString(GridDhtTxFinishResponse.class, this, super.toString());
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 5: {
                if (!writer.writeBoolean("checkCommitted", this.checkCommitted)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeByteArray("checkCommittedErrBytes", this.checkCommittedErrBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                if (!writer.writeIgniteUuid("miniId", this.miniId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                if (!writer.writeMessage("retVal", this.retVal)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 5: {
                this.checkCommitted = reader.readBoolean("checkCommitted");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.checkCommittedErrBytes = reader.readByteArray("checkCommittedErrBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.miniId = reader.readIgniteUuid("miniId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 8: {
                this.retVal = (GridCacheReturn)reader.readMessage("retVal");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDhtTxFinishResponse.class);
    }

    @Override
    public byte directType() {
        return 33;
    }

    @Override
    public byte fieldsCount() {
        return 9;
    }
}

