/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.processor.EntryProcessor;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheInvokeEntry;
import org.apache.ignite.internal.processors.cache.CacheLockCandidates;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheMvccCandidate;
import org.apache.ignite.internal.processors.cache.GridCacheMvccFuture;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheReturn;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxMapping;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxLocalAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxPrepareRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxPrepareResponse;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxPrepareResponse;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.dr.GridDrType;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObjectAdapter;
import org.apache.ignite.internal.transactions.IgniteTxHeuristicCheckedException;
import org.apache.ignite.internal.transactions.IgniteTxOptimisticCheckedException;
import org.apache.ignite.internal.transactions.IgniteTxTimeoutCheckedException;
import org.apache.ignite.internal.util.F0;
import org.apache.ignite.internal.util.GridLeanSet;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.IgnitePair;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.CIX1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteFutureCancelledException;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteReducer;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.transactions.TransactionState;
import org.jetbrains.annotations.Nullable;

public final class GridDhtTxPrepareFuture
extends GridCompoundFuture<IgniteInternalTx, GridNearTxPrepareResponse>
implements GridCacheMvccFuture<GridNearTxPrepareResponse> {
    private static final long serialVersionUID = 0L;
    private static final AtomicReference<IgniteLogger> logRef = new AtomicReference();
    private static final AtomicReferenceFieldUpdater<GridDhtTxPrepareFuture, Throwable> ERR_UPD = AtomicReferenceFieldUpdater.newUpdater(GridDhtTxPrepareFuture.class, Throwable.class, "err");
    private static final IgniteReducer<IgniteInternalTx, GridNearTxPrepareResponse> REDUCER = new IgniteReducer<IgniteInternalTx, GridNearTxPrepareResponse>(){

        @Override
        public boolean collect(IgniteInternalTx e) {
            return true;
        }

        @Override
        public GridNearTxPrepareResponse reduce() {
            return null;
        }
    };
    private static final AtomicIntegerFieldUpdater<GridDhtTxPrepareFuture> REPLIED_UPD = AtomicIntegerFieldUpdater.newUpdater(GridDhtTxPrepareFuture.class, "replied");
    private static final AtomicIntegerFieldUpdater<GridDhtTxPrepareFuture> MAPPED_UPD = AtomicIntegerFieldUpdater.newUpdater(GridDhtTxPrepareFuture.class, "mapped");
    private static IgniteLogger log;
    private static IgniteLogger msgLog;
    private GridCacheSharedContext<?, ?> cctx;
    private IgniteUuid futId;
    @GridToStringExclude
    private GridDhtTxLocalAdapter tx;
    private Map<UUID, GridDistributedTxMapping> nearMap;
    private Map<UUID, GridDistributedTxMapping> dhtMap;
    private volatile Throwable err;
    private volatile int replied;
    private volatile int mapped;
    private Iterable<IgniteTxEntry> reads;
    private Iterable<IgniteTxEntry> writes;
    private Map<UUID, Collection<UUID>> txNodes;
    private boolean trackable = true;
    private IgniteUuid nearMiniId;
    private Map<IgniteTxKey, GridCacheVersion> dhtVerMap;
    private boolean last;
    private boolean retVal;
    private GridCacheReturn ret;
    private Collection<IgniteTxKey> filterFailedKeys;
    @GridToStringInclude
    private final Set<IgniteTxKey> lockKeys = new HashSet<IgniteTxKey>();
    private IgniteInternalFuture<?> forceKeysFut;
    private volatile boolean locksReady;
    private boolean invoke;
    private final PrepareTimeoutObject timeoutObj;

    public GridDhtTxPrepareFuture(GridCacheSharedContext cctx, GridDhtTxLocalAdapter tx, long timeout, IgniteUuid nearMiniId, Map<IgniteTxKey, GridCacheVersion> dhtVerMap, boolean last, boolean retVal) {
        super(REDUCER);
        this.cctx = cctx;
        this.tx = tx;
        this.dhtVerMap = dhtVerMap;
        this.last = last;
        this.futId = IgniteUuid.randomUuid();
        this.nearMiniId = nearMiniId;
        if (log == null) {
            msgLog = cctx.txPrepareMessageLogger();
            log = U.logger(cctx.kernalContext(), logRef, GridDhtTxPrepareFuture.class);
        }
        this.dhtMap = tx.dhtMap();
        this.nearMap = tx.nearMap();
        this.retVal = retVal;
        assert (this.dhtMap != null);
        assert (this.nearMap != null);
        this.timeoutObj = timeout > 0L ? new PrepareTimeoutObject(timeout) : null;
    }

    @Override
    public IgniteUuid futureId() {
        return this.futId;
    }

    public IgniteUuid nearMiniId() {
        return this.nearMiniId;
    }

    @Override
    public GridCacheVersion version() {
        return this.tx.xidVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onOwnerChanged(GridCacheEntryEx entry, GridCacheMvccCandidate owner) {
        boolean rmv;
        if (log.isDebugEnabled()) {
            log.debug("Transaction future received owner changed callback: " + entry);
        }
        Object object = this.sync;
        synchronized (object) {
            rmv = this.lockKeys.remove(entry.txKey());
        }
        return rmv && this.mapIfLocked();
    }

    @Override
    public boolean trackable() {
        return this.trackable;
    }

    @Override
    public void markNotTrackable() {
        this.trackable = false;
    }

    public GridDhtTxLocalAdapter tx() {
        return this.tx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkLocks() {
        if (!this.locksReady) {
            return false;
        }
        Object object = this.sync;
        synchronized (object) {
            return this.lockKeys.isEmpty();
        }
    }

    @Override
    public boolean onNodeLeft(UUID nodeId) {
        for (IgniteInternalFuture fut : this.futures()) {
            MiniFuture f;
            if (!this.isMini(fut) || !(f = (MiniFuture)fut).node().id().equals(nodeId)) continue;
            f.onNodeLeft();
            return true;
        }
        return false;
    }

    private void onEntriesLocked() {
        this.ret = new GridCacheReturn(null, this.tx.localResult(), true, null, true);
        for (IgniteTxEntry writeEntry : this.writes) {
            IgniteTxEntry txEntry = this.tx.entry(writeEntry.txKey());
            assert (txEntry != null) : writeEntry;
            GridCacheContext<?, ?> cacheCtx = txEntry.context();
            GridCacheEntryEx cached = txEntry.cached();
            ExpiryPolicy expiry = cacheCtx.expiryForTxEntry(txEntry);
            try {
                boolean sndOldVal;
                boolean readOld;
                if ((txEntry.op() == GridCacheOperation.CREATE || txEntry.op() == GridCacheOperation.UPDATE) && txEntry.conflictExpireTime() == -1L && expiry != null) {
                    Duration duration = cached.hasValue() ? expiry.getExpiryForUpdate() : expiry.getExpiryForCreation();
                    txEntry.ttl(CU.toTtl(duration));
                }
                boolean hasFilters = !F.isEmptyOrNulls(txEntry.filters()) && !F.isAlwaysTrue(txEntry.filters());
                CacheObject oldVal = null;
                boolean bl = readOld = hasFilters || this.retVal || txEntry.op() == GridCacheOperation.DELETE || txEntry.op() == GridCacheOperation.TRANSFORM;
                if (readOld) {
                    cached.unswap(this.retVal);
                    boolean readThrough = !txEntry.skipStore() && (txEntry.op() == GridCacheOperation.TRANSFORM || (this.retVal || hasFilters) && cacheCtx.config().isLoadPreviousValue());
                    boolean evt = this.retVal || txEntry.op() == GridCacheOperation.TRANSFORM;
                    EntryProcessor entryProc = null;
                    if (evt && txEntry.op() == GridCacheOperation.TRANSFORM) {
                        entryProc = (EntryProcessor)F.first(txEntry.entryProcessors()).get1();
                    }
                    boolean keepBinary = txEntry.keepBinary();
                    CacheObject val = oldVal = cached.innerGet(null, this.tx, true, readThrough, this.retVal, evt, false, this.tx.subjectId(), entryProc, this.tx.resolveTaskName(), null, keepBinary);
                    if (this.retVal || txEntry.op() == GridCacheOperation.TRANSFORM) {
                        if (!F.isEmpty(txEntry.entryProcessors())) {
                            GridCacheOperation op;
                            this.invoke = true;
                            if (txEntry.hasValue()) {
                                val = txEntry.value();
                            }
                            KeyCacheObject key = txEntry.key();
                            Object procRes = null;
                            Exception err = null;
                            boolean modified = false;
                            txEntry.oldValueOnPrimary(val != null);
                            for (T2<EntryProcessor<Object, Object, Object>, Object[]> t : txEntry.entryProcessors()) {
                                CacheInvokeEntry invokeEntry = new CacheInvokeEntry(key, val, txEntry.cached().version(), keepBinary, txEntry.cached());
                                try {
                                    EntryProcessor processor = (EntryProcessor)t.get1();
                                    procRes = processor.process(invokeEntry, (Object[])t.get2());
                                    val = cacheCtx.toCacheObject(invokeEntry.getValue(true));
                                }
                                catch (Exception e) {
                                    err = e;
                                    break;
                                }
                                modified |= invokeEntry.modified();
                            }
                            if (modified) {
                                val = cacheCtx.toCacheObject(cacheCtx.unwrapTemporary(val));
                            }
                            GridCacheOperation gridCacheOperation = modified ? (val == null ? GridCacheOperation.DELETE : GridCacheOperation.UPDATE) : (op = GridCacheOperation.NOOP);
                            if (op == GridCacheOperation.NOOP && expiry != null) {
                                long ttl = CU.toTtl(expiry.getExpiryForAccess());
                                txEntry.ttl(ttl);
                                if (ttl == -2L) {
                                    op = GridCacheOperation.DELETE;
                                }
                            }
                            txEntry.entryProcessorCalculatedValue(new T2<GridCacheOperation, CacheObject>(op, op == GridCacheOperation.NOOP ? null : val));
                            if (this.retVal) {
                                if (err != null || procRes != null) {
                                    this.ret.addEntryProcessResult(txEntry.context(), key, null, procRes, err, keepBinary);
                                } else {
                                    this.ret.invokeResult(true);
                                }
                            }
                        } else if (this.retVal) {
                            this.ret.value(cacheCtx, val, keepBinary);
                        }
                    }
                    if (hasFilters && !cacheCtx.isAll(cached, txEntry.filters())) {
                        if (expiry != null) {
                            txEntry.ttl(CU.toTtl(expiry.getExpiryForAccess()));
                        }
                        txEntry.op(GridCacheOperation.NOOP);
                        if (this.filterFailedKeys == null) {
                            this.filterFailedKeys = new ArrayList<IgniteTxKey>();
                        }
                        this.filterFailedKeys.add(cached.txKey());
                        this.ret.success(false);
                    } else {
                        this.ret.success(txEntry.op() != GridCacheOperation.DELETE || cached.hasValue());
                    }
                }
                if (!(sndOldVal = !cacheCtx.isLocal() && !cacheCtx.topology().rebalanceFinished(this.tx.topologyVersion()))) continue;
                if (oldVal == null && !readOld) {
                    oldVal = cached.innerGet(null, this.tx, true, false, false, false, false, this.tx.subjectId(), null, null, null, true);
                }
                if (oldVal == null) continue;
                oldVal.prepareMarshal(cacheCtx.cacheObjectContext());
                txEntry.oldValue(oldVal, true);
            }
            catch (IgniteCheckedException e) {
                U.error(log, "Failed to get result value for cache entry: " + cached, e);
            }
            catch (GridCacheEntryRemovedException e) {
                assert (false) : "Got entry removed exception while holding transactional lock on entry [e=" + e + ", cached=" + cached + ']';
            }
        }
    }

    public void onError(Throwable t) {
        this.onDone(null, t);
    }

    public void onResult(UUID nodeId, GridDhtTxPrepareResponse res) {
        if (this.isDone()) {
            if (msgLog.isDebugEnabled()) {
                msgLog.debug("DHT prepare fut, response for finished future [txId=" + this.tx.nearXidVersion() + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + nodeId + ", res=" + res + ", fut=" + this + ']');
            }
            return;
        }
        MiniFuture mini = this.miniFuture(res.miniId());
        if (mini != null) {
            assert (mini.node().id().equals(nodeId));
            mini.onResult(res);
        } else if (msgLog.isDebugEnabled()) {
            msgLog.debug("DHT prepare fut, failed to find mini future [txId=" + this.tx.nearXidVersion() + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + nodeId + ", res=" + res + ", fut=" + this + ']');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MiniFuture miniFuture(IgniteUuid miniId) {
        Object object = this.sync;
        synchronized (object) {
            int size = this.futuresCountNoLock();
            for (int i = 0; i < size; ++i) {
                MiniFuture mini;
                IgniteInternalFuture fut = this.future(i);
                if (!this.isMini(fut) || !(mini = (MiniFuture)fut).futureId().equals(miniId)) continue;
                if (!mini.isDone()) {
                    return mini;
                }
                return null;
            }
        }
        return null;
    }

    private void readyLocks() {
        if (log.isDebugEnabled()) {
            log.debug("Marking all local candidates as ready: " + this);
        }
        this.readyLocks(this.writes);
        if (this.tx.serializable() && this.tx.optimistic()) {
            this.readyLocks(this.reads);
        }
        this.locksReady = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readyLocks(Iterable<IgniteTxEntry> checkEntries) {
        block5: for (IgniteTxEntry txEntry : checkEntries) {
            GridCacheContext<?, ?> cacheCtx = txEntry.context();
            if (cacheCtx.isLocal()) continue;
            GridDistributedCacheEntry entry = (GridDistributedCacheEntry)txEntry.cached();
            if (entry == null) {
                entry = (GridDistributedCacheEntry)cacheCtx.cache().entryEx(txEntry.key(), this.tx.topologyVersion());
                txEntry.cached(entry);
            }
            if (this.tx.optimistic() && txEntry.explicitVersion() == null) {
                Object object = this.sync;
                synchronized (object) {
                    this.lockKeys.add(txEntry.txKey());
                }
            }
            while (true) {
                try {
                    assert (txEntry.explicitVersion() == null || entry.lockedBy(txEntry.explicitVersion()));
                    CacheLockCandidates owners = entry.readyLock(this.tx.xidVersion());
                    if (!log.isDebugEnabled()) continue block5;
                    log.debug("Current lock owners for entry [owner=" + owners + ", entry=" + entry + ']');
                    continue block5;
                }
                catch (GridCacheEntryRemovedException ignored) {
                    if (log.isDebugEnabled()) {
                        log.debug("Got removed entry in future onAllReplies method (will retry): " + txEntry);
                    }
                    entry = (GridDistributedCacheEntry)cacheCtx.cache().entryEx(txEntry.key(), this.tx.topologyVersion());
                    txEntry.cached(entry);
                    continue;
                }
                break;
            }
        }
    }

    private boolean mapIfLocked() {
        if (this.checkLocks()) {
            if (!MAPPED_UPD.compareAndSet(this, 0, 1)) {
                return false;
            }
            if (this.forceKeysFut == null || this.forceKeysFut.isDone() && this.forceKeysFut.error() == null) {
                this.prepare0();
            } else {
                this.forceKeysFut.listen(new CI1<IgniteInternalFuture<?>>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void apply(IgniteInternalFuture<?> f) {
                        try {
                            f.get();
                            GridDhtTxPrepareFuture.this.prepare0();
                        }
                        catch (IgniteCheckedException e) {
                            GridDhtTxPrepareFuture.this.onError(e);
                        }
                        finally {
                            GridDhtTxPrepareFuture.this.cctx.txContextReset();
                        }
                    }
                });
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onDone(GridNearTxPrepareResponse res0, Throwable err) {
        assert (err != null || this.initialized() && !this.hasPending()) : "On done called for prepare future that has pending mini futures: " + this;
        ERR_UPD.compareAndSet(this, null, err);
        if (this.tx.optimistic()) {
            this.tx.clearPrepareFuture(this);
        }
        if (this.tx.onePhaseCommit() && this.tx.commitOnPrepare()) {
            assert (this.last);
            Throwable prepErr = this.err;
            final GridNearTxPrepareResponse res = this.createPrepareResponse(prepErr);
            this.onComplete(res);
            if (this.tx.commitOnPrepare()) {
                if (this.tx.markFinalizing(IgniteInternalTx.FinalizationStatus.USER_FINISH)) {
                    IgniteInternalFuture<IgniteInternalTx> fut = null;
                    CIX1<IgniteInternalFuture<IgniteInternalTx>> resClo = new CIX1<IgniteInternalFuture<IgniteInternalTx>>(){

                        @Override
                        public void applyx(IgniteInternalFuture<IgniteInternalTx> fut) {
                            try {
                                if (REPLIED_UPD.compareAndSet(GridDhtTxPrepareFuture.this, 0, 1)) {
                                    GridDhtTxPrepareFuture.this.sendPrepareResponse(res);
                                }
                            }
                            catch (IgniteCheckedException e) {
                                U.error(log, "Failed to send prepare response [txId=" + GridDhtTxPrepareFuture.this.tx.nearXidVersion() + "," + ", dhtTxId=" + GridDhtTxPrepareFuture.this.tx.xidVersion() + ", node=" + GridDhtTxPrepareFuture.this.tx.nearNodeId() + ", res=" + res, ", tx=" + GridDhtTxPrepareFuture.this.tx, e);
                            }
                        }
                    };
                    if (prepErr == null) {
                        try {
                            fut = this.tx.commitAsync();
                        }
                        catch (Error | RuntimeException e) {
                            IgniteTxHeuristicCheckedException hEx = new IgniteTxHeuristicCheckedException("Commit produced a runtime exception: " + CU.txString(this.tx), e);
                            res.error(hEx);
                            this.tx.systemInvalidate(true);
                            fut = this.tx.rollbackAsync();
                            fut.listen((IgniteInClosure<IgniteInternalFuture<IgniteInternalTx>>)resClo);
                            throw e;
                        }
                    } else if (!this.cctx.kernalContext().isStopping()) {
                        fut = this.tx.rollbackAsync();
                    }
                    if (fut != null) {
                        fut.listen((IgniteInClosure<IgniteInternalFuture<IgniteInternalTx>>)resClo);
                    }
                }
            } else {
                try {
                    if (REPLIED_UPD.compareAndSet(this, 0, 1)) {
                        this.sendPrepareResponse(res);
                    }
                }
                catch (IgniteCheckedException e) {
                    U.error(log, "Failed to send prepare response [txId=" + this.tx.nearXidVersion() + "," + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + this.tx.nearNodeId() + ", res=" + res, ", tx=" + this.tx, e);
                }
            }
            return true;
        }
        if (REPLIED_UPD.compareAndSet(this, 0, 1)) {
            GridNearTxPrepareResponse res = this.createPrepareResponse(this.err);
            try {
                this.sendPrepareResponse(res);
            }
            catch (IgniteCheckedException e) {
                U.error(log, "Failed to send prepare response [txId=" + this.tx.nearXidVersion() + "," + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + this.tx.nearNodeId() + ", res=" + res, ", tx=" + this.tx, e);
            }
            finally {
                this.onComplete(res);
            }
            return true;
        }
        try {
            if (err != null) {
                this.get();
            }
        }
        catch (IgniteInterruptedException e) {
            this.onError(new IgniteCheckedException("Got interrupted while waiting for replies to be sent.", e));
        }
        catch (IgniteCheckedException igniteCheckedException) {
            // empty catch block
        }
        return false;
    }

    private void sendPrepareResponse(GridNearTxPrepareResponse res) throws IgniteCheckedException {
        if (!this.tx.nearNodeId().equals(this.cctx.localNodeId())) {
            Throwable err = this.err;
            if (err != null && err instanceof IgniteFutureCancelledException) {
                if (msgLog.isDebugEnabled()) {
                    msgLog.debug("DHT prepare fut, skip send response [txId=" + this.tx.nearXidVersion() + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + this.tx.nearNodeId() + ", err=" + err + ", res=" + res + ']');
                }
                return;
            }
            this.cctx.io().send(this.tx.nearNodeId(), (GridCacheMessage)res, this.tx.ioPolicy());
            if (msgLog.isDebugEnabled()) {
                msgLog.debug("DHT prepare fut, sent response [txId=" + this.tx.nearXidVersion() + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + this.tx.nearNodeId() + ", res=" + res + ']');
            }
        }
    }

    private GridNearTxPrepareResponse createPrepareResponse(@Nullable Throwable prepErr) {
        assert (F.isEmpty(this.tx.invalidPartitions()));
        GridNearTxPrepareResponse res = new GridNearTxPrepareResponse(this.tx.nearXidVersion(), this.tx.colocated() ? this.tx.xid() : this.tx.nearFutureId(), this.nearMiniId == null ? this.tx.xid() : this.nearMiniId, this.tx.xidVersion(), this.tx.writeVersion(), this.ret, prepErr, null, this.tx.activeCachesDeploymentEnabled());
        if (prepErr == null) {
            if (this.tx.needReturnValue() || this.tx.nearOnOriginatingNode() || this.tx.hasInterceptor()) {
                this.addDhtValues(res);
            }
            GridCacheVersion min = this.tx.minVersion();
            if (this.tx.needsCompletedVersions()) {
                IgnitePair<Collection<GridCacheVersion>> versPair = this.cctx.tm().versions(min);
                res.completedVersions((Collection)versPair.get1(), (Collection)versPair.get2());
            }
            res.pending(this.localDhtPendingVersions(this.tx.writeEntries(), min));
            this.tx.implicitSingleResult(this.ret);
        }
        res.filterFailedKeys(this.filterFailedKeys);
        return res;
    }

    private void addDhtValues(GridNearTxPrepareResponse res) {
        CacheObject val0;
        GridCacheVersion dhtVer;
        GridCacheEntryEx entry;
        GridCacheContext<?, ?> cacheCtx;
        IgniteTxEntry txEntry;
        if (!F.isEmpty(this.writes)) {
            block4: for (IgniteTxEntry igniteTxEntry : this.writes) {
                txEntry = this.tx.entry(igniteTxEntry.txKey());
                assert (txEntry != null) : "Missing tx entry for key [tx=" + this.tx + ", key=" + igniteTxEntry.txKey() + ']';
                cacheCtx = txEntry.context();
                while (true) {
                    try {
                        entry = txEntry.cached();
                        dhtVer = entry.version();
                        val0 = entry.valueBytes();
                        if (val0 == null) continue block4;
                        res.addOwnedValue(txEntry.txKey(), dhtVer, val0);
                        continue block4;
                    }
                    catch (GridCacheEntryRemovedException ignored) {
                        txEntry.cached(cacheCtx.cache().entryEx(txEntry.key(), this.tx.topologyVersion()));
                        continue;
                    }
                    break;
                }
            }
        }
        block6: for (Map.Entry entry2 : this.dhtVerMap.entrySet()) {
            txEntry = this.tx.entry((IgniteTxKey)entry2.getKey());
            if (res.hasOwnedValue((IgniteTxKey)entry2.getKey())) continue;
            cacheCtx = txEntry.context();
            while (true) {
                try {
                    entry = txEntry.cached();
                    dhtVer = entry.version();
                    if (entry2.getValue() != null && ((GridCacheVersion)entry2.getValue()).equals(dhtVer)) continue block6;
                    val0 = entry.valueBytes();
                    res.addOwnedValue(txEntry.txKey(), dhtVer, val0);
                    continue block6;
                }
                catch (GridCacheEntryRemovedException ignored) {
                    txEntry.cached(cacheCtx.cache().entryEx(txEntry.key(), this.tx.topologyVersion()));
                    continue;
                }
                break;
            }
        }
    }

    private boolean isMini(IgniteInternalFuture<?> f) {
        return f.getClass().equals(MiniFuture.class);
    }

    private boolean onComplete(@Nullable GridNearTxPrepareResponse res) {
        if (this.last || this.tx.isSystemInvalidate()) {
            this.tx.state(TransactionState.PREPARED);
        }
        if (super.onDone(res, this.err)) {
            this.cctx.mvcc().removeMvccFuture(this);
            if (this.timeoutObj != null) {
                this.cctx.time().removeTimeoutObject(this.timeoutObj);
            }
            return true;
        }
        return false;
    }

    public void complete() {
        GridNearTxPrepareResponse res = new GridNearTxPrepareResponse();
        res.error(new IgniteCheckedException("Failed to prepare transaction."));
        this.onComplete(res);
    }

    public void prepare(Collection<IgniteTxEntry> reads, Collection<IgniteTxEntry> writes, Map<UUID, Collection<UUID>> txNodes) {
        boolean ser;
        if (this.tx.empty()) {
            this.tx.setRollbackOnly();
            this.onDone((GridNearTxPrepareResponse)null);
        }
        this.reads = reads;
        this.writes = writes;
        this.txNodes = txNodes;
        boolean bl = ser = this.tx.serializable() && this.tx.optimistic();
        if (!F.isEmpty(writes) || ser && !F.isEmpty(reads)) {
            Map<Integer, Collection<KeyCacheObject>> forceKeys = null;
            for (IgniteTxEntry entry : writes) {
                forceKeys = this.checkNeedRebalanceKeys(entry, forceKeys);
            }
            if (ser) {
                for (IgniteTxEntry entry : reads) {
                    forceKeys = this.checkNeedRebalanceKeys(entry, forceKeys);
                }
            }
            this.forceKeysFut = this.forceRebalanceKeys(forceKeys);
        }
        this.readyLocks();
        if (this.timeoutObj != null) {
            this.cctx.time().addTimeoutObject(this.timeoutObj);
        }
        this.mapIfLocked();
    }

    private Map<Integer, Collection<KeyCacheObject>> checkNeedRebalanceKeys(IgniteTxEntry e, Map<Integer, Collection<KeyCacheObject>> map) {
        if (this.retVal || !F.isEmpty(e.entryProcessors()) || !F.isEmpty(e.filters()) || e.entryReadVersion() != null) {
            Collection<KeyCacheObject> keys;
            if (map == null) {
                map = new HashMap<Integer, Collection<KeyCacheObject>>();
            }
            if ((keys = map.get(e.cacheId())) == null) {
                keys = new ArrayList<KeyCacheObject>();
                map.put(e.cacheId(), keys);
            }
            keys.add(e.key());
        }
        return map;
    }

    private IgniteInternalFuture<Object> forceRebalanceKeys(Map<Integer, Collection<KeyCacheObject>> keysMap) {
        if (F.isEmpty(keysMap)) {
            return null;
        }
        GridCompoundFuture compFut = null;
        IgniteInternalFuture<Object> lastForceFut = null;
        for (Map.Entry<Integer, Collection<KeyCacheObject>> entry : keysMap.entrySet()) {
            if (lastForceFut != null && compFut == null) {
                compFut = new GridCompoundFuture();
                compFut.add(lastForceFut);
            }
            int cacheId = entry.getKey();
            Collection<KeyCacheObject> keys = entry.getValue();
            lastForceFut = this.cctx.cacheContext(cacheId).preloader().request(keys, this.tx.topologyVersion());
            if (compFut == null || lastForceFut == null) continue;
            compFut.add(lastForceFut);
        }
        if (compFut != null) {
            compFut.markInitialized();
            return compFut;
        }
        return lastForceFut;
    }

    @Nullable
    private IgniteCheckedException checkReadConflict(Iterable<IgniteTxEntry> entries) throws IgniteCheckedException {
        block3: {
            try {
                for (IgniteTxEntry entry : entries) {
                    GridCacheVersion serReadVer = entry.entryReadVersion();
                    if (serReadVer == null) continue;
                    entry.cached().unswap();
                    if (entry.cached().checkSerializableReadVersion(serReadVer)) continue;
                    return this.versionCheckError(entry);
                }
            }
            catch (GridCacheEntryRemovedException ignore) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)("Got removed exception on entry with dht local candidate: " + entries));
            }
        }
        return null;
    }

    private IgniteTxOptimisticCheckedException versionCheckError(IgniteTxEntry entry) {
        GridCacheContext<?, ?> cctx = entry.context();
        return new IgniteTxOptimisticCheckedException("Failed to prepare transaction, read/write conflict [key=" + entry.key().value(cctx.cacheObjectContext(), false) + ", cache=" + cctx.name() + ']');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepare0() {
        try {
            if (this.tx.serializable() && this.tx.optimistic()) {
                IgniteCheckedException err0;
                try {
                    err0 = this.checkReadConflict(this.writes);
                    if (err0 == null) {
                        err0 = this.checkReadConflict(this.reads);
                    }
                }
                catch (IgniteCheckedException e) {
                    U.error(log, "Failed to check entry version: " + e, e);
                    err0 = e;
                }
                if (err0 != null) {
                    ERR_UPD.compareAndSet(this, null, err0);
                    this.tx.rollbackAsync();
                    GridNearTxPrepareResponse res = this.createPrepareResponse(this.err);
                    this.onDone(res, res.error());
                    return;
                }
            }
            this.onEntriesLocked();
            this.tx.writeVersion(this.cctx.versions().next(this.tx.topologyVersion()));
            if (!F.isEmpty(this.writes)) {
                for (IgniteTxEntry write : this.writes) {
                    this.map(this.tx.entry(write.txKey()));
                }
            }
            if (!F.isEmpty(this.reads)) {
                for (IgniteTxEntry read : this.reads) {
                    this.map(this.tx.entry(read.txKey()));
                }
            }
            if (this.isDone()) {
                return;
            }
            if (this.last) {
                assert (this.tx.transactionNodes() != null);
                long timeout = this.timeoutObj != null ? this.timeoutObj.timeout : 0L;
                for (GridDistributedTxMapping dhtMapping : this.tx.dhtMap().values()) {
                    assert (!dhtMapping.empty());
                    ClusterNode n = dhtMapping.node();
                    assert (!n.isLocal());
                    GridDistributedTxMapping nearMapping = this.tx.nearMap().get(n.id());
                    Collection<IgniteTxEntry> nearWrites = nearMapping == null ? null : nearMapping.writes();
                    Collection<IgniteTxEntry> dhtWrites = dhtMapping.writes();
                    if (F.isEmpty(dhtWrites) && F.isEmpty(nearWrites)) continue;
                    if (this.tx.remainingTime() == -1L) {
                        return;
                    }
                    MiniFuture fut = new MiniFuture(n.id(), dhtMapping, nearMapping);
                    this.add(fut);
                    assert (this.txNodes != null);
                    GridDhtTxPrepareRequest req = new GridDhtTxPrepareRequest(this.futId, fut.futureId(), this.tx.topologyVersion(), this.tx, timeout, dhtWrites, nearWrites, this.txNodes, this.tx.nearXidVersion(), true, this.tx.onePhaseCommit(), this.tx.subjectId(), this.tx.taskNameHash(), this.tx.activeCachesDeploymentEnabled(), this.retVal);
                    int idx = 0;
                    for (IgniteTxEntry entry : dhtWrites) {
                        try {
                            List<ClusterNode> owners;
                            GridDhtCacheEntry cached = (GridDhtCacheEntry)entry.cached();
                            GridCacheContext cacheCtx = cached.context();
                            req.invalidateNearEntry(idx, !this.tx.nearNodeId().equals(n.id()) && cached.readerId(n.id()) != null);
                            if (!cached.isNewLocked() || (owners = cacheCtx.topology().owners(cached.partition(), this.tx != null ? this.tx.topologyVersion() : cacheCtx.affinity().affinityTopologyVersion())).contains(this.cctx.localNode())) break;
                            req.markKeyForPreload(idx);
                            break;
                        }
                        catch (GridCacheEntryRemovedException ignore) {
                            assert (false) : "Got removed exception on entry with dht local candidate: " + entry;
                            ++idx;
                        }
                    }
                    if (!F.isEmpty(nearWrites)) {
                        for (IgniteTxEntry entry : nearWrites) {
                            try {
                                if (entry.explicitVersion() != null) break;
                                GridCacheMvccCandidate added = entry.cached().candidate(this.version());
                                assert (added != null) : "Missing candidate for cache entry:" + entry;
                                assert (added.dhtLocal());
                                if (added.ownerVersion() == null) break;
                                req.owned(entry.txKey(), added.ownerVersion());
                                break;
                            }
                            catch (GridCacheEntryRemovedException ignore) {
                                assert (false) : "Got removed exception on entry with dht local candidate: " + entry;
                            }
                        }
                    }
                    assert (req.transactionNodes() != null);
                    try {
                        this.cctx.io().send(n, (GridCacheMessage)req, this.tx.ioPolicy());
                        if (!msgLog.isDebugEnabled()) continue;
                        msgLog.debug("DHT prepare fut, sent request dht [txId=" + this.tx.nearXidVersion() + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + n.id() + ']');
                    }
                    catch (ClusterTopologyCheckedException ignored) {
                        fut.onNodeLeft();
                    }
                    catch (IgniteCheckedException e) {
                        if (!this.cctx.kernalContext().isStopping()) {
                            if (msgLog.isDebugEnabled()) {
                                msgLog.debug("DHT prepare fut, failed to send request dht [txId=" + this.tx.nearXidVersion() + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + n.id() + ']');
                            }
                            fut.onResult(e);
                            continue;
                        }
                        if (!msgLog.isDebugEnabled()) continue;
                        msgLog.debug("DHT prepare fut, failed to send request dht, ignore [txId=" + this.tx.nearXidVersion() + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + n.id() + ", err=" + e + ']');
                    }
                }
                for (GridDistributedTxMapping nearMapping : this.tx.nearMap().values()) {
                    if (this.tx.dhtMap().containsKey(nearMapping.node().id())) continue;
                    if (this.tx.remainingTime() == -1L) {
                        return;
                    }
                    MiniFuture fut = new MiniFuture(nearMapping.node().id(), null, nearMapping);
                    this.add(fut);
                    GridDhtTxPrepareRequest req = new GridDhtTxPrepareRequest(this.futId, fut.futureId(), this.tx.topologyVersion(), this.tx, timeout, null, nearMapping.writes(), this.tx.transactionNodes(), this.tx.nearXidVersion(), true, this.tx.onePhaseCommit(), this.tx.subjectId(), this.tx.taskNameHash(), this.tx.activeCachesDeploymentEnabled(), this.retVal);
                    for (IgniteTxEntry entry : nearMapping.entries()) {
                        if (!CU.writes().apply(entry)) continue;
                        try {
                            if (entry.explicitVersion() != null) break;
                            GridCacheMvccCandidate added = entry.cached().candidate(this.version());
                            assert (added != null) : "Null candidate for non-group-lock entry [added=" + added + ", entry=" + entry + ']';
                            assert (added.dhtLocal()) : "Got non-dht-local candidate for prepare future[added=" + added + ", entry=" + entry + ']';
                            if (added == null || added.ownerVersion() == null) break;
                            req.owned(entry.txKey(), added.ownerVersion());
                            break;
                        }
                        catch (GridCacheEntryRemovedException ignore) {
                            assert (false) : "Got removed exception on entry with dht local candidate: " + entry;
                        }
                    }
                    assert (req.transactionNodes() != null);
                    try {
                        this.cctx.io().send(nearMapping.node(), (GridCacheMessage)req, this.tx.ioPolicy());
                        if (!msgLog.isDebugEnabled()) continue;
                        msgLog.debug("DHT prepare fut, sent request near [txId=" + this.tx.nearXidVersion() + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + nearMapping.node().id() + ']');
                    }
                    catch (ClusterTopologyCheckedException ignored) {
                        fut.onNodeLeft();
                    }
                    catch (IgniteCheckedException e) {
                        if (!this.cctx.kernalContext().isStopping()) {
                            if (msgLog.isDebugEnabled()) {
                                msgLog.debug("DHT prepare fut, failed to send request near [txId=" + this.tx.nearXidVersion() + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + nearMapping.node().id() + ']');
                            }
                            fut.onResult(e);
                            continue;
                        }
                        if (!msgLog.isDebugEnabled()) continue;
                        msgLog.debug("DHT prepare fut, failed to send request near, ignore [txId=" + this.tx.nearXidVersion() + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + nearMapping.node().id() + ", err=" + e + ']');
                    }
                }
            }
        }
        finally {
            this.markInitialized();
        }
    }

    private void map(IgniteTxEntry entry) {
        if (entry.cached().isLocal()) {
            return;
        }
        GridDhtCacheEntry cached = (GridDhtCacheEntry)entry.cached();
        GridCacheContext<?, ?> cacheCtx = entry.context();
        GridDhtCacheAdapter<?, ?> dht = cacheCtx.isNear() ? cacheCtx.near().dht() : cacheCtx.dht();
        ExpiryPolicy expiry = cacheCtx.expiryForTxEntry(entry);
        if (expiry != null && (entry.op() == GridCacheOperation.READ || entry.op() == GridCacheOperation.NOOP)) {
            entry.op(GridCacheOperation.NOOP);
            entry.ttl(CU.toTtl(expiry.getExpiryForAccess()));
        }
        while (true) {
            try {
                List<ClusterNode> dhtNodes = dht.topology().nodes(cached.partition(), this.tx.topologyVersion());
                if (log.isDebugEnabled()) {
                    log.debug("Mapping entry to DHT nodes [nodes=" + U.toShortString(dhtNodes) + ", entry=" + entry + ']');
                }
                this.map(entry, F.view(dhtNodes, F.remoteNodes(this.cctx.localNodeId())), this.dhtMap);
                Collection<UUID> readers = cached.readers();
                if (!F.isEmpty(readers)) {
                    Collection<ClusterNode> nearNodes = this.cctx.discovery().nodes(readers, F0.not(F.idForNodeId(this.tx.nearNodeId())));
                    if (log.isDebugEnabled()) {
                        log.debug("Mapping entry to near nodes [nodes=" + U.toShortString(nearNodes) + ", entry=" + entry + ']');
                    }
                    this.map(entry, F.view(nearNodes, F0.notIn(dhtNodes)), this.nearMap);
                    break;
                }
                if (!log.isDebugEnabled()) break;
                log.debug("Entry has no near readers: " + entry);
            }
            catch (GridCacheEntryRemovedException ignore) {
                cached = dht.entryExx(entry.key(), this.tx.topologyVersion());
                entry.cached(cached);
                continue;
            }
            break;
        }
    }

    private void map(IgniteTxEntry entry, Iterable<ClusterNode> nodes, Map<UUID, GridDistributedTxMapping> globalMap) {
        if (nodes != null) {
            for (ClusterNode n : nodes) {
                GridDhtPartitionState state;
                GridDistributedTxMapping global = globalMap.get(n.id());
                if (!F.isEmpty(entry.entryProcessors()) && (state = entry.context().topology().partitionState(n.id(), entry.cached().partition())) != GridDhtPartitionState.OWNING && state != GridDhtPartitionState.EVICTED) {
                    T2<GridCacheOperation, CacheObject> procVal = entry.entryProcessorCalculatedValue();
                    assert (procVal != null) : entry;
                    entry.op((GridCacheOperation)((Object)procVal.get1()));
                    entry.value((CacheObject)procVal.get2(), true, false);
                    entry.entryProcessors(null);
                }
                if (global == null) {
                    global = new GridDistributedTxMapping(n);
                    globalMap.put(n.id(), global);
                }
                global.add(entry);
            }
        }
    }

    private Collection<GridCacheVersion> localDhtPendingVersions(Iterable<IgniteTxEntry> entries, GridCacheVersion baseVer) {
        GridLeanSet<GridCacheVersion> lessPending = new GridLeanSet<GridCacheVersion>(5);
        for (IgniteTxEntry entry : entries) {
            try {
                for (GridCacheMvccCandidate cand : entry.cached().localCandidates(new GridCacheVersion[0])) {
                    if (!cand.version().isLess(baseVer)) continue;
                    lessPending.add(cand.version());
                }
            }
            catch (GridCacheEntryRemovedException gridCacheEntryRemovedException) {
            }
        }
        return lessPending;
    }

    @Override
    public String toString() {
        Collection futs = F.viewReadOnly(this.futures(), new C1<IgniteInternalFuture<?>, String>(){

            @Override
            public String apply(IgniteInternalFuture<?> f) {
                return "[node=" + ((MiniFuture)f).node().id() + ", loc=" + ((MiniFuture)f).node().isLocal() + ", done=" + f.isDone() + "]";
            }
        }, new IgnitePredicate[0]);
        return S.toString(GridDhtTxPrepareFuture.class, this, "xid", (Object)this.tx.xidVersion(), "innerFuts", futs, "super", super.toString());
    }

    private class PrepareTimeoutObject
    extends GridTimeoutObjectAdapter {
        private final long timeout;

        PrepareTimeoutObject(long timeout) {
            super(timeout);
            this.timeout = timeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTimeout() {
            Object object = GridDhtTxPrepareFuture.this.sync;
            synchronized (object) {
                GridDhtTxPrepareFuture.this.clear();
                GridDhtTxPrepareFuture.this.lockKeys.clear();
            }
            GridDhtTxPrepareFuture.this.onError(new IgniteTxTimeoutCheckedException("Failed to acquire lock within provided timeout for transaction [timeout=" + GridDhtTxPrepareFuture.this.tx.timeout() + ", tx=" + GridDhtTxPrepareFuture.this.tx + ']'));
        }

        public String toString() {
            return S.toString(PrepareTimeoutObject.class, this);
        }
    }

    private class MiniFuture
    extends GridFutureAdapter<IgniteInternalTx> {
        private static final long serialVersionUID = 0L;
        private final IgniteUuid futId = IgniteUuid.randomUuid();
        private UUID nodeId;
        @GridToStringInclude
        private GridDistributedTxMapping dhtMapping;
        @GridToStringInclude
        private GridDistributedTxMapping nearMapping;

        MiniFuture(UUID nodeId, GridDistributedTxMapping dhtMapping, GridDistributedTxMapping nearMapping) {
            assert (dhtMapping == null || nearMapping == null || dhtMapping.node().equals(nearMapping.node()));
            this.nodeId = nodeId;
            this.dhtMapping = dhtMapping;
            this.nearMapping = nearMapping;
        }

        IgniteUuid futureId() {
            return this.futId;
        }

        public ClusterNode node() {
            return this.dhtMapping != null ? this.dhtMapping.node() : this.nearMapping.node();
        }

        void onResult(Throwable e) {
            if (log.isDebugEnabled()) {
                log.debug("Failed to get future result [fut=" + this + ", err=" + e + ']');
            }
            this.onDone(e);
        }

        void onNodeLeft() {
            if (msgLog.isDebugEnabled()) {
                msgLog.debug("DHT prepare fut, mini future node left [txId=" + GridDhtTxPrepareFuture.this.tx.nearXidVersion() + ", dhtTxId=" + GridDhtTxPrepareFuture.this.tx.xidVersion() + ", node=" + this.node().id() + ']');
            }
            if (GridDhtTxPrepareFuture.this.tx != null) {
                GridDhtTxPrepareFuture.this.tx.removeMapping(this.nodeId);
            }
            this.onDone(GridDhtTxPrepareFuture.this.tx);
        }

        void onResult(GridDhtTxPrepareResponse res) {
            if (res.error() != null) {
                GridDhtTxPrepareFuture.this.onError(res.error());
            } else {
                if (this.nearMapping != null && !F.isEmpty(res.nearEvicted())) {
                    block5: for (IgniteTxEntry entry : this.nearMapping.entries()) {
                        if (!res.nearEvicted().contains(entry.txKey())) continue;
                        while (true) {
                            try {
                                GridDhtCacheEntry cached = (GridDhtCacheEntry)entry.cached();
                                cached.removeReader(this.nearMapping.node().id(), res.messageId());
                                continue block5;
                            }
                            catch (GridCacheEntryRemovedException ignore) {
                                GridCacheEntryEx e = entry.context().cache().peekEx(entry.key());
                                if (e == null) continue block5;
                                entry.cached(e);
                                continue;
                            }
                            break;
                        }
                    }
                    this.nearMapping.evictReaders(res.nearEvicted());
                }
                if (!F.isEmpty(res.invalidPartitions())) {
                    Iterator<IgniteTxEntry> it = this.dhtMapping.entries().iterator();
                    while (it.hasNext()) {
                        IgniteTxEntry entry;
                        entry = it.next();
                        if (!res.invalidPartitions().contains(entry.cached().partition())) continue;
                        it.remove();
                        if (!log.isDebugEnabled()) continue;
                        log.debug("Removed mapping for entry from dht mapping [key=" + entry.key() + ", tx=" + GridDhtTxPrepareFuture.this.tx + ", dhtMapping=" + this.dhtMapping + ']');
                    }
                }
                if (!F.isEmpty(res.invalidPartitionsByCacheId())) {
                    Map<Integer, int[]> invalidPartsMap = res.invalidPartitionsByCacheId();
                    Iterator<IgniteTxEntry> it = this.dhtMapping.entries().iterator();
                    while (it.hasNext()) {
                        IgniteTxEntry entry = it.next();
                        int[] invalidParts = invalidPartsMap.get(entry.cacheId());
                        if (invalidParts == null || !F.contains(invalidParts, entry.cached().partition())) continue;
                        it.remove();
                        if (!log.isDebugEnabled()) continue;
                        log.debug("Removed mapping for entry from dht mapping [key=" + entry.key() + ", tx=" + GridDhtTxPrepareFuture.this.tx + ", dhtMapping=" + this.dhtMapping + ']');
                    }
                    if (this.dhtMapping.empty()) {
                        GridDhtTxPrepareFuture.this.dhtMap.remove(this.nodeId);
                        if (log.isDebugEnabled()) {
                            log.debug("Removed mapping for node entirely because all partitions are invalid [nodeId=" + this.nodeId + ", tx=" + GridDhtTxPrepareFuture.this.tx + ']');
                        }
                    }
                }
                AffinityTopologyVersion topVer = GridDhtTxPrepareFuture.this.tx.topologyVersion();
                boolean rec = GridDhtTxPrepareFuture.this.cctx.gridEvents().isRecordable(84);
                block9: for (GridCacheEntryInfo info : res.preloadEntries()) {
                    GridCacheContext cacheCtx = GridDhtTxPrepareFuture.this.cctx.cacheContext(info.cacheId());
                    while (true) {
                        GridCacheEntryEx entry = cacheCtx.cache().entryEx(info.key());
                        GridDrType drType = cacheCtx.isDrEnabled() ? GridDrType.DR_PRELOAD : GridDrType.DR_NONE;
                        try {
                            if (!entry.initialValue(info.value(), info.version(), info.ttl(), info.expireTime(), true, topVer, drType, false)) continue block9;
                            if (rec && !entry.isInternal()) {
                                cacheCtx.events().addEvent(entry.partition(), entry.key(), GridDhtTxPrepareFuture.this.cctx.localNodeId(), (IgniteUuid)null, null, 84, info.value(), true, null, false, null, null, null, false);
                            }
                            if (!GridDhtTxPrepareFuture.this.retVal || GridDhtTxPrepareFuture.this.invoke) continue block9;
                            GridDhtTxPrepareFuture.this.ret.value(cacheCtx, info.value(), false);
                            continue block9;
                        }
                        catch (IgniteCheckedException e) {
                            this.onDone(e);
                            return;
                        }
                        catch (GridCacheEntryRemovedException ignore) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug("Failed to set entry initial value (entry is obsolete, will retry): " + entry);
                            continue;
                        }
                        break;
                    }
                }
                this.onDone(GridDhtTxPrepareFuture.this.tx);
            }
        }

        @Override
        public String toString() {
            return S.toString(MiniFuture.class, this, "done", (Object)this.isDone(), "cancelled", this.isCancelled(), "err", this.error());
        }
    }
}

