/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxPrepareRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxLocalAdapter;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.GridLeanMap;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

public class GridDhtTxPrepareRequest
extends GridDistributedTxPrepareRequest {
    private static final long serialVersionUID = 0L;
    public static final int NEED_RETURN_VALUE_FLAG_MASK = 1;
    private UUID nearNodeId;
    private IgniteUuid futId;
    private IgniteUuid miniId;
    private AffinityTopologyVersion topVer;
    private BitSet invalidateNearEntries;
    @GridToStringInclude
    @GridDirectCollection(value=IgniteTxEntry.class)
    private Collection<IgniteTxEntry> nearWrites;
    @GridToStringInclude
    @GridDirectTransient
    private Map<IgniteTxKey, GridCacheVersion> owned;
    @GridDirectCollection(value=IgniteTxKey.class)
    private Collection<IgniteTxKey> ownedKeys;
    @GridDirectCollection(value=GridCacheVersion.class)
    private Collection<GridCacheVersion> ownedVals;
    private GridCacheVersion nearXidVer;
    private boolean last;
    private UUID subjId;
    private int taskNameHash;
    private BitSet preloadKeys;
    private byte flags;

    public GridDhtTxPrepareRequest() {
    }

    public GridDhtTxPrepareRequest(IgniteUuid futId, IgniteUuid miniId, AffinityTopologyVersion topVer, GridDhtTxLocalAdapter tx, long timeout, Collection<IgniteTxEntry> dhtWrites, Collection<IgniteTxEntry> nearWrites, Map<UUID, Collection<UUID>> txNodes, GridCacheVersion nearXidVer, boolean last, boolean onePhaseCommit, UUID subjId, int taskNameHash, boolean addDepInfo, boolean retVal) {
        super(tx, timeout, null, dhtWrites, txNodes, onePhaseCommit, addDepInfo);
        assert (futId != null);
        assert (miniId != null);
        this.topVer = topVer;
        this.futId = futId;
        this.nearWrites = nearWrites;
        this.miniId = miniId;
        this.nearXidVer = nearXidVer;
        this.last = last;
        this.subjId = subjId;
        this.taskNameHash = taskNameHash;
        this.needReturnValue(retVal);
        this.invalidateNearEntries = new BitSet(dhtWrites == null ? 0 : dhtWrites.size());
        this.nearNodeId = tx.nearNodeId();
    }

    public boolean needReturnValue() {
        return (this.flags & 1) != 0;
    }

    public void needReturnValue(boolean retVal) {
        this.flags = retVal ? (byte)(this.flags | 1) : (byte)(this.flags & 0xFFFFFFFE);
    }

    public boolean last() {
        return this.last;
    }

    public GridCacheVersion nearXidVersion() {
        return this.nearXidVer;
    }

    public UUID nearNodeId() {
        return this.nearNodeId;
    }

    @Nullable
    public UUID subjectId() {
        return this.subjId;
    }

    public int taskNameHash() {
        return this.taskNameHash;
    }

    public Collection<IgniteTxEntry> nearWrites() {
        return this.nearWrites == null ? Collections.emptyList() : this.nearWrites;
    }

    public void invalidateNearEntry(int idx, boolean invalidate) {
        this.invalidateNearEntries.set(idx, invalidate);
    }

    public boolean invalidateNearEntry(int idx) {
        return this.invalidateNearEntries.get(idx);
    }

    public void markKeyForPreload(int idx) {
        if (this.preloadKeys == null) {
            this.preloadKeys = new BitSet();
        }
        this.preloadKeys.set(idx, true);
    }

    public boolean needPreloadKey(int idx) {
        return this.preloadKeys != null && this.preloadKeys.get(idx);
    }

    public IgniteUuid futureId() {
        return this.futId;
    }

    public IgniteUuid miniId() {
        return this.miniId;
    }

    @Override
    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    public void owned(IgniteTxKey key, GridCacheVersion ownerMapped) {
        if (this.owned == null) {
            this.owned = new GridLeanMap<IgniteTxKey, GridCacheVersion>(3);
        }
        this.owned.put(key, ownerMapped);
    }

    public Map<IgniteTxKey, GridCacheVersion> owned() {
        return this.owned;
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        if (this.owned != null && this.ownedKeys == null) {
            this.ownedKeys = this.owned.keySet();
            this.ownedVals = this.owned.values();
            for (IgniteTxKey key : this.ownedKeys) {
                GridCacheContext cctx = ctx.cacheContext(key.cacheId());
                key.prepareMarshal(cctx);
                if (!this.addDepInfo) continue;
                this.prepareObject(key, cctx);
            }
        }
        if (this.nearWrites != null) {
            this.marshalTx(this.nearWrites, ctx);
        }
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        if (this.ownedKeys != null) {
            assert (this.ownedKeys.size() == this.ownedVals.size());
            this.owned = U.newHashMap(this.ownedKeys.size());
            Iterator<IgniteTxKey> keyIter = this.ownedKeys.iterator();
            Iterator<GridCacheVersion> valIter = this.ownedVals.iterator();
            while (keyIter.hasNext()) {
                IgniteTxKey key = keyIter.next();
                key.finishUnmarshal(ctx.cacheContext(key.cacheId()), ldr);
                this.owned.put(key, valIter.next());
            }
        }
        this.unmarshalTx(this.nearWrites, true, ctx, ldr);
    }

    @Override
    public String toString() {
        return S.toString(GridDhtTxPrepareRequest.class, this, "super", super.toString());
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 23: {
                if (!writer.writeByte("flags", this.flags)) {
                    return false;
                }
                writer.incrementState();
            }
            case 24: {
                if (!writer.writeIgniteUuid("futId", this.futId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 25: {
                if (!writer.writeBitSet("invalidateNearEntries", this.invalidateNearEntries)) {
                    return false;
                }
                writer.incrementState();
            }
            case 26: {
                if (!writer.writeBoolean("last", this.last)) {
                    return false;
                }
                writer.incrementState();
            }
            case 27: {
                if (!writer.writeIgniteUuid("miniId", this.miniId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 28: {
                if (!writer.writeUuid("nearNodeId", this.nearNodeId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 29: {
                if (!writer.writeCollection("nearWrites", this.nearWrites, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 30: {
                if (!writer.writeMessage("nearXidVer", this.nearXidVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 31: {
                if (!writer.writeCollection("ownedKeys", this.ownedKeys, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 32: {
                if (!writer.writeCollection("ownedVals", this.ownedVals, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 33: {
                if (!writer.writeBitSet("preloadKeys", this.preloadKeys)) {
                    return false;
                }
                writer.incrementState();
            }
            case 34: {
                if (!writer.writeUuid("subjId", this.subjId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 35: {
                if (!writer.writeInt("taskNameHash", this.taskNameHash)) {
                    return false;
                }
                writer.incrementState();
            }
            case 36: {
                if (!writer.writeMessage("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 23: {
                this.flags = reader.readByte("flags");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 24: {
                this.futId = reader.readIgniteUuid("futId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 25: {
                this.invalidateNearEntries = reader.readBitSet("invalidateNearEntries");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 26: {
                this.last = reader.readBoolean("last");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 27: {
                this.miniId = reader.readIgniteUuid("miniId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 28: {
                this.nearNodeId = reader.readUuid("nearNodeId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 29: {
                this.nearWrites = reader.readCollection("nearWrites", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 30: {
                this.nearXidVer = (GridCacheVersion)reader.readMessage("nearXidVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 31: {
                this.ownedKeys = reader.readCollection("ownedKeys", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 32: {
                this.ownedVals = reader.readCollection("ownedVals", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 33: {
                this.preloadKeys = reader.readBitSet("preloadKeys");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 34: {
                this.subjId = reader.readUuid("subjId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 35: {
                this.taskNameHash = reader.readInt("taskNameHash");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 36: {
                this.topVer = (AffinityTopologyVersion)reader.readMessage("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDhtTxPrepareRequest.class);
    }

    @Override
    public byte directType() {
        return 34;
    }

    @Override
    public byte fieldsCount() {
        return 37;
    }
}

