/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.GridDirectMap;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxPrepareResponse;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class GridDhtTxPrepareResponse
extends GridDistributedTxPrepareResponse {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    @GridDirectCollection(value=IgniteTxKey.class)
    private Collection<IgniteTxKey> nearEvicted;
    private IgniteUuid futId;
    private IgniteUuid miniId;
    @GridToStringInclude
    @GridDirectCollection(value=int.class)
    private Collection<Integer> invalidParts;
    @GridDirectMap(keyType=Integer.class, valueType=int[].class)
    private Map<Integer, int[]> invalidPartsByCacheId;
    @GridDirectCollection(value=GridCacheEntryInfo.class)
    private List<GridCacheEntryInfo> preloadEntries;

    public GridDhtTxPrepareResponse() {
    }

    public GridDhtTxPrepareResponse(GridCacheVersion xid, IgniteUuid futId, IgniteUuid miniId, boolean addDepInfo) {
        super(xid, addDepInfo);
        assert (futId != null);
        assert (miniId != null);
        this.futId = futId;
        this.miniId = miniId;
    }

    public GridDhtTxPrepareResponse(GridCacheVersion xid, IgniteUuid futId, IgniteUuid miniId, Throwable err, boolean addDepInfo) {
        super(xid, err, addDepInfo);
        assert (futId != null);
        assert (miniId != null);
        this.futId = futId;
        this.miniId = miniId;
    }

    public Collection<IgniteTxKey> nearEvicted() {
        return this.nearEvicted;
    }

    public void nearEvicted(Collection<IgniteTxKey> nearEvicted) {
        this.nearEvicted = nearEvicted;
    }

    public IgniteUuid futureId() {
        return this.futId;
    }

    public IgniteUuid miniId() {
        return this.miniId;
    }

    public Collection<Integer> invalidPartitions() {
        return this.invalidParts;
    }

    public void invalidPartitions(Collection<Integer> invalidParts) {
        this.invalidParts = invalidParts;
    }

    public Map<Integer, int[]> invalidPartitionsByCacheId() {
        return this.invalidPartsByCacheId;
    }

    public void invalidPartitionsByCacheId(Map<Integer, Set<Integer>> invalidPartsByCacheId) {
        this.invalidPartsByCacheId = CU.convertInvalidPartitions(invalidPartsByCacheId);
    }

    public Collection<GridCacheEntryInfo> preloadEntries() {
        return this.preloadEntries == null ? Collections.emptyList() : this.preloadEntries;
    }

    public void addPreloadEntry(GridCacheEntryInfo info) {
        assert (info.cacheId() != 0);
        if (this.preloadEntries == null) {
            this.preloadEntries = new ArrayList<GridCacheEntryInfo>();
        }
        this.preloadEntries.add(info);
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        GridCacheContext cctx;
        super.prepareMarshal(ctx);
        if (this.nearEvicted != null) {
            for (IgniteTxKey key : this.nearEvicted) {
                cctx = ctx.cacheContext(key.cacheId());
                key.prepareMarshal(cctx);
            }
        }
        if (this.preloadEntries != null) {
            for (GridCacheEntryInfo info : this.preloadEntries) {
                cctx = ctx.cacheContext(info.cacheId());
                info.marshal(cctx);
            }
        }
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        GridCacheContext cctx;
        super.finishUnmarshal(ctx, ldr);
        if (this.nearEvicted != null) {
            for (IgniteTxKey key : this.nearEvicted) {
                cctx = ctx.cacheContext(key.cacheId());
                key.finishUnmarshal(cctx, ldr);
            }
        }
        if (this.preloadEntries != null) {
            for (GridCacheEntryInfo info : this.preloadEntries) {
                cctx = ctx.cacheContext(info.cacheId());
                info.unmarshal(cctx, ldr);
            }
        }
    }

    @Override
    public String toString() {
        return S.toString(GridDhtTxPrepareResponse.class, this, "super", super.toString());
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 8: {
                if (!writer.writeIgniteUuid("futId", this.futId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                if (!writer.writeCollection("invalidParts", this.invalidParts, MessageCollectionItemType.INT)) {
                    return false;
                }
                writer.incrementState();
            }
            case 10: {
                if (!writer.writeMap("invalidPartsByCacheId", this.invalidPartsByCacheId, MessageCollectionItemType.INT, MessageCollectionItemType.INT_ARR)) {
                    return false;
                }
                writer.incrementState();
            }
            case 11: {
                if (!writer.writeIgniteUuid("miniId", this.miniId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 12: {
                if (!writer.writeCollection("nearEvicted", this.nearEvicted, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 13: {
                if (!writer.writeCollection("preloadEntries", this.preloadEntries, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 8: {
                this.futId = reader.readIgniteUuid("futId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 9: {
                this.invalidParts = reader.readCollection("invalidParts", MessageCollectionItemType.INT);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 10: {
                this.invalidPartsByCacheId = reader.readMap("invalidPartsByCacheId", MessageCollectionItemType.INT, MessageCollectionItemType.INT_ARR, false);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 11: {
                this.miniId = reader.readIgniteUuid("miniId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 12: {
                this.nearEvicted = reader.readCollection("nearEvicted", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 13: {
                this.preloadEntries = (List)reader.readCollection("preloadEntries", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDhtTxPrepareResponse.class);
    }

    @Override
    public byte directType() {
        return 35;
    }

    @Override
    public byte fieldsCount() {
        return 14;
    }
}

