/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedUnlockRequest;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class GridDhtUnlockRequest
extends GridDistributedUnlockRequest {
    private static final long serialVersionUID = 0L;
    @GridDirectCollection(value=KeyCacheObject.class)
    private List<KeyCacheObject> nearKeys;

    public GridDhtUnlockRequest() {
    }

    public GridDhtUnlockRequest(int cacheId, int dhtCnt, boolean addDepInfo) {
        super(cacheId, dhtCnt, addDepInfo);
    }

    public List<KeyCacheObject> nearKeys() {
        return this.nearKeys;
    }

    public void addNearKey(KeyCacheObject key) throws IgniteCheckedException {
        if (this.nearKeys == null) {
            this.nearKeys = new ArrayList<KeyCacheObject>();
        }
        this.nearKeys.add(key);
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        this.prepareMarshalCacheObjects(this.nearKeys, ctx.cacheContext(this.cacheId));
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        this.finishUnmarshalCacheObjects(this.nearKeys, ctx.cacheContext(this.cacheId), ldr);
    }

    @Override
    public String toString() {
        return S.toString(GridDhtUnlockRequest.class, this);
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 8: {
                if (!writer.writeCollection("nearKeys", this.nearKeys, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                if (!writer.writeCollection("partIds", this.partIds, MessageCollectionItemType.INT)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 8: {
                this.nearKeys = (List)reader.readCollection("nearKeys", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 9: {
                this.partIds = (List)reader.readCollection("partIds", MessageCollectionItemType.INT);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDhtUnlockRequest.class);
    }

    @Override
    public byte directType() {
        return 36;
    }

    @Override
    public byte fieldsCount() {
        return 10;
    }
}

